<?php defined('BASEPATH') || exit('No direct script access allowed');
/**
 * Admin Controller
 *
 * This class provides a base class for all admin-facing controllers.
 * It automatically loads the form, form_validation and pagination
 * helpers/libraries, sets defaults for pagination and sets our
 * Admin Theme.
 *
 * @package    Bonfire
 * @subpackage MY_Controller
 * @category   Controllers
 * @author     Bonfire Dev Team
 * @link       http://guides.cibonfire.com/helpers/file_helpers.html
 *
 */
class Admin_Controller extends Access_Control
{
    /**
     * Class constructor - setup paging and keyboard shortcuts as well as
     * load various libraries
     *
     */
    protected $acoes;
    
    public function __construct() 
    {
        parent::__construct();
        
        $this->valida_sessao();

        //$data['profile'] = $this->get_dados_profile();
        
        if(base_url() == "https://comdono.com/"){
            if($this->uri->segment(2) != 'autenticacao'){
                if($this->session->secret_google == ''){
                    redirect('/auth/autenticacao/primeira_autenticacao');
                }
                if($this->session->dois_fatores != TRUE){
                    redirect('/auth/autenticacao');
                }
            }
        }
        
        $this->load->library('menu_lib');
        //$this->load->helper('comdono/comdono');
        //$this->load->helper('incorporadora/incorporadora');
        //$this->load->library('notificacoes/toolbar');
        //$this->load->helper('notificacoes/notificacoes');
        //$this->load->helper('top_bar');
        
        //$data = ini_top_bar();
        
        //$data['userdata'] = $this->get_dados_theme();
        
        
        
        //Template::set($data);
    }
    
    private function get_dados_profile() 
    {
        $profile = $this->session->all_userdata();
        
        if($profile['perfil'] != 1)
            redirect(base_url('minha_conta'));
        
        $this->load->model('sistema/configuracoes_model');
    	$result = $this->configuracoes_model->get_profile($profile['user_id']);
    	
    	if($result != NULL)
    	{
    	    return $result;
    	}
    	else
    	{
    	    return NULL;
    	}
    }
    
    
    protected function breadcrumb($nome = null, $uri = null) 
    {
        if($nome == null){
            $uris = $this->uri->segment_array();
            $nome = end($uris);
        }
        
        $nome = ucfirst($nome);
        
        if($uri == null)
            Menu_lib::setBreadcrumb([$this->uri->uri_string(), $nome]);
        else
            Menu_lib::setBreadcrumb([$this->uriModuleClass.$uri, $nome]);
        
        return $this;
    }
    
    protected function ini_method($method = NULL, $action = NULL, $permission = FALSE) 
    {
        if ($method != NULL) 
        {
            $this->set_method($method);
        }
        
        $access = TRUE;
        
        $module = $this->get_module();
        
        if ($module !== NULL && $module->active == 1) 
        {
            define('MENU', $module->id_module);
            define('TITLE_MODULE', $module->name);
            
            $result = $this->get_section_permissions($module);
            
            if ($result === FALSE) 
            {
                $access = FALSE;
            } 
            elseif ($result === NULL) 
            {
                $access = $this->get_subsection_permissions($module);
            } 
            else
            {
                $access = $result;
            }
        } 
        else
        {
            $access = FALSE;
        }
        
        if ($permission === TRUE) 
        {
            $access = TRUE;
        } 
        else
        {
            if ($access === FALSE) 
            {
                redirect('painel/acesso_restrito');
            } 
            else
            {
                $this->set_acoes($access['permissions']);
                $this->load_modulo_menu($module, $access);
                $this->session->set_flashdata('menu_active',$access['result']);
            }
            
            if ($action != NULL && (!in_array($action, $this->acoes))) 
            {
                redirect('painel/acesso_restrito');
            }
        }
        return $this;
    }
    
    
    private function get_dados_theme() 
    {
        $userdata = $this->session->all_userdata();
        $tratar_nome = explode(' ', $userdata['nome']);
        $userdata['nome_abreviado'] = (count($tratar_nome) > 1) ? $tratar_nome[0] . ' ' . $tratar_nome[count($tratar_nome) - 1] : $tratar_nome[0];
        $userdata['perfil_name'] = $this->get_perfil_name($userdata['perfil']);
        return $userdata;
    }
    
    private function get_perfil_name($id_perfil) 
    {
        $this->load->model('sistema/usuario_model');
        $perfil = $this->usuario_model->get_perfil_name_by_id($id_perfil);
        return $perfil;
    }
    
    private function set_acoes($array) 
    {
        $array_acoes = array();
        foreach ($array as $acao) 
        {
            $array_acoes[] = $acao->id_action;
        }
        $this->acoes = $array_acoes;
    }
    
    public function valida_acao($id_action) 
    {
        if (in_array($id_action, $this->acoes)) 
        {
            return true;
        } 
        else
        {
            return false;
        }
    }
    
    private function load_modulo_menu($module, $access) 
    {
        $result = $this->menu_lib->generate_modulo_menu($module->id_module, $access);
        Template::set('modulo_menu', $result);
    }
    
    
    
    
    
    
    
    
    
    
    
}
/* End of file Admin_Controller.php */