<?php (defined('BASEPATH')) OR exit('No direct script access allowed');

class Builder_Controller extends Login_Facebook
{
    protected $meuCadastro;
    protected $perfil;
    protected $module;
    protected $class;
    protected $method;
    
    public function __construct() 
    {
        parent::__construct();
        
        if(base_url() == "https://dev.comdono.com/" && $this->session->dev_admin != true){
            //redirect('https://comdono.com/');
        }
        
        $this->load->library('template');
        $this->load->library('assets');
        $this->load->library('events');
        $this->load->library('auth/Tank_auth');
        
        $instance = parent::get_instance();
        $this->perfil = $this->session->userdata('perfil');
        $this->module = $instance->router->fetch_module();
        $this->class = $instance->router->fetch_class();
        $this->method = $instance->router->fetch_method();
        
        $this->load->helper('cookie');
        $this->load->helper('comdono/comdono');
        $this->load->helper('minha_conta/minha_conta');
        
        $this->load->model('comdono/busca_model');
        
		$this->load->library('newsletter/newsletter');
        $this->load->library('comdono/notification');
        
        $this->config->load('module', FALSE, TRUE);
        
        $this->builder_ini();
        
        $this->aceita_cookie();
        //$this->set_http_referer();
    }
    
    public function logado()
    {
        return $this->tank_auth->is_logged_in();
    }
    
    function aceita_cookie(){
        
        //delete_cookie('aceita_cookie'); 
        //var_dump(get_cookie('aceita_cookie'));
        
        if((get_cookie('aceita_cookie')??'') != 'aceito'){
            
            Assets::add_module_css('comdono', array(
                'cookie'
            ));
            Assets::add_module_js('comdono', array(
                'cookie'
            ));
            Template::set_modal([],[
                'comdono/cookie/cookie_view'
            ]);
            
            //set_cookie('cookie_primeiravez','primeiro',time() + (10 * 365 * 24 * 60 * 60));
            //redirect('apresentacao');
        }
    }
    
    
    private function builder_ini() 
    {
        setlocale(LC_ALL, 'pt_BR', 'pt_BR.utf-8', 'pt_BR.utf-8', 'portuguese');
        
        $theme  = $this->config->item('theme');
        $module = $this->config->item('theme.module');
        $header = $this->config->item('theme.header');
        $footer = $this->config->item('theme.footer');
        $css = $this->config->item('theme.css');
        $js = $this->config->item('theme.js');
        
        Assets::add_module_js('comdono', array(
            'wsConection',
            'main'
        ));
        
        $this->set_http_referer();
        $data['get_http_referer'] = $this->get_http_referer();
        
        $data['body']['class'] = 'autocomplete-responsive';
        $data['logado'] = $this->logado();
        $data["notficacoes"] = [];
        $data['active'] = "";
        if($this->module == "comdono" && $this->class == 'busca' && $this->method == 'index')
            $data['active'] = "ofertas";
       
        if($this->module == "minha_conta")
            $data['active'] = "minha_conta";
        
        
        $data['linkMenuChat'] = base_url('login');
        
        if($data['logado'] == true)
        { 
            $data["notficacoes"] = Notification::getAll();
            $this->meuCadastro = $this->cad_model->get_cadastro();
            
            if($this->meuCadastro->etapa == 1){
                $data["menu_home"] = false;
                $data["footer_home"] = false;
            }
            $negVendas = $this->cad_model->getNegocDono();
            $negCompras = $this->cad_model->getNegocInteressado();
            if(count($negVendas)>0){
                $data['linkMenuChat'] = base_url('minha_conta/minhas_vendas/negociacoes/'.$negVendas[0]->id_imovel.'/'.$negVendas[0]->id_chat);
            }
            elseif (count($negCompras)>0) {
                $data['linkMenuChat'] = base_url('minha_conta/minhas_compras/negociacoes/'.$negCompras[0]->id_imovel.'/'.$negCompras[0]->id_chat);
            }
            else{
                $data['linkMenuChat'] = base_url('minha-conta');
            }
            
            if(
                ($this->module == "comdono" && $this->class == 'cadastro' && ($this->method == 'imovel' || $this->method == 'preview')) ||
                //($this->module == "minha_conta" && $this->class == 'minhas_vendas' && $this->method == 'edit')
                ($this->module == "minha_conta" && $this->class == 'minhas_vendas' && in_array($this->method, ['edit','edit_lancamento','edit_unidade']))
            ){
                $data["menu_cad_imovel"] = false; 
            }
            
            
            $data['cadastro_user'] = $this->meuCadastro;
            
            //var_dump($data['cadastro_user']);
            
            //$data['first_name'] = explode(" ", $this->meuCadastro->nome)[0]; 
            
            $str = explode(" ", $this->meuCadastro->nome)[0]; 
            if(strlen($str) >= 12){
                $data['first_name'] = substr($str,0,12).'...';
            }
            else{
                $data['first_name'] = explode(" ", $this->meuCadastro->nome)[0]; 
            }
            
            
            $urlImgPerfil = $this->meuCadastro->img_perfil_uri.$this->meuCadastro->img_perfil;
            $noImg = base_url("themes/comdono/img/no-img-perfil.png");
            $data['urlImgPerfil'] = ($this->meuCadastro->img_perfil == '')?$noImg:$urlImgPerfil;
            
            $data['imovel_incompleto'] = $this->cad_model->getImovelCad(['status <' => 2 ,'id_imovel_rel' => 0]); 
        }
        else
        {
            
            
            if($this->module == "comdono" && $this->class == 'cadastro' && $this->method == 'index'){
              $data["menu_home"] = false;
              $data["footer_home"] = false;
            }
        }
        
        if($this->module == "comdono" && $this->class == 'busca' && $this->method == 'lancamento'){
            $data["menu_landingpage"] = true;
        }
        
        if($this->module == "landingpage" && ($this->class == 'avaliacao' || $this->class == 'links' || $this->class == 'resultado' || $this->class == 'financiamento' || $this->class == 'luner' || $this->class == 'maedesete' || $this->class == 'grupo_attos')){
                
            $data["menu_home"] = false;
            $data["footer_lp"] = false;
        }
        
        if($this->module == "landingpage" && ($this->class == 'elleven')){
            $data["menu_home"] = true;
            $data["footer_lp"] = true;
        }
        
        $key = $this->uri->segment(3);
        $imovel_lp = $this->uri->segment(2);
        $uri2 = $this->uri->segment(2);
        $condicoes_comerciais = $this->uri->segment(3);
        $landingpage = $this->uri->segment(1);
        
        if($condicoes_comerciais == 'condicoes_comerciais' || $landingpage == 'lp' || $this->module == "landingpage" && ($this->class == 'luner' || $this->class == 'grupo_attos' || $this->class == 'convite')){
            $data["menu_home"] = false;
            $data["footer_home"] = false;
        }
        
        if($this->module == "landingpage" && $this->class == 'resultado'){
            $data["menu_home"] = false;
            $data["footer_home"] = false;
        }
        
        if(($this->module == "landingpage" && $this->class == 'vendainteligente')  || ($landingpage == 'lp' && $uri2 == "venda-inteligente-comdono")){
            $data["menu_home"] = false;
            $data["footer_home"] = true;
        }
        
        if(($this->module == "landingpage" && $this->class == 'aluguel_inteligente')  || ($landingpage == 'lp' && $uri2 == "aluguel-inteligente-comdono")){
            $data["menu_home"] = false;
            $data["footer_home"] = true;
        }
        
        /*SEO*/
        
        $lpConfig =  $this->cad_model->getLpConfig([['id_imovel',$this->uri->segment(2)]]);
        if($lpConfig != null)
        {
            $data["page_seo"] = true;
	        $data["url_header"] = $lpConfig->seo_site_url;
	        $data["image_header"] = $lpConfig->seo_img;
	       
            $data["title_page"] = $lpConfig->seo_titulo;
            $data["imovel_description"] = $lpConfig->seo_descricao;
            
        }
        else{
            if($this->uri->segment(1) == 'imovel' || $this->uri->segment(1) == 'lancamento')
    	    {
    	        $page = $this->uri->segment(1);
                $id_imovel = $this->uri->segment(2);
                $url_page = $this->uri->segment(3);
                $title_page = ucwords(str_replace ("-" , " ", $url_page)); 
                $where[] = [['a.id_imovel',$id_imovel]];
                $data["url_header"] = base_url().$this->uri->uri_string();
                $imovel_header = $this->busca_model->getImovel($where);
                
                if($imovel_header !== NULL){
                    $data["page_seo"] = true;
                    //var_dump($data["page_seo"]);
                    
                    $data["imovel_header"] = $imovel_header;
                    $text = "Anuncie ou compre seu imóvel Comdono";
                    $description = strip_tags($imovel_header->caracteristicas !== "" ? $imovel_header->caracteristicas : $text);
                    
                    $description = str_replace("\n", "", $description);
                    $description = str_replace("\r", "", $description);
                    $description = preg_replace('/\s/',' ',$description);
                    $qtd_str = strlen($description);
                    
                    if ($qtd_str > 230) {
                        $data["imovel_description"] = substr($description,0,227).'...';
                        $description_resumo = substr($description,0,227).'...';
                    }else{
                        $data["imovel_description"] = $description;
                    }
                    
                    if($imovel_header->doc_perfil == "cpf"){
                        $data["title_page"] = $title_page." - Compre COMDONO";
                    }else{
                        if($page == "lancamento"){
                            $data["title_page"] = $title_page." - ".$description_resumo;
                        }else{
                            if($imovel_header->tipo_imovel == "Comercial"){
                                $data["title_page"] = "Venda de ".$title_page;
                            }else{
                                $data["title_page"] = "Venda de ".$title_page." - ".$imovel_header->dn_nome_nomefantasia;
                            }
                        }
                    }
                }
    	    }
        }
	    
	    if($this->uri->segment(1) == 'avaliacao')
	    {
	        $data["page_seo"] = true;
	        $data["url_header"] = base_url().$this->uri->uri_string();
	        $data["image_header"] = base_url()."assets/img/comdono/bg/bg-avaliacao2-rs.jpg";
            $data["title_page"] = "Quanto vale o meu imóvel?";
            $data["imovel_description"] = "Avalie seu imóvel com nossa tecnologia e descubra em menos de 2 minutos o valor do seu imóvel.";
	    }
	    
	    if($this->uri->segment(2) == 'chega-de-imobiliaria')
	    {
	        $data["page_seo"] = true;
	        $data["url_header"] = base_url().$this->uri->uri_string();
	        $data["image_header"] = base_url()."assets/img/comdono/lp/imobi/images/chega-de-imobiliaria.jpg";
            $data["title_page"] = "Não compre imóvel com imobiliária!";
            $data["imovel_description"] = "Descubra a verdade sobre a compra de imóveis.";
	    }
	    
	    if($this->uri->segment(2) == 'financiamento')
	    {
	        $data["page_seo"] = true;
	        $data["url_header"] = base_url().$this->uri->uri_string();
	        $data["image_header"] = base_url().'themes/comdono/img/logo-new-236x236.jpg';
            $data["title_page"] = "Financimento imobiliário Comdono.";
            $data["imovel_description"] = "Crédito imobiliário. Quem oferece a melhor condição?";
	    }
	    
	    if($this->uri->segment(1) == 'proposta-inteligente')
	    {
	        $data["page_seo"] = true;
	        $data["url_header"] = base_url().$this->uri->uri_string();
	        $data["image_header"] = (getenv('MEDIA_URL'))."/modules/comdono/lp/venda-inteligente/images/bg/bg-estrategia.png";
	       
            $data["title_page"] = "Proposta Inteligente Comdono";
            $data["imovel_description"] = "O principal critério para quem busca imóveis é a confiança na incorporadora, ou seja, um anúncio confiável aumenta a velocidade na tomada de decisão do seu cliente.";
	    }
	    
	    
	    
	    if($this->uri->segment(1) == 'landingpage' && $this->uri->segment(2) == 'luner')
	    {
	        $data["page_seo"] = true;
	        $data["url_header"] = "https://construtoraluner.com.br/";
	        $data["image_header"] = (getenv('MEDIA_URL'))."/modules/comdono/lp/luner/images/logo-luner-236x236.jpg";
	        $data["favicon_header"] = (getenv('MEDIA_URL'))."/modules/comdono/lp/luner/images/favicon-luner.png";
            $data["title_page"] = "Construtora Luner: obras de excelência em Brasília";
            $data["imovel_description"] = "Responsável pela incorporação de diversos empreendimentos imobiliários na capital, a construtora atua com foco em projetos criativos, inovadores e modernos.";
	    }
	    
	    /*if($this->uri->segment(1) == 'landingpage' && $this->uri->segment(2) == 'convite')
	    {
	        $data["page_seo"] = true;
	        $data["page_uri"] = 'convite';
	        $data["url_header"] = "https://comdono.com/landingpage/convite/ellev_attos_urg91m";
	        $data["image_header"] = (getenv('MEDIA_URL'))."/modules/comdono/lp/convite/images/elleven-convite.jpg";
            $data["title_page"] = "Café da manhã - Elleven Lago Norte";
            $data["imovel_description"] = "Neste sábado dia 24 a partir das 9h00 venha tomar um delicioso café da manhã. As incorporadoras Base e Attos irão te apresentar o melhor estilo de vida de Brasília.";
	    }*/
	    
	    $evento = $this->cad_model->getEvento(['uuid_evento',$this->uri->segment(3)]);
        if($evento != null)
        {
            $data["page_seo"] = true;
	        $data["url_header"] = $evento->seo_site_url;
	        $data["image_header"] = $evento->seo_img;
	       
            $data["title_page"] = $evento->seo_titulo;
            $data["imovel_description"] = $evento->seo_descricao;
            
        }
	    
        /*END SEO*/
        
        $data['select_busca'] = json_encode($this->cad_model->getSelectBusca());
        
        //Metodos que nao carregam tema ogiginal
        /*$class = ["home","login","login","login","cadastro"];
        $method = ["index","index","recuperar_senha","nova_senha","index"];*/
        $class = ["home","login","login","login"];
        $method = ["index","index","recuperar_senha","nova_senha"];
        foreach ($class as $key=>$cls)
        {
            if($this->module == "comdono" && $this->class == $cls && $this->method == $method[$key]){
              $data["menu_home"] = false;
              $data["footer_home"] = false;
            }
        }
        
        if(!empty($theme))
        {
            //Template::set_theme($theme,'painel');
            Template::set_theme($theme);
        }

        if(!empty($css))
        {
            Assets::add_css($css);
        }
        
        if(!empty($js))
        {
            Assets::add_js( $js, 'external', false);
        }
        
        if(!empty($header))
        {
            Template::load_view($module.'/theme/'.$header, $data, '', '', $data['header']);
        }
        
        if(!empty($footer))
        {
            $data['footer'] = '';
            Template::load_view($module.'/theme/'.$footer, $data, '', '', $data['footer']);
        }
        
        $data['url'] = $this->loginUrl();
        
        Template::set_modal($data,[
            'comdono/modal/login_site_view'
        ]);

        Template::set($data);
    }
    
    function set_http_referer()
    {
        if(isset($_SERVER["HTTP_REFERER"]))
        {
            $referer = $_SERVER["HTTP_REFERER"];
            $pos = strpos($referer, base_url());
            if (!$pos) {
                $this->session->set_userdata('http_referer', $referer);
                $this->session->mark_as_temp('http_referer', 3600);
            }
        }
    }
    
    public function get_http_referer()
    {
        $http_referer = $this->session->http_referer;
	    if($http_referer == null)
	       $http_referer = 'Acesso Direto';
        return $http_referer;
    }
    
    public function setRefRedirect()
    {
        if(isset($_SERVER["HTTP_REFERER"]))
        {
            $referer = $_SERVER["HTTP_REFERER"];
            $pos = strpos($referer, base_url());
            if (!$pos) {
                $this->session->set_userdata('ref_redirect', $referer);
            }
        }
    }
    
    public function refRedirect()
    {
        //var_dump($this->session->ref_redirect??false);die();
        if($this->session->ref_redirect??false){
            $ref_redirect = $this->session->ref_redirect;
            //$this->session->unset_userdata('ref_redirect');
			return $ref_redirect;
			
        }
		else
			return ($this->session->login_redirect == "Acesso Direto" || $this->session->login_redirect == NULL) ? base_url('minha-conta'):$this->session->login_redirect;
    }
    
}