<?php (defined('BASEPATH')) OR exit('No direct script access allowed');

class Builder_Controller extends Login_Facebook
{
    protected $meuCadastro;
    protected $perfil;
    protected $module;
    protected $class;
    protected $method;
    
    public function __construct() 
    {
        parent::__construct();
        
        
        if(base_url() == "https://dev.comdono.com/" && $this->session->dev_admin != true){
            //redirect('https://comdono.com/');
        }
        
        $this->load->library('template');
        $this->load->library('assets');
        $this->load->library('events');
        $this->load->library('auth/Tank_auth');
        
        $this->load->library('aceita_cookie/aceita_cookie');
        
        $instance = parent::get_instance();
        $this->perfil = $this->session->userdata('perfil');
        $this->module = $instance->router->fetch_module();
        $this->class = $instance->router->fetch_class();
        $this->method = $instance->router->fetch_method();
        
        $this->load->helper('cookie');
        $this->load->helper('comdono/comdono');
        $this->load->helper('minha_conta/minha_conta');
        
        $this->load->model('comdono/busca_model');
        
		$this->load->library('newsletter/newsletter');
        $this->load->library('comdono/notification');
        
        $this->config->load('module', FALSE, TRUE);
        
        $this->set_theme('comdono');
        
        $this->aceita_cookie();
    }
    
    public function logado()
    {
        return $this->tank_auth->is_logged_in();
    }
    
    private function aceita_cookie(){
        
        //delete_cookie('aceita_cookie'); 
        
        //return false;
        
        if((get_cookie('aceita_cookie')??'') != 'aceito'){
            
            Assets::add_module_css('comdono', array(
                'cookie'
            ));
            Assets::add_module_js('comdono', array(
                'cookie'
            ));
            Template::set_modal([],[
                'comdono/cookie/cookie_view'
            ]);
        }
    }
    
    protected function set_theme($theme = 'painel')
    {
        setlocale(LC_ALL, 'pt_BR', 'pt_BR.utf-8', 'pt_BR.utf-8', 'portuguese');
        
        Template::set_theme($theme);
        
        $this->load->config('../../../html/themes/'.$theme.'/config.php');
        
        $this->config->item('theme.module');
        $css = $this->config->item('theme.css');
        $js = $this->config->item('theme.js');
        $modJs = $this->config->item('module.js');
        
        $data['header']  = $this->config->item('theme.header');
        $data['topnav']  = $this->config->item('theme.topnav');
        $data['sidebar'] = $this->config->item('theme.sidebar');
        $data['footer']  = $this->config->item('theme.footer');
        $data['footer_scripts']  = $this->config->item('theme.footer_scripts');
        
        if(!empty($css))
        {
            Assets::add_css($css);
        }
        
        if(!empty($js))
        {
            Assets::add_js( $js, 'external', false);
        }
        
        if(!empty($modJs))
        {
            Assets::add_module_js($theme, $modJs);
        }
        
        $this->variaveis_ini($data);
        $this->set_logado($data);
        
        Template::set($data);
    }
    
    private function set_logado(&$data = [])
    {
        if($this->logado() == true)
        { 
            $data["notficacoes"] = Notification::getAll();
            $this->meuCadastro = $this->cad_model->get_cadastro();
            
            if($this->meuCadastro->etapa == 1){
                $data["menu_home"] = false;
                $data["footer_home"] = false;
            }
            $negVendas = $this->cad_model->getNegocDono();
            $negCompras = $this->cad_model->getNegocInteressado();
            if(count($negVendas)>0){
                $data['linkMenuChat'] = base_url('minha_conta/minhas_vendas/negociacoes/'.$negVendas[0]->id_imovel.'/'.$negVendas[0]->id_chat);
            }
            elseif (count($negCompras)>0) {
                $data['linkMenuChat'] = base_url('minha_conta/minhas_compras/negociacoes/'.$negCompras[0]->id_imovel.'/'.$negCompras[0]->id_chat);
            }
            else{
                $data['linkMenuChat'] = base_url('minha-conta');
            }
            
            if(
                ($this->module == "comdono" && $this->class == 'cadastro' && ($this->method == 'imovel' || $this->method == 'preview')) ||
                ($this->module == "minha_conta" && $this->class == 'minhas_vendas' && in_array($this->method, ['edit','edit_lancamento','edit_unidade']))
            ){
                $data["menu_cad_imovel"] = false; 
            }
            
            $data['cadastro_user'] = $this->meuCadastro;
            
            $str = explode(" ", $this->meuCadastro->nome)[0]; 
            if(strlen($str) >= 12){
                $data['first_name'] = substr($str,0,12).'...';
            }
            else{
                $data['first_name'] = explode(" ", $this->meuCadastro->nome)[0]; 
            }
            
            
            $urlImgPerfil = $this->meuCadastro->img_perfil_uri.$this->meuCadastro->img_perfil;
            $noImg = base_url("themes/comdono/img/no-img-perfil.png");
            $data['urlImgPerfil'] = ($this->meuCadastro->img_perfil == '')?$noImg:$urlImgPerfil;
            
            $data['imovel_incompleto'] = $this->cad_model->getImovelCad(['status <' => 2 ,'id_imovel_rel' => 0]); 
        }    
        return $data;
    }   
    
    private function variaveis_ini(&$data = []) 
    {
        $this->set_http_referer();
        
        $data['get_http_referer'] = $this->get_http_referer();
        $data['body']['class'] = 'autocomplete-responsive';
        $data['notficacoes'] = [];
        $data['active'] = "";
        $data['url'] = $this->loginUrl();
        $data['logado'] = $this->logado();
        $data['linkMenuChat'] = base_url('login');
        $data["menu_home"] = true;
        $data['select_busca'] = json_encode($this->cad_model->getSelectBusca());
        $data['gcaptcha'] = $this->session->gcaptcha;
        $data['public_key'] = $this->db->where('name','captcha_public_key')->get('sys_config')->row()->value;
        
        Template::set_modal($data,[
            'comdono/modal/login_site_view'
        ]);
        
        return $data;
    }
    
    function set_http_referer()
    {
        if(isset($_SERVER["HTTP_REFERER"]))
        {
            $referer = $_SERVER["HTTP_REFERER"];
            $pos = strpos($referer, base_url());
            if (!$pos) {
                $this->session->set_userdata('http_referer', $referer);
                $this->session->mark_as_temp('http_referer', 3600);
            }
        }
    }
    
    public function get_http_referer()
    {
        $http_referer = $this->session->http_referer;
	    if($http_referer == null)
	       $http_referer = 'Acesso Direto';
        return $http_referer;
    }
    
    public function setRefRedirect()
    {
        if(isset($_SERVER["HTTP_REFERER"]))
        {
            $referer = $_SERVER["HTTP_REFERER"];
            $pos = strpos($referer, base_url());
            if (!$pos) {
                $this->session->set_userdata('ref_redirect', $referer);
            }
        }
    }
    
    public function refRedirect()
    {
        //var_dump($this->session->ref_redirect??false);die();
        if($this->session->ref_redirect??false){
            $ref_redirect = $this->session->ref_redirect;
            //$this->session->unset_userdata('ref_redirect');
			return $ref_redirect;
			
        }
		else
			return ($this->session->login_redirect == "Acesso Direto" || $this->session->login_redirect == NULL) ? base_url('minha-conta'):$this->session->login_redirect;
    }
    
}