<?php (defined('BASEPATH')) OR exit('No direct script access allowed');

class Comdono_Controller extends Builder_Controller
{
    public function __construct() 
    {
        parent::__construct();
        
        $this->comdono_ini();
        
        if($this->input->get('utm_source', TRUE) !== NULL)
        {   
            $origem = [
                'origem'        => uri_string(),
                'link'          => base_url(uri_string()),
                'utm_source'    => $this->input->get('utm_source', TRUE),
                'utm_medium'    => $this->input->get('utm_medium', TRUE),
                'utm_campaign'  => $this->input->get('utm_campaign', TRUE),
                'utm_term'      => $this->input->get('utm_term', TRUE),
                'utm_content'   => $this->input->get('utm_content', TRUE),
            ];
            $this->session->set_userdata('origem', $origem);
        }
    }
    
    private function comdono_ini() 
    {
        //var_dump($this->module,$this->class, $this->method);
        //string(11) "landingpage" string(16) "vendainteligente" string(5) "index"
        
        if($this->tank_auth->is_logged_in()){
            
            $this->verificaCadastro();
        }
            
        elseif($this->module == "minha_conta")
            redirect('login');
        
        //elseif($this->module == "landingpage" && $this->class == "vendainteligente")
             //redirect('venda-inteligente');
    }
    
    private function verificaCadastro()
    {
       $this->meuCadastro = $this->cad_model->get_cadastro();
       
       if($this->meuCadastro->etapa < 8 && ($this->module != "comdono" || $this->class != "cadastro" || $this->method != "index")){
           redirect('cadastro');
       }
    }
 }