<?php defined('BASEPATH') || exit('No direct script access allowed');
/**
 * Painel Controller
 *
 * This class provides a base class for all admin-facing controllers.
 * It automatically loads the form, form_validation and pagination
 * helpers/libraries, sets defaults for pagination and sets our
 * Admin Theme.
 *
 * @package    Builder
 * @subpackage MY_Controller
 * @category   Controllers
 * @author     ViewBrasil Dev Team
 * @link       http://guides.cibonfire.com/helpers/file_helpers.html
 *
 */
class Painel_Controller extends Login_Facebook
{
    /**
     * Class constructor - setup paging and keyboard shortcuts as well as
     * load various libraries
     * IMPORTANT! There is no 
     */
    
    protected $theme;
    
    public function __construct() 
    {
		parent::__construct();
		
		$this->theme = $this->theme??'painel';
		
        $this->load->library('template');
        
        $this->load->library('assets');
        $this->load->library('events');
        $this->load->library('auth/Tank_auth');
        
        Assets::add_module_js('sistema', array('modal'));
        
        Template::load_view('sistema/modal/clear_cache', '', '', '', $data['modal'][]);
        Template::load_view('sistema/modal/clear_session', '', '', '', $data['modal'][]);
        Template::load_view('sistema/modal/logout', '', '', '', $data['modal'][]);
        
        $data['csrf_ajax'] = $this->get_csrf_ajax();
        
        $this->set_theme($this->theme);
        
        Template::set($data);    
    }
    
    protected function set_theme($theme = 'painel', $subtheme = '')
    {
        Template::set_theme($theme,$subtheme);
        
        $this->load->config('../../../html/themes/'.$theme.'/config.php');
        
        $module = $this->config->item('theme.module');
        $css = $this->config->item('theme.css');
        $js = $this->config->item('theme.js');
        
        $data['header']  = $this->config->item('theme.header');
        $data['topnav']  = $this->config->item('theme.topnav');
        $data['sidebar'] = 'menu_left'; //$this->config->item('theme.sidebar');
        $data['footer']  = $this->config->item('theme.footer');
        
        if(!empty($css))
        {
            Assets::add_css($css);
        }
        
        if(!empty($js))
        {
            Assets::add_js( $js, 'external', false);
        }
        
        Template::set($data);
        
    }
    
    private function get_csrf_ajax() 
    {
        return array(
            'name' => $this->security->get_csrf_token_name(),
            'hash' => $this->security->get_csrf_hash()
        );
    }
}
/* End of file Painel_Controller.php */