<?php (defined('BASEPATH')) OR exit('No direct script access allowed');

class Sites_Controller extends CI_Controller
{
    public function __construct() 
    {
        parent::__construct();
        
        $this->load->library('template');
        $this->load->library('assets');
        $this->load->library('events');
        
        $this->load->helper('cookie');
        $this->load->library('aceita_cookie/aceita_cookie');
        
        $this->load->helper('comdono/comdono');
        
        $this->config->load('module', FALSE, TRUE);
        
        //$this->set_theme('clean');
    }
    
    protected function set_theme($config)
    {
        setlocale(LC_ALL, 'pt_BR', 'pt_BR.utf-8', 'pt_BR.utf-8', 'portuguese');
        
        $this->load->config('../config/'.$config.'.php');
        
        $theme = $this->config->item('theme.module');
        
        Template::set_theme($theme);
        
        $css = $this->config->item('theme.css');
        $js = $this->config->item('theme.js');
        $modJs = $this->config->item('module.js');
        
        
        $data['header']  = $this->config->item('theme.header');
        $data['topnav']  = $this->config->item('theme.topnav');
        $data['footer']  = $this->config->item('theme.footer');
        $data['footer_scripts']  = $this->config->item('theme.footer_scripts');
        
        if(!empty($css))
        {
            Assets::add_css($css);
        }
        
        if(!empty($js))
        {
            Assets::add_js( $js, 'external', false);
        }
        
        if(!empty($modJs))
        {
            Assets::add_module_js($theme, $modJs);
        }
        
        Template::set($data);
    }
}