Chart.defaults.global.pointHitDetectionRadius = 1
Chart.defaults.global.tooltips.enabled = false
Chart.defaults.global.tooltips.mode = 'index'
Chart.defaults.global.tooltips.position = 'nearest'
Chart.defaults.global.tooltips.custom = CustomTooltips

var $usuarios;
var $capturas;
var $imoveis;
var $periodo = 'mes';

//Callbeck erro ajax
$error = function error(r){console.log('erro', r)};

$(window).on('load', function(){
    ini_dashboard();
    
    //carrossel
    $('.owl-carousel-cards').owlCarousel({
        autoplay:true,
        autoplayHoverPause: true,
        loop:false,
        touchDrag: true,
        mouseDrag: true,
        margin:10,
        responsiveClass:true,
        responsive:{
            0:{
                items:1,
                nav:false,
                dots:true
            },
            768:{
                items:3,
                nav:false,
                dots:true
            },
        }
    });
    
});


$('body').on('change','#periodo', function(){
    
    $('.novoLoad').html('<i class="fa fa-circle-o-notch fa-spin fa-fw"></i>');
    
    $('.chart').hide();
    $periodo = $("#periodo :selected").attr('value');
    ini_dashboard();
});


function ini_dashboard(){
    setUsuarios();
    setCapturas();
    setImoveis();
    setFinanciamentos();
    setNegociacoes();
}


function setCapturas(){
    get_ajax('getCapturas', retorno =>{
        $capturas = retorno.data;
        
        $('.capturasTotal').html($capturas.total);
        $('.capturasCompletas').html($capturas.completas);
        
        $('.capturasAtual').html($capturas.atual);
        $('.capturasAnterior').html($capturas.anterior);
        
        setChartGeral('#card-chart1',$capturas.periodos);
        
    }, $error);
}

function setUsuarios(){
    get_ajax('getUsuarios', retorno =>{
        $usuarios = retorno.data;

        $('.usuariosTotal').html($usuarios.total);
        $('.usuariosAtivos').html($usuarios.ativos);
        
        $('.usuariosAtual').html($usuarios.atual);
        $('.usuariosAnterior').html($usuarios.anterior);
        
        setChartGeral('#card-chart2',$usuarios.periodos);
        
    },$error);
}

function setImoveis(){
    get_ajax('getImoveis',  retorno =>{
        $imoveis = retorno.data;
        
        $('.imoveisTotal').html($imoveis.total);
        $('.imoveisPublicados').html($imoveis.publicados);
       
        $('.imoveisAtual').html($imoveis.atual);
        $('.imoveisAnterior').html($imoveis.anterior);
       
       setChartGeral('#card-chart3',$imoveis.periodos);
        
    }, $error);
}

function setFinanciamentos(){
    get_ajax('getFinanciamentos',  retorno =>{
        $financiamentos = retorno.data;
        
        $('.financiamentosTotal').html($financiamentos.total);
        $('.financiamentosSolicitados').html($financiamentos.solicitados);
        
        $('.financiamentosAtual').html($financiamentos.atual);
        $('.financiamentosAnterior').html($financiamentos.anterior);
        
        setChartGeral('#card-chart4',$financiamentos.periodos);
        
    }, $error);
}

function setNegociacoes(){
    get_ajax('getNegociacoes',  retorno =>{
        $negociacoes = retorno.data;
        
        $('.negociacoesTotal').html($negociacoes.total);
        $('.negociacoesAndamento').html($negociacoes.andamento);
        
        
        $('.negociacoesAtual').html($negociacoes.atual);
        $('.negociacoesAnterior').html($negociacoes.anterior);
        
        setChartGeral('#card-chart5',$negociacoes.periodos);
        
    }, $error);
}


function setChartGeral($cart, $periodos)
{
    $labels = [];
    $valores = [];
    $menor = 0
    $maior = 0;
    for(var i in $periodos)
    {
        //$mes = $periodos[i].mes;
        $dt = $periodos[i][$periodo];
        
        
        
        $qnt = parseInt($periodos[i].qnt);
        
        
        
        
        //$labels[i] = "Mês: "+$mes;
        $labels[i] = $periodo+": "+$dt;
        $valores[i] = $qnt;
        
        if(i == 0){
            $menor = $qnt;
            $maior = $qnt;
        }
        if($qnt < $menor)
            $menor = $qnt;
        if($qnt > $maior)
            $maior = $qnt;
    }
    
    iniChart($cart,$labels,$valores, $menor, $maior);
}
var cont = 0;
var $card = []; 
function iniChart($divCard,$labels,$valores, $menor, $maior){
    
    if($card[$divCard] != undefined){
        $card[$divCard].destroy();
    }
    
    $card[$divCard] = new Chart($($divCard), {
      type: 'line',
      data: {
        labels: $labels,
        datasets: [
          {
            label: '',
            backgroundColor: getStyle('--primary'),
            borderColor: 'rgba(255,255,255,.55)',
            data: $valores
          }
        ]
      },
      options: {
        maintainAspectRatio: false,
        legend: {
          display: false
        },
        /*tooltips: {
            mode: 'y'
        },*/
        scales: {
          xAxes: [{
            gridLines: {
              color: 'transparent',
              zeroLineColor: 'transparent'
            },
            ticks: {
              fontSize: 2,
              fontColor: 'transparent'
            }
          }],
          yAxes: [{
            display: false,
            ticks: {
              display: false,
              min: $menor-5,
              max: $maior+5 
            }
          }]
        },
        elements: {
          line: {
            borderWidth: 1
          },
          point: {
            radius: 4,
            hitRadius: 10,
            hoverRadius: 4
          }
        }
      }
    })
}
 
function get_ajax($func, $success, $error, $data = []){
     
    $.ajax({
		url: base_url+"administrativo/ajax/painel_ajax/"+$func, 
		dataType: 'json',
		type: 'POST',
		data: {periodo: $periodo},
		success: function(retorno)
		{		
		    if(retorno.valid == false)
		    {
		        $error(retorno);
		    }
		    else
		    {
		        $success(retorno);
		        
		    }
		},
		error: function(error)
		{
		    $error(error);
		}
    });
    
 }