<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

include_once GROCERY_CRUD;

class Atendimento extends Grocery {

    function __construct() 
    {
        parent::__construct();
		$this->load->model('administrativo/admin_model');
		$this->load->model('administrativo/dash_model');
		
		Assets::add_module_js('comdono', array(
            'main'
        ));
    }
    
    public function index() 
    {
        try{
		    $this->ini_method();
		    
			$crud = new grocery_CRUD();
			
			$this->valida_acoes($crud);
			
			$crud->set_theme('bootstrap');
			$crud->set_table('cad_atendimento');
			$crud->set_subject('Atendimento');
			
			//$crud->set_relation('id_captura','cad_captura','nome');
			
			//$crud->set_relation('id_cadastro','cad_cadastro','nome');
			
			//$crud->columns(['nome','email','email']);
			
			//crud->field_type('id_user', 'hidden', $this->session->id_cadastro);
		    
		    $crud->add_action('Add Atendimento', '','administrativo/atendimento/atendimentos','fa fa-plus-square');
		    
			$stateInfo = $crud->getStateInfo();
			$state = $crud->getState();
			$output = $crud->render();
			$this->_example_output($output);
			
		}catch(Exception $e){
			show_error($e->getMessage().' --- '.$e->getTraceAsString());
		}
    }   
    
    function resumo()
	{
        $this->ini_method();
        
        $naoAguardandoRetorno = [];
        $naoAtendidas = [];
    
        //===============================================================================
        $whereCadsImovel = [['status', 3],['doc_perfil', 'cpf']];
        $whereSimulacoes = [['id_imovel >',0]];//,['step >=', 4]
        
        //$tb_origem, $name_id, $function_get, $where, $tipo_interesse(cad_atendimento_historico), $origem_captura(so se for da cad_captura), $name(titulo), $link
        $configAtendimento = [
                ['fnc_simulacao', 'id_simulacao', 'getSimulacoes', $whereSimulacoes, 'Financiamento',    'xxx', 'Simulações',  'administrativo/atendimento/financiamento_imovel'],
                ['cad_cadastro',  'id_cadastro',  'getCadsImovel', $whereCadsImovel, 'Anunciante ativo', 'xxx', 'Anunciantes', 'administrativo/atendimento/anunciantes'],
                ['cad_contato', 'id', 'getContatos', [], 'Contato',    'xxx', 'Contatos',  'administrativo/atendimento/contatos'],
                
                ['cad_captura', 'email', 'getCapturas', [], 'Financiamento', 'financiamento',         'LP Financiamento', 'administrativo/atendimento/financiamento'],
                ['cad_captura', 'email', 'getCapturas', [], 'Avaliação',     'avaliacao',             'LP Avaliação', 'administrativo/atendimento/avaliacao'],
                ['cad_captura', 'email', 'getCapturas', [], 'Elleven',       'interessado_elleven',   'LP Elleven', 'administrativo/atendimento/elleven'],
                /*['cad_captura', 'email', 'getCapturas', [], 'Exclusive',     'interessado_exclusive', 'LP Exclusive', 'administrativo/atendimento/exclusive'],*/
                ['cad_captura', 'email', 'getCapturas', [], 'Liberty',       'interessado_liberty',   'LP Liberty', 'administrativo/atendimento/liberty'],
                ['cad_captura', 'email', 'getCapturas', [], 'Signature',       'interessado_signature',   'LP Signature', 'administrativo/atendimento/signature'],
        ];
        
        foreach ($configAtendimento as $dt)
        {
            $tb_origem      = $dt[0];
            $name_id        = $dt[1];
            $function_get   = $dt[2];
            $where          = $dt[3];
            $tipo_interesse = $dt[4];
            $origem_captura = $dt[5];
            $name           = $dt[6];
            $link           = $dt[7];
            
            $CapturasNaoAtendidas = $this->admin_model->getNaoAtendidas($tb_origem, $name_id, $function_get, $where, $tipo_interesse, $origem_captura);
            //if(!empty($CapturasNaoAtendidas)){
            $naoAtendidas[] = (object)[
                    'key'      => $tb_origem,
                    'name'     => $name,
                    'qnt'      => count($CapturasNaoAtendidas),
                    'link'     => $link,
                ];
            //}
             
            $CapturasAtendidas = $this->admin_model->getAguardandoRetorno($tb_origem, $name_id, $function_get, $where, $tipo_interesse, $origem_captura);
            if(!empty($CapturasAtendidas)){
                $naoAguardandoRetorno[] = (object)[
                        'key'      => $tb_origem,
                        'name'     => $name,
                        'qnt'      => count($CapturasAtendidas),
                        'link'     => $link,
                    ];
            }
        }
        //===============================================================================
        
        //===============================================================================
        $atendGeral = $this->dash_model->getAtendimentoHistorico_count();
        foreach ($atendGeral as $k=>$atend)
        {
            $w = [];
            $w[] = ['id_user', $atend->id_cadastro];
            
            $atend->dia_atual       = $this->dash_model->getCountAtual('getAtendimentoHistorico', 'data_hora', 'dia', $w);
            $atend->dia_anterior    = $this->dash_model->getCountAnterior('getAtendimentoHistorico', 'data_hora', 'dia', $w);
            
            $atend->semana_atual    = $this->dash_model->getCountAtual('getAtendimentoHistorico', 'data_hora', 'semana', $w);
            $atend->semana_anterior = $this->dash_model->getCountAnterior('getAtendimentoHistorico', 'data_hora', 'semana', $w);
            
            $atend->mes_atual       = $this->dash_model->getCountAtual('getAtendimentoHistorico', 'data_hora', 'mes', $w);
            $atend->mes_anterior    = $this->dash_model->getCountAnterior('getAtendimentoHistorico', 'data_hora', 'mes', $w);
            
            if($atend->mes_atual == 0 && $atend->mes_anterior == 0)
                unset($atendGeral[$k]);
        }
        //===============================================================================
        
        
        $data['atendentes'] = $atendGeral;
        $data['naoAtendidas'] = $naoAtendidas;
        $data['naoAguardandoRetorno'] = $naoAguardandoRetorno;
        
        $this->dataTables();
        
        //var_dump( date("W"));
        
        Assets::add_js(array(
            'js/Chart.min',
        ));
        Assets::add_module_js('administrativo', array(
            'main',
            //'atendimento',
            'dashboard',
            'dashboard_atendimento'
        ));
        
        Template::set($data);
        Template::set_view('administrativo/dashboard_atendimento_view');
        Template::render();
    }
    
    function anunciantes()
	{
        $this->ini_method();
        //$result = [];
        
        $w[] = ['status =', 3];
        $w[] = ['doc_perfil', 'cpf'];
        
        $anunciantes = $this->admin_model->getCadsImovel($w);
        
        $data['anunciantesProximoContato'] = [];
        $data['anunciantesFinalizados'] = [];
        foreach ($anunciantes as $k=>$anunciante)
        {
            $w['id'] = ['id_cadastro',$anunciante->id_cadastro];
            $anunciante->imoveis = $this->dash_model->getImoveis($w);
            $anunciante->atendimento  = $this->admin_model->getAtendimentoHistoricoDesc([['id_rel',$anunciante->id_cadastro],['tb_origem', 'cad_cadastro']]);
            
            if(!empty($anunciante->atendimento))
            {
                $proximo_contato = end($anunciante->atendimento)->proximo_contato;
                if($proximo_contato == 0 || $proximo_contato == '0000-00-00 00:00:00')
                {
                    $data['anunciantesFinalizados'][] = $anunciante;
                }
                else
                {
                    $data['anunciantesProximoContato'][] = $anunciante;
                }
                unset($anunciantes[$k]);
            }
            
        }
        
        $this->dataTables();
        
        Assets::add_module_js('administrativo', array(
            'main',
            'atendimento',
            'anunciantes'
        ));
        
        $data['anunciantes'] = $anunciantes;
        
        Template::set($data);
        Template::set_view('administrativo/anunciantes_view');
        Template::render();
		    
    }
    
    public function atendimentos() 
    {
        try{
		    $this->ini_method('index');
			$crud = new grocery_CRUD();
			$this->valida_acoes($crud);
			
			$id_antendimento  = $this->uri->segment(4);
			
			$atendimentos = $this->admin_model->getAtendimentoHistorico([['a.id_atendimento',$id_antendimento]]);
			
			foreach($atendimentos as $atend)
			{
			    $atend->atendente =   $this->admin_model->get_cadastro([], $atend->id_user)->nome??'';
			}
			$data['atendimentos'] = $atendimentos;
			
			$stateInfo = $crud->getStateInfo();
			$state = $crud->getState();
			
			$crud->set_theme('bootstrap');
			$crud->set_table('cad_atendimento_historico');
			$crud->set_subject('Atendimentos');
		    
		    //`id_hist_atend`, `id_bug`, `id_user`, `id_atendimento`, `data_hora`, `tipo_interesse`, `fase_atual`, `fase_atual_motivo`, `proxima_fase`, `ultimo_contato`, `ultimo_contato_tipo`, `status_jornada`, `proximo_contato`, `proximo_contato_motivo`, `observacao`
		    //$crud->columns(['tipo_interesse','observacao']);
		    $crud->fields('id_bug','id_atendimento','id_user','data_hora','tipo_interesse','observacao');
		    //$crud->where('id_atendimento', $id_antendimento);
		        
			//$crud->field_type('id_atendimento', 'hidden', $id_antendimento);
			
			//$crud->field_type('atendimento', 'hidden', $id_antendimento);
			$crud->field_type('id_bug', 'hidden', $id_antendimento);
			$crud->field_type('id_atendimento', 'hidden', $id_antendimento);
			$crud->field_type('id_user', 'hidden', $this->session->id_cadastro);
			
			$crud->field_type('data_hora', 'hidden', date("Y-m-d H:i:s"));
			
			//var_dump($data['atendimentos']);
			
			$data['state'] = $state;
			
			if($state == 'list' || $state == 'success')
			{
			    redirect('administrativo/atendimento/leads');
			}
			
			Template::set_html_custom($data,'atendimentos_view');
			
			$output = $crud->render();
			$this->_example_output($output);
			
		}catch(Exception $e){
			show_error($e->getMessage().' --- '.$e->getTraceAsString());
		}
    }
    
    public function atendimentos_elleven() 
    {
		    $this->ini_method('index');
		    
			$id_antendimento  = $this->uri->segment(4);
			
			$atendimentos = $this->admin_model->getAtendimentoHistorico([['a.id_atendimento',$id_antendimento]]);
			
			
			foreach($atendimentos as $atend)
			{
			    $atend->atendente =   $this->admin_model->get_cadastro([], $atend->id_user)->nome??'';
			}
			
			
			$data['atendimentos'] = $atendimentos;
			$data['state'] = 'add';
			
			
			$data['id_bug'] = $id_antendimento;
			$data['id_atendimento'] = $id_antendimento;
			$data['id_user'] = $this->session->id_cadastro;
			$data['data_hora'] = date("Y-m-d H:i:s");
			
			
			Assets::add_module_js('comdono', array(
			    'main'
			    ));
            Assets::add_module_js('administrativo', array(
                'atendimento',
            ));
            
    		Template::set($data);
            Template::set_view('administrativo/elleven/atendimento_view');
            Template::render();
    } 
    
    function setViewBancos($data)
	{
	    $data['simulacao'] = $this->admin_model->getSimulacao([['id_simulacao',$data['id_simulacao']]]);
	    $data['interessado'] = $this->admin_model->get_cadastro([], $data['simulacao']->id_cad_interessado); 
	    $data['imovel'] = $this->admin_model->getImovel([['a.id_imovel',$data['simulacao']->id_imovel]]);
	   
	    
        $teste = ['status','lixeira','dn_nome_nomefantasia','dn_telefone','dn_email','dn_cpf_cnpj','dn_img','dn_img_uri','tipo_imovel','lancamento','previsao_entrega','cep','endereco','numero','complemento','bairro','cidade','estado'];
        
	    Template::set_html_custom($data,'financiamento_view');
	}
	
	public function atendimento_geral() 
    {
		    $this->ini_method();
		    
		    $data['tipo_interesse']  = $this->uri->segment(4);
			$id_antendimento  = $this->uri->segment(5);
			$data['interessado'] = $this->admin_model->getAtendimento([['id_atendimento',$id_antendimento]]);
			
			//dd($data['user']);
			
			$atendimentos = $this->admin_model->getAtendimentoHistorico([['a.id_atendimento',$id_antendimento]]);
			
			
			$data['empreendimentos'] = $this->admin_model->getEmpreendimentos();
			
			
			foreach($atendimentos as $atend)
			{
			    $atend->atendente =   $this->admin_model->get_cadastro([], $atend->id_user)->nome??'';
			}
			
			
			$data['atendimentos'] = $atendimentos;
			$data['state'] = 'add';
			
			
			$data['id_bug'] = $id_antendimento;
			$data['id_atendimento'] = $id_antendimento;
			$data['id_user'] = $this->session->id_cadastro;
			$data['data_hora'] = date("Y-m-d H:i:s");
			
			
			Assets::add_module_js('comdono', array(
			    'main'
			    ));
            Assets::add_module_js('administrativo', array(
                'atendimento',
            ));
            
    		Template::set($data);
            Template::set_view('administrativo/atendimento_view');
            Template::render();
			
		
    }
    
    function leads()
	{
        $this->ini_method();
        $result = [];
        
        $capturas = $this->admin_model->getCapturas();
        $cadastros = $this->admin_model->getCadastros();
        $atendimentos = $this->admin_model->getAtendimentoHistorico();
        
        foreach ($capturas as $cap)
        {
            if(!isset($result[$cap->email]['nome']) && !isset($result[$cap->email]['email']) && !isset($result[$cap->email]['telefone'])){
                $result[$cap->email]['nome']            = '';
                $result[$cap->email]['email']           = '';
                $result[$cap->email]['telefone']        = '';
                $result[$cap->email]['origem_captura']  = '';
            }
            
            if($cap->nome != '')
                $result[$cap->email]['nome']      = $cap->nome;
            if($cap->email != '')
                $result[$cap->email]['email']     = $cap->email;
            if($cap->telefone != '')
                $result[$cap->email]['telefone']  = $cap->telefone;
            
            
            $origens[$cap->email]['origem_captura'][$cap->origem_captura][] = $cap->origem_captura;
            
            $origensString = "";
            
            foreach($origens[$cap->email]['origem_captura'] as $array)
            {
                $origen = end($array);
                $origensString .= ($origensString=='')?count($array).'-'.$origen:',<br>'.count($array).'-'.$origen;
            }
            
            $result[$cap->email]['origem_captura'] = $origensString;
            
            //$result[$cap->email]['origem_captura']  =  ($result[$cap->email]['origem_captura'] == '')? $cap->origem_captura : $result[$cap->email]['origem_captura'].', '.$cap->origem_captura;
            
            $result[$cap->email]['captura'][] = $cap;
            $result[$cap->email]['data_cap'] = $cap->datetime_captura??'';
            $result[$cap->email]['cadastro'] = [];
            $result[$cap->email]['atendimento'] = [];
            $result[$cap->email]['id_captura'] = $cap->id_captura;
        }
        
        foreach ($cadastros as $cad)
        {
            if(!isset($result[$cad->email]['nome']) && !isset($result[$cad->email]['email']) && !isset($result[$cad->email]['telefone'])){
                $result[$cad->email]['nome']            = '';
                $result[$cad->email]['email']           = '';
                $result[$cad->email]['telefone']        = '';
                //$result[$cap->email]['origem_captura']  = '';
            }
            
            if(!isset($result[$cad->email]['captura']))
                $result[$cad->email]['captura'] = [];
            
            if($cad->nome != '')
                $result[$cad->email]['nome']      = $cad->nome;
                
            if($cad->email != '')
                $result[$cad->email]['email']     = $cad->email;
                
            if($cad->telefone != '')
                $result[$cad->email]['telefone']  = $cad->telefone;
            
            $result[$cad->email]['cadastro'] = $cad;
            $result[$cap->email]['data_cad'] = $cad->data_hora_cadastro;
            $result[$cad->email]['atendimento'] = [];
            $result[$cad->email]['id_cadastro'] = $cad->id_cadastro;
            
            
        }
        
        foreach ($atendimentos as $atend)
        {
            if(!isset($result[$cad->email]['captura']))
                $result[$cad->email]['captura'] = [];
                
            $result[$atend->email]['atendimento'][] = (object)['id_atendimento' => $atend->id_atendimento,'observacao' => $atend->observacao];
        }
        
        $this->dataTables();
        
        Assets::add_module_js('administrativo', array(
            'atendimento',
            'main'
        ));
        
        unset($result['']);
        
        $data['result'] = $result;
        
        Template::set($data);
        //Template::set_view('leds_view');
        Template::set_view('leads_view');
        Template::render();
		    
    }
	
	function leads_bk()
	{			
		try{
		    $this->ini_method();
		    
			$crud = new grocery_CRUD();

			$this->valida_acoes($crud);
			
			$crud->set_theme('bootstrap');
			$crud->set_table('cad_captura');
			$crud->set_subject('Leads página de captura');
			
			$crud->columns(['id_captura','nome','email','telefone','origem_captura','datetime_captura','status_captura','cep','bairro','status_captura','tipo_imovel']);
			
			$stateInfo = $crud->getStateInfo();
			$state = $crud->getState();
			
			$output = $crud->render();
			
			$this->_example_output($output);
			
		}catch(Exception $e){
			show_error($e->getMessage().' --- '.$e->getTraceAsString());
		}
	}
    
    /*function avaliacao()
	{
        $this->ini_method();
        $result = [];
        
        $capturas = $this->admin_model->getCapturasOrderBy([['origem_captura','avaliacao']]);
        
        
        $data['contFace']      = count($this->admin_model->getCapturasOrderBy([['origem_captura','interessado_elleven'],['mensagem','facebook']]));
        $data['contLand']      = count($this->admin_model->getCapturasOrderBy([['origem_captura','interessado_elleven'],['mensagem','']]));
        $data['contFaceAtivo'] = count($this->admin_model->getCapturasOrderBy([['origem_captura','interessado_elleven'],['mensagem','facebook'],['status_captura',3]]));
        $data['contLandAtivo'] = count($this->admin_model->getCapturasOrderBy([['origem_captura','interessado_elleven'],['mensagem',''],['status_captura',3]]));
        
        foreach ($capturas as $cap)
        {
            $cap->atendimento = $this->admin_model->getAtendimentoHistoricoDesc([['email',$cap->email],['tipo_interesse','Avaliação']]);
            $w = [];
            $w[] = ['id_campanha', 32];
            $w[] = ['email', $cap->email];
            
            $logs = $this->admin_model->get_log_emails($w);
            
            $cap->abriu_email = 'Não';
            $cap->clicou_email = 'Não';
            
            $logenviado = false;
            foreach ($logs as $log)
            {
                if($log->enviado >= 1)
                    $logenviado = true;
                    
                if($log->abriu > 0)
                    $cap->abriu_email = '<span class="badge badge-success">Sim</span>';
                if($log->clicou > 0)
                    $cap->clicou_email = '<span class="badge badge-success">Sim</span>';
            }
            
            if($logenviado == false)
                    $cap->datetime_captura = '<span class="badge badge-danger">Não enviado</span>';
            
            $cadastro = $this->admin_model->getCadastro([['email',$cap->email]]);
            
            $cap->cadastro = 'Não';
            if($cadastro != NULL)
                $cap->cadastro = '<span class="badge badge-success">Sim</span>';
            
            $cap->especialista = 'Não';
            if($cap->horario != "" && $cap->dia_semana != "")
                $cap->especialista = '<span class="badge badge-success" data-toggle="tooltip" data-html="true" data-original-title="Dia semana: '.$cap->dia_semana.'<br>Horário: '.$cap->horario.'">Sim, veja aqui.</span>';
            
        }
        
        $this->dataTables();
        
        Assets::add_module_js('administrativo', array(
            'main',
            'atendimento',
            
        ));
        
        $data['capturas'] = $capturas;
        
        Template::set($data);
        Template::set_view('administrativo/avaliacao/dashboard_view');
        Template::render();
		    
    }*/
    
    /*function cadastros()
	{
        $this->ini_method();
        
        
        $cadastros = $this->admin_model->getCadastros();
        
        foreach ($cadastros as $cad)
        {
            $cad->atendimento = $this->admin_model->getAtendimentoHistoricoDesc([['email',$cad->email]]);
        }
        
        $this->dataTables();
        
        Assets::add_module_js('administrativo', array(
            'main',
            'atendimento'
        ));
        
        $data['cadastros'] = $cadastros;
        
        Template::set($data);
        Template::set_view('administrativo/cadastros/dashboard_view');
        Template::render();
    }*/
	
	function elleven()
	{
        $this->ini_method();
        $result = [];
        
        $capturas = $this->admin_model->getCapturasOrderBy([['origem_captura','interessado_elleven']]);
        
        $data['contFace']      = count($this->admin_model->getCapturasOrderBy([['origem_captura','interessado_elleven'],['mensagem','facebook']]));
        $data['contLand']      = count($this->admin_model->getCapturasOrderBy([['origem_captura','interessado_elleven'],['mensagem','']]));
        $data['contFaceAtivo'] = count($this->admin_model->getCapturasOrderBy([['origem_captura','interessado_elleven'],['mensagem','facebook'],['status_captura',3]]));
        $data['contLandAtivo'] = count($this->admin_model->getCapturasOrderBy([['origem_captura','interessado_elleven'],['mensagem',''],['status_captura',3]]));

        $new_cap = [];
        $time_line = [];
        foreach ($capturas as $cap)
        {
            //$cap->atendimento = $this->admin_model->getAtendimentoHistoricoDesc([['email',$cap->email]]);

            $w = [];
            $w[] = [['id_campanha', 45],['id_campanha', 54]];
            //$w[] = ['id_campanha', 45];
            $w[] = ['email', $cap->email];
            $logs = $this->admin_model->get_log_emails($w); 
            
            $cap->abriu_email = 'Não';
            $cap->clicou_email = 'Não';
            $logenviado = false;
            $line = [];
            foreach ($logs as $log)
            {
                if($log->enviado >= 1){
                    $logenviado = true;
                }
                    
                if($log->abriu_em != '0000-00-00 00:00:00'){
                    $log->abriu_em = date('d/m/Y H:i:s', strtotime($log->abriu_em));
                }
                    
                if($log->abriu > 0){
                    $log->abriu_email = '<span class="badge badge-success">Sim em '.$log->abriu_em.'</span>';
                }else{
                    $log->abriu_email = '<span class="badge badge-danger">Não</span>';
                }
                if($log->clicou > 0){
                    $log->clicou_email = '<span class="badge badge-success">Sim</span>';
                }else{
                    $log->clicou_email = '<span class="badge badge-danger">Não</span>';
                }
                if($log->id_campanha == 45){
                    $log->campanha = 'Email - Elleven Cadastro';
                }elseif($log->id_campanha == 54){
                    $log->campanha = 'Email - Estilizar Projeto';
                }
                $log->enviado_em = date('d/m/Y H:i:s', strtotime($log->enviado_em));
                
                $line[] = $log;

            }
            
            if($logenviado == false)
                    $cap->datetime_captura = '<span class="badge badge-danger">Não enviado</span>';
                    
            $new_cap[$cap->email] = $cap;
            $time_line[$cap->email][] = $line;
            $new_cap[$cap->email]->atendimento = $this->admin_model->getAtendimentoHistoricoDesc([['email',$cap->email],['tipo_interesse','Elleven']]);
            $new_cap[$cap->email]->time_line = $time_line[$cap->email];
        }

        $this->dataTables();
        
        Assets::add_module_js('administrativo', array(
            'atendimento',
            'main'
        ));
        
        $data['capturas'] = (object)$new_cap;
        Template::set($data);
        Template::set_view('administrativo/elleven/dashboard_view');
        Template::render();
    }
	
	function elleven_projeto()
	{
        $this->ini_method();
        $result = [];
        
        $capturas = $this->admin_model->getCapturasOrderBy([['origem_captura','interessado_elleven'], ['status_captura',5]]);
        
        foreach ($capturas as $cap)
        {
            $cap->atendimento = $this->admin_model->getAtendimentoHistoricoDesc([['email',$cap->email]]);
        }
        
        $this->dataTables();
        
        Assets::add_module_js('administrativo', array(
            'atendimento',
            'main'
        ));
        
        $data['capturas'] = $capturas;
        
        Template::set($data);
        Template::set_view('administrativo/elleven/projeto_view');
        Template::render();
    }
    
    function exclusive()
	{
        $this->ini_method();
        $result = [];
        
        $capturas = $this->admin_model->getCapturasOrderBy([['origem_captura','interessado_signature']]);
        
        $data['contFace']      = count($this->admin_model->getCapturasOrderBy([['origem_captura','interessado_signature'],['mensagem','facebook']]));
        $data['contLand']      = count($this->admin_model->getCapturasOrderBy([['origem_captura','interessado_signature'],['mensagem','']]));
        $data['contFaceAtivo'] = count($this->admin_model->getCapturasOrderBy([['origem_captura','interessado_signature'],['mensagem','facebook'],['status_captura',3]]));
        $data['contLandAtivo'] = count($this->admin_model->getCapturasOrderBy([['origem_captura','interessado_signature'],['mensagem',''],['status_captura',3]]));

        $new_cap = [];
        $time_line = [];
        foreach ($capturas as $cap)
        {
            //$cap->atendimento = $this->admin_model->getAtendimentoHistoricoDesc([['email',$cap->email]]);

            $w = [];
            $w[] = [['id_campanha', 50],['id_campanha', 57]];
            //$w[] = ['id_campanha', 45];
            $w[] = ['email', $cap->email];
            $logs = $this->admin_model->get_log_emails($w); 
            
            $cap->abriu_email = 'Não';
            $cap->clicou_email = 'Não';
            $logenviado = false;
            $line = [];
            foreach ($logs as $log)
            {
                if($log->enviado >= 1){
                    $logenviado = true;
                }
                    
                if($log->abriu_em != '0000-00-00 00:00:00'){
                    $log->abriu_em = date('d/m/Y H:i:s', strtotime($log->abriu_em));
                }
                    
                if($log->abriu > 0){
                    $log->abriu_email = '<span class="badge badge-success">Sim em '.$log->abriu_em.'</span>';
                }else{
                    $log->abriu_email = '<span class="badge badge-danger">Não</span>';
                }
                if($log->clicou > 0){
                    $log->clicou_email = '<span class="badge badge-success">Sim</span>';
                }else{
                    $log->clicou_email = '<span class="badge badge-danger">Não</span>';
                }
                if($log->id_campanha == 50){
                    $log->campanha = 'Email - Exclusive cadastro';
                }elseif($log->id_campanha == 57){
                    $log->campanha = 'Email - Exclusive estilizar projeto';
                }
                $log->enviado_em = date('d/m/Y H:i:s', strtotime($log->enviado_em));
                
                $line[] = $log;

            }
            
            if($logenviado == false)
                    $cap->datetime_captura = '<span class="badge badge-danger">Não enviado</span>';
                    
            $new_cap[$cap->email] = $cap;
            $time_line[$cap->email][] = $line;
            $new_cap[$cap->email]->atendimento = $this->admin_model->getAtendimentoHistoricoDesc([['email',$cap->email]]);
            $new_cap[$cap->email]->time_line = $time_line[$cap->email];
        }
        
        
        
        Assets::add_module_js('administrativo', array(
            'atendimento',
            'main'
        ));
        
        $data['capturas'] = (object)$new_cap;
        Template::set($data);
        Template::set_view('administrativo/exclusive/dashboard_view');
        Template::render();
    }
	
	function exclusive_projeto()
	{
        $this->ini_method();
        $result = [];
        
        $capturas = $this->admin_model->getCapturasOrderBy([['origem_captura','interessado_signature'], ['status_captura',5]]);
        
        /*$data['contFace']      = count($this->admin_model->getCapturasOrderBy([['origem_captura','interessado_elleven'],['mensagem','facebook']]));
        $data['contLand']      = count($this->admin_model->getCapturasOrderBy([['origem_captura','interessado_elleven'],['mensagem','']]));
        $data['contFaceAtivo'] = count($this->admin_model->getCapturasOrderBy([['origem_captura','interessado_elleven'],['mensagem','facebook'],['status_captura',3]]));
        $data['contLandAtivo'] = count($this->admin_model->getCapturasOrderBy([['origem_captura','interessado_elleven'],['mensagem',''],['status_captura',3]]));*/
        
        foreach ($capturas as $cap)
        {
            $cap->atendimento = $this->admin_model->getAtendimentoHistoricoDesc([['email',$cap->email]]);
        }
        
        $this->dataTables();
        
        Assets::add_module_js('administrativo', array(
            'atendimento',
            'main'
        ));
        
        $data['capturas'] = $capturas;
        
        Template::set($data);
        Template::set_view('administrativo/exclusive/projeto_view');
        Template::render();
    }
    
    function liberty()
	{
        $this->ini_method();
        $result = [];
        
        $capturas = $this->admin_model->getCapturasOrderBy([['origem_captura','interessado_liberty']]);
        
        
        $data['contCapturas']  = count($this->admin_model->getCapturasOrderBy([['origem_captura','interessado_liberty']]));
        $data['contVisitas']    = count($this->admin_model->getCapturasOrderBy([['origem_captura','interessado_liberty'],['data_agenda !=','0000-00-00']]));
        $data['contSimulacoes'] = 0;
        
        foreach ($capturas as $cap)
        {
            $cap->atendimento = $this->admin_model->getAtendimentoHistoricoDesc([['email',$cap->email],['tipo_interesse','Liberty']   ]);
           
            
            $cad = $this->admin_model->get_cadastro([['email',$cap->email]]);
            
            $cap->cadastro      = 'Não';
            $cap->financiamento = 'Não';
            $cap->valor = 0.0;
            
            
            
            if($cad != null){
                
                $where[]    =   ['id_imovel',0];
                $where[]    =   ['id_cad_dono', 0];
                $where[]    =   ['id_cad_interessado',$cad->id_cadastro];
                $where[]    =   ['origem_financiamento','lp_liberty'];
                $where[]    =   ['cpf',$cap->cpf];
                $where[]    =   ['data_simulacao >',$cap->datetime_captura];
                
                $financiamentos = $this->admin_model->getSimulacoes($where);
                
                $cap->simulacao = $financiamentos;
                
                $cap->cadastro = '<span class="badge badge-warning">Incompleto</span>';
                if($cad->etapa >= 8)
                   $cap->cadastro = '<span class="badge badge-success">Completo</span>';
               
                if(!empty($financiamentos))
                {
                    $simulacaoConcluida = false;
                     
                    $cap->financiamento = '<span class="badge badge-warning">Incompleto</span>';
                    $c = 0;
                    
                    foreach ($financiamentos as $simulacao)
                    {
                        if($simulacao->step >= 4)
                        {
                            $c++;
                            $n = ($c>1)?$c.'-':'';
                            $s = ($c>1)?'s':'';
                            
                            $cap->financiamento = '<span class="badge badge-success">'.$n.'Completo'.$s.'</span>';
                            $simulacaoConcluida = true;
                            
                            if($simulacao->val_imovel > $cap->valor)
                                $cap->valor = $simulacao->val_imovel;
                        }
                            
                    }
                    if($simulacaoConcluida)
                        $data['contSimulacoes']++;
                }
            }
        }
        
        $this->dataTables();
        
        Assets::add_module_js('administrativo', array(
            'main',
            'atendimento',
            'financiamento'
        ));
        
        $data['capturas'] = $capturas;
        
        Template::set($data);
        Template::set_view('administrativo/liberty/dashboard_view');
        Template::render();
		    
    }
    
	function signature()
	{
        $this->ini_method();
        
        $capturas = $this->admin_model->getCapturasOrderBy([['origem_captura','interessado_signature']]);
        foreach ($capturas as $cap)
        {
            $cap->atendimento = $this->admin_model->getAtendimentoHistoricoDesc([['email',$cap->email],['tipo_interesse','Signature']]);
        }
        
        $data['capturas']      = $capturas;
        $data['contLand']      = count($this->admin_model->getCapturasOrderBy([['origem_captura','interessado_signature'],['mensagem','']]));
        $data['contLandAtivo'] = count($this->admin_model->getCapturasOrderBy([['origem_captura','interessado_signature'],['mensagem',''],['status_captura',3]]));
        
        
        $this->dataTables();
        
        Assets::add_module_js('administrativo', array(
            'atendimento',
            'main'
        ));
        
        Template::set($data);
        Template::set_view('administrativo/signature/dashboard_view');
        Template::render();
    }
	
	/*function contatos()
	{
        $this->ini_method();
        
        $contatos = $this->admin_model->getContatos();
         
        foreach ($contatos as $contato)
        {
            $contato->atendimento  = $this->admin_model->getAtendimentoHistoricoDesc([['id_rel',$contato->id],['tb_origem','cad_contato'],['tipo_interesse','Contato']]);
            $contato->cadastro  = $this->admin_model->getCadastro([['email',$contato->email]]);
            
            $contato->data_atendimento = [
                'id_rel'    => $contato->id, 
                'tb_origem' => 'cad_contato',
                'nome'      => $contato->nome,
                'telefone'  => $contato->telefone,
            ];
            
            $contato->id_rel = $contato->id;
            $contato->tb_origem = 'cad_contato';
        }
        
        $this->dataTables();
        
        Assets::add_module_js('administrativo', array(
            'main',
            'atendimento'
        ));
        
        $data['contatos'] = $contatos;
        
        Template::set($data);
        Template::set_view('administrativo/contatos/dashboard_view');
        Template::render();
    }*/
	
	function financiamento()
	{
        $this->ini_method();
        $result = [];
        
        $capturas = $this->admin_model->getCapturasOrderBy([['origem_captura','financiamento']]);
        
        $data['contCapturas']  = count($this->admin_model->getCapturasOrderBy([['origem_captura','financiamento']]));
        $data['contVer']       = count($this->admin_model->getCapturasOrderBy([['origem_captura','financiamento'],['mensagem','verimoveis']]));
        $data['contSolicitar'] = count($this->admin_model->getCapturasOrderBy([['origem_captura','financiamento'],['mensagem','solicitarproposta']]));
        $data['contSimulacoes'] = 0;
        
        foreach ($capturas as $cap)
        {
            $cap->atendimento = $this->admin_model->getAtendimentoHistoricoDesc([['email',$cap->email],['tipo_interesse','Financiamento']  ]);
            
         
            $cad = $this->admin_model->get_cadastro([['email',$cap->email]]);
            
            $cap->cadastro      = 'Não';
            $cap->financiamento = 'Não';
            $cap->valor = 0.0;
            if($cad != null){
                $financiamentos = $this->admin_model->getSimulacoes([['id_imovel',0],['id_cad_dono', 0],['id_cad_interessado',$cad->id_cadastro]]);
                
                $cap->simulacao = $financiamentos;
                
                $cap->cadastro = '<span class="badge badge-warning">Incompleto</span>';
                if($cad->etapa >= 8)
                   $cap->cadastro = '<span class="badge badge-success">Completo</span>';
               
                if(!empty($financiamentos))
                {
                    $simulacaoConcluida = false;
                     
                    $cap->financiamento = '<span class="badge badge-warning">Incompleto</span>';
                    $c = 0;
                    foreach ($financiamentos as $simulacao)
                    {
                        if($simulacao->step >= 4)
                        {
                            $c++;
                            $n = ($c>1)?$c.'-':'';
                            $s = ($c>1)?'s':'';
                            
                            $cap->financiamento = '<span class="badge badge-success">'.$n.'Completo'.$s.'</span>';
                            $simulacaoConcluida = true;
                            
                            if($simulacao->val_imovel > $cap->valor)
                                $cap->valor = $simulacao->val_imovel;
                        }
                            
                    }
                    if($simulacaoConcluida)
                        $data['contSimulacoes']++;
                }
            }
        }
        
        
        
        $this->dataTables();
        
        Assets::add_module_js('administrativo', array(
            'main',
            'atendimento',
            'financiamento'
        ));
        
        $data['capturas'] = $capturas;
        
        Template::set($data);
        Template::set_view('administrativo/financiamento/dashboard_view');
        Template::render();
		    
    }
    
    function financiamento_imovel()
	{
        $this->ini_method();
        
        $simulacoes = $this->admin_model->getSimulacoes([['fnc_simulacao.id_imovel >',0]]);//,['fnc_simulacao.step >=',4]
         
        foreach ($simulacoes as $sim)
        {
            $sim->interessado  = $this->admin_model->get_cadastro([],$sim->id_cad_interessado);
            $sim->dono         = $this->admin_model->get_cadastro([],$sim->id_cad_dono);
            $sim->imovel       = $this->admin_model->getImovel([['a.id_imovel',$sim->id_imovel]]);
            $sim->atendimento  = $this->admin_model->getAtendimentoHistoricoDesc([['id_rel',$sim->id_simulacao],['tb_origem','fnc_simulacao'],['tipo_interesse','Financiamento']]);
            
            $sim->data_atendimento = [
                'id_rel'    => $sim->id_simulacao, 
                'tb_origem' => 'fnc_simulacao',
                'nome'      => $sim->interessado->nome,
                'telefone'  => $sim->interessado->telefone,
            ];
            
            


            
            $sim->interessado->id_rel = $sim->id_simulacao;
            $sim->interessado->tb_origem = 'fnc_simulacao';
        }
        
        $this->dataTables();
        
        Assets::add_module_js('administrativo', array(
            'main',
            'atendimento',
            'financiamento'
        ));
        
        $data['simulacoes'] = $simulacoes;
        
        Template::set($data);
        Template::set_view('administrativo/financiamento/dashboard_imovel_view');
        Template::render();
		    
    }
    
    /*function lancamentos()
	{
        $this->ini_method();
        $result = [];
        
        $capturas = $this->admin_model->getCapturasOrderBy([['origem_captura','interessado_liberty']]);
        
        
        $data['contCapturas']  = count($this->admin_model->getCapturasOrderBy([['origem_captura','interessado_liberty']]));
        $data['contVisitas']    = count($this->admin_model->getCapturasOrderBy([['origem_captura','interessado_liberty'],['data_agenda !=','0000-00-00']]));
        $data['contSimulacoes'] = 0;
        
        foreach ($capturas as $cap)
        {
            $cap->atendimento = $this->admin_model->getAtendimentoHistoricoDesc([['email',$cap->email],['tipo_interesse','Liberty']   ]);
           
            
            $cad = $this->admin_model->get_cadastro([['email',$cap->email]]);
            
            $cap->cadastro      = 'Não';
            $cap->financiamento = 'Não';
            $cap->valor = 0.0;
            
            
            
            if($cad != null){
                
                $where[]    =   ['id_imovel',0];
                $where[]    =   ['id_cad_dono', 0];
                $where[]    =   ['id_cad_interessado',$cad->id_cadastro];
                $where[]    =   ['origem_financiamento','lp_liberty'];
                $where[]    =   ['cpf',$cap->cpf];
                $where[]    =   ['data_simulacao >',$cap->datetime_captura];
                
                $financiamentos = $this->admin_model->getSimulacoes($where);
                
                $cap->simulacao = $financiamentos;
                
                $cap->cadastro = '<span class="badge badge-warning">Incompleto</span>';
                if($cad->etapa >= 8)
                   $cap->cadastro = '<span class="badge badge-success">Completo</span>';
               
                if(!empty($financiamentos))
                {
                    $simulacaoConcluida = false;
                     
                    $cap->financiamento = '<span class="badge badge-warning">Incompleto</span>';
                    $c = 0;
                    
                    foreach ($financiamentos as $simulacao)
                    {
                        if($simulacao->step >= 4)
                        {
                            $c++;
                            $n = ($c>1)?$c.'-':'';
                            $s = ($c>1)?'s':'';
                            
                            $cap->financiamento = '<span class="badge badge-success">'.$n.'Completo'.$s.'</span>';
                            $simulacaoConcluida = true;
                            
                            if($simulacao->val_imovel > $cap->valor)
                                $cap->valor = $simulacao->val_imovel;
                        }
                            
                    }
                    if($simulacaoConcluida)
                        $data['contSimulacoes']++;
                }
            }
        }
        
        Assets::add_css(array(
            '../comdono/plugins/dataTables/css/dataTables.bootstrap4.min',
        ));
        
        Assets::add_js(array(
            '../comdono/plugins/dataTables/js/jquery.dataTables.min',
            '../comdono/plugins/dataTables/js/dataTables.bootstrap4.min',
            '../comdono/plugins/dataTables/js/dataTables.buttons.min.js',
            '../comdono/plugins/dataTables/js/buttons.flash.min.js',
            '../comdono/plugins/dataTables/js/jszip.min.js',
            '../comdono/plugins/dataTables/js/vfs_fonts.js',
            '../comdono/plugins/dataTables/js/buttons.html5.min.js',
            '../comdono/plugins/dataTables/js/config'
        ));
        
        Assets::add_module_js('administrativo', array(
            'main',
            'atendimento',
            'financiamento'
        ));
        
        $data['capturas'] = $capturas;
        
        Template::set($data);
        Template::set_view('administrativo/lancamento/dashboard_view');
        Template::render();
		    
    }*/
    function permissoes()
	{
        try{
		    $this->ini_method();
			$crud = new grocery_CRUD();
			$this->valida_acoes($crud);
		
			
			$stateInfo = $crud->getStateInfo();
			$state = $crud->getState();
			
			$crud->set_table('cad_atendimento_permissao');
			$crud->set_subject('permissoes');
		    
		    $crud->set_relation('id_cadastro','cad_cadastro','nome');
			
			$output = $crud->render();
			$this->_example_output($output);
			
		}catch(Exception $e){
			show_error($e->getMessage().' --- '.$e->getTraceAsString());
		}
	}
	
	public function dataTables(){
	    Assets::add_css(array(
            '../comdono/plugins/dataTables/css/dataTables.bootstrap4.min',
        ));
        
        Assets::add_js(array(
            '../comdono/plugins/dataTables/js/jquery.dataTables.min',
            '../comdono/plugins/dataTables/js/dataTables.bootstrap4.min',
            '../comdono/plugins/dataTables/js/dataTables.buttons.min.js',
            '../comdono/plugins/dataTables/js/buttons.flash.min.js',
            '../comdono/plugins/dataTables/js/jszip.min.js',
            '../comdono/plugins/dataTables/js/vfs_fonts.js',
            '../comdono/plugins/dataTables/js/buttons.html5.min.js',
            '../comdono/plugins/dataTables/js/config'
        ));
	}
    
}