<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

include_once GROCERY_CRUD;

class Design_system extends Grocery {

    function __construct() 
    {
        parent::__construct();
		$this->load->model('administrativo/admin_model');
    }
    
    public function categorias() 
    {
        
        try{
		    $this->ini_method();
		    
			$crud = new grocery_CRUD();

			$this->valida_acoes($crud);
			
			$crud->set_theme('bootstrap');
			$crud->set_table('des_categorias');
			$crud->set_subject('Categorias'); 
		    
			$stateInfo = $crud->getStateInfo();
			$state = $crud->getState();
			$output = $crud->render();
			$this->_example_output($output);
			
		}catch(Exception $e){
			show_error($e->getMessage().' --- '.$e->getTraceAsString());
		}
    } 
    
    public function conteudos() 
    {
        
        try{
		    $this->ini_method();
		    
			$crud = new grocery_CRUD();

			$this->valida_acoes($crud);
			
			$crud->set_theme('bootstrap');
			$crud->set_table('des_conteudos');
			$crud->set_subject('Conteúdos'); 
			
			$crud->set_relation('id_cat','des_categorias','categoria');
			
			$crud->columns(['id_conteudo','id_cat','titulo']);
			$crud->required_fields('id_cat','titulo','titulo_descricao','codigo');
			
			$crud->unset_texteditor('codigo','full_text');
			
			$crud->callback_field('codigo',array($this,'field_callback_codigo'));
		    
			$stateInfo = $crud->getStateInfo();
			$state = $crud->getState();
			$output = $crud->render();
			$this->_example_output($output);
			
		}catch(Exception $e){
			show_error($e->getMessage().' --- '.$e->getTraceAsString());
		}
        
    }
    
    function field_callback_codigo($value = '', $primary_key = null)
    {
        return '<textarea name="codigo" class="form-control" row="10" style="height: 200px;">'.$value.'</textarea>';
    }
}