<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
	
include_once GROCERY_CRUD;

class Imoveis extends Grocery{
	
	protected $crud;
	function __construct()
	{
		parent::__construct();
		$this->load->model('administrativo/admin_model');
		
	}
	
	function ativos()
	{			
		try{
		    $this->ini_method();
		    
			$crud = new grocery_CRUD();

			$this->valida_acoes($crud);
			
			$crud->set_theme('bootstrap');
			$crud->set_table('cad_imovel');
			$crud->set_subject('Imóveis');
			$crud->where('status', 3);
			$crud->where('lixeira', 0);
			$crud->where('id_imovel_rel', 0);
			
			//`id_imovel`, `id_imovel_rel`, `id_cadastro`, `key_anuncio`, `unidade`, `id_localizacao`, `step`, `status`, `status_lancamento`, `tipo_empreendimento`, `lixeira`, `status_hipoteca`, `doc_perfil`, `dados_perfil`, `dn_nome_nomefantasia`, `dn_razao_social`, `dn_telefone`, `dn_email`, `dn_cpf_cnpj`, `dn_img`, `dn_img_uri`, `tipo_imovel`, `lancamento`, `previsao_entrega`, `imovel_novo`, `importar_planilha`, `dn_razao_social-lixo`, `dn_telefone_empresa`, `dn_cnpj`, `dn_cep`, `dn_endereco`, `dn_numero`, `dn_complemento`, `dn_bairro`, `dn_cidade`, `dn_estado`, `aceita_corretor`, `aceita_imobiliaria`, `cep`, `endereco`, `numero`, `complemento`, `bairro`, `cidade`, `estado`, `longitude`, `latitude`, `bairro_lat`, `bairro_long`, `quadra_lat`, `quadra_long`, `conjunto_lat`, `conjunto_long`, `area_privativa`, `area_total`, `quartos`, `suites`, `banheiros`, `andar`, `vaga`, `posicao_sol`, `num_matricula`, `chk_termo`, `imovel_canto`, `doc_propriedade`, `doc_planilha`, `cobertura_privativa`, `armarios_planejados`, `armarios_cozinha`, `box_blindex`, `quarto_extra_reversivel`, `ar_condicionado`, `armarios_embutidos_quarto`, `armarios_banheiro`, `quarto_servico`, `varanda`, `dce`, `caracteristicas`, `academia`, `elevador`, `lavanderia`, `playground`, `salao_festa`, `churrasqueira`, `espaco_gourmet`, `piscina`, `quadra_esportiva`, `sauna`, `cobertura`, `estacionamento_rotativo`, `wifi`, `porteiro_24h`, `acessibilidade`, `val_pretendido`, `val_public_total`, `val_public_total_metro`, `val_condominio`, `val_iptu`, `fotos_profissionais`, `melhor_horario`, `tour_virtual`, `visualizacoes`, `data_hora_imovel`, `timestamp_imovel`
			
			$crud->display_as('lancamento','Empreendimento');
			$crud->display_as('data_hora_imovel','Hora Cadastro');
			$crud->display_as('timestamp_imovel','Ultima edição');
			$crud->columns(['id_imovel','id_cadastro','lancamento','dn_nome_nomefantasia','dn_telefone','tipo_imovel','val_pretendido','bairro','endereco','data_hora_imovel']);
			
		    $this->add_actions($crud);
			
		    Assets::add_module_js('administrativo',['imoveis']);
			
			$stateInfo = $crud->getStateInfo();
			$state = $crud->getState();
			
			$output = $crud->render();
			
			$this->_example_output($output);
			
		}catch(Exception $e){
			show_error($e->getMessage().' --- '.$e->getTraceAsString());
		}
	}
	
	function cadastros()
	{			
		try{
		    $this->ini_method();
		    
			$crud = new grocery_CRUD();

			$this->valida_acoes($crud);
			
			$crud->set_theme('bootstrap');
			$crud->set_table('cad_imovel');
			$crud->set_subject('Imóveis');
			//$crud->where('status <', 4);
			//$crud->where('id_imovel_rel', 0);
			
			//`id_imovel`, `id_imovel_rel`, `id_cadastro`, `key_anuncio`, `unidade`, `id_localizacao`, `step`, `status`, `status_lancamento`, `tipo_empreendimento`, `lixeira`, `status_hipoteca`, `doc_perfil`, `dados_perfil`, `dn_nome_nomefantasia`, `dn_razao_social`, `dn_telefone`, `dn_email`, `dn_cpf_cnpj`, `dn_img`, `dn_img_uri`, `tipo_imovel`, `lancamento`, `previsao_entrega`, `imovel_novo`, `importar_planilha`, `dn_razao_social-lixo`, `dn_telefone_empresa`, `dn_cnpj`, `dn_cep`, `dn_endereco`, `dn_numero`, `dn_complemento`, `dn_bairro`, `dn_cidade`, `dn_estado`, `aceita_corretor`, `aceita_imobiliaria`, `cep`, `endereco`, `numero`, `complemento`, `bairro`, `cidade`, s`estado`, `longitude`, `latitude`, `bairro_lat`, `bairro_long`, `quadra_lat`, `quadra_long`, `conjunto_lat`, `conjunto_long`, `area_privativa`, `area_total`, `quartos`, `suites`, `banheiros`, `andar`, `vaga`, `posicao_sol`, `num_matricula`, `chk_termo`, `imovel_canto`, `doc_propriedade`, `doc_planilha`, `cobertura_privativa`, `armarios_planejados`, `armarios_cozinha`, `box_blindex`, `quarto_extra_reversivel`, `ar_condicionado`, `armarios_embutidos_quarto`, `armarios_banheiro`, `quarto_servico`, `varanda`, `dce`, `caracteristicas`, `academia`, `elevador`, `lavanderia`, `playground`, `salao_festa`, `churrasqueira`, `espaco_gourmet`, `piscina`, `quadra_esportiva`, `sauna`, `cobertura`, `estacionamento_rotativo`, `wifi`, `porteiro_24h`, `acessibilidade`, `val_pretendido`, `val_public_total`, `val_public_total_metro`, `val_condominio`, `val_iptu`, `fotos_profissionais`, `melhor_horario`, `tour_virtual`, `visualizacoes`, `data_hora_imovel`, `timestamp_imovel`
			
			$crud->display_as('lancamento','Empreendimento');
			$crud->display_as('data_hora_imovel','Hora Cadastro');
			$crud->display_as('timestamp_imovel','Ultima edição');
			$crud->columns(['id_imovel','id_cadastro','lancamento','dn_nome_nomefantasia','dn_telefone','tipo_imovel','val_pretendido','bairro','endereco','data_hora_imovel','status']);
			
			$crud->callback_column('status',array($this,'_callback_webpage_url'));
			
			
			
			
		    $this->add_actions($crud);
			
		    Assets::add_module_js('administrativo',['imoveis']);
			
			$stateInfo = $crud->getStateInfo();
			$state = $crud->getState();
			
			$output = $crud->render();
			
			$this->_example_output($output);
			
		}catch(Exception $e){
			show_error($e->getMessage().' --- '.$e->getTraceAsString());
		}
	}
	
	function crud()
	{			
		try{
		    $this->ini_method();
			$crud = new grocery_CRUD();
			$this->valida_acoes($crud);
			
			$crud->set_theme('bootstrap');
			$crud->set_table('cad_imovel');
			$crud->set_subject('Imóveis');
			//$crud->where('id_imovel_rel', 0);
			
			//`id_imovel`, `id_imovel_rel`, `id_cadastro`, `key_anuncio`, `unidade`, `id_localizacao`, `step`, `status`, `status_lancamento`, `tipo_empreendimento`, `lixeira`, `status_hipoteca`, `doc_perfil`, `dados_perfil`, `dn_nome_nomefantasia`, `dn_razao_social`, `dn_telefone`, `dn_email`, `dn_cpf_cnpj`, `dn_img`, `dn_img_uri`, `tipo_imovel`, `lancamento`, `previsao_entrega`, `imovel_novo`, `importar_planilha`, `dn_razao_social-lixo`, `dn_telefone_empresa`, `dn_cnpj`, `dn_cep`, `dn_endereco`, `dn_numero`, `dn_complemento`, `dn_bairro`, `dn_cidade`, `dn_estado`, `aceita_corretor`, `aceita_imobiliaria`, `cep`, `endereco`, `numero`, `complemento`, `bairro`, `cidade`, s`estado`, `longitude`, `latitude`, `bairro_lat`, `bairro_long`, `quadra_lat`, `quadra_long`, `conjunto_lat`, `conjunto_long`, `area_privativa`, `area_total`, `quartos`, `suites`, `banheiros`, `andar`, `vaga`, `posicao_sol`, `num_matricula`, `chk_termo`, `imovel_canto`, `doc_propriedade`, `doc_planilha`, `cobertura_privativa`, `armarios_planejados`, `armarios_cozinha`, `box_blindex`, `quarto_extra_reversivel`, `ar_condicionado`, `armarios_embutidos_quarto`, `armarios_banheiro`, `quarto_servico`, `varanda`, `dce`, `caracteristicas`, `academia`, `elevador`, `lavanderia`, `playground`, `salao_festa`, `churrasqueira`, `espaco_gourmet`, `piscina`, `quadra_esportiva`, `sauna`, `cobertura`, `estacionamento_rotativo`, `wifi`, `porteiro_24h`, `acessibilidade`, `val_pretendido`, `val_public_total`, `val_public_total_metro`, `val_condominio`, `val_iptu`, `fotos_profissionais`, `melhor_horario`, `tour_virtual`, `visualizacoes`, `data_hora_imovel`, `timestamp_imovel`
			
			$crud->display_as('lancamento','Empreendimento');
			$crud->display_as('data_hora_imovel','Hora Cadastro');
			$crud->display_as('timestamp_imovel','Ultima edição');
			$crud->columns(['id_imovel','id_cadastro','lancamento','dn_nome_nomefantasia','dn_telefone','tipo_imovel','val_pretendido','bairro','endereco','data_hora_imovel','status']);
			
			$crud->callback_column('status',array($this,'_callback_webpage_url'));
			
			$crud->add_action('Detalhes', '','administrativo/dashboard/imovel','fa fa-cog');
		
			
			
		    //$this->add_actions($crud);
			
		    Assets::add_module_js('administrativo',['imoveis']);
			
			$stateInfo = $crud->getStateInfo();
			$state = $crud->getState();
			
			$output = $crud->render();
			
			$this->_example_output($output);
			
		}catch(Exception $e){
			show_error($e->getMessage().' --- '.$e->getTraceAsString());
		}
	}
	
	function moderacao()
	{			
		try{
		    $this->ini_method();
		    
			$crud = new grocery_CRUD();

			$this->valida_acoes($crud);
			
			$crud->set_theme('bootstrap');
			$crud->set_table('cad_imovel');
			$crud->set_subject('Imóveis');
			$crud->where('status', 2);
			$crud->where('id_imovel_rel', 0);
			$crud->columns(['id_imovel','id_cadastro','lancamento','dn_nome_nomefantasia','dn_telefone','tipo_imovel','val_pretendido','bairro','endereco','data_hora_imovel']);
			
		    $this->add_actions($crud);
			
			$stateInfo = $crud->getStateInfo();
			$state = $crud->getState();
			
			$output = $crud->render();
			
			$this->_example_output($output);
			
		}catch(Exception $e){
			show_error($e->getMessage().' --- '.$e->getTraceAsString());
		}
	}
	
	function solicitacao_de_fotos()
	{			
					
		try{
		    $this->ini_method();
		    
			$crud = new grocery_CRUD();

			$this->valida_acoes($crud);
			
			$crud->set_theme('bootstrap');
			$crud->set_table('cad_imovel');
			$crud->set_subject('Imóveis aguardando fotos');
			//$crud->where('status', 3);
			
			
			$crud->where('id_imovel_rel', 0);
			
			
			/*$imoveis = $this->admin_model->getImoveis(['status >' => 1],false);
			foreach($imoveis as $imovel)
			    if(empty($imovel->imagens))
			        $crud->or_where('id_imovel', $imovel->id_imovel);
			*/
			
			
			$crud->columns(['id_imovel', 'id_cadastro','lancamento','dn_nome_nomefantasia','dn_telefone','val_pretendido','bairro','endereco','status']);
		    $this->add_actions($crud);
			
			
			
		    Assets::add_module_js('administrativo',['imoveis']);
			
			$stateInfo = $crud->getStateInfo();
			$state = $crud->getState();
			
			$output = $crud->render();
			
			$this->_example_output($output);
			
		}catch(Exception $e){
			show_error($e->getMessage().' --- '.$e->getTraceAsString());
		}
	}
	
	
	
	function inativos()
	{			
					
		try{
		    $this->ini_method();
		    
			$crud = new grocery_CRUD();

			$this->valida_acoes($crud);
			
			$crud->set_theme('bootstrap');
			$crud->set_table('cad_imovel');
			$crud->set_subject('Imóveis');
			$crud->where('status', 4);
			$crud->where('id_imovel_rel', 0);
			
			//$crud->columns(['id_imovel','lancamento','dn_nome_nomefantasia','dn_telefone','tipo_imovel','val_pretendido','bairro','endereco','status']);
			$crud->columns(['id_imovel','id_cadastro','lancamento','dn_nome_nomefantasia','dn_telefone','tipo_imovel','val_pretendido','bairro','endereco','data_hora_imovel','status']);
			
		    $this->add_actions($crud);
		    
			$stateInfo = $crud->getStateInfo();
			$state = $crud->getState();
			
			$output = $crud->render();
			
			$this->_example_output($output);
			
		}catch(Exception $e){
			show_error($e->getMessage().' --- '.$e->getTraceAsString());
		}
	
	}
	
	
	
	public function _callback_webpage_url($value, $row)
    {
      return "<span class='badge ".HImovel::getStatus($value)->bdg."'>".HImovel::getStatus($value)->text."</span>";
    }
	
	
	private function add_actions($crud)
	{
	    $stateInfo = $crud->getStateInfo();
	    $state = $crud->getState();
	    
	    if($state == "edit")
	    {
	        $imovel = $this->admin_model->getImovel([['a.id_imovel',$stateInfo->primary_key]]);
	        
	        if($imovel->lancamento == 'Sim')
	            redirect('administrativo/imoveis/lancamento/'.$imovel->id_imovel);
	        else
	            redirect('administrativo/braco_direito/edit/'.$imovel->id_imovel);
	    }
	    Assets::add_module_js('administrativo',['imoveis']);

		$crud->add_action('Detalhes/Moderação', '','administrativo/dashboard/imovel','fa fa-cog');
	    //$crud->add_action('Aprovar', '','prontuario/imoveis/ativos','fa fa-check aceitarAnuncio');
		//$crud->add_action('Negar', '','prontuario/imoveis/ativos','fa fa-ban negarAnuncio');
		//$crud->add_action('Moderar', '','prontuario/imoveis/ativos','fa fa-hourglass-end moderarAnuncio');
		$crud->add_action('Visualizar', '','imovel','fa fa-eye verAnuncio');
		//$crud->add_action('Detalhes', '', '','icon-diamond',[$this,'link_ver_perfil']);
		//$crud->add_action('Perfil', '', '','icon-people',[$this,'link_ver_perfil']);
		
		$crud->unset_read();
	}
	
	
	function link_ver_perfil($primary_key , $row)
    {
        $imovel = $this->admin_model->getImovel([['a.id_imovel',$primary_key]]);
        return base_url('administrativo/usuarios/perfil/'.$imovel->id_cadastro);
    }
	
	public function edit()
	{
        $uri = $this->uri->segment_array();
        $id_imovel = $uri[4];
        if($id_imovel == null)
            redirect('administrativo/imoveis/ativos/');
        
        
            
        $data['imovel'] = $this->admin_model->getImovel([['a.id_imovel',$id_imovel]]); 
        if($data['imovel'] == null)
            redirect('administrativo/imoveis/ativos/');
        
        $data['step'] = 1;
            if($uri[5]??false && ($uri[5] <= 8 || $uri[5] >= 1)){
                $data['step'] = $uri[5];
            }
            
        $data['meuCadastro'] = json_encode([]);//$this->cad_model->get_cadastro());
        
        
        
            
            /*$data['imagens'] = $this->cad_model->getImgsImovel($data['imovel']->id_imovel);
            if(!empty($data['imagens']) && $data['imagens'] !== null){ 
                $data['img_base'] = base_url('modules/anunciante/'.$data['imovel']->id_cadastro.'/'.$data['imovel']->id_imovel.'/galeria/');
            }*/
            
            $data['tiposImovel'] = HBusca::getSelectTiposImovel();
            $data['imoveis_rel'] = [];//$this->cad_model->getImoveis(['id_imovel_rel' => $data['imovel']->id_imovel ]); 
            
            //$data['arrayImovel'] = HImovel::getDetalhesImovel($data['imovel']);
            //$data['arrayCondominio'] = HImovel::getDetalhesComdominio($data['imovel']);
            
            //Template::load_view('comdono/termos_view', '', '', '', $data['termos']);
            
            $this->set_imovel_css_js();
            Assets::add_module_js('comdono', array(
                'upload_fotos_sortable',
                'initGoogleMaps',
                'config-ckeditor',
                'cadastro_imovel',
                'cadastro_imovel_front',
            ));
            
            $data['edit'] = true;
            $data['textTitulo'] = 'Editar Imóvel';
            Template::set($data);
            Template::set_view('comdono/cadastro_imovel_view');
            Template::render();
        
    
	}
	
	
	function setViewLancamento($data)
	{
	    //$data['simulacao'] = $this->admin_model->getSimulacao([['id_simulacao',$data['id_simulacao']]]);
	    //$data['interessado'] = $this->admin_model->get_cadastro([], $data['simulacao']->id_cad_interessado); 
	    $data['imovel'] = $this->admin_model->getImovel([['a.id_imovel',$data['id_imovel'] ]]);
	    
	    $data['imoveis'] = $this->admin_model->getImoveis([    ['a.id_imovel',$data['id_imovel']],['a.id_imovel_rel',$data['id_imovel']]        ]);
	    Template::set_html_custom($data,'lancamento_view');
	}
	
	public function lancamento()
	{
		try{
		    
		   
		    
		    $this->ini_method('moderacao');
			$crud = new grocery_CRUD();
			$this->valida_acoes($crud);
			
			$id_imovel = $this->uri->segment(4);
        
            $w[] = ['a.id_imovel',$id_imovel];
            $lancamento = $this->admin_model->getImovel($w);
            
            //var_dump($lancamento);die();
            if($lancamento == null)            redirect('administrativo/imoveis/ativos');
            if($lancamento->id_imovel_rel != 0)    redirect('administrativo/imoveis/lancamento/'.$lancamento->id_imovel_rel);
			
			
			$crud->columns(['id_imovel','tipo_imovel','val_pretendido','status']);
			
			$crud->set_theme('bootstrap');
			$crud->set_table('cad_imovel');
			
			$crud->where('id_imovel', $id_imovel);
			$crud->or_where('id_imovel_rel', $id_imovel);
			
			
			$crud->set_subject('Lancamento');
			
			//$crud->callback_column('status_bcrel',array($this,'_callback_status_bcrel'));
			//$crud->callback_column('id_banco',array($this,'_callback_logo_banco'));
    		
    		$state = $crud->getState();
            $state_info = $crud->getStateInfo();
    		
    		$this->setViewLancamento([
    		    'id_imovel' => $id_imovel,
                'state' => $state,
                'state_info' => $state_info,
    		    ]);
    		
			$output = $crud->render();
			$this->_example_output($output);
			
		}catch(Exception $e){
			show_error($e->getMessage().' --- '.$e->getTraceAsString());
		}
	}
	
	public function xxx_lancamento()
    {
        $data['dashboard'] = TRUE;
        $data['item_mv'] = TRUE;
        $data['item_mv_anuncios'] = TRUE;
        $data['pgLancamento'] = TRUE;
        
        $id_imovel = $this->uri->segment(4);
        
        $w[] = ['a.id_imovel',$id_imovel];
        $lancamento = $this->admin_model->getImovel($w); 
        if($lancamento == null)            redirect('administrativo/imoveis/ativos');
        if($lancamento->id_imovel_rel != 0)    redirect('administrativo/imoveis/lancamento/'.$lancamento->id_imovel_rel);
        
        $where[] = ['status >', 1];
        $where[] = ['a.lixeira <', 2];
        $where[] = [['a.id_imovel', $id_imovel],['a.id_imovel_rel', $id_imovel]];
        
        
        $data['imoveis'] = $this->admin_model->getImoveis($where);
        
        $data['lancamento'] = $lancamento;
            
        Assets::add_css(array(
            'plugins/owlcarousel2-2.3.4/css/owl.carousel.min',
            'plugins/owlcarousel2-2.3.4/css/owl.theme.default.min',
            'plugins/dataTables/css/dataTables.bootstrap4.min',
        ));
        
        Assets::add_js(array(
            'plugins/owlcarousel2-2.3.4/js/owl.carousel.min',
            'plugins/dataTables/js/jquery.dataTables.min',
            'plugins/dataTables/js/dataTables.bootstrap4.min'
        ));
        
        Assets::add_module_js('comdono', array(
            'loading_image',
            'actions'
        ));
        
        Assets::add_module_js('minha_conta', array(
            /*'pagination',*/
            'anuncios',
            'dataTables'
            
        ));
        
        //$data['favoritos'] = $this->busca_model->get_favoritos();
        
        Template::set($data);
        //Template::set_view('anuncios_vendas_view');
        Template::set_view('minha_conta/anuncios_vendas_lancamento_view');
        Template::render();
    }
	
    public function edit_unidade()
    {
        
    }
    
    public function edit_lancamento()
    {
        
    }
	
	private function set_imovel_css_js()
    {
        Assets::add_css(array(
            'plugins/blueimp/css/jquery.fileupload',
            'plugins/blueimp/css/jquery.fileupload-ui',
            'plugins/blueimp/css/blueimp-gallery.min',
            'plugins/blueimp/css/custom',
            'plugins/unitegallery/css/unite-gallery',
            'plugins/unitegallery/css/ug-theme-default',
            'plugins/fancyBox-v3.5.7/css/jquery.fancybox.min'
        ));
        
        Assets::add_module_css('comdono', array(
            'cad_maps'
        ));
        
        Assets::add_js(array(
            'plugins/blueimp/js/jquery.ui.widget',
            'plugins/blueimp/js/tmpl.min',
            'plugins/blueimp/js/load-image.all.min',
            'plugins/blueimp/js/canvas-to-blob.min',
            'plugins/blueimp/js/blueimp-gallery.min',
            'plugins/blueimp/js/jquery.blueimp-gallery.min',
            'plugins/blueimp/js/jquery.iframe-transport',
            'plugins/blueimp/js/jquery.fileupload',
            'plugins/blueimp/js/jquery.fileupload-process',
            'plugins/blueimp/js/jquery.fileupload-image',
            'plugins/blueimp/js/jquery.fileupload-validate',
            'plugins/blueimp/js/jquery.fileupload-ui',
            'plugins/unitegallery/js/unitegallery.min',
            'plugins/unitegallery/js/ug-theme-default',
            'plugins/sortable/jquery-sortable.min',
            'plugins/unitegallery/js/imovel',
            'plugins/fancyBox-v3.5.7/js/jquery.fancybox.min',
            '../painel/plugins/ckeditor-4.6.2/ckeditor',
            '../painel/plugins/ckeditor-4.6.2/samples/js/sample',
            '../painel/plugins/ckeditor-4.6.2/adapters/jquery'
        ));
        
        
    } 
}