<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Negociacoes extends Admin_Controller {

    function __construct() 
    {
        parent::__construct();
		$this->load->model('administrativo/admin_model');
    }
    
    public function index()
    {
        $this->load->model("comdono/busca_model");
        $this->load->model("minha_conta/chat_model");
        
        //$data["imoveis"] = $this->chat_model->getChat([['a.id_cadastro',$this->session->id_cadastro],['chat_status',3]]);
        $data["imoveis"] = $this->chat_model->getChat();
        
        $bairros = [];
        
        $data['checkIdBairro'] = '';
        $data['checkIdImovel'] = $this->uri->segment(4);
        $data['checkIdChat'] = $this->uri->segment(5);
        
        foreach($data["imoveis"] as $id_imovel=>$imovel)
        {
            $bairros[$imovel->bairro][$id_imovel] = $imovel;
            if($id_imovel == $data['checkIdImovel'])
                $data['checkIdBairro'] = $imovel->bairro;
        }
        
        $data["bairros"] = $bairros;
        $data['usuarios_chat'] = $this->chat_model->getUsuariosChat();
        
        Assets::add_css(array(
            '../comdono/plugins/dataTables/css/dataTables.bootstrap4.min',
        ));
        
        Assets::add_js(array(
            '../comdono/plugins/dataTables/js/jquery.dataTables.min',
            '../comdono/plugins/dataTables/js/dataTables.bootstrap4.min',
            '../comdono/plugins/dataTables/js/config'
        ));
        
        Assets::add_module_js('administrativo', array(
            'negociacoes'
        ));
        
        Template::set($data); 
        Template::set_view('negociacoes_view');
        Template::render();
    }
    
    
    public function ex_index() 
    {
        Assets::add_module_js('administrativo', [
            'dashboard'
        ]);
            
	    //Template::set($data);
		Template::set_view('administrativo/dashboard_view');
		Template::render();
    } 
    
}