<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
//use Aws\Credentials\Credentials;
//use Aws\S3\S3Client;
//use Aws\S3\Exception\S3Exception;

class Incorporadora_ajax extends Admin_Controller {

    protected $statusBadgeEmpreendimento = [
	        'Aguardando envio'  => 'secondary',
	        'Enviada'           => 'primary',
	        'Aceita'            => 'success',
	        'Aguardando'        => 'warning',
	        'Negada'            => 'danger',
	    ];

	function __construct()
	{
        parent::__construct();
        require APPPATH . 'libraries/vendor/autoload.php';
        
        if(($this->session->perfil??0) == 0)
        {
	        echo json_encode(['valid' => false,'erro' => 1,'msg' => 'Acesso negado!']);
	        die();
		}
		
		$this->load->model('administrativo/admin_model');
		$this->load->library('newsletter/newsletter');
		$this->load->model('newsletter/painel_model');
	}
	
//--------INCORPORADORA-------------------
	public function atualiza_incorporadora()
	{
	    try{
            
            $post = $this->input->post();
            
            if($post['email'] != '' && !empty(Cad_model::getCadastroByEmail($post['email'],$post['id_responsavel'])))
                throw new Exception("Email já tem cadastro no sistema");
            
            
    	    if(($post['senha']??'') != ''){
    	        $hasher = new PasswordHash($this->config->item('phpass_hash_strength', 'tank_auth') , $this->config->item('phpass_hash_portable', 'tank_auth'));
    	        $post['password'] = $hasher->HashPassword($post['senha']);}
    	    if(($post['login']??'') != '')
    	        $post['username'] = $post['login'];
    	    if(($post['responsavel']??'') != '')
    	        $post['nome'] = $post['responsavel'];
    	    if(($post['data_nascimento']??'') != '')
    	        $post['data_nascimento'] = HData::converteData($post['data_nascimento']);
    	    
    	    Cad_model::updateCadUser($post['id_responsavel'], $post);
    	    $valid =  $this->admin_model->updateIncorporadora($post['id_incorporadora'], $post);
    	    
    	    echo json_encode(['valid' => $valid, 'msg' => 'Sucesso', 'update' => $post ]);
            
        }catch(Exception $e) {
                echo json_encode(['valid' => false,'erro' => 5,'msg' => $e->getMessage()]);
        }
	}
	
	public function addParceiro()
	{
	    $post = $this->input->post();
	    $id_unidade = $this->cad_model->insert('inc_parceiro_rel_incorporadora',$post);
	    echo json_encode(['valid' => true, 'msg' => 'Sucesso', 'post' => $post]);
	}
	
	
	public function atualiza_parceiro_empreendimento()
	{
	    try{
            $post = $this->input->post();
            $id_empreendimento = $post['id_empreendimento'];
            
            $this->cad_model->delete('inc_parceiro_rel_empreendimento', ['id_empreendimento',$id_empreendimento]);
            
            if(is_array($post['parceiros']))
                foreach ($post['parceiros'] as $pcs)
                {
                    $pc = json_decode($pcs);
                    $insert = [];
                    $insert['id_parceiro'] = $pc[0];
                    $insert['id_incorporadora'] = $pc[1];
                    $insert['id_empreendimento'] = $id_empreendimento;
                    
                    $this->cad_model->insert('inc_parceiro_rel_empreendimento',$insert);
                }
            echo json_encode(['valid' => true, 'msg' => 'Sucesso', 'post' => $post]);
            
        }catch(Exception $e) {
            echo json_encode(['valid' => false,'erro' => 5,'msg' => $e->getMessage()]);
        }
	}
	
	
	
//--Fim---INCORPORADORA-------------------	


//--------EMPREENDIMENTO-------------------
	public function ini_empreendimento()
	{
	    $post = $this->input->post();
	    
	    $post['pro_status'] = 'Aguardando envio';
	    $post['pro_status_badge'] = 'secondary';
	    $post['emp_data_cadastro'] = date("Y-m-d H:i:s");
	    if(!empty($post['res_data_nascimento']))
            $post['res_data_nascimento'] = HData::converteData($post['res_data_nascimento']);
        
	    $incorporadora = $this->admin_model->getIncorporadora([['id_incorporadora',$post['id_incorporadora']]]);
	    
	    $uuid = strtolower(substr($post['emp_nome_fantasia'], 0, 5))." ";
	    
	    $uuid .= strtolower(substr($incorporadora->incorporadora, 0, 5))." ";
	    
	    $uuid .= $this->gerar_senha();
	    
	    $post['uuid_empreendimento'] = convertAccentsAndSpecialToNormal($uuid, "_");
	    
	    $id_empreendimento = $this->admin_model->insertEmpreendimento($post);
	    echo json_encode(['valid' => true, 'msg' => 'Sucesso', 'id_empreendimento' => $id_empreendimento]);
	}
	public function atualiza_empreendimento()
	{
	    $post = $this->input->post();
	    
	    if(($post['pro_status']??'') != '')
            $post['pro_status_badge'] = $this->statusBadgeEmpreendimento[$post['pro_status']];
        
        if(($post['res_data_nascimento']??'') != '')    
            $post['res_data_nascimento'] = HData::converteData($post['res_data_nascimento']);//<--------------------revisar
	    
	    unset($post['id_incorporadora']);
	    
	    $valid =  $this->admin_model->updateEmpreendimento($post['id_empreendimento'], $post);
	    
	    $empreendimento = $this->admin_model->getEmpreendimento([['id_empreendimento',$post['id_empreendimento']]]);
	    
	    if($valid && $empreendimento->id_imovel > 0)
	    {
	        $updateImovel                         = (array)$empreendimento;
            $updateImovel['dn_nome_nomefantasia'] = $empreendimento->emp_razao_social;
            $updateImovel['dn_razao_social']      = $empreendimento->emp_razao_social;
            $updateImovel['dn_telefone']          = $empreendimento->emp_telefone;
            $updateImovel['dn_email']             = $empreendimento->emp_email;
            $updateImovel['dn_cpf_cnpj']          = $empreendimento->emp_cnpj;
            $updateImovel['dn_img']               = $empreendimento->emp_logo;
            
            $id_imovel = $empreendimento->id_imovel;
            $this->cad_model->updateImovel($id_imovel,$updateImovel);
            $this->cad_model->updateImovelRel($id_imovel,$this->filtraCamposNovaUnidade($updateImovel));
            
	    }
	    
	    
	    echo json_encode(['valid' => $valid, 'msg' => 'Sucesso', 'update' => $post]);
	}
	private function filtraCamposNovaUnidade($cad)
    {
        $cad = (array)$cad;
        $array_unset = [
            'id_imovel',
            'id_imovel_rel',
            'unidade',
            'status',
            'importar_planilha',
            'doc_planilha',
            'tipo_imovel',
            'quartos',
            'suites',
            'banheiros',
            'andar',
            'vaga',
            'posicao_sol',
            'imovel_canto',
            'num_matricula',
            'area_total',
            'area_privativa',
            'doc_propriedade',
            'val_pretendido',
            'key_anuncio',
            'status_unidade_estoque'
            ];
        foreach ($cad as $key=>$value)
            if(in_array($key, $array_unset))
                unset($cad[$key]);
        
        return $cad;
    }
    private function buscar_cep($cep)
	{
	    $vazio = [
                    'latitude' => '',
                    'cep' => '',
                    'endereco' => '',
                    'bairro' => '',
                    'cidade' => '',
                    'estado' => ''
                ];
	    
	    if($cep == NULL || $cep == '')
           return $vazio;
	    
        $cep = preg_replace("/[^0-9]/", "", $cep);
        $end = $this->cad_model->getEndereco($cep);
        
        if (empty($end))
            return $vazio;
        else{
            $end = (array)$end;
            $end['latitude'] = '';
            $end['endereco'] = $end['logradouro'];
            return $end;
        }
	}
	
	 private function gerar_senha($tamanho = 6, $numeros = true,  $minusculas = true,  $maiusculas = false, $simbolos = false)
    {
        $ma = "ABCDEFGHIJKLMNOPQRSTUVYXWZ"; // $ma contem as letras maiúsculas
        $mi = "abcdefghijklmnopqrstuvyxwz"; // $mi contem as letras minusculas
        $nu = "0123456789"; // $nu contem os números
        $si = "!@#$%¨&*()_+="; // $si contem os símbolos
        
        $senha = '';
        
        if ($maiusculas){
            // se $maiusculas for "true", a variável $ma é embaralhada e adicionada para a variável $senha
            $senha .= str_shuffle($ma);
        }
        
        if ($minusculas){
            // se $minusculas for "true", a variável $mi é embaralhada e adicionada para a variável $senha
            $senha .= str_shuffle($mi);
        }
        
        if ($numeros){
            // se $numeros for "true", a variável $nu é embaralhada e adicionada para a variável $senha
            $senha .= str_shuffle($nu);
        }
        
        if ($simbolos){
            // se $simbolos for "true", a variável $si é embaralhada e adicionada para a variável $senha
            $senha .= str_shuffle($si);
        }
        
        // retorna a senha embaralhada com "str_shuffle" com o tamanho definido pela variável $tamanho
        return substr(str_shuffle($senha),0,$tamanho);
    }
//--Fim---EMPREENDIMENTO-------------------	
	
	
//--------IMOVEL-------------------
	public function ini_imovel()
	{
	    $post = $this->input->post();
	    
	    $id_empreendimento = $this->input->post('id_empreendimento');
	    $empreendimento = $this->admin_model->getEmpreendimento([['id_empreendimento',$id_empreendimento]]);
	    
	    if($empreendimento->id_imovel == 0)
	    {
	        $insertImovel                         = (array)$empreendimento;
	        $insertImovel['id_cadastro']          = $post['id_responsavel'];
	        $insertImovel['data_hora_imovel']     = date("Y-m-d H:i:s");
	        $insertImovel['tipo_empreendimento']  = 'lancamento';
	        $insertImovel['doc_perfil']           = 'cnpj';
	        $insertImovel['lancamento']           = 'Sim';
	        $insertImovel['chk_termo']            = 'on';
	        $insertImovel['step']                 = 11;
	        $insertImovel['status']               = 2;
	        
	        $insertImovel['dn_nome_nomefantasia'] = $empreendimento->emp_nome_fantasia;
            $insertImovel['dn_razao_social']      = $empreendimento->emp_razao_social;
            $insertImovel['dn_telefone']          = $empreendimento->emp_telefone;
            $insertImovel['dn_email']             = $empreendimento->emp_email;
            $insertImovel['dn_cpf_cnpj']          = $empreendimento->emp_cnpj;
            $insertImovel['dn_img']               = $empreendimento->emp_logo;
	        
	        //key_anuncio    <<<-----------------------------<<<-----------------------------<<<-----------------------------<<<-----------------------------<<<-----------------------------<<<-----------------------------
    
	        $id_imovel = $this->cad_model->insertImovel($insertImovel);
	        $this->admin_model->updateEmpreendimento($id_empreendimento, ['id_imovel' => $id_imovel]);
	        
	        $imovel = $this->cad_model->getImovel(['id_imovel'=>$id_imovel]);
	        
            //$imovel, $origem = 'iniCardImovel', $id_lista = 1, $id_responsavel = 0, $obs = null, $perfilExecutor = null
            $this->load->model('administrativo/fluxo_model');
            MFluxo::iniCardImovel($imovel, 'iniEmpreendimento',9);
	        
	        echo json_encode(['valid' => true, 'msg' => 'Sucesso', 'id_imovel' => $id_imovel]);
	        
	    }else {
	        
	        if( $this->admin_model->getImovel([['a.id_imovel',$empreendimento->id_imovel]]) == null){
	            $this->admin_model->updateEmpreendimento($id_empreendimento, ['id_imovel' => 0]);
	            $this->ini_imovel();
	        }
	        else{
	            $id_imovel =  $empreendimento->id_imovel;
	            echo json_encode(['valid' => true, 'msg' => 'Sucesso', 'id_imovel' => $id_imovel]);
	        }
	    }
	    
	    
	}
	public function atualiza_imovel()
	{
	    $post = $this->input->post();
	    
	    if(isset($post['status_imovel'])){
	        $post['status'] = $post['status_imovel']==''?3:$post['status_imovel'];
	        
	        $descricao = $post['status_imovel']==''?'Removeu Vendido':'Vendido';
	        
	        $this->load->model('administrativo/fluxo_model');
	        MFluxo::editImovel($post['id_imovel'], $post, null, $descricao);
	    }
	        
	        
	    
	    
	    $valid =  $this->admin_model->updateImovel($post['id_imovel'], $post);
	    echo json_encode(['valid' => $valid, 'msg' => 'Sucesso', 'update' => $post]);
	}
	public function remove_imovel()
    {
        try{
            $id_imovel = $this->input->post('id_imovel');
            if($id_imovel == null)
                throw new Exception("ID Imovel Nulo");
            $valid = $this->admin_model->deleteImovel([['id_imovel',$id_imovel]]);
            
            echo json_encode(['valid' => $valid]);
            
        } catch(Exception $e) {
            echo json_encode(['valid' => false,'msg' => $e->getMessage()]);
        }
        
    }
	public function atualiza_planilha()
    {
        try 
        {
            $post = $this->input->post();
            
            if($post['url'] == ""){
                $imovel = $this->admin_model->getImovel([['a.id_imovel', $post['id_imovel']]]);
                if($imovel == null)
                    throw new Exception("Imovel não encontrado");
                $this->admin_model->deleteImovel([['id_imovel_rel',$imovel->id_imovel],['importar_planilha', 'on']]);//planilha on IMPLEMENTAR<---------------------------------
            }
            $this->cad_model->updateImovel($post['id_imovel'],['doc_planilha' => $post['url']]);
            echo json_encode(['valid' => true, 'doc_planilha' => $post['url'], 'msg' => 'Sucesso!']);  
        } catch(Exception $e) {
            echo json_encode(['valid' => false,'erro' => 5,'msg' => $e->getMessage()]);
        }
    }
    public function add_unidade_imovel()
    {
        try {
            $post = $this->input->post();
            $imovel = $this->admin_model->getImovel([['a.id_imovel',$post['id_imovel']??null]]);
            if($imovel == null)
                throw new Exception("Imovel não encontrado");
            
            $val_pretendido = $post['val_pretendido']??0;
            $area_total = $post['area_total']??0;
            
            if(!($val_pretendido > 0 && $area_total > 0))
                throw new Exception("Valor e area total devem ser preenchidos");
            
            $val_public_total = (1.5*$val_pretendido)/100;
            $val_public_total_metro = $val_public_total/$area_total;
            
            $post['id_imovel_rel']          = $imovel->id_imovel;
            $post['id_cadastro']            = $imovel->id_cadastro;
            $post['val_public_total']       = $val_public_total;
            $post['val_public_total_metro'] = $val_public_total_metro;
            $post['dn_img']                 = $imovel->dn_img;
            $post['dn_img_uri']             = $imovel->dn_img_uri;
            $post['importar_planilha']      = '';   
            $insert = array_merge((array)$imovel, $post);
             
            $id_imovel_rel = $this->cad_model->insertImovel($insert);
            
            echo json_encode(['valid' => true, 'id_imovel_rel' => $id_imovel_rel, 'msg' => 'Sucesso!']);    
                
            } catch(Exception $e) {
                echo json_encode(['valid' => false,'erro' => 5,'msg' => $e->getMessage()]);
            }
    }
	public function insert_unidades()
    {
        try {
            $post = $this->input->post();
            
            $imovel = $this->admin_model->getImovel([['a.id_imovel',$post['id_imovel']??null]]);
            if($imovel == null)
                throw new Exception("Imovel não encontrado");
            
            
            $id_cadastro = $imovel->id_cadastro;
            $id_imovel = $imovel->id_imovel;
                
            foreach ($_FILES as $inputName=>$file){
                $inputName = $inputName; $file = $file;
            }
                
            if (!isset($file))
                throw new Exception("File not uploaded");
                
            if(!is_dir('./modules/anunciante/' . $id_cadastro .'/planilhas/'))
                mkdir('./modules/anunciante/' . $id_cadastro .'/planilhas/', 0774, true);
                
            $config['upload_path']          = './modules/anunciante/' . $id_cadastro .'/planilhas/';
            $config['allowed_types']        = 'xlsx';
                
            $this->load->library('upload', $config);
            
            if (!$this->upload->do_upload('doc_planilha'))
                throw new Exception("Erro ao importar arquivo");
                    
            $upDoc = $this->upload->data();
                
            $inputFileName = '../html/modules/anunciante/' . $id_cadastro .'/planilhas/'.$upDoc['file_name'];
        	$spreadsheet = \PhpOffice\PhpSpreadsheet\IOFactory::load($inputFileName);
        	    
        	if(strcasecmp(trim($this->get_cell_value($spreadsheet,1,2)),'Empreendimento') == 0)
        	{
        	        $worksheet = $spreadsheet->getActiveSheet(); 
                    $highestRow = $worksheet->getHighestRow(); // e.g. 10 
                    
                    $imoveis_rel = [];
                    $count = 1; 
                    $tipoPlanilha2 = (strcasecmp(trim($this->get_cell_value($spreadsheet,71,2)),'Descrição') == 0)?true:false;
                    if($tipoPlanilha2)
                        $arrayEndereco = $this->buscar_cep($this->get_cell_value($spreadsheet,29,3));
                    
                    for($row = 3; $row < $highestRow; $row ++)
                    {
                        
                        $val_pretendido = $this->get_cell_value($spreadsheet,15,$row);
                        $area_total = $this->get_cell_value($spreadsheet,10,$row);
                        if($val_pretendido > 0 && $area_total > 0)
                        {
                            
                            $val_public_total = (1.5*$val_pretendido)/100;
                            $val_public_total_metro = $val_public_total/$area_total;
                            
                            $insert = [
                                    'id_imovel_rel'          => $post['id_imovel'],
                                    'id_cadastro'            => $imovel->id_cadastro,
                                    'complemento'            => $this->get_cell_value($spreadsheet,2,$row),
                                    'unidade'                => $this->get_cell_value($spreadsheet,2,$row),
                                    'area_total'             => $area_total,
                                    'area_privativa'         => $this->get_cell_value($spreadsheet,11,$row),
                                    'quartos'                => $this->get_cell_value($spreadsheet,13,$row),
                                    'vaga'                   => $this->get_vagas($this->get_cell_value($spreadsheet,14,$row)),
                                    'val_pretendido'         => $val_pretendido,
                                    'val_public_total'       => $val_public_total,
                                    'val_public_total_metro' => $val_public_total_metro,
                                    'importar_planilha'      => 'on',
                                ];
                            
                            if($tipoPlanilha2)
                            {   //for($asd = 1; $asd < 72; $asd ++) echo $asd.' => ["nameDB" => "","name" => "'.$this->get_cell_value($spreadsheet,$asd,2).'" ],<br>';
                                foreach (HImovel::getTbPlanilha() as $col=>$db){
                                    $val = $this->get_cell_value($spreadsheet,$col,$row);
                                    $insert[$db['nameDB']] = ($col>=47&&$col<71)?($val==NULL?'':'on'):$val;
                                }
                                //$insert = array_merge($insert, $arrayEndereco);
                                $update = $insert;
                            }
                            if($count > 1)
                            {
                                $insert['dn_img'] = $imovel->dn_img;
                                $insert['dn_img_uri'] = $imovel->dn_img_uri;
                                
                                $insert = array_merge((array)$imovel, $insert);
                                
                                $insert['id_imovel_rel'] = $this->cad_model->insertImovel($insert);
                                $imoveis_rel[] = $insert;
                                $update = $insert;
                            }
                            else
                            {
                                $update = $insert;
                                
                                unset($update['id_imovel_rel']);
                                $this->cad_model->updateImovel($post['id_imovel'],$update);
                                
                            }
                        }
                        $count++;
                    }
                    
                    $json = ['valid' => true,'imoveis_rel' => (object)$imoveis_rel, 'imovel' => (object)$update,  'msg' => 'sucesso!']; //
                    
                    $width = $post['width']??300;
                    $upload_path = $post['path']??'upload_path/temporario';
                    //---------------------------------------------------------------------
                    $allowed_types = ['gif','GIF','jpg','JPG','jpeg','JPEG','png','PNG','pdf','PDF','xlsx'];
                    $path_parts = pathinfo($file["name"]);
                    $extension = $path_parts['extension'];
                    if (!in_array($extension, $allowed_types))
                        throw new Exception("Tipo de arquivo não permitido!");
                    //---------------------------------------------------------------------
                    //$credentials = new Credentials(ACCESS_KEY, SECRET_KEY);
                    //$s3 = new S3Client(['version' => 'latest','region' => 'us-west-2']); //,'credentials' => $credentials
                    //$name = str_replace($extension, "", convertAccentsAndSpecialToNormal($file['name'])).'.'.$extension;
                    //$putImg = $this->getPutResize($file['tmp_name'], $name, $width, $upload_path); 
                    //$resImg = $s3->putObject($putImg);
                    //$imgUrl = $resImg['ObjectURL'];
                    
                    $tmp_name = $file['tmp_name'];
                    $name = str_replace($extension, "", convertAccentsAndSpecialToNormal($file['name'])).'.'.$extension;
                    $imgUrl = Upload::putObjectResize($tmp_name, $name, $width, $upload_path);
                    
                    
                    
                    $this->atualiza_galeria($id_imovel);
                    
                    if(file_exists($tmp_name))
                    {
                        unlink($tmp_name);  
                    }
                    
                    
                    
                    echo json_encode(['valid' => true, 'url_s3' => $imgUrl, 'msg' => 'Sucesso!']);
        	    
        	}else{
                $file_path = './modules/anunciante/' . $id_cadastro .'/planilhas/'.$upDoc['file_name'];
                if(file_exists($file_path))
                    unlink($file_path);
                throw new Exception("Erro. Modelo incorreto!");
            }
        } catch(Exception $e) {
            echo json_encode(['valid' => false,'erro' => 5,'msg' => $e->getMessage()]);
        }
    }
    
    public function atualiza_galeria($id_imovel)
    {
        $imovel = $this->cad_model->getImovel(['id_imovel'=> $id_imovel]);
        $imagens = $this->cad_model->getImgsImovel($imovel->id_imovel);
        foreach( $this->cad_model->getImoveis(['id_imovel_rel'=>$imovel->id_imovel]) as $imovelRel ){
            $this->cad_model->deletaImgsImovel($imovelRel->id_imovel);
            foreach ($imagens as $imagem){
                $img = (array)$imagem;
                $img['id_img_rel'] = $img['id_img'];
                $img['id_imovel'] = $imovelRel->id_imovel;
                unset($img['id_img']);
                $this->cad_model->update_galeria($img);//insert<-----------------------
            }
        }
    }
    
    
    
    
    
    protected $excel;
    protected $rowCabecalho = 2;
    
    public function new_insert_unidades()
    {
        try {
            $post = $this->input->post();
            
            $imovel = $this->admin_model->getImovel([['a.id_imovel',$post['id_imovel']??null]]);
            if($imovel == null)
                throw new Exception("Imovel não encontrado");
            
            
            $id_cadastro = $imovel->id_cadastro;
            $id_imovel = $imovel->id_imovel;
                
            foreach ($_FILES as $inputName=>$file){
                $inputName = $inputName; $file = $file;
            }
                
            if (!isset($file))
                throw new Exception("File not uploaded");
                
            if(!is_dir('./modules/anunciante/' . $id_cadastro .'/planilhas/'))
                mkdir('./modules/anunciante/' . $id_cadastro .'/planilhas/', 0774, true);
                
            $config['upload_path']          = './modules/anunciante/' . $id_cadastro .'/planilhas/';
            $config['allowed_types']        = 'xlsx';
                
            $this->load->library('upload', $config);
            
            if (!$this->upload->do_upload('doc_planilha'))
                throw new Exception("Erro ao importar arquivo");
                    
            $upDoc = $this->upload->data();
                
            $inputFileName = '../html/modules/anunciante/' . $id_cadastro .'/planilhas/'.$upDoc['file_name'];
        	$this->excel = $spreadsheet = \PhpOffice\PhpSpreadsheet\IOFactory::load($inputFileName);
        	
        	
        	if(strcasecmp(trim($this->get_cell_value($spreadsheet,1,2)),'Empreendimento') == 0)
        	{
        	        $worksheet = $spreadsheet->getActiveSheet(); 
                    $highestRow = $worksheet->getHighestRow(); // e.g. 10 
                    
                    $imoveis_rel = [];
                    
                    $row = $this->rowCabecalho + 1;
                    
                    for($row; $row < $highestRow; $row ++)
                    {
                        
                        $val_pretendido = $this->getCampoExcel('val_pretendido', $row);
                        $area_total = $this->getCampoExcel('area_total', $row);
                        
                        if($val_pretendido > 0 && $area_total > 0)
                        {
                            $val_public_total = (1.5*$val_pretendido)/100;
                            $val_public_total_metro = $val_public_total/$area_total;
                            
                            $insert = [
                                    'id_imovel_rel'          => $post['id_imovel'],
                                    'id_cadastro'            => $imovel->id_cadastro,
                                    'area_total'             => $area_total,
                                    'vaga'                   => $this->get_vagas($this->getCampoExcel('vaga', $row)),
                                    'val_pretendido'         => $val_pretendido,
                                    'val_public_total'       => $val_public_total,
                                    'val_public_total_metro' => $val_public_total_metro,
                                    'importar_planilha'      => 'on',
                                ];
                            
                            
                             foreach ($this->getCamposRow($this->rowCabecalho) as $col=>$rowName){
                                 
                                    $keyDB = HImovel::getfieldDb($rowName);
                                    $val = $this->getValColRow($col,$row);
                                    
                                    if(in_array($keyDB ,HImovel::getCaposCheckbox()))
                                        $val = $val==NULL?'':'on';
                                        
                                    if(in_array($keyDB, HImovel::getCamposDate()))
                                        $val = $this->converDateExcel($val);
                                        
                                    $insert[$keyDB] = $val;
                             }
                            
                            //dd($insert);//status_unidade_estoque
                            
                            
                            
                            $insert['status_unidade_estoque'] = 1;//DISPONIVEL NO ESTOQUE
                            $insert['dn_img'] = $imovel->dn_img;
                            $insert['dn_img_uri'] = $imovel->dn_img_uri;
                            $insert = array_merge($this->filtraCamposNovaUnidade($imovel), $insert);
                            $insert['id_imovel_rel'] = $this->cad_model->insertImovel($insert);
                            $imoveis_rel[] = $insert;
                            
                        }
                    }
                    
                    $this->atualiza_galeria($id_imovel);
                    
                    $json = ['valid' => true,'imoveis_rel' => (object)$imoveis_rel, 'imovel' => $imovel,  'msg' => 'sucesso!']; //
                    
                    $width = $post['width']??300;
                    $upload_path = $post['path']??'upload_path/temporario';
                    //---------------------------------------------------------------------
                    $allowed_types = ['gif','GIF','jpg','JPG','jpeg','JPEG','png','PNG','pdf','PDF','xlsx'];
                    $path_parts = pathinfo($file["name"]);
                    $extension = $path_parts['extension'];
                    if (!in_array($extension, $allowed_types))
                        throw new Exception("Tipo de arquivo não permitido!");
                    //---------------------------------------------------------------------
                    //$credentials = new Credentials(ACCESS_KEY, SECRET_KEY);
                    //$s3 = new S3Client(['version' => 'latest','region' => 'us-west-2']); //,'credentials' => $credentials
                    //$name = str_replace($extension, "", convertAccentsAndSpecialToNormal($file['name'])).'.'.$extension;
                    //$putImg = $this->getPutResize($file['tmp_name'], $name, $width, $upload_path); 
                    //$resImg = $s3->putObject($putImg);
                    //$imgUrl = $resImg['ObjectURL'];
                    
                    $tmp_name = $file['tmp_name'];
                    $name = str_replace($extension, "", convertAccentsAndSpecialToNormal($file['name'])).'.'.$extension;
                    $imgUrl = Upload::putObjectResize($tmp_name, $name, $width, $upload_path);
                    
                    if(file_exists($tmp_name))
                    {
                        unlink($tmp_name);  
                    }
                    
                    
                    
                    echo json_encode(['valid' => true, 'url_s3' => $imgUrl, 'msg' => 'Sucesso!']);
        	    
        	}else{
                $file_path = './modules/anunciante/' . $id_cadastro .'/planilhas/'.$upDoc['file_name'];
                if(file_exists($file_path))
                    unlink($file_path);
                throw new Exception("Erro. Modelo incorreto!");
            }
        } catch(Exception $e) {
            echo json_encode(['valid' => false,'erro' => 5,'msg' => $e->getMessage()]);
        }
    }
    
    private function getCampoExcel($nameDB, $row){
        foreach ($this->getCamposRow($this->rowCabecalho) as $col=>$rowName)
            if(HImovel::getfieldDb($rowName) == $nameDB)
                return $this->get_cell_value($this->excel,$col,$row);
        return null;
        
        
    }
    
    private function getValColRow($col,$row)
    {
        return $this->get_cell_value($this->excel,$col,$row);
    }
        
    
    
    private function getCamposRow($row)
    {
        $col = 1;
        $campos = [];
        while (true) {
            $campos[$col] = $this->get_cell_value($this->excel,$col,$row);
            if($campos[$col] == '' || $campos[$col] == null)
            {
                unset($campos[$col]);
                break;
            }
               
            $col++;
        }
        return $campos;
    }
    
    private function get_vagas($str)
	{
	    $output = preg_split( "/e|,/", $str );
	    
	    return count($output);
	}
	private function get_cell_value($spreadsheet,$column,$row)
	{
	    return $spreadsheet->getActiveSheet()->getCellByColumnAndRow($column,$row)->getValue();
	}
	
	private function converDateExcel($excel_date)
	{
        $unix_date = ($excel_date - 25569) * 86400;
        $excel_date = 25569 + ($unix_date / 86400);
        $unix_date = ($excel_date - 25569) * 86400;
        
        return gmdate("Y-m-d", $unix_date);
	}
	
//--Fim---IMOVEL-------------------


//--------FINANCEIRO-------------------
	public function insert_investimento()
	{
	    try {
            $post = $this->input->post();
            
            if($post['midia'] == null)
                throw new Exception("Selecione mídia");
            if(!($post['valor'] > 0))
                throw new Exception("adicione um valor");
                
            $post['data'] = date("Y-m-d");
	    
	        $id_config = $this->admin_model->insertInvestimento($post);
	        echo json_encode(['valid' => true, 'msg' => 'Sucesso', 'id_config' => $id_config]);    
                
                
            } catch(Exception $e) {
                echo json_encode(['valid' => false,'erro' => 5,'msg' => $e->getMessage()]);
        }
	}
	public function atualiza_investimento()
	{
	    $post = $this->input->post();
	    
	    $valid =  $this->admin_model->updateInvestimento($post['id_empreendimento'], $post);
	    echo json_encode(['valid' => $valid, 'msg' => 'Sucesso', 'update' => $post]);
	}
//--Fim---FINANCEIRO-------------------


//--------CONFIG LP-------------------
	public function ini_config_lp()
	{
	    $post = $this->input->post();
	    $post['data_cadastro'] = date("Y-m-d H:i:s");
	    $id_config = $this->admin_model->insertConfigLp($post);
	    echo json_encode(['valid' => true, 'msg' => 'Sucesso', 'id_config' => $id_config]);
	}
	public function atualiza_config_lp()
	{
	    $post = $this->input->post();
	    
	    $valid =  $this->admin_model->updateConfigLp($post['id_config'], $post);
	    echo json_encode(['valid' => $valid, 'msg' => 'Sucesso', 'update' => $post]);
	}
	//LP CONFIG - unidade
	public function insert_unidade()
	{
	    $post = $this->input->post();
	    
	    $id_unidade = $this->admin_model->insertUnidade($post);
	    echo json_encode(['valid' => true, 'msg' => 'Sucesso', 'id_unidade' => $id_unidade]);
	}
	public function atualiza_unidade()
	{
	    $post = $this->input->post();
	    
	    $valid =  $this->admin_model->updateUnidade($post['id_unidade'], $post);
	    echo json_encode(['valid' => $valid, 'msg' => 'Sucesso', 'update' => $post]);
	}
	//LP CONFIG - diferencial
	public function insert_diferencial()
	{
	    $post = $this->input->post();
	    
	    $id_config = $this->admin_model->insertDiferencial($post);
	    echo json_encode(['valid' => true, 'msg' => 'Sucesso', 'id_config' => $id_config]);
	}
	public function atualiza_diferencial()
	{
	    $post = $this->input->post();
	    
	    $valid =  $this->admin_model->updateDiferencial($post['id_diferencial'], $post);
	    echo json_encode(['valid' => $valid, 'msg' => 'Sucesso', 'update' => $post]);
	}
	//LP CONFIG - Comodidade
	public function insert_comodidade()
	{
	    $post = $this->input->post();
	    
	    $id_comodidade = $this->admin_model->insertComodidade($post);
	    echo json_encode(['valid' => true, 'msg' => 'Sucesso', 'id_comodidade' => $id_comodidade]);
	}
	public function atualiza_comodidade()
	{
	    $post = $this->input->post();
	    
	    $valid =  $this->admin_model->updateComodidade($post['id_comodidade'], $post);
	    echo json_encode(['valid' => $valid, 'msg' => 'Sucesso', 'update' => $post]);
	}
//--Fim---CONFIG LP-------------------


//--------UPLOAD S3-------------------
	public function upload_s3()
    {
        try {
            foreach ($_FILES as $inputName=>$file)
                $inputName = $inputName; $file = $file;
            
            if (!isset($file))
                throw new Exception("Arquivo não encontrado!");
            
            $post = $this->input->post();
            
            $width = $post['width']??600;
            $upload_path = $post['path']??'upload_path/temporario';
            //---------------------------------------------------------------------
            $allowed_types = ['gif','GIF','jpg','JPG','jpeg','JPEG','png','PNG','mp4','pdf','PDF','xlsx'];
            $path_parts = pathinfo($file["name"]);
            $extension = $path_parts['extension'];
            if (!in_array($extension, $allowed_types))
                throw new Exception("Tipo de arquivo não permitido!");
            //---------------------------------------------------------------------
            
            //$s3 = new S3Client(['version' => 'latest','region' => 'us-west-2']); 
            //$name = str_replace($extension, "", convertAccentsAndSpecialToNormal($file['name'])).'.'.$extension;
            //$putImg1 = $this->getPutResize($file['tmp_name'], $name, 460, $upload_path.'/thumb');
            //$resImg1  = $s3->putObject($putImg1);
            //$putImg  = $this->getPutResize($file['tmp_name'], $name, $width, $upload_path);
            //$resImg = $s3->putObject($putImg);
            //$imgUrl = $resImg['ObjectURL'];
            
            
            $tmp_name = $file['tmp_name'];
            $name = str_replace($extension, "", convertAccentsAndSpecialToNormal($file['name'])).'.'.$extension;
            //$upload_path = 'anunciante/' . $id_cadastro .'/anuncios/'.$id_imovel.'/galeria';
            Upload::putObjectResize($tmp_name, $name, 460, $upload_path.'/thumb');
            $imgUrl = Upload::putObjectResize($tmp_name, $name, $width, $upload_path);
            
            if(file_exists($tmp_name))
            {
                unlink($tmp_name);  
            }
            
            echo json_encode(['valid' => true, 'url_s3' => $imgUrl, 'msg' => 'Sucesso!']);  
            
        } catch(Exception $e) {
            echo json_encode(['valid' => false,'erro' => 5,'msg' => $e->getMessage()]);
        }
    }
	/*
	public function getPutResize($tmp_name, $name, $width, $upload_path)
    {
        $key = $upload_path.'/'.$name;
        $sourceFile = $tmp_name;
        
        $path_parts = pathinfo($name);
        $extension = $path_parts['extension'];
        
        if(in_array($extension,['gif','jpeg','jpg','png']))
        {
            // versão atualizada do resize das imagens com PNG transparente!
    		$sourceFile = FCPATH.'assets/uploads/'.rand().'-'.$name;
    		
            $count = strlen($extension)+1;
    		
            $this->load->library('image_lib');
    		
    		$config['image_library'] = 'gd2';
            $config['source_image'] = $tmp_name;
            $config['new_image'] = $sourceFile;
            
            $config['create_thumb']  = TRUE;
            $config['maintain_ratio'] = TRUE;
            $config['width']          = $width;
            
            $this->image_lib->clear();
            $this->image_lib->initialize($config);
            
            if (!$this->image_lib->resize())
            {
                echo $this->image_lib->display_errors();
            }
            
            $sourceFile = substr($sourceFile,0,-$count).'_thumb.'.$extension;
        }
        
        $contentType = $extension == 'pdf'?'application/pdf':'image/jpeg'; 
        
        return [
            'ACL' => 'public-read',
            'Bucket' => getenv('S3_BUCKET'),
            'Key'    => $key,
            'SourceFile' => $sourceFile,
            'ContentDisposition' => 'inline; filename='.$name,
            'ContentType' => $contentType
            ];
    }
    */
	public function remove_s3()
    {
        
        $data['img_perfil'] = '';
        $data['img_perfil_uri'] = '';
        $this->cad_model->updateCadastro($id_cadastro, $data);
        
        $dtImovel['dn_img'] = '';
        $dtImovel['dn_img_uri'] = '';
        $wup[] = ['id_cadastro', $id_cadastro];
        $wup[] = ['doc_perfil', 'cpf'];
        $this->cad_model->updateImoveis($wup,$dtImovel);
        
        $file_path = './modules/anunciante/' . $id_cadastro .'/perfil/';
        $file = $file_path.$cad->img_perfil;
        if(file_exists($file)){
            unlink($file);  
        }
    }
//--Fim---UPLOAD S3-------------------

	public function editar_propostar_post(){
	    //faz a validação se tem os dois
	    $post = $this->input->post();
	    
        if(!isset($post['plano'])){
            $post['status_proposta'] = 0;
            $post['logs_proposta'] = json_encode([date('Y-m-d h:i:s') =>"Proposta criada sem planos, reeditar nova."]);
        }else{
            $post['id_plano'] = $this->admin_model->insertPlanos($post);
            
            $condicoes = ['condicoes' => $post['condicoes']];
            $servicos = ['servicos' => $post['servicos']];
            
            $condicoes_servicos = array_merge($condicoes,$servicos);
            
            $post['condicoes_servicos'] = json_encode($condicoes_servicos);
            
            $this->admin_model->insert_plano_rel($post);
            unset($post['id_plano']);
            $post['logs_proposta'] = json_encode([date('Y-m-d h:i:s') =>"Editada criada com sucesso."]);
            $post['status_proposta'] = 1;
        }
        
        $insert = $this->admin_model->insertPropostas($post);
        
        if($insert > 0){
            $json = ['valid' => true, 'msg' => 'Cadastro inserido com sucesso!'];
        }else{
            $json = ['valid' => false, 'msg' => 'Falha de comunicação!'];
        }
        echo json_encode($json);
	}
	
	/** * Funcao auxiliar pra pegar o primeiro e o ultimo nome dua string
    * @access private 
    * @param String $str - nome do lead completo
    * @return Primeiro nome do lead com a primeira letra maiúscula
    */
	private function primeiroNome($str){
        $nome = explode(' ', $str);
        $first = array_shift($nome);
        $nome_novo = trim($first);
        $nome_novo_final = ucfirst($nome_novo);
        return $nome_novo_final;
    }
	
	
	/** * Função para enviar mensagens com o convite do evento para o whatsapp dos leads do evento
    * @access public 
    * @param -
    * @return Ajax
    */
	public function enviarConviteWhats(){
	    $this->load->library('atendimento/zapi_whatsapp');
	    $data = $this->input->post();
        $data['link_corretor'] = trim($data['link_corretor']);
        
        if(!empty($data['link_corretor']) && !empty($data['mensagem'])){
        
    	    if(!empty($data['ids'])){
    	        $capturas = [];
        	    foreach($data['ids'] as $d){
        	        
        	        $captura = $this->cad_model->getCaptura([['id_captura',$d]]);
        	        array_push($capturas,$captura);

        	    }
    	        //dd($capturas);
    	        $return_msg = [];
    	        foreach($capturas as $cap){
    	            $envio['cap'] = $cap;
    	            $envio['link_corretor'] = $data['link_corretor'];
    	            //Caso de teste//if($cap->id_captura == 31){
    	            //Caso de teste//$cap->telefone = '(61)996849576';     
    	            //Caso de teste//$cap->nome = 'matheus carvalho';
    	            
    	            $telefone = str_replace("(" , "", $cap->telefone);
            	    $telefone = str_replace(")" , "", $telefone);
            	    $telefone = str_replace(" " , "", $telefone);
            	    $telefone = str_replace("-" , "", $telefone);
            	    $telefone = "55".$telefone;    
    	            
    	            $nome = $this->primeiroNome($cap->nome);
    	            
    	            $envio['mensagem'] = str_replace('{nome}', $nome, $data['mensagem']);
    	            
    	            $mensagem_final =  Template::getView('administrativo/evento_whatsapp_view', $envio);
    	            
    	            $return = $this->zapi_whatsapp->sendMessage($telefone, $mensagem_final);
    	            
    	            if($return != false){
    	                $log = [
    	                    'id_captura' => $cap->id_captura,
    	                    'telefone' => $cap->telefone,
    	                    'id_evento' => $data['id_evento'],
    	                    'enviado' => 1,
    	                    'enviado_em' => date("Y-m-d H:i:s")
    	                    ];
    	                 $this->cad_model->insertLogWhatsapp($log);
    	            }
    	            else{
    	                $log = [
    	                    'id_captura' => $cap->id_captura,
    	                    'telefone' => $cap->telefone,
    	                    'id_evento' => $data['id_evento'],
    	                    'enviado' => 0,
    	                    'enviado_em' => date("Y-m-d H:i:s")
    	                    ];
    	                 $this->cad_model->insertLogWhatsapp($log);    
    	            }
    	            
    	            array_push($return_msg,$return);
    	            //Caso de teste//}
    	        }
                //dd($return_msg);
    	        $flag = true;
    	        foreach($return_msg as $r){
    	            if($r == false){
    	                $flag = false;
    	            }
    	        }
    	        
        	        
                if($flag == false || empty($return_msg)){
                    if(empty($return_msg)){
                        $json = ['success' => false, 'msg' => 'Nenhuma mensagem enviada!'];
                    }
                    else{
                        $json = ['success' => true, 'msg' => 'Alguma mensagem falhou no envio, mas outras podem ter sido enviadas!'];
                    }
                }
                else{
                   $json = ['success' => true, 'msg' => 'Todas as mensagens estão sendo enviadas!'];
                }
                
    	    }
    	    else{
    	       $json = ['success' => false, 'msg' => 'Sem leads para enviar mensagem!'];
    	    }
	    }
	    else{
	        $json = ['success' => false, 'msg' => 'Alguns dos campos a serem preenchidos estão vazios!'];
	    }
	    
	    echo json_encode($json);
	    
	}
	
	
	/** * Função para enviar mensagens com o convite do evento para o email dos leads do evento
    * @access public 
    * @param -
    * @return Ajax
    */
    public function enviarConviteEmail(){
        $data = $this->input->post();
        
        $data['link_corretor'] = trim($data['link_corretor']);
        $data['uuid_campanha'] = trim($data['uuid_campanha']);
        
        if(!empty($data['link_corretor']) && !empty($data['uuid_campanha'])){
            if(!empty($data['ids'])){
                
                $capturas = [];
        	    foreach($data['ids'] as $d){
        	        $captura = $this->cad_model->getCaptura([['id_captura',$d]]);
        	        array_push($capturas,$captura);
        	    }
                
                $return_msg = [];
                foreach($capturas as $cap){
                    //Caso de teste//if($cap->id_captura == 31){
    	            //Caso de teste//$cap->nome = 'matheus carvalho';
    	            //Caso de teste//$cap->email = 'matheus@comdono.com';
                    $nome = $this->primeiroNome($cap->nome);
                    $dt = [
                        "link_convite" => $data['link_corretor'],
                        "nome" => $nome
                    ];
                    
                    $arquivo = $this->cad_model->getArquivo(['nome',$data['uuid_evento']]);
                    if($arquivo == null){
                        $arquivo = [
                            'nome'     => $data['uuid_evento'],
                            'datetime' => date('Y-m-d H:i:s')
                            ];
                            
                        $id_arquivo = $this->cad_model->insertArquivo($arquivo);
                    }
                    else
                        $id_arquivo = $arquivo->id_arquivo;
                    
                    //dd($data['uuid_campanha'],$id_arquivo);
                    
    	            $return = Envia::email($cap->email, [$data['uuid_campanha'],$id_arquivo], $dt);
    	            array_push($return_msg,$return);
                    //Caso de teste//}
    	        }
    	        
    	        $flag = true;
    	        foreach($return_msg as $r){
    	            if($r == false){
    	                $flag = false;
    	            }
    	        }
    	        if($flag == false){
                    
                    $json = ['success' => true, 'msg' => 'Alguma mensagem falhou no envio, mas outras podem ter sido enviadas!'];
                    
                }
                else{
                    
                   $json = ['success' => true, 'msg' => 'Todas as mensagens estão sendo enviadas!'];
                }
    	        
            }
            else{
                $json = ['success' => false, 'msg' => 'Sem leads para enviar mensagem!'];
            }
            
        }
        else{
            $json = ['success' => false, 'msg' => 'Alguns dos campos a serem preenchidos estão vazios!'];
        }
        
        echo json_encode($json);
    }
	
	public function salvarConfigMensagem(){
	    
	    try{
    	    
    	    $data = $this->input->post();
    	    
    	    if($data == null || empty($data))
    	        throw new Exception('Erro nos dados, contactar a TI!');
    	    
            $data['link'] = trim($data['link']);
            $data['titulo'] = trim($data['titulo']);
            $data['imagem'] = trim($data['imagem']);
            
            $config = null;
            if($data['id_config'] != ''){
                $config = $this->cad_model->getLogWhatsappConfig(['id_config', $data['id_config']]);
            }
            
            if($config != null)
                $this->cad_model->updateLogWhatsappConfig($data['id_config'],$data);
            else
                $resultado = $this->cad_model->insertLogWhatsappConfig($data);
            
            
            $json = ['success' => true, 'msg' => 'Configuração salva'];
           
    	    
    	    echo json_encode($json);
	    
    	}catch(Exception $e) {
            echo json_encode(['success' => false, 'msg' => $e->getMessage()]);
        }
	    
	}	
	
	/** * Função para enviar mensagens para o whatsapp dos leads pela lista da newsletter
    * @access public 
    * @param -
    * @return Ajax
    */
	public function enviarWhatsLista(){
	    
	    try{
    	    $this->load->library('atendimento/zapi_whatsapp');
    	    $data = $this->input->post();
    	    
    	    if($data == null || empty($data))
    	        throw new Exception('Erro nos dados, contactar a TI!');
    	    
            $data['link'] = trim($data['link']);
            $data['titulo'] = trim($data['titulo']);
            
            //$lista = $this->cad_model->getNewsletterLista(['id', $data['id_lista']]);
            //$leads = $this->painel_model->get_sql_lista($lista);
            
            $this->load->library('newsletter/Lista_Custom');
            
    	    $leads = $this->lista_custom->get_leads_lista($data['id_lista']);
            
            //dd($data, $leads);
            if(!empty($data['mensagem'])){
            
        	    if($leads != null){
        	        
        	        $return_msg = [];
        	        foreach($leads as $cap){
        	            $envio['cap'] = $cap;
        	            $envio['link'] = $data['link'];
        	            $envio['titulo'] = $data['titulo'];
        	            //Caso de teste//if($cap->id_captura == 31){
        	            //Caso de teste//$cap->telefone = '(61)996849576';     
        	            //Caso de teste//$cap->nome = 'matheus carvalho';
        	            
        	            $telefone = str_replace("(" , "", $cap->telefone);
                	    $telefone = str_replace(")" , "", $telefone);
                	    $telefone = str_replace(" " , "", $telefone);
                	    $telefone = str_replace("-" , "", $telefone);
                	    $telefone = "55".$telefone;    
        	            
        	            $nome = $this->primeiroNome($cap->nome);
        	            
        	            $envio['mensagem'] = str_replace('{nome}', $nome, $data['mensagem']);
        	            
        	            $mensagem_final =  Template::getView('newsletter/lista_whatsapp_view', $envio);
        	            
        	            if($data['imagem'] != ''){
        	                $return = $this->zapi_whatsapp->sendImage($telefone, $data['imagem'], $mensagem_final);
        	            }
        	            else{
        	                $return = $this->zapi_whatsapp->sendMessage($telefone, $mensagem_final);
        	            }
        	            
        	            
        	            
        	            if($return != false){
        	                $log = [
        	                    'id_cadastro' => $cap->id_cadastro??0,
        	                    'id_captura' => $cap->id_captura??0,
        	                    'telefone' => $cap->telefone,
        	                    'id_lista' => $data['id_lista'],
        	                    'enviado' => 1,
        	                    'enviado_em' => date("Y-m-d H:i:s")
        	                    ];
        	                 $this->cad_model->insertLogWhatsapp($log);
        	            }
        	            else{
        	                $log = [
        	                    'id_cadastro' => $cap->id_cadastro??0,
        	                    'id_captura' => $cap->id_captura,
        	                    'telefone' => $cap->telefone,
        	                    'id_lista' => $data['id_lista'],
        	                    'enviado' => 0,
        	                    'enviado_em' => date("Y-m-d H:i:s")
        	                    ];
        	                 $this->cad_model->insertLogWhatsapp($log);    
        	            }
        	            
        	            array_push($return_msg,$return);
        	            //Caso de teste//}
        	        }
                    //dd($return_msg);
        	        $flag = true;
        	        foreach($return_msg as $r){
        	            if($r == false){
        	                $flag = false;
        	            }
        	        }
        	        
            	        
                    if($flag == false || empty($return_msg)){
                        if(empty($return_msg)){
                            //$json = ['success' => false, 'msg' => 'Nenhuma mensagem enviada!'];
                            throw new Exception('Nenhuma mensagem enviada!');
                        }
                        else{
                            $json = ['success' => true, 'msg' => 'Alguma mensagem falhou no envio, mas outras podem ter sido enviadas!'];
                        }
                    }
                    else{
                       $json = ['success' => true, 'msg' => 'Todas as mensagens estão sendo enviadas!'];
                    }
                    
        	    }
        	    else{
        	       //$json = ['success' => false, 'msg' => 'Sem leads para enviar mensagem!'];
        	       throw new Exception('Sem leads para enviar mensagem!');
        	    }
    	    }
    	    else{
    	        //$json = ['success' => false, 'msg' => 'Alguns dos campos a serem preenchidos estão vazios!'];
    	        throw new Exception('O campo mensagem está vazio!');
    	    }
    	    
    	    echo json_encode($json);
	    
    	}catch(Exception $e) {
            echo json_encode(['success' => false, 'msg' => $e->getMessage()]);
        }
	    
	}	
	
	public function enviarEmailLista(){
        $data = $this->input->post();
        
        
        //if($data == null || empty($data))
    	        //throw new Exception('Erro nos dados, contactar a TI!');
    	        
        $data['link_corretor'] = trim($data['link_corretor']);
        $data['uuid_campanha'] = trim($data['uuid_campanha']);
        //dd($data);
        //$lista = $this->cad_model->getNewsletterLista(['id', $data['id_lista']]);
        //$leads = $this->painel_model->get_sql_lista($lista);
        
        $this->load->library('newsletter/Lista_Custom');
        
	    $leads = $this->lista_custom->get_leads_lista($data['id_lista']);
        
        if(!empty($data['uuid_campanha'])){
            if($leads != null){
                
                $capturas = $leads;
                
                $return_msg = [];
                foreach($capturas as $cap){
                    //Caso de teste//if($cap->id_captura == 31){
    	            //Caso de teste//$cap->nome = 'matheus carvalho';
    	            //Caso de teste//$cap->email = 'matheus@comdono.com';
                    $nome = $this->primeiroNome($cap->nome);
                    if($data['link_corretor'] != ''){
                        $dt = [
                            "link_convite" => $data['link_corretor'],
                            "nome" => $nome
                        ];
                    }
                    else{
                        $dt = [
                            "nome" => $nome
                        ];
                    }
                    
                    
                    $arquivo = $this->cad_model->getArquivo(['nome',$data['uuid_campanha']]);
                    if($arquivo == null){
                        $arquivo = [
                            'nome'     => $data['uuid_campanha'],
                            'datetime' => date('Y-m-d H:i:s')
                            ];
                            
                        $id_arquivo = $this->cad_model->insertArquivo($arquivo);
                    }
                    else
                        $id_arquivo = $arquivo->id_arquivo;
                    
                    //dd($data['uuid_campanha'],$id_arquivo);
                    
    	            $return = Envia::email($cap->email, [$data['uuid_campanha'],$id_arquivo], $dt);
    	            array_push($return_msg,$return);
                    //Caso de teste//}
    	        }
    	        
    	        $flag = true;
    	        foreach($return_msg as $r){
    	            if($r == false){
    	                $flag = false;
    	            }
    	        }
    	        if($flag == false){
                    
                    $json = ['success' => true, 'msg' => 'Alguma mensagem falhou no envio, mas outras podem ter sido enviadas!'];
                    
                }
                else{
                    
                   $json = ['success' => true, 'msg' => 'Todas as mensagens estão sendo enviadas!'];
                }
    	        
            }
            else{
                $json = ['success' => false, 'msg' => 'Sem leads para enviar mensagem!'];
            }
            
        }
        else{
            $json = ['success' => false, 'msg' => 'Alguns dos campos a serem preenchidos estão vazios!'];
        }
        
        echo json_encode($json);
    }
	
	
}