<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

// Require the Composer autoloader.
//require APPPATH . 'libraries/vendor/autoload.php';
//define('ACCESS_KEY', "AKIAXWSGWKL2LMYZ2XSV");
//define('SECRET_KEY', "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");
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
//use Aws\Credentials\Credentials;
//use Aws\S3\S3Client;
//use Aws\S3\Exception\S3Exception;

class Painel_ajax extends Admin_Controller {

	function __construct()
	{
        parent::__construct();
        require APPPATH . 'libraries/vendor/autoload.php';
        /*if($this->session->perfil != 1)
        {   echo json_encode(['valid' => false,'erro' => 1,'msg' => 'Acesso negado!']);
	        die();
		}*/
		$this->load->model('administrativo/admin_model');
		$this->load->model('administrativo/dash_model');
		
		$this->load->library('newsletter/newsletter');
	}


    //D A S D B O A R D   A T E N D I M E N T O ------------------------------------------
    
    public function getAtendimentos()
    {
        $periodo = $this->input->post('periodo');
        $data['periodos']            = $this->dash_model->getPeriodos('getAtendimentoHistorico', 'data_hora',$periodo);
        $data['atendimentos']        = $this->dash_model->getAtendimentoHistorico();
        
        $totalPeriodos = 0;
        $ultimos = end($data['periodos'])->qnt??0;
        foreach ($data['periodos'] as $c=>$p){
            $totalPeriodos += $p->qnt;
        }
        
        if($periodo == 'dia'){
            $data['totalPeriodos'] = 'em 7 dias - '.$totalPeriodos;
            $data['ultimos']       = 'hoje - '.$ultimos;
        }elseif ($periodo == 'semana') {
            $data['totalPeriodos'] = 'em 4 semanas - '.$totalPeriodos;
            $data['ultimos']       = 'semana atual - '.$ultimos;
        }else {
            $data['totalPeriodos'] = 'em 6 meses - '.$totalPeriodos;
            $data['ultimos']       = 'mês atual - '.$ultimos;
        }
        
        echo json_encode(['valid' => true, 'data'=> $data, 'msg' => 'Sucesso!']);
    }
    
    protected function getWhereTipoInteresse($tipo)
    {
        $tiposAtendimento = 
                [
                    'captura' => 
                        [
                            'vender',                            
                            'comprar', 
                            'Vender',                            
                            'Comprar',                            
                            'Avaliação',
                            'Exclusive',
                            'Elleven',
                        ],
                    'oportunidade' => 
                        [
                            'Olx',
                        ],
                    'outros' => 
                        [
                            '',
                            'Financiamento',
                            'Outros',
                        ],
                ];
        $w = [];
        foreach ($tiposAtendimento[$tipo] as $interesse)
            $w['tipo_interesse'][] = ['tipo_interesse', $interesse];
            
        return $w;
        
    }
    

    public function getOportunidadesAtual()
    {
        $periodo = $this->input->post('periodo');
        
        $data['atendidas']      = $this->dash_model->getCountAtual('getOportunidadesAtendidas', 'data_status', $periodo);
        $data['negadas']        = $this->dash_model->getCountAtual('getOportunidadesAtendidas', 'data_status', $periodo, [['status','Negado']]);
        $data['aguardando']     = $this->dash_model->getCountAtual('getOportunidadesAtendidas', 'data_status', $periodo, [[['status','Aguardando'],['status','']]]);
        $data['aceitas']        = $this->dash_model->getCountAtual('getOportunidadesAtendidas', 'data_status', $periodo, [['status','Iniciado']]);
       
        echo json_encode($data);
    }
    
    public function getOportunidadesAnterior()
    {
        $periodo = $this->input->post('periodo');
        
        $data['atendidas']      = $this->dash_model->getCountAnterior('getOportunidadesAtendidas', 'data_status', $periodo);
        $data['negadas']        = $this->dash_model->getCountAnterior('getOportunidadesAtendidas', 'data_status', $periodo, [['status','Negado']]);
        $data['aguardando']     = $this->dash_model->getCountAnterior('getOportunidadesAtendidas', 'data_status', $periodo, [[['status','Aguardando'],['status','']]]);
        $data['aceitas']        = $this->dash_model->getCountAnterior('getOportunidadesAtendidas', 'data_status', $periodo, [['status','Iniciado']]);
       
        echo json_encode($data);
    }
    
    
    public function getAtendimentosCaptura()
    {
        $periodo = $this->input->post('periodo');
        
        $w = $this->getWhereTipoInteresse('captura');
        $data['atual']        = $this->dash_model->getCountAtual('getAtendimentoHistorico', 'data_hora', $periodo, $w);
        $data['anterior']     = $this->dash_model->getCountAnterior('getAtendimentoHistorico', 'data_hora', $periodo, $w);
        echo json_encode($data);
    }
    
    public function getAtendimentosOportunidade()
    {
        $periodo = $this->input->post('periodo');
        
        $w = $this->getWhereTipoInteresse('oportunidade');
        $data['atual']        = $this->dash_model->getCountAtual('getAtendimentoHistorico', 'data_hora', $periodo, $w);
        $data['anterior']     = $this->dash_model->getCountAnterior('getAtendimentoHistorico', 'data_hora', $periodo, $w);
        echo json_encode($data);
    }
    
    public function getAtendimentosOutros()
    {
        $periodo = $this->input->post('periodo');
        
        $w = $this->getWhereTipoInteresse('outros');
        $data['atual']        = $this->dash_model->getCountAtual('getAtendimentoHistorico', 'data_hora', $periodo, $w);
        $data['anterior']     = $this->dash_model->getCountAnterior('getAtendimentoHistorico', 'data_hora', $periodo, $w);
        echo json_encode($data);
    }
    
    //D A S D B O A R D   P R I N C I P A L ------------------------------------------
    
    public function getCapturas()
    {
        $periodo = $this->input->post('periodo');
        
        $resultado = $this->dash_model->getCapturas();
        $capturas = [
            'total'      => count($resultado),
            'completas' => 0,
            'incompletas'  => 0,
            'outros'     => 0,
             ];
        
        foreach ($resultado as $imv)
        {
            if($imv->status_captura == 0)
                $capturas['incompletas']++;
            elseif ($imv->status_captura == 1) 
                $capturas['completas']++;
            else
                $capturas['outros']++;
        }
        
        $capturas['periodos'] = $this->dash_model->getPeriodos('getCapturas','datetime_captura', $periodo);
        $capturas['atual']    = $this->dash_model->getCountAtual('getCapturas','datetime_captura',$periodo);
        $capturas['anterior'] = $this->dash_model->getCountAnterior('getCapturas','datetime_captura',$periodo);
        
        $json = ['valid' => true, 'data'=> $capturas, 'msg' => 'Sucesso!'];
           
        echo json_encode($json);
    }
    
    public function getUsuarios()
    {
        $periodo = $this->input->post('periodo');
        $resultado = $this->dash_model->getCadastros();
        $usuarios = [
            'total'       => count($resultado),
            'preCadastro' => 0,
            'ativos'      => 0,
            'outros'      => 0,
             ];
        
        foreach ($resultado as $imv)
        {
            if($imv->etapa < 2)
                $usuarios['preCadastro']++;
            elseif ($imv->etapa >= 8) 
                $usuarios['ativos']++;
            else
                $usuarios['outros']++;
        }
        
        $usuarios['periodos'] = $this->dash_model->getPeriodos('getCadastros','data_hora_cadastro', $periodo);
        $usuarios['atual']    = $this->dash_model->getCountAtual('getCadastros','data_hora_cadastro',$periodo);
        $usuarios['anterior'] = $this->dash_model->getCountAnterior('getCadastros','data_hora_cadastro',$periodo);
        
        $json = ['valid' => true, 'data'=> $usuarios, 'msg' => 'Sucesso!'];
           
        echo json_encode($json);
    }
    
    public function getImoveis()
    {
        $periodo = $this->input->post('periodo');
        $resultado = $this->dash_model->getImoveis();
        $imoveis = [
            'total'      => count($resultado),
            'publicados' => 0,
            'moderacao'  => 0,
            'outros'     => 0,
             ];
        
        foreach ($resultado as $imv)
        {
            //0 - Cadastro incompleto, 1 - Cadastro incompleto, 2 - Aguardando moderação, 3 - Publicado, 4 - Bloqueado
            if($imv->status == 3 && $imv->lixeira == 0)
                $imoveis['publicados']++;
            elseif ($imv->status == 2) 
                $imoveis['moderacao']++;
            else
                $imoveis['outros']++;
        }
        
        $w[] = ['status >=', 3];
        $w[] = ['lixeira', 0];
        
        $imoveis['periodos'] = $this->dash_model->getPeriodos('getImoveis','data_hora_imovel', $periodo, $w);
        $imoveis['atual']    = $this->dash_model->getCountAtual('getImoveis','data_hora_imovel',$periodo, $w);
        $imoveis['anterior'] = $this->dash_model->getCountAnterior('getImoveis','data_hora_imovel',$periodo, $w);
        
        $json = ['valid' => true, 'data'=> $imoveis, 'msg' => 'Sucesso!'];
           
        echo json_encode($json);
    }
    
    public function getFinanciamentos()
    {
        $periodo = $this->input->post('periodo');
        $resultado = $this->dash_model->getFinanciamentos();
        $financiamentos = [
            'total'       => count($resultado),
            'solicitados' => 0,
             ];
        
        foreach ($resultado as $imv)
        {
            if($imv->status == 1)
                $financiamentos['solicitados']++;
        }
        
        $financiamentos['periodos'] = $this->dash_model->getPeriodos('getFinanciamentos','data_simulacao', $periodo);
        $financiamentos['atual']    = $this->dash_model->getCountAtual('getFinanciamentos','data_simulacao',$periodo);
        $financiamentos['anterior'] = $this->dash_model->getCountAnterior('getFinanciamentos','data_simulacao',$periodo);
        
        $json = ['valid' => true, 'data'=> $financiamentos, 'msg' => 'Sucesso!'];
           
        echo json_encode($json);
    }
    
    public function getNegociacoes()
    {
        $periodo = $this->input->post('periodo');
        $resultado = $this->dash_model->getNegociacoes();
        $negociacoes = [
            'total'      => count($resultado),
            'andamento'  => 0
             ];
        
        foreach ($resultado as $imv)
        {
            if($imv->chat_status == 3)
                $negociacoes['andamento']++;
        }
        
        
        $negociacoes['periodos'] = $this->dash_model->getPeriodos('getNegociacoes','data_chat', $periodo);
        $negociacoes['atual']    = $this->dash_model->getCountAtual('getNegociacoes','data_chat',$periodo);
        $negociacoes['anterior'] = $this->dash_model->getCountAnterior('getNegociacoes','data_chat',$periodo);
        
        $json = ['valid' => true, 'data'=> $negociacoes, 'msg' => 'Sucesso!'];
           
        echo json_encode($json);
    }
    
    
    
    //D A S D B O A R D   P R I N C I P A L ------------------------------------------
    
    
    public function remove_depoimento_file()
    {
        $id_cadastro = $this->input->post('id_cadastro');
        
        if($id_cadastro > 0){
            
            $data['depoimento_file'] = '';
            $this->cad_model->updateCadastro($id_cadastro, $data);
        }
        
    }
    
    public function depoimento_file()
    {
        if(true){
            $json = ['valid' => true, 'imagem_path' => 'https://dev.comdono.com/themes/comdono/img/ico-file-mp3.png', 'data'=> '$data','msg' => 'Sucesso!'];
        }
        else{
            $json = ['valid' => false,'erro' => 5,'msg' => 'Falha de comunicação com o banco!'];
        }
        echo json_encode($json);
    }
    
    public function upload_img_perfil()
    {
        $id_cadastro = $this->input->post('id_cadastro');
        
        if(!($id_cadastro > 0)){
            echo json_encode(['valid' => false,'erro' => 5,'msg' => 'id_cadastro NULL']);
            die();
        }
         
        $cad = $this->admin_model->get_cadastro([], $id_cadastro);
        if($cad == null)
        {
            echo json_encode(['valid' => false,'erro' => 5,'msg' => 'Cadastro NULL']);
            die();    
        }
        
        try {
            if (!isset($_FILES['dn_img']))
                throw new Exception("File not uploaded", 1);
            $allowed_types = array( 
                'gif',     'GIF',
                'jpg',     'JPG',
                'jpeg',    'JPEG',
                'png',     'PNG',
               );
               
            $path_parts = pathinfo($_FILES["dn_img"]["name"]);
            $extension = $path_parts['extension'];
            if (!in_array($extension, $allowed_types))                                                                                                                                                                                                                                                                                                                                           
                die(json_encode(['valid' => false,'erro' => 5,'msg' => 'Tipo de arquivo não permitido!']));
            
            
            $angle = $this->get_angle_rotate($_FILES['dn_img']['tmp_name']);
            $this->rotate_image($_FILES['dn_img']['tmp_name'],$angle);
            
            
            //$credentials = new Credentials(ACCESS_KEY, SECRET_KEY);
            //$s3 = new S3Client(['version' => 'latest','region' => 'us-west-2','credentials' => $credentials]);
            //$this->load->library('easyphpthumbnail');
            //$tmp_name = $_FILES['dn_img']['tmp_name'];
            //$name = str_replace($extension, "", convertAccentsAndSpecialToNormal($_FILES['dn_img']['name'])).'.'.$extension;
            //$putImg = $this->getPutResize($tmp_name, $name, 300, $id_cadastro);
            //$resImg = $s3->putObject($putImg);
            //$imgUrl = $resImg['ObjectURL'];
            
            $tmp_name = $_FILES['dn_img']['tmp_name'];
            $name = str_replace($extension, "", convertAccentsAndSpecialToNormal($_FILES['dn_img']['name'])).'.'.$extension;
            $upload_path = 'anunciante/' . $id_cadastro .'/perfil';
            $imgUrl = Upload::putObjectResize($tmp_name, $name, 300, $upload_path);
            
            $uri = str_replace($name, "", $imgUrl);
            
            $data['dn_img'] = $name;    
            $data['dn_img_uri'] = $uri;    
            
            $upPerfil['img_perfil'] = $name;
            $upPerfil['img_perfil_uri'] = $uri;  
            
            $wup[] = ['id_cadastro', $id_cadastro];
            $wup[] = ['doc_perfil', 'cpf'];
            
            $this->cad_model->updateImoveis($wup,$data);
            
            if($this->cad_model->updateCadastro($id_cadastro, $upPerfil)){
                $json = ['valid' => true, 'imagem_path' => $imgUrl, 'data'=> $data,'msg' => 'Sucesso!'];
            }
            else{
                $json = ['valid' => false,'erro' => 5,'msg' => 'Falha de comunicação com o banco!'];
            }
            
            echo json_encode($json);  
            
        } catch(Exception $e) {
            echo json_encode(['valid' => false,'erro' => 5,'msg' => $e->getMessage()]);
        }
    }
	
	public function remove_imagem_perfil()
    {
        $id_cadastro = $this->input->post('id_cadastro');
        
        if($id_cadastro > 0){
            
            $data['img_perfil'] = '';
            $data['img_perfil_uri'] = '';
            $this->cad_model->updateCadastro($id_cadastro, $data);
            
            $dtImovel['dn_img'] = '';
            $dtImovel['dn_img_uri'] = '';
            $wup[] = ['id_cadastro', $id_cadastro];
            $wup[] = ['doc_perfil', 'cpf'];
            $this->cad_model->updateImoveis($wup,$dtImovel);
        }
    }
    
    /*private function getPutResize($tmp_name, $name, $width, $id_cadastro)
    {
        $resize = new easyphpthumbnail;
        		$resize->Thumblocation = $tmp_name;
        		$resize->Thumbfilename = $name;
        		$resize->Thumbwidth = $width;
        		$resize->Quality = 60;
        		$resize->Createthumb($tmp_name, 'file');
        
        $key = 'anunciante/' . $id_cadastro .'/perfil/'.$name;
        
        return [
            'ACL' => 'public-read',
            'Bucket' => getenv('S3_BUCKET'),
            'Key'    => $key,
            'SourceFile' => $resize->Thumblocation.$resize->Thumbfilename,
            'ContentDisposition' => 'inline; filename='.$tmp_name,
            ];
    }*/
    
    private function get_angle_rotate($filename)
    {
        
        $info = getimagesize($filename);
        $rotate = 0;
        
        if ($info['mime'] == 'image/jpeg')
        {
            $image = imagecreatefromjpeg($filename);
            $exif = @exif_read_data($filename);
            
            if(!empty($exif['Orientation'])) {
                //echo $exif['Orientation'];
                switch($exif['Orientation']) {
                    case 8:
                        $rotate = 90;
                        break;
                    case 3:
                        $rotate = 180;
                        break;
                    case 6:
                        $rotate = 270;
                        break;
                }
            }
        }   
        
        return $rotate;
    }
    
    private function rotate_image($filename,$angle)
    {
        if($angle != 0)
        {
            $this->image_lib->clear();
        
            $config=array();
            $config['image_library'] = 'GD2';
            $config['create_thumb'] = FALSE; //No thumbnail
            $config['source_image'] = $filename; //full path for the source image
            $config['rotation_angle'] = $angle;//
        
            $this->image_lib->initialize($config);
        
            //Rotate the image
            if (!$this->image_lib->rotate()){
                echo $this->image_lib->display_errors();
            }
        }
    }
    
    
    //F I A N C I A M E N T O ------------------------------------------
    
    public function email_propostas()
    {
        $id_simulacao = $this->input->post('id');
        $simulacao = $this->admin_model->getSimulacaoFinanciamento(['a.id_simulacao'=>$id_simulacao]);
        if(count($simulacao->bancos??[]) > 0){
            
            $data['anexo'] = [];
            foreach ($simulacao->bancos as $banco)
            {
                if($banco->file_url != '')
                    $data['anexo'][] = $banco->file_url;
            }
             
            if(!empty($data['anexo'])){
                
                $cad_interessado = $this->admin_model->getCadastro([['id_cadastro', $simulacao->id_cad_interessado]]);
                
                $data['linkcustom'] = base_url().'minha_conta/minhas_compras/comparativo/'.$id_simulacao;
                $data['nome_comprador'] = primeiroNome($cad_interessado->nome);
                if($this->newsletter->envia($cad_interessado->email, 56, $data))
                {
                    $simulacao->email_propostas++;
                    if($simulacao->historico_email != '')
                    {
                        $historico_email = json_decode($simulacao->historico_email);
                        $historico_email[] = ['anexo' => $data['anexo'], 'data'=> date("Y-m-d H:i:s")];
                        $simulacao->historico_email = json_encode($historico_email);
                    }
                    else
                    {
                        $simulacao->historico_email = json_encode([['anexo' => $data['anexo'], 'data'=> date("Y-m-d H:i:s")]]);
                    }
                    
                    $this->admin_model->updateSimulacao($simulacao->id_simulacao,(array)$simulacao);
                    
                    $json = ['valid' => true,'msg' => 'Email enviado com Sucesso!'];
                }
                else{
                    $json = ['valid' => false,'msg' => 'erro!'];
                }
                
            }else
            {
                $json = ['valid' => false,'msg' => 'erro! Nenhum PDF anexo encontrado!'];
            }
                
        }else{
            $json = ['valid' => false,'msg' => 'erro! Nenhum Banco Cadastrado!'];
        }
        
        echo json_encode($json);
    }
    
       
       
       
       
       
       
       
       
       
       
       
       
       
       
       
       
       
       
       
       
       
       
       
       
       
       
       
       
       
       
       
}