<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Dash_model extends Cad_model
{
    function __construct() {
        parent::__construct();
    }
    
    function select($select)
    {
        $this->db->select($select);
        return $this;
    }
    
    function group_by($group_by)
    {
        $this->db->group_by($group_by);
        return $this;
    }
    
    //=======================================================================================
    
    function getImoveis($where = []) 
    {
        return $this->getResult('cad_imovel', $where);
    }
    
    function getImoveis_sum_group($where = []) 
    {
        $this->db->select('bairro, count(*) as qnt, (SUM(`val_pretendido`)/ count(*)) as val_medio, SUM(`val_pretendido`) as val_total, SUM(`val_public_total`) as ticket_medio');
        $this->db->group_by('bairro');
        
        return $this->getResult('cad_imovel', $where);
    }
    
    function getCapturas($where = [])
	{
	    return $this->getResult('cad_captura', $where);
	}
	
	function getCadastros($where = [])
	{
	    return $this->getResult('cad_cadastro', $where);
	}
	
	function getFinanciamentos($where = [])
	{
	    return $this->getResult('fnc_simulacao', $where);
	}
	
	function getNegociacoes($where = [])
	{
	    return $this->getResult('ngc_chat', $where);
	}
	
	function getAtendimentoHistorico($where = [])
	{
	    return $this->getResult('cad_atendimento_historico', $where);
	}
	
	function getAtendimentoHistorico_count($where = [])
	{
	    $this->db->select('id_user as id_cadastro, nome, count(*) qnt');
	    
	    $this->db->join('cad_cadastro as b', 'a.id_user = b.id_cadastro', 'left');
	    
	    $this->db->group_by('id_user');
	    
	    return $this->getResult('cad_atendimento_historico as a', $where);
	}
	
	function getInformativos($where = []) 
    {
        //$this->db->order_by("data_cadastro", "desc");
        $this->db->order_by("priority", "asc");
        return $this->getResult('cad_informativo', $where);
    }
	
	function getOportunidadesAtendidas($where = [])
	{
	    //$this->db->select('id_user as id_cadastro, nome, count(*) qnt');
	    $where[] = ['tb_origem', 'crawler_olx'];
	    $this->db->join('cad_atendimento as b', 'a.id = b.id_rel', 'left');
	    //$this->db->group_by('id_user');
	    
	    return $this->getResult('crawler_olx as a', $where);
	}
	
	protected function objectVazio($date)
	{
	    return (object)[
                'ano'    => date("Y",$date),
                'mes'    => date("m",$date),
                'semana' => date("W",$date),
                'dia'    => date("d",$date),
                'qnt'    => 0,
                ];
	}
	
	//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	
	/*function select($select, $func, $where = [])
	{
	    $this->db->select($select);
	    return call_user_func([$this,$func],$where);
	}*/
	
	function getPeriodos($func, $campo_data, $periodo = 'mes' , $where = [])
	{
	    $return = [];
	    if($periodo == 'dia'){
            $limit = 7;
	        for ($i = 0; $i <= $limit; $i++) {
	            $this->db->select("YEAR($campo_data) as ano, MONTH($campo_data) as mes, WEEK($campo_data) as semana, DAY($campo_data) as dia,  count(*) as qnt");
	            $date_anterior = mktime(date("H"), date("i"), date("s"), date("m") , date("d") - ($limit-$i), date("Y"));
	            $w = $where;
	            $w[] = ["YEAR($campo_data)",date("Y",$date_anterior)];
	            $w[] = ["MONTH($campo_data)",date("m",$date_anterior)];
	            $w[] = ["DAY($campo_data)",date("d",$date_anterior)];
	            $result = call_user_func([$this,$func],$w)[0]??[];
                $return[] = ($result->qnt == 0) ? $this->objectVazio($date_anterior) : $result;
            }
            return $return;
	    }
	    elseif ($periodo == 'semana') {
	        $limit = 4;
	        for ($i = 0; $i <= $limit; $i++) {
	            $this->db->select("YEAR($campo_data) as ano, MONTH($campo_data) as mes, WEEK($campo_data) as semana, DAY($campo_data) as dia,  count(*) as qnt");
	            $date_anterior = mktime(date("H"), date("i"), date("s"), date("m") , date("d") - (($limit-$i)*7)-7, date("Y"));
	            $w = $where;
	            $w[] = ["YEAR($campo_data)",date("Y",$date_anterior)];
	            $w[] = ["WEEK($campo_data)",date("W",$date_anterior)];
	            $result = call_user_func([$this,$func],$w)[0]??[];
                $return[] = ($result->qnt == 0) ? $this->objectVazio($date_anterior) : $result;
            }
            return $return;
	        
	        
	    }else {
	        $limit = 6;
	        for ($i = 0; $i <= $limit; $i++) {
	            $this->db->select("YEAR($campo_data) as ano, MONTH($campo_data) as mes, WEEK($campo_data) as semana, DAY($campo_data) as dia,  count(*) as qnt");
	            $date_anterior = mktime(date("H"), date("i"), date("s"), date("m") - ($limit-$i), date("d") , date("Y"));
	            $w = $where;
	            $w[] = ["YEAR($campo_data)",date("Y",$date_anterior)];
	            $w[] = ["MONTH($campo_data)",date("m",$date_anterior)];
	            $result = call_user_func([$this,$func],$w)[0]??[];
                $return[] = ($result->qnt == 0) ? $this->objectVazio($date_anterior) : $result;
            }
            return $return;
	    }
	}
	
	function getAtual($func, $campo_data, $periodo = 'mes', $where = [])
	{
	    if($periodo == 'dia')
	    {
	        $where[] = ["YEAR($campo_data)",date("Y")];
	        $where[] = ["MONTH($campo_data)",date("m")];
	        $where[] = ["DAY($campo_data)",date("d")];
	    }
	    elseif ($periodo == 'semana') {
	        
	        $date_anterior = mktime(date("H"), date("i"), date("s"), date("m"), date("d")-7, date("Y"));
	        $where[] = ["YEAR($campo_data)",date("Y")];
	        $where[] = ["WEEK($campo_data)",date("W",$date_anterior)];
	        
	    }else {
	        $where[] = ["YEAR($campo_data)",date("Y")];
	        $where[] = ["MONTH($campo_data)",date("m")];
        }
	    
	    return call_user_func([$this,$func],$where);
	    
	}
	
	function getAnterior($func, $campo_data, $periodo = 'mes', $where = [])
	{
	    if($periodo == 'dia')
	    {
	        $date_anterior = mktime(date("H"), date("i"), date("s"), date("m"), date("d")-1, date("Y"));
	        $where[] = ["YEAR($campo_data)",date("Y", $date_anterior)];
	        $where[] = ["MONTH($campo_data)",date("m", $date_anterior)];
	        $where[] = ["DAY($campo_data)",date("d", $date_anterior)];
	    }
	    elseif ($periodo == 'semana') {
	        
	        $date_anterior = mktime(date("H"), date("i"), date("s"), date("m"), date("d")-14, date("Y"));
	        $where[] = ["YEAR($campo_data)",date("Y", $date_anterior)];
	        $where[] = ["WEEK($campo_data)",date("W",$date_anterior)];
	        
	    }else {
	        $date_anterior = mktime(date("H"), date("i"), date("s"), date("m") - 1, date("d") , date("Y"));
	        $where[] = ["MONTH($campo_data)",date("m", $date_anterior)];
	        $where[] = ["YEAR($campo_data)",date("Y", $date_anterior)];
        }
	    
	    return call_user_func([$this,$func],$where);
	}
	
	function getCountAtual($func, $campo_data, $periodo = 'mes', $where = [])
	{
	    return count($this->getAtual($func, $campo_data, $periodo, $where));
	    
	}
	
	function getCountAnterior($func, $campo_data, $periodo = 'mes', $where = [])
	{
	    return count($this->getAnterior($func, $campo_data, $periodo, $where));
	}
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
}