<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Fluxo_model extends Cad_model
{
    function __construct() {
        parent::__construct();
    }

    function getResult($tb, $where = []) 
    {
        $this->where($where,[]);
        $query = $this->db->get($tb);
        
        if ($query->num_rows() > 0) 
            return $query->result();
        return [];
    }
    
    function getRow($tb, $where = []) 
    {
        $this->where($where,[]);
        $query = $this->db->get($tb);
        
        if ($query->num_rows() > 0) 
            return $query->row();
        return null;
    }
    
    function XXXupdate($tb, $where = [],$data)
	{
	   if($where == null)
	       return false;
	       
	    $this->where($where,[]);   
	    return $this->db->update($tb, $data);
	}
	
	function randLimit($limit, $campo = 'id')
	{
	    $this->db->order_by($campo, 'RANDOM');
	    $this->db->limit($limit);
	    return $this;
	}
	
	//-------------------------------------------------------------------------------------------
	
    function getSequencia($where = [])
    {
        $this->db->order_by('sequencia', 'asc');
        $this->db->join('flx_lista as b', 'b.id_lista = a.id_lista');
        return $this->getResult('flx_quadro_rel_lista as a',$where);
    }
    
    //flx_card_rel_cadastro
    
    
    function getQuadros($where = []) 
    {
        return $this->getResult('flx_quadro',$where);
    }
    
    function getQuadro($where = []) 
    {
        return $this->getRow('flx_quadro',$where);
    }
    
    function getListas($where = []) 
    {
        $this->db->order_by('sequencia', 'asc');
        $this->db->join('flx_quadro_rel_lista as b', 'b.id_lista = a.id_lista');
        
        return $this->getResult('flx_lista as a',$where);
    }
    
    function getLista($where = []) 
    {
        return $this->getRow('flx_lista',$where);
    }
    
    function getCards($where = []) 
    {
        return $this->getResult('flx_card as a',$where);
    }
    
    function getCard($where = [])
    {
        return $this->getRow('flx_card as a',$where);
     
    }
    
    function getOlxs($where = []) 
    {
        return $this->getResult('crawler_olx',$where);
     
    }
    
    function getOlx($where = []) 
    {
        return $this->getRow('crawler_olx',$where);
     
    }
    
    function getHistorico($where = []) 
    {
        $this->db->join('cad_cadastro', 'cad_cadastro.id_cadastro = flx_card_hist.id_cadastro');
        return $this->getResult('flx_card_hist',$where);
    }
    
    //C O N T R E L  E  D E   A C E S S O --------------------------------------------------------------
    
    
    function getListasPerfil($id_quadro) 
    {
        $perfil = $this->session->perfil;
        $w[] = ['a.id_quadro', $id_quadro];
        if(!Cad_model::perfilAdmin($perfil))
        {
            $w[] = ['id_perfil', $perfil];
            $this->db->join('flx_lista_rel_perfil as c', 'c.id_lista = a.id_lista');
            $this->db->group_by('a.id_lista');
        }
        return $this->getListas($w);
    }
    
    function getCardsPerfil($id_lista) 
    {
        $w[] = ['a.id_lista', $id_lista];
        if(!Cad_model::perfilAdmin($this->session->perfil)){
            
            $this->db->select('*, a.id_cadastro as id_cadastro');
            
            $w[] = ['c.id_cadastro', $this->session->id_cadastro];
            $this->db->join('flx_card_rel_cadastro as c', 'c.id_card = a.id_card');
            $this->db->group_by('a.id_card');
        }
        
        return $this->getCards($w);
    }
    
    function getCardPerfil($w) 
    {
        if(!Cad_model::perfilAdmin($this->session->perfil)){
            
            $this->db->select('*, a.id_cadastro as id_cadastro');
            
            $w[] = ['c.id_cadastro', $this->session->id_cadastro];
            $this->db->join('flx_card_rel_cadastro as c', 'c.id_card = a.id_card');
            $this->db->group_by('a.id_card');
        }
        
        return $this->getCard($w);
    }
    
    function getPermicoesPerfil($where = []) 
    {
        $where[] = ['id_cadastro',  $this->session->id_cadastro];
        return $this->getResult('cad_atendimento_permissao',$where);
    }
    
    
    // I N S E R T ==================================================================================
    function insertCard($data)
	{
	    $this->db->insert('flx_card', $data);
	    $id_card = $this->db->insert_id();
	    MFluxo::setHistorico($id_card, 'Iniciou Fluxo');
	    $this->insertResponsavel(['id_card' => $id_card, 'id_cadastro' => $data['id_responsavel']]);
	    return  $id_card;
	}
	
	function insertHistorico($data){
	    $this->db->insert('flx_card_hist', $data);
	    return  $this->db->insert_id();
	}
	
	function insertResponsavel($data){
	    $this->db->insert('flx_card_rel_cadastro', $data);
	    return  $this->db->insert_id();
	}
	
	// D E L E T E ==================================================================================
	
	function removeResponsavel($where = null)
	{   
	    if($where == null)
	        return false;
	        
	    $this->where($where);
	    return $this->db->delete('flx_card_rel_cadastro');
	}
	
	// U P D A T E ==================================================================================
	
	function updateCard($where = null,$data)
	{   
	    if($where == null || $data == null)
	        return false;
	    $this->where($where);    
	    return $this->update('flx_card',  $data);
	}  
	
	function updateOlx($where = null,$data)
	{   
	    if($where == null || $data == null)
	        return false;
	    $this->where($where);     
	    return $this->update('crawler_olx',  $data);
	} 
    
    /*function atualizaHistorico($where = []){
        $data = ['saiu_lista' => date('Y-m-d H:i:s')];
        
        $this->update('flx_card_hist', $where, $data);
    }*/
    
    function getImoveis($where = [], $like = [], $or_where = [], $or_like = [], $order_by = [], $config = true) 
    {
        $this->db->select('*, a.id_imovel as id_imovel, a.id_cadastro as id_cadastro');
        if($config)
            $this->config_default_campanhas();
        $this->where($where, $or_where);
        $this->like($like, $or_like);
        $this->order_by($order_by);
        
        $this->db->order_by('val_pretendido', 'ASC');
        //$this->db->join('cad_img as b', 'b.id_imovel = a.id_imovel','left');
        
        $query = $this->db->get('cad_imovel as a');
        // echo( $this->db->last_query());
        if ($query->num_rows() > 0)
        {
            $result = $query->result();
            $imoveis = [];
            $imagens = [];
            
            foreach($result as $obj)
            {
                //$obj->val_pretendido += $obj->val_public_total;
                $id = $obj->id_imovel;
                $imoveis[$id] = self::mGetImovel($obj);
                if( true)
                //if( $obj->id_img??'' == '')
                    //$imagens[$id] = [];
                    $imagens[$id] = $this->db->where('id_imovel', $id)->order_by('priority', 'ASC')->limit(3)->get('cad_img')->result();
                else  
                     $imagens[$id][] = self::mGetImagem($obj);
                
                $imoveis[$id]->imagens = $imagens[$id];
            }
            return $imoveis;
        }
            
        return [];
    }
    
    function getImovel($where = [], $like = [], $or_where = [], $or_like = [], $order_by = [], $config = true) 
    {
        $this->db->select('*, a.id_imovel as id_imovel, a.id_cadastro as id_cadastro');
        //if($config)
            //$this->config_default_campanhas();
        $this->where($where, $or_where);
        $this->like($like, $or_like);
        $this->order_by($order_by);
        $this->db->order_by('priority', 'ASC');
        $this->db->join('cad_img as b', 'b.id_imovel = a.id_imovel','left');
        $query = $this->db->get('cad_imovel as a');
        //echo( $this->db->last_query());
        if ($query->num_rows() > 0)
        {
            $result = $query->result();
            $imagens = [];
            
            foreach($result as $obj)
            {
                $id = $obj->id_imovel;
                //$obj->val_pretendido += $obj->val_public_total;
                $imovel = self::mGetImovel($obj);
                if( $obj->id_img == '')
                    $imagens[$id] = [];
                else 
                     $imagens[$id][] = self::mGetImagem($obj);
                
                $imovel->imagens = $imagens[$id];
            }
            return $imovel;
        }
        return null;
    }
    
}

class MFluxo extends Fluxo_model
{
    static protected $model = null;
    
    static function iniFluxo_model()
    {
        if(self::$model == null)
            self::$model = new Fluxo_model(); 
    }
    
    static function fluxo_model()
    {
        self::iniFluxo_model();
        return self::$model; 
    }
    
    static function iniCardImovel($imovel, $origem = 'iniCardImovel', $id_lista = 1, $id_responsavel = 0, $obs = null, $perfilExecutor = null)
    {
            $card['titulo']         = "[".$imovel->id_imovel."] [".$imovel->id_cadastro."] [".$imovel->bairro."] ".$imovel->endereco;
            $card['id_cadastro']    = $imovel->id_cadastro;
            $card['id_imovel']      = $imovel->id_imovel;
            $card['id_lista']       = $id_lista;
            $card['data_criacao']   = date("Y-m-d H:i:s");
            $card['origem']         = $origem;
            $card['id_responsavel'] = $id_responsavel;
            $card['obs']            = $obs??'Iniciou Automatico no Cadastro';
            
    	    self::$db->insert('flx_card', $card);
    	    $id_card = self::$db->insert_id();
            
            if($id_card){
        	    self::setHistorico($id_card, 'Iniciou Fluxo',[],'card',$perfilExecutor);
        	    self::setHistorico($id_card, 'Iniciou cadastro',[],'imovel',$perfilExecutor);
        	    if($id_responsavel > 0)
        	        self::$db->insert('flx_card_rel_cadastro', ['id_card' => $id_card, 'id_cadastro' => $id_responsavel]);
            }
    	    return $id_card;
    }
    
    static function finalizouCadImovel($id_imovel, $arrayUpdate,  $perfilExecutor = null)
    {
        $imovel = self::fluxo_model()->getImovel([['a.id_imovel', $id_imovel]]);
        $card = self::fluxo_model()->getCard([['id_imovel', $id_imovel]]);
        //Cria card se nao existir
        if($card == null){
            $id_card = sefl::iniCardImovel($imovel, 'editImovel', 1, 0, 'Iniciou Automatico no Finaliza Cadastro');
        }
        else{
            $id_card = $card->id_card;
        }
        //seta historio de alteracao
        self::setHistorico($id_card, 'Finalizou Cadastro', $arrayUpdate, 'imovel', $perfilExecutor);
		
		/*
        1	*Aguardando Atendimento	        2	Cadastro do Dono        3	Cadastro de Imóvel        4	Agendar Visita/Fotos        
        5	*Aguardando Visita/Fotos        6	Fotos        7	Edição        8	Vídeo        9	Aguardando moderação        
        10	Publicado        11  lixeira
        */
        
        $id_lista = 9; //Aguardando moderação
		if($imovel->fotos_profissionais == 'on')
		    $id_lista = 4; //Agendar Visita/Fotos
		    
		$updateCard['titulo']         = "[".$imovel->id_imovel."] [".$imovel->id_cadastro."] [".$imovel->bairro."] ".$imovel->endereco;
		$updateCard['id_lista']       = $id_lista;  
		
		self::setHistorico($id_card, 'Saiu da lista', [], 'card', $perfilExecutor);
        self::fluxo_model()->updateCard([['id_card',$id_card]],$updateCard);
        self::setHistorico($id_card, 'Entrou na lista', [], 'card', $perfilExecutor);
		
    }
    
    
    static function imovel($id_imovel, $arrayUpdate = [],  $descricao = 'Editar Imovel', $perfilExecutor = null)
    {
        self::editImovel($id_imovel, $arrayUpdate, $perfilExecutor = null, $descricao = 'Editar Imovel');
    }
    
    
    static function editImovel($id_imovel, $arrayUpdate, $perfilExecutor = null, $descricao = 'Editar Imovel')
    {
        $imovel = self::fluxo_model()->getImovel([['a.id_imovel', $id_imovel]]);
        $card = self::fluxo_model()->getCard([['id_imovel', $id_imovel]]);
        //Cria card se nao existir
        if($card == null)
            $id_card = self::iniCardImovel($imovel, 'editImovel', 1, 0, 'Iniciou Automatico no Edit Imovel',$perfilExecutor);
        else
            $id_card = $card->id_card;
        
        //seta historio de alteracao
        self::setHistorico($id_card, $descricao, $arrayUpdate, 'imovel', $perfilExecutor);
        
		/*
		L I S T A S
		
        1	*Aguardando Atendimento	        2	Cadastro do Dono        3	Cadastro de Imóvel        4	Agendar Visita/Fotos        
        5	*Aguardando Visita/Fotos        6	Fotos        7	Edição        8	Vídeo        9	Aguardando moderação        
        10	Publicado        11  lixeira        12  Bloqueado
        */
		
		//verifica se foi parar lixeira, mover para lista de excluido pelo usuario
		//	0 - Visivel, 1 - oculto, 2 - lixeira, 3 - lancamento lixeira, 4 - excluido
		if($imovel->lixeira >= 2)//2 - lixeira, 3 - lancamento lixeira, 4 - excluido
		    self::moveCard($id_card, 11, $perfilExecutor);//11  lixeira
		
		//verifica status imovel para mover o card em caso de publicar, moderar, bloquear
		//0 Cadastro incompleto, 1 - Cadastro incompleto, 2 - Aguardando moderação, 3 - Publicado, 4 - Bloqueado
		
		elseif ($imovel->status == 2)//2 - Aguardando moderação
		    self::moveCard($id_card, 9, $perfilExecutor);//9 -   lista   Aguardando moderação
		    
		elseif ($imovel->status == 3)//3 - Publicado
	    	self::moveCard($id_card, 10, $perfilExecutor);//10 - lista   Publicado
		
		elseif ($imovel->status == 4)//4 - Bloqueado
		    self::moveCard($id_card, 12, $perfilExecutor);//12 - lista   Bloqueado
		
	
    }
    
    static function moveCard($id_card, $id_lista, $perfilExecutor = null)
    {
        self::setHistorico($id_card, 'Saiu da lista', [], 'card', $perfilExecutor);
        self::fluxo_model()->updateCard([['id_card',$id_card]],['id_lista'=>$id_lista]);
        self::setHistorico($id_card, 'Entrou na lista', [], 'card', $perfilExecutor);
        
    }
    
    
    
    
    
    static function editCardImovel($id_imovel, $data)
    {
        dd('FLUXO MODEL - se cair aqui, avisar o Ramon');
    }
    
    
    
    static function setHistorico($id_card, $descricao = '', $dados_alterados = [], $tipo_log = 'card', $id_perfil = null)
    {
        self::$db->where('id_card',$id_card);
        self::$db->join('flx_lista as b', 'b.id_lista = a.id_lista');
        $query =  self::$db->get('flx_card as a');
        
        if ($query->num_rows() == 0)
            return false;
        
        $card = $query->row();
        
        $historico = [
                        'id_quadro'     => $card->id_quadro??0,
                        'id_lista'      => $card->id_lista??0,
                        'id_imovel'     => $card->id_imovel??0,
                        'id_card'       => $id_card,
                        'id_cadastro'   => self::$CI->session->id_cadastro,
                        'descricao'     => $descricao,
                        'encode'        => json_encode($dados_alterados),
                        'tipo_log'      => $tipo_log,
                        'tipo_perfil'   => self::getPerfil($id_perfil)
                        
        	                ];
        
        self::$db->insert('flx_card_hist', $historico);
	    return  self::$db->insert_id();
    }
    
    static function getPerfil($id)
    {
        if($id === null)
            $id = self::$CI->session->perfil;
            
        if($id == 0)
            return 'Usuário';
        
        return self::$db->where('id_perfil',$id)->get('sys_perfil')->row()->perfil??'indefinido';
    }
    
    
    
    
    
    
    
    
    
    
    
    
    
}