<div class="animated fadeIn">
    <div class="row">
        <div class="col-lg-4">
            <div class="card card-accent-primary">
                <div class="card-header"><i class="icon-home"></i> Dados do imóvel</div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="align-box-img">
                                <div class="container-img custom-file container-img-img <?php e(($imovel->imagens[0]??'') != "" ? "" : "d-none"); ?>">
                                    <div class="box-doc divImgPerfil" style="background-image: url('<?php e(($imovel->imagens[0]->uri??'').($imovel->imagens[0]->imagem??''))?>');"></div>
                                </div> 
                            </div>
                            <!-- /.box-info-->
                            <div class="box-info-perfil">
                                <div><strong>Valor:</strong> <?php e($imovel->val_pretendido) ?> </div>
                                <div><strong>Bairro:</strong> <?php e($imovel->bairro) ?></div>
                                <div><strong>Endereço:</strong> <?php e($imovel->endereco) ?></div>
                                <div><strong>Tipo do imóvel:</strong> <?php e($imovel->tipo_imovel) ?></div>
                                <div><strong>Área privativa:</strong> <?php e($imovel->area_total) ?> m²</div>
                                <div><strong>Quarto(s):</strong> <?php e($imovel->quartos) ?> | <strong>Vaga(s):</strong> <?php e($imovel->vaga) ?> | <strong>Banheiro(s):</strong> <?php e($imovel->banheiros) ?></div>
                                <input type="hidden" name="" id="id_imovel" data-id_imovel='<?php e($imovel->id_imovel) ?>'>
                                
                                <div class="btn-group mt-2" role="group">
                                    
                                    <?php if($imovel->id_imovel_rel == 0 && $imovel->lancamento == "Sim"){ ?>
                                    <a href="<?php e(base_url('lancamento/'.$imovel->id_imovel));?>" target="_blank" class="btn btn-sm btn-primary" >Ver página</a>
                                    <?php }else{ ?>
                                    <a href="<?php e(base_url('imovel/'.$imovel->id_imovel));?>" target="_blank" class="btn btn-sm btn-primary" >Ver imóvel</a>
                                    <?php } ?>
                                    
                                    <a href="<?php e(base_url('administrativo/braco_direito/edit/'.$imovel->id_imovel))?>" target="_blank" class="btn btn-sm btn-success"><i class="icon-pencil"></i> Editar</a>
                                    
                                    <a href="<?php e(base_url('administrativo/operacao/quadro/1#imovel_'.$imovel->id_imovel));?>" target="_blank" class="btn btn-sm btn-primary" >Ver card</a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="box-title-section mt-4">
                        <div class="form-inline">
                            <div class="form-group">
                                <label class="text-value" for="periodo">Dados do dono</label>
                            </div>
                        </div>
                        <hr>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <div class="align-box-img">
                                <div class="container-img custom-file container-img-img <?php e($cadastro->img_perfil != "" ? "" : "d-none"); ?>">
                                    <div class="box-doc divImgPerfil" <?php if ($cadastro->img_perfil != ""){ ?> style="background-image: url('<?php e($cadastro->img_perfil_uri.$cadastro->img_perfil)?>');" <?php } ?>></div>
                                </div> 
                            </div>
                            <!-- /.box-info-->
                            <div class="box-info-perfil">
                                <input type="hidden" name="" id="dados_perfil" data-dados_perfil='<?php e(json_encode($cadastro)) ?>'>
                                <?php e(($cadastro->etapa < 8)?'<div><span class="badge badge-warning">Cadastro incompleto</span></div>':''); ?>
                                <div><strong>Nome:</strong> <?php e($cadastro->nome); ?></div>
                                <div><strong>Perfil:</strong> <?php e(($cadastro->comprador==1)?'Comprador':''.' '.($cadastro->vendedor==1)?'Vendedor':''); ?></div>
                                <div><strong>E-mail:</strong> <?php e($cadastro->email); ?></div>
                                <div><strong>Telefone:</strong> <?php e($cadastro->telefone); ?></div>
                                <div><strong>CPF:</strong> <?php e($cadastro->cpf); ?></div>
                                <div><strong>Data de nascimento:</strong> <?php e($cadastro->data_nascimento); ?></div>
                                <div class="btn-group mt-2" role="group">
                                    <a href="<?php e(base_url('administrativo/usuarios/perfil/').$cadastro->id_cadastro)?>" target="_blank" class="btn btn-sm btn-success">Detalhes do perfil</a>
                                </div>
                                <input type="hidden" name="" id="id_cadastro" value="<?php e($cadastro->id_cadastro); ?>">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        
            <div class="card card-accent-primary">
                <div class="card-header"><i class="icon-home"></i>Historico do Imovel</div>
                <div class="card-body">
                    <div class="table-container table-responsive">
                        <table class="display table table-striped table-bordered" style="width:100%">
                            <thead>
                                <tr>
                                    <th>Ação</th>
                                    <th>Usuario</th>
                                    <th>Data</th>
                                    <th>Perfil</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach($historico as $log) { ?>
                                    <tr class="trData">
                                        <td><span class="d-none"><?php e($log->data_hora); ?></span><?php e($log->descricao); ?></td>
                                        <td><?php e($log->nome); ?></td>
                                        <td><span class="d-none"><?php e($log->data_hora); ?></span><?php e(date('d/m/Y',strtotime($log->data_hora))); ?></td>
                                        <td><?php e($log->tipo_perfil); ?></td>
                                    </tr>
                                <?php } ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
            <!-- /.col-->
        
        
        <div class="col-lg-8">
            <!--<div class="box-title-section">
                <div class="form-inline">
                    <div class="form-group">
                        <label class="text-value text-primary" for="periodo">Situação atual</label>
                    </div>
                </div>
                <hr>
            </div>-->
            <!-- /.box-title-section-->
            <div class="row">
                <div class="col-lg-6">
                    <div class="card text-white <?php e($bgSituacao); ?>">
                        <div class="card-body">
                            <div class="text-value">Situação</div>
                                <div><?php e($situacaImovel); ?></div>
                            <div class="progress progress-white progress-xs my-2">
                                <div class="progress-bar" role="progressbar" style="width: <?php e($porcentoCompleto) ?>%" aria-valuenow="<?php e($porcentoCompleto) ?>" aria-valuemin="0" aria-valuemax="100"></div>
                            </div>
                            <small class="text-muted">Etapa <?php e($imovel->step) ?> / 11 - Requisitos <?php e($contCompletos .' / '.$numeroRequesitos) ?></small>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6">
                    <?php if ($imovel->lixeira > 0 ){ ?>
                        <div class="card text-white <?php e($bgLixeira)?> ">
                            <div class="card-body">
                                <div class="text-value"><?php e($statusLixeira)?></div>
                                <div>Status: <?php e(HImovel::getStatus($imovel->status)->text)?></div>
                                <div class="progress progress-white progress-xs my-2">
                                <!--<div class="progress-bar" role="progressbar" style="width: 25%" aria-valuenow="25" aria-valuemin="0" aria-valuemax="100"></div>-->
                                </div>
                                    
                                <a href="#" class="btn btn-sm btn-info btnRestaurarImovel">Restaurar</a>
                                    
                                <?php if ($imovel->status != 2): ?>
                                    <a href="#" class="btn btn-sm btn-warning btnModerarImovel">Enviar para Moderação</a>
                                <?php endif; ?>
                                <?php if ($imovel->status != 3): ?>
                                    <a href="#" class="btn btn-sm btn-success btnPublicarImovel">Publicar</a>
                                <?php endif; ?>
                                <?php if ($imovel->status != 4): ?>
                                    <a href="#" class="btn btn-sm btn-danger" type="button" data-toggle="modal" data-target="#dangerModal">Bloquear</a> 
                                <?php endif; ?>
                            </div>
                        </div>
                    <?php }else{ ?>
                        <div class="card text-white <?php e(HImovel::getStatus($imovel->status)->bdg)?> ">
                            <div class="card-body">
                                <div class="text-value"><?php e(HImovel::getStatus($imovel->status)->text)?></div>
                                <div>...</div>
                                <div class="progress progress-white progress-xs my-2">
                                <!--<div class="progress-bar" role="progressbar" style="width: 25%" aria-valuenow="25" aria-valuemin="0" aria-valuemax="100"></div>-->
                                </div>
                                <?php if ($imovel->status != 2): ?>
                                    <a href="#" class="btn btn-sm btn-warning btnModerarImovel">Enviar para Moderação</a>
                                <?php endif; ?>
                                <?php if ($imovel->status != 3): ?>
                                    <a href="#" class="btn btn-sm btn-success btnPublicarImovel">Publicar</a>
                                <?php endif; ?>
                                <?php if ($imovel->status != 4): ?>
                                    <a href="#" class="btn btn-sm btn-danger" type="button" data-toggle="modal" data-target="#dangerModal">Bloquear</a> 
                                <?php endif; ?>
                            </div>
                        </div>
                    <?php } ?>
                </div>
            </div>
            
            <div class="row  card-destaque_">
                <div class="col-lg-6">
                    <div class="card">
                        <div class="card-body p-0 d-flex align-items-center">
                            <i class="<?php $check = 0; e($imovel->dn_img!='' ? "icon-like bg-success":"icon-dislike bg-danger"); ?> p-4 font-2xl mr-3"></i>
                            <div class="w-100">
                                <div class="text-value-sm">Foto de perfil</div>
                                <div class="text-right">
                                    <a href="<?php e(base_url('administrativo/braco_direito/edit/'.$imovel->id_imovel));?>" target="_blank" class="btn btn-sm btn-ghost-primary mr-2">
                                        <i class="icon-pencil"></i>&nbsp;Editar
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="card">
                        <div class="card-body p-0 d-flex align-items-center">
                            <i class="<?php e($imovel->doc_propriedade != '' ? "icon-like bg-success":"icon-dislike bg-danger"); ?> p-4 font-2xl mr-3"></i>
                            <div class="w-100">
                                <div class="text-value-sm">Documentação</div>
                                <div class="text-right">
                                    <a href="<?php e($imovel->doc_propriedade); ?>" target="_blank" class="<?php e($imovel->doc_propriedade != '' ? "":"d-none"); ?> btn btn-sm btn-ghost-primary mr-2" type="button">
                                        <i class="icon-eye"></i>&nbsp;Visualizar
                                    </a>
                                    <a href="<?php e(base_url('administrativo/braco_direito/edit/'.$imovel->id_imovel.'/5'));?>" target="_blank" class="btn btn-sm btn-ghost-primary mr-2">
                                        <i class="icon-pencil"></i>&nbsp;Editar
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
            </div>
            
            <div class="row card-destaque_">
                <!--<div class="col-lg-6">
                    <div class="card">
                        <div class="card-body p-0 d-flex align-items-center">
                            <i class="<?php $check = 0; e($check == 1 ? "icon-like bg-success":"icon-diamond bg-warning"); ?> p-4 font-2xl mr-3"></i>
                            <div>
                                <div class="text-value-sm">Galeria premium? <span class="text-muted small">Marque abaixo:</span></div>
                                <div>
                                    <label class="switch switch-label switch-pill switch-success mb-0">
                                        <input class="switch-input" type="checkbox">
                                        <span class="switch-slider" data-checked="✓" data-unchecked="✕"></span>
                                    </label>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>-->
                <div class="col-lg-6">
                    <div class="card">
                        <div class="card-body p-0 d-flex align-items-center">
                            <i class="<?php  e($imovel->caracteristicas != ''  ? "icon-like bg-success":"icon-dislike bg-danger"); ?> p-4 font-2xl mr-3"></i>
                            <div class="w-100">
                                <div class="text-value-sm">Descrição do imóvel</div>
                                <div class="text-right">
                                    <a data-fancybox="ver-descricao" data-src="#ver-descricao" href="javascript:;" class="btn btn-sm btn-ghost-primary mr-2">
                                        <i class="icon-eye"></i>&nbsp;Visualizar
                                    </a>
                                    <div id="ver-descricao" class="fancy-modal" style="display: none;">
                                        <h2 class="mb-3">
                                            Descrição do imóvel
                                        </h2>
                                        <?php  e($imovel->caracteristicas) ?>
                                    </div>
                                    <a href="<?php e(base_url('administrativo/braco_direito/edit/'.$imovel->id_imovel.'/9'));?>" target="_blank" class="btn btn-sm btn-ghost-primary mr-2">
                                        <i class="icon-pencil"></i>&nbsp;Editar
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="card">
                        <div class="card-body p-0 d-flex align-items-center">
                            <i class="<?php  e(!empty($imovel->imagens) ? "icon-like bg-success":"icon-dislike bg-danger"); ?> p-4 font-2xl mr-3"></i>
                            <div class="w-100">
                                <div class="text-value-sm">Fotos</div>
                                <div class="text-right">
                                    <a href="<?php e(base_url('administrativo/braco_direito/edit/'.$imovel->id_imovel.'/10'));?>" target="_blank" class="btn btn-sm btn-ghost-primary mr-2">
                                        <i class="icon-pencil"></i>&nbsp;Editar
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="row card-destaque_">
                <div class="col-lg-4">
                    <div class="card">
                        <div class="card-body p-0 d-flex align-items-center">
                            <i class="<?php $check = 0; e($check == 1 ? "icon-like bg-success":"icon-volume-1 bg-primary"); ?> p-4 font-2xl mr-3"></i>
                            <div class="w-100">
                                <div class="text-value-sm">Depoimento em áudio</div>
                                <div class="text-right">
                                     
                                    <a data-fancybox data-type="iframe" data-src="<?php e(getenv('MEDIA_URL'));?>/anunciante/85/depoimento/depoimento.mp3" href="javascript:;" class="btn btn-sm btn-ghost-primary mr-2">
                                        <i class="icon-volume-1"></i>&nbsp;Ouvir
                                    </a>
                                    <a href="" class="btn btn-sm btn-ghost-primary mr-2">
                                        <i class="icon-pencil"></i>&nbsp;Editar
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="card card-accent-primary d-none">
                        <div class="card-header">
                            Upload do arquivo de áudio
                        </div>
                        <div class="card-body d-block">
                            <div class="row">
                                <div class="col-lg-12">
                                    <div id="depoimento_file_div" class="container-file custom-file container-doc-file <?php echo $cadastro->depoimento_file != "" ? "d-none" : "d-block"; ?>">
                                        <input type="file" name="depoimento_file" class="custom-file-input" id="depoimento_file" data-value="<?php echo $cadastro->depoimento_file; ?>" value="">
                                        <label class="custom-file-label label-doc-file" for="customFile">
                                            <div class="row d-flex justify-content-center">
                                                <div class="col-md-3 col-lg-3 p-0">
                                                    <div class="container-box-doc text-right <?php echo $cadastro->depoimento_file != "" ? "d-block" : "d-none"; ?>">
                                                        <div class="divDoc">
                                                            <?php 
                                                                if ($cadastro->depoimento_file != ""){
                                                                    
                                                                $pdf = explode(".",$cadastro->depoimento_file);
                                                                
                                                                if (end($pdf) == "pdf"){
                                                            ?>
                                                            <img src="<?php e(base_url('themes/comdono/img/ico-file-pdf.png')); ?>">
                                                            
                                                            <?php } else { ?>
                                                            <img src="<?php e(base_url().'themes/comdono/img/ico-file-img.png'); ?>">
                                                            
                                                            <?php } } ?>
                                                        </div>
                                                    </div>
                                                    <div class="container-doc-load text-right d-none">
                                                        <i class="fa fa-circle-o-notch fa-spin"></i>
                                                    </div>
                                                    <div class="box-icons-doc text-right <?php echo $cadastro->depoimento_file != "" ? "d-none" : "d-block"; ?>">
                                                        <div class="ico arrow">
                    								        <i class="material-icons">
                                                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24">
                                                                   <path fill="none" d="M0 0h24v24H0V0z"></path>
                                                                   <path d="M4 12l1.41 1.41L11 7.83V20h2V7.83l5.58 5.59L20 12l-8-8-8 8z"></path>
                                                                </svg>
                                                            </i>
                    								    </div>
                    								    <div class="ico space">
                    								        <i class="material-icons">
                                                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24">
                                                                   <path fill="none" d="M0 0h24v24H0V0z"></path>
                                                                   <path d="M18 9v4H6V9H4v6h16V9h-2z"></path>
                                                                </svg>
                                                            </i>
                    								    </div>
                                                    </div>
            								    </div>
            								    <div class="col-md-7 col-lg-7 p-0">
            								        <div class="text">
            								            Arquivo de áudio</span>
            								        </div>
            								    </div>
            							    </div>
                                        </label>
                                    </div>
                                    <!-- ------- NÃO REMOVER O ESPAÇO EM BRANCO ENTRE AS TAGS ------- -->
                                    <script id="template-download" type="text/x-tmpl"> </script>
                                    <!-- ------- NÃO REMOVER O ESPAÇO EM BRANCO ENTRE AS TAGS ------- -->
                                
                                    <!--loading-->
                                    <div id="depoimento_file_div_load" class="container-file custom-file container-doc-file d-none">
                                        <label class="custom-file-label label-doc-file" for="customFile">
                                            <div class="row d-flex justify-content-center">
                                                <div class="col-md-3 col-lg-3 p-0">
                                                    <div class="text-right mt-15 mr-20">
                                                        <i class="fa fa-circle-o-notch fa-spin fa-2x"></i>
                                                    </div>
            								    </div>
            								    <div class="col-md-7 col-lg-7 p-0">
            								        <div class="text mt-15">
            								            Carregando...
            								        </div>
            								    </div>
            							    </div>
                                        </label>
                                    </div>
                                    
                                    <!--documento-->
                                    <a href="<?php e($cadastro->depoimento_file); ?>" class="link_divDoc cursor-pointer" target="_blank">
                                    <div id="depoimento_file_div_doc" class="container-file custom-file container-doc-file <?php e($cadastro->depoimento_file != "" ? "" : "d-none"); ?>">
                                        <label class="custom-file-label label-doc-file cursor-pointer" for="customFile">
                                            <div class="row d-flex justify-content-center">
                                                <div class="col-md-3 col-lg-3 p-0">
                                                    <div class="container-box-doc text-right <?php echo $cadastro->depoimento_file != "" ? "d-block" : "d-none"; ?>">
                                                        <div class="divDoc">
                                                            <?php 
                                                                if ($cadastro->depoimento_file != ""){
                                                                    
                                                                $pdf = explode(".",$cadastro->depoimento_file);
                                                                
                                                                if (end($pdf) == "pdf"){
                                                            ?>
                                                            <img src="<?php e(base_url('themes/comdono/img/ico-file-pdf.png')); ?>">
                                                            <?php } else { ?>
                                                            <img src="<?php e(base_url().'themes/comdono/img/ico-file-img.png'); ?>">
                                                            <?php } } ?>
                                                        </div>
                                                    </div>
            								    </div>
            								    <div class="col-md-7 col-lg-7 p-0">
            								        <div class="text mt-15 c-blue">Ver documento</div>
            								    </div>
            							    </div>
                                        </label>
                                    </div>
                                    </a>
                                    
                                    <div class="container-remover">
                                        <div class="row d-flex justify-content-center">
                                            <div class="col-md-3 col-lg-3 p-0">
                                                <div class="box-act-remover-doc <?php echo $cadastro->depoimento_file != "" ? "d-block" : "d-none"; ?>">
                                                    <a href="javascript:;" class="act-text act-remover-doc">Remover</a> 
                                                    <a href="javascript:;" class="act-text act-pergunta-doc act-remover_doc" style="display: none;">Remover?</a>
                                                </div>
                                            </div><div class="col-md-7 col-lg-7 p-0"></div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="card">
                        <div class="card-body p-0 d-flex align-items-center">
                            <i class="<?php $check = 0; e($check == 1 ? "icon-like bg-success":"icon-social-youtube bg-primary"); ?> p-4 font-2xl mr-3"></i>
                            <div class="w-100">
                                <div class="text-value-sm">Depoimento em vídeo</div>
                                <div class="text-right">
                                    
                                    <a data-fancybox="" href="https://www.youtube.com/watch?v=_sI_Ps7JSEk" class="btn btn-sm btn-ghost-primary mr-2">
                                        <i class="icon-eye"></i>&nbsp;Visualizar
                                    </a>
                                    <a href="" class="btn btn-sm btn-ghost-primary mr-2">
                                        <i class="icon-pencil"></i>&nbsp;Editar
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="card card-accent-primary d-none">
                        <div class="card-header">
                            Link depoimento em vídeo
                        </div>
                        <div class="card-body d-block">
                            <div class="row">
                                <div class="col-lg-12">
                                    <div class="form-group">
                                        <input type="text" name="depoimento_video" class="form-control" id="depoimento_text" placeholder="link youtube">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="card">
                        <div class="card-body p-0 d-flex align-items-center">
                            <i class="<?php $check = 0; e($check == 1 ? "icon-like bg-success":"icon-book-open bg-primary"); ?> p-4 font-2xl mr-3"></i>
                            <div class="w-100">
                                <div class="text-value-sm">Depoimento em texto</div>
                                <div class="text-right">
                                    <a data-fancybox="ver-depoimento" data-src="#ver-depoimento" href="javascript:;" class="btn btn-sm btn-ghost-primary mr-2">
                                        <i class="icon-eye"></i>&nbsp;Visualizar
                                    </a>
                                    <div id="ver-depoimento" class="fancy-modal" style="display: none;">
                                        <h2 class="mb-3">
                                            Depoimento
                                        </h2>
                                        <p>
                                            The first focusable element in the modal gets the focus for better accessibility.
                                            The script traps focus within the modal to disable the user to access the content behind it.
                                            Focus is restored to last focused element when modal closes.
                                        </p>
                                        <p>
                                            The first focusable element in the modal gets the focus for better accessibility.
                                            The script traps focus within the modal to disable the user to access the content behind it.
                                            Focus is restored to last focused element when modal closes.
                                        </p>
                                    </div>
                                    <a href="" class="btn btn-sm btn-ghost-primary mr-2">
                                        <i class="icon-pencil"></i>&nbsp;Editar
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="card card-accent-primary d-none">
                        <div class="card-header">
                            Texto de no máximo 144 caracteres
                        </div>
                        <div class="card-body d-block">
                            <div class="row">
                                <div class="col-lg-12">
                                    <div class="form-group">
                                        <textarea name="depoimento_text" class="form-control" id="textarea-input" rows="5" placeholder="Depoimento..."></textarea>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /.row-->
            
            <div class="box-title-section">
                <div class="form-inline">
                    <div class="form-group">
                        <label class="mr-1 text-value text-primary" for="periodo">Relatório Geral</label>
                        <!--<select name="periodo" class="form-control" id="periodo">
                            <option value="dia">Diário</option>
                            <option value="semana">Semanal</option>
                            <option value="mes" selected>Mensal</option>
                        </select>-->
                    </div>
                </div>
                <hr>
            </div>
            <!-- /.box-title-section-->
            
             <!-- Ações no imóvel-->
            <div class="card-group mb-4">
                <div class="card">
                    <div class="card-body">
                        <div class="h1 text-muted text-right mb-4">
                            <i class="icon-eye"></i>
                        </div>
                        <div class="text-value"><?php e($visualizacoes) ?></div>
                        <small class="text-muted text-uppercase font-weight-bold">Visualizações</small>
                        <div class="progress progress-xs my-2">
                            <div class="progress-bar bg-primary" role="progressbar" style="width: 25%" aria-valuenow="25" aria-valuemin="0" aria-valuemax="100"></div>
                        </div>
                        <!--<small class="text-muted">Período anterior <strong>0</strong></small>-->
                    </div>
                </div>
                <div class="card">
                    <div class="card-body">
                        <div class="h1 text-muted text-right mb-4">
                            <i class="icon-heart"></i>
                        </div>
                        <div class="text-value"><?php e(count($favoritos)) ?></div>
                        <small class="text-muted text-uppercase font-weight-bold">Favoritaram</small>
                        <div class="progress progress-xs my-2">
                            <div class="progress-bar bg-primary" role="progressbar" style="width: 25%" aria-valuenow="25" aria-valuemin="0" aria-valuemax="100"></div>
                        </div>
                        <!--<small class="text-muted">Período anterior <strong>0</strong></small>-->
                    </div>
                </div>
                <div class="card">
                    <div class="card-body">
                        <div class="h1 text-muted text-right mb-4">
                            <i class="icon-speech"></i>
                        </div>
                        <div class="text-value"><?php e(count($negociacoes)) ?></div>
                        <small class="text-muted text-uppercase font-weight-bold">Negociações</small>
                        <div class="progress progress-xs my-2">
                            <div class="progress-bar bg-primary" role="progressbar" style="width: 25%" aria-valuenow="25" aria-valuemin="0" aria-valuemax="100"></div>
                        </div>
                        <!--<small class="text-muted">Período anterior <strong>1</strong></small>-->
                        <a href="#" class="btn btn-sm btn-primary float-right collapsed" data-toggle="collapse" data-target="#collapseNegocCompras" aria-expanded="false">Ver chat</a>
                    </div>
                </div>
                <div class="card">
                    <div class="card-body">
                        <div class="h1 text-muted text-right mb-4">
                            <i class="icon-wallet"></i>
                        </div>
                        <div class="text-value"><?php e(count($financiamentos)) ?></div>
                        <small class="text-muted text-uppercase font-weight-bold">Financiamentos</small>
                        <div class="progress progress-xs my-2">
                            <div class="progress-bar bg-primary" role="progressbar" style="width: 25%" aria-valuenow="25" aria-valuemin="0" aria-valuemax="100"></div>
                        </div>
                        <!--<small class="text-muted">Período anterior <strong>2</strong></small>-->
                        <a href="#" class="btn btn-sm btn-primary float-right collapsed" data-toggle="collapse" data-target="#collapseFinanciamento" aria-expanded="false">Ver financiamentos</a>
                    </div>
                </div>
            </div>
            <!-- /.card-group-->
            
            <!-- Canais de divulgação -->
            <div class="card-group mb-4">
                <div class="card">
                    <div class="card-body">
                        <div class="h1 text-muted text-right mb-4">
                            <img src="<?php e(getenv('MEDIA_URL'));?>/modules/comdono/lp/venda-inteligente/images/icones/wimoveis.png">
                        </div>
                        <div class="text-value"><?php e(count($negociacoes)) ?></div>
                        <small class="text-muted text-uppercase font-weight-bold">Visualizações</small>
                        <div class="progress progress-xs my-2">
                            <div class="progress-bar bg-primary" role="progressbar" style="width: 25%" aria-valuenow="25" aria-valuemin="0" aria-valuemax="100"></div>
                        </div>
                        <form name="formAtualizaImovel" class="formAtualizaImovel" action="" method="post">
                            <div class="form-group">
                                <label for="id_wimoveis">Id wimoveis</label>
                                <input type="text" name="id_wimoveis" class="form-control" id="id_wimoveis" value="<?php e($imovel->id_wimoveis); ?>">
                                <div class="link"><a href="" target="_blank">Ver anúncio</a></div>
                            </div>
                            <div class="form-group">
                                <button type="button" class="btn btn-sm btn-primary float-right btnAtualizarImovel">Salvar</button>
                            </div>
                        </form>
                    </div>
                </div>
                <div class="card">
                    <div class="card-body">
                        <div class="h1 text-muted text-right mb-4">
                            <img src="<?php e(getenv('MEDIA_URL'));?>/modules/comdono/lp/venda-inteligente/images/icones/zap.png">
                        </div>
                        <div class="text-value"><?php e(count($negociacoes)) ?></div>
                        <small class="text-muted text-uppercase font-weight-bold">Visualizações</small>
                        <div class="progress progress-xs my-2">
                            <div class="progress-bar bg-primary" role="progressbar" style="width: 25%" aria-valuenow="25" aria-valuemin="0" aria-valuemax="100"></div>
                        </div>
                        <form name="formAtualizaImovel" class="formAtualizaImovel" action="" method="post">
                            <div class="form-group">
                                <label for="id_zap">Id Zap imóveis</label>
                                <input type="text" name="id_zap" class="form-control" id="id_zap" value="<?php e($imovel->id_zap); ?>">
                                <div class="link"><a href="" target="_blank">Ver anúncio</a></div>
                            </div>
                            <div class="form-group">
                                <button type="button" class="btn btn-sm btn-primary float-right btnAtualizarImovel">Salvar</button>
                            </div>
                        </form>
                    </div>
                </div>
                <div class="card">
                    <div class="card-body">
                        <div class="h1 text-muted text-right mb-4">
                            <img src="<?php e(getenv('MEDIA_URL'));?>/modules/comdono/lp/venda-inteligente/images/icones/viva-real.png">
                        </div>
                        <div class="text-value"><?php e(count($negociacoes)) ?></div>
                        <small class="text-muted text-uppercase font-weight-bold">Visualizações</small>
                        <div class="progress progress-xs my-2">
                            <div class="progress-bar bg-primary" role="progressbar" style="width: 25%" aria-valuenow="25" aria-valuemin="0" aria-valuemax="100"></div>
                        </div>
                        <form name="formAtualizaImovel" class="formAtualizaImovel" action="" method="post">
                            <div class="form-group">
                                <label for="id_viva_real">Id Viva Real</label>
                                <input type="text" name="id_viva_real" class="form-control" id="id_viva_real" value="<?php e($imovel->id_viva_real); ?>">
                                <div class="link"><a href="" target="_blank">Ver anúncio</a></div>
                            </div>
                            <div class="form-group">
                                <button type="button" class="btn btn-sm btn-primary float-right btnAtualizarImovel">Salvar</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
            <!-- /.card-group-->
            
            <div class="box-title-section">
                <div class="form-inline">
                    <div class="form-group">
                        <label class="mr-1 text-value text-primary" for="periodo">Mais informações</label>
                    </div>
                </div>
                <hr>
            </div>
            <!-- /.box-title-section-->
            
            <div class="row">
                <div class="col-lg-12">
                    <div class="card">
                        <div class="card-header"><a href="#" data-toggle="collapse" data-target="#collapseNegocCompras" aria-expanded="false" class="collapsed"><i class="icon-speech"></i> Negociacoes de vendas  - <?php e(count($negociacoes??[])); ?></a>
                            <div class="card-header-actions">
                                <a class="card-header-action btn-minimize" href="#" data-toggle="collapse" data-target="#collapseNegocCompras" aria-expanded="false" class="collapsed">
                                    <i class="icon-arrow-up"></i>
                                </a>
                            </div>
                        </div>
                        <div class="collapse" id="collapseNegocCompras">
                            <div class="card-body">
                                <div class="table-container table-responsive">
                                    <table class="display table table-striped table-bordered" style="width:100%">
                                        <thead>
                                            <tr>
                                                <th>Id Chat</th>
                                                <th>Interessado</th>
                                                <th>Status</th>
                                                <th>Etapa</th>
                                                <th>nº msgs</th>
                                                <th>Data</th>
                                                <th>Ver Chat</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php foreach($negociacoes as $chat) { ?>
                                                <tr class="trData">
                                            <td><?php e($chat->id_chat); ?></td>
                                            <td><a href="<?php e(base_url().'administrativo/usuarios/perfil/'.$chat->id_interessado); ?>" target="_blank"><i class="icon-user-follow icons font-2xl"></i> </a></td>
                                            <td>
                                                <?php if($chat->chat_status == 2){e("Status ".$chat->chat_status." - Aguardando o dono aceitar o interessado");} ?>
                                                <?php if($chat->chat_status == 3){e("Status ".$chat->chat_status." - aceitou o interessado");} ?>
                                                <?php if($chat->chat_status == 4){e("Status ".$chat->chat_status." - negou o interessado");} ?>
                                            </td>
                                            <td><?php e($chat->etapa); ?></td>
                                            <td><?php e(count($chat->msgs) -1); ?></td>
                                            <td><span class="d-none"><?php e(end($chat->msgs)->dt_msg); ?></span><?php e(date('d/m/Y',strtotime(end($chat->msgs)->dt_msg))); ?></td>
                                            <td><a href="<?php e(base_url().'administrativo/braco_direito/chat/'.$imovel->id_imovel.'/'.$chat->id_chat); ?>" target="_blank"><i class="icon-speech font-2xl"></i></a></td>
                                        </tr>
                                            <?php } ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>  
                </div>
            </div>
            <!-- /.row-->
            
            <div class="row">
                <div class="col-lg-12">
                    <div class="card">
                        <div class="card-header"><a href="#" data-toggle="collapse" data-target="#collapseFinanciamento" aria-expanded="false" class="collapsed"><i class="icon-wallet"></i> Financiamento - <?php e(count($financiamentos??[])); ?></a>
                            <div class="card-header-actions">
                                <a class="card-header-action btn-minimize" href="#" data-toggle="collapse" data-target="#collapseFinanciamento" aria-expanded="false" class="collapsed">
                                    <i class="icon-arrow-up"></i>
                                </a>
                            </div>
                        </div>
                        <div class="collapse" id="collapseFinanciamento">
                            <div class="card-body">
                                <div class="table-container table-responsive">
                                    <table class="display table table-striped table-bordered" style="width:100%">
                                        <thead>
                                            <tr>
                                                <th>Id</th>
                                                
                                                <th>Interessado</th>
                                                <th>Valor entrada</th>
                                                <th>Parcelas</th>
                                                <th>Meses</th>
                                                <th>Data</th>
                                                <th>Ação</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php foreach($financiamentos as $financiamento) { ?>
                                            <tr class="trData">
                                                <td><?php e($financiamento->id_simulacao); ?></td>
                                                <td><a href="<?php e(base_url().'administrativo/usuarios/perfil/'.$financiamento->id_cad_interessado); ?>" target="_blank"><i class="icon-user-follow icons font-2xl"></i> </a></td>
                                                <td><?php e($financiamento->val_entrada); ?></td>
                                                <td><?php e($financiamento->val_parcelas); ?></td>
                                                <td><?php e($financiamento->meses_financiado); ?></td>
                                                <td><span class="d-none"><?php e($financiamento->data_simulacao); ?></span><?php e(date('d/m/Y',strtotime($financiamento->data_simulacao))); ?></td>
                                                <td><a href="<?php e(base_url('administrativo/financiamentos/bancos/').$financiamento->id_simulacao); ?>" target="_blank"><i class="icon-credit-card font-2xl"></i></a>
                                            </tr>
                                            <?php } ?>
                                           
                                            
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
        </div>
    </div>
</div>

<div class="modal fade" id="dangerModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true" style="display: none;">
    <div class="modal-dialog modal-danger" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">Atendimento</h4>
                <button class="close" type="button" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">×</span>
                </button>
            </div>
            <div class="modal-body">
                <p><strong>Deseja Bloquear/Ocultar imovel?</strong> Informe o motivo abaixo.</p>
                <form id="formBloquearImovel" action="" method="post">
                    <div class="form-group">
                       <label for="motivo">Motivo</label>
                       <textarea name="motivo" id="motivo" class="form-control" required="required"></textarea>
                    </div>
                </form>
                <div class="erroFormNegarAnuncio"></div>
            </div>
            <div class="modal-footer">
                <button class="btn btn-danger btnBloquearImovel" type="button">Bloquear</button>
                <button class="btn btn-secondary" type="button" data-dismiss="modal">Fechar</button>
            </div>
        </div>
    </div>
</div>