<div class="d-flex justify-content-center">
    <div class="col-md-10">
        <div class="card">
            <div class="card-header">Enviar convite - evento: <?php e($evento->uuid_evento) ?></div>
            <div class="card-body">
                <div class="card text-white bg-info">
                    <div class="card-header">Quem pode e quem não pode receber o E-mail e o Whatsapp</div>
                    <div class="card-body">
                        <p><u>Podem receber:</u> Pessoas que se cadastraram na página do Empreendimento mas não agendaram visita. Pessoas que desistiram no momento da visita.</p>
                        <p><u>Não podem receber:</u> Pessoas que estão em momento de compra dentro do painel da incorporadora. Pessoas que solicitaram descadastro.</p>
                    </div>
                </div>
                <ul class="nav nav-tabs" id="myTab1" role="tablist">
                    <li class="nav-item">
                        <a class="nav-link active" id="home-tab" data-toggle="tab" href="#home" role="tab" aria-controls="home" aria-selected="true">
                            <strong><i class="fa fa-envelope-o text-primary"></i> Por E-mail</strong>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" id="profile-tab" data-toggle="tab" href="#profile" role="tab" aria-controls="profile" aria-selected="false">
                            <strong><i class="fa fa-whatsapp text-success"></i> Pelo Whatsapp</strong>
                        </a>
                    </li>
                </ul>
                <div class="tab-content" id="myTab1Content">
                    <div class="tab-pane fade show active" id="home" role="tabpanel" aria-labelledby="home-tab">
                        <div class="card card-accent-primary">
                            <div class="card-header">Formulário de envio</div>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-lg-5">
                                        <form id="form_enviar_email">
                                            <div class="form-group">
                                                <label>Link corretor(a)</label>
                                                <input type="text" name="link_corretor" class="form-control" required="required">
                                            </div>
                                            <div class="form-group">
                                                <label>UIID da Newsletter</label>
                                                <input type="text" name="uuid_campanha" class="form-control" required="required">
                                            </div>
                                            <div>
                                                <div class="msgEnviar"></div>
                                                <div class="form-group text-right">
                                                    <button type="submit" id="btn_enviar_email" class="btn btn-primary btn_enviar_email" data-ids='<?php e(!empty($ids_captura) ? json_encode($ids_captura) : "" ); ?>'>
                                                        Enviar
                                                    </button>
                                                </div>
                                            </div>
                                            <input type="hidden" name="uuid_evento" value="<?php e($evento->uuid_evento) ?>">
                                        </form>
                                        <div class="result_email"></div>
                                    </div>
                                    <div class="offset-lg-1 col-lg-6">
                                        <a class="btn btn-secondary mb-2" data-toggle="collapse" href="#instrucao_email" role="button" aria-expanded="true" aria-controls="instrucao_email">
                                            <i class="fa fa-info-circle" aria-hidden="true"></i> Instruções
                                        </a>
                                        <div class="collapse show" id="instrucao_email">
                                            <div class="card card-body">
                                                <p>- O campo Link corretor(a) deverá possuir o link do convite.</p>
                                                <p>- O campo UIID da Newsletter deverá possuir o uuid da campanha da newsletter. Confira a configuração do e-mail <a href="<?php e(base_url("newsletter/painel/campanhas"))?>" target="_blank">aqui</a>. Entre e pesquise por UIID.</p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="card card-accent-primary">
                            <div class="card-header">Resultado do envio</div>
                            <div class="card-body">
                                <div class="table-container table-responsive">
                                    <table class="display table table-striped table-bordered" style="width:100%">
                                        <thead>
                                            <tr>
                                                <th>Email</th>
                                                <th>Id campanha</th>
                                                <th>Enviado</th>
                                                <th>Abriu</th>
                                                <th>Clicou</th>
                                                <th>Enviado em</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php foreach($log_emails as $le){ ?>
                                            <tr class="trData" >
                                                <td><?php e($le->email); ?></td>
                                                <td><?php e($le->id_campanha); ?></td>
                                                <td><?php e($le->enviado); ?></td>
                                                <td><?php e($le->abriu); ?></td>
                                                <td><?php e($le->clicou); ?></td>
                                                <td><?php e(substr(converte_datahora($le->enviado_em,1),0,-3)); ?></td>
                                            </tr>
                                            <?php } ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="tab-pane fade" id="profile" role="tabpanel" aria-labelledby="profile-tab">
                        <div class="card card-accent-primary">
                            <div class="card-header">Formulário de envio</div>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-lg-5">
                                        <form id="form_enviar_whats">
                                            
                                            <div class="form-group">
                                                <label>Link corretor(a)</label>
                                                <input type="text" name="link_corretor" class="form-control" required="required">
                                            </div>
                                            <div class="form-group">
                                                <label>Mensagem para Whatsapp</label>
                                                <textarea name="mensagem"class="form-control" rows="10" placeholder="Mensagem" required="required">Olá {nome}!
Tenho um convite especial para você.
No dia xx de xx, xxxxxx, o Grupo xxxx estará realizando a rodada de negócios do xxx.
É uma oportunidade única para conhecer o empreendimento mais seguro do xxx e fechar um excelente negócio.
Você é o nosso convidado especial. Te esperamos lá.</textarea>
                                            </div>
                                            <div>
                                                <div class="msgEnviar"></div>
                                                <div class="form-group text-right">
                                                    <button type="submit" id="btn_enviar_whats" class="btn btn-primary btn_enviar_whats" data-ids='<?php e(!empty($ids_captura) ? json_encode($ids_captura) : "" ); ?>'>
                                                        Enviar
                                                    </button>
                                                </div>
                                            </div>
                                            <input type="hidden" name="id_evento" value="<?php e($evento->id_evento) ?>">
                                        </form>
                                        <div class="result_whats"></div>
                                    </div>
                                    <div class="offset-lg-1 col-lg-6">
                                        <a class="btn btn-secondary mb-2" data-toggle="collapse" href="#instrucao_whatsapp" role="button" aria-expanded="true" aria-controls="instrucao_whatsapp">
                                            <i class="fa fa-info-circle" aria-hidden="true"></i> Instruções
                                        </a>
                                        <div class="collapse show" id="instrucao_whatsapp">
                                            <div class="card card-body">
                                                <p>- O campo Link corretor(a) deverá possuir o link do convite.</p>
                                                <p>
                                                    - O campo Mensagem para Whatsapp, além de possuir a mensagem que deseja enviar, deverá possuir uma tag {nome} para indicar onde vai o nome do lead na mensagem.
                                                    Você pode substituir as 'xx' pela data, nome da incorporadora e ou informações pertinentes à mensagem.
                                                </p>
                                                <p><strong>Por exemplo:</strong><br>
                                                   Olá {nome}<br>
                                                   Tenho um convite especial para você...
                                                </p>
                                                <p><strong>No Whatsapp ficará assim:</strong></p>
                                                
                                                <div class="card text-white bg-success">
                                                    <div class="card-body">
                                                        <blockquote class="card-bodyquote">
                                                            <p><strong>Convite do Comdono pra você:</strong><br><br>
                                                            Olá 'primero nome do lead'!<br>
                                                            Tenho um convite especial para você...<br>
                                                            Clique no link abaixo para saber todas as informações e confirmar a sua presença.<br>   
                                                            'link do corretor(a)'</p>
                                                        </blockquote>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="card card-accent-primary">
                            <div class="card-header">Resultado do envio</div>
                            <div class="card-body">
                                <div class="table-container table-responsive">
                                    <table class="display table table-striped table-bordered" style="width:100%">
                                        <thead>
                                            <tr>
                                                <th>ID</th>
                                                <th>Telefone</th>
                                                <th>Data do Envio</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                        <?php if(!empty($log_whats)){ ?>
                                            <?php foreach($log_whats as $lw) { ?>    
                                            <tr class="trData" >
                                                <td><?php e($lw->id); ?></td>
                                                <td><?php e($lw->telefone); ?></td>
                                                <td><?php e(substr(converte_datahora($lw->enviado_em,1),0,-3)); ?></td>
                                            </tr>
                                            <?php } ?>
                                        <?php } ?>   
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>