<?php if (in_array($state,['list','success','add','edit'])){ ?>
    <div class="row">
        <div class="col">
            <a href="<?php e(base_url('administrativo/financiamentos/solicitacoes'));?>" class="btn btn-primary float-right">Voltar</a>
        </div>
    </div>
    <div class="row mt-5">
        <div class="col-lg-12">
            <div class="card">
                <h5 class="card-header">Detalhes</h5>
                <div class="card-body">
                    <div class="row">
                        <?php if(isset($imovel->id_imovel)){ ?>
                        <div class="col-md-12 col-lg-6">
                            <div class="card card-accent-info">
                                <div class="card-header"><h5 class="card-title m-0">Dados do imóvel</h5></div>
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-md-6 col-lg-6">
                                            <a href="<?php e(base_url("imovel/").$imovel->id_imovel); ?>" target="_blank" title="Ver imóvel">
                                                <div class="img-bg" style="background-image: url('<?php if (!empty($imovel->imagens)){HImg::ref($imovel->imagens[1]); }else{e(base_url("themes/comdono/img/no-image-gallery.png"));} ?>');"></div>
                                            </a>
                                        </div>
                                        <div class="col-md-6 col-lg-6">
                                            <ul class="list-group">
                                                <li class="list-group-item"><strong>Valor:</strong> <span><?php HValorFormat::exibe($imovel->val_pretendido); ?></span></li>
                                                <li class="list-group-item"><strong>Bairro:</strong> <?php e($imovel->bairro); ?></li>
                                                <li class="list-group-item"><strong>Endereço:</strong> <?php e($imovel->endereco); ?></li>
                                                <li class="list-group-item"><strong>Tipo do imóvel:</strong> <?php e($imovel->tipo_imovel); ?></li>
                                                <li class="list-group-item"><strong>Área privativa:</strong> <span><?php e($imovel->area_privativa." m²"); ?></span></li>
                                                <li class="list-group-item"><strong>Quarto(s):</strong> <span><?php e($imovel->quartos); ?></span></li>
                                                <li class="list-group-item"><strong>Vaga(s):</strong> <span><?php e($imovel->vaga); ?></span></li>
                                                <li class="list-group-item"><strong>Banheiro(s):</strong> <span><?php e($imovel->banheiros); ?></span></li>
                                                <li class="list-group-item"><a href="<?php e(base_url("imovel/").$imovel->id_imovel); ?>" target="_blank">Ver imóvel</a></li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php } ?>
                        <div class="col-md-6 col-lg-3">
                            <div class="card card-accent-info">
                                <div class="card-header"><h5 class="card-title m-0">Dados do interessado</h5></div>
                                <div class="card-body">
                                    <ul class="list-group">
                                        <li class="list-group-item"><strong>Nome:</strong> <?php e($interessado->nome); ?></li>
                                        <li class="list-group-item"><strong>E-mail:</strong> <?php e($interessado->email); ?></li>
                                        <li class="list-group-item"><strong>Telefone:</strong> <span><?php e($interessado->telefone); ?></span></li>
                                        <?php if($simulacao->tipo_pessoa == "cpf"){ ?>
                                        <li class="list-group-item"><strong>CPF:</strong> <span><?php e($simulacao->cpf); ?></span></li>
                                        <?php }else{ ?>
                                        <li class="list-group-item"><strong>CNPJ:</strong> <span><?php e($simulacao->cnpj); ?></span></li>
                                        <?php } ?>
                                        <li class="list-group-item"><strong>Data de nascimento:</strong> <span><?php e($simulacao->data_nascimento) ?></span></li>
                                        <li class="list-group-item"><strong>Renda familiar:</strong> <span> <?php HValorFormat::exibe($simulacao->renda_familiar); ?></span></li>
                                        <li class="list-group-item"><strong>É servidor público:</strong> <span><?php e($simulacao->servidor_publico == "on" ? "Sim":"Não"); ?></span></li>
                                        <li class="list-group-item"><strong>Possui FGTS:</strong> <span><?php e($simulacao->possui_fgts == "on" ? "Sim":"Não"); ?></span></li>
                                        <?php if($simulacao->possui_fgts == "on"){ ?>
                                        <li class="list-group-item"><strong>Valor FGTS:</strong> <span><?php e('R$ '.number_format($simulacao->valor_fgts, 2, ',', '.')); ?></span></li>
                                        <?php } ?>
                                    </ul>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6 col-lg-3">
                            <div class="card card-accent-info">
                                <div class="card-header"><h5 class="card-title m-0">Dados da simulação</h5></div>
                                <div class="card-body">
                                    <ul class="list-group">
                                        <li class="list-group-item"><strong>Data da simulação:</strong> <span><?php e(date("d/m/Y", strtotime($simulacao->data_simulacao))); ?></span></li>
                                        <li class="list-group-item"><strong>Total de meses (parcelas):</strong> <span><?php e($simulacao->meses_financiado); ?></span></li>
                                        <li class="list-group-item"><strong>Valor da Entrada:</strong> <span><?php HValorFormat::exibe($simulacao->val_entrada); ?></span></li>
                                        <li class="list-group-item"><strong>Juros(a.a):</strong> <span><?php e($simulacao->taxa); ?>%</span></li>
                                        <li class="list-group-item"><strong>Valor das parcelas:</strong> <span><?php HValorFormat::exibe($simulacao->val_parcelas); ?></span></li>
                                        <li class="list-group-item"><strong>Valor a ser pago:</strong> <span><?php HValorFormat::exibe($simulacao->val_total); ?></span></li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row ">
                        <div class="col text-right">
                            <?php if($simulacao->email_propostas == 0){?>
                            <button class="btn btn-success mb-1" data-id="<?php //e($imv->id); ?>" type="button" data-toggle="modal" data-target="#successModal">Enviar email</button>
                            <?php }else{?>
                            <button class="btn btn-warning mb-1" data-id="<?php //e($imv->id); ?>" type="button" data-toggle="modal" data-target="#successModal">Enviar novamente</button>
                            <?php }?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
    </div>
<div class="modal fade" id="successModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true" style="display: none;">
    <div class="modal-dialog _modal-success" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">Email de Proposta</h4>
                <button class="close" type="button" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">×</span>
                </button>
            </div>
            <div class="modal-body">
                <p>Enviar email para o cliente com as propostas?</p>
            </div>
            <div class="modal-footer">
                <a href="javascript:;" class="btn btn-success enviarProposta" data-id="<?php e($id_simulacao); ?>">Enviar</a>
                <button class="btn btn-secondary" type="button" data-dismiss="modal">Fechar</button>
            </div>
        </div>
    </div>
</div>

<?php }else{ ?>
    
<?php } ?>