<?php if($quadro->id_quadro != 1) { ?>
<h4>Quadro não encontrado</h4>
<?php } else {?>

<div class="box-title-section">
    <div class="form-inline">
        <div class="form-group">
            <a href="<?php e(base_url("administrativo/operacao/venda")); ?>" class="btn btn-primary"><i class="icon-action-undo"></i> Voltar a listagem</a>
        </div>
        <div class="form-group ml-2">
            <a href="script:;"class="btn btn-success abrirModalAddCard"  data-toggle="modal" data-target="#modalAddCard" ><i class="icon-plus"></i> Adicionar Cartão</a>
        </div>
    </div>
    <hr>
</div>

<div class="board-main">
    <!--<div class="dragscroll container-board style-scroll-h"> obs: dragscroll arrasta pagina-->
    <div class="container-board style-scroll-h">
        <!--begin lists-->
        <?php foreach($listas as $lista) { ?>
        <div id="accordion-<?php e($lista->id_lista); ?>" class="list-container">
            <h4><?php e($lista->lista); ?></h4>
            <div class="list-wrapper ui-sortable style-scroll-v">
                <div class="list-content">
                    <div class="row dragdrop">
                        <div class="col-md-12 ui-sortable">
                            <!--begin cards-->
                            
                            <?php $i=1; foreach($lista->cards as $card) { ?>
                            
                            <div id="card_<?php e($card->id_card ); ?>" class="card <?php e($lista->id_lista == 1 ? "card-accent-danger":"card-accent-primary"); ?>">
                                <div class="card-header ui-sortable-handle ">
                                    <div id="imovel_<?php e($card->imovel->id_imovel??0); ?>" class="row">
                                        <div class="col-md-10 pr-0">
                                            <div><a class="card-header-action btn-minimize" href="#" data-toggle="collapse" data-target="#collapseCard-<?php e($card->id_card); ?>" aria-expanded="true"><?php e($card->titulo); ?></a></div>
                                            <div>
                                                <a class="badge <?php e($lista->id_lista == 1 ? "badge-danger" : "badge-primary"); ?>" href="#" data-toggle="collapse" data-target="#collapseCard-<?php e($card->id_card); ?>" aria-expanded="true">
                                                    <?php if($lista->id_lista == 1){ ?>aguardando atendimento <?php } ?>
                                                    <?php if($lista->id_lista == 2){ 
                            e(($card->id_cadastro > 0) ? 'Aguardando prosseguimento' : 'Aguardando cadastro do dono'); } ?>
                                                    <?php if($lista->id_lista == 3){  e(($card->id_imovel > 0) ? 'Aguardando prosseguimento' : 'Aguardando cadastro do imóvel'); } ?>
                                                    <?php if($lista->id_lista == 4){  e(($card->autorizacao_dono == 'Sim') ? 'Aguardando prosseguimento' : 'Aguardando Agendamento'); } ?>
                                                    <?php if($lista->id_lista == 5){ ?>aguardando visita <?php } ?>
                                                </a>
                                            </div>
                                            <?php if($this->session->perfil == 1){ ?>
                                            <div>
                                                <?php if($card->id_responsavel > 0){ ?>
                                                <a class="badge badge-info text-white" href="#" data-toggle="collapse" data-target="#collapseCard-<?php e($card->id_card); ?>" aria-expanded="true">
                                                    <?php  e($card->atendente->nome); ?>
                                                </a>
                                                <?php } ?>
                                                <?php if($card->id_fotografo > 0){ ?>
                                                <a class="badge badge-secondary text-white" href="#" data-toggle="collapse" data-target="#collapseCard-<?php e($card->id_card); ?>" aria-expanded="true">
                                                    <?php e($card->fotografo->nome??''); ?>
                                                </a>
                                                <?php } ?>
                                            </div>
                                            <?php } ?>
                                        </div>
                                        <div class="col-md-2 pl-0">
                                            <div class="card-header-actions">
                                                <?php if ($card->imovel->id_imovel??false): ?>
                                                    <a class="" href="<?php e(base_url('administrativo/dashboard/imovel/'.$card->imovel->id_imovel));?>" target="_blank" ><i class="icon-settings"></i></a>
                                                <?php endif; ?>
                                                
                                                <a class="card-header-action btn-minimize" href="#" data-toggle="collapse" data-target="#collapseCard-<?php e($card->id_card); ?>" aria-expanded="true"><i class="icon-arrow-up"></i></a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="collapse <?php e(($lista->id_lista == 1 && $i == 1) ? "show":""); ?>" id="collapseCard-<?php e($card->id_card); ?>" data-parent="#accordion-<?php e($lista->id_lista); ?>">
                                    <div class="card-body">
                                        <form id="formPreatendimento" action="" method="post">
                                            <div class="form-group-obs-<?php e($card->id_card); ?>">
                                                <label class="label-obs" for="nome">Observação <?php if($lista->id_lista > 1 || !empty($card->obs)){ ?><button class="btn btn-sm btn-secundary btn-edit" data-id_card="<?php e($card->id_card)?>" data-card_obs="<?php e($card->obs); ?>" type="button"><i class="icon-pencil"></i> Editar</button> <?php } ?></label>
                                                
                                                <?php if($lista->id_lista == 1 && empty($card->obs)){ ?>
                                                <div class="box-textarea box-text-obs">
                                                   <textarea class="form-control textarea-obs" id="textarea-input" rows="3" name="obs_card_<?php e($card->id_card); ?>" placeholder="Escreva aqui..."></textarea>
                                                </div>
                                                <?php } else { ?>
                                                <div class="box-text-obs">
                                                   <p><?php e($card->obs); ?></p>
                                                </div>
                                                 <?php } ?>
                                            </div>
                                            
                                            <div class="text-obs-<?php e($card->id_card)?>"></div>
                                            <div class="btns-obs">
                                            <?php if($lista->id_lista == 1 && empty($card->obs)){ ?>
                                            <div class="form-group mt-2 btns-salvar-obs">
                                                <button class="btn btn-sm btn-primary btn-save-obs" data-id_card="<?php e($card->id_card)?>" type="button"><i class="fa fa-dot-circle-o"></i> Salvar</button>
                                                <button class="btn btn-sm btn-danger" type="button"><i class="icon-close"></i> Fechar</button>
                                            </div>
                                            <?php } ?>
                                            </div>
                                        </form>
                                        
                                        <!--checklist/tarefa -->
                                        <!--checklist/tarefa -->
                                        <?php $idList = 2; if($lista->id_lista >= $idList){ if($lista->id_lista == $idList){ ?>
                                                <div class="card text-white bg-info scroll-card">
                                            <div class="card-header">
                                                <a class="card-header-action btn-minimize" href="#" data-toggle="collapse" data-target="#collapseCaptura-<?php e($card->id_card); ?>" aria-expanded="false"> Cadastro do Dono</a>
                                                <div class="card-header-actions">
                                                    <a class="card-header-action btn-minimize" href="#" data-toggle="collapse" data-target="#collapseCaptura-<?php e($card->id_card); ?>" aria-expanded="false"><i class="icon-arrow-up"></i></a>
                                                </div>
                                            </div>
                                            <div class="collapse show" id="collapseCaptura-<?php e($card->id_card); ?>">
                                                <div class="card-body form-cadono-<?php e($card->id_card); ?>">
                                                    <div class="alert-cad-<?php e($card->id_card); ?>"></div>
                                                    <form id="form-cad-dono-id-<?php e($card->id_card); ?>" action="" method="post">
                                                        <div class="form-group">
                                                           <label for="email">E-mail</label>
                                                           <input type="email" name="email_cad" id="email_cad" class="form-control" value="<?php e($card->cadastro->email??'')?>">
                                                        </div>
                                                        <button class="btn btn-sm btn-secundary btn-verifica-dono <?php e(isset($card->cadastro)?'d-none':'')?>" data-id_card="<?php e($card->id_card)?>" type="button"><i class="fa fa-dot-circle-o"></i> Verificar</button>
                                                        <span class="forms-cad-false-<?php e($card->id_card)?> <?php e(isset($card->cadastro)?'':'d-none')?>" >
                                                            <div class="form-group">
                                                               <label for="nome">Nome</label>
                                                               <input type="text" name="nome_cad" class="form-control" value="<?php e($card->cadastro->nome??'')?>">
                                                            </div>
                                                            <div class="form-group">
                                                                <label for="telefone">Telefone</label>
                                                                <input type="phone" name="telefone" class="form-control" value="<?php e($card->cadastro->telefone??'')?>">
                                                            </div>
                                                            <!--<div class="form-group">
                                                                <label for="cpf">CPF</label>
                                                                <input type="text" name="cpf" class="form-control">
                                                            </div>-->
                                                            <div class="form-group btns-<?php e($card->id_card);?> <?php e($card->id_cadastro != 0 ?'d-none':'')?>">
                                                                <button class="btn btn-sm btn-primary btn-save-dono" data-id_card="<?php e($card->id_card)?>" type="button"><i class="fa fa-dot-circle-o"></i> Salvar</button>
                                                                <button class="btn btn-sm btn-danger" type="reset"><i class="fa fa-ban"></i> Limpar</button>
                                                            </div>
                                                        </span>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                        <?php }else{ ?>
                                                <div class="card text-black bg-light scroll-card">
                                            
                                            <div class="card-header">
                                                <a class="card-header-action btn-minimize collapsed" href="#" data-toggle="collapse" data-target="#collapseCaptura-<?php e($card->id_card); ?>" aria-expanded="false">Cadastro do Dono</a>
                                                <div class="card-header-actions">
                                                    <a class="card-header-action btn-minimize collapsed" href="#" data-toggle="collapse" data-target="#collapseCaptura-<?php e($card->id_card); ?>" aria-expanded="false"><i class="icon-arrow-up"></i></a>
                                                </div>
                                            </div>
                                            <div class="collapse" id="collapseCaptura-<?php e($card->id_card); ?>">
                                                <div class="card-body form-cadono-<?php e($card->id_card); ?>">
                                                    <div class="alert-cad-<?php e($card->id_card); ?>"></div>
                                                    <form id="form-cad-dono" action="" method="post">
                                                        <div class="form-group">
                                                           <label for="email">E-mail</label>
                                                           <input type="email" id="email_cad" class="form-control" value="<?php e($card->cadastro->email??'')?>" readonly>
                                                        </div>
                                                        <!--<button class="btn btn-sm btn-secundary btn-verifica-dono <?php e(isset($card->cadastro)?'d-none':'')?>" data-id_card="<?php e($card->id_card)?>" type="button"><i class="fa fa-dot-circle-o"></i> Verificar</button>
                                                        <span class="forms-cad-false-<?php e($card->id_card)?> <?php e(isset($card->cadastro)?'':'d-none')?>" >-->
                                                            <div class="form-group">
                                                               <label for="nome">Nome</label>
                                                               <input type="text"  class="form-control" value="<?php e($card->cadastro->nome??'')?>" readonly>
                                                            </div>
                                                            <div class="form-group">
                                                                <label for="telefone">Telefone</label>
                                                                <input type="phone" class="form-control" value="<?php e($card->cadastro->telefone??'')?>" readonly>
                                                            </div>
                                                            <!--<div class="form-group">
                                                                <label for="cpf">CPF</label>
                                                                <input type="text" name="cpf" class="form-control">
                                                            </div>
                                                            <div class="form-group btns-<?php e($card->id_card);?>">
                                                                <button class="btn btn-sm btn-primary btn-save-dono" data-id_card="<?php e($card->id_card)?>" type="button"><i class="fa fa-dot-circle-o"></i> Salvar</button>
                                                                <button class="btn btn-sm btn-danger" type="reset"><i class="fa fa-ban"></i> Limpar</button>
                                                            </div>
                                                        </span>-->
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                        <?php } } ?>
                                        <!-- end checklist/tarefa -->
                                        
                                        <?php $idList = 3; if($lista->id_lista >= $idList){ if($lista->id_lista == $idList){ ?>
                                            <div class="card text-white bg-info scroll-card">    
                                            <div class="card-header">
                                                <a class="card-header-action btn-minimize" href="#" data-toggle="collapse" data-target="#collapseImovel-<?php e($card->id_card); ?>" aria-expanded="false">Cadastro do Imóvel</a> <?php e(isset($card->imovel)?
                                                
                                                '<a href="'.base_url('administrativo/braco_direito/edit_imovel/'.$card->imovel->id_imovel).'"class="btn btn-sm btn-primary"><i class="icon-pencil"></i> Editar </a> 
                                                
                                                <a href="'.base_url('administrativo/dashboard/imovel/'.$card->imovel->id_imovel).'" class="btn btn-sm btn-success"  target="_blank"><i class="fa fa-cog"></i> Detalhes</a>
                                                
                                                <a href="'.base_url('imovel/'.$card->imovel->id_imovel).'" class="btn btn-sm btn-success"  target="_blank"><i class="icon-eye"></i> Ver</a>
                                                
                                                ':'')?> 
                                                
                                                <div class="card-header-actions">
                                                    <a class="card-header-action btn-minimize" href="#" data-toggle="collapse" data-target="#collapseImovel-<?php e($card->id_card); ?>" aria-expanded="false"><i class="icon-arrow-up"></i></a>
                                                </div>
                                            </div>
                                            <div class="collapse show" id="collapseImovel-<?php e($card->id_card); ?>">
                                                <div class="card-body">
                                                    <div class="alert-cep-<?php e($card->id_card); ?>"></div>
                                                    <form id="formImovel-<?php e($card->id_card); ?>" action="" method="post">
                                                        <div class="form-group">
                                                           <label for="endereco">CEP</label>
                                                           <input type="text" name="cep" class="form-control" value="<?php e($card->imovel->cep??'')?>">
                                                        </div>
                                                        <button class="btn btn-sm btn-secundary btn-verifica-cep <?php e(isset($card->imovel)?'d-none':'')?>" data-id_card="<?php e($card->id_card)?>" type="button"><i class="fa fa-dot-circle-o"></i> Verificar</button>
                                                        <span class="forms-imovel-<?php e($card->id_card)?> <?php e(isset($card->imovel)?'':'d-none')?>" >
                                                            <div class="form-group">
                                                               <label for="endereco">Endereço</label>
                                                               <input type="text" name="endereco" class="form-control" value="<?php e($card->imovel->endereco??'')?>" >
                                                            </div>
                                                            <div class="form-group">
                                                               <label for="numero">Numero</label>
                                                               <input type="text" name="numero" class="form-control" value="<?php e($card->imovel->numero??'')?>">
                                                            </div>
                                                            <div class="form-group">
                                                               <label for="complemento">Complemento</label>
                                                               <input type="text" name="complemento" class="form-control" value="<?php e($card->imovel->complemento??'')?>">
                                                            </div>
                                                            <div class="form-group">
                                                               <label for="bairro">Bairro</label>
                                                               <input type="text" name="bairro" class="form-control" value="<?php e($card->imovel->bairro??'')?>">
                                                            </div>
                                                            <div class="form-group">
                                                                <label for="cidade">Cidade</label>
                                                                <input type="text" name="cidade" class="form-control" value="<?php e($card->imovel->cidade??'')?>">
                                                            </div>
                                                            <div class="form-group">
                                                                <label for="cidade">Estado</label>
                                                                <input type="text" name="estado" class="form-control" value="<?php e($card->imovel->estado??'')?>">
                                                            </div>
                                                            <div class="form-group">
                                                               <label for="valor">Valor Pretendido</label>
                                                               <input type="text" name="valor" class="form-control" value="<?php e($card->imovel->val_pretendido??'')?>">
                                                            </div>
                                                            <div class="form-group">
                                                               <label for="valor">Tipo</label>
                                                               <select name="tipo_imovel" class="form-control">
                                                                <option value="">Selecione</option>
                                                                <?php
                                                                    foreach ($tiposImovel as $grupo=>$options)
                                                                    {
                                                                        echo("<optgroup label='$grupo'>");
                                                                        foreach ($options as $value=>$text)
                                                                        {
                                                                            $selected = '';
                                                                            if($value == ($card->imovel->tipo_imovel??''))
                                                                                $selected = 'selected';
                                                                            echo("<option value='$value' $selected >$text</option>");
                                                                        }
                                                                        echo("</optgroup>");
                                                                    }
                                                                ?>
                                                                </select>
                                                            </div>
                                                            <div class="form-row">
                                                                <div class="col">
                                                                    <label for="quartos">Quartos</label>
                                                                    <input type="text" name="quartos" class="form-control" value="<?php e($card->imovel->quartos??'')?>">
                                                                </div>
                                                                <div class="col">
                                                                    <label for="metragem">M²</label>
                                                                    <input type="text" name="metragem" class="form-control" value="<?php e($card->imovel->area_toal??'')?>">
                                                                </div>
                                                                <div class="col">
                                                                    <label for="banheiros">Banheiros</label>
                                                                    <input type="text" name="banheiros" class="form-control" value="<?php e($card->imovel->banheiros??'')?>">
                                                                </div>
                                                              </div>
                                                            <!-- Residente / Alugado => Inputs com dados do inquilino / Desocupado -->
                                                            <div class="form-group">
                                                                <label>Status:</label>
                                                                <div class="form-check form-check-inline">
                                                                  <input class="form-check-input" type="radio" name="status_imovel"  data-id_card="<?php e($card->id_card)?>" id="inlineRadio1" value="Residente" <?php e($card->status_imovel == "Residente" ? "checked" : ""); ?>>
                                                                  <label class="form-check-label" for="status_imovel">Residente</label>
                                                                </div>
                                                                <div class="form-check form-check-inline">
                                                                  <input class="form-check-input" type="radio" name="status_imovel"  data-id_card="<?php e($card->id_card)?>" id="inlineRadio2" value="Desocupado" <?php e($card->status_imovel == "Desocupado" ? "checked" : ""); ?>>
                                                                  <label class="form-check-label" for="status_imovel">Desocupado</label>
                                                                </div>
                                                                <div class="form-check form-check-inline">
                                                                  <input class="form-check-input" type="radio" data-id_card="<?php e($card->id_card)?>" name="status_imovel" id="status-alugado" value="Alugado" <?php e($card->status_imovel == "Alugado" ? "checked" : ""); ?>>
                                                                  <label class="form-check-label" for="status_imovel">Alugado</label>
                                                                </div>
                                                            </div>
                                                            <div class="inquilino-<?php e($card->id_card)?>" <?php e(($card->status_imovel != "Alugado" || empty($card->status_imovel)) ?'style="display: none;"':'')?>>
                                                                <div class="form-group">
                                                                   <label for="nome">Nome inquilino</label>
                                                                   <input type="text" name="nome_inquilino" class="form-control" value="<?php e($card->imovel->nome_inquilino??'')?>">
                                                                </div>
                                                                <div class="form-group">
                                                                    <label for="telefone">Telefone inquilino</label>
                                                                    <input type="phone" name="telefone_inquilino" class="form-control" value="<?php e($card->imovel->telefone_inquilino??'')?>">
                                                                </div>
                                                            </div>
                                                            <!-- Braco Direito / Não / Sim => Dados do Resposavel -->
                                                            <div class="form-group">
                                                                <label>Braço Direito:</label>
                                                                <div class="form-check form-check-inline">
                                                                  <input class="form-check-input" type="radio" data-id_card="<?php e($card->id_card)?>" id="inlineCheckbox1" name="barco_direito" value="Sim" <?php e($card->braco_direito == "Sim" ? "checked" : ""); ?>>
                                                                  <label class="form-check-label" for="barco_direito">Sim</label>
                                                                </div>
                                                                <div class="form-check form-check-inline">
                                                                  <input class="form-check-input" type="radio" data-id_card="<?php e($card->id_card)?>" id="inlineCheckbox2" name="barco_direito" value="Não" <?php e($card->braco_direito == "Não" ? "checked" : ""); ?>>
                                                                  <label class="form-check-label" for="barco_direito">Não</label>
                                                                </div>
                                                            </div>
                                                            <div class="bd-<?php e($card->id_card)?>" <?php e(($card->braco_direito != "Sim" || empty($card->braco_direito)) ?'style="display: none;"':'')?>>
                                                            <div class="form-group">
                                                                   <label for="nome">Nome Braço direito</label>
                                                                   <input type="text" name="nome_bd" class="form-control" value="<?php e($card->nome_braco_direito??'')?>">
                                                                </div>
                                                                <div class="form-group">
                                                                    <label for="telefone">Telefone Braço direito</label>
                                                                    <input type="phone" name="telefone_bd" class="form-control" value="<?php e($card->telefone_braco_direito??'')?>">
                                                                </div>
                                                            </div>
                                                            <div class="form-group <?php e($card->id_imovel != 0 ?'d-none':'')?>">
                                                                <button class="btn btn-sm btn-primary btn-salvar-imovel" data-id_card="<?php e($card->id_card)?>" type="button"><i class="fa fa-dot-circle-o"></i> Salvar</button>
                                                                <button class="btn btn-sm btn-danger" type="reset"><i class="fa fa-ban"></i> Limpar</button>
                                                            </div>
                                                        </span>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                        <?php }else{ ?>
                                            <div class="card text-black bg-light scroll-card">
                                            <div class="card-header">
                                                <a class="card-header-action btn-minimize collapsed" href="#" data-toggle="collapse" data-target="#collapseImovel-<?php e($card->id_card); ?>" aria-expanded="false">Cadastro do Imóvel</a> 
                                                <a href="<?php e(base_url('administrativo/braco_direito/edit_imovel/'.($card->imovel->id_imovel??0)));?>" class="btn btn-sm btn-primary"><i class="icon-pencil"></i> </a>
                                                <a href="<?php e(base_url('administrativo/dashboard/imovel/'.($card->imovel->id_imovel??0)));?>" class="btn btn-sm btn-success" target="_blank"><i class="fa fa-cog"></i> </a>
                                                <a href="<?php e(base_url('imovel/'.($card->imovel->id_imovel??0)));?>" class="btn btn-sm btn-success" target="_blank"><i class="icon-eye"></i> </a>
                                                
                                                <div class="card-header-actions">
                                                    <a class="card-header-action btn-minimize collapsed" href="#" data-toggle="collapse" data-target="#collapseImovel-<?php e($card->id_card); ?>" aria-expanded="false"><i class="icon-arrow-up"></i></a>
                                                </div>
                                            </div>
                                            <div class="collapse" id="collapseImovel-<?php e($card->id_card); ?>">
                                                <div class="card-body">
                                                    <div class="alert-cep-<?php e($card->id_card); ?>"></div>
                                                    <form id="formImovel" action="" method="post">
                                                        <div class="form-group">
                                                           <label for="endereco">CEP</label>
                                                           <input type="text" class="form-control" value="<?php e($card->imovel->cep??'')?>" readonly>
                                                        </div>
                                                        <!--<button class="btn btn-sm btn-secundary btn-verifica-cep <?php e(isset($card->imovel)?'d-none':'')?>" data-id_card="<?php e($card->id_card)?>" type="button"><i class="fa fa-dot-circle-o"></i> Verificar</button>
                                                        <span class="forms-imovel-<?php e($card->id_card)?> <?php e(isset($card->imovel)?'':'d-none')?>" >-->
                                                            <div class="form-group">
                                                               <label for="endereco">Endereço</label>
                                                               <input type="text" class="form-control" value="<?php e($card->imovel->endereco??'')?>" readonly>
                                                            </div>
                                                            <div class="form-group">
                                                               <label for="numero">Numero</label>
                                                               <input type="text" class="form-control" value="<?php e($card->imovel->numero??'')?>" readonly>
                                                            </div>
                                                            <div class="form-group">
                                                               <label for="complemento">Complemento</label>
                                                               <input type="text" class="form-control" value="<?php e($card->imovel->complemento??'')?>" readonly>
                                                            </div>
                                                            <div class="form-group">
                                                               <label for="bairro">Bairro</label>
                                                               <input type="text" class="form-control" value="<?php e($card->imovel->bairro??'')?>" readonly>
                                                            </div>
                                                            <div class="form-group">
                                                                <label for="cidade">Cidade</label>
                                                                <input type="text" class="form-control" value="<?php e($card->imovel->cidade??'')?>" readonly>
                                                            </div>
                                                            <div class="form-group">
                                                                <label for="cidade">Estado</label>
                                                                <input type="text" class="form-control" value="<?php e($card->imovel->estado??'')?>" readonly>
                                                            </div>
                                                            <div class="form-group">
                                                               <label for="valor">Valor Pretendido</label>
                                                               <input type="text" class="form-control" value="<?php e($card->imovel->val_pretendido??'')?>" readonly>
                                                            </div>
                                                            <div class="form-group">
                                                               <label for="valor">Tipo</label>
                                                               <select name="tipo_imovel" class="form-control" disabled>
                                                                <option value="">Selecione</option>
                                                                <?php
                                                                    foreach ($tiposImovel as $grupo=>$options)
                                                                    {
                                                                        echo("<optgroup label='$grupo'>");
                                                                        foreach ($options as $value=>$text)
                                                                        {
                                                                            $selected = '';
                                                                            if($value == $card->imovel->tipo_imovel??'')
                                                                                $selected = 'selected';
                                                                            echo("<option value='$value' $selected >$text</option>");
                                                                        }
                                                                        echo("</optgroup>");
                                                                    }
                                                                ?>
                                                                </select>
                                                            </div>
                                                            <div class="form-row">
                                                                <div class="col">
                                                                    <label for="quartos">Quartos</label>
                                                                    <input type="text" class="form-control" value="<?php e($card->imovel->quartos??'')?>" readonly>
                                                                </div>
                                                                <div class="col">
                                                                    <label for="metragem">M²</label>
                                                                    <input type="text" class="form-control" value="<?php e($card->imovel->area_toal??'')?>" readonly>
                                                                </div>
                                                                <div class="col">
                                                                    <label for="banheiros">Banheiros</label>
                                                                    <input type="text" class="form-control" value="<?php e($card->imovel->banheiros??'')?>" readonly>
                                                                </div>
                                                              </div>
                                                            <!-- Residente / Alugado => Inputs com dados do inquilino / Desocupado -->
                                                            <div class="form-group">
                                                                <label>Status:</label>
                                                                <div class="form-check form-check-inline">
                                                                  <input class="form-check-input" type="radio" name="status_imovel" id="inlineRadio1" value="Residente" <?php e($card->status_imovel == "Residente" ? "checked" : ""); ?> disabled>
                                                                  <label class="form-check-label" for="status_imovel">Residente</label>
                                                                </div>
                                                                <div class="form-check form-check-inline">
                                                                  <input class="form-check-input" type="radio" name="status_imovel" id="inlineRadio2" value="Desocupado" <?php e($card->status_imovel == "Desocupado" ? "checked" : ""); ?> disabled>
                                                                  <label class="form-check-label" for="status_imovel">Desocupado</label>
                                                                </div>
                                                                <div class="form-check form-check-inline">
                                                                  <input class="form-check-input" type="radio" data-id_card="<?php e($card->id_card)?>" name="status_imovel" id="status-alugado" value="Alugado" <?php e($card->status_imovel == "Alugado" ? "checked" : ""); ?> disabled>
                                                                  <label class="form-check-label" for="status_imovel">Alugado</label>
                                                                </div>
                                                            </div>
                                                            <div class="inquilino-<?php e($card->id_card)?>" <?php e(($card->status_imovel != "Alugado" || empty($card->status_imovel)) ?'style="display: none;"':'')?>>
                                                                <div class="form-group">
                                                                   <label for="nome">Nome inquilino</label>
                                                                   <input type="text" name="nome_inquilino" class="form-control" value="<?php e($card->imovel->nome_inquilino??'')?>" readonly>
                                                                </div>
                                                                <div class="form-group">
                                                                    <label for="telefone">Telefone inquilino</label>
                                                                    <input type="phone" name="telefone_inquilino" class="form-control" value="<?php e($card->imovel->telefone_inquilino??'')?>" readonly>
                                                                </div>
                                                            </div>
                                                            <!-- Braco Direito / Não / Sim => Dados do Resposavel -->
                                                            <div class="form-group">
                                                                <label>Braço Direito:</label>
                                                                <div class="form-check form-check-inline">
                                                                  <input class="form-check-input" type="radio" id="inlineCheckbox1" name="barco_direito" value="Sim" <?php e($card->braco_direito == "Sim" ? "checked" : ""); ?> disabled>
                                                                  <label class="form-check-label" for="barco_direito">Sim</label>
                                                                </div>
                                                                <div class="form-check form-check-inline">
                                                                  <input class="form-check-input" type="radio" id="inlineCheckbox2" name="barco_direito" value="Não" <?php e($card->braco_direito == "Não" ? "checked" : ""); ?> disabled>
                                                                  <label class="form-check-label" for="barco_direito">Não</label>
                                                                </div>
                                                            </div>
                                                            <div class="bd-<?php e($card->id_card)?>" <?php e(($card->braco_direito != "Sim" || empty($card->braco_direito)) ?'style="display: none;"':'')?>>
                                                            <div class="form-group">
                                                                   <label for="nome">Nome Braço direito</label>
                                                                   <input type="text" name="nome_bd" class="form-control" value="<?php e($card->nome_braco_direito??'')?>" readonly>
                                                                </div>
                                                                <div class="form-group">
                                                                    <label for="telefone">Telefone Braço direito</label>
                                                                    <input type="phone" name="telefone_bd" class="form-control" value="<?php e($card->telefone_braco_direito??'')?>" readonly>
                                                                </div>
                                                            </div>
                                                            <!--<div class="form-group <?php e($card->id_imovel != 0 ?'d-none':'')?>">
                                                                <button class="btn btn-sm btn-primary btn-salvar-imovel" data-id_card="<?php e($card->id_card)?>" type="button"><i class="fa fa-dot-circle-o"></i> Salvar</button>
                                                                <button class="btn btn-sm btn-danger" type="reset"><i class="fa fa-ban"></i> Limpar</button>
                                                            </div>
                                                        </span>-->
                                                    </form>
                                                </div>
                                            </div>
                                        
                                        </div>
                                        <?php } } ?>
                                        
                                        <!-- end checklist/tarefa -->
                                        
                                        <?php $idList = 4; if($lista->id_lista >= $idList){ if($lista->id_lista == $idList){ ?>
                                            <div class="card text-white bg-info scroll-card">
                                            <div class="card-header">
                                                <a class="card-header-action btn-minimize" href="#" data-toggle="collapse" data-target="#collapseAgenda-<?php e($card->id_card); ?>" aria-expanded="false">Agendamento de visita</a>
                                                <div class="card-header-actions">
                                                    <a class="card-header-action btn-minimize" href="#" data-toggle="collapse" data-target="#collapseAgenda-<?php e($card->id_card); ?>" aria-expanded="false"><i class="icon-arrow-up"></i></a>
                                                </div>
                                            </div>
                                            <div class="collapse show" id="collapseAgenda-<?php e($card->id_card); ?>">
                                                <div class="card-body">
                                                    <form id="formAgendarFotos-<?php e($card->id_card); ?>" action="" method="post">
                                                        <div class="form-group">
                                                               <label for="fotografo">Fotógrafo  Profissional</label>
                                                               <select name="fotografo" class="form-control">
                                                                <option value="">Selecione</option>
                                                                <?php
                                                                    foreach ($fotografos as $fotografo)
                                                                    {
                                                                        $selected = '';
                                                                        if($card->id_fotografo == $fotografo->id_cadastro)
                                                                        $selected = 'selected';
                                                                        echo("<option value='$fotografo->id_cadastro' $selected >$fotografo->nome</option>");
                                                                        
                                                                    }
                                                                ?>
                                                                </select>
                                                        </div>
                                                        <!--<button class="btn btn-sm btn-secundary btn-salva-fotografo <?php //e(isset($card->imovel)?'d-none':'')?>" data-id_card="<?php //e($card->id_card)?>" type="button"><i class="fa fa-dot-circle-o"></i> Salvar</button>-->
                                                        <div class="form-group">
                                                           <label for="endereco">Autorização do dono</label>
                                                            <div class="form-label">
                                                                <div class="form-check form-check-inline mr-1">
                                                                    <input class="form-check-input" id="autorizacao_dono_1" type="radio" value="Sim" name="autorizacao_dono">
                                                                    <label class="form-check-label" for="autorizacao_dono_1">Sim</label>
                                                                </div>
                                                                <div class="form-check form-check-inline mr-1">
                                                                    <input class="form-check-input" id="autorizacao_dono_2" type="radio" value="Não" name="autorizacao_dono">
                                                                    <label class="form-check-label" for="autorizacao_dono_2">Não</label>
                                                                </div>
                                                                <div class="form-check form-check-inline mr-1">
                                                                    <input class="form-check-input" id="autorizacao_dono_3" type="radio" value="Aguardando" name="autorizacao_dono">
                                                                    <label class="form-check-label" for="autorizacao_dono_3">Aguardando</label>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="form-group">
                                                           <label for="data_hora">Data e Hora</label>
                                                           <input type="datetime-local" name="data_fotos" class="form-control" value="<?php e($card->data_fotos??'')?>">
                                                        </div>
                                                        <div class="form-group">
                                                            <button class="btn btn-sm btn-primary btn_agendar_fotos" data-id_card="<?php e($card->id_card)?>" type="button"><i class="fa fa-dot-circle-o"></i> Salvar</button>
                                                            <button class="btn btn-sm btn-danger" type="reset"><i class="fa fa-ban"></i>Limpar</button>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                        <?php }else{ ?>
                                            <div class="card text-black bg-light scroll-card">    
                                            <div class="card-header">
                                                <a class="card-header-action btn-minimize" href="#" data-toggle="collapse" data-target="#collapseAgenda-<?php e($card->id_card); ?>" aria-expanded="false">Agendamento de visita</a>
                                                <div class="card-header-actions">
                                                    <a class="card-header-action btn-minimize" href="#" data-toggle="collapse" data-target="#collapseAgenda-<?php e($card->id_card); ?>" aria-expanded="false"><i class="icon-arrow-up"></i></a>
                                                </div>
                                            </div>
                                            <div class="collapse show" id="collapseAgenda-<?php e($card->id_card); ?>">
                                                <div class="card-body">
                                                    <form id="formAgendarFotos" action="" method="post">
                                                        <div class="form-group">
                                                               <label for="fotografo">Fotógrafo  Profissional</label>
                                                               <select name="fotografo" class="form-control" disabled>
                                                                <option value="">Selecione</option>
                                                                <?php
                                                                    foreach ($fotografos as $fotografo)
                                                                    {
                                                                        $selected = '';
                                                                        if($card->id_fotografo == $fotografo->id_cadastro)
                                                                        $selected = 'selected';
                                                                        echo("<option value='$fotografo->id_cadastro' $selected >$fotografo->nome</option>");
                                                                        
                                                                    }
                                                                ?>
                                                                </select>
                                                        </div>
                                                        <!--<button class="btn btn-sm btn-secundary btn-salva-fotografo <?php //e(isset($card->imovel)?'d-none':'')?>" data-id_card="<?php //e($card->id_card)?>" type="button"><i class="fa fa-dot-circle-o"></i> Salvar</button>-->
                                                        <div class="form-group">
                                                           <label for="endereco">Autorização do dono</label>
                                                            <div class="form-label">
                                                                <div class="form-check form-check-inline mr-1">
                                                                    <input class="form-check-input" id="autorizacao_dono_1" type="radio" value="Sim" name="autorizacao_dono" <?php e($card->autorizacao_dono == "Sim" ? "checked" : ""); ?> disabled>
                                                                    <label class="form-check-label" for="autorizacao_dono_1">Sim</label>
                                                                </div>
                                                                <div class="form-check form-check-inline mr-1">
                                                                    <input class="form-check-input" id="autorizacao_dono_2" type="radio" value="Não" name="autorizacao_dono" <?php e($card->autorizacao_dono == "Não" ? "checked" : ""); ?> disabled>
                                                                    <label class="form-check-label" for="autorizacao_dono_2">Não</label>
                                                                </div>
                                                                <div class="form-check form-check-inline mr-1">
                                                                    <input class="form-check-input" id="autorizacao_dono_3" type="radio" value="Aguardando" name="autorizacao_dono" <?php e($card->autorizacao_dono == "Aguardando" ? "checked" : ""); ?> disabled>
                                                                    <label class="form-check-label" for="autorizacao_dono_3">Aguardando</label>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="form-group">
                                                           <label for="data_hora">Data e Hora</label>
                                                           <input type="text" name="data_fotos" class="form-control" value="<?php e($card->data_fotos??'')?>" readonly>
                                                        </div>
                                                        <!--<div class="form-group">
                                                            <button class="btn btn-sm btn-primary btn_agendar_fotos" data-id_card="<?php e($card->id_card)?>" type="button"><i class="fa fa-dot-circle-o"></i> Salvar</button>
                                                            <button class="btn btn-sm btn-danger" type="reset"><i class="fa fa-ban"></i>Limpar</button>
                                                        </div>-->
                                                    </form>
                                                </div>
                                            </div>
                                            </div>
                                        <?php } } ?>
                                        
                                        
                                        <!-- end checklist/tarefa -->
                                        <div class="box-alert alerts-<?php e($card->id_card)?>"></div>
                                        <div class="form-group">
                                             <button class="btn btn-sm btn-default prev_list float-left mb-4" data-id_card="<?php e($card->id_card)?>" type="button"><i class="icon-arrow-left-circle "></i> Voltar</button>
                                            <button class="btn btn-sm btn-success next_list float-right mb-4" data-id_card="<?php e($card->id_card)?>" type="button"><i class="icon-arrow-right-circle "></i> Avançar</button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <?php $i++; } ?>
                            <!--end cards-->
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php } ?>
        <!--end lists-->
    </div>
</div>
<div class="modal fade modalAddCard" id="modalAddCard" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true" style="display: none;">
    <div class="modal-dialog modal-success" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">Adicionar Cartão</h4>
                <button class="close" type="button" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">×</span>
                </button>
            </div>
            <div class="modal-body">
                <p> ---- </p>
                <form id="formAddNewCard" action="" method="post">
                    <div class="form-group">
                       <label for="titulo">Titulo Cartão</label>
                       <input type="text" name="titulo" id="titulo" class="form-control" value="">
                    </div>
                    
                    <div class="form-group">
                       <label for="id_cadastro">Id Cadastro</label>
                       <input type="text" name="id_cadastro" class="form-control" value="">
                    </div>
                    
                    <div class="form-group">
                       <label for="id_imovel">Id Imovel</label>
                       <input type="text" name="id_imovel" class="form-control" value="">
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <a href="javascript:;" class="btn btn-success iniciarCartao">Iniciar atendimento</a>
                <button class="btn btn-secondary" type="button" data-dismiss="modal">Fechar</button>
            </div>
        </div>
    </div>
</div>


<?php } ?>