<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

include_once GROCERY_CRUD;

class Correspondentes extends Grocery {

    function __construct() 
    {
        parent::__construct();
        $this->load->model('comdono/cad_model');
		$this->load->model('administrativo/admin_model');
		$this->load->model('administrativo/dash_model');
		
		Assets::add_module_js('comdono', array(
            'main'
        ));
        
        $this->dataTables();
        
        $instance = parent::get_instance();
        $method = $instance->router->fetch_method();
        Template::set_html_custom($this->setNotificacoes(['tipo_interesse'=> $method]), 'atendimento/blocos/box_atendimentos', 'box_atendimento');
        Template::set_modal([],'atendimento/blocos/modal_atendimento_rapido');
    }
    
    function setNotificacoes($data = [])
    {
        
        $naoAguardandoRetorno = [];
        $naoAtendidas = [];
        
        //===============================RESUMO ATENDIMENTO================================================
        $whereCadsImovelHipoteca = [['status_hipoteca', 1]];
        $whereSimulacoes = [['step >=',4]];
        
        //1 - tb_origem / 2 - $name_id / 3 - $function_get / 4 -  $where / 5 - $tipo_interesse(cad_atendimento_historico)  / 6 -  $name(titulo)
        $configAtendimento = [
                
                ['cad_imovel',  'id_imovel',  'getImoveisCad', $whereCadsImovelHipoteca, 'hipotecas',               'Hipotecas'],
                ['fnc_simulacao', 'id_simulacao', 'getSimulacoes', $whereSimulacoes,      'financiamento_completo', 'Financiamentos'],
        ];
        
        foreach ($configAtendimento as $dt)
        {
            $tb_origem      = $dt[0];
            $name_id        = $dt[1];
            $function_get   = $dt[2];
            $where          = $dt[3];
            $UUID           = $dt[4];
            $name           = $dt[5];
            $link           = $dt[6]??"atendimento/correspondentes/$UUID";
            
            $CapturasNaoAtendidas = $this->admin_model->getNaoAtendidas($tb_origem, $name_id, $function_get, $where, $UUID);
            //if(!empty($CapturasNaoAtendidas)){
            $naoAtendidas[] = (object)[
                    'UUID'     => $UUID,
                    'key'      => $tb_origem,
                    'name'     => $name,
                    'qnt'      => count($CapturasNaoAtendidas),
                    'link'     => $link,
                ];
            //}
             
            $CapturasAtendidas = $this->admin_model->getAguardandoRetorno($tb_origem, $name_id, $function_get, $where, $UUID);
            if(!empty($CapturasAtendidas)){
                $naoAguardandoRetorno[] = (object)[
                        'UUID'     => $UUID,
                        'key'      => $tb_origem,
                        'name'     => $name,
                        'qnt'      => count($CapturasAtendidas),
                        'link'     => $link,
                    ];
            }
        }
        
        $data['naoAtendidas'] = $naoAtendidas;
        $data['naoAguardandoRetorno'] = $naoAguardandoRetorno;
        
        return $data;
    }
       
    function index()
    {
        $this->ini_method();
        $data['module'] = $module = Menu_lib::getModuleByNickname($this->module);
        $data['tipo_interesse'] = "";
        
        Template::load_view('atendimento/blocos/box_atendimentos.php', $this->setNotificacoes($data), '', '', $data['box_atendimento']);
        
        Template::set($data);
        Template::set_view('comdono_view');
        Template::render();
    }
    
    function setBlocosCondono($data)
    {
        Template::set_html_custom($this->setNotificacoes($data), 'atendimento/blocos/box_atendimentos', 'box_atendimento');
        Template::set_modal($data,'atendimento/blocos/modal_atendimento_rapido');
    }
    
    function hipotecas()
	{
        $this->ini_method('index')->breadcrumb();
        
        $w[] = ['status_hipoteca', 1];
        
        $anunciantes = $this->admin_model->getImoveisCad($w);
        
        $data['atendimentosFinalizados'] = []; 
        $data['atendimentosProximoContato'] = [];
        $data['atendimentosAguardando'] = $anunciantes; 
        foreach ($anunciantes as $k=>$anunciante)
        {
            $w['id'] = ['id_cadastro',$anunciante->id_cadastro];
            $anunciante->atendimento  = $this->admin_model->getAtendimentoHistoricoDesc([['id_rel',$anunciante->id_imovel],['tb_origem','cad_imovel'],['tipo_interesse','hipotecas']]);
            
            if(!empty($anunciante->atendimento))
            {
                $proximo_contato = end($anunciante->atendimento)->proximo_contato;
                if($proximo_contato == 0 || $proximo_contato == '0000-00-00 00:00:00')
                {
                    $data['atendimentosFinalizados'][] = $anunciante;
                }
                else
                {
                    $data['atendimentosProximoContato'][] = $anunciante;
                }
                unset($data['atendimentosAguardando'][$k]);
            }
        }
        
        $this->dataTables();
        
        Assets::add_module_js('atendimento', array(
            'atendimento'
        ));
        
        $data['anunciantes'] = $anunciantes;
        
        Template::set($data);
        Template::set_view('atendimento/hipotecas_view');
        Template::render();
    }
    
    //Financiamento com imóveis
    function financiamento_completo()
	{
        $this->ini_method('index')->breadcrumb('Financiamentos');
        
        $simulacoes = $this->admin_model->getSimulacoes(['fnc_simulacao.step >=',4]);//,['fnc_simulacao.step >=',4]
        
        $data['atendimentosAguardando'] = $simulacoes;
        $data['atendimentosFinalizados'] = []; 
        $data['atendimentosProximoContato'] = []; 
        
        foreach ($simulacoes as $k=>$sim)
        {
            $sim->interessado  = $this->admin_model->get_cadastro([],$sim->id_cad_interessado);
            $sim->dono         = $this->admin_model->get_cadastro([],$sim->id_cad_dono);
            $sim->imovel       = $this->admin_model->getImovel([['a.id_imovel',$sim->id_imovel]]);
            $sim->atendimento  = $this->admin_model->getAtendimentoHistoricoDesc([['id_rel',$sim->id_simulacao],['tb_origem','fnc_simulacao'],['tipo_interesse','financiamento_completo']]);
            
            if(!empty($sim->atendimento))
            {
                $proximo_contato = end($sim->atendimento)->proximo_contato;
                if($proximo_contato == 0 || $proximo_contato == '0000-00-00 00:00:00')
                {
                    $data['atendimentosFinalizados'][] = $sim;
                }
                else
                {
                    $data['atendimentosProximoContato'][] = $sim;
                }
                unset($data['atendimentosAguardando'][$k]);
            }
            
            $sim->actions[] = "<a href='".base_url('atendimento/correspondentes/simulacao/'.$sim->id_simulacao)."' class='btn btn-sm btn-outline-primary' data-toggle='tooltip' data-original-title='Bancos'>
                                <i class='fa fa-credit-card'></i>
                               </a>";
        
            
        }
        
        Assets::add_module_js('atendimento', array(
            'atendimento'
        ));
        
        Template::set($data);
        Template::set_view('atendimento/financiamentos_view');
        Template::render();
		    
    }
	
	function simulacao()
	{
		try{
		    //$this->ini_method('solicitacoes');
		    $this->ini_method('index')->breadcrumb('Financiamentos','financiamento_completo')->breadcrumb('Simulacão');
			$crud = new Custom_Grocery_Crud();
			$this->valida_acoes($crud);
			
			$id_simulacao = $this->uri->segment(4);
			
			$crud->set_theme('bootstrap');
			$crud->set_table('fnc_banco_rel_simulacao');
			$crud->where('id_simulacao', $id_simulacao);
			
			$crud->set_relation('id_banco','fnc_bancos','Banco');
			
			$state = $crud->getState();
            $state_info = $crud->getStateInfo();
            $simulacao = $this->admin_model->getSimulacaoFinanciamento(['a.id_simulacao'=>$id_simulacao]);
            $interessado = $this->admin_model->getCadastro([['id_cadastro',$simulacao->id_cad_interessado]]);
            
            $crud->field_type('id_cadastro','hidden',$interessado->id_cadastro);
            $crud->field_type('id_simulacao', 'hidden', $id_simulacao);
			
			if($state == 'edit')
    		{
    		    /*$crud->field_type('id_simulacao','readonly');
    			$crud->field_type('id_cadastro','readonly');*/
    		}
			
    		$this->setViewBancos([
    		    'id_simulacao' => $id_simulacao,
                'state' => $state,
                'state_info' => $state_info,
		    ]);
			
			$crud->set_subject('Solicitações de Financiamento');
			
			$crud->unset_fields('banco_chec','agencia', 'conta');
			
			//$crud->display_as('id_simulacao', 'Nº Simulação');
			$crud->display_as('id_banco', 'Banco');
			$crud->display_as('id_cadastro', 'Nome');
			$crud->display_as('file_url', 'Proposta');
			$crud->display_as('status_bcrel', 'Status');
			
			//$crud->field_type('status_bcrel','dropdown', array('0' => 'Aguardando análise', '1' => 'Em análise', '2' => 'Aprovada', '3' => 'Negada'));
			$crud->field_type('status_bcrel','dropdown', array('0' => 'Em andamento', '1' => 'Enviado'));
			
			$crud->columns('id_banco', 'id_cadastro', 'status_bcrel', 'primeira_parcela', 'ultima_parcela', 'prazo_total', 'valor_total', 'taxa_efetiva', 'cet', 'file_url');
			
			// Callbacks
			$crud->callback_field('primeira_parcela',array($this,'_callback_field_primeira_parcela'));
			$crud->callback_field('ultima_parcela',array($this,'_callback_field_ultima_parcela'));
			$crud->callback_field('prazo_total',array($this,'_callback_field_prazo_total'));
			$crud->callback_field('valor_total',array($this,'_callback_field_valor_total'));
			$crud->callback_field('contatado',array($this,'_callback_field_contatado'));
			$crud->callback_column('status_bcrel',array($this,'_callback_status_bcrel'));
			$crud->callback_column('id_banco',array($this,'_callback_logo_banco'));
			$crud->callback_column('file_url',array($this,'_callback_icon_file'));
			
			//required_fields
			$crud->required_fields('id_banco','status_bcrel','status','contatado','file_url');
    		
		    $this->config->set_item('grocery_crud_file_upload_allow_file_types','pdf');
		    $crud->set_field_upload_S3('file_url','financiamento/'.$id_simulacao.'/pdf');
		    
			/*$stateInfo = $crud->getStateInfo();
			$state = $crud->getState();*/
			
			Assets::add_module_css('administrativo', array(
                'admin',
            ));
            
            Assets::add_module_js('atendimento', array(
                'atendimento'
            ));
            
			$output = $crud->render();
			
			$this->_example_output($output);
			
		}catch(Exception $e){
			show_error($e->getMessage().' --- '.$e->getTraceAsString());
		}
	}
	
	function _callback_field_primeira_parcela()
    {
      return '<input class="form-control moneyMask" name="primeira_parcela" type="text" maxlength="50">';
    }
    function _callback_field_ultima_parcela()
    {
      return '<input class="form-control moneyMask" name="ultima_parcela" type="text" maxlength="50">';
    }
    function _callback_field_prazo_total()
    {
      return '<input class="form-control moneyMask" name="prazo_total" type="number" min="12" max="420">';
    }
    function _callback_field_valor_total()
    {
      return '<input class="form-control moneyMask" name="valor_total" type="text" maxlength="50">';
    }
    function _callback_field_contatado()
    {
    	return ' <input type="radio" name="contatado" value="1" /> Sim  <input type="radio" name="contatado" value="0" /> Não';
    }
	public function _callback_status_bcrel($value, $row)
    {
      return '<div class="m-0 alert '.HProposta::getStatus($value)->bg.'">'. HProposta::getStatus($value)->text . '</div>';
    }
    public function _callback_logo_banco($value, $row)
    {
        $banco = $this->admin_model->getBancoFinanciamento(['id_banco'=>$value]);
        
        //var_dump($banco);
        
        return '<img src='.(base_url($banco->logo_ativa)).'>';
    }
	public function _callback_icon_file($value, $row)
	{
	    if($value == ''){
	        $div = '';
	    }else{
	        $div = '<div class="text-center" style="font-size:15px"><a href="'.$value.'" target="_blank"><i class="fa fa-file-code-o" aria-hidden="true"></i></a></div>';
	    }
	    return $div;
	}
	
	
	
	
   
    private function setViewBancos($data)
	{
	    $data['simulacao'] = $this->admin_model->getSimulacao([['id_simulacao',$data['id_simulacao']]]);
	    
	    if(isset($data['simulacao']->id_cad_interessado)) 
	    {
    	    $data['interessado'] = $this->admin_model->getCadastro([['id_cadastro', $data['simulacao']->id_cad_interessado]]); 
    	    
    	    $data['imovel'] = $this->admin_model->getImovel([['a.id_imovel',$data['simulacao']->id_imovel]]);
    	    
            //$teste = ['status','lixeira','dn_nome_nomefantasia','dn_telefone','dn_email','dn_cpf_cnpj','dn_img','dn_img_uri','tipo_imovel','lancamento','previsao_entrega','cep','endereco','numero','complemento','bairro','cidade','estado'];
            
    	    Template::set_html_custom($data,'correspondentes/simulacao_resumo_view');
	    }
	}
    public function dataTables()
    {
	    Assets::add_css(array(
            '../comdono/plugins/dataTables/css/dataTables.bootstrap4.min',
        ));
        
        Assets::add_js(array(
            '../comdono/plugins/dataTables/js/jquery.dataTables.min',
            '../comdono/plugins/dataTables/js/dataTables.bootstrap4.min',
            '../comdono/plugins/dataTables/js/dataTables.buttons.min.js',
            '../comdono/plugins/dataTables/js/buttons.flash.min.js',
            '../comdono/plugins/dataTables/js/jszip.min.js',
            '../comdono/plugins/dataTables/js/vfs_fonts.js',
            '../comdono/plugins/dataTables/js/buttons.html5.min.js',
            '../comdono/plugins/dataTables/js/config'
        ));
	}
   
   
   
   
   
   
   
   
    
}