<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

include_once GROCERY_CRUD;

class Incorporadoras extends Grocery {

    function __construct() 
    {
        parent::__construct();
        //$this->load->model('comdono/cad_model');
		$this->load->model('administrativo/admin_model');
		$this->load->model('administrativo/dash_model');
		$this->load->model('minha_conta/conta_model');
		
		Assets::add_module_js('comdono', array(
            'main'
        ));
    }
    
    /*function email(){
        Template::set_view('atendimento/blocos/box_informacoes_email_demo_view');
        Template::render();
    }*/
    
    function index()
    {
        $this->ini_method();
        
        $this->load->library('marketing/Wimoveis_lib');
        
        //$data['module'] = $module = Menu_lib::getModuleByNickname($this->module);
        //$this->breadcrumb("<i class='nav-icon $module->icon'></i> $module->name");
        
        $data['negociacoes_andamento'] = count($this->admin_model->getNegociacoes([['step >=','1'],['step <=','2']]));
        $data['novas_negociacoes'] = count($this->admin_model->getNegociacaoByData([['ngc_negociacoes.step >=', '1'],['ngc_negociacoes.step <=','2'],['p.data_prereserva >=',date('Y-m-d 00:00:00')]]));
        
        $data['negociacoes_concluida'] = count($this->admin_model->getNegociacoes([['step =','3']]));
        $data['novas_negociacoes_concluida'] = count($this->admin_model->getNegociacaoByData([['ngc_negociacoes.step =','3'],['p.data_prereserva >=',date('Y-m-d 00:00:00')]]));
        
        $data['reunioes'] = $this->admin_model->getAgendas([['destino','1'],['tipo_agendamento !=','3']]);
        $data['reunioes_concluidas'] = $this->admin_model->getVisitas([['destino','1'],['tipo_agendamento !=','3']]);
        
        $data['empreendimentos'] = $this->cad_model->getEmpreendimentos([['emp_status',4]]);
        
        $data['historicos'] = [];
        
        $historicos = $this->admin_model->getHistoricosAtendimentoIncorporadoras($this->session->id_cadastro);
        
        foreach($historicos as $hist){
            if($hist->origem == 1){
                $cap = $this->cad_model->getCapAgenda([['id_agenda',$hist->id_origem]]);
                $cad = $this->cad_model->getCadastro([['id_cadastro', $cap->id_cadastro]]);
                $uri = 'desistencia';
            }else{
                $cap = $this->cad_model->getCaptura([['id_captura', $hist->id_origem]]);
                if(!isset($cap->id_cadastro)) // tratamento para não quebrar atendimento qdo a captura tiver sido excluida manualmente da tabela
                    continue;
                $cad = $this->cad_model->getCadastro([['id_cadastro', $cap->id_cadastro]]);
                $uri = 'atendimento';
            }
           
            //STATUS VAO AUMENTAR FAZER SWITCH CASE
            if($hist->status == 1){
                $hist->status_formatado = '<span class="badge badge-warning">Em Atendimento</span>';
            }elseif($hist->status == 2){
                $hist->status_formatado = '<span class="badge badge-success">Finalizado</span>';
            }elseif($hist->status == 3){
                $hist->status_formatado = '<span class="badge badge-info">Adiado</span>';
            }
            
            
            $hist->captura = $this->cad_model->getEmpreendimento([['uuid_empreendimento',$cap->origem_captura]])->emp_nome_fantasia??'';
            //$hist->captura = $this->cad_model->getEmpreendimento([['uuid_empreendimento',$cap->origem_captura]])->emp_nome_fantasia;
            //$hist->captura = $this->cad_model->getEmpreendimento([['uuid_empreendimento',$cap->origem_captura]]);
            
            $hist->uri_atend = $uri.'/'.$hist->id_origem;
            
            $data['historicos'][] = (object)array_merge((array)$hist, (array)$cad, (array)$cap);
        }
        
        //PEGA A QNT DE INTERESSES CADASTRADOS
        $interesses = $this->cad_model->getInteresses();
        $data['interesses_cont'] = count($interesses);
        
        //PEGA TODOS OS INTERESSES PARA LISTAR
        
        $hist_interesses=[];
        foreach($interesses as $inter){
        
            $inter->pessoa = $this->cad_model->getCaptura([['id_captura', $inter->id_captura]]);
            if(empty($inter->pessoa)){
                $inter->pessoa = $this->cad_model->getCadastro([['id_cadastro', $inter->id_cadastro]]);
            }
            $inter->bairros = $this->cad_model->getBairrosInteresse([['id_interesse', $inter->id_interesse]]);
            $inter->tipo_emp = $this->cad_model->getTiposEmpInteresse([['id_interesse', $inter->id_interesse]]);
            $hist_interesses[] = $inter;
        }
        $data['interesses']=$hist_interesses;
        
        //PEGAR O NUMERO DE ATENDIMENTOS CONCLUIDOS
        $atendimentos_concluidos = $this->admin_model->getFilas(['status'=>2]);
        $data['atendimentos_concluidos'] = count($atendimentos_concluidos);
        
        //PEGAR A QNT DE VISITAS AGENDADAS / REALIZADAS
        $data['reunioes_age'] = count($data['reunioes']);
        $data['reunioes_real'] = count($data['reunioes_concluidas']);
        
        //PEGAR A QNT DE QUANTAS PESSOAS AINDA NÃO FORAM ATENDIDAS
        $atendimentos_pendentes = $this->admin_model->getFilaAtendimentos();
        if($atendimentos_pendentes == NULL){
            $data['atendimentos_pendentes'] = '0';
        }
        else{
            $data['atendimentos_pendentes'] = count($atendimentos_pendentes);
        }
        
        //PEGAR O NUMERO DE ATENDIMENTOS NO FOLLOW-UP
        $atendimentos_fu = $this->admin_model->getFilas(['status'=>3]);
        $data['atendimentos_fu'] = count($atendimentos_fu);
        
        //PEGAR O NUMERO DE ATENDIMENTOS SENDO REALIZADOS
        $atendimentos_em_andamento = $this->admin_model->getFilas(['status'=>1]);
        $data['atendimentos_em_andamento'] = count($atendimentos_em_andamento);
        
        //PEGAR O NUMERO TOTAL DE ATENDIMENTOS REALIZADOS/A SEREM REALIZADOS/ SENDO REALIZADOS
        $total_atend = $data['atendimentos_pendentes'] + $data['atendimentos_fu'] + $data['atendimentos_em_andamento'] + $data['atendimentos_concluidos'];
        $data['atendimentos_total'] = $total_atend;
        
        //Pegar os leads do Wimoveis
        $data['leads_wimoveis'] = $this->wimoveis_lib->get_all_msg();
        $data['qtd_leads_wimoveis'] = count($data['leads_wimoveis']);
        
        //Pegar os leads do VivaReal
        $leads = $this->cad_model->getCapturas([['origem_captura', 'portais_VivaReal'],['datetime_captura >', date('Y-m-d H:i:s', strtotime('-2 months', strtotime(date('Y-m-d H:i:s'))))]]);
        
        foreach ($leads as $l){
            $l->imovel_interesse = $this->cad_model->getImovel(['id_imovel' => $l->portais_imovel]);
        }
        
        $data['leads_vivareal'] = array_reverse($leads);
        $data['qtd_leads_vivareal'] = count($leads);
        
        //Pegar os leads do Zap
        $leads_zap = $this->cad_model->getCapturas([['origem_captura', 'portais_Zap'],['datetime_captura >', date('Y-m-d H:i:s', strtotime('-2 months', strtotime(date('Y-m-d H:i:s'))))]]);
        
        foreach ($leads_zap as $lz){
            $lz->imovel_interesse = $this->cad_model->getImovel(['id_imovel' => $lz->portais_imovel]);
        }
        
        $data['leads_zap'] = array_reverse($leads_zap);
        $data['qtd_leads_zap'] = count($leads_zap);
        
        //Pegar os leads do GrupoZap
        $leads_grupozap = $this->cad_model->getCapturas([['origem_captura', 'portais_GrupoZap'],['datetime_captura >', date('Y-m-d H:i:s', strtotime('-2 months', strtotime(date('Y-m-d H:i:s'))))]]);
        
        foreach ($leads_grupozap as $lgz){
            $lgz->imovel_interesse = $this->cad_model->getImovel(['id_imovel' => $lgz->portais_imovel]);
        }
        
        $data['leads_grupozap'] = array_reverse($leads_grupozap);
        $data['qtd_leads_grupozap'] = count($leads_grupozap);
        
        //Salvando o id do atendente
        $data['id_responsavel'] = $this->session->id_cadastro;
        
		Assets::add_css(array(
		    '../comdono/plugins/charts-2.8.0/css/Chart.min',
            '../comdono/plugins/fullcalendar-5.3.2/main',
            '../comdono/plugins/datetimepicker/css/bootstrap-datetimepicker.min',
            '../painel/plugins/select2-4.1.0-beta.1/select2.min',
            '../comdono/plugins/daterangepicker-v3.14/daterangepicker',
        ));
        
        Assets::add_js(array(
            '../comdono/plugins/charts-2.8.0/js/Chart.min',
            '../comdono/plugins/fullcalendar-5.3.2/main',
            '../comdono/plugins/fullcalendar-5.3.2/locales/pt-br',
            '../comdono/plugins/datetimepicker/js/moment',
            '../comdono/plugins/datetimepicker/js/bootstrap-datetimepicker.min',
            '../comdono/plugins/datetimepicker/js/locale',
            '../painel/plugins/select2-4.1.0-beta.1/select2.min',
            '../comdono/plugins/daterangepicker-v3.14/daterangepicker.min',            
        ));
        
        Assets::add_module_css('atendimento', array(
            'atendimento'
        ));
        
        $this->dataTables();
        
        Assets::add_module_js('atendimento', array(
            'fullcalendar',
            'chart.js',
            'date_time',
            'dash_atendimento',
            'atendimento_fila',
            'atendimento_geral',
        ));
        
        Template::set($data);
        Template::set_view('atendimento/dashboard_incorporadora_view');
        Template::render();
    }

    
    /** * Função para o atendimento de captura ou desistencia
    * @access public 
    * @param String $tipo - Possíveis tipos: agendamento ou desistencia
    * @param String $id - Id da captura em caso de agendamento e Id da agenda em caso de desistencia
    * @return Output
    */
    function atendimento($tipo = NULL, $id = NULL)
    {
        $this->ini_method('index');
        
        $data['module'] = $module = Menu_lib::getModuleByNickname($this->module);
        $this->breadcrumb("<i class='nav-icon $module->icon'></i> $module->name");
        
        $data['tipo'] = $tipo;
        //dd($this->session->perfil);
        //DEIXAR SEM CONTROLE DE ACESSO POR ENQUANTO
        /*$responsavel_sessao = $this->admin_model->getStatusFila('id_origem = '.$id.' AND origem = 1 AND id_responsavel = '.$this->session->id_cadastro.' AND status = 1')->id_responsavel;
        if($this->session->id_cadastro != $responsavel_sessao || $this->session->perfil != '1'){
            echo "Não é o responsável pelo atendimento";
        }*/
        
        if($tipo == 'desistencia'){
            
            $num_tipo = 1;
            
            $data['fila'] = $this->admin_model->getStatusFila('id_origem = '.$id.' AND origem = 1 AND id_responsavel = '.$this->session->id_cadastro.' AND status = 1');
            
            $data['agenda'] = $this->cad_model->getAgenda([['id_agenda',$id]]);
            //dd($data['agenda']);
            
            $data['visita'] = $this->cad_model->getVisita([['id_agenda',$id]]);
            
            $data['negociacao'] = $this->cad_model->getNegociacao([['id_visita',$data['visita']->id_visita]]);
            
            //GET EM TODAS AGENDAS, gambirra do igual
            $data['agendas'] = $this->cad_model->getAgendas([['JSON_UNQUOTE(JSON_EXTRACT(participantes, "$.id_interessado")) =',$data['agenda']->participantes->id_interessado]]);
            //dd($data['agendas']);
            
            if(!empty($data['agendas'])){
                $data['agendas'] = $this->trataAgenda($data['agendas']);
            }
            //dd($data['agendas']);
            //GET EM TODOS EMPREENDIMENTOS
            $data['empreendimentos'] = $this->cad_model->getEmpreendimentos([['emp_status',4]]);
            
            //Chegou a negociacao
            if($data['negociacao'] != NULL){
                
                $id_origem = $this->admin_model->get_Negociacao_origem($data['negociacao']->id_negociacao);
                
                $data['dados_pessoais'] = $this->admin_model->get_Negociacao($data['negociacao']->id_negociacao, $id_origem);
                
                $data['pre_reserva'] = $this->cad_model->getPreReserva([['id_visita',$data['visita']->id_visita]]);
                
                $data['empreendimento'] = $this->cad_model->getEmpreendimento([['id_empreendimento',$data['negociacao']->id_empreendimento]]);
                
                $data['unidade'] = $this->cad_model->getImovel(['id_imovel'=>$data['empreendimento']->id_imovel]);
                
                $data['vendedor'] = $this->cad_model->getCadastro([['id_cadastro',$data['negociacao']->id_vendedor]]);
                
                $data['incorporadora'] = $this->cad_model->getIncorporadora([['id_incorporadora',$data['empreendimento']->id_incorporadora]]);
                
                $data['id_cadastro'] = $this->cad_model->getCadastroByEmail($data['dados_pessoais']->email)->id_cadastro;
                
            }
            else{
                
                $dados_pessoais = $this->cad_model->getCadastro([['id_cadastro',$data['agenda']->participantes->id_interessado]]);
                
                $data['empreendimento'] = $this->cad_model->getEmpreendimento([['id_empreendimento',$data['agenda']->id_destino]]);
                
                $data['unidade'] = $this->cad_model->getImovel(['id_imovel'=>$data['empreendimento']->id_imovel]);
                
                $data['vendedor'] = $this->cad_model->getCadastro([['id_cadastro',$data['agenda']->participantes->id_responsavel]]);
                
                $data['incorporadora'] = $this->cad_model->getIncorporadora([['id_incorporadora',$data['empreendimento']->id_incorporadora]]);
                
                
                $captura = $this->cad_model->getCaptura([['id_cadastro', $dados_pessoais->id_cadastro],['origem_captura', $data['empreendimento']->uuid_empreendimento]]);
                
                $dados_pessoais_final = array_merge((array)$captura,(array)$dados_pessoais);
                
                $data['dados_pessoais'] = (object)$dados_pessoais_final;
                
                $data['id_cadastro'] = $this->cad_model->getCadastroByEmail($data['dados_pessoais']->email)->id_cadastro;
                
               
            }
            
            $data['parceiro'] = $this->admin_model->getParceiro(['id_parceiro',$data['dados_pessoais']->id_parceiro]);
			if($data['parceiro'] != null)
			{
			    if($data['parceiro']->tipo_atendimento == 1)
			        $data['boxAgendamento'] = false;
			}
            //$data['negociacao'] = FALSE;
            
            if($data['negociacao'] == FALSE){
                $email = $this->cad_model->get_cadastro([],$data['agenda']->participantes->id_interessado)->email;
            }else{
                $email = $data['dados_pessoais']->email;
            }
            
            if($email != NULL){
                $capturas = $this->admin_model->getCapturas([['email', $email]]);
                $result['nome']      = '';
                $result['email']     = '';
                $result['telefone']  = '';
                $capturado = (object)$result;
                foreach ($capturas as $cap)
                {
                    if($cap->nome != '')
                        $capturado->nome = $cap->nome;
                    if($cap->email != '')
                        $capturado->email = $cap->email;
                    if($cap->telefone != '')
                        $capturado->telefone  = $cap->telefone;
                }
                $data['capturas']  = $capturas;
            }
            
            $data['atendimentos'] = $this->admin_model->getAtendimentoHistorico([['a.id_rel',$data['dados_pessoais']->id_captura],['a.tb_origem','cad_captura']]);
            
            foreach($data['atendimentos'] as $atend)
                $atend->atendente =   $this->admin_model->get_cadastro([], $atend->id_user)->nome??'';
            
            $data['responsavel'] = $this->cad_model->getCadastro([['id_cadastro',$data['agenda']->id_responsavel]]);
            
            
        }
        else{
        //No caso de agendamento
            
            $num_tipo = 2;
            
            $data['fila'] = $this->admin_model->getStatusFila('id_origem = '.$id.' AND origem = 2 AND id_responsavel = '.$this->session->id_cadastro.' AND status = 1');
           
            $data['empreendimentos'] = $this->cad_model->getEmpreendimentos([['emp_status',4]]);
            
            $data['captura'] = $captura = $this->cad_model->getCaptura([['id_captura', $id]]);
            
            
            $dados_pessoais = $this->cad_model->getCadastro([['id_cadastro',$captura->id_cadastro]]);
            
            $dados_pessoais_final = array_merge((array)$captura,(array)$dados_pessoais);
                
            $data['dados_pessoais'] = (object)$dados_pessoais_final;
            
            //dd($data['dados_pessoais']);
            
            $data['id_cadastro'] = $this->cad_model->getCadastroByEmail($data['dados_pessoais']->email)->id_cadastro;
            
            $data['empreendimento'] = $this->cad_model->getEmpreendimento([['uuid_empreendimento',$data['dados_pessoais']->origem_captura]]);
            
            //----ini------AGENDAMENTOS----------
            $extract = ['participantes', 'id_interessado', $captura->id_cadastro];
            $data['agendas'] = $this->admin_model->JSON($extract)->getAgendas([['id_destino',$data['empreendimento']->id_empreendimento]]);
             if(!empty($data['agendas'])){
                $data['agendas'] = $this->trataAgenda($data['agendas']);
            }
            
            //----fim------AGENDAMENTOS----------
            
            $data['incorporadora'] = $this->cad_model->getIncorporadora([['id_incorporadora',$data['empreendimento']->id_incorporadora]]);   
            
            $data['unidade'] = $this->cad_model->getImovel(['id_imovel'=>$data['empreendimento']->id_imovel]);
            
            
            $data['parceiro'] = $this->admin_model->getParceiro(['id_parceiro',$data['dados_pessoais']->id_parceiro]);
			
			if($data['parceiro'] != null)
			{
			    if($data['parceiro']->tipo_atendimento == 1)
			        $data['boxAgendamento'] = false;
			}
            //$data['negociacao'] = FALSE;
            
            $email = $data['dados_pessoais']->email;
            
            if($email != NULL){
                $capturas = $this->admin_model->getCapturas([['email', $email]]);
                $result['nome']      = '';
                $result['email']     = '';
                $result['telefone']  = '';
                $capturado = (object)$result;
                foreach ($capturas as $cap)
                {
                    if($cap->nome != '')
                        $capturado->nome = $cap->nome;
                    if($cap->email != '')
                        $capturado->email = $cap->email;
                    if($cap->telefone != '')
                        $capturado->telefone  = $cap->telefone;
                }
                $data['capturas']  = $capturas;
            }
            
            $data['atendimentos'] = $this->admin_model->getAtendimentoHistorico([['a.id_rel',$data['dados_pessoais']->id_captura],['a.tb_origem','cad_captura']]);
            
            foreach($data['atendimentos'] as $atend)
                $atend->atendente =   $this->admin_model->get_cadastro([], $atend->id_user)->nome??''; 
                
                
        }
        //Tratamento para avaliar se já foi agendando no mesmo empreendimento a mesma dados_pessoa
        if(empty($data['agendas'])){
            $data['flag_agenda']=true;
        }
        else{
            $data['flag_agenda']=true;
            foreach ($data['agendas'] as $agendamento){
                if($agendamento->status_agenda == 0){
                    $data['flag_agenda']=false;
                    break;
                }
            }
        }
        
        //Pegar a HOUSE pelo id_parceiro
        $data['house'] = $this->admin_model->getParceiro(['id_parceiro',$data['dados_pessoais']->id_parceiro]);
        
        //FORÇA O GET NA FILA
        if(empty($data['fila'])){
            $data['fila'] = $this->admin_model->getStatusFila('id_origem = '.$id.' AND origem = '.$num_tipo/*.' AND id_responsavel = '.$this->session->id_cadastro*/);
        }
        
        //PEGANDO OS INTERESSES PRA SETAR NA VIEW
        $interesses = $this->cad_model->getInteresses(['id_captura', $id]);
        $captura_interesse = $this->cad_model->getCaptura([['id_captura', $id]]);
        $interesse_painel = $this->cad_model->getInteresses([['id_captura', $id],['interesse_painel_cs',1]]);
        
        if(empty($interesse_painel)){
            $data['sem_interesse']=1;
            $interesse_painel = [];
        }
        else{
            $data['sem_interesse']=0;
            $interesse_painel = $interesse_painel[0];
        }
        
        $interesse = array_merge((array)$interesse_painel,(array)$captura_interesse);
        
        $data['interesse'] = $interesse;
        
        //PEGANDO OS INTERESSES PARA O HISTÓRICO DE INTERESSES
        $hist_interesses=[];
        foreach($interesses as $inter){
            if($inter != []){
                $inter->bairros = $this->cad_model->getBairrosInteresse([['id_interesse', $inter->id_interesse]]);
                $inter->tipo_emp = $this->cad_model->getTiposEmpInteresse([['id_interesse', $inter->id_interesse]]);
                $hist_interesses[] = $inter;
            }
        }
        $data['interesses']=$hist_interesses;
        
        $uuids = [];
        
        foreach($data['empreendimentos'] as $emp){
            $uuids[] = $emp->uuid_empreendimento;
        }
        
        $data['outros_atendimentos'] = [];
        foreach($data['capturas'] as $capt){
            if(array_search($capt->origem_captura,$uuids) === FALSE){
                continue;
            }else{
                $chave = array_search($capt->origem_captura,$uuids);
                $data['outros_atendimentos'][] = ['id_captura' => $capt->id_captura, 'name_emp' => $data['empreendimentos'][$chave]->emp_nome_fantasia];
            }
        }
        
        //PEGANDO AS DESCRIÇÕES CORRESPONDENDES AO CLIENTE
        $descricoes = $this->cad_model->getAtendDescricoes([['id_fila',$data['fila']->id_fila]]);
        
        if(empty($descricoes)){
            $data['descricoes'] = [];
        }
        else{
            foreach ($descricoes as $d){
                $d->atendente = $this->cad_model->getCadastro([['id_cadastro',$data['fila']->id_responsavel]])->nome;
            }
            $data['descricoes']=$descricoes;
        }
        
        
        //PEGANDO AS AVALIAÇÕES PARA O HISTÓRICO DE AVALIAÇÕES
        $data['avaliacoes'] = $this->cad_model->getCapturas([['origem_captura','avaliacao'],['email',$data['dados_pessoais']->email]]);
        
        
        //PEGAR O INTERESSE PRINCIPAL
        $wInteresseP[] = ['principal',1];
		$wInteresseP[] = ['id_cadastro',$data['id_cadastro']];
		$interesseP =  $this->cad_model->getInteresse($wInteresseP);
		
	    if(!empty($interesseP)){
	        $interesseP->bairros = $this->cad_model->getBairrosInteresse([['id_interesse', $interesseP->id_interesse]]);
	        $interesseP->tipo_emp = $this->cad_model->getTiposEmpInteresse([['id_interesse', $interesseP->id_interesse]]);
	    }
		
		$data['interesseP'] = $interesseP??[];
		
		$bairros = [];
		foreach(($data['interesseP']->bairros??[]) as $b){
		    $bairros[] = $b->bairro;
		}
		
		$data['interesseP_bairros'] = $bairros;
		
		$tipo_emp = [];
		foreach(($data['interesseP']->tipo_emp??[]) as $t){
		    $tipo_emp[] = $t->tipo_emp;
		}
		
		$data['interesseP_tipo_emp'] = $tipo_emp;
        
        
		Assets::add_css(array(
            '../comdono/plugins/datetimepicker/css/bootstrap-datetimepicker.min',
            '../comdono/plugins/daterangepicker/css/daterangepicker',
            '../painel/plugins/select2-4.1.0-beta.1/select2.min',
        ));
        
        Assets::add_js(array(
            '../comdono/plugins/datetimepicker/js/moment',
            '../comdono/plugins/datetimepicker/js/bootstrap-datetimepicker.min',
            '../comdono/plugins/datetimepicker/js/locale',
            '../comdono/plugins/daterangepicker/js/daterangepicker',
            '../painel/plugins/select2-4.1.0-beta.1/select2.min',
            
        ));
        
        Assets::add_module_css('atendimento', array(
            'atendimento'
        ));
        
        $this->dataTables();
		
        Assets::add_module_js('atendimento', array(
            'atendimento',
            'atendimento_incorporadora',
            'date_time',
            'atendimento_desistencias',
            'atendimento_geral',
        ));
        
        Template::set($data);
        Template::set_view('atendimento/atend_incorporadora_view');
        Template::render();
        
        
    }
    
    //===================== PAGINA DE ATENDIMENTO 2 ==============================
    function atendimento2($tipo = NULL, $id = NULL)
    {
        
        $data['module'] = $module = Menu_lib::getModuleByNickname($this->module);
        $this->breadcrumb("<i class='nav-icon $module->icon'></i> $module->name");
        
        if($tipo == 'desistencia'){
            
            $data['fila'] = $this->admin_model->getStatusFila('id_origem = '.$id.' AND origem = 1 AND id_responsavel = '.$this->session->id_cadastro.' AND status = 1');
            
            $data['agenda'] = $this->cad_model->getAgenda([['id_agenda',$id]]);
            
            $data['visita'] = $this->cad_model->getVisita([['id_agenda',$id]]);
            
            $data['negociacao'] = $this->cad_model->getNegociacao([['id_visita',$data['visita']->id_visita]]);
            
            //GET EM TODAS AGENDAS, gambirra do igual
            $data['agendas'] = $this->cad_model->getAgendas([['JSON_UNQUOTE(JSON_EXTRACT(participantes, "$.id_interessado")) =',$data['agenda']->participantes->id_interessado]]);
            
            //GET EM TODOS EMPREENDIMENTOS
            $data['empreendimentos'] = $this->cad_model->getEmpreendimentos([['emp_status',4]]);
            
            //Chegou a negociacao
            if($data['negociacao'] != NULL){
                
                $id_origem = $this->admin_model->get_Negociacao_origem($data['negociacao']->id_negociacao);
                
                $data['dados_pessoais'] = $this->admin_model->get_Negociacao($data['negociacao']->id_negociacao, $id_origem);
                
                $data['pre_reserva'] = $this->cad_model->getPreReserva([['id_visita',$data['visita']->id_visita]]);
                
                $data['empreendimento'] = $this->cad_model->getEmpreendimento([['id_empreendimento',$data['negociacao']->id_empreendimento]]);
                
                $data['unidade'] = $this->cad_model->getImovel(['id_imovel'=>$data['empreendimento']->id_imovel]);
                
                $data['vendedor'] = $this->cad_model->getCadastro([['id_cadastro',$data['negociacao']->id_vendedor]]);
                
                $data['incorporadora'] = $this->cad_model->getIncorporadora([['id_incorporadora',$data['empreendimento']->id_incorporadora]]);
                
                $data['id_cadastro'] = $this->cad_model->getCadastroByEmail($data['dados_pessoais']->email)->id_cadastro;
                
            }
            else{
                
                $dados_pessoais = $this->cad_model->getCadastro([['id_cadastro',$data['agenda']->participantes->id_interessado]]);
                
                $data['empreendimento'] = $this->cad_model->getEmpreendimento([['id_empreendimento',$data['agenda']->id_destino]]);
                
                $data['unidade'] = $this->cad_model->getImovel(['id_imovel'=>$data['empreendimento']->id_imovel]);
                
                $data['vendedor'] = $this->cad_model->getCadastro([['id_cadastro',$data['agenda']->participantes->id_responsavel]]);
                
                $data['incorporadora'] = $this->cad_model->getIncorporadora([['id_incorporadora',$data['empreendimento']->id_incorporadora]]);
                
                
                $captura = $this->cad_model->getCaptura([['id_cadastro', $dados_pessoais->id_cadastro],['origem_captura', $data['empreendimento']->uuid_empreendimento]]);
                
                $dados_pessoais_final = array_merge((array)$captura,(array)$dados_pessoais);
                
                $data['dados_pessoais'] = (object)$dados_pessoais_final;
                
                $data['id_cadastro'] = $this->cad_model->getCadastroByEmail($data['dados_pessoais']->email)->id_cadastro;
                
                
            }
            
            $data['parceiro'] = $this->admin_model->getParceiro(['id_parceiro',$data['dados_pessoais']->id_parceiro]);
			if($data['parceiro'] != null)
			{
			    if($data['parceiro']->tipo_atendimento == 1)
			        $data['boxAgendamento'] = false;
			}
            //$data['negociacao'] = FALSE;
            
            if($data['negociacao'] == FALSE){
                $email = $this->cad_model->get_cadastro([],$data['agenda']->participantes->id_interessado)->email;
            }else{
                $email = $data['dados_pessoais']->email;
            }
            
            if($email != NULL){
                $capturas = $this->admin_model->getCapturas([['email', $email]]);
                $result['nome']      = '';
                $result['email']     = '';
                $result['telefone']  = '';
                $capturado = (object)$result;
                foreach ($capturas as $cap)
                {
                    if($cap->nome != '')
                        $capturado->nome = $cap->nome;
                    if($cap->email != '')
                        $capturado->email = $cap->email;
                    if($cap->telefone != '')
                        $capturado->telefone  = $cap->telefone;
                }
                $data['capturas']  = $capturas;
            }
            
            $data['atendimentos'] = $this->admin_model->getAtendimentoHistorico([['a.id_rel',$data['dados_pessoais']->id_captura],['a.tb_origem','cad_captura']]);
            
            foreach($data['atendimentos'] as $atend)
                $atend->atendente =   $this->admin_model->get_cadastro([], $atend->id_user)->nome??'';
            
        }
        else{
        //No caso de agendamento
            $data['fila'] = $this->admin_model->getStatusFila('id_origem = '.$id.' AND origem = 2 AND id_responsavel = '.$this->session->id_cadastro.' AND status = 1');
            
            $data['agendas'] = [];
            
            $data['empreendimentos'] = $this->cad_model->getEmpreendimentos([['emp_status',4]]);
            
            $captura = $this->cad_model->getCaptura([['id_captura', $id]]);
            
            $dados_pessoais = $this->cad_model->getCadastro([['id_cadastro',$captura->id_cadastro]]);
            
            $dados_pessoais_final = array_merge((array)$captura,(array)$dados_pessoais);
                
            $data['dados_pessoais'] = (object)$dados_pessoais_final;
            
            $data['id_cadastro'] = $this->cad_model->getCadastroByEmail($data['dados_pessoais']->email)->id_cadastro;
            
            $data['empreendimento'] = $this->cad_model->getEmpreendimento([['uuid_empreendimento',$data['dados_pessoais']->origem_captura]]);
           
            $data['incorporadora'] = $this->cad_model->getIncorporadora([['id_incorporadora',$data['empreendimento']->id_incorporadora]]);   
            
            $data['unidade'] = $this->cad_model->getImovel(['id_imovel'=>$data['empreendimento']->id_imovel]);
            
            
            $data['parceiro'] = $this->admin_model->getParceiro(['id_parceiro',$data['dados_pessoais']->id_parceiro]);
			
			if($data['parceiro'] != null)
			{
			    if($data['parceiro']->tipo_atendimento == 1)
			        $data['boxAgendamento'] = false;
			}
            //$data['negociacao'] = FALSE;
            
            $email = $data['dados_pessoais']->email;
            
            if($email != NULL){
                $capturas = $this->admin_model->getCapturas([['email', $email]]);
                $result['nome']      = '';
                $result['email']     = '';
                $result['telefone']  = '';
                $capturado = (object)$result;
                foreach ($capturas as $cap)
                {
                    if($cap->nome != '')
                        $capturado->nome = $cap->nome;
                    if($cap->email != '')
                        $capturado->email = $cap->email;
                    if($cap->telefone != '')
                        $capturado->telefone  = $cap->telefone;
                }
                $data['capturas']  = $capturas;
            }
            
            $data['atendimentos'] = $this->admin_model->getAtendimentoHistorico([['a.id_rel',$data['dados_pessoais']->id_captura],['a.tb_origem','cad_captura']]);
            
            foreach($data['atendimentos'] as $atend)
                $atend->atendente =   $this->admin_model->get_cadastro([], $atend->id_user)->nome??''; 
               
              
        }
        
		Assets::add_css(array(
            '../comdono/plugins/datetimepicker/css/bootstrap-datetimepicker.min',
            '../comdono/plugins/daterangepicker/css/daterangepicker'
        ));
        
        Assets::add_js(array(
            '../comdono/plugins/datetimepicker/js/moment',
            '../comdono/plugins/datetimepicker/js/bootstrap-datetimepicker.min',
            '../comdono/plugins/datetimepicker/js/locale',
            '../comdono/plugins/daterangepicker/js/daterangepicker'
        ));
        
        Assets::add_module_css('atendimento', array(
            'atendimento'
        ));
		
        Assets::add_module_js('atendimento', array(
            'atendimento',
            'atendimento_incorporadora',
            'date_time',
            'atendimento_desistencias',
            'atendimento_geral'
        ));
        
        Template::set($data);
        Template::set_view('atendimento/atend_incorporadora2_view');
        Template::render();
        
        
    }
    
    //===================== DASHBOARD ATENDIMENTO ==============================
    function atendimento_geral() 
    {
	    $this->ini_method('incorporadoras');
	    $data['tipo_interesse']  = $this->uri->segment(4);
		$data['id_atendimento'] = $id_atendimento  = $this->uri->segment(5);
		$data['atendimentoInicial'] = $this->admin_model->getAtendimento([['id_atendimento',$id_atendimento]]);
	
		$this->setObjetoAtendido($data);
		$this->setCasdastro($data);
		$this->setOutrosAtentimentos($data);
		$this->setInteressado($data);
		
		if($data['atendimentoInicial']->tb_origem == 'cad_captura' && $this->verificaSeEmpreendimento($data['tipo_interesse'])){
			$data['boxAgendamento'] = true;
			
			$data['empreendimento'] = $empreendimento = $this->admin_model->getEmpreendimento(['uuid_empreendimento', $data['tipo_interesse']]);
			$incorporadora = $this->admin_model->getIncorporadora(['id_incorporadora', $empreendimento->id_incorporadora]);
            $data['id_participantes'] = $incorporadora->id_responsavel;
            $data['id_destino'] = $empreendimento->id_empreendimento??0;
            
            //planos e propostas
            $data['proposta'] = $proposta = $this->cad_model->getProposta(['id_proposta',$empreendimento->id_proposta]);
            $planos_rel = json_decode($proposta->planos_rel);
            $planos = [];
            foreach ($planos_rel as $id_plano)
            {
                $planos[] = $this->cad_model->getPlano(['id_plano',$id_plano]);
            }
            $data['planos'] = $planos;
            
            //dd($data['planos']);
            //dd($data['proposta']);
		}
		
		$data['atendimentos'] = $this->admin_model->getAtendimentoHistorico([['a.id_atendimento',$id_atendimento]]);
		foreach($data['atendimentos'] as $atend)
		    $atend->atendente =   $this->admin_model->get_cadastro([], $atend->id_user)->nome??'';
    	
		//e($this->db->last_query()); die();
    	
		$data['id_user'] = $this->session->id_cadastro;
		
		
		Assets::add_css(array(
            '../comdono/plugins/datetimepicker/css/bootstrap-datetimepicker.min',
        ));
        
        Assets::add_js(array(
            '../comdono/plugins/datetimepicker/js/moment',
            '../comdono/plugins/datetimepicker/js/bootstrap-datetimepicker.min',
            '../comdono/plugins/datetimepicker/js/locale'
        ));
		
        Assets::add_module_js('atendimento', array(
            'dashboar_incorporadora',
            'atendimento',
            'date_time'
        ));
        
		Template::set($data);
        Template::set_view('atendimento/atendimento_view');
        Template::render();
    }
    
    //==================================================
    
    function verificaSeEmpreendimento($UUID)
    {
        $UUIDs = [];
        $empreendimentos = $this->admin_model->getEmpreendimentos();
        foreach ($empreendimentos  as $empreendimento)
            $UUIDs[] =  $empreendimento->uuid_empreendimento;
        return in_array($UUID, $UUIDs);   
    }
    
    function setObjetoAtendido(&$data)
    {
        $AtendimentoInicial = $data['atendimentoInicial'];
        
        $tb_origem      = $AtendimentoInicial->tb_origem;
        $id_rel         = $AtendimentoInicial->id_rel;
		$primaryKeyName = $this->admin_model->getPrimaryKey($tb_origem);
		
		$data['objetoAtendido'] = $this->admin_model->getRow($tb_origem, [$primaryKeyName, $id_rel]);
		$data['objetoAtendido']->tb_origem = $tb_origem;
    }
    
    function setCasdastro(&$data)
    {
        $objetoAtendido = $data['objetoAtendido'];
        
        $cadastro = null;
		if(($objetoAtendido->id_cadastro??false))
		    $cadastro =  $this->admin_model->getCadastro(['id_cadastro',$objetoAtendido->id_cadastro]);
		elseif(($objetoAtendido->id_cad_interessado??false))
		    $cadastro =  $this->admin_model->getCadastro(['id_cadastro',$objetoAtendido->id_cad_interessado]);
		elseif(($objetoAtendido->email??false)){
		    $cadastro =  $this->admin_model->getCadastro(['email',$objetoAtendido->email]);
		    if($cadastro == null)
		    {
		       $id = $this->admin_model->insertCadastro((array)$objetoAtendido);
		      
		       if($data['atendimentoInicial']->tb_origem == 'cad_captura' && $objetoAtendido->id_cadastro == 0)
		            $this->admin_model->updateCaptura($objetoAtendido->id_captura,['id_cadastro' => $id]);
		       $cadastro =  $this->admin_model->getCadastro(['id_cadastro',$id]);
		    }
		}
        $data['cadastro'] = $cadastro;
    }
    
    function setOutrosAtentimentos(&$data)
    {
        $id_atendimento = $data['id_atendimento'];
        $cadastro       = $data['cadastro'];
        $objetoAtendido = $data['objetoAtendido'];
        
        $email       = $cadastro->email??($objetoAtendido->email??null);
        $id_cadastro = $cadastro->id_cadastro??false;
		
		$outroAtendimentos = [];
		$data['capturas'] = $capturas = [];
		if($email??false){
		    $outroAtendimentos      = $this->admin_model->getAtendimentoHistorico([['email',$email],['a.id_atendimento !=',$id_atendimento]]);
		    $data['capturas']       = $capturas       = $this->admin_model->getCapturas(['email',$email]);
		    $atedimentosTemporarios = [];
		    foreach ($capturas as $cap)
		    {
		        $result = $this->admin_model->getAtendimentoHistorico([['email',''],['a.id_atendimento !=',$id_atendimento],['tb_origem','cad_captura'],['id_rel',$cap->id_captura]]);
		        if(!empty($result))
		            $atedimentosTemporarios[] = $result;
		    }
		    
		    $data['contatos']       = $contatos       = $this->admin_model->getContatos(['email',$email]);
            foreach ($contatos as $contato)
		    {
		        $result = $this->admin_model->getAtendimentoHistorico([['email',''],['a.id_atendimento !=',$id_atendimento],['tb_origem','cad_contato'],['id_rel',$contato->id]]);
		        if(!empty($result))
		            $atedimentosTemporarios[] = $result;
		    }
		    
		    if($id_cadastro)
		    {
		        $data['simulacoes'] = $simulacoes = $this->admin_model->getSimulacoes(['id_cad_interessado',$id_cadastro]);
		        foreach ($simulacoes as $simulacao)
    		    {
    		        $result = $this->admin_model->getAtendimentoHistorico([['email',''],['a.id_atendimento !=',$id_atendimento],['tb_origem','fnc_simulacao'],['id_rel',$simulacao->id_simulacao]]);
    		        if(!empty($result))
    		            $atedimentosTemporarios[] = $result;
    		    }
		    }
		    
		    foreach ($atedimentosTemporarios as $result)
		        $outroAtendimentos = array_merge($outroAtendimentos, $result);
		}
		foreach ($outroAtendimentos as $atend)
		{
		    $tipo_interesse = ($atend->tipo_interesse=='')?'Outros':$atend->tipo_interesse;
		    $atend->atendente =   $this->admin_model->get_cadastro([], $atend->id_user)->nome??'';
		    $outrosPorAssunto[$tipo_interesse][] = $atend;
		}
		
		$data['outrosPorAssunto'] = $outrosPorAssunto??[];
		
    }
    
    function setInteressado(&$data)
    {
		$cadastro       = $data['cadastro'];
        $objetoAtendido = $data['objetoAtendido'];
		
		$data['interessado'] = (object)[];
		
		$data['interessado']->nome            = $cadastro->nome??($objetoAtendido->nome??'');
		$data['interessado']->email           = $cadastro->email??($objetoAtendido->email??'');
		$data['interessado']->telefone        = $cadastro->telefone??($objetoAtendido->telefone??'');
		$data['interessado']->cpf             = $cadastro->cpf??($objetoAtendido->cpf??'');
		$data['interessado']->data_nascimento = $cadastro->data_nascimento??($objetoAtendido->data_nascimento??'');
		$data['interessado']->comprador       = $cadastro->comprador??($objetoAtendido->comprador??'');
		$data['interessado']->vendedor        = $cadastro->vendedor??($objetoAtendido->comprador??'');
    }
    
    //===================== INCORPORADORAS ==============================
    
    function incorporadoras()
    {
        $this->ini_method();
        
        $empreendimentos = $this->admin_model->getEmpreendimentos([['contrato > ',0]]);
        $notificacoesNaoAtendindas = [];
        $notificacoesAguardandoRetorno = [];
        foreach ($empreendimentos as $emp){
            $imovel = $this->admin_model->getImovel(['a.id_imovel',$emp->id_imovel]);
            
            //0 - Cadastro incompleto, 1 - Cadastro incompleto, 2 - Aguardando moderação, 3 - Publicado, 4 - Recusado, 5 - Bloqueado, 6 - Vendido, 7 - Alugado
            if(!in_array(($imovel->status??4),[4,5])) 
            {
                $res = $this->getNotificacaoEmpreendimentoNaoAtendida($emp);
                //if($res->qnt > 0)
                    $notificacoesNaoAtendindas[] = $res;
                
                $res = $this->getNotificacaoEmpreendimentoAguardandoRetorno($emp);
                if($res->qnt > 0)
                    $notificacoesAguardandoRetorno[] = $res;
            }
            
        }
        
        $this->dataTables();
        Assets::add_module_js('atendimento', array(
            //'atendimento',
            'incorporadora'
        ));
        
        $data['capNaoAtendidas']      = $notificacoesNaoAtendindas;
        $data['capAguardandoRetorno'] = $notificacoesAguardandoRetorno;
        
        Template::set($data);
        Template::set_view('incorporadoras_view');
        Template::render();
    }
    
    private function getNotificacaoEmpreendimentoNaoAtendida($emp)
    {
        $CapturasNaoAtendidas = $this->admin_model->getNaoAtendidas('cad_captura', 'id_captura', 'getCapturas', [['origem_captura', $emp->uuid_empreendimento]]);
        return (object)[
                    'UUID'     => $emp->uuid_empreendimento,
                    'name'     => $emp->emp_nome_fantasia,
                    'qnt'      => count($CapturasNaoAtendidas),
                ];
    }
    
    private function getNotificacaoEmpreendimentoAguardandoRetorno($emp)
    {
        $CapturasAtendidas = $this->admin_model->getAguardandoRetorno('cad_captura', 'id_captura', 'getCapturas', [['origem_captura', $emp->uuid_empreendimento]]);
        return (object)[
                    'UUID'     => $emp->uuid_empreendimento,
                    'name'     => $emp->emp_nome_fantasia,
                    'qnt'      => count($CapturasAtendidas),
                ];
    }
    
    
    
    //===========FIM======= INCORPORADORAS ==============================
    

    
    function resumo()
	{
        $this->ini_method();
    
        //===============================================================================
        $naoAguardandoRetorno = [];
        $naoAtendidas = [];
        
        $whereCadsImovel = [['status', 3],['doc_perfil', 'cpf']];
        $whereSimulacoes = [['id_imovel >',0]];//,['step >=', 4]
        
        //$tb_origem, $name_id, $function_get, $where, $tipo_interesse(cad_atendimento_historico), $origem_captura(so se for da cad_captura), $name(titulo), $link
        $configAtendimento = [
                ['fnc_simulacao', 'id_simulacao', 'getSimulacoes', $whereSimulacoes, 'Financiamento',    'xxx', 'Simulações',  'administrativo/atendimento/financiamento_imovel'],
                ['cad_captura', 'email', 'getCapturas', [], 'Financiamento', 'financiamento',         'LP Financiamento', 'administrativo/atendimento/financiamento'],
                ['cad_captura', 'email', 'getCapturas', [], 'Elleven',       'interessado_elleven',   'LP Elleven', 'administrativo/atendimento/elleven'],
                
                /*['cad_captura', 'email', 'getCapturas', [], 'Liberty',       'interessado_liberty',   'LP Liberty', 'administrativo/atendimento/liberty'],
                ['cad_captura', 'email', 'getCapturas', [], 'Signature',       'interessado_signature',   'LP Signature', 'administrativo/atendimento/signature'],
                ['cad_captura', 'email', 'getCapturas', [], 'Exclusive',     'interessado_exclusive', 'LP Exclusive', 'administrativo/atendimento/exclusive'],*/
                
                ['cad_captura', 'email', 'getCapturas', [], 'Avaliação',     'avaliacao',             'LP Avaliação', 'atendimento/atendimento/avaliacao'],
                ['cad_contato', 'id', 'getContatos', [], 'Contato',    'xxx', 'Contatos',  'atendimento/atendimento/contatos'],
                /*['cad_cadastro',  'id_cadastro',  'getCadsImovel', $whereCadsImovel, 'Anunciante ativo', 'xxx', 'Anunciantes', 'administrativo/atendimento/anunciantes'],*/
        ];
        
        foreach ($configAtendimento as $dt)
        {
            $tb_origem      = $dt[0];
            $name_id        = $dt[1];
            $function_get   = $dt[2];
            $where          = $dt[3];
            $tipo_interesse = $dt[4];
            $origem_captura = $dt[5];
            $name           = $dt[6];
            $link           = $dt[7];
            
            $CapturasNaoAtendidas = $this->admin_model->getNaoAtendidas($tb_origem, $name_id, $function_get, $where, $tipo_interesse, $origem_captura);
            //if(!empty($CapturasNaoAtendidas)){
            $naoAtendidas[] = (object)[
                    'key'      => $tb_origem,
                    'name'     => $name,
                    'qnt'      => count($CapturasNaoAtendidas),
                    'link'     => $link,
                ];
            //}
             
            $CapturasAtendidas = $this->admin_model->getAguardandoRetorno($tb_origem, $name_id, $function_get, $where, $tipo_interesse, $origem_captura);
            if(!empty($CapturasAtendidas)){
                $naoAguardandoRetorno[] = (object)[
                        'key'      => $tb_origem,
                        'name'     => $name,
                        'qnt'      => count($CapturasAtendidas),
                        'link'     => $link,
                    ];
            }
        }
        //===============================================================================
        
        //===============================================================================
        $atendGeral = $this->dash_model->getAtendimentoHistorico_count();
        foreach ($atendGeral as $k=>$atend)
        {
            $w = [];
            $w[] = ['id_user', $atend->id_cadastro];
            
            $atend->dia_atual       = $this->dash_model->getCountAtual('getAtendimentoHistorico', 'data_hora', 'dia', $w);
            $atend->dia_anterior    = $this->dash_model->getCountAnterior('getAtendimentoHistorico', 'data_hora', 'dia', $w);
            
            $atend->semana_atual    = $this->dash_model->getCountAtual('getAtendimentoHistorico', 'data_hora', 'semana', $w);
            $atend->semana_anterior = $this->dash_model->getCountAnterior('getAtendimentoHistorico', 'data_hora', 'semana', $w);
            
            $atend->mes_atual       = $this->dash_model->getCountAtual('getAtendimentoHistorico', 'data_hora', 'mes', $w);
            $atend->mes_anterior    = $this->dash_model->getCountAnterior('getAtendimentoHistorico', 'data_hora', 'mes', $w);
            
            if($atend->mes_atual == 0 && $atend->mes_anterior == 0)
                unset($atendGeral[$k]);
        }
        //===============================================================================
        
        //================I N C O R P O R A D O R A S====================================================================================
        $empreendimentos = $this->admin_model->getEmpreendimentos([['contrato > ',0]]);
        foreach ($empreendimentos as $emp)
            $origens['origens'][] = ['origem_captura', $emp->uuid_empreendimento];
        $CapturasNaoAtendidas = $this->admin_model->getNaoAtendidas('cad_captura', 'id_captura', 'getCapturas', $origens);
        $naoAtendidas[] = (object)[
                    'name'     => 'Incorporadoras',
                    'qnt'      => count($CapturasNaoAtendidas),
                    'link'     => 'atendimento/atendimento/incorporadoras',
                ];
        $CapturasAtendidas = $this->admin_model->getAguardandoRetorno('cad_captura', 'id_captura', 'getCapturas', $origens);
        if(!empty($CapturasAtendidas)){
            $naoAguardandoRetorno[] = (object)[
                        'name'     => 'Incorporadoras',
                        'qnt'      => count($CapturasAtendidas),
                        'link'     => 'atendimento/atendimento/incorporadoras',
                ];
        }
        //=======FIM======I N C O R P O R A D O R A S====================================================================================
        $data['atendentes'] = $atendGeral;
        $data['naoAtendidas'] = $naoAtendidas;
        $data['naoAguardandoRetorno'] = $naoAguardandoRetorno;
        
        
        //===============================================================================
        
        $capturas = $this->admin_model->getCapturasOrderBy([['origem_captura','interessado_signature']]);
        foreach ($capturas as $cap)
        {
            $cap->atendimento = $this->admin_model->getAtendimentoHistoricoDesc([['email',$cap->email],['tipo_interesse','Signature']]);
        }
        
        $data['capturas']      = $capturas;
        $data['contLand']      = count($this->admin_model->getCapturasOrderBy([['origem_captura','interessado_signature'],['mensagem','']]));
        $data['contLandAtivo'] = count($this->admin_model->getCapturasOrderBy([['origem_captura','interessado_signature'],['mensagem',''],['status_captura',3]]));
        
        //================================================================================
        
        $this->dataTables();
        
        //var_dump( date("W"));
        
        Assets::add_js(array(
            'js/Chart.min',
        ));
        Assets::add_module_js('administrativo', array(
            'main',
            //'atendimento',
            'dashboard',
            'dashboard_atendimento'
        ));
        
        Template::set($data);
        Template::set_view('atendimento/atend_resumo_view');
        Template::render();
    }
    
    function interessado() 
    {
        $this->ini_method();
        
        $id_cadastro = $this->uri->segment(3);
        $id_captura = $this->uri->segment(4);
        
        //Cadastro/Capturas----------------------------------------------
        $cadastro = null;
        $capturas = [];
        $capturado = null;
        if($id_cadastro > 0){
            $cadastro = $this->admin_model->get_cadastro([], $id_cadastro);
            $capturas = $this->admin_model->getCapturas([['email', $cadastro->email]]);
        }
        if($id_captura > 0){
            $captura = $this->admin_model->getCaptura([['id_captura', $id_captura]]);
            if($captura != null){
                $capturas = $this->admin_model->getCapturas([['email', $captura->email]]);
                $result['nome']      = '';
                $result['email']     = '';
                $result['telefone']  = '';
                $capturado = (object)$result;
                foreach ($capturas as $cap)
                {
                    if($cap->nome != '')
                        $capturado->nome = $cap->nome;
                    if($cap->email != '')
                        $capturado->email = $cap->email;
                    if($cap->telefone != '')
                        $capturado->telefone  = $cap->telefone;
                }
            }
            if($cadastro == null && $captura != null){
                $cadastro = $this->admin_model->get_cadastro([['email', $captura->email]]);
            }
        }
        //Cadastro/Capturas----------------------------------------------
        
        
        //PESQUISAS---------------------------------------------------------
        $pesquisou = [];
        $intencoes_busca = $this->admin_model->getIntencoesBusca([['id_cadastro', $id_cadastro]]);
        foreach ($intencoes_busca as $intencao){
            
            $key = $intencao->pesquisa.$intencao->bairro.$intencao->quartos;
            
            $cont[$key][] = '';
            $pesquisou[$key] = (object)[
                    'pesquisa' => $intencao->pesquisa,
                    'bairro'  => $intencao->bairro,
                    'quartos'  => $intencao->quartos,
                    'cont'    => count($cont[$key]),
                ];
            
        }
        unset($pesquisou['']);
        //PESQUISAS---------------------------------------------------------
        
        //FAVORITOS---------------------------------------------------------
        $favoritos = $this->admin_model->get_favoritos($id_cadastro);
        foreach($favoritos as $fav)
            $where['orwhere'][] = ['a.id_imovel', $fav->id_imovel];
        $where[] = ['a.status', 3];
        $imoveisFavoritos = empty($favoritos)?[]:$this->conta_model->getImoveis($where,[],false);
        //FAVORITOS---------------------------------------------------------
        
        
       
        $imoveis = [];
        $negociacoes_compras = [];
        if($cadastro != null){
            
            //I M O V E I S ---------------------------------------------------------
            $wim[] = ['a.id_cadastro', $id_cadastro];
            $wim[] = ['id_imovel_rel', 0];
            $wim[] = [['a.lixeira <', 2],[['a.lancamento','Sim'],['a.lixeira <', 3]]];
            $imoveis = $this->admin_model->getImoveis($wim);
            //I M O V E I S ---------------------------------------------------------
            
            //N e g o c i a c o e s _ c o m p r a s---------------------------------------------------------
            $this->load->model("comdono/busca_model");
            $this->load->model("minha_conta/chat_model");
            $n_compras = $this->chat_model->getChat([['id_interessado',$id_cadastro]]);
            
            foreach($n_compras as $id_imovel=>$imovel) {
                foreach($imovel->chats as $id_chat=>$chat) {
                    $chat->imovel = $imovel;
                    $negociacoes_compras[$id_chat] = $chat;
                }
            }
            //N e g o c i a c o e s _ c o m p r a s---------------------------------------------------------
            
        }
       
       
       
        //A t e n d i m e n t o s---------------------------------------------------------
        $atendimentos =[];
        $atendimento = $this->admin_model->getAtendimento([['email' ,$cadastro->email??$captura->email]]);
        if($atendimento != null)
            $atendimentos = $this->admin_model->getHistoricoAtendimento([['id_atendimento', $atendimento->id_atendimento]]);
        //A t e n d i m e n t o s---------------------------------------------------------
        
        //Capturas landingpages---------------------------------------------------------
        
        /*if($id_captura > 0){
            $captura = $this->admin_model->getCaptura([['id_captura', $id_captura]]);
            if($captura != null){
                $capturas = $this->admin_model->getCapturas([['email', $captura->email]]);
                $result['nome']      = '';
                $result['email']     = '';
                $result['telefone']  = '';
                $capturado = (object)$result;
                foreach ($capturas as $cap)
                {
                    if($cap->nome != '')
                        $capturado->nome = $cap->nome;
                    if($cap->email != '')
                        $capturado->email = $cap->email;
                    if($cap->telefone != '')
                        $capturado->telefone  = $cap->telefone;
                }
            }
            if($cadastro == null && $captura != null){
                $cadastro = $this->admin_model->get_cadastro([['email', $captura->email]]);
            }
        }*/
        
        
        
        /*$origens =['financiamento','interessado_elleven','avaliacao','avaliacao_cep_nao'];
        $atendimento = $this->admin_model->getAtendimento([['email' ,$cadastro->email??$captura->email]]);
        if($atendimento != null)
            $atendimentos = $this->admin_model->getHistoricoAtendimento([['id_atendimento', $atendimento->id_atendimento]]);*/
            
            
            
        //Capturas landingpages---------------------------------------------------------
        
        
        //$this->chat_model->getChat([['id_interessado',$this->session->id_cadastro]]);
        
        $data['cadastro']              = $cadastro;
        $data['capturas']              = $capturas;
        $data['capturado']             = $capturado;
        $data['pesquisou']             = $pesquisou;
        $data['favoritos']             = $imoveisFavoritos;
        
        $data['financiamentos']        = [];
        $data['negociacoes_compras']   = $negociacoes_compras;
       
        $data['imoveis']               = $imoveis;
        $data['negociacoes_vendas']    = [];
        
        $data['atendimentos']          = $atendimentos;
        
        //`id_intencao`, `id_cadastro`, `clique`, `cont_result`, `result`, `pesquisa`, `bairro`, `tipo`, `quartos`, `valor`, `metro_quadrado`, `id_lancamento`, `tipo_busca`, `data_hora_busca`, `timestemp_intencao`, `intencao`
    
        
        Assets::add_css(array(
            '../comdono/plugins/blueimp/css/jquery.fileupload',
            '../comdono/plugins/blueimp/css/jquery.fileupload-ui',
            '../comdono/plugins/blueimp/css/blueimp-gallery.min',
            //'../comdono/plugins/blueimp/css/custom',
            '../comdono/plugins/unitegallery/css/unite-gallery',
            '../comdono/plugins/unitegallery/css/ug-theme-default',
            
            '../comdono/plugins/dataTables/css/dataTables.bootstrap4.min',
            
            //'../painel/plugins/select2-4.0.3/select2.min'
            '../painel/plugins/select2-4.1.0-beta.1/select2.min',
        ));
        
        Assets::add_js(array(
            '../comdono/plugins/blueimp/js/jquery.ui.widget',
            '../comdono/plugins/blueimp/js/tmpl.min',
            '../comdono/plugins/blueimp/js/load-image.all.min',
            '../comdono/plugins/blueimp/js/canvas-to-blob.min',
            '../comdono/plugins/blueimp/js/blueimp-gallery.min',
            '../comdono/plugins/blueimp/js/jquery.blueimp-gallery.min',
            '../comdono/plugins/blueimp/js/jquery.iframe-transport',
            '../comdono/plugins/blueimp/js/jquery.fileupload',
            '../comdono/plugins/blueimp/js/jquery.fileupload-process',
            '../comdono/plugins/blueimp/js/jquery.fileupload-image',
            '../comdono/plugins/blueimp/js/jquery.fileupload-validate',
            '../comdono/plugins/blueimp/js/jquery.fileupload-ui',
            '../comdono/plugins/unitegallery/js/unitegallery.min',
            '../comdono/plugins/unitegallery/js/ug-theme-default',
            '../comdono/plugins/unitegallery/js/imovel',
            
            '../comdono/plugins/dataTables/js/jquery.dataTables.min',
            '../comdono/plugins/dataTables/js/dataTables.bootstrap4.min',
            '../comdono/plugins/dataTables/js/config',
        
            //'../painel/plugins/select2-4.0.3/select2',
            '../painel/plugins/select2-4.1.0-beta.1/select2.min',
            
            
        ));
        
        Assets::add_module_js('administrativo', [
            'perfil'
        ]);
        
        Assets::add_module_js('atendimento', array(
            'script_select2',
            'atendimento',
        ));
        
	    Template::set($data);
		Template::set_view('atendimento/perfil_view');
		Template::render();
    }
    
    
    
    //== E X E M P L O S   E   L I  X O ===========================================================================================
    
    function EXEMPLOanunciantes()
	{
        $this->ini_method();
        //$result = [];
        
        $w[] = ['status =', 3];
        $w[] = ['doc_perfil', 'cpf'];
        
        $anunciantes = $this->admin_model->getCadsImovel($w);
        
        $data['anunciantesProximoContato'] = [];
        $data['anunciantesFinalizados'] = [];
        foreach ($anunciantes as $k=>$anunciante)
        {
            $w['id'] = ['id_cadastro',$anunciante->id_cadastro];
            $anunciante->imoveis = $this->dash_model->getImoveis($w);
            $anunciante->atendimento  = $this->admin_model->getAtendimentoHistoricoDesc([['id_rel',$anunciante->id_cadastro],['tb_origem', 'cad_cadastro']]);
            
            if(!empty($anunciante->atendimento))
            {
                $proximo_contato = end($anunciante->atendimento)->proximo_contato;
                if($proximo_contato == 0 || $proximo_contato == '0000-00-00 00:00:00')
                {
                    $data['anunciantesFinalizados'][] = $anunciante;
                }
                else
                {
                    $data['anunciantesProximoContato'][] = $anunciante;
                }
                unset($anunciantes[$k]);
            }
            
        }
        
        $this->dataTables();
        
        Assets::add_module_js('administrativo', array(
            'main',
            'atendimento',
            'anunciantes'
        ));
        
        $data['anunciantes'] = $anunciantes;
        
        Template::set($data);
        Template::set_view('administrativo/anunciantes_view');
        Template::render();
		    
    }
    
    function index2()
	{
        $this->ini_method();
        
        $capturas = $this->admin_model->getCapturasOrderBy([['origem_captura','interessado_signature']]);
        foreach ($capturas as $cap)
        {
            $cap->atendimento = $this->admin_model->getAtendimentoHistoricoDesc([['email',$cap->email],['tipo_interesse','Signature']]);
        }
        
        $data['capturas']      = $capturas;
        $data['contLand']      = count($this->admin_model->getCapturasOrderBy([['origem_captura','interessado_signature'],['mensagem','']]));
        $data['contLandAtivo'] = count($this->admin_model->getCapturasOrderBy([['origem_captura','interessado_signature'],['mensagem',''],['status_captura',3]]));
        
        
        $this->dataTables();
        
        Assets::add_module_js('administrativo', array(
            'atendimento',
            'main'
        ));
        
        Template::set($data);
        Template::set_view('atendimento/atend_resumo_view');
        Template::render();
    }
    
    public function interessado2() 
    {
        $this->ini_method();
		    
	    $data['tipo_interesse']  = $this->uri->segment(3);
		$id_antendimento  = $this->uri->segment(4);
		$data['interessado'] = $this->admin_model->getAtendimento([['id_atendimento',$id_antendimento]]);
		
		$atendimentos = $this->admin_model->getAtendimentoHistorico([['a.id_atendimento',$id_antendimento]]);
		
		foreach($atendimentos as $atend)
		{
		    $atend->atendente =   $this->admin_model->get_cadastro([], $atend->id_user)->nome??'';
		}
		
		
		$data['atendimentos'] = $atendimentos;
		$data['state'] = 'add';
		
		
		$data['id_bug'] = $id_antendimento;
		$data['id_atendimento'] = $id_antendimento;
		$data['id_user'] = $this->session->id_cadastro;
		$data['data_hora'] = date("Y-m-d H:i:s");
		
		
		Assets::add_module_js('comdono', array(
		    'main'
		    ));
        Assets::add_module_js('administrativo', array(
            'atendimento',
        ));
        
		Template::set($data);
        Template::set_view('atendimento/atend_interessado_view');
        Template::render();
    }
	
	public function dataTables(){
	    Assets::add_css(array(
            '../comdono/plugins/dataTables/css/dataTables.bootstrap4.min',
        ));
        
        Assets::add_js(array(
            '../comdono/plugins/dataTables/js/jquery.dataTables.min',
            '../comdono/plugins/dataTables/js/dataTables.bootstrap4.min',
            '../comdono/plugins/dataTables/js/dataTables.buttons.min.js',
            '../comdono/plugins/dataTables/js/buttons.flash.min.js',
            '../comdono/plugins/dataTables/js/jszip.min.js',
            '../comdono/plugins/dataTables/js/vfs_fonts.js',
            '../comdono/plugins/dataTables/js/buttons.html5.min.js',
            '../comdono/plugins/dataTables/js/config',
        ));
	}
	
	//Funcao para traduzir o dia da semana e pegar o nome do responsavel do atendimento
	private function trataAgenda($data){
	    //$data['responsavel'] = $this->cad_model->getCadastro([['id_cadastro',$data['agenda']->id_responsavel]]);
	    foreach($data as $dat){
	        
	        $dat->responsavel = $this->cad_model->getCadastro([['id_cadastro',$dat->id_responsavel]])->nome;
	        $dia = $dat->data_hora_agendamento;
	        $dia = date("l", strtotime($dia));
	        switch($dia){
                case 'Sunday':
                    $dia = 'Domingo';
                    break;
                case 'Monday':
                    $dia = 'Segunda-Feira';
                    break;
                case 'Tuesday':
                    $dia = 'Terça-Feira';
                    break;
                case 'Wednesday':
                    $dia = 'Quarta-Feira';
                    break;
                case 'Thursday':
                    $dia = 'Quinta-Feira';
                    break;
                case 'Friday':
                    $dia = 'Sexta-Feira';
                    break;
                case 'Saturday':
                    $dia = 'Sábado';
                    break;
            }
            $dat->data_dia_semana=$dia;
	    }
	    return $data;
	}
    
    
    
   
   
   
   
   
   
   
   
   
   
   
   
   
   
   
   
   
   
	
    
}