<!-- Inicio -->

<?php $prod = base_url() == 'https://dev.comdono.com/' ? '' : 'style="display:none;"'; ?>

<div class="card bg-light">
    <div class="card-header">
        <div class="d-flex justify-content-between">
            <span class="h5 my-auto">
                <?php e($empreendimento->emp_nome_fantasia) ?>
            </span>
            <div class="buttonss">
                <!-- <button class=" btn btn-primary mr-2" type="button" data-toggle="modal" data-target="#transferAtend" <?php e($prod); ?>>Transferir</button> -->
                <button class=" btn btn-secondary mr-2" type="button" data-toggle="modal" data-target="#prorrogaAtend" >Adiar atendimento</button>
                <button class=" btn btn-danger" type="button" data-toggle="modal" data-target="#concluirAtend" >Concluir atendimento</button>
            </div>
            <div class="d-flex">
                  <div class="gravacao" style="display:none; font-size: 0.6rem;">
                      <div class="d-flex d-flex align-items-center mr-3">
                        <p class="my-auto">Gravando <i class="fa fa-circle" aria-hidden="true" style="color:red; margin:0;"></i></p>
                        <span id="hour">00</span>:<span id="minute">00</span>:<span id="second">00</span><span id="millisecond" style="display:none">000</span>                                              
                      </div>
                  </div>
                  <!--<br />
                  <button type="button" name="start">start</button>
                  <button type="button" name="pause">pause</button>
                  <button type="button" name="reset">reset</button>-->
                <div <?php e($prod); ?>>
                    <button class="btn  btn-success btn-sm float-right btn-ligar" data-id_cadastro="<?php e($dados_pessoais->id_cadastro); ?>" data-id_responsavel="<?php e($fila->id_responsavel); ?>" type="button"><i class="fa fa-phone mr-2" aria-hidden="true"></i>Ligar</button>
                    <button class="btn  btn-danger btn-sm float-right btn-desligar" data-id_cadastro="<?php e($dados_pessoais->telefone); ?>" type="button" style="display:none;"><i class="fa fa-phone mr-2" aria-hidden="true"></i>Desligar</button>
                </div>
            </div>
        </div>
    </div>
    <div class="card-body">
            <!-- Atendimento -->
            <div class="row">
                <div class="col-lg-5">
                    <!--Dados do lead-->
                    <div class="card">
                        <div class="card-body">
                            <!--Dados-->
                            <div class="d-flex text-muted mb-4">
                                <img src="https://cdn.pixabay.com/photo/2016/08/08/09/17/avatar-1577909_1280.png" class="rounded img-fluid" style="width: 85px; height: 85px; object-fit: cover;" alt="...">
                                <div class="ml-3">
                                    <div>
                                        <b>Nome:</b> <?php e($dados_pessoais->nome); ?>
                                    </div>
                                    <div>
                                        <b>CPF:</b> <?php e($dados_pessoais->cpf); ?>
                                    </div>
                                    <div>
                                        <b>Email:</b> <?php e($dados_pessoais->email); ?>
                                    </div>
                                    <div>
                                        <b>Telefone:</b> 61 ****-****
                                    </div>
                                </div>
                            </div>
                            <!--Cartão VIP-->
                            <div class="card bg-light text-muted">
                                <div class="card-header">
                                    <div class="d-flex justify-content-between">
                                        <span>Cartão VIP: <span class="text-primary">Elleven</span></span>
                                        <span class="text-success">Ativo</span>
                                    </div>
                                </div>
                                <div class="card-body">
                                    <ul class="list-unstyled mb-0">
                                      <li><b>Unidade:</b> <?php e($pre_reserva->unidade??'1'); ?></li>
                                      <li><b>Incorporadora:</b> <?php e($incorporadora->incorporadora??''); ?></li>
                                      <li><b>Valor:</b> <?php e(money($pre_reserva->valor_total??'0.00')); ?></li>
                                      <li><b>Data de ativação:</b> 22/02/2020 às 15:30</li>
                                    </ul>
                                </div>
                            </div>
                            <!--Acompanhamento-->
                            <div class="card text-muted mb-0">
                                <div class="card-body">
                                    <div class="card-step">
                                        <div class="row">
                                            <div class="col-md-12">
                                                <div id="progresscard">
                                                    <!-- progressbar -->
                                                    <ul id="progressbar">
                                                        <li class="active" id="account"><strong>Captura</strong></li>
                                                        <li id="personal"><strong>Agendamento</strong></li>
                                                        <li id="payment"><strong>Reserva</strong></li>
                                                        <li id="confirm"><strong>Conquista</strong></li>
                                                    </ul> 
                                                    <!-- fieldsets -->
<!--                                                     <fieldset>
    <p>Leverage agile frameworks to provide a robust synopsis for high level overviews. Iterative approaches to corporate strategy foster collaborative thinking to further the overall value proposition. Organically grow the holistic world view of disruptive innovation via workplace diversity and empowerment.</p>
    <button name="next" class="btn btn-primary next float-right" value="Next Step">Próxmo</button>
</fieldset>
<fieldset>
    <p>Leverage agile frameworks to provide a robust synopsis for high level overviews. Iterative approaches to corporate strategy foster collaborative thinking to further the overall value proposition. Organically grow the holistic world view of disruptive innovation via workplace diversity and empowerment.</p>
    <button name="previous" class="btn btn-secondary previous float-left" value="Previous">Anterior</button>
    <button name="next" class="btn btn-primary next float-right" value="Next Step">Próxmo</button>
</fieldset>
<fieldset>
    <p>Bring to the table win-win survival strategies to ensure proactive domination. At the end of the day, going forward</p>
    <button name="previous" class="btn btn-secondary  previous float-left" value="Previous">Anterior</button>
    <button name="next" class="btn btn-primary next float-right" value="Next Step">Próxmo</button>
</fieldset>
<fieldset>
    <p>O usuário já efetuou a compra do imóvel!</p>
    <span class="text-success">Conquista realizada</span>
</fieldset> -->
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!--Ações Atendimento-->
                    <div class="list-group atend-acoes mb-4">
                      <a href="#" class="list-group-item list-group-item-action" type="button" data-toggle="modal" data-target="#cadastroContaComdono" <?php e($id_cadastro == '' ? '' : 'disabled' );?> <?php e($id_cadastro == '' ? 'title="Criar conta"' : 'title="Já possui conta"' );?>>Criar conta Comdono</a>
                      <a href="#" class="list-group-item list-group-item-action" type="button"  data-toggle="modal" data-target="#cartaovipNovo" >Novo Cartão VIP</a>
                      <a href="#" class="list-group-item list-group-item-action" type="button"  data-toggle="modal" data-target="#enviarInfo" >Enviar Informações</a>
                      <a href="#" class="list-group-item list-group-item-action" type="button" <?php e($prod); ?>>Avaliação do Imóvel</a>
                      <a href="#" class="list-group-item list-group-item-action" type="button" <?php e($prod); ?>>Anúncio do Imóvel</a>
                      <a href="#" class="list-group-item list-group-item-action" type="button" data-toggle="modal" data-target="#interesseModal" <?php e($prod); ?>>Anúncio de Interesse</a>
                      <a href="#" class="list-group-item list-group-item-action" type="button" <?php e($prod); ?>>Crédito Imobiliário</a>
                      

                    </div>
                </div>
                <div class="col-lg-7">
                    
                    <!--Informações de Atendimento do Lead-->
                    <div class="card">
                        <div class="card-header">
                            <div class="d-flex justify-content-between">
                                <span class="my-auto">Informações do Atendimento</span>
                                <span class="my-auto">
                                    <button type="button" class="btn btn-sm btn-secondary">Editar</button>
                                    <button type="button" class="btn btn-sm btn-success btn-save-interesse">Salvar</button>
                                </span>
                            </div>
                        </div>
                        <div class="card-body text-muted">
                            <form id="form-interesse">
                                <input type="hidden" name="id_captura" value="<?php e($dados_pessoais->id_captura); ?>">
                                <div class="row">
                                    <div class="col-sm-12">
                                        <div class="form-group row">
                                            <div class="col-6">
                                                <label for="interesse1">Qual momento do cliente?</label>
                                                <select class="form-control atendForm" id="interesse1" name="tipo_interesse">
                                                  <option value="compra">Comprar</option>
                                                  <option value="comprar e vender">Comprar e vender</option>
                                                  <option value="investir">Desistir para aluguel</option>
                                                  <option value="permultar">Permultar</option>
                                                  <option value="pesquisando">Apenas pesquisando</option>
                                                </select>
                                            </div>
                                            <div class="col-6">
                                                <label for="onde1">Onde mora?</label>
                                                <input class="form-control atendForm" id="onde1" type="text" name="onde_mora" placeholder="">
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <div class="col-6 ">
                                                <label for="onde2">Profissão</label>
                                                <input class="form-control atendForm" id="onde2" name="profissao" type="text" placeholder="">
                                            </div>
                                            <div class="col-6 ">
                                                <label for="onde3">Local de trabalho</label>
                                                <input class="form-control atendForm" id="onde3" name="local_trabalho" type="text" placeholder="">
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <div class="col-6 ">
                                                <label for="onde4">Estado Civil</label>
                                                <input class="form-control atendForm" id="onde4" name="estado_civil" type="text" placeholder="">
                                            </div>
                                            <div class="col-6">
                                                <label for="onde5">Possui família em Brasília?</label>
                                                <div class="form-inline">
                                                    <div class="form-check form-check-inline mr-5 atendForm">
                                                        <input class="form-check-input atendForm" id="inline-radio1" type="radio" name="possui_familia_brasilia" value="1" name="possuiFamilia">
                                                        <label class="form-check-label font-weight-normal" for="inline-radio1">Sim</label>
                                                    </div>
                                                    <div class="form-check form-check-inline mr-5 atendForm">
                                                        <input class="form-check-input atendForm" id="inline-radio2" type="radio" name="possui_familia_brasilia" value="0" name="possuiFamilia">
                                                        <label class="form-check-label font-weight-normal" for="inline-radio2">Não</label>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <div class="col-6">
                                                <label for="onde6">Tem imóveil próprio?*</label>
                                                <div class="form-inline">
                                                    <div class="form-check form-check-inline mr-5 atendForm">
                                                        <input class="form-check-input atendForm" id="inline-radio1" type="radio" name="possui_imovel" value="1" name="imovelProprio">
                                                        <label class="form-check-label font-weight-normal" for="inline-radio1">Sim</label>
                                                    </div>
                                                    <div class="form-check form-check-inline mr-5 atendForm">
                                                        <input class="form-check-input atendForm" id="inline-radio2" type="radio" name="possui_imovel" value="0" name="imovelProprio">
                                                        <label class="form-check-label font-weight-normal" for="inline-radio2">Não</label>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-6">
                                                <label for="name">Quer vender?*</label>
                                                <div class="form-inline">
                                                    <div class="form-check form-check-inline mr-5">
                                                        <input class="form-check-input atendForm" id="inline-radio1" type="radio" name="quer_vender" value="1" name="querVender">
                                                        <label class="form-check-label font-weight-normal" for="inline-radio1">Sim</label>
                                                    </div>
                                                    <div class="form-check form-check-inline mr-5">
                                                        <input class="form-check-input atendForm" id="inline-radio2" type="radio" name="quer_vender" value="0" name="querVender">
                                                        <label class="form-check-label font-weight-normal" for="inline-radio2">Não</label>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </form>
                            <div class="resultado_interesse mt-4"></div>
                        </div>
                    </div>
                    
                    <!--Card Atendimento-->
                    <div class="card">     
                        <div class="card-header">
                            <div class="d-flex justify-content-between">
                                
                                <span class="my-auto mr-2">Ligação</span>
                                
                                
                                <div class="btn-group btn-group-toggle" data-toggle="buttons">

                                  <button type="button" class="btn btn-light disabled">00:00:00</button>
                                  <button type="button" class="btn btn-secondary disabled">Mute</button>
                                  <label class="btn btn-success">
                                    <input type="radio" name="options" id="option2" autocomplete="off"><i class="nav-icon fa fa-phone"></i></input>
                                  </label>
                                  <label class="btn btn-secondary disabled">
                                    <input type="radio" name="options" id="option3" autocomplete="off"> Encerrar</input>
                                  </label>
                                </div>
                                
              
                                
                                <span class="my-auto">
                                    <button type="button" class="btn btn-sm btn-secondary">Editar</button>
                                    <button type="button" class="btn btn-sm btn-success">Salvar</button>
                                </span>
                            </div>
                        </div>
                        <div class="card-body text-muted">   
                            <div class="form">
                                <textarea class="form-control"style="resize: none;" name="descricao" id="descricao1" rows="3"></textarea>
                            </div>
                        </div>
                    </div>
                    
                    <!--Agendamentos-->
                    <div class="card mb-0">
                        <div class="card-header">
                            <div class="d-flex justify-content-between align-items-center">
                                <span>Agendamentos</span>
                                <?php if(true){ ?>
                                  <button type="button" class="btn btn-sm btn-primary float-right" data-toggle="modal" data-target="#agendaModal">Adicionar visita <i class="fa fa-plus ml-1" aria-hidden="true"></i></button>
                                <?php } ?>
                            </div>
                        </div>
                        <div class="card-body text-muted" style="max-height: 200px;overflow-y: scroll;">
                            <div class="container">
                                <?php foreach($agendas as $agenda){ ?>   
                        		    <div class="row row-striped">
                        			<div class="col-2 text-right">
                        				<h1 class="display-4"><span class="badge badge-secondary">23</span></h1>
                        			</div>
                        			<div class="col-10 mt-3">
                        				<h5 class="text-uppercase"><strong>Visita  <?php e($agenda->tipo_agendamento == '1' ? 'Presencial' : 'Virtual'); ?></strong></h5>
                        				<ul class="list-inline">
                        				    <li class="list-inline-item"><i class="fa fa-calendar-o" aria-hidden="true"></i> Segunda</li>
                        					<li class="list-inline-item"><i class="fa fa-clock-o" aria-hidden="true"></i> <?php e(substr(converte_datahora($agenda->data_hora_agendamento,1),0,-3)); ?></li>
                        					<li class="list-inline-item"><i class="fa fa-location-arrow" aria-hidden="true"></i> <?php e($agenda->id_responsavel); ?></li>
                        				</ul>
                        				
                        			</div>
                        		</div>
                        		<?php } ?>
                        	</div>
                        </div>
                    </div>
                </div>
            </div>
    </div>
</div>
<!-- Histórico -->
<div class="row">
    <div class="col-md-12 mb-5">
        <hr>
        <div class="card-body p-0">
            <ul class="nav nav-tabs" id="historico1Tab1" role="tablist">
                <li class="nav-item">
                    <a class="nav-link active" id="historico1-tab" data-toggle="tab" href="#historico1" role="tab" aria-controls="historico1" aria-selected="true">Histórico do Lead</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" id="profile-tab" data-toggle="tab" href="#profile" role="tab" aria-controls="profile" aria-selected="false">Histórico de Atendimentos</a>
                </li>
            </ul>
            <div class="tab-content" id="myTab1Content">
                <div class="tab-pane fade show active" id="historico1" role="tabpanel" aria-labelledby="historico1-tab">
                    <div class="d-none">
                        <form class="filtrar-historico-lead text-dark form-inline justify-content-end">
                            <label class="font-weight-normal mr-2" for="inputEmpreendimento">Data e Hora:</label>
                            <input type="hidden" name="email" value="<?php e($dados_pessoais->email)?>">
                            <input name="date" type="date" class="form-control" style="max-width: 150px;" placeholder="dd/mm/ano">  
                        </form> 
                        <button type="button" class="btn btn-primary my-auto btn-filtrar-historico-lead">Filtrar</button>
                    </div>
                    <hr>
                    <table class="display table table-striped table-bordered" style="width:100%">
                        <thead>
                            <tr>
                                <th>Origem captura</th>
                                <th>Data captura</th>
                                <th>Nome</th>
                                <th>E-mail</th>
                                <th>telefone</th>
                                <th>cpf</th>
                            </tr>
                        </thead>
                        <tbody id="tabela-historico-lead">
                            <?php if(!empty($capturas)){ ?>
                                <?php foreach($capturas as $captura) { ?>
                                <tr>
                                    <td><?php e($captura->origem_captura); ?></td>
                                    <td><?php e(converte_datahora($captura->datetime_captura,1)); ?></td>
                                    <td><?php e($captura->nome); ?></td>
                                    <td><?php e($captura->email); ?></td>
                                    <td><?php e($captura->telefone); ?></td>
                                    <td><?php e($captura->cpf); ?></td>
                                </tr>
                                <?php } ?>
                            <?php } ?>
                        </tbody>
                    </table> 
                </div>
                
                
                <div class="tab-pane fade" id="profile" role="tabpanel" aria-labelledby="profile-tab">
                    
                    <form class="form-inline justify-content-end d-none">
                    
                        <label class="font-weight-normal mr-2" for="inputEmpreendimento">Data e Hora:</label>
                      
                        <div class="input-group date dateTimeAgenda mr-2">
                            <div class="input-group-prepend">
                                <div class="input-group-text input-group-addon">
                                  <i class="fa fa-calendar" aria-hidden="true"></i>
                                </div>
                            </div>
                            <input type="text" class="form-control" style="max-width: 120px;"  id="dataHistorico" placeholder="dd/mm/ano">
                         </div>
                         
                         
                        <button type="submit" class="btn btn-primary my-auto">Filtrar</button>
                        
                    </form>
                    <hr>
                    <table class="table table-striped table-bordered table-responsive-xl">
                      <thead>
                        <tr>
                          <th scope="col">Data de entrada</th>
                          <th scope="col">Último Atendimento</th>
                          <th scope="col">Último Contato Meio</th>
                          <th scope="col">Próximo Atendimento</th>
                          <th scope="col">Próximo Contato Motivo</th>
                          <th scope="col">Atendente</th>
                          <th scope="col">Observação</th>
                          <th scope="col">Status</th>
                          <th scope="col">Ações</th>
                        </tr>
                      </thead>
                      <tbody>
                        <?php if(!empty($atendimentos)){ ?>
                            <?php foreach($atendimentos as $atend) { ?>
                                <tr>
                                  <td><?php e(converte_datahora($atend->data_hora,1)); ?></td>
                                  <td><?php e(converte_datahora($atend->ultimo_contato,1)); ?></td>
                                  <td><?php e($atend->ultimo_contato_tipo); ?></td>
                                  <td><?php e(converte_datahora($atend->proximo_contato,1)); ?></td>
                                  <td><?php e($atend->proximo_contato_motivo); ?></td>
                                  <td><?php e($atend->atendente); ?></td>
                                  <td><?php e($atend->observacao); ?></td>
                                  <td><?php e($atend->status_jornada); ?><span class="badge badge-success">Ativo</span></td>
                                  <td><button class="btn btn-sm btn-primary mr-1 set_leed" data-id="1034" data-toggle="modal" data-target="#atendimentoRapidoModal" data-original-title="Atendimento rápido"><i class="icon-plus"></i></button>
                                  </td>
                                </tr>
                            <?php } ?>
                        <?php } ?>
                      </tbody>
                    </table>                 
                </div>
            </div>
        </div>        
    </div>    
</div>    

<!-- Modal --> 
<div class="modal fade" id="interesseModal" tabindex="-1" role="dialog" aria-labelledby="interesseModal" aria-hidden="true">
<div class="modal-dialog modal-dialog-centered" style="max-width: 1000px;" role="document">
<div class="modal-content">
  <div class="modal-header">
    <h4 class="modal-title" id="exampleModalLabel">Anunciar Interesse</h4>
    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
      <span aria-hidden="true">&times;</span>
    </button>
  </div>
  <div class="modal-body">
    <div class="row">
        <div class="col-md-6">
            <form class="text-dark form-anunciar-interesse">
                
                <input type="hidden" name="id_captura" value="<?php e($dados_pessoais->id_captura) ?>">
                
                <div class="form-group row">
                    <div class="col-6">
                       <label for="interessadoEM">Interessado em:</label>
                        <select name="tipo_interesse" class="form-control interForm" id="interessadoEM">
                          <option value="compra">Comprar</option>
                          <option value="venda">Vender</option>
                          <option value="comprar e vender">Comprar e vender</option>
                        </select> 
                    </div>
                  <div class="col-6">
                        <label for="interesse1">Tipo de imóvel</label>
                        <?php
                        e(HBusca::getHtmlSelectTiposImovel());
                        ?>
                        <select class="form-control interForm" id="interesse1">
                            <option value="casa">Casa</option>
                            <option value="apartamento">Apartamento</option>
                            <option value="tudio">Studio</option>
                            <option>Flat</option>
                            <option>Cobertura</option>
                            <option>Duplex</option>
                        </select>                           
                  </div>
                    
                </div>
                <div class="form-group row">
                    <div class="col-4">
                        <label for="interesse2">Quartos</label>
                        <select name="quartos" class="form-control interForm" id="interesse2">
                          <option>1</option>
                          <option>2</option>
                          <option>3</option>
                          <option value="4">4 ou +</option>
                        </select>
                    </div>
                    <div class="col-4">
                        <label for="interesse3" class="col-form-label">Banheiros:</label>
                        <select name="banheiros" class="form-control interForm" id="interesse3">
                          <option value="0">1</option>
                          <option>2</option>
                          <option>3</option>
                          <option value="4">4 ou +</option>
                        </select>                                
                    </div>  
                    <div class="col-4">
                        <label for="interesse4" class="col-form-label">Vagas:</label>
                        <select name="vaga" class="form-control interForm" id="interesse4">
                          <option>1</option>
                          <option>2</option>
                          <option>3</option>
                          <option value="4">4 ou +</option>
                        </select>                                    
                    </div> 
                </div>
                <div class="form-group">
                    <label for="interesse5">Bairro:</label>
                    <input name="bairro" type="text" class="form-control interForm" id="interesse5">
                </div>  
                <div class="form-group">
                    <label for="interesse6" class="col-form-label">Faixa de preço:</label>
                    <div class="row">
                        <div class="col-6 d-flex align-items-center pr-2">
                            De
                            <input name="faixa_preco_inicio" type="text" class="form-control ml-2 interForm" id="interesse6">
                        </div>
                        <div class="col-6 d-flex align-items-center pl-0">
                            até
                            <input name="faixa_preco_fim" type="text" class="form-control ml-2 interForm" id="interesse6">
                        </div>
                    </div>
                </div>
                <div class="form-group">
                    <label for="exampleFormControlTextarea1">Descrição</label>
                    <textarea name="descricao" class="form-control interForm" style="resize: none;" id="exampleFormControlTextarea1" rows="2"></textarea>
                </div>
                <button type="button" class="btn btn-block btn-outline-success salvarInter">Salvar</button>
                <div class="resultado_anunciar_interesse"></div>
                
            </form>
        </div>
        <div class="col-md-6">
            <div class="card bg-light h-100">
                <div class="card-body pb-0" id="card-interesse-sujestao">
                    <div class="card-text text-muted">
                    <h5>Sugestões de imóveis</h5>
                    </div>
                    
                </div>
                <div class="card-footer">
                    <button class="btn btn-block btn-primary" type="button">Enviar email e whatsapp</button>
                </div>
            </div> 
        </div>
    </div>  
  </div>
</div>
</div>
</div> 
<!-- Modal --> 
<div class="modal fade" id="agendaModal" tabindex="-1" role="dialog" aria-labelledby="agendaModal" aria-hidden="true">
<div class="modal-dialog modal-dialog-centered" role="document">
<div class="modal-content">
  <div class="modal-header">
    <div class="d-flex">
        <h4 class="my-auto mr-2">Agendamento de visita: </h4><h4 class="my-auto text-primary"><?php e($empreendimento->emp_nome_fantasia) ?></h4>
    </div>
    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
      <span aria-hidden="true">&times;</span>
    </button>
  </div>
  <div class="modal-body">
   <form class="add-visita text-dark">
        <div class="form-group">
            <input type="hidden" name="data_hora_agendamento"   id="data_hora_agendamento" value="">
            <input type="hidden" name="id_parceiro"      id="id_origem" value="<?php e($parceiro->id_parceiro) ?>">
            <input type="hidden" name="id_participantes[]" id="id_participantes" value="<?php e($incorporadora->id_responsavel) ?>">
            <input type="hidden" name="origem"           id="origem" value="4">
            <input type="hidden" name="id_origem"        id="id_origem" value="<?php e($dados_pessoais->id_captura) ?>">
            <input type="hidden" name="destino"          id="destino" value="1">
            <input type="hidden" name="id_destino"       id="id_destino" value="<?php e($empreendimento->id_empreendimento) ?>">
            <input type="hidden" name="id_interessado"   id="id_interessado" value="<?php e($dados_pessoais->id_cadastro) ?>">
            <label for="tipoEvento">Tipo de visita:</label>
            <select class="form-control" id="tipoEvento">
              <option>Visita virtual</option>
              <option>Visita presencial</option>
            </select>
        </div>
        <div class="form-group row">
          <div class="col-6">
            <label for="melhordia" class="col-form-label">Melhor dia:</label>
            <div id="datetimepicker"><input type="text" name="data" class="form-control"></div>
            
          </div>   
          <div class="col-6">
            <label for="melhorhora1" class="col-form-label">Melhor hora:</label>
            <div class="card-body card-scroll container-items horariosDisponiveis" style="max-height: 255px;"></div>
          </div>  
          
          <input type="hidden" name="data_hora_agendamento" value="">
          
       </div>
      <div class="form-group">
        <label for="observação1" class="col-form-label">Observação:</label>
        <textarea class="form-control" name="descricao_agenda" id="observação1"></textarea>
      </div>
      
      <div class="resultado_agendar_visita"></div>
    </form>
  </div>
  <div class="modal-footer">
    <button type="button" class="btn btn-primary btn-add-visita">Salvar agendamento</button>
  </div>
</div>
</div>
</div>
<!-- Modal --> 
<div class="modal fade" id="cartaovipNovo" tabindex="-1" role="dialog" aria-labelledby="cartaovipNovo" aria-hidden="true">
          <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
              <div class="modal-header">
                <h4 class="modal-title text-muted" id="exampleModalLabel">Cadastro de Cartão VIP</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                  <span aria-hidden="true">&times;</span>
                </button>
              </div>
              <div class="modal-body">
                <form class="text-dark form-modal-criar-cvip">
                   
                   <input type="hidden" name="id_cadastro" value="<?php e($dados_pessoais->id_cadastro) ?>"/>
                   
                    <div class="form-group row">
                        <div class="col-8">
                            <label for="nomeVIP">Nome completo:</label>
                            <input name="nome" type="text" class="form-control vipForm" value="<?php e($dados_pessoais->nome) ?>" id="nomeVIP">
                        </div>
                        <div class="col-4">
                            <label for="cpfVIP">CPF:</label>
                            <input name="cpf" type="text" class="form-control vipForm" value="<?php e($dados_pessoais->cpf) ?>" id="cpfVIP">
                        </div>
                    </div>  
                    <div class="form-group row">
                        <div class="col-7">
                            <label for="emailVIP">Email:</label>
                            <input name="email" type="text" class="form-control vipForm" value="<?php e($dados_pessoais->email) ?>" id="emailVIP">
                        </div>
                        <div class="col-5">
                            <label for="telefoneVIP">Telefone:</label>
                            <input name="telefone" type="text" class="form-control vipForm" value="<?php e($dados_pessoais->telefone) ?>" id="telefoneVIP">
                        </div>
                    </div>  
                    <div class="form-group row">
                        <div class="col-4">
                            <label for="conjugeVIP">Possui cônjuge?</label>
                            <div class="form-inline">
                                <div class="form-check form-check-inline mr-5">
                                    <input class="form-check-input vipForm" id="inline-radio1" type="radio" value="Sim" name="possui_conjuje" <?php e($dados_pessoais->possui_conjuje == 'Sim' ? 'checked' : '' );?>>
                                    <label class="form-check-label font-weight-normal" for="inline-radio1">Sim</label>
                                </div>
                                <div class="form-check form-check-inline mr-2">
                                    <input class="form-check-input vipForm" id="inline-radio2" type="radio" value="Não" name="possui_conjuje" <?php e($dados_pessoais->possui_conjuje == 'Não' ? 'checked' : '' );?>>
                                    <label class="form-check-label font-weight-normal" for="inline-radio2">Não</label>
                                </div>
                            </div>
                        </div>
    
                    </div>
                    <div class="form-group row" id="cadastra-cartao-conjuje" style="<?php e($dados_pessoais->possui_conjuje == 'Não' ? 'display: none;' : '' );?>">
                        <div class="col-8">
                            <label for="nomeconjVIP">Nome completo do cônjuge:</label>
                            <input name="nome_conjuje" type="text" class="form-control vipForm" value="<?php e($dados_pessoais->nome_conjuje) ?>" id="nomeconjVIP">                                    
                        </div>                    
                        <div class="col-6">
                            <label for="cpfconjVIP">CPF do cônjuge:</label>
                            <input name="cpf_conjuje" type="text" class="form-control vipForm" value="<?php e($dados_pessoais->cpf_conjuje) ?>" id="cpfconjVIP">
                        </div>
                        <div class="col-6">
                            <label for="telefoneconjVIP">Telefone do cônjuge:</label>
                            <input name="telefone_conjuge" type="text" class="form-control vipForm" value="<?php e($dados_pessoais->telefone_conjuge) ?>" id="telefoneconjVIP">
                        </div>
                    </div>
                    <hr>
                    <div class="form-group row">
                        <div class="col-6">
                              <div class="form-group">
                                <label for="exampleFormControlSelect1">Empreendimento escolhido:</label>
                                <select class="form-control select_emp_add_cartao" name="emp_nome_fantasia" id="exampleFormControlSelect1">
                                    <option>Selecione</option>
                                    <?php foreach($empreendimentos as $emp) { ?>
                                        <option value="<?php e($emp->id_empreendimento) ?>"><?php e($emp->emp_nome_fantasia) ?></option>
                                    <?php } ?>
                                </select>
                              </div>
                        </div>
                        <div class="col-6 result_unidades">
                            
                        </div>
                    </div>                            

                   <div class="resultado_criar_cvip"></div>
                   
                </form>
              </div>
              <div class="modal-footer">
                <button type="button" class="btn btn-block btn-outline-success btn-criar-cartao-vip">Salvar</button>
              </div>
            </div>
          </div>
        </div>
<!-- Modal --> 
<div class="modal fade" id="cadastroContaComdono" tabindex="-1" role="dialog" aria-labelledby="cadastroContaComdono" aria-hidden="true">
          <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
              <div class="modal-header">
                <h4 class="modal-title text-muted" id="exampleModalLabel">Cadastrar Conta Comdono</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                  <span aria-hidden="true">&times;</span>
                </button>
              </div>
              <div class="modal-body">
                <form class="text-dark form-modal-criar-conta-comdono">
                    
                    <div class="form-group row">
                        <div class="col-8">
                            <label for="nomeVIP">Nome completo:</label>
                            <input name="nome" type="text" class="form-control" value="">
                        </div>
                    </div>  
                    <div class="form-group row">
                        <div class="col-7">
                            <label for="emailVIP">Email:</label>
                            <input name="email" type="text" class="form-control" value="" >
                        </div>
                        <div class="col-5">
                            <label for="telefoneVIP">Telefone:</label>
                            <input name="telefone" type="text" class="form-control" value="" id="telefone_conta_comdono">
                        </div>
                    </div>  
                    
                   <div class="resultado_conta_comdono"></div>
                </form>
              </div>
              <div class="modal-footer">
                <button type="button" class="btn btn-block btn-outline-success btn-criar-conta-comdono">Cadastrar</button>
              </div>
            </div>
          </div>
        </div>            
<!-- Modal --> 
<div class="modal fade" id="cartaovipEditar" tabindex="-1" role="dialog" aria-labelledby="cartaovipNovo" aria-hidden="true">
          <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
              <div class="modal-header">
                <h4 class="modal-title text-muted" id="exampleModalLabel">Editar dados  Cartão VIP</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                  <span aria-hidden="true">&times;</span>
                </button>
              </div>
              <div class="modal-body">
                <form class="text-dark form-modal-cvip">
                    <input type="hidden" name="id_captura" value="<?php e($dados_pessoais->id_captura) ?>"/>  
                    <input type="hidden" name="id_cadastro" value="<?php e($dados_pessoais->id_cadastro) ?>"/>
                    <div class="form-group row">
                        <div class="col-8">
                            <label for="nomeVIP">Nome completo:</label>
                            <input name="nome" type="text" class="form-control" value="<?php e($dados_pessoais->nome) ?>" id="nomeVIP">
                        </div>
                        <div class="col-4">
                            <label for="cpfVIP">CPF:</label>
                            <input name="cpf" type="text" class="form-control readonly" value="<?php e($dados_pessoais->cpf) ?>" id="cpfVIP_edit" readonly>
                        </div>
                    </div>  
                    <div class="form-group row">
                        <div class="col-7">
                            <label for="emailVIP">Email:</label>
                            <input name="email" type="text" class="form-control" value="<?php e($dados_pessoais->email) ?>" id="emailVIP">
                        </div>
                        <div class="col-5">
                            <label for="telefoneVIP">Telefone:</label>
                            <input name="telefone" type="text" class="form-control" value="<?php e($dados_pessoais->telefone) ?>" id="telefoneVIP_edit">
                        </div>
                    </div>  
                    <div class="form-group row">
                        <div class="col-4">
                            <label for="conjugeVIP">Possui cônjuge?</label>
                            <div class="form-inline">
                                <div class="form-check form-check-inline mr-5">
                                    <input class="form-check-input" id="checkbox-edit-cvip" type="radio" value="Sim" name="possui_conjuje" <?php e($dados_pessoais->possui_conjuje == 'Sim' ? 'checked' : '' );?>>
                                    <label class="form-check-label font-weight-normal" for="inline-radio1">Sim</label>
                                </div>
                                <div class="form-check form-check-inline mr-2">
                                    <input class="form-check-input" id="checkbox-edit-cvip" type="radio" value="Não" name="possui_conjuje" <?php e($dados_pessoais->possui_conjuje == 'Não' ? 'checked' : '' );?>>
                                    <label class="form-check-label font-weight-normal" for="inline-radio2">Não</label>
                                </div>
                            </div>
                        </div>
                       
                        
                    </div>
                    <div class="form-group row" id="edit-cartao-conjuje" style="<?php e($dados_pessoais->possui_conjuje == 'Não' ? 'display: none;' : '' );?>">
                        <div class="col-8">
                            <label for="nomeconjVIP">Nome completo do cônjuge:</label>
                            <input name="nome_conjuje" type="text" class="form-control" value="<?php e($dados_pessoais->nome_conjuje) ?>" id="nomeconjVIP">                                    
                        </div>
                        
                        <div class="col-6">
                            <label for="cpfconjVIP">CPF do cônjuge:</label> 
                            <input name="cpf_conjuje" type="text"  class="form-control" value="<?php e($dados_pessoais->cpf_conjuje) ?>" id="cpfconjVIP_edit" readonly>
                        </div>
                        <div class="col-6">
                            <label for="telefoneconjVIP">Telefone do cônjuge:</label>
                            <input name="telefone_conjuge" type="text" class="form-control" value="<?php e($dados_pessoais->telefone_conjuge) ?>" id="telefoneconjVIP_edit">
                        </div>
                    </div>
                    <hr>
                    <div class="form-group row">
                        <div class="col-6">
                            <label for="empreVIP">Empreendimento escolhido:</label>
                            <input name="emp_nome_fantasia" type="text" class="form-control" value="<?php e($empreendimento->emp_nome_fantasia) ?>" id="empreVIP" readonly>
                        </div>
                        <div class="col-6">
                            <label for="unidadeVIP">Unidade escolhida:</label>
                            <input name="unidade" type="text" class="form-control" value="<?php e($unidade->unidade) ?>" id="unidadeVIP" readonly>
                        </div>
                    </div>                            
                    
                   <div class="resultado_cvip"></div>
                </form>
              </div>
              <div class="modal-footer">
                <button type="button" class="btn btn-block btn-outline-success btn-salvar-cartao-vip">Salvar</button>
              </div>
            </div>
          </div>
        </div>
<!-- Modal --> 
<div class="modal fade" id="concluirAtend" tabindex="-1" role="dialog" aria-labelledby="concluirAtend" aria-hidden="true">
          <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
              <div class="modal-header">
                <h4 class="modal-title" id="exampleModalLabel">Ajude-nos a melhorar o seu Dashboard!</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                  <span aria-hidden="true">&times;</span>
                </button>
              </div>
              <div class="modal-body">
                <form class="text-dark form-modal-enviar-sugestao">
                   
                    <input type="hidden" name="id_fila" value="<?php e($fila->id_fila) ?>">
                    <div class="form-group">
                        <label for="conjugeVIP">Como está sua experiência com o sistemas?</label>
                        <div class="form-inline">
                            <div class="form-check form-check-inline mr-5">
                                <input class="form-check-input" id="inline-radio1" type="radio" value="1" name="experiencia">
                                <label class="form-check-label font-weight-normal" for="inline-radio1">Boa</label>
                            </div>
                            <div class="form-check form-check-inline mr-2">
                                <input class="form-check-input" id="inline-radio2" type="radio" value="2" name="experiencia">
                                <label class="form-check-label font-weight-normal" for="inline-radio2">Ruim</label>
                            </div>
                        </div>
                    </div>
               
                    <div class="form-group">
                        <label for="descricao1">Alguma sugestão ou reclamação?</label>
                        <textarea name="sugestao" class="form-control" style="resize: none;" id="descricao1" rows="3"></textarea>
                    </div>
                   
                   <div class="resultado_enviar_sugestao"></div>
                </form>
              </div>
              <div class="modal-footer">
                    <div class="d-flex justify-content-around">
                        <div class="mx-2">
                            <button type="button" class="btn btn-block btn-primary btn-finaliza-atendimento" data-id_fila="<?php e($fila->id_fila) ?>">Finalizar Atendimento</button>
                        </div>
                        <div class="d-none">
                            <button type="button" class="btn btn-block btn-success">Próximo atendimento</button>
                        </div>
                    </div>
               
              </div>
            </div>
          </div>
        </div>
<!-- Modal --> 
<div class="modal fade" id="enviarInfo" tabindex="-1" role="dialog" aria-labelledby="concluirAtend" aria-hidden="true">
          <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
              <div class="modal-header">
                <h4 class="modal-title text-muted" id="exampleModalLabel">Enviar informações para o Lead</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                  <span aria-hidden="true">&times;</span>
                </button>
              </div>
              <div class="modal-body">
                <form class="text-dark">
                    <div class="row">
                        <div class="col-6">
                            <div class="form d-flex flex-column">
                                
                                <div class="form-group">
                                    <label for="conjugeVIP">Sobre o empreendimento</label>
                                    <select class="form-control" id="interessadoEM">
                                      <option>Elleven</option>
                                      <option>Liberty</option>
                                      <option>Exclusive</option>
                                      <option>Signature</option>
                                    </select>                                             
                                </div>

                                
                                <div class="form-check form-check-inline ">
                                    <input class="form-check-input" id="gridCheck1" type="checkbox">
                                    <label class="form-check-label font-weight-normal" for="gridCheck1">Book Digital</label>
                                </div>
                                <div class="form-check form-check-inline ">
                                    <input class="form-check-input" id="gridCheck1" type="checkbox">
                                    <label class="form-check-label font-weight-normal" for="gridCheck1">Landing page</label>
                                </div>
                                <div class="form-check form-check-inline">
                                    <input class="form-check-input" id="gridCheck1" type="checkbox">
                                    <label class="form-check-label font-weight-normal" for="gridCheck1">Localização</label>
                                </div>
                                <div class="form-check form-check-inline ">
                                    <input class="form-check-input" id="gridCheck1" type="checkbox">
                                    <label class="form-check-label font-weight-normal" for="gridCheck1">Localização - Stand de Vendas</label>
                                </div>
                                <div class="form-check form-check-inline ">
                                    <input class="form-check-input" id="gridCheck1" type="checkbox">
                                    <label class="form-check-label font-weight-normal" for="gridCheck1">Localização - Empreendimento</label>
                                </div>
                                <div class="form-check form-check-inline">
                                    <input class="form-check-input" id="gridCheck1" type="checkbox">
                                    <label class="form-check-label font-weight-normal" for="gridCheck1">Layout Personalizado</label>
                                </div>
                            </div>
                        </div>
                        <hr width = “2” size = “100”>
                        <div class="col-6">
                            <div class="form d-flex flex-column">
                                <div class="form-group mb-1">
                                    <label for="conjugeVIP">Sobre o Comdono</label>
                                </div>
                                <div class="form-check form-check-inline ">
                                    <input class="form-check-input" id="gridCheck1" type="checkbox">
                                    <label class="form-check-label font-weight-normal" for="gridCheck1">Apresentação Comdono</label>
                                </div>
                                <div class="form-check form-check-inline ">
                                    <input class="form-check-input" id="gridCheck1" type="checkbox">
                                    <label class="form-check-label font-weight-normal" for="gridCheck1">Localização Comdono</label>
                                </div>
                                <div class="form-check form-check-inline">
                                    <input class="form-check-input" id="gridCheck1" type="checkbox">
                                    <label class="form-check-label font-weight-normal" for="gridCheck1">Localização</label>
                                </div>
                                <div class="form-check form-check-inline ">
                                    <input class="form-check-input" id="gridCheck1" type="checkbox">
                                    <label class="form-check-label font-weight-normal" for="gridCheck1">Convite Comdono</label>
                                </div>
                            </div>
                        </div>
                    </div>
                    <hr>
                    <div class="form-group">
                        <div class="form-check form-check-inline mb-2">
                            <input class="form-check-input" id="gridCheck1" type="checkbox">
                            <label class="form-check-label" for="gridCheck1">Mensagem</label>
                        </div>
                        <textarea class="form-control" style="resize: none;" id="descricao1" rows="3"></textarea>
                    </div>

                </form>
              </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Fechar</button>
                    <button type="button" class="btn btn-primary">Enviar via whatsappp</button>
                    <button type="button" class="btn btn-primary">Enviar via email</button>
                </div>
               
              </div>
            </div>
          </div>
<!-- Modal --> 
<div class="modal fade" id="transferAtend"  tabindex="-1"  role="dialog" aria-labelledby="transferAtend" aria-hidden="true">
<div class="modal-dialog modal-dialog-centered" role="document">
    <div class="modal-content">
        <div class="modal-header">
            <h4 class="modal-title" id="exampleModalLabel">Transferir atendimento</h4>
            <button type="button" class="close transfForm" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
            </button>
        </div>
        <div class="modal-body">
            <form class="text-dark">
                <div class="form-group">
                    <label for="tipoTRANS" class="col-form-label">Tipo de atendimento:</label>
                    <div class="form-inline">
                        <div class="form-check form-check-inline mr-5">
                            <input class="form-check-input transfForm" id="tipoTRANSradio1" type="radio" value="option1" name="tipoTRANS">
                            <label class="form-check-label font-weight-normal" for="tipoTRANSradio1">Comdono</label>
                        </div>
                        <div class="form-check form-check-inline mr-5">
                            <input class="form-check-input transfForm" id="tipoTRANSradio2" type="radio" value="option2" name="tipoTRANS">
                            <label class="form-check-label font-weight-normal" for="tipoTRANSradio2">Correspondente</label>
                        </div>
                    </div>
                </div>
                <div class="form-group">
                    <label for="tipoTRANS2" class="col-form-label">Motivo:</label>
                    <input type="text" class="form-control transfForm" id="tipoTRANS2">
                </div>
                <div class="form-group">
                    <label for="tipoTRANS3" class="col-form-label">Message:</label>
                    <textarea class="form-control transfForm" id="tipoTRANS3"></textarea>
                </div> 
                <div class="form-group">
                    <label for="tipoTRANS" class="col-form-label">Próximo contato:</label>
                    <div class="form-inline">
                        <div class="form-check form-check-inline mr-5">
                            <input class="form-check-input transfForm" id="TRANSradio1" type="radio" value="option1" name="tipoTRANS">
                            <label class="form-check-label font-weight-normal" for="TRANSradio1">Próximo da fila</label>
                        </div>
                        <div class="form-check form-check-inline mr-5">
                            <input class="form-check-input transfForm" id="TRANSradio2" type="radio" value="option2" name="tipoTRANS">
                            <label class="form-check-label font-weight-normal" for="TRANSradio2">Personalizado</label>
                        </div>
                    </div>
                </div>
                <button type="button" class="btn btn-outline-primary btn-lg btn-block mt-3 salvarTrans">Transferir</button>
                <div class="row transConcluido">
                    <div class="col-6">
                        <button type="button" class="btn btn-outline-primary btn-block salvarTrans mt-3">Ir para o Dashboard</button>
                    </div>
                    <div class="col-6 pl-0">
                        <button type="button" onclick="window.location.href='https://dev.comdono.com/atendimento/incorporadoras';" class="btn btn-success btn-block mt-3">Próximo atendimento</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
</div>
<!-- Modal --> 
<div class="modal fade" id="prorrogaAtend"  tabindex="-1"  role="dialog" aria-labelledby="prorrogaAtend" aria-hidden="true">
<div class="modal-dialog modal-dialog-centered" role="document">
    <div class="modal-content">
        <div class="modal-header">
            <h4 class="modal-title" id="exampleModalLabel">Adiar atendimento</h4>
            <button type="button" class="close transfForm" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
            </button>
        </div>
        <div class="modal-body">
            <form class="text-dark adia-atendimento">
                <div class="form-group">
                    <label for="tipoTRANS2" class="col-form-label">Tempo:</label>
                    <select class="form-control select-prorr" name="date_prorrogado">
                        <option value="0000-00-00 00:00:00">Selecione</option>
                        <option value="<?php e(date('Y-m-d H:i:s', strtotime('+1 hour'))) ?>">1 Hora</option>
                        <option value="<?php e(date('Y-m-d 09:00:00', strtotime('+1 day'))) ?>">1 Dia</option>
                        <option value="<?php e(date('Y-m-d 09:00:00', strtotime('+1 week'))) ?>">1 Semana</option>
                        <option value="personalizado">Personalizado</option>
                    </select>
                </div>
                <input name="id_fila" type="hidden" value="<?php e($fila->id_fila); ?>">
                <div class="form-group data-perso" style="display:none;">
                    <label for="tipoTRANS3" class="col-form-label">Data Personalizada:</label>
                    <input class="form-control transfForm dt-perso" type="datetime-local" id="tipoTRANS3">
                </div>
                <div class="form-group">
                    <label for="tipoTRANS3" class="col-form-label">Message:</label>
                    <textarea class="form-control transfForm" name="motivo_prorrogacao" id="tipoTRANS3"></textarea>
                </div>
                <div class="row transConcluido">
                    <div class="col-6">
                        <button type="button" class="btn btn-outline-primary btn-block 132salvarTrans mt-3">Cancelar</button>
                    </div>
                    <div class="col-6 pl-0">
                        <button type="button" class="btn btn-success btn-block mt-3 adia-atend">Salvar</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
</div>
<!-- Modal --> 
<div class="modal fade" id="modalNvoip"  tabindex="-1"  role="dialog" aria-labelledby="prorrogaAtend" aria-hidden="true">
<div class="modal-dialog modal-dialog-centered" role="document">
    <div class="modal-content">
        <div class="modal-header">
            <h4 class="modal-title" id="exampleModalLabel">Realizar Ligação</h4>
            <button type="button" class="close transfForm" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
            </button>
        </div>
        <div class="modal-body">
            <form class="text-dark">
                <label>Nome:</label>
                <input name="nome" value="<?php e($dados_pessoais->nome); ?>" class="form-control" readonly>
                <label>Telefone:</label>
                <input name="nome" value="<?php e($dados_pessoais->telefone); ?>" class="form-control">
            </form>
            <button type="button" class="btn btn-primary"><i class="fa fa-phone fa-rotate-90" aria-hidden="true"></i> Discar</button>
            <button type="button" class="btn btn-primary"><i class="fa fa-volume-control-phone" aria-hidden="true"></i> Discar</button>
        </div>
    </div>
</div>
</div>




<!--  
<div class="row">
   SESSÃO2
   <div class="col-md-5">
       ATENDIMENTO
       <div class="card">
           <div class="card-header">
               <div class="row">
                   <div class="col-6 d-flex">
                       <h5 class="my-auto mr-2">Atendimento: </h5>
                       <span class="my-auto text-primary"><?php e($empreendimento->emp_nome_fantasia) ?></span></h5>
                   </div>
                   <div class="col-6 d-flex">
                         <div class="gravacao" style="display:none; font-size: 0.6rem;">
                           <p>Ligação Sendo Gravada <i class="fa fa-circle" aria-hidden="true" style="color:red; margin:0;"></i></p>
                           <span id="hour">00</span>:<span id="minute">00</span>:<span id="second">00</span><span id="millisecond" style="display:none">000</span>
                         </div>
                       
                         <br />
                       
                         <button type="button" name="start">start</button>
                         <button type="button" name="pause">pause</button>
                         <button type="button" name="reset">reset</button>
                       <div <?php e($prod); ?>>
                           <button class="btn btn-success float-right btn-ligar" data-id_cadastro="<?php e($dados_pessoais->id_cadastro); ?>" data-id_responsavel="<?php e($fila->id_responsavel); ?>" type="button"><i class="fa fa-phone mr-2" aria-hidden="true"></i>Ligar</button>
                           <button class="btn btn-danger float-right btn-desligar" data-id_cadastro="<?php e($dados_pessoais->telefone); ?>" type="button" style="display:none;"><i class="fa fa-phone mr-2" aria-hidden="true"></i>Desligar</button>
                       </div>
                   </div>
               </div>
           </div>
           <div class="card-body">
               <div class="card mb-3">
                   <div class="card-body">
                       <form id="form-interesse">
                       <input type="hidden" name="id_captura" value="<?php e($dados_pessoais->id_captura); ?>">
                       <div class="row"> 
                           <div class="col-sm-12">
                               <div class="form-group">
                                   <label for="interesse1">Interesse</label>
                                   <select class="form-control atendForm" id="interesse1" name="tipo_interesse">
                                     <option value="compra">Comprar</option>
                                     <option value="comprar e vender">Comprar e vender</option>
                                     <option value="investir">Investir</option>
                                     <option value="financiar">Financiar</option>
                                     <option value="permultar">Permultar</option>
                                     <option value="outros">Outro</option>
                                   </select>
                               </div>
                               <div class="form-group">
                                   <label for="onde1">Onde mora?</label>
                                   <input class="form-control atendForm" id="onde1" type="text" name="onde_mora" placeholder="">
                               </div>
                               <div class="form-group row">
                                   <div class="col-6 ">
                                       <label for="onde2">Profissão</label>
                                       <input class="form-control atendForm" id="onde2" name="profissao" type="text" placeholder="">
                                   </div>
                                   <div class="col-6 ">
                                       <label for="onde3">Local de trabalho</label>
                                       <input class="form-control atendForm" id="onde3" name="local_trabalho" type="text" placeholder="">
                                   </div>
                               </div>
                               <div class="form-group row">
                                   <div class="col-6 ">
                                       <label for="onde4">Estado Civil</label>
                                       <input class="form-control atendForm" id="onde4" name="estado_civil" type="text" placeholder="">
                                   </div>
                                   <div class="col-6">
                                       <label for="onde5">Possui família em Brasília?</label>
                                       <div class="form-inline">
                                           <div class="form-check form-check-inline mr-5 atendForm">
                                               <input class="form-check-input atendForm" id="inline-radio1" type="radio" name="possui_familia_brasilia" value="1" name="possuiFamilia">
                                               <label class="form-check-label font-weight-normal" for="inline-radio1">Sim</label>
                                           </div>
                                           <div class="form-check form-check-inline mr-5 atendForm">
                                               <input class="form-check-input atendForm" id="inline-radio2" type="radio" name="possui_familia_brasilia" value="0" name="possuiFamilia">
                                               <label class="form-check-label font-weight-normal" for="inline-radio2">Não</label>
                                           </div>
                                       </div>
                                   </div>
                               </div>
                               <div class="form-group row">
                                   <div class="col-6">
                                       <label for="onde6">Tem imóveil próprio?*</label>
                                       <div class="form-inline">
                                           <div class="form-check form-check-inline mr-5 atendForm">
                                               <input class="form-check-input atendForm" id="inline-radio1" type="radio" name="possui_imovel" value="1" name="imovelProprio">
                                               <label class="form-check-label font-weight-normal" for="inline-radio1">Sim</label>
                                           </div>
                                           <div class="form-check form-check-inline mr-5 atendForm">
                                               <input class="form-check-input atendForm" id="inline-radio2" type="radio" name="possui_imovel" value="0" name="imovelProprio">
                                               <label class="form-check-label font-weight-normal" for="inline-radio2">Não</label>
                                           </div>
                                       </div>
                                   </div>
                                   <div class="col-6">
                                       <label for="name">Quer vender?*</label>
                                       <div class="form-inline">
                                           <div class="form-check form-check-inline mr-5">
                                               <input class="form-check-input atendForm" id="inline-radio1" type="radio" name="quer_vender" value="1" name="querVender">
                                               <label class="form-check-label font-weight-normal" for="inline-radio1">Sim</label>
                                           </div>
                                           <div class="form-check form-check-inline mr-5">
                                               <input class="form-check-input atendForm" id="inline-radio2" type="radio" name="quer_vender" value="0" name="querVender">
                                               <label class="form-check-label font-weight-normal" for="inline-radio2">Não</label>
                                           </div>
                                       </div>
                                   </div>
                               </div>
                           </div>
                       </div>
                       
                   </div>    
               </div>
               
               <div class="form">
                 <div class="form-group">
                   <label for="descricao1">Descrição</label>
                   <textarea class="form-control atendForm"style="resize: none;" name="descricao" id="descricao1" rows="3"></textarea>
                 </div>
               </div>
               </form>
               <div class="row">
                   <div class="col-md-5">
                       <button class="btn btn-block btn-primary" data-toggle="modal" data-target="#enviarInfo"  type="button">Enviar informações</button>
                   </div>
                   <div class="col-md-7 pl-0">
                       <button type="button" class="btn btn-outline-success btn-block salvar11 btn-save-interesse">Salvar Atendimento</button>
                   </div>
               </div>
               <div class="resultado_interesse"></div>
           </div>
       </div>
       PROXIMO ATENDIMENTO
       <div class="accordion d-none" id="proximoDrop">
         <div class="card">
           <div class="card-header d-flex" id="proximoHeader">
             <h5 class="mb-0 my-auto d-flex">
               <input class="my-auto mr-3" type="checkbox" data-toggle="collapse" data-target="#proximoCollapse" aria-label="Ativar próximo atendimento">
               Próximo Atendimento
             </h5>
           </div>
           <div id="proximoCollapse" class="collapse multi-collapse" aria-labelledby="proximoHeader" data-parent="#proximoDrop">
               <div class="card-body">
                   <div class="form-row"> 
                       <form id="form-prox-atend">
                           <div class="form-group col-sm-8">
                               <label for="name">Agendar próximo contato em:</label>
                               <input name="tipo_interesse" type="hidden" value="<?php e($dados_pessoais->origem_captura); ?>">
                               <input name="novo_contato" type="hidden" value="sim">
                               <input name="agendar_visita" type="hidden" value="nao">
                               <input name="id_user" type="hidden" value="<?php e($this->session->id_cadastro); ?>">
                               <input name="origem" type="hidden" value="4">
                               <input name="id_origem" type="hidden" value="<?php e($dados_pessoais->id_captura); ?>">
                               <input name="id_destino" type="hidden" value="<?php e($empreendimento->id_empreendimento) ?>">
                               <input name="destino" type="hidden" value="1">
                               <input name="id_participantes" type="hidden" value="<?php e($incorporadora->id_responsavel) ?>"> 
                               <div class="form-inline pt-1">
                                   <div class="form-check form-check-inline mr-4">
                                       <input class="form-check-input proxForm" id="inline-radio1" type="radio" value="1" name="dias">
                                       <label class="form-check-label font-weight-normal" for="inline-radio1">Amanhã</label>
                                   </div>
                                   <div class="form-check form-check-inline mr-4">
                                       <input class="form-check-input proxForm" id="inline-radio2" type="radio" value="2" name="dias">
                                       <label class="form-check-label font-weight-normal" for="inline-radio2">2 Dias</label>
                                   </div>
                                   <div class="form-check form-check-inline">
                                       <input class="form-check-input proxForm personalizado" id="inline-radio3" type="radio" value="personalizado" name="dias">
                                       <label class="form-check-label font-weight-normal" for="inline-radio3">Personalizado</label>
                                   </div>
                               </div>
                           </div>
       
                           <div class="form-group col-4 quandoShow" style="display:none">
                               <label for="name">Quando?</label>
                               <div class="input-group date dateTimeAgenda">
                                   <div class="input-group-prepend">
                                       <span class="input-group-text input-group-addon"><i class="fa fa-calendar" aria-hidden="true"></i></span>
                                   </div>
                                   <input type="text" name="proximo_contato" class="form-control proxForm" id="proximo_contato">
                               </div>
                           </div>
                           <div class="resultado_contato"></div>
                       </form>
                   </div>
                   <div class="form-row">    
                       <div class="col-sm-12">
                         <button type="submit" class="btn btn-outline-success btn-block salvarProx btn-prox-atend">Salvar próximo atendimento</button>
                       </div>
                   </div>                          
               </div>
           </div>
         </div>
       </div>
       REPORTAR RECLAMAÇÃO
       <div class="accordion" id="reclamacaoDrop">
       <div class="card">
           <div class="card-header" id="reclamacaoHeader">
             <h5 class="mb-0">
               <input class="my-auto mr-3" type="checkbox" data-toggle="collapse" data-target="#reclamacaoCollapse" aria-label="Checkbox for following text input">
               Reportar reclamação
             </h5>
           </div>
           <div id="reclamacaoCollapse" class="collapse" aria-labelledby="reclamacaoHeader" data-parent="#reclamacaoDrop">
             <div class="card-body">
                 <form id="form-reclamacao">
                   <input type="hidden" name="id_responsavel" value="<?php e($this->session->id_cadastro)?>">
                   <input type="hidden" name="id_cliente" value="<?php e($dados_pessoais->id_cadastro)?>">
                   <div class="form-row"> 
                       <div class="form-group col-sm-12 mr-2">
                           <label for="areaReclamacao">Área:</label>
                           <div class="form-inline">
                               <div class="form-check form-check-inline mr-5">
                                   <input class="form-check-input" type="radio" name="area_reclamacao" id="area_reclamacao_mkt" value="marketing">
                                   <label class="form-check-label font-weight-normal" for="inline-radio1">Marketing</label>
                               </div>
                               <div class="form-check form-check-inline mr-5">
                                   <input class="form-check-input" type="radio" name="area_reclamacao" id="area_reclamacao_ti" value="tecnologia">
                                   <label class="form-check-label font-weight-normal" for="inline-radio2">Tecnologia</label>
                               </div>
                               <div class="form-check form-check-inline mr-5">
                                   <input class="form-check-input" type="radio" name="area_reclamacao" id="area_reclamacao_cor" value="corretor">
                                   <label class="form-check-label font-weight-normal" for="inline-radio2">Corretor</label>
                               </div>
                           </div>
                       </div>
                   </div>
                       
                       <div class="form">
                           <div class="form-group">
                               <label for="exampleFormControlTextarea1">Escreva aqui a reclamação do Lead:</label>
                               <textarea class="form-control reclForm" name="reclamacao" style="resize: none;" id="exampleFormControlTextarea1" rows="3"></textarea>
                           </div>
                       </div>
                   
                   <div class="form-row">    
                       <div class="col-sm-12">
                         <button type="submit" class="btn btn-outline-success btn-block">Enviar reclamação</button>
                       </div>
                       </br>
                       <div class="resultado_reclamacao"></div>
                   </div> 
                 </form>
             </div>
           </div>
         </div>
       </div>
   </div>
       </div>
   
   </div>
   SESSÃO3
   <div class="col-md-4">
       Cartão Vip
       <div class="card">
           <div class="card-header">
               <div class="row">
                   <div class="col-9 d-flex">
                       <h5 class="my-auto mr-2">Cartão VIP: </h5><h5 class="my-auto text-primary"><?php e($empreendimento->emp_nome_fantasia) ?></h5>
                   </div>
                   <div class="col-3">
                       <button type="button" class="btn btn-outline-primary btn-block" data-toggle="modal" data-target="#cartaovipEditar">Editar</button>
                   </div>
               </div>
           </div>
           <div class="card-body text-muted ">
               <ul class="list-group">
                 <li class="list-group-item">Cras justo odio</li>
                 <li class="list-group-item">Dapibus ac facilisis in</li>
                 <li class="list-group-item">Morbi leo risus</li>
                 <li class="list-group-item">Porta ac consectetur ac</li>
                 <li class="list-group-item">Vestibulum at eros</li>
               </ul>
               
               
               
               
               <div class="mb-1">
                   <b>Unidade:</b> <?php e($pre_reserva->unidade??''); ?>
               </div>
               <div class="mb-1">
                   <b>Incorporadora:</b> <?php e($incorporadora->incorporadora??''); ?>
               </div>
               <div class="mb-1">
                   <b>Vendedor:</b> <?php e($vendedor->nome??''); ?>
               </div>
               <div class="mb-1">
                   <b>Valor:</b> <?php e(money($pre_reserva->valor_total??'0.00')); ?>
               </div>
               <div class="mb-1">
                   <b>Status de compra:</b> Pré-reserva
               </div>
               <div class="mb-1">
                   <b>Visita:</b> <?php e(substr(converte_datahora($agenda->data_hora_agendamento??'',1),0,-3)); ?>
               </div> 
               <hr>
               <div class="mb-1">
                   <b>Data de entrada:</b> <?php e(substr(converte_datahora($dados_pessoais->datetime_captura,1),0,-3)); ?>
               </div>
               <div class="mb-1">
                   <b>Origem do Lead:</b> Google Ads
               </div>
               <button type="button" class="btn btn-outline-<?php e($dados_pessoais->status_captura == '3' ? 'success' : 'danger'); ?> btn-block mt-2" <?php e($dados_pessoais->status_captura == '3' ? 'disabled' : ''); ?>><?php e($dados_pessoais->status_captura == '3' ? 'Cartão Vip Ativo' : 'Cartão Vip Não Ativado'); ?></button>
           </div>
       </div>
       VISITAS
       <div class="card">
           <div class="card-header">
               
               <div class="row">
                   <div class="col-6 d-flex">
                       <h5 class="my-auto mr-2">Agenda: </h5><h5 class="my-auto text-primary"><?php e($empreendimento->emp_nome_fantasia) ?></h5>
                   </div>
                   <?php if(true){ ?>
                   <div class="col-6">
                       <button type="button" class="btn btn-primary float-right" data-toggle="modal" data-target="#agendaModal">Adicionar visita <i class="fa fa-plus ml-1" aria-hidden="true"></i></button>
                   </div>
                   <?php } ?>
               </div>
               
           </div>
           <div class="card-body pb-1" style="max-height: 368px;overflow-y: scroll;">
              
               <?php foreach($agendas as $agenda){ ?>
               <div class="card card-accent-warning mb-3">
                   <div class="card-body d-flex justify-content-between">
                       <div class="card-text">
                           <h5>Visita <?php e($agenda->tipo_agendamento == '1' ? 'Presencial' : 'Virtual'); ?> com <?php e($agenda->id_responsavel); ?></h5>
                           <p class="mb-0"><?php e(substr(converte_datahora($agenda->data_hora_agendamento,1),0,-3)); ?></p>
                       </div>
                       <a class="text-danger" style="color: #fff;" href="#">
                           <i class="fa fa-times" aria-hidden="true"></i>
                       </a>
                   </div>
               </div>
               <?php } ?>
               
           </div>
       </div>
   </div>
   LISTAS
   <div class="col-md-12 mb-bottom">
       <hr>
       <div class="card-body p-0">
           TABS
           <ul class="nav nav-tabs" id="historico1Tab1" role="tablist">
               <li class="nav-item">
                   <a class="nav-link active" id="historico1-tab" data-toggle="tab" href="#historico1" role="tab" aria-controls="historico1" aria-selected="true">Histórico do Lead</a>
               </li>
               <li class="nav-item">
                   <a class="nav-link" id="profile-tab" data-toggle="tab" href="#profile" role="tab" aria-controls="profile" aria-selected="false">Histórico de Atendimentos</a>
               </li>
           </ul>
           <div class="tab-content" id="myTab1Content">
               TAB 1
               <div class="tab-pane fade show active" id="historico1" role="tabpanel" aria-labelledby="historico1-tab">
                   
                   Filtro
                   <div class="d-none">
                   <form class="filtrar-historico-lead text-dark form-inline justify-content-end">
                       <label class="font-weight-normal mr-2" for="inputEmpreendimento">Data e Hora:</label>
                     
                         
                       <input type="hidden" name="email" value="<?php e($dados_pessoais->email)?>">
                       <input name="date" type="date" class="form-control" style="max-width: 150px;" placeholder="dd/mm/ano">  
                       
                   </form> 
                        
                       <button type="button" class="btn btn-primary my-auto btn-filtrar-historico-lead">Filtrar</button>
                       
                   </div>
                   
                   <hr>
                   HISTORICO LEAD
                   <table class="display table table-striped table-bordered" style="width:100%">
                       <thead>
                           <tr>
                               <th>Origem captura</th>
                               <th>Data captura</th>
                               <th>Nome</th>
                               <th>E-mail</th>
                               <th>telefone</th>
                               <th>cpf</th>
                           </tr>
                       </thead>
                       <tbody id="tabela-historico-lead">
                           <?php if(!empty($capturas)){ ?>
                               <?php foreach($capturas as $captura) { ?>
                               <tr>
                                   <td><?php e($captura->origem_captura); ?></td>
                                   <td><?php e(converte_datahora($captura->datetime_captura,1)); ?></td>
                                   <td><?php e($captura->nome); ?></td>
                                   <td><?php e($captura->email); ?></td>
                                   <td><?php e($captura->telefone); ?></td>
                                   <td><?php e($captura->cpf); ?></td>
                               </tr>
                               <?php } ?>
                           <?php } ?>
                       </tbody>
                   </table> 
               </div>
               
               TAB 2
               <div class="tab-pane fade" id="profile" role="tabpanel" aria-labelledby="profile-tab">
                   Filtro
                   <form class="form-inline justify-content-end d-none">
                   
                       <label class="font-weight-normal mr-2" for="inputEmpreendimento">Data e Hora:</label>
                     
                       <div class="input-group date dateTimeAgenda mr-2">
                           <div class="input-group-prepend">
                               <div class="input-group-text input-group-addon">
                                 <i class="fa fa-calendar" aria-hidden="true"></i>
                               </div>
                           </div>
                           <input type="text" class="form-control" style="max-width: 120px;"  id="dataHistorico" placeholder="dd/mm/ano">
                        </div>
                        
                        
                       <button type="submit" class="btn btn-primary my-auto">Filtrar</button>
                       
                   </form>
                   <hr>
                   IHSTORICO ATENDIMENTO
                   <table class="table table-striped table-bordered table-responsive-xl">
                     <thead>
                       <tr>
                         <th scope="col">Data de entrada</th>
                         <th scope="col">Último Atendimento</th>
                         <th scope="col">Último Contato Meio</th>
                         <th scope="col">Próximo Atendimento</th>
                         <th scope="col">Próximo Contato Motivo</th>
                         <th scope="col">Atendente</th>
                         <th scope="col">Observação</th>
                         <th scope="col">Status</th>
                         <th scope="col">Ações</th>
                       </tr>
                     </thead>
                     <tbody>
                       <?php if(!empty($atendimentos)){ ?>
                           <?php foreach($atendimentos as $atend) { ?>
                               <tr>
                                 <td><?php e(converte_datahora($atend->data_hora,1)); ?></td>
                                 <td><?php e(converte_datahora($atend->ultimo_contato,1)); ?></td>
                                 <td><?php e($atend->ultimo_contato_tipo); ?></td>
                                 <td><?php e(converte_datahora($atend->proximo_contato,1)); ?></td>
                                 <td><?php e($atend->proximo_contato_motivo); ?></td>
                                 <td><?php e($atend->atendente); ?></td>
                                 <td><?php e($atend->observacao); ?></td>
                                 <td><?php e($atend->status_jornada); ?><span class="badge badge-success">Ativo</span></td>
                                 <td><button class="btn btn-sm btn-primary mr-1 set_leed" data-id="1034" data-toggle="modal" data-target="#atendimentoRapidoModal" data-original-title="Atendimento rápido"><i class="icon-plus"></i></button>
                                 </td>
                               </tr>
                           <?php } ?>
                       <?php } ?>
                     </tbody>
                   </table>                 
               </div>
           </div>
       </div>        
   </div>
   Modal
   <div class="modal fade" id="interesseModal" tabindex="-1" role="dialog" aria-labelledby="interesseModal" aria-hidden="true">
     <div class="modal-dialog modal-dialog-centered" style="max-width: 1000px;" role="document">
       <div class="modal-content">
         <div class="modal-header">
           <h4 class="modal-title" id="exampleModalLabel">Anunciar Interesse</h4>
           <button type="button" class="close" data-dismiss="modal" aria-label="Close">
             <span aria-hidden="true">&times;</span>
           </button>
         </div>
         <div class="modal-body">
           <div class="row">
               <div class="col-md-6">
                   <form class="text-dark form-anunciar-interesse">
                       
                       <input type="hidden" name="id_captura" value="<?php e($dados_pessoais->id_captura) ?>">
                       
                       <div class="form-group row">
                           <div class="col-6">
                              <label for="interessadoEM">Interessado em:</label>
                               <select name="tipo_interesse" class="form-control interForm" id="interessadoEM">
                                 <option value="compra">Comprar</option>
                                 <option value="venda">Vender</option>
                                 <option value="comprar e vender">Comprar e vender</option>
                               </select> 
                           </div>
                         <div class="col-6">
                               <label for="interesse1">Tipo de imóvel</label>
                               <?php
                               e(HBusca::getHtmlSelectTiposImovel());
                               ?>
                               <select class="form-control interForm" id="interesse1">
                                   <option value="casa">Casa</option>
                                   <option value="apartamento">Apartamento</option>
                                   <option value="tudio">Studio</option>
                                   <option>Flat</option>
                                   <option>Cobertura</option>
                                   <option>Duplex</option>
                               </select>                           
                         </div>
                           
                       </div>
                       <div class="form-group row">
                           <div class="col-4">
                               <label for="interesse2">Quartos</label>
                               <select name="quartos" class="form-control interForm" id="interesse2">
                                 <option>1</option>
                                 <option>2</option>
                                 <option>3</option>
                                 <option value="4">4 ou +</option>
                               </select>
                           </div>
                           <div class="col-4">
                               <label for="interesse3" class="col-form-label">Banheiros:</label>
                               <select name="banheiros" class="form-control interForm" id="interesse3">
                                 <option value="0">1</option>
                                 <option>2</option>
                                 <option>3</option>
                                 <option value="4">4 ou +</option>
                               </select>                                
                           </div>  
                           <div class="col-4">
                               <label for="interesse4" class="col-form-label">Vagas:</label>
                               <select name="vaga" class="form-control interForm" id="interesse4">
                                 <option>1</option>
                                 <option>2</option>
                                 <option>3</option>
                                 <option value="4">4 ou +</option>
                               </select>                                    
                           </div> 
                       </div>
                       <div class="form-group">
                           <label for="interesse5">Bairro:</label>
                           <input name="bairro" type="text" class="form-control interForm" id="interesse5">
                       </div>  
                       <div class="form-group">
                           <label for="interesse6" class="col-form-label">Faixa de preço:</label>
                           <div class="row">
                               <div class="col-6 d-flex align-items-center pr-2">
                                   De
                                   <input name="faixa_preco_inicio" type="text" class="form-control ml-2 interForm" id="interesse6">
                               </div>
                               <div class="col-6 d-flex align-items-center pl-0">
                                   até
                                   <input name="faixa_preco_fim" type="text" class="form-control ml-2 interForm" id="interesse6">
                               </div>
                           </div>
                       </div>
                       <div class="form-group">
                           <label for="exampleFormControlTextarea1">Descrição</label>
                           <textarea name="descricao" class="form-control interForm" style="resize: none;" id="exampleFormControlTextarea1" rows="2"></textarea>
                       </div>
                       <button type="button" class="btn btn-block btn-outline-success salvarInter">Salvar</button>
                       <div class="resultado_anunciar_interesse"></div>
                       
                   </form>
               </div>
               <div class="col-md-6">
                   <div class="card bg-light h-100">
                       <div class="card-body pb-0" id="card-interesse-sujestao">
                           <div class="card-text text-muted">
                           <h5>Sugestões de imóveis</h5>
                           </div>
                           
                       </div>
                       <div class="card-footer">
                           <button class="btn btn-block btn-primary" type="button">Enviar email e whatsapp</button>
                       </div>
                   </div> 
               </div>
           </div>  
         </div>
       </div>
     </div>
   </div> 
   Modal
   <div class="modal fade" id="agendaModal" tabindex="-1" role="dialog" aria-labelledby="agendaModal" aria-hidden="true">
     <div class="modal-dialog modal-dialog-centered" role="document">
       <div class="modal-content">
         <div class="modal-header">
           <div class="d-flex">
               <h4 class="my-auto mr-2">Agendamento de visita: </h4><h4 class="my-auto text-primary"><?php e($empreendimento->emp_nome_fantasia) ?></h4>
           </div>
           <button type="button" class="close" data-dismiss="modal" aria-label="Close">
             <span aria-hidden="true">&times;</span>
           </button>
         </div>
         <div class="modal-body">
          <form class="add-visita text-dark">
               <div class="form-group">
                   <input type="hidden" name="data_hora_agendamento"   id="data_hora_agendamento" value="">
                   <input type="hidden" name="id_parceiro"      id="id_origem" value="<?php e($parceiro->id_parceiro) ?>">
                   <input type="hidden" name="id_participantes[]" id="id_participantes" value="<?php e($incorporadora->id_responsavel) ?>">
                   <input type="hidden" name="origem"           id="origem" value="4">
                   <input type="hidden" name="id_origem"        id="id_origem" value="<?php e($dados_pessoais->id_captura) ?>">
                   <input type="hidden" name="destino"          id="destino" value="1">
                   <input type="hidden" name="id_destino"       id="id_destino" value="<?php e($empreendimento->id_empreendimento) ?>">
                   <input type="hidden" name="id_interessado"   id="id_interessado" value="<?php e($dados_pessoais->id_cadastro) ?>">
                   <label for="tipoEvento">Tipo de visita:</label>
                   <select class="form-control" id="tipoEvento">
                     <option>Visita virtual</option>
                     <option>Visita presencial</option>
                   </select>
               </div>
               <div class="form-group row">
                 <div class="col-6">
                   <label for="melhordia" class="col-form-label">Melhor dia:</label>
                   <div id="datetimepicker"><input type="text" name="data" class="form-control"></div>
                   
                 </div>   
                 <div class="col-6">
                   <label for="melhorhora1" class="col-form-label">Melhor hora:</label>
                   <div class="card-body card-scroll container-items horariosDisponiveis" style="max-height: 255px;"></div>
                 </div>  
                 
                 <input type="hidden" name="data_hora_agendamento" value="">
                 
              </div>
             <div class="form-group">
               <label for="observação1" class="col-form-label">Observação:</label>
               <textarea class="form-control" name="descricao_agenda" id="observação1"></textarea>
             </div>
             
             <div class="resultado_agendar_visita"></div>
           </form>
         </div>
         <div class="modal-footer">
           <button type="button" class="btn btn-primary btn-add-visita">Salvar agendamento</button>
         </div>
       </div>
     </div>
   </div>
   Modal
   <div class="modal fade" id="cartaovipNovo" tabindex="-1" role="dialog" aria-labelledby="cartaovipNovo" aria-hidden="true">
                 <div class="modal-dialog modal-dialog-centered" role="document">
                   <div class="modal-content">
                     <div class="modal-header">
                       <h4 class="modal-title text-muted" id="exampleModalLabel">Cadastro de Cartão VIP</h4>
                       <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                         <span aria-hidden="true">&times;</span>
                       </button>
                     </div>
                     <div class="modal-body">
                       <form class="text-dark form-modal-criar-cvip">
                          
                          <input type="hidden" name="id_cadastro" value="<?php e($dados_pessoais->id_cadastro) ?>"/>
                          
                           <div class="form-group row">
                               <div class="col-8">
                                   <label for="nomeVIP">Nome completo:</label>
                                   <input name="nome" type="text" class="form-control vipForm" value="<?php e($dados_pessoais->nome) ?>" id="nomeVIP">
                               </div>
                               <div class="col-4">
                                   <label for="cpfVIP">CPF:</label>
                                   <input name="cpf" type="text" class="form-control vipForm" value="<?php e($dados_pessoais->cpf) ?>" id="cpfVIP">
                               </div>
                           </div>  
                           <div class="form-group row">
                               <div class="col-7">
                                   <label for="emailVIP">Email:</label>
                                   <input name="email" type="text" class="form-control vipForm" value="<?php e($dados_pessoais->email) ?>" id="emailVIP">
                               </div>
                               <div class="col-5">
                                   <label for="telefoneVIP">Telefone:</label>
                                   <input name="telefone" type="text" class="form-control vipForm" value="<?php e($dados_pessoais->telefone) ?>" id="telefoneVIP">
                               </div>
                           </div>  
                           <div class="form-group row">
                               <div class="col-4">
                                   <label for="conjugeVIP">Possui cônjuge?</label>
                                   <div class="form-inline">
                                       <div class="form-check form-check-inline mr-5">
                                           <input class="form-check-input vipForm" id="inline-radio1" type="radio" value="Sim" name="possui_conjuje" <?php e($dados_pessoais->possui_conjuje == 'Sim' ? 'checked' : '' );?>>
                                           <label class="form-check-label font-weight-normal" for="inline-radio1">Sim</label>
                                       </div>
                                       <div class="form-check form-check-inline mr-2">
                                           <input class="form-check-input vipForm" id="inline-radio2" type="radio" value="Não" name="possui_conjuje" <?php e($dados_pessoais->possui_conjuje == 'Não' ? 'checked' : '' );?>>
                                           <label class="form-check-label font-weight-normal" for="inline-radio2">Não</label>
                                       </div>
                                   </div>
                               </div>
           
                           </div>
                           <div class="form-group row" id="cadastra-cartao-conjuje" style="<?php e($dados_pessoais->possui_conjuje == 'Não' ? 'display: none;' : '' );?>">
                               <div class="col-8">
                                   <label for="nomeconjVIP">Nome completo do cônjuge:</label>
                                   <input name="nome_conjuje" type="text" class="form-control vipForm" value="<?php e($dados_pessoais->nome_conjuje) ?>" id="nomeconjVIP">                                    
                               </div>                    
                               <div class="col-6">
                                   <label for="cpfconjVIP">CPF do cônjuge:</label>
                                   <input name="cpf_conjuje" type="text" class="form-control vipForm" value="<?php e($dados_pessoais->cpf_conjuje) ?>" id="cpfconjVIP">
                               </div>
                               <div class="col-6">
                                   <label for="telefoneconjVIP">Telefone do cônjuge:</label>
                                   <input name="telefone_conjuge" type="text" class="form-control vipForm" value="<?php e($dados_pessoais->telefone_conjuge) ?>" id="telefoneconjVIP">
                               </div>
                           </div>
                           <hr>
                           <div class="form-group row">
                               <div class="col-6">
                                     <div class="form-group">
                                       <label for="exampleFormControlSelect1">Empreendimento escolhido:</label>
                                       <select class="form-control select_emp_add_cartao" name="emp_nome_fantasia" id="exampleFormControlSelect1">
                                           <option>Selecione</option>
                                           <?php foreach($empreendimentos as $emp) { ?>
                                               <option value="<?php e($emp->id_empreendimento) ?>"><?php e($emp->emp_nome_fantasia) ?></option>
                                           <?php } ?>
                                       </select>
                                     </div>
                               </div>
                               <div class="col-6 result_unidades">
                                   
                               </div>
                           </div>                            

                          <div class="resultado_criar_cvip"></div>
                          
                       </form>
                     </div>
                     <div class="modal-footer">
                       <button type="button" class="btn btn-block btn-outline-success btn-criar-cartao-vip">Salvar</button>
                     </div>
                   </div>
                 </div>
               </div>
   Modal
   <div class="modal fade" id="cadastroContaComdono" tabindex="-1" role="dialog" aria-labelledby="cadastroContaComdono" aria-hidden="true">
                 <div class="modal-dialog modal-dialog-centered" role="document">
                   <div class="modal-content">
                     <div class="modal-header">
                       <h4 class="modal-title text-muted" id="exampleModalLabel">Cadastrar Conta Comdono</h4>
                       <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                         <span aria-hidden="true">&times;</span>
                       </button>
                     </div>
                     <div class="modal-body">
                       <form class="text-dark form-modal-criar-conta-comdono">
                           
                           <div class="form-group row">
                               <div class="col-8">
                                   <label for="nomeVIP">Nome completo:</label>
                                   <input name="nome" type="text" class="form-control" value="">
                               </div>
                           </div>  
                           <div class="form-group row">
                               <div class="col-7">
                                   <label for="emailVIP">Email:</label>
                                   <input name="email" type="text" class="form-control" value="" >
                               </div>
                               <div class="col-5">
                                   <label for="telefoneVIP">Telefone:</label>
                                   <input name="telefone" type="text" class="form-control" value="" id="telefone_conta_comdono">
                               </div>
                           </div>  
                           
                          <div class="resultado_conta_comdono"></div>
                       </form>
                     </div>
                     <div class="modal-footer">
                       <button type="button" class="btn btn-block btn-outline-success btn-criar-conta-comdono">Cadastrar</button>
                     </div>
                   </div>
                 </div>
               </div>            
   Modal
   <div class="modal fade" id="cartaovipEditar" tabindex="-1" role="dialog" aria-labelledby="cartaovipNovo" aria-hidden="true">
                 <div class="modal-dialog modal-dialog-centered" role="document">
                   <div class="modal-content">
                     <div class="modal-header">
                       <h4 class="modal-title text-muted" id="exampleModalLabel">Editar dados  Cartão VIP</h4>
                       <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                         <span aria-hidden="true">&times;</span>
                       </button>
                     </div>
                     <div class="modal-body">
                       <form class="text-dark form-modal-cvip">
                           <input type="hidden" name="id_captura" value="<?php e($dados_pessoais->id_captura) ?>"/>  
                           <input type="hidden" name="id_cadastro" value="<?php e($dados_pessoais->id_cadastro) ?>"/>
                           <div class="form-group row">
                               <div class="col-8">
                                   <label for="nomeVIP">Nome completo:</label>
                                   <input name="nome" type="text" class="form-control" value="<?php e($dados_pessoais->nome) ?>" id="nomeVIP">
                               </div>
                               <div class="col-4">
                                   <label for="cpfVIP">CPF:</label>
                                   <input name="cpf" type="text" class="form-control readonly" value="<?php e($dados_pessoais->cpf) ?>" id="cpfVIP_edit" readonly>
                               </div>
                           </div>  
                           <div class="form-group row">
                               <div class="col-7">
                                   <label for="emailVIP">Email:</label>
                                   <input name="email" type="text" class="form-control" value="<?php e($dados_pessoais->email) ?>" id="emailVIP">
                               </div>
                               <div class="col-5">
                                   <label for="telefoneVIP">Telefone:</label>
                                   <input name="telefone" type="text" class="form-control" value="<?php e($dados_pessoais->telefone) ?>" id="telefoneVIP_edit">
                               </div>
                           </div>  
                           <div class="form-group row">
                               <div class="col-4">
                                   <label for="conjugeVIP">Possui cônjuge?</label>
                                   <div class="form-inline">
                                       <div class="form-check form-check-inline mr-5">
                                           <input class="form-check-input" id="checkbox-edit-cvip" type="radio" value="Sim" name="possui_conjuje" <?php e($dados_pessoais->possui_conjuje == 'Sim' ? 'checked' : '' );?>>
                                           <label class="form-check-label font-weight-normal" for="inline-radio1">Sim</label>
                                       </div>
                                       <div class="form-check form-check-inline mr-2">
                                           <input class="form-check-input" id="checkbox-edit-cvip" type="radio" value="Não" name="possui_conjuje" <?php e($dados_pessoais->possui_conjuje == 'Não' ? 'checked' : '' );?>>
                                           <label class="form-check-label font-weight-normal" for="inline-radio2">Não</label>
                                       </div>
                                   </div>
                               </div>
                              
                               
                           </div>
                           <div class="form-group row" id="edit-cartao-conjuje" style="<?php e($dados_pessoais->possui_conjuje == 'Não' ? 'display: none;' : '' );?>">
                               <div class="col-8">
                                   <label for="nomeconjVIP">Nome completo do cônjuge:</label>
                                   <input name="nome_conjuje" type="text" class="form-control" value="<?php e($dados_pessoais->nome_conjuje) ?>" id="nomeconjVIP">                                    
                               </div>
                               
                               <div class="col-6">
                                   <label for="cpfconjVIP">CPF do cônjuge:</label> 
                                   <input name="cpf_conjuje" type="text"  class="form-control" value="<?php e($dados_pessoais->cpf_conjuje) ?>" id="cpfconjVIP_edit" readonly>
                               </div>
                               <div class="col-6">
                                   <label for="telefoneconjVIP">Telefone do cônjuge:</label>
                                   <input name="telefone_conjuge" type="text" class="form-control" value="<?php e($dados_pessoais->telefone_conjuge) ?>" id="telefoneconjVIP_edit">
                               </div>
                           </div>
                           <hr>
                           <div class="form-group row">
                               <div class="col-6">
                                   <label for="empreVIP">Empreendimento escolhido:</label>
                                   <input name="emp_nome_fantasia" type="text" class="form-control" value="<?php e($empreendimento->emp_nome_fantasia) ?>" id="empreVIP" readonly>
                               </div>
                               <div class="col-6">
                                   <label for="unidadeVIP">Unidade escolhida:</label>
                                   <input name="unidade" type="text" class="form-control" value="<?php e($unidade->unidade) ?>" id="unidadeVIP" readonly>
                               </div>
                           </div>                            
                           
                          <div class="resultado_cvip"></div>
                       </form>
                     </div>
                     <div class="modal-footer">
                       <button type="button" class="btn btn-block btn-outline-success btn-salvar-cartao-vip">Salvar</button>
                     </div>
                   </div>
                 </div>
               </div>
   Modal
   <div class="modal fade" id="concluirAtend" tabindex="-1" role="dialog" aria-labelledby="concluirAtend" aria-hidden="true">
                 <div class="modal-dialog modal-dialog-centered" role="document">
                   <div class="modal-content">
                     <div class="modal-header">
                       <h4 class="modal-title" id="exampleModalLabel">Ajude-nos a melhorar o seu Dashboard!</h4>
                       <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                         <span aria-hidden="true">&times;</span>
                       </button>
                     </div>
                     <div class="modal-body">
                       <form class="text-dark form-modal-enviar-sugestao">
                          
                           <input type="hidden" name="id_fila" value="<?php e($fila->id_fila) ?>">
                           <div class="form-group">
                               <label for="conjugeVIP">Como está sua experiência com o sistemas?</label>
                               <div class="form-inline">
                                   <div class="form-check form-check-inline mr-5">
                                       <input class="form-check-input" id="inline-radio1" type="radio" value="1" name="experiencia">
                                       <label class="form-check-label font-weight-normal" for="inline-radio1">Boa</label>
                                   </div>
                                   <div class="form-check form-check-inline mr-2">
                                       <input class="form-check-input" id="inline-radio2" type="radio" value="2" name="experiencia">
                                       <label class="form-check-label font-weight-normal" for="inline-radio2">Ruim</label>
                                   </div>
                               </div>
                           </div>
                      
                           <div class="form-group">
                               <label for="descricao1">Alguma sugestão ou reclamação?</label>
                               <textarea name="sugestao" class="form-control" style="resize: none;" id="descricao1" rows="3"></textarea>
                           </div>
                          
                          <div class="resultado_enviar_sugestao"></div>
                       </form>
                     </div>
                     <div class="modal-footer">
                           <div class="d-flex justify-content-around">
                               <div class="mx-2">
                                   <button type="button" class="btn btn-block btn-primary btn-finaliza-atendimento" data-id_fila="<?php e($fila->id_fila) ?>">Finalizar Atendimento</button>
                               </div>
                               <div class="d-none">
                                   <button type="button" class="btn btn-block btn-success">Próximo atendimento</button>
                               </div>
                           </div>
                      
                     </div>
                   </div>
                 </div>
               </div>
   Modal
   <div class="modal fade" id="enviarInfo" tabindex="-1" role="dialog" aria-labelledby="concluirAtend" aria-hidden="true">
                 <div class="modal-dialog modal-dialog-centered" role="document">
                   <div class="modal-content">
                     <div class="modal-header">
                       <h4 class="modal-title text-muted" id="exampleModalLabel">Enviar informações para o Lead</h4>
                       <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                         <span aria-hidden="true">&times;</span>
                       </button>
                     </div>
                     <div class="modal-body">
                       <form class="text-dark">
                           <div class="row">
                               <div class="col-6">
                                   <div class="form d-flex flex-column">
                                       
                                       <div class="form-group">
                                           <label for="conjugeVIP">Sobre o empreendimento</label>
                                           <select class="form-control" id="interessadoEM">
                                             <option>Elleven</option>
                                             <option>Liberty</option>
                                             <option>Exclusive</option>
                                             <option>Signature</option>
                                           </select>                                             
                                       </div>

                                       
                                       <div class="form-check form-check-inline ">
                                           <input class="form-check-input" id="gridCheck1" type="checkbox">
                                           <label class="form-check-label font-weight-normal" for="gridCheck1">Book Digital</label>
                                       </div>
                                       <div class="form-check form-check-inline ">
                                           <input class="form-check-input" id="gridCheck1" type="checkbox">
                                           <label class="form-check-label font-weight-normal" for="gridCheck1">Landing page</label>
                                       </div>
                                       <div class="form-check form-check-inline">
                                           <input class="form-check-input" id="gridCheck1" type="checkbox">
                                           <label class="form-check-label font-weight-normal" for="gridCheck1">Localização</label>
                                       </div>
                                       <div class="form-check form-check-inline ">
                                           <input class="form-check-input" id="gridCheck1" type="checkbox">
                                           <label class="form-check-label font-weight-normal" for="gridCheck1">Localização - Stand de Vendas</label>
                                       </div>
                                       <div class="form-check form-check-inline ">
                                           <input class="form-check-input" id="gridCheck1" type="checkbox">
                                           <label class="form-check-label font-weight-normal" for="gridCheck1">Localização - Empreendimento</label>
                                       </div>
                                       <div class="form-check form-check-inline">
                                           <input class="form-check-input" id="gridCheck1" type="checkbox">
                                           <label class="form-check-label font-weight-normal" for="gridCheck1">Layout Personalizado</label>
                                       </div>
                                   </div>
                               </div>
                               <hr width = “2” size = “100”>
                               <div class="col-6">
                                   <div class="form d-flex flex-column">
                                       <div class="form-group mb-1">
                                           <label for="conjugeVIP">Sobre o Comdono</label>
                                       </div>
                                       <div class="form-check form-check-inline ">
                                           <input class="form-check-input" id="gridCheck1" type="checkbox">
                                           <label class="form-check-label font-weight-normal" for="gridCheck1">Apresentação Comdono</label>
                                       </div>
                                       <div class="form-check form-check-inline ">
                                           <input class="form-check-input" id="gridCheck1" type="checkbox">
                                           <label class="form-check-label font-weight-normal" for="gridCheck1">Localização Comdono</label>
                                       </div>
                                       <div class="form-check form-check-inline">
                                           <input class="form-check-input" id="gridCheck1" type="checkbox">
                                           <label class="form-check-label font-weight-normal" for="gridCheck1">Localização</label>
                                       </div>
                                       <div class="form-check form-check-inline ">
                                           <input class="form-check-input" id="gridCheck1" type="checkbox">
                                           <label class="form-check-label font-weight-normal" for="gridCheck1">Convite Comdono</label>
                                       </div>
                                   </div>
                               </div>
                           </div>
                           <hr>
                           <div class="form-group">
                               <div class="form-check form-check-inline mb-2">
                                   <input class="form-check-input" id="gridCheck1" type="checkbox">
                                   <label class="form-check-label" for="gridCheck1">Mensagem</label>
                               </div>
                               <textarea class="form-control" style="resize: none;" id="descricao1" rows="3"></textarea>
                           </div>

                       </form>
                     </div>
                       <div class="modal-footer">
                           <button type="button" class="btn btn-secondary" data-dismiss="modal">Fechar</button>
                           <button type="button" class="btn btn-primary">Enviar via whatsappp</button>
                           <button type="button" class="btn btn-primary">Enviar via email</button>
                       </div>
                      
                     </div>
                   </div>
                 </div>
   Modal
   <div class="modal fade" id="transferAtend"  tabindex="-1"  role="dialog" aria-labelledby="transferAtend" aria-hidden="true">
       <div class="modal-dialog modal-dialog-centered" role="document">
           <div class="modal-content">
               <div class="modal-header">
                   <h4 class="modal-title" id="exampleModalLabel">Transferir atendimento</h4>
                   <button type="button" class="close transfForm" data-dismiss="modal" aria-label="Close">
                     <span aria-hidden="true">&times;</span>
                   </button>
               </div>
               <div class="modal-body">
                   <form class="text-dark">
                       <div class="form-group">
                           <label for="tipoTRANS" class="col-form-label">Tipo de atendimento:</label>
                           <div class="form-inline">
                               <div class="form-check form-check-inline mr-5">
                                   <input class="form-check-input transfForm" id="tipoTRANSradio1" type="radio" value="option1" name="tipoTRANS">
                                   <label class="form-check-label font-weight-normal" for="tipoTRANSradio1">Comdono</label>
                               </div>
                               <div class="form-check form-check-inline mr-5">
                                   <input class="form-check-input transfForm" id="tipoTRANSradio2" type="radio" value="option2" name="tipoTRANS">
                                   <label class="form-check-label font-weight-normal" for="tipoTRANSradio2">Correspondente</label>
                               </div>
                           </div>
                       </div>
                       <div class="form-group">
                           <label for="tipoTRANS2" class="col-form-label">Motivo:</label>
                           <input type="text" class="form-control transfForm" id="tipoTRANS2">
                       </div>
                       <div class="form-group">
                           <label for="tipoTRANS3" class="col-form-label">Message:</label>
                           <textarea class="form-control transfForm" id="tipoTRANS3"></textarea>
                       </div> 
                       <div class="form-group">
                           <label for="tipoTRANS" class="col-form-label">Próximo contato:</label>
                           <div class="form-inline">
                               <div class="form-check form-check-inline mr-5">
                                   <input class="form-check-input transfForm" id="TRANSradio1" type="radio" value="option1" name="tipoTRANS">
                                   <label class="form-check-label font-weight-normal" for="TRANSradio1">Próximo da fila</label>
                               </div>
                               <div class="form-check form-check-inline mr-5">
                                   <input class="form-check-input transfForm" id="TRANSradio2" type="radio" value="option2" name="tipoTRANS">
                                   <label class="form-check-label font-weight-normal" for="TRANSradio2">Personalizado</label>
                               </div>
                           </div>
                       </div>
                       <button type="button" class="btn btn-outline-primary btn-lg btn-block mt-3 salvarTrans">Transferir</button>
                       <div class="row transConcluido">
                           <div class="col-6">
                               <button type="button" class="btn btn-outline-primary btn-block salvarTrans mt-3">Ir para o Dashboard</button>
                           </div>
                           <div class="col-6 pl-0">
                               <button type="button" onclick="window.location.href='https://dev.comdono.com/atendimento/incorporadoras';" class="btn btn-success btn-block mt-3">Próximo atendimento</button>
                           </div>
                       </div>
                   </form>
               </div>
           </div>
       </div>
   </div>
   Modal
   <div class="modal fade" id="prorrogaAtend"  tabindex="-1"  role="dialog" aria-labelledby="prorrogaAtend" aria-hidden="true">
       <div class="modal-dialog modal-dialog-centered" role="document">
           <div class="modal-content">
               <div class="modal-header">
                   <h4 class="modal-title" id="exampleModalLabel">Adiar atendimento</h4>
                   <button type="button" class="close transfForm" data-dismiss="modal" aria-label="Close">
                     <span aria-hidden="true">&times;</span>
                   </button>
               </div>
               <div class="modal-body">
                   <form class="text-dark adia-atendimento">
                       <div class="form-group">
                           <label for="tipoTRANS2" class="col-form-label">Tempo:</label>
                           <select class="form-control select-prorr" name="date_prorrogado">
                               <option value="0000-00-00 00:00:00">Selecione</option>
                               <option value="<?php e(date('Y-m-d H:i:s', strtotime('+1 hour'))) ?>">1 Hora</option>
                               <option value="<?php e(date('Y-m-d 09:00:00', strtotime('+1 day'))) ?>">1 Dia</option>
                               <option value="<?php e(date('Y-m-d 09:00:00', strtotime('+1 week'))) ?>">1 Semana</option>
                               <option value="personalizado">Personalizado</option>
                           </select>
                       </div>
                       <input name="id_fila" type="hidden" value="<?php e($fila->id_fila); ?>">
                       <div class="form-group data-perso" style="display:none;">
                           <label for="tipoTRANS3" class="col-form-label">Data Personalizada:</label>
                           <input class="form-control transfForm dt-perso" type="datetime-local" id="tipoTRANS3">
                       </div>
                       <div class="form-group">
                           <label for="tipoTRANS3" class="col-form-label">Message:</label>
                           <textarea class="form-control transfForm" name="motivo_prorrogacao" id="tipoTRANS3"></textarea>
                       </div>
                       <div class="row transConcluido">
                           <div class="col-6">
                               <button type="button" class="btn btn-outline-primary btn-block 132salvarTrans mt-3">Cancelar</button>
                           </div>
                           <div class="col-6 pl-0">
                               <button type="button" class="btn btn-success btn-block mt-3 adia-atend">Salvar</button>
                           </div>
                       </div>
                   </form>
               </div>
           </div>
       </div>
   </div>
   Modal
   <div class="modal fade" id="modalNvoip"  tabindex="-1"  role="dialog" aria-labelledby="prorrogaAtend" aria-hidden="true">
       <div class="modal-dialog modal-dialog-centered" role="document">
           <div class="modal-content">
               <div class="modal-header">
                   <h4 class="modal-title" id="exampleModalLabel">Realizar Ligação</h4>
                   <button type="button" class="close transfForm" data-dismiss="modal" aria-label="Close">
                     <span aria-hidden="true">&times;</span>
                   </button>
               </div>
               <div class="modal-body">
                   <form class="text-dark">
                       <label>Nome:</label>
                       <input name="nome" value="<?php e($dados_pessoais->nome); ?>" class="form-control" readonly>
                       <label>Telefone:</label>
                       <input name="nome" value="<?php e($dados_pessoais->telefone); ?>" class="form-control">
                   </form>
                   <button type="button" class="btn btn-primary"><i class="fa fa-phone fa-rotate-90" aria-hidden="true"></i> Discar</button>
                   <button type="button" class="btn btn-primary"><i class="fa fa-volume-control-phone" aria-hidden="true"></i> Discar</button>
               </div>
           </div>
       </div>
   </div>

</div>
</div> -->