<!-- Inicio -->

<?php $prod = base_url() == 'https://dev.comdono.com/' ? '' : 'style="display:none;"'; ?>

<div class="card bg-light">
    <div class="card-header">
        <div class="d-flex  align-items-center">
            
            <span class="h5 mb-0">Atendimento:</span>
            <!-- TROCAR PARA 1 -->
            <?php if(count($outros_atendimentos) >= 2){ ?>
                <span class="ml-1">
                    <select class="btn btn-outline" <?php e($prod); ?> name="select_atendimentos">
                        <option value="0">Outros atendimentos</option>
                        <?php foreach($outros_atendimentos as $outro){ ?>
                            <option value="<?php e($outro['id_captura']) ?>"><?php e($outro['name_emp']) ?></option>
                        <?php } ?>
                    </select>
                </span>
            <?php } ?>
            
            
            <div class="buttonss ml-auto">
                <!-- <button class=" btn btn-primary mr-2" type="button" data-toggle="modal" data-target="#transferAtend" <?php e($prod); ?>>Transferir</button> -->
                <button class=" btn btn-secondary mr-2" type="button" data-toggle="modal" data-target="#prorrogaAtend" >Criar Follow-UP</button>
                <button class=" btn btn-danger" type="button" data-toggle="modal" data-target="#concluirAtend" >Concluir atendimento</button>
            </div>
            <div class="d-flex">
                  <div class="gravacao" style="display:none; font-size: 0.6rem;">
                      <div class="d-flex d-flex align-items-center mr-3">
                        <p class="my-auto">Gravando <i class="fa fa-circle" aria-hidden="true" style="color:red; margin:0;"></i></p>
                        <span id="hour">00</span>:<span id="minute">00</span>:<span id="second">00</span><span id="millisecond" style="display:none">000</span>                                              
                      </div>
                  </div>
                  <!--<br />
                  <button type="button" name="start">start</button>
                  <button type="button" name="pause">pause</button>
                  <button type="button" name="reset">reset</button>-->
                  
                <div class="d-none" <?php e($prod); ?>>
                    <button class="btn  btn-success btn-sm float-right btn-ligar" data-id_cadastro="<?php e($dados_pessoais->id_cadastro); ?>" data-id_responsavel="<?php e(@$fila->id_responsavel); ?>" type="button"><i class="fa fa-phone mr-2" aria-hidden="true"></i>Ligar</button>
                    <button class="btn  btn-danger btn-sm float-right btn-desligar" data-id_cadastro="<?php e($dados_pessoais->telefone); ?>" type="button" style="display:none;"><i class="fa fa-phone mr-2" aria-hidden="true"></i>Desligar</button>
                </div>
            </div>
        
        </div>
    </div>
    <div class="card-body">
            <!-- Atendimento -->
            <div class="row">
                <div class="col-lg-5">
                    <!--Dados do lead-->
                    <div class="card">
                        <div class="card-body">
                            <!--Dados-->
                            <div class="d-flex text-muted mb-4">
                                <img src="https://cdn.pixabay.com/photo/2016/08/08/09/17/avatar-1577909_1280.png" class="rounded img-fluid" style="width: 85px; height: 85px; object-fit: cover;" alt="...">
                                <div class="ml-3">
                                    <div>
                                        <b>Nome:</b> <?php e($dados_pessoais->nome); ?>
                                    </div>
                                    <div>
                                        <b>CPF:</b> <?php e($dados_pessoais->cpf); ?>
                                    </div>
                                    <div>
                                        <b>Email:</b> <?php e($dados_pessoais->email); ?>
                                    </div>
                                    <div>
                                        <b>Telefone:</b> <?php e($dados_pessoais->telefone); ?>
                                    </div>
                                    <div>
                                        <b>Origem do Lead:</b> <?php e($dados_pessoais->origem_lead == '' ? $empreendimento->emp_nome_fantasia : $dados_pessoais->origem_lead); ?>
                                    </div>
                                </div>
                            </div>
                            <!--Cartão VIP-->
                            <div class="card bg-light text-muted">
                                <div class="card-header">
                                    <div class="d-flex justify-content-between">
                                        <span>Cartão VIP: <span class="text-primary"><?php e($empreendimento->emp_nome_fantasia) ?> - <?php e($house->par_razao_social??''); ?></span></span>
                                        <span class="text-success">Ativo</span>
                                    </div>
                                </div>
                                <div class="card-body">
                                    <ul class="list-unstyled mb-0">
                                      <li><b>Unidade:</b> <?php e($pre_reserva->unidade??'1'); ?></li>
                                      <li><b>House:</b> <?php e($house->par_razao_social??''); ?></li>
                                      <li><b>Incorporadora:</b> <?php e($incorporadora->incorporadora??''); ?></li>
                                      <li><b>Valor:</b> <?php e(money($pre_reserva->valor_total??'0.00')); ?></li>
                                      <li><b>Data de ativação:</b> <?php e(substr(converte_datahora($dados_pessoais->datetime_captura,1),0,10)??''); ?> às <?php e(substr(converte_datahora($dados_pessoais->datetime_captura,1),13,-3)??''); ?></li>
                                    </ul>
                                </div>
                            </div>
                            <!--Acompanhamento-->
                            <div class="card text-muted mb-0">
                                <div class="card-body">
                                    <div class="card-step">
                                        <div class="row">
                                            <div class="col-md-12">
                                                <div id="progresscard">
                                                    <!-- progressbar -->
                                                    <ul id="progressbar">
                                                        <li class="active" id="account"><strong>Captura</strong></li>
                                                        <li id="personal"><strong>Agendamento</strong></li>
                                                        <li id="payment"><strong>Reserva</strong></li>
                                                        <li id="confirm"><strong>Pagamento</strong></li>
                                                    </ul> 

                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!--Ações Atendimento-->
                    <div class="list-group atend-acoes mb-4">
                      <a href="#" class="list-group-item list-group-item-action" type="button" data-toggle="modal" <?php e($id_cadastro == '' ? 'data-target="#cadastroContaComdono"' : '' );?> <?php e($id_cadastro == '' ? 'title="Criar conta"' : 'title="Já possui conta"' );?>>Criar conta Comdono</a>
                      <a href="#" class="list-group-item list-group-item-action" type="button" data-toggle="modal" data-target="#cartaovipNovo" >Novo Cartão VIP</a>
                      <a href="#" class="list-group-item list-group-item-action" type="button" <?php e($prod); ?> data-toggle="modal" data-target="#enviarInfo" >Enviar Informações</a>
                      <a href="#" class="list-group-item list-group-item-action" type="button" data-toggle="modal" data-target="#avaliarImovelDono">Avaliação do Imóvel</a>
                      <a href="#" class="list-group-item list-group-item-action btn-anunciar-imovel" type="button" data-dados_pessoais='<?php e($dados_pessoais->etapa == 8 ? json_encode($dados_pessoais) : "" ); ?>' <?php e($prod); ?> >Anúncio do Imóvel</a>
                      <a href="#" class="list-group-item list-group-item-action" type="button" data-toggle="modal" data-target="#interesseModal" ?>Anúncio de Interesse</a>
                      <a href="#" class="list-group-item list-group-item-action" type="button" <?php e($prod); ?>>Crédito Imobiliário</a>
                      

                    </div>
                </div>
                <div class="col-lg-7">
                    
                    <!--Informações de Atendimento do Lead-->
                    <div class="card">
                        <div class="card-header">
                            <div class="d-flex justify-content-between">
                                <span class="my-auto">Informações do Atendimento</span>
                                <span class="my-auto">
                                    <button type="button" class="btn btn-sm btn-secondary btn-edit-interesse">Editar</button>
                                    <button type="button" class="btn btn-sm btn-success btn-save-interesse">Salvar</button>
                                </span>
                            </div>
                        </div>
                        <div class="card-body text-muted ">
                            <form id="form-interesse">
                                <input type="hidden" name="id_captura" value="<?php e($dados_pessoais->id_captura); ?>">
                                <input type="hidden" name="id_cadastro" value="<?php e($dados_pessoais->id_cadastro); ?>">
                                <input type="hidden" name="id_responsavel" value="<?php e($fila->id_responsavel); ?>">
                                <input type="hidden" name="id_interesse" value="<?php $sem_interesse == 0 ? e($interesse['id_interesse']) : e(''); ?>">
                                <div class="row">
                                    <div class="col-sm-12">
                                        <div class="form-group row">
                                            <div class="col-6">
                                                <label for="interesse1">Qual momento do cliente?</label>
                                                <select class="form-control atendForm" id="interesse1" name="tipo_interesse">
                                                  <option value="compra" <?php $sem_interesse == 0 ? e($interesse['tipo_interesse'] == 'compra' ? 'selected' : '') : e(''); ?>>Comprar</option>
                                                  <option value="comprar e vender" <?php $sem_interesse == 0 ? e($interesse['tipo_interesse'] == 'comprar e vender' ? 'selected' : '') : e(''); ?>>Comprar e vender</option>
                                                  <option value="investir" <?php $sem_interesse == 0 ? e($interesse['tipo_interesse'] == 'investir' ? 'selected' : '') : e(''); ?>>Desistir para aluguel</option>
                                                  <option value="permultar" <?php $sem_interesse == 0 ? e($interesse['tipo_interesse'] == 'permultar' ? 'selected' : '') : e(''); ?>>Permultar</option>
                                                  <option value="pesquisando" <?php $sem_interesse == 0 ? e($interesse['tipo_interesse'] == 'pesquisando' ? 'selected' : '') : e(''); ?>>Apenas pesquisando</option>
                                                </select>
                                            </div>
                                            <div class="col-6">
                                                <label for="interesse1">Quando é o momento do cliente?</label>
                                                <select class="form-control atendForm" id="interesse1" name="momento_interesse">
                                                  <option value="Não Sabe/indeciso" <?php $sem_interesse == 0 ? e($interesse['momento_interesse'] == 'Não Sabe/indeciso' ? 'selected' : '') : e(''); ?>>Não sabe ou indeciso</option>
                                                  <option value="Até 1 Mes" <?php $sem_interesse == 0 ? e($interesse['momento_interesse'] == 'Até 1 Mes' ? 'selected' : '') : e(''); ?>>Em Até um mes</option>
                                                  <option value="Em Alguns Meses" <?php $sem_interesse == 0 ? e($interesse['momento_interesse'] == 'Em Alguns Meses' ? 'selected' : '') : e(''); ?>>Em Alguns Meses</option>
                                                  <option value="Em Até 1 Ano" <?php $sem_interesse == 0 ? e($interesse['momento_interesse'] == 'Em Até 1 Ano' ? 'selected' : '') : e(''); ?>>Em Até 1 Ano</option>
                                                  <option value="Apos 1 Ano" <?php $sem_interesse == 0 ? e($interesse['momento_interesse'] == 'Apos 1 Ano' ? 'selected' : '') : e(''); ?>>Apos 1 Ano</option>
                                                </select>
                                            </div>
                                            <div class="col-6">
                                                <label for="onde1">Onde mora?</label>
                                                <input class="form-control atendForm" id="onde1" type="text" name="onde_mora" placeholder="" value="<?php $sem_interesse == 0 ? e($interesse['onde_mora']) : e(''); ?>">
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <div class="col-6 ">
                                                <label for="onde2">Profissão</label>
                                                <input class="form-control atendForm" id="onde2" name="profissao" type="text" placeholder="" value="<?php $sem_interesse == 0 ? e($interesse['profissao']) : e(''); ?>">
                                            </div>
                                            <div class="col-6 ">
                                                <label for="onde3">Local de trabalho</label>
                                                <input class="form-control atendForm" id="onde3" name="local_trabalho" type="text" placeholder="" value="<?php $sem_interesse == 0 ? e($interesse['local_trabalho']) : e(''); ?>">
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <div class="col-6 ">
                                                <label for="onde4">Estado Civil</label>
                                                <input class="form-control atendForm" id="onde4" name="estado_civil" type="text" placeholder="" value="<?php $sem_interesse == 0 ? e($interesse['estado_civil']) : e(''); ?>">
                                            </div>
                                            <div class="col-6">
                                                <label for="onde5">Possui família em Brasília?</label>
                                                <div class="form-inline">
                                                    <div class="form-check form-check-inline mr-5 atendForm">
                                                        <input class="form-check-input atendForm" id="inline-radio1" type="radio" name="possui_familia_brasilia" value="1" <?php $sem_interesse == 0 ? e($interesse['possui_familia_brasilia'] == '1' ? 'checked' : '' ) : e('');?>>
                                                        <label class="form-check-label font-weight-normal" for="inline-radio1">Sim</label>
                                                    </div>
                                                    <div class="form-check form-check-inline mr-5 atendForm">
                                                        <input class="form-check-input atendForm" id="inline-radio2" type="radio" name="possui_familia_brasilia" value="0" <?php $sem_interesse == 0 ? e($interesse['possui_familia_brasilia'] == '0' ? 'checked' : '' ) : e('');?>>
                                                        <label class="form-check-label font-weight-normal" for="inline-radio2">Não</label>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group row mb-0">
                                            <div class="col-6">
                                                <label for="onde6">Tem imóveil próprio?*</label>
                                                <div class="form-inline">
                                                    <div class="form-check form-check-inline mr-5 atendForm">
                                                        <input class="form-check-input atendForm" id="inline-radio1" type="radio" name="possui_imovel" value="1" <?php $sem_interesse == 0 ? e($interesse['possui_imovel'] == '1' ? 'checked' : '' ) : e('');?>>
                                                        <label class="form-check-label font-weight-normal" for="inline-radio1">Sim</label>
                                                    </div>
                                                    <div class="form-check form-check-inline mr-5 atendForm">
                                                        <input class="form-check-input atendForm" id="inline-radio2" type="radio" name="possui_imovel" value="0" <?php $sem_interesse == 0 ? e($interesse['possui_imovel'] == '0' ? 'checked' : '' ) : e('');?>>
                                                        <label class="form-check-label font-weight-normal" for="inline-radio2">Não</label>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-6">
                                                <label for="name">Quer vender?*</label>
                                                <div class="form-inline">
                                                    <div class="form-check form-check-inline mr-5">
                                                        <input class="form-check-input atendForm" id="inline-radio1" type="radio" name="imovel_venda" value="1" <?php $sem_interesse == 0 ? e($interesse['imovel_venda'] == '1' ? 'checked' : '' ) : e('');?>>
                                                        <label class="form-check-label font-weight-normal" for="inline-radio1">Sim</label>
                                                    </div>
                                                    <div class="form-check form-check-inline mr-5">
                                                        <input class="form-check-input atendForm" id="inline-radio2" type="radio" name="imovel_venda" value="0" <?php $sem_interesse == 0 ? e($interesse['imovel_venda'] == '0' ? 'checked' : '' ) : e('');?>>
                                                        <label class="form-check-label font-weight-normal" for="inline-radio2">Não</label>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </form>
                            <div class="resultado_interesse mt-4"></div>
                        </div>
                    </div>
                    
                    <!--Card Atendimento Descrição-->
                    <div class="card">     
                        <div class="card-header">
                            <div class="d-flex justify-content-between">
                                <span class="my-auto mr-2">Descrição</span>
                                <br>
                                <span class="my-auto">
                                    <button type="button" class="btn btn-sm btn-secondary btn-edit-descricao">Editar</button>
                                    <button type="button" class="btn btn-sm btn-success btn-save-descricao">Salvar</button>
                                </span>
                            </div>
                        </div>
                        <div class="card-body text-muted">
                            <form id="form-descricao">  
                            <input type="hidden" name="id_fila" value="<?php e($fila->id_fila); ?>">
                            <input type="hidden" name="id_responsavel" value="<?php e($this->session->id_cadastro); ?>">
                            <input type="hidden" name="id_empreendimento" value="<?php e($empreendimento->id_empreendimento); ?>">
                                <div class="form">
                                    <textarea class="form-control descricaoForm"style="resize: none;" name="descricao" id="descricao1" rows="3"></textarea>
                                </div>
                            </form>
                            
                            <div class="resultado_descricao mt-4"></div>
                        </div>
                    </div>
                    
                    <!-- Card Atendimento Lista de Descrições -->
                    <div class="card">
                        <h5 class="card-header">Últimas descrições - Empreendimento: <?php e($empreendimento->emp_nome_fantasia) ?></h5>
                        <div class="card-body" style="overflow-y: scroll;max-height: 350px;">
                            <?php if(!empty($descricoes)){ ?>
                            <div class="row">
                                <div class="col-lg-12">
                                    <div id="accordion" role="tablist">
                                        <?php $i = 1; foreach($descricoes as $descricao){ ?>
                                        <div class="card card-accent-info">
                                            <div class="card-header" id="heading-<?php e($i); ?>" role="tab">
                                                <h5 class="mb-0">
                                                <a data-toggle="collapse" href="#collapse-<?php e($i); ?>" aria-expanded="true" aria-controls="collapse-<?php e($i); ?>" class="collapsed">
                                                    <?php e(date('d/m/Y - H:i:s', strtotime($descricao->data_hora))); ?>
                                                </a>
                                                </h5>
                                            </div>
                                            <div class="collapse" id="collapse-<?php e($i); ?>" role="tabpanel" aria-labelledby="heading-<?php e($i); ?>" data-parent="#accordion" style="">
                                                <div class="card-body" >
                                                    <div class="row">
                                                        <div class="col-lg-12">
                                                            <div class="form-group">
                                                                <label class="control-label">Atendente</label>
                                                                <input type="text" name="atendente" value="<?php e($descricao->atendente); ?>" class="form-control" readonly="readonly">
                                                            </div>
                                                            <div class="form-group">
                                                                <label class="control-label">Descrição</label>
                                                                <textarea name="observacao" class="form-control" rows="3" readonly="readonly"><?php e(strip_tags($descricao->descricao)); ?></textarea>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <?php $i++; } ?>
                                    </div>
                                </div>
                            </div>
                            <?php }else{ ?>
                            <div class="row">
                                <div class="col-lg-12">
                                    <p>Ainda não houve descrições nesse atendimento</p>
                                </div>
                            </div>
                            <?php } ?>
                        </div>
                    </div>
                    
                    <!--Agendamentos-->
                    <div class="card mb-0">
                        <div class="card-header">
                            <div class="d-flex justify-content-between align-items-center">
                                <span>Agendamentos</span>
                                <?php if($flag_agenda == true){ ?>
                                  <button type="button" class="btn btn-sm btn-primary float-right" data-toggle="modal" data-target="#agendaModal">Adicionar visita <i class="fa fa-plus ml-1" aria-hidden="true"></i></button>
                                <?php } ?>
                            </div>
                        </div>
                        <div class="card-body text-muted" style="max-height: 200px;overflow-y: scroll;">
                            <div class="container">
                                <?php foreach((array_reverse($agendas)) as $age){ ?>   
                        		<div class="row row-striped">
                        			<div class="col-2 text-right">
                        				<h1 class="display-4"><a href="#" data-toggle="modal" <?php e($age->status_agenda == 0 ? 'class="alterarVisita"' : '' );?> data-id_agenda="<?php e($age->id_agenda); ?>"><span class="badge badge-secondary image_dia_mes_agendamento"><?php e(substr(converte_datahora($age->data_hora_agendamento,1),0,2)); ?></span></a></h1>
                        			</div>
</a>                        			<div class="col-10 mt-3">
                        				<h5 class="text-uppercase"><strong>Visita  <?php e($age->tipo_agendamento == '1' ? 'Presencial' : 'Virtual'); ?></strong></h5>
                        				<ul class="list-inline">
                        				    <li class="list-inline-item"><i class="fa fa-calendar-o" aria-hidden="true"></i> <span class="dia_semana_agend_visita"><?php e($age->data_dia_semana) ?></span></li>
                        					<li class="list-inline-item"><i class="fa fa-clock-o" aria-hidden="true"></i> <?php e(substr(converte_datahora($age->data_hora_agendamento,1),0,-3)); ?></li>
                        					<li class="list-inline-item"><i class="fa fa-location-arrow" aria-hidden="true"></i> <?php e($age->responsavel); ?></li>
                        				    <?php e('<li class="list-inline-item"><i class="fa fa-'.HAgenda::status($age->status_agenda)->icon.'" aria-hidden="true"></i>'.HAgenda::status($age->status_agenda)->text.'</li>') ?>
                        				    <?php if (in_array($age->status_agenda,[5,9]) && $age->justificativa != ''): ?>
                        				        <li class="list-inline-item">Justificativa: <?php e($age->justificativa) ?></li>
                        				    <?php endif; ?>
                        				    <?php if (in_array($age->status_agenda,[1]) && $age->motivo_agenda != ''): ?>
                        				        <li class="list-inline-item">Justificativa: <?php e($age->motivo_agenda) ?></li>
                        				    <?php endif; ?>
                        				</ul>
                        				
                        			</div>
                        		</div>
                        		<?php } ?>
                        	</div>
                        </div>
                    </div>
                </div>
            </div>
    </div>
</div>
<!-- Histórico -->
<div class="row">
    <div class="col-md-12 mb-5">
        <hr>
        <div class="card-body p-0">
            <ul class="nav nav-tabs" id="historico1Tab1" role="tablist">
                <li class="nav-item">
                    <a class="nav-link active" id="historico1-tab" data-toggle="tab" href="#historico1" role="tab" aria-controls="historico1" aria-selected="true">Histórico do Lead</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" id="profile-tab" data-toggle="tab" href="#profile" role="tab" aria-controls="profile" aria-selected="false">Histórico de Atendimentos</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" id="interesse-tab" data-toggle="tab" href="#interesse" role="tab" aria-controls="interesse" aria-selected="false">Histórico de Interesses</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" id="avaliacao-tab" data-toggle="tab" href="#avaliacao" role="tab" aria-controls="avaliacao" aria-selected="false">Histórico de Avaliações</a>
                </li>
            </ul>
            <div class="tab-content" id="myTab1Content">
                <div class="tab-pane fade show active" id="historico1" role="tabpanel" aria-labelledby="historico1-tab">
                    <div class="d-none">
                        <form class="filtrar-historico-lead text-dark form-inline justify-content-end">
                            <label class="font-weight-normal mr-2" for="inputEmpreendimento">Data e Hora:</label>
                            <input type="hidden" name="email" value="<?php e($dados_pessoais->email)?>">
                            <input name="date" type="date" class="form-control" style="max-width: 150px;" placeholder="dd/mm/ano">  
                        </form> 
                        <button type="button" class="btn btn-primary my-auto btn-filtrar-historico-lead">Filtrar</button>
                    </div>
                    <hr>
                    <table class="display table table-striped table-bordered" style="width:100%">
                        <thead>
                            <tr>
                                <th>Origem captura</th>
                                <th>Dat  a captura</th>
                                <th>Nome</th>
                                <th>E-mail</th>
                                <!--<th>telefone</th>-->
                                <th>cpf</th>
                            </tr>
                        </thead>
                        <tbody id="tabela-historico-lead">
                            <?php if(!empty($capturas)){ ?>
                                <?php foreach($capturas as $captura) { ?>
                                <tr>
                                    <td><?php e($captura->origem_captura); ?></td>
                                    <td><?php e(converte_datahora($captura->datetime_captura,1)); ?></td>
                                    <td><?php e($captura->nome); ?></td>
                                    <td><?php e($captura->email); ?></td>
                                    <!--<td><?php e($captura->telefone); ?></td>-->
                                    <td><?php e($captura->cpf); ?></td>
                                </tr>
                                <?php } ?>
                            <?php } ?>
                        </tbody>
                    </table> 
                </div>
                
                
                <div class="tab-pane fade" id="profile" role="tabpanel" aria-labelledby="profile-tab">
                    
                    <form class="form-inline justify-content-end d-none">
                    
                        <label class="font-weight-normal mr-2" for="inputEmpreendimento">Data e Hora:</label>
                      
                        <div class="input-group date dateTimeAgenda mr-2">
                            <div class="input-group-prepend">
                                <div class="input-group-text input-group-addon">
                                  <i class="fa fa-calendar" aria-hidden="true"></i>
                                </div>
                            </div>
                            <input type="text" class="form-control" style="max-width: 120px;"  id="dataHistorico" placeholder="dd/mm/ano">
                         </div>
                         
                         
                        <button type="submit" class="btn btn-primary my-auto">Filtrar</button>
                        
                    </form>
                    <hr>
                    <table class="table table-striped table-bordered table-responsive-xl">
                      <thead>
                        <tr>
                          <th scope="col">Data de entrada</th>
                          <th scope="col">Último Atendimento</th>
                          <th scope="col">Último Contato Meio</th>
                          <th scope="col">Próximo Atendimento</th>
                          <th scope="col">Próximo Contato Motivo</th>
                          <th scope="col">Atendente</th>
                          <th scope="col">Observação</th>
                          <th scope="col">Status</th>
                          <th scope="col">Ações</th>
                        </tr>
                      </thead>
                      <tbody>
                        <?php if(!empty($atendimentos)){ ?>
                            <?php foreach($atendimentos as $atend) { ?>
                                <tr>
                                  <td><?php e(converte_datahora($atend->data_hora,1)); ?></td>
                                  <td><?php e(converte_datahora($atend->ultimo_contato,1)); ?></td>
                                  <td><?php e($atend->ultimo_contato_tipo); ?></td>
                                  <td><?php e(converte_datahora($atend->proximo_contato,1)); ?></td>
                                  <td><?php e($atend->proximo_contato_motivo); ?></td>
                                  <td><?php e($atend->atendente); ?></td>
                                  <td><?php e($atend->observacao); ?></td>
                                  <td><?php e($atend->status_jornada); ?><span class="badge badge-success">Ativo</span></td>
                                  <td><button class="btn btn-sm btn-primary mr-1 set_leed" data-id="1034" data-toggle="modal" data-target="#atendimentoRapidoModal" data-original-title="Atendimento rápido"><i class="icon-plus"></i></button>
                                  </td>
                                </tr>
                            <?php } ?>
                        <?php } ?>
                      </tbody>
                    </table>                 
                </div>
                
                <div class="tab-pane fade" id="interesse" role="tabpanel" aria-labelledby="interesse-tab">
                    
                    <form class="form-inline justify-content-end d-none">
                    
                        <label class="font-weight-normal mr-2" for="inputEmpreendimento">Data e Hora:</label>
                      
                        <div class="input-group date dateTimeAgenda mr-2">
                            <div class="input-group-prepend">
                                <div class="input-group-text input-group-addon">
                                  <i class="fa fa-calendar" aria-hidden="true"></i>
                                </div>
                            </div>
                            <input type="text" class="form-control" style="max-width: 120px;"  id="dataHistorico" placeholder="dd/mm/ano">
                         </div>
                         
                         
                        <button type="submit" class="btn btn-primary my-auto">Filtrar</button>
                        
                    </form>
                    <hr>
                    <table id="historico_interesse_table" class="display table table-striped table-bordered" style="width:100%">
                        <thead>
                            <tr>
                                <th>Interesse em</th>
                                <th>Tipo de imovel</th>
                                <th>Tipo de empreendimento</th>
                                <th>Faixa de Preço</th>
                                <th>Momento</th>
                                <th>Bairros</th>
                                <th>Quartos</th>
                                <th>Descrição</th>
                                <th>Ações</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach($interesses as $inter) { ?>
                            <?php if($inter->ativo == 1 && $inter->interesse_painel_cs == 0) { ?>
                            <tr class="trData" >
                              <td><?php e($inter->tipo_interesse) ?></td>
                              <td><?php e($inter->tipo_imovel) ?></td>
                              <td><?php foreach($inter->tipo_emp as $tipo_emp){ ?><span class="badge badge-secondary"><?php echo $tipo_emp->tipo_emp; ?></span> <?php } ?></td>
                              <td><?php e(money($inter->faixa_preco_inicio) . ' a ' . money($inter->faixa_preco_fim)) ?></td>
                              <td><?php e($inter->momento_interesse) ?></td>
                              <td><?php foreach($inter->bairros as $bairro){ ?><span class="badge badge-secondary"><?php echo $bairro->bairro; ?></span> <?php } ?></td>
                              <td><?php e($inter->quartos) ?></td>
                              <td><?php e($inter->descricao) ?></td>
                              <td>
                                  <a href="<?php e(base_url('atendimento/interesse/visualizar/'.$inter->id_interesse)) ?>" target="_blank" class="btn btn-outline-primary" data-toggle="tooltip" data-original-title="Visualizar"><i class="fa fa-eye" aria-hidden="true"></i></a>
                                  <button class="btn btn-outline-warning btn_editar_interesse" data-toggle="tooltip" data-original-title="Editar" data-interesse='<?php e(json_encode($inter)); ?>'><i class="fa fa-pencil" aria-hidden="true"></i></button>
                                  <button class="btn btn-outline-danger btn_excluir_interesse" data-toggle="tooltip" data-original-title="Excluir" data-interesse="<?php e($inter->id_interesse); ?>"><i class="fa fa-times" aria-hidden="true"></i></button>
                              </td>
                            </tr>
                            <?php } } ?>
                        </tbody>
                    </table>                 
                </div>
                
                <div class="tab-pane fade" id="avaliacao" role="tabpanel" aria-labelledby="avaliacao-tab">
                    
                    <form class="form-inline justify-content-end d-none">
                    
                        <label class="font-weight-normal mr-2" for="inputEmpreendimento">Data e Hora:</label>
                      
                        <div class="input-group date dateTimeAgenda mr-2">
                            <div class="input-group-prepend">
                                <div class="input-group-text input-group-addon">
                                  <i class="fa fa-calendar" aria-hidden="true"></i>
                                </div>
                            </div>
                            <input type="text" class="form-control" style="max-width: 120px;"  id="dataHistorico" placeholder="dd/mm/ano">
                         </div>
                         
                         
                        <button type="submit" class="btn btn-primary my-auto">Filtrar</button>
                        
                    </form>
                    <hr>
                    <table id="historico_avaliacao_table" class="display table table-striped table-bordered" style="width:100%">
                        <thead>
                            <tr>
                                <th>Nome</th>
                                <th>Email</th>
                                <th>CEP</th>
                                <th>Bairro</th>
                                <th>Cidade</th>
                                <th>Estado</th>
                                <th>Tipo Imóvel</th>
                                <th>Avalização</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach($avaliacoes as $aval) { ?>
                            <?php if($aval->key_captura != '') { ?>
                            <tr class="trData" >
                              <td><?php e($aval->nome) ?></td>
                              <td><?php e($aval->email) ?></td>
                              <td><?php e($aval->cep) ?></td>
                              <td><?php e($aval->bairro) ?></td>
                              <td><?php e($aval->cidade) ?></td>
                              <td><?php e($aval->estado) ?></td>
                              <td><?php e($aval->tipo_imovel) ?></td>
                              <td>
                                  <a href="<?php e(base_url().'avaliacao/resultado/'.$aval->key_captura) ?>" target="_blank" class="btn btn-outline-primary" data-toggle="tooltip" data-original-title="Visualizar o Resultado da Avaliação"><i class="fa fa-eye" aria-hidden="true" ></i></a>
                                  <button class="btn btn-outline-warning btn_enviar_avaliacao" data-toggle="tooltip" data-original-title="Enviar por Email a Avaliação" data-cap='<?php e(json_encode($aval)); ?>'><i class="fa fa-envelope-o" aria-hidden="true"></i></button>
                              </td>
                            </tr>
                            <?php } } ?>
                        </tbody>
                    </table>                 
                </div>
            </div>
        </div>        
    </div>    
</div>    

<!-- Modal --> 
<div class="modal fade" id="interesseModal" tabindex="-1" role="dialog" aria-labelledby="interesseModal" aria-hidden="true">
<div class="modal-dialog modal-dialog-centered" style="max-width: 1000px;" role="document">
<div class="modal-content">
  <div class="modal-header">
    <h4 class="modal-title" id="exampleModalLabel">Anunciar Interesse</h4>
    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
      <span aria-hidden="true">&times;</span>
    </button>
  </div>
  <div class="modal-body">
    <div class="row">
        <div class="col-md-6">
            <form class="text-dark form-anunciar-interesse">
                
                <input type="hidden" name="id_captura" value="<?php e($dados_pessoais->id_captura) ?>">
                <input type="hidden" name="id_cadastro" value="<?php e($id_cadastro) ?>">
                <input type="hidden" name="email" value="<?php e($dados_pessoais->email) ?>">
                
                <div class="form-group row">
                    <div class="col-6">
                       <label for="interessadoEM">Interessado em:</label>
                        <select name="tipo_interesse" class="form-control interForm" id="interessadoEM">
                          <option value="compra" <?php e(($interesseP->tipo_interesse??'') == 'compra' ? 'selected' : '') ?>>Comprar</option>
                          <option value="venda" <?php e(($interesseP->tipo_interesse??'') == 'venda' ? 'selected' : '') ?>>Vender</option>
                          <option value="comprar e vender" <?php e(($interesseP->tipo_interesse??'') == 'comprar e vender' ? 'selected' : '') ?>>Comprar e vender</option>
                        </select> 
                    </div>
                  <div class="col-6">
                        <label for="interesse1">Tipo de imóvel</label>
                        <select name="tipo_imovel" id="tipo_imovel" class="form-control">
                            <option value="">Todos</option>
                            <?php
                                foreach (HBusca::getSelectTiposImovel() as $grupo=>$options)
                                {
                                    echo("<optgroup label='$grupo'>");
                                    foreach ($options as $value=>$text)
                                    {
                                        $selected = '';
                                        if($value == ($interesseP->tipo_imovel??''))
                                            $selected = 'selected';
                                        echo("<option value='$value' $selected >$text</option>");
                                    }
                                    echo("</optgroup>");
                                }
                            ?>
                        </select>
                  </div>
                    
                </div>
                <div class="form-group row">
                    <div class="col-4">
                        <label for="interesse2">Quartos</label>
                        <select name="quartos" class="form-control interForm" id="interesse2">
                          <option <?php e(($interesseP->quartos??'') == 0 ? 'selected' : '') ?>>0</option>
                          <option <?php e(($interesseP->quartos??'') == 1 ? 'selected' : '') ?>>1</option>
                          <option <?php e(($interesseP->quartos??'') == 2 ? 'selected' : '') ?>>2</option>
                          <option <?php e(($interesseP->quartos??'') == 3 ? 'selected' : '') ?>>3</option>
                          <option value="4" <?php e(($interesseP->quartos??'') == 4 ? 'selected' : '') ?>>4 ou +</option>
                        </select>
                    </div>
                    <div class="col-4">
                        <label for="interesse3" class="col-form-label">Banheiros:</label>
                        <select name="banheiro" class="form-control interForm" id="interesse3">
                          <option <?php e(($interesseP->banheiro??'') == 0 ? 'selected' : '') ?>>0</option>
                          <option <?php e(($interesseP->banheiro??'') == 1 ? 'selected' : '') ?>>1</option>
                          <option <?php e(($interesseP->banheiro??'') == 2 ? 'selected' : '') ?>>2</option>
                          <option <?php e(($interesseP->banheiro??'') == 3 ? 'selected' : '') ?>>3</option>
                          <option value="4" <?php e(($interesseP->banheiro??'') == 4 ? 'selected' : '') ?>>4 ou +</option>
                        </select>                                
                    </div>  
                    <div class="col-4">
                        <label for="interesse4" class="col-form-label">Vagas:</label>
                        <select name="vagas" class="form-control interForm" id="interesse4">
                          <option <?php e(($interesseP->vagas??'') == 0 ? 'selected' : '') ?>>0</option>
                          <option <?php e(($interesseP->vagas??'') == 1 ? 'selected' : '') ?>>1</option>
                          <option <?php e(($interesseP->vagas??'') == 2 ? 'selected' : '') ?>>2</option>
                          <option <?php e(($interesseP->vagas??'') == 3 ? 'selected' : '') ?>>3</option>
                          <option value="4" <?php e(($interesseP->vagas??'') == 4 ? 'selected' : '') ?>>4 ou +</option>
                        </select>                                    
                    </div> 
                </div>
                <div class="form-group">
                    <label for="interesse55" class="col-form-label">Tipo de empreendimento:</label>
                    <select class="form-control interForm tipo_emp_anunciar_interesse" name="tipo_emp_cliente[]" multiple="multiple" id="interesse55">
                      <option value="pronto" <?php e(in_array('pronto',($interesseP_tipo_emp??[])) ? 'selected' : '') ?>>Pronto</option>
                      <option value="lancamento" <?php e(in_array('lancamento',($interesseP_tipo_emp??[])) ? 'selected' : '') ?>>Lançamento</option>
                      <option value="Terreno" <?php e(in_array('Terreno',($interesseP_tipo_emp??[])) ? 'selected' : '') ?>>Terreno</option>
                    </select>
                </div>
                <div class="form-group">
                    <label for="interesse5" class="col-form-label">Bairro:</label>
                    <?php $bairros = HBairros::getSelect2()->items;  ?>
                    <select class="form-control interForm bairro_anunciar_interesse" name="bairro[]" multiple="multiple" id="interesse5">
                      <option value="Brasília" <?php e(in_array('Brasília',($interesseP_bairros??[])) ? 'selected' : '')?> >Brasília</option>
                        <?php foreach($bairros as $b){ ?>
                            <option value="<?php e($b->id) ?>" <?php e(in_array($b->id,($interesseP_bairros??[])) ? 'selected' : '')?> ><?php e($b->text) ?></option> 
                        <?php } ?>
                    </select>
                </div>  
                <div class="form-group">
                    <label for="interesse6" class="col-form-label">Faixa de preço:</label>
                    <div class="row">
                        <div class="col-6 d-flex align-items-center pr-2">
                            De
                            <input name="faixa_preco_inicio" type="text" class="form-control ml-2 interForm faixa_preco_anunciar_interesse" id="interesse6" value="<?php e(($interesseP->faixa_preco_inicio??'')) ?>">
                        </div>
                        <div class="col-6 d-flex align-items-center pl-0">
                            até
                            <input name="faixa_preco_fim" type="text" class="form-control ml-2 interForm faixa_preco_anunciar_interesse" id="interesse6" value="<?php e(($interesseP->faixa_preco_fim??'')) ?>">
                        </div>
                    </div>
                </div>
                <div class="form-group">
                    <label for="exampleFormControlTextarea1">Descrição</label>
                    <textarea name="descricao" class="form-control interForm" style="resize: none;" id="exampleFormControlTextarea1" rows="2"><?php e(($interesseP->descricao??'')) ?></textarea>
                </div>
                <!--
                <div class="form-group">
                    <label for="deseja_enviar_email_checkbox">Deseja enviar Email com os imóveis do Interesse?</label>
                    <div class="form-inline deseja_enviar_email_checkbox">
                        <div class="form-check form-check-inline mr-5">
                            <input class="form-check-input" type="radio" name="deseja_enviar_email_anunciar_inter" value="1">
                            <label class="form-check-label font-weight-normal" for="inline-radio1">Sim</label>
                        </div>
                        <div class="form-check form-check-inline mr-5">
                            <input class="form-check-input" type="radio" name="deseja_enviar_email_anunciar_inter" value="0" checked>
                            <label class="form-check-label font-weight-normal" for="inline-radio2">Não</label>
                        </div>
                    </div>
                </div>-->
                <div class="row">
                            <div class="col">
                                <button type="button" class="btn btn-block btn-outline-success salvarInterPainel">Salvar</button>
                            </div>
                            <div class="col">
                                 <button type="button" class="btn btn-block btn-outline-success getSugestoesImoveisPainel">Sugestões</button>
                            </div>
                        </div>
                <div class="resultado_anunciar_interesse"></div>
                
                <div class="result_envio_anunciar_interesse"></div>
            </form>
        </div>
        <div class="col-md-6">
            <div class="card bg-light h-100">
                <div class="card-header">
                        <h5>Sugestões de imóveis</h5>
                        <p>Foram encontrados <b class="cont_imoveis_sugestoes"> 0 </b> imóveis para essas especificações</p>
                        <div class="float-right">
                            <label for="checkbox_sugestoes_imoveis_todos">Selecionar Todos</label>
                            <input type="checkbox" class="checkbox_sugestoes_imoveis_todos" >
                        </div>
                </div>
                <div class="card-body pb-0" id="card-interesse-sujestao">
                    <!--<div class="card-text text-muted">
                    <h5>Sugestões de imóveis</h5>
                    
                    </div>-->
                    
                </div>
                
                <div class="card-footer">
                    <div class="row">
                        <div class="col-md-6">    
                            <button class="btn btn-block btn-success btn-enviar-whats-anunciar-interessePainelcs" type="button" data-telefone="<?php e($dados_pessoais->telefone); ?>" data-toggle="tooltip" data-placement="top" title="Contactar a TI para Liberar a Função">Enviar whatsapp</button>
                        </div>
                        <div class="col-md-6">
                            <button class="btn btn-block btn-primary btn-enviar-email-anunciar-interessePainelcs" type="button" data-email="<?php e($dados_pessoais->email); ?>">Enviar E-mail</button>
                        </div>
                    </div>
                </div>
                
                <div class="result_envia_whats_interesse"></div>
            </div> 
        </div>
    </div>  
  </div>
</div>
</div>
</div> 
<!-- Modal --> 
<div class="modal fade" id="agendaModal" tabindex="-1" role="dialog" aria-labelledby="agendaModal" aria-hidden="true">
<div class="modal-dialog modal-dialog-centered" role="document">
<div class="modal-content">
  <div class="modal-header">
    <div class="d-flex">
        <h4 class="my-auto mr-2">Agendamento de visita: </h4><h4 class="my-auto text-primary"><?php e($empreendimento->emp_nome_fantasia) ?> - <?php e($house->par_razao_social??''); ?></h4>
    </div>
    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
      <span aria-hidden="true">&times;</span>
    </button>
  </div>
  <div class="modal-body">
   <form class="add-visita text-dark">
        <div class="form-group">
            <input type="hidden" name="data_hora_agendamento"   id="data_hora_agendamento" value="">
            <input type="hidden" name="id_parceiro"      id="id_origem" value="<?php e($parceiro->id_parceiro) ?>">
            <input type="hidden" name="id_participantes[]" id="id_participantes" value="<?php e($incorporadora->id_responsavel) ?>">
            <input type="hidden" name="origem"           id="origem" value="4">
            <input type="hidden" name="id_origem"        id="id_origem" value="<?php e($dados_pessoais->id_captura) ?>">
            <input type="hidden" name="destino"          id="destino" value="1">
            <input type="hidden" name="id_destino"       id="id_destino" value="<?php e($empreendimento->id_empreendimento) ?>">
            <input type="hidden" name="id_interessado"   id="id_interessado" value="<?php e($dados_pessoais->id_cadastro) ?>">
            <label for="tipoEvento">Tipo de visita:</label>
            <select class="form-control" name="tipo_agendamento" id="tipo_agendamento">
              <option value="1">Visita presencial</option>
              <option value="2">Visita virtual</option>
            </select>
        </div>
        <div class="form-group row">
          <div class="col-6">
            <label for="melhordia" class="col-form-label">Melhor dia:</label>
            <div id="datetimepicker"><input type="text" name="data" class="form-control"></div>
            
          </div>   
          <div class="col-6">
            <label for="melhorhora1" class="col-form-label">Melhor hora:</label>
            <div class="card-body card-scroll container-items horariosDisponiveis" style="max-height: 255px;"></div>
          </div>  
          
          <input type="hidden" name="data_hora_agendamento" value="">
          
       </div>
      <div class="form-group">
        <label for="observação1" class="col-form-label">Observação:</label>
        <textarea class="form-control" name="descricao_agenda" id="observação1"></textarea>
      </div>
      
      <div class="resultado_agendar_visita"></div>
    </form>
  </div>
  <div class="modal-footer">
    <button type="button" class="btn btn-primary btn-add-visita">Salvar agendamento</button>
  </div>
</div>
</div>
</div>
<!-- Modal --> 
<div class="modal fade" id="cartaovipNovo" tabindex="-1" role="dialog" aria-labelledby="cartaovipNovo" aria-hidden="true">
          <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
              <div class="modal-header">
                <h4 class="modal-title text-muted" id="exampleModalLabel">Cadastro de Cartão VIP</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                  <span aria-hidden="true">&times;</span>
                </button>
              </div>
              <div class="modal-body">
                <form class="text-dark form-modal-criar-cvip">
                   
                   <input type="hidden" name="id_cadastro" value="<?php e($dados_pessoais->id_cadastro) ?>"/>
                   
                    <div class="form-group row">
                        <div class="col-8">
                            <label for="nomeVIP">Nome completo:</label>
                            <input name="nome" type="text" class="form-control vipForm" value="<?php e($dados_pessoais->nome) ?>" id="nomeVIP">
                        </div>
                        <div class="col-4">
                            <label for="cpfVIP">CPF:</label>
                            <input name="cpf" type="text" class="form-control vipForm" value="<?php e($dados_pessoais->cpf) ?>" id="cpfVIP">
                        </div>
                    </div>  
                    <div class="form-group row">
                        <div class="col-7">
                            <label for="emailVIP">Email:</label>
                            <input name="email" type="text" class="form-control vipForm" value="<?php e($dados_pessoais->email) ?>" id="emailVIP">
                        </div>
                        <div class="col-5">
                            <label for="telefoneVIP">Telefone:</label>
                            <input name="telefone" type="text" class="form-control vipForm" value="<?php e($dados_pessoais->telefone) ?>" id="telefoneVIP">
                        </div>
                    </div>  
                    <div class="form-group row">
                        <div class="col-4">
                            <label for="conjugeVIP">Possui cônjuge?</label>
                            <div class="form-inline">
                                <div class="form-check form-check-inline mr-5">
                                    <input class="form-check-input vipForm" id="inline-radio1" type="radio" value="Sim" name="possui_conjuje" <?php e($dados_pessoais->possui_conjuje == 'Sim' ? 'checked' : '' );?>>
                                    <label class="form-check-label font-weight-normal" for="inline-radio1">Sim</label>
                                </div>
                                <div class="form-check form-check-inline mr-2">
                                    <input class="form-check-input vipForm" id="inline-radio2" type="radio" value="Não" name="possui_conjuje" <?php e($dados_pessoais->possui_conjuje == 'Não' ? 'checked' : '' );?>>
                                    <label class="form-check-label font-weight-normal" for="inline-radio2">Não</label>
                                </div>
                            </div>
                        </div>
    
                    </div>
                    <div class="form-group row" id="cadastra-cartao-conjuje" style="<?php e($dados_pessoais->possui_conjuje == 'Não' ? 'display: none;' : '' );?>">
                        <div class="col-8">
                            <label for="nomeconjVIP">Nome completo do cônjuge:</label>
                            <input name="nome_conjuje" type="text" class="form-control vipForm" value="<?php e($dados_pessoais->nome_conjuje) ?>" id="nomeconjVIP">                                    
                        </div>                    
                        <div class="col-6">
                            <label for="cpfconjVIP">CPF do cônjuge:</label>
                            <input name="cpf_conjuje" type="text" class="form-control vipForm" value="<?php e($dados_pessoais->cpf_conjuje) ?>" id="cpfconjVIP">
                        </div>
                        <div class="col-6">
                            <label for="telefoneconjVIP">Telefone do cônjuge:</label>
                            <input name="telefone_conjuge" type="text" class="form-control vipForm" value="<?php e($dados_pessoais->telefone_conjuge) ?>" id="telefoneconjVIP">
                        </div>
                    </div>
                    <hr>
                    <div class="form-group row">
                        <div class="col-6">
                              <div class="form-group">
                                <label for="exampleFormControlSelect1">Empreendimento escolhido:</label>
                                <select class="form-control select_emp_add_cartao" name="emp_nome_fantasia" id="exampleFormControlSelect1">
                                    <option>Selecione</option>
                                    <?php foreach($empreendimentos as $emp) { ?>
                                        <option value="<?php e($emp->id_empreendimento) ?>"><?php e($emp->emp_nome_fantasia) ?></option>
                                    <?php } ?>
                                </select>
                              </div>
                        </div>
                        <div class="col-6 result_unidades">
                            
                        </div>
                    </div>                            

                   <div class="resultado_criar_cvip"></div>
                   
                </form>
              </div>
              <div class="modal-footer">
                <button type="button" class="btn btn-block btn-outline-success btn-criar-cartao-vip">Salvar</button>
              </div>
            </div>
          </div>
        </div>
<!-- Modal --> 
<div class="modal fade" id="cadastroContaComdono" tabindex="-1" role="dialog" aria-labelledby="cadastroContaComdono" aria-hidden="true">
          <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
              <div class="modal-header">
                <h4 class="modal-title text-muted" id="exampleModalLabel">Cadastrar Conta Comdono</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                  <span aria-hidden="true">&times;</span>
                </button>
              </div>
              <div class="modal-body">
                <form class="text-dark form-modal-criar-conta-comdono">
                    
                    <div class="form-group row">
                        <div class="col-8">
                            <label for="nomeVIP">Nome completo:</label>
                            <input name="nome" type="text" class="form-control" value="">
                        </div>
                    </div>  
                    <div class="form-group row">
                        <div class="col-7">
                            <label for="emailVIP">Email:</label>
                            <input name="email" type="text" class="form-control" value="" >
                        </div>
                        <div class="col-5">
                            <label for="telefoneVIP">Telefone:</label>
                            <input name="telefone" type="text" class="form-control" value="" id="telefone_conta_comdono">
                        </div>
                    </div>  
                    
                   <div class="resultado_conta_comdono"></div>
                </form>
              </div>
              <div class="modal-footer">
                <button type="button" class="btn btn-block btn-outline-success btn-criar-conta-comdono">Cadastrar</button>
              </div>
            </div>
          </div>
        </div>            
<!-- Modal --> 
<div class="modal fade" id="cartaovipEditar" tabindex="-1" role="dialog" aria-labelledby="cartaovipNovo" aria-hidden="true">
          <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
              <div class="modal-header">
                <h4 class="modal-title text-muted" id="exampleModalLabel">Editar dados  Cartão VIP</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                  <span aria-hidden="true">&times;</span>
                </button>
              </div>
              <div class="modal-body">
                <form class="text-dark form-modal-cvip">
                    <input type="hidden" name="id_captura" value="<?php e($dados_pessoais->id_captura) ?>"/>  
                    <input type="hidden" name="id_cadastro" value="<?php e($dados_pessoais->id_cadastro) ?>"/>
                    <div class="form-group row">
                        <div class="col-8">
                            <label for="nomeVIP">Nome completo:</label>
                            <input name="nome" type="text" class="form-control" value="<?php e($dados_pessoais->nome) ?>" id="nomeVIP">
                        </div>
                        <div class="col-4">
                            <label for="cpfVIP">CPF:</label>
                            <input name="cpf" type="text" class="form-control readonly" value="<?php e($dados_pessoais->cpf) ?>" id="cpfVIP_edit" readonly>
                        </div>
                    </div>  
                    <div class="form-group row">
                        <div class="col-7">
                            <label for="emailVIP">Email:</label>
                            <input name="email" type="text" class="form-control" value="<?php e($dados_pessoais->email) ?>" id="emailVIP">
                        </div>
                        <div class="col-5">
                            <label for="telefoneVIP">Telefone:</label>
                            <input name="telefone" type="text" class="form-control" value="<?php e($dados_pessoais->telefone) ?>" id="telefoneVIP_edit">
                        </div>
                    </div>  
                    <div class="form-group row">
                        <div class="col-4">
                            <label for="conjugeVIP">Possui cônjuge?</label>
                            <div class="form-inline">
                                <div class="form-check form-check-inline mr-5">
                                    <input class="form-check-input" id="checkbox-edit-cvip" type="radio" value="Sim" name="possui_conjuje" <?php e($dados_pessoais->possui_conjuje == 'Sim' ? 'checked' : '' );?>>
                                    <label class="form-check-label font-weight-normal" for="inline-radio1">Sim</label>
                                </div>
                                <div class="form-check form-check-inline mr-2">
                                    <input class="form-check-input" id="checkbox-edit-cvip" type="radio" value="Não" name="possui_conjuje" <?php e($dados_pessoais->possui_conjuje == 'Não' ? 'checked' : '' );?>>
                                    <label class="form-check-label font-weight-normal" for="inline-radio2">Não</label>
                                </div>
                            </div>
                        </div>
                       
                        
                    </div>
                    <div class="form-group row" id="edit-cartao-conjuje" style="<?php e($dados_pessoais->possui_conjuje == 'Não' ? 'display: none;' : '' );?>">
                        <div class="col-8">
                            <label for="nomeconjVIP">Nome completo do cônjuge:</label>
                            <input name="nome_conjuje" type="text" class="form-control" value="<?php e($dados_pessoais->nome_conjuje) ?>" id="nomeconjVIP">                                    
                        </div>
                        
                        <div class="col-6">
                            <label for="cpfconjVIP">CPF do cônjuge:</label> 
                            <input name="cpf_conjuje" type="text"  class="form-control" value="<?php e($dados_pessoais->cpf_conjuje) ?>" id="cpfconjVIP_edit" readonly>
                        </div>
                        <div class="col-6">
                            <label for="telefoneconjVIP">Telefone do cônjuge:</label>
                            <input name="telefone_conjuge" type="text" class="form-control" value="<?php e($dados_pessoais->telefone_conjuge) ?>" id="telefoneconjVIP_edit">
                        </div>
                    </div>
                    <hr>
                    <div class="form-group row">
                        <div class="col-6">
                            <label for="empreVIP">Empreendimento escolhido:</label>
                            <input name="emp_nome_fantasia" type="text" class="form-control" value="<?php e($empreendimento->emp_nome_fantasia) ?>" id="empreVIP" readonly>
                        </div>
                        <div class="col-6">
                            <label for="unidadeVIP">Unidade escolhida:</label>
                            <input name="unidade" type="text" class="form-control" value="<?php e($unidade->unidade) ?>" id="unidadeVIP" readonly>
                        </div>
                    </div>                            
                    
                   <div class="resultado_cvip"></div>
                </form>
              </div>
              <div class="modal-footer">
                <button type="button" class="btn btn-block btn-outline-success btn-salvar-cartao-vip">Salvar</button>
              </div>
            </div>
          </div>
        </div>
<!-- Modal --> 
<div class="modal fade" id="concluirAtend" tabindex="-1" role="dialog" aria-labelledby="concluirAtend" aria-hidden="true">
          <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
              <div class="modal-header">
                <h4 class="modal-title" id="exampleModalLabel">Ajude-nos a melhorar o seu Dashboard!</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                  <span aria-hidden="true">&times;</span>
                </button>
              </div>
              <div class="modal-body">
                <form class="text-dark form-modal-enviar-sugestao">
                   
                    <input type="hidden" name="id_fila" value="<?php e($fila->id_fila) ?>">
                    <div class="form-group">
                        <label for="conjugeVIP">Como está sua experiência com o sistemas?</label>
                        <div class="form-inline">
                            <div class="form-check form-check-inline mr-5">
                                <input class="form-check-input" id="inline-radio1" type="radio" value="1" name="experiencia">
                                <label class="form-check-label font-weight-normal" for="inline-radio1">Boa</label>
                            </div>
                            <div class="form-check form-check-inline mr-2">
                                <input class="form-check-input" id="inline-radio2" type="radio" value="2" name="experiencia">
                                <label class="form-check-label font-weight-normal" for="inline-radio2">Ruim</label>
                            </div>
                        </div>
                    </div>
               
                    <div class="form-group">
                        <label for="descricao1">Alguma sugestão ou reclamação?</label>
                        <textarea name="sugestao" class="form-control" style="resize: none;" id="descricao1" rows="3"></textarea>
                    </div>
                   
                   <div class="resultado_enviar_sugestao"></div>
                </form>
              </div>
              <div class="modal-footer">
                    <div class="d-flex justify-content-around">
                        <div class="mx-2">
                            <button type="button" class="btn btn-block btn-primary btn-finaliza-atendimento" data-id_fila="<?php e($fila->id_fila) ?>">Finalizar Atendimento</button>
                        </div>
                        <div class="d-none">
                            <button type="button" class="btn btn-block btn-success">Próximo atendimento</button>
                        </div>
                    </div>
               
              </div>
            </div>
          </div>
        </div>
<!-- Modal --> 
<div class="modal fade" id="enviarInfo" tabindex="-1" role="dialog" aria-labelledby="concluirAtend" aria-hidden="true">
          <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
              <div class="modal-header">
                <h4 class="modal-title text-muted" id="exampleModalLabel">Enviar informações para o Lead</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                  <span aria-hidden="true">&times;</span>
                </button>
              </div>
              <div class="modal-body">
                <form class="text-dark form-envia-info">
                    <div class="row">
                        <div class="col-6">
                            <div class="form d-flex flex-column">
                                <input type="hidden" name="email" value="<?php e($dados_pessoais->email) ?>">
                                <input type="hidden" name="id_empreendimento" value="<?php e($empreendimento->id_empreendimento) ?>">
                                
                                <div class="form-group">
                                    <label for="conjugeVIP">Sobre o empreendimento</label>
                                    <select name="emp_envia_info_empreendimento" class="form-control emp_envia_info_empreendimento" id="interessadoEM">
                                      <option value="">Selecione</option>
                                      <?php foreach($empreendimentos as $emp){ ?>
                                        <option value="<?php e($emp->uuid_empreendimento) ?>"><?php e($emp->emp_nome_fantasia) ?></option>  
                                      <?php } ?>
                                    </select>                                             
                                </div>

                                
                                <div class="form-check form-check-inline emp_envia_info_book_digital">
                                    <input name="emp_envia_info_book_digital" class="form-check-input" id="gridCheck1" type="checkbox">
                                    <label class="form-check-label font-weight-normal " for="gridCheck1">Book Digital</label>
                                </div>
                                <div class="form-check form-check-inline emp_envia_info_landing_page">
                                    <input name="emp_envia_info_landing_page" class="form-check-input" id="gridCheck1" type="checkbox">
                                    <label class="form-check-label font-weight-normal" for="gridCheck1">Landing page</label>
                                </div>
                                <!--<div class="form-check form-check-inline emp_envia_info_localizacao">
                                    <input name="emp_envia_info_localizacao" class="form-check-input" id="gridCheck1" type="checkbox">
                                    <label class="form-check-label font-weight-normal " for="gridCheck1">Localização</label>
                                </div>-->
                                <div class="form-check form-check-inline emp_envia_info_localizacao_stand">
                                    <input name="emp_envia_info_localizacao_stand" class="form-check-input" id="gridCheck1" type="checkbox">
                                    <label class="form-check-label font-weight-normal " for="gridCheck1">Localização - Stand de Vendas</label>
                                </div>
                                <div class="form-check form-check-inline emp_envia_info_localizacao_emp">
                                    <input name="emp_envia_info_localizacao_emp" class="form-check-input" id="gridCheck1" type="checkbox">
                                    <label class="form-check-label font-weight-normal " for="gridCheck1">Localização - Empreendimento</label>
                                </div>
                                <!--<div class="form-check form-check-inline emp_envia_info_layout_personalizado">
                                    <input name="emp_envia_info_layout_personalizado" class="form-check-input" id="gridCheck1" type="checkbox">
                                    <label class="form-check-label font-weight-normal " for="gridCheck1">Layout Personalizado</label>
                                </div>-->
                            </div>
                        </div>
                        <hr width = “2” size = “100”>
                        <div class="col-6">
                            <div class="form d-flex flex-column">
                                <div class="form-group mb-1">
                                    <label for="conjugeVIP">Sobre o Comdono</label>
                                </div>
                                <div class="form-check form-check-inline ">
                                    <input name="comdono_envia_info_apresentacao_comdono" class="form-check-input" id="gridCheck1" type="checkbox">
                                    <label class="form-check-label font-weight-normal" for="gridCheck1">Apresentação Comdono</label>
                                </div>
                                <div class="form-check form-check-inline ">
                                    <input name="comdono_envia_info_localizacao_comdono" class="form-check-input" id="gridCheck1" type="checkbox">
                                    <label class="form-check-label font-weight-normal" for="gridCheck1">Localização Comdono</label>
                                </div>
                                <!--<div class="form-check form-check-inline">
                                    <input name="comdono_envia_info_localizacao" class="form-check-input" id="gridCheck1" type="checkbox">
                                    <label class="form-check-label font-weight-normal" for="gridCheck1">Localização</label>
                                </div>-->
                                <div class="form-check form-check-inline ">
                                    <input name="comdono_envia_info_convite_comdono" class="form-check-input" id="gridCheck1" type="checkbox">
                                    <label class="form-check-label font-weight-normal" for="gridCheck1">Convite Comdono</label>
                                </div>
                            </div>
                        </div>
                    </div>
                    <hr>
                    <div class="form-group">
                        <div class="form-check form-check-inline mb-2">
                            <input name="envia_info_mensagem" class="form-check-input checkbox_mensagem_envia_info" id="gridCheck1" type="checkbox">
                            <label class="form-check-label" for="gridCheck1">Mensagem</label>
                        </div>
                        <textarea name="envia_info_text_area" class="form-control campo_mensagem_envia_info" style="resize: none; display: none;" id="descricao1" rows="3"></textarea>
                    </div>
                    
                </form>
              </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Fechar</button>
                    <button type="button" class="btn btn-primary btn-envia-info-whatsapp" data-toggle="tooltip" data-placement="top" title="Contactar a TI para Liberar a Função">Enviar via whatsapp</button>
                    <button type="button" class="btn btn-primary btn-envia-info-email">Enviar via email</button>
                </div>
               <div class="result_envia_info"></div>
              </div>
            </div>
          </div>
<!-- Modal --> 
<div class="modal fade" id="transferAtend"  tabindex="-1"  role="dialog" aria-labelledby="transferAtend" aria-hidden="true">
<div class="modal-dialog modal-dialog-centered" role="document">
    <div class="modal-content">
        <div class="modal-header">
            <h4 class="modal-title" id="exampleModalLabel">Transferir atendimento</h4>
            <button type="button" class="close transfForm" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
            </button>
        </div>
        <div class="modal-body">
            <form class="text-dark">
                <div class="form-group">
                    <label for="tipoTRANS" class="col-form-label">Tipo de atendimento:</label>
                    <div class="form-inline">
                        <div class="form-check form-check-inline mr-5">
                            <input class="form-check-input transfForm" id="tipoTRANSradio1" type="radio" value="option1" name="tipoTRANS">
                            <label class="form-check-label font-weight-normal" for="tipoTRANSradio1">Comdono</label>
                        </div>
                        <div class="form-check form-check-inline mr-5">
                            <input class="form-check-input transfForm" id="tipoTRANSradio2" type="radio" value="option2" name="tipoTRANS">
                            <label class="form-check-label font-weight-normal" for="tipoTRANSradio2">Correspondente</label>
                        </div>
                    </div>
                </div>
                <div class="form-group">
                    <label for="tipoTRANS2" class="col-form-label">Motivo:</label>
                    <input type="text" class="form-control transfForm" id="tipoTRANS2">
                </div>
                <div class="form-group">
                    <label for="tipoTRANS3" class="col-form-label">Message:</label>
                    <textarea class="form-control transfForm" id="tipoTRANS3"></textarea>
                </div> 
                <div class="form-group">
                    <label for="tipoTRANS" class="col-form-label">Próximo contato:</label>
                    <div class="form-inline">
                        <div class="form-check form-check-inline mr-5">
                            <input class="form-check-input transfForm" id="TRANSradio1" type="radio" value="option1" name="tipoTRANS">
                            <label class="form-check-label font-weight-normal" for="TRANSradio1">Próximo da fila</label>
                        </div>
                        <div class="form-check form-check-inline mr-5">
                            <input class="form-check-input transfForm" id="TRANSradio2" type="radio" value="option2" name="tipoTRANS">
                            <label class="form-check-label font-weight-normal" for="TRANSradio2">Personalizado</label>
                        </div>
                    </div>
                </div>
                <button type="button" class="btn btn-outline-primary btn-lg btn-block mt-3 salvarTrans">Transferir</button>
                <div class="row transConcluido">
                    <div class="col-6">
                        <button type="button" class="btn btn-outline-primary btn-block salvarTrans mt-3">Ir para o Dashboard</button>
                    </div>
                    <div class="col-6 pl-0">
                        <button type="button" onclick="window.location.href='https://dev.comdono.com/atendimento/incorporadoras';" class="btn btn-success btn-block mt-3">Próximo atendimento</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
</div>
<!-- Modal --> 
<div class="modal fade" id="prorrogaAtend"  tabindex="-1"  role="dialog" aria-labelledby="prorrogaAtend" aria-hidden="true">
<div class="modal-dialog modal-dialog-centered" role="document">
    <div class="modal-content">
        <div class="modal-header">
            <h4 class="modal-title" id="exampleModalLabel">Gerar Follow-UP de Atendimento</h4>
            <button type="button" class="close transfForm" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
            </button>
        </div>
        <div class="modal-body">
            <form class="text-dark adia-atendimento">
                <div class="form-group">
                    <label for="tipoTRANS2" class="col-form-label">Tempo:</label>
                    <select class="form-control select-prorr" name="date_prorrogado">
                        <option value="0000-00-00 00:00:00">Selecione</option>
                        <option value="<?php e(date('Y-m-d H:i:s', strtotime('+1 hour'))) ?>">1 Hora</option>
                        <option value="<?php e(date('Y-m-d 09:00:00', strtotime('+1 day'))) ?>">1 Dia</option>
                        <option value="<?php e(date('Y-m-d 09:00:00', strtotime('+1 week'))) ?>">1 Semana</option>
                        <option value="personalizado">Personalizado</option>
                    </select>
                </div>
                <input name="id_fila" type="hidden" value="<?php e($fila->id_fila); ?>">
                <div class="form-group data-perso" style="display:none;">
                    <label for="tipoTRANS3" class="col-form-label">Data Personalizada:</label>
                    <input class="form-control transfForm dt-perso" type="datetime-local" id="tipoTRANS3">
                </div>
                <div class="form-group">
                    <label for="tipoTRANS3" class="col-form-label">Message:</label>
                    <textarea class="form-control transfForm" name="motivo_prorrogacao" id="tipoTRANS3"></textarea>
                </div>
                <div class="row transConcluido">
                    <div class="col-6">
                        <button type="button" class="btn btn-outline-primary btn-block 132salvarTrans mt-3">Cancelar</button>
                    </div>
                    <div class="col-6 pl-0">
                        <button type="button" class="btn btn-success btn-block mt-3 adia-atend">Salvar</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
</div>
<!-- Modal --> 
<div class="modal fade" id="modalNvoip"  tabindex="-1"  role="dialog" aria-labelledby="prorrogaAtend" aria-hidden="true">
<div class="modal-dialog modal-dialog-centered" role="document">
    <div class="modal-content">
        <div class="modal-header">
            <h4 class="modal-title" id="exampleModalLabel">Realizar Ligação</h4>
            <button type="button" class="close transfForm" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
            </button>
        </div>
        <div class="modal-body">
            <form class="text-dark">
                <label>Nome:</label>
                <input name="nome" value="<?php e($dados_pessoais->nome); ?>" class="form-control" readonly>
                <label>Telefone:</label>
                <input name="nome" value="<?php e($dados_pessoais->telefone); ?>" class="form-control">
            </form>
            <button type="button" class="btn btn-primary"><i class="fa fa-phone fa-rotate-90" aria-hidden="true"></i> Discar</button>
            <button type="button" class="btn btn-primary"><i class="fa fa-volume-control-phone" aria-hidden="true"></i> Discar</button>
        </div>
    </div>
</div>
</div>
<!-- Modal --> 
<div class="modal fade" id="alteraAgendaModal" tabindex="-1" role="dialog" aria-labelledby="agendaModal" aria-hidden="true">
<div class="modal-dialog modal-dialog-centered" role="document">
<div class="modal-content">
  <div class="modal-header">
    <div class="d-flex">
        <h4 class="my-auto mr-2">Alterar visita: </h4><h4 class="my-auto text-primary"><?php e($empreendimento->emp_nome_fantasia) ?> - <?php e($house->par_razao_social??''); ?></h4>
    </div>
    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
      <span aria-hidden="true">&times;</span>
    </button>
  </div>
  <div class="modal-body">
   <form class="reagendar-visita text-dark">
        <div class="form-group">
            <input type="hidden" name="data_hora_agendamento"   id="data_hora_agendamento" value="">
            <input type="hidden" name="id_agenda" id="id_agenda">
            <input type="hidden" name="id_parceiro"      id="id_origem" value="<?php e($parceiro->id_parceiro) ?>">
            <input type="hidden" name="id_participantes[]" id="id_participantes" value="<?php e($incorporadora->id_responsavel) ?>">
            <input type="hidden" name="origem"           id="origem" value="4">
            <input type="hidden" name="id_origem"        id="id_origem" value="<?php e($dados_pessoais->id_captura) ?>">
            <input type="hidden" name="destino"          id="destino" value="1">
            <input type="hidden" name="id_destino"       id="id_destino" value="<?php e($empreendimento->id_empreendimento) ?>">
            <input type="hidden" name="id_interessado"   id="id_interessado" value="<?php e($dados_pessoais->id_cadastro) ?>">
            <label for="tipoEvento">Tipo de visita:</label>
            <select class="form-control" name="tipo_agendamento" id="tipo_agendamento">
              <option value="1">Visita presencial</option>
              <option value="2">Visita virtual</option>
            </select>
        </div>
        <div class="form-group row">
          <div class="col-6">
            <label for="melhordia" class="col-form-label">Melhor dia:</label>
            <div id="datetimepicker2"><input type="text" name="data" class="form-control"></div>
            
          </div>   
          <div class="col-6">
            <label for="melhorhora1" class="col-form-label">Melhor hora:</label>
            <div class="card-body card-scroll container-items horariosDisponiveis" style="max-height: 255px;"></div>
          </div>  
          
          <input type="hidden" name="data_hora_agendamento" value="">
          
       </div>
      <div class="form-group">
        <label for="observação1" class="col-form-label">Observação:</label>
        <textarea class="form-control" name="descricao_agenda" id="observação1"></textarea>
      </div>
      
      <div class="resultado_agendar_visita"></div>
    </form>
  </div>
  <div class="modal-footer">
      <button type="button" class="btn btn-danger btn-cancelar-visita">Cancelar a Visita</button>
    <button type="button" class="btn btn-primary btn-reagendar-visita">Alterar Visita</button>
  </div>
</div>
</div>
</div>
<!-- Modal --> 
<div class="modal fade" id="confimaCancelamento" tabindex="-1" role="dialog" aria-labelledby="confimaCancelamento" aria-hidden="true">
<div class="modal-dialog modal-dialog-centered" role="document">
<div class="modal-content">
  <div class="modal-header">
    <div class="d-flex">
        <h4 class="my-auto mr-2">Alterar visita: </h4><h4 class="my-auto text-primary"><?php e($empreendimento->emp_nome_fantasia) ?> - <?php e($house->par_razao_social??''); ?></h4>
    </div>
    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
      <span aria-hidden="true">&times;</span>
    </button>
  </div>
  <div class="modal-body">
    <p>Deseja realmente cancelar <b>esta visita</b>? Está ação é irrevesivel!</p>
  </div>
  <div class="result_cancelamento_agenda"></div>
  <div class="modal-footer">
        <button type="button" class="btn btn-danger btn-confirma-cancelar-visita">Cancelar a Visita</button>
        <button type="button" class="btn btn-primary btn-cancela-cancelamento">Fechar</button>
  </div>
</div>
</div>
</div>
</div>
<!-- Modal --> 
<div class="modal fade" id="editInteresseModal" tabindex="-1" role="dialog" aria-labelledby="editInteresseModal" aria-hidden="true">
<div class="modal-dialog modal-dialog-centered" style="max-width: 800px;" role="document">
<div class="modal-content">
  <div class="modal-header">
    <h4 class="modal-title" id="exampleModalLabel">Editar Interesse</h4>
    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
      <span aria-hidden="true">&times;</span>
    </button>
  </div>
  <div class="modal-body">
    <div class="row">
        <div class="col">
            <form class="text-dark form-edit-interesse">
                
                <input class="edit_interesse_id_captura" type="hidden" name="id_captura">
                <input class="edit_interesse_id_interesse" type="hidden" name="id_interesse">
                <input type="hidden" name="id_cadastro" value="<?php e($dados_pessoais->id_cadastro); ?>">
                <input type="hidden" name="id_responsavel" value="<?php e($fila->id_responsavel); ?>">
                
                <div class="form-group row">
                    <div class="col-6">
                       <label for="interessadoEM">Interessado em:</label>
                        <select name="tipo_interesse" class="form-control interForm edit_interesse_tipo_interesse" id="interessado90">
                          <option value="compra">Comprar</option>
                          <option value="venda">Vender</option>
                          <option value="comprar e vender">Comprar e vender</option>
                        </select> 
                    </div>
                  <div class="col-6">
                        <label for="interesse1">Tipo de imóvel</label>
                        <select name="tipo_imovel" id="tipo_imovel" class="form-control edit_interesse_tipo_imovel">
                            <option value="">Todos</option>
                            <optgroup label="Apartamento">
                                <option value="Apartamento Padrão">Padrão</option>
                                <option value="Kitnet">Kitnet</option>
                                <option value="Studio">Studio</option>
                                <option value="Loft">Loft</option>
                                <option value="Flat">Flat</option>
                                <option value="Cobertura">Cobertura</option>
                                <option value="Duplex">Duplex</option>
                                <option value="Triplex">Triplex</option>
                            </optgroup>
                            <optgroup label="Casa">
                                <option value="Casa Padrão">Padrão</option>
                                <option value="Casa de Condomínio">Casa de Condomínio</option>
                                <option value="Casa de Vila">Casa de Vila</option>
                            </optgroup>
                            <optgroup label="Outros">
                                <option value="Comercial">Comercial</option>
                                <option value="Rural">Rural</option>
                                <option value="Terreno">Terreno</option>
                                <option value="Vaga de Garagem">Vaga de Garagem</option>
                                </optgroup>
                        </select>
                  </div>
                    
                </div>
                <div class="form-group row">
                    <div class="col-4">
                        <label for="interesse2">Quartos</label>
                        <select name="quartos" class="form-control interForm edit_interesse_quartos" id="interesse91">
                          <option value="0">0</option>
                          <option value="1">1</option>
                          <option value="2">2</option>
                          <option value="3">3</option>
                          <option value="4">4 ou +</option>
                        </select>
                    </div>
                    <div class="col-4">
                        <label for="interesse3" class="col-form-label">Banheiros:</label>
                        <select name="banheiro" class="form-control interForm edit_interesse_banheiro" id="interesse92">
                          <option value="0">0</option>
                          <option value="1">1</option>
                          <option value="2">2</option>
                          <option value="3">3</option>
                          <option value="4">4 ou +</option>
                        </select>                                
                    </div>  
                    <div class="col-4">
                        <label for="interesse4" class="col-form-label">Vagas:</label>
                        <select name="vagas" class="form-control interForm edit_interesse_vagas" id="interesse93">
                          <option value="0">0</option>
                          <option value="1">1</option>
                          <option value="2">2</option>
                          <option value="3">3</option>
                          <option value="4">4 ou +</option>
                        </select>                                    
                    </div> 
                </div>
                <div class="form-group">
                    <label for="interesse97" class="col-form-label">Tipo de empreendimento:</label>
                    <select class="form-control interForm tipo_emp_editar_interesse" name="tipo_emp_cliente[]" multiple="multiple" id="interesse97">
                      <option value="pronto">Pronto</option>
                      <option value="lancamento">Lançamento</option>
                      <option value="Terreno">Terreno</option>
                    </select>
                </div>
                <div class="form-group">
                    <label for="interesse94" class="col-form-label">Bairro:</label>
                    <?php $bairros = HBairros::getSelect2()->items;  ?>
                    <select class="form-control interForm bairro_editar_interesse edit_interesse_bairro" name="bairro[]" multiple="multiple" id="interesse94">
                      <option value="Brasília">Brasília</option>
                      <?php
                        foreach($bairros as $b){
                            ?><option value="<?php e($b->id) ?>"><?php e($b->text) ?></option> <?php
                        }
                      ?>
                    </select>
                </div>  
                <div class="form-group">
                    <label for="interesse95" class="col-form-label">Faixa de preço:</label>
                    <div class="row">
                        <div class="col-6 d-flex align-items-center pr-2">
                            De
                            <input name="faixa_preco_inicio" type="text" class="form-control ml-2 interForm faixa_preco_anunciar_interesse edit_interesse_faixa_preco_inicio" id="interesse95">
                        </div>
                        <div class="col-6 d-flex align-items-center pl-0">
                            até
                            <input name="faixa_preco_fim" type="text" class="form-control ml-2 interForm faixa_preco_anunciar_interesse edit_interesse_faixa_preco_fim" id="interesse95">
                        </div>
                    </div>
                </div>
                <div class="form-group">
                    <label for="exampleFormControlTextarea96">Descrição</label>
                    <textarea name="descricao" class="form-control interForm edit_interesse_descricao" style="resize: none;" id="exampleFormControlTextarea96" rows="2"></textarea>
                </div>
                <button type="button" class="btn btn-block btn-outline-success editInteresse">Salvar</button>
                
                <div class="result_edit_interesse"></div>
            </form>
        </div>
        
    </div>  
  </div>
</div>
</div>
</div>
<!-- Modal --> 
<div class="modal fade" id="avaliarImovelDono" tabindex="-1" role="dialog" aria-labelledby="avaliarImovelDonoModal" aria-hidden="true">
<div class="modal-dialog modal-dialog-centered" style="max-width: 800px;" role="document">
<div class="modal-content">
  <div class="modal-header">
    <div class="d-flex">
        <h4 class="my-auto mr-2">Avaliação do Imóvel -</h4><h4 class="my-auto text-primary">Qual o valor do imóvel?</h4>
    </div>
    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
      <span aria-hidden="true">&times;</span>
    </button>
  </div>
  <div class="modal-body">
    <div class="row">
        <div class="col">
            <form class="text-dark form-avaliar-imovel-dono">
                
                <input class="origem_captura_avaliar_imovel_dono" type="hidden" name="origem_captura" value="avaliacao">
                <input class="nome_avaliar_imovel_dono" type="hidden" name="nome" value="<?php e($dados_pessoais->nome) ?>">
                <input class="email_avaliar_imovel_dono" type="hidden" name="email" value="<?php e($dados_pessoais->email) ?>">
                
                <div class="form group row">
                    <div class="col-4">
                        <label for="cepAvaliar">CEP:</label>
                        <input name="cep" type="text" class="form-control readonly cep_avaliar_dono" id="cepAvaliar">
                    </div>
                    <div class="col-lg-12 mb-3">
                        <p><small>Não sabe o CEP, <a href="http://www.buscacep.correios.com.br/sistemas/buscacep/buscaCepEndereco.cfm" target="_blank">clique aqui.</a></small></p>
                    </div>
                </div>
                <br>
                <button type="button" class="btn btn-block btn-primary btn-avaliarImovel-dono" data-toggle="modal" data-target="#avaliarImovel">Avalie agora!</button>
                
                <div class="result_avaliar_imovel_dono"></div>
            </form>
        </div>
        
    </div>  
  </div>
</div>
</div>
</div>

<!-- Modal --> 
<div class="modal fade" id="avaliarImovel" tabindex="-1" role="dialog" aria-labelledby="avaliarImovelModal" aria-hidden="true">
<div class="modal-dialog modal-dialog-centered" style="max-width: 1000px;" role="document">
<div class="modal-content">
  <div class="modal-header">
    <div class="d-flex">
        <h4 class="my-auto mr-2">Sobre o imóvel</h4>
    </div>
    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
      <span aria-hidden="true">&times;</span>
    </button>
  </div>
  <div class="modal-body">
    <div class="row">
        <div class="col">
            <form class="text-dark form-avaliar-imovel">
                
                <input class="id_captura_avaliar_imovel" type="hidden" name="id_captura">
                <div class="row">
                    <div class="col-lg-6 form-separator pr-40">
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="content-subtitle">
                                    <h3 class="text-primary">Detalhes do Imóvel</h3>
                                </div>
                            </div>
                        </div>
                        <br>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="tipo_captura">Padrão do Imóvel*</label>
                                    <select name="tipo_captura" id="tipo_captura" class="form-control tipo_imovel" required="required">
                                        <option value="">Selecione</option>
                                        <option value="1">Baixo - A reformar</option>
                                        <option value="2">Médio - Padrão</option>
                                        <option value="3">Alto - Premium</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="idade_imovel">Idade do Imóvel*</label>
                                    <select name="idade_imovel" id="idade_imovel" class="form-control idade_imovel" required="required">
                                        <option value="">Selecione</option>
                                        <option value="Novo">Novo</option>
                                        <option value="Até 5 anos">Até 5 anos</option>
                                        <option value="Entre 5 e 10 anos">Entre 5 e 10 anos</option>
                                        <option value="Mais de 10 anos">Mais de 10 anos</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="interesse1">Tipo de imóvel</label>
                                    <select name="tipo_imovel" id="tipo_imovel" class="form-control avaliar_tipo_imovel">
                                        <option value="">Todos</option>
                                        <optgroup label="Apartamento">
                                            <option value="Apartamento Padrão">Padrão</option>
                                            <option value="Kitnet">Kitnet</option>
                                            <option value="Studio">Studio</option>
                                            <option value="Loft">Loft</option>
                                            <option value="Flat">Flat</option>
                                            <option value="Cobertura">Cobertura</option>
                                            <option value="Duplex">Duplex</option>
                                            <option value="Triplex">Triplex</option>
                                        </optgroup>
                                        <optgroup label="Casa">
                                            <option value="Casa Padrão">Padrão</option>
                                            <option value="Casa de Condomínio">Casa de Condomínio</option>
                                            <option value="Casa de Vila">Casa de Vila</option>
                                        </optgroup>
                                        <optgroup label="Outros">
                                            <option value="Comercial">Comercial</option>
                                            <option value="Rural">Rural</option>
                                            <option value="Terreno">Terreno</option>
                                            <option value="Vaga de Garagem">Vaga de Garagem</option>
                                            </optgroup>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="area_total">Área privativa em m²*</label>
                                    <input type="number" name="area_total" class="form-control" id="area_total" min="0" required="required">
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col">
                                <div class="form-group">
                                    <label for="andar">Pavimento*</label>
                                    <input type="number" name="andar" class="form-control avaliar_pavimento" id="andar" min="0" max="40" required="required">
                                </div>
                            </div>
                            <div class="col">
                                <div class="form-group">
                                    <label for="quartos">Quarto(s)*</label>
                                    <select name="quartos" id="quartos" class="form-control avaliar_quartos" required="required">
                                        <option value="">Selecione</option>
                                        <option value="0">0</option>
                                        <option value="1">1</option>
                                        <option value="2">2</option>
                                        <option value="3">3</option>
                                        <option value="4">4+</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="row mb-4">
                            <div class="col">
                                <div class="form-group">
                                    <label for="banheiros">Banheiro(s)*</label>
                                    <select name="banheiros" id="banheiros" class="form-control avaliar_banheiros" required="required">
                                        <option value="">Selecione</option>
                                        <option value="0">0</option>
                                        <option value="1">1</option>
                                        <option value="2">2</option>
                                        <option value="3">3</option>
                                        <option value="4">4+</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col">
                                <div class="form-group">
                                    <label for="vaga">Vaga(s)*</label>
                                    <select name="vaga" id="vaga" class="form-control avaliar_vaga" required="required">
                                        <option value="">Selecione</option>
                                        <option value="0">0</option>
                                        <option value="1">1</option>
                                        <option value="2">2</option>
                                        <option value="3">3</option>
                                        <option value="4">4+</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-6 form-separator pl-40">
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="content-subtitle">
                                    <h3 class="text-primary">Localização do imóvel</h3>
                                </div>
                            </div>
                        </div>
                        <br>
                        <div class="row">
                            <div class="col-lg-3 col-md-3">
                                <div class="form-group">
                                    <label for="cep">CEP*</label>
                                    <input type="text" name="cep" class="form-control avaliar_cep" id="cep" value="" readonly="readonly" required="required">
                                    <span class="info-cep"></span>
                                </div>
                            </div>
                            <div class="col-lg-6 col-md-6">
                                <div class="form-group">
                                    <label for="dn_endereco">Endereço*</label>
                                    <input type="text" name="endereco" class="form-control avaliar_endereco" id="endereco" value="" readonly="readonly" required="required">
                                </div>
                            </div>
                            <div class="col-lg-3 col-md-3">
                                <div class="form-group">
                                    <label for="end_numero">Número*</label>
                                    <input type="text" name="numero" class="form-control" id="end_numero" value="" required="required">
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-lg-6 col-md-6">
                                <div class="form-group">
                                    <label for="end_complemento">Complemento*</label>
                                    <input type="text" name="complemento" class="form-control" id="end_complemento" value="" required="required">
                                </div>
                            </div>
                            <div class="col-lg-6 col-md-6">
                                <div class="form-group">
                                    <label for="bairro">Bairro*</label>
                                    <input type="text" name="bairro" class="form-control avaliar_bairro" id="bairro" value="" readonly="readonly" required="required">
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-lg-6 col-md-6">
                                <div class="form-group">
                                    <label for="dn_cidade">Cidade*</label>
                                    <input type="text" name="cidade" class="form-control avaliar_cidade" id="dn_end_complemento" value="" readonly="readonly" required="required">
                                </div>
                            </div>
                            <div class="col-lg-6 col-md-6">
                                <div class="form-group">
                                    <label for="dn_estado">Estado*</label>
                                    <input type="text" name="estado" class="form-control avaliar_estado" id="dn_estado" value="" readonly="readonly" required="required">
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-lg-8 col-md-12">
                                <div class="form-group">
                                    <label for="telefone">Telefone</label>
                                    <input type="text" class="form-control mb-3 avaliar_telefone" name="telefone" id="telefone" placeholder="Seu telefone" required="required">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <button type="button" class="btn btn-block btn-primary btn-avaliarImovel">Estimar valor</button>
                </div>
                
                <div class="result_avaliar_imovel"></div>
            </form>
        </div>
        
    </div>  
  </div>
</div>
</div>
</div>