<div class="animated fadeIn">
    <!--/Button voltar-->
    <div class="row mb-4">
        <div class="col-lg-12">
            <button class="btn btn-default cancel-button b10 voltar_pagina" type="button" id="cancel-button"><i class="icon-action-undo"></i> Voltar a listagem</button>
        </div>
    </div>
    
    <!--/Perfil-->
    <div class="row">
        <div class="col-lg-4">
            <div class="card border-primary">
                <div class="card-header text-white bg-primary border-primary">Cadastro</div>
                <div class="card-body">
                    <ul class="list-unstyled">
                        <li><strong>Nome:</strong> <?php e($cadastro->nome); ?></li>
                        <li><strong>E-mail:</strong> <?php e($cadastro->email); ?></li>
                        <li><strong>Telefone:</strong> <?php e($cadastro->telefone); ?></li>
                    </ul>
                </div>
            </div>
        </div>
        <div class="col-lg-4">
            <div class="card border-danger">
                <div class="card-header text-white bg-danger border-danger">Perfil</div>
                <div class="card-body">
                    <ul class="list-unstyled">
                        <li><strong>Idade:</strong> <?php e($cadastro->data_nascimento); ?></li>
                        <li><strong>Estado civil:</strong> <?php e($cadastro->estado_civil); ?></li>
                        <li><strong>Renda:</strong> <?php e("R$ 50.000,00"); ?></li>
                    </ul>
                </div>
            </div>
        </div>
        <div class="col-lg-4">
            <div class="card border-warning">
                <div class="card-header text-white bg-warning border-warning">Moradia</div>
                <div class="card-body">
                    <ul class="list-unstyled">
                        <li><strong>Onde mora:</strong> <?php e($cadastro->end_bairro); ?></li>
                        <li><strong>Tipo de moradia:</strong> <?php e("Alugada"); ?></li>
                        <li><strong>Qtd de residentes:</strong> <?php e("4"); ?></li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
    
    <!--/Cadastro-->
    <div class="row">
        <div class="col-lg-12">
            <div class="card card-accent-primary">
                <div class="card-header">
                    <div class="row">
                        <div class="col-lg-8">
                            <a href="#" data-toggle="collapse" data-target="#collapsePerfil" aria-expanded="true">
                            <ul class="list-inline m-0 d-flex align-items-center">
                                <li class="list-inline-item">
                                    <div class="avatar">
                                        <img class="img-avatar" src="<?php e(getenv('MEDIA_URL'));?>/anunciante/2/anuncios/1215/galeria/DSCF5195.jpg">
                                    </div>
                                </li>
                                <li class="list-inline-item"><?php e($cadastro->nome); ?></li>
                            </ul>
                            </a>
                        </div>
                        <div class="col-lg-4 text-right">
                            <a class="btn btn-primary text-white" data-toggle="collapse" data-target="#collapsePerfil" aria-expanded="true"><i class="fa fa-pencil"></i> Ver/editar cadastro completo</a>
                        </div>
                    </div>
                </div>
                <div class="card-body collapse" id="collapsePerfil">
                    <form name="" class="" method="post">
                    <div class="row">
                        <div class="col-lg-4">
                            <div class="card border-primary">
                                <div class="card-body">
                                    <input type="hidden" name="" id="dados_perfil" data-dados_perfil='<?php e(json_encode($cadastro)) ?>'>
                                    <div class="row">
                                        <div class="col-lg-6">
                                            <div class="form-group">
                                                <label for="id_cadastro">ID</label>
                                                <input type="text" name="id_cadastro" id="id_cadastro" class="form-control" value='<?php e($cadastro->id_cadastro); ?>' readonly="readonly">
                                            </div>
                                        </div>
                                        <div class="col-lg-6">
                                             <div class="form-group">
                                                <label for="etapa">Etapa cadastro</label>
                                                <input type="text" name="etapa" id="etapa" class="form-control" value='<?php e($cadastro->etapa < 8 ? "Cadastro incompleto":"Completo"); ?>'>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-lg-4">
                                            <div class="form-group">
                                                <label for="perfil">Perfil</label>
                                                <input type="text" name="perfil" id="perfil" class="form-control" value='<?php e(($cadastro->comprador==1)?'Comprador':''.' '.($cadastro->vendedor==1)?'Vendedor':''); ?>'>
                                            </div>
                                        </div>
                                        <div class="col-lg-8">
                                            <div class="form-group">
                                                <label for="nome">Nome</label>
                                                <input type="text" name="nome" id="nome" class="form-control border-primary" value='<?php e($cadastro->nome); ?>'>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-lg-6">
                                            <div class="form-group">
                                                <label for="email">E-mail</label>
                                                <input type="email" name="email" id="email" class="form-control border-primary" value='<?php e($cadastro->email); ?>'>
                                            </div>
                                        </div>
                                        <div class="col-lg-6">
                                            <div class="form-group">
                                                <label for="telefone">Celular/WhatsApp</label>
                                                <input type="text" name="telefone" id="telefone" class="celularMask form-control border-primary" value='<?php e($cadastro->telefone); ?>'>
                                            </div>
                                        </div>
                                    </div>
                            
                                    <div class="form-group">
                                        <label class="m-0" for="foto_perfil">Foto do perfil</label>
                                    </div>
                                    <div class="form-group">
                                        <div class="container-img custom-file container-img-img <?php e($cadastro->img_perfil != "" ? "" : "d-none"); ?>">
                                            <div class="box-doc divImgPerfil" <?php if ($cadastro->img_perfil != ""){ ?> style="background-image: url('<?php e($cadastro->img_perfil_uri.$cadastro->img_perfil)?>');" <?php } ?>></div>
                                            <div class="box-ico-text">
                                                <div class="text">
                                                    <div class="txt">
                                                        <i class="material-icons">
                                                           <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24">
                                                               <path fill="none" d="M0 0h24v24H0V0z"/>
                                                               <path d="M14.12 4l1.83 2H20v12H4V6h4.05l1.83-2h4.24M15 2H9L7.17 4H4c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V6c0-1.1-.9-2-2-2h-3.17L15 2zm-3 7c1.65 0 3 1.35 3 3s-1.35 3-3 3-3-1.35-3-3 1.35-3 3-3m0-2c-2.76 0-5 2.24-5 5s2.24 5 5 5 5-2.24 5-5-2.24-5-5-5z"/>
                                                            </svg>
                                                        </i>
                                                        <a href="javascript:;" class="act-remover-img">Remover foto</a> 
                                                        <a href="javascript:;" class="act-pergunta-img act-remover_img_perfil d-none">Remover foto?</a> 
                                                    </div>
                                                </div>
                                            </div>
                                        </div> 
                                        <div class="box-doc text-center container-img-load d-none">
                                            <label><i class='fa fa-circle-o-notch fa-spin'></i></label>
                                        </div>
                                        <div id="dn_img_div" class="container-img custom-file container-img-input <?php echo $cadastro->img_perfil != "" ? "d-none" : ""; ?>">
                                            <input type="file" name="dn_img" class="custom-file-input" id="dn_img" value="">
                                            <label class="custom-file-label label-img-input" for="customFile">
                                                <div class="box-ico-text">
                                                    <div class="ico">
                                                        <i class="material-icons">
                                                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24">
                                                                <path d="M12 12c2.21 0 4-1.79 4-4s-1.79-4-4-4-4 1.79-4 4 1.79 4 4 4zm0 2c-2.67 0-8 1.34-8 4v2h16v-2c0-2.66-5.33-4-8-4z"/>
                                                                <path d="M0 0h24v24H0z" fill="none"/>
                                                            </svg>
                                                        </i>
                                                    </div>
                                                    <div class="text">
                                                        <div class="txt">
                                                        <i class="material-icons">
                                                           <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24">
                                                               <path fill="none" d="M0 0h24v24H0V0z"/>
                                                               <path d="M14.12 4l1.83 2H20v12H4V6h4.05l1.83-2h4.24M15 2H9L7.17 4H4c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V6c0-1.1-.9-2-2-2h-3.17L15 2zm-3 7c1.65 0 3 1.35 3 3s-1.35 3-3 3-3-1.35-3-3 1.35-3 3-3m0-2c-2.76 0-5 2.24-5 5s2.24 5 5 5 5-2.24 5-5-2.24-5-5-5z"/>
                                                            </svg>
                                                        </i>
                                                        Adicionar foto
                                                        </div>
                                                    </div>
                                                </div>
                                            </label>
                                        </div>
                                    </div>
                                    <!-- ------- NÃO REMOVER O ESPAÇO EM BRANCO ENTRE AS TAGS ------- -->
                                    <script id="template-download" type="text/x-tmpl"> </script>
                                    <!-- ------- NÃO REMOVER O ESPAÇO EM BRANCO ENTRE AS TAGS ------- -->
                                    <div class="row">
                                        <div class="col-lg-12">
                                            <div class="msgAtualizaCadastro"></div>
                                            <div class="form-group text-right mt-2">
                                                <button type="button" class="btn btn-success btnAtualizaCadastro"><i class="fa fa-check"></i> Salvar</button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-4">
                            <div class="card border-danger">
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-lg-6">
                                            <div class="form-group">
                                                <label for="profissao">Profissão</label>
                                                <input type="text" name="profissao" id="profissao" class="celularMask form-control" value='<?php e($cadastro->profissao); ?>'>
                                            </div>
                                        </div>
                                        <div class="col-lg-6">
                                            <div class="form-group">
                                                <label for="genero">Gênero</label>
                                                <select name="genero" class="form-control" id="genero">
                                                    <option value="0">Selecione</option>
                                                    <option value="1">Masculino</option>
                                                    <option value="2">Feminino</option>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-lg-6">
                                            <div class="form-group">
                                                <label for="data_nascimento">Data de nascimento</label>
                                                <input type="text" name="data_nascimento" id="data_nascimento" class="dataMask form-control border-danger" value='<?php e($cadastro->data_nascimento); ?>'>
                                            </div>
                                        </div>
                                        <div class="col-lg-6">
                                            <div class="form-group">
                                                <label for="cpf">CPF</label>
                                                <input type="text" name="cpf" id="cpf" class="cpfMask form-control" value='<?php e($cadastro->cpf); ?>'>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-lg-6">
                                            <div class="form-group">
                                                <label for="rg">RG</label>
                                                <input type="text" name="rg" id="rg" class="form-control" value='<?php e($cadastro->rg); ?>'>
                                            </div>
                                        </div>
                                        <div class="col-lg-6">
                                            <div class="form-group">
                                                <label for="orgao_exp">Orgão expeditor</label>
                                                <input type="text" name="orgao_exp" id="orgao_exp" class="form-control" value='<?php e($cadastro->orgao_exp); ?>'>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-lg-6">
                                            <div class="form-group">
                                                <label for="nacionalidade">Nacionalidade</label>
                                                <input type="text" name="nacionalidade" id="nacionalidade" class="form-control" value='<?php e($cadastro->nacionalidade); ?>'>
                                            </div>
                                        </div>
                                        <div class="col-lg-6">
                                            <div class="form-group">
                                                <label for="estado_civil">Estado Civil</label>
                                                <input type="text" name="estado_civil" id="estado_civil" class="form-control border-danger" value='<?php e($cadastro->estado_civil); ?>'>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-lg-6">
                                            <div class="form-group">
                                                <label for="nome_conjuje">Nome do cônjuge</label>
                                                <input type="text" name="nome_conjuje" id="nome_conjuje" class="form-control" value='<?php e("nome_conjuje"); ?>'>
                                            </div>
                                        </div>
                                        <div class="col-lg-6">
                                            <div class="form-group">
                                                <label for="cpf_conjuje">CPF do cônjuge</label>
                                                <input type="text" name="cpf_conjuje" id="cpf_conjuje" class="form-control cpfMask" value='<?php e("999.999.999-99"); ?>'>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-lg-6">
                                        <div class="form-group">
                                            <label for="renda_mensal">Renda mensal</label>
                                            <input type="text" name="renda_mensal" id="renda_mensal" class="form-control border-danger" value='<?php e("renda_mensal"); ?>'>
                                        </div>
                                        </div>
                                        <div class="col-lg-6">
                                            <div class="form-group">
                                                <label for="renda_mensal_casal">Renda mensal casal</label>
                                                <input type="text" name="renda_mensal_casal" id="renda_mensal_casal" class="form-control" value='<?php e("renda_mensal_casal"); ?>'>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-lg-12">
                                            <div class="msgAtualizaCadastro"></div>
                                            <div class="form-group text-right mt-4">
                                                <button type="button" class="btn btn-success btnAtualizaCadastro"><i class="fa fa-check"></i> Salvar</button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-4">
                            <div class="card border-warning">
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-lg-6">
                                            <div class="form-group">
                                                <label for="facebook">Facebook*</label>
                                                <input type="text" name="facebook" class="form-control" id="facebook" value="<?php e($cadastro->facebook); ?>">
                                            </div>
                                        </div>
                                        <div class="col-lg-6">
                                            <div class="form-group">
                                                <label for="instagram">Instagram*</label>
                                                <input type="text" name="instagram" class="form-control" id="instagram" value="<?php e($cadastro->instagram); ?>">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-lg-6">
                                            <div class="form-group">
                                                <label for="modaria">Moradia*</label>
                                                <select name="modaria" class="form-control border-warning" id="select1">
                                                    <option value="0">Selecione</option>
                                                    <option value="1">Própria</option>
                                                    <option value="2">Alugada</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-lg-6">
                                            <div class="form-group">
                                                <label for="residentes">Residentes*</label>
                                                <input type="number" name="residentes" class="form-control border-warning" id="residentes" value="<?php e(4); ?>">
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <div class="form-group">
                                        <label for="end_cep">CEP*</label>
                                        <input type="text" name="end_cep" class="form-control end_cep cepMask" id="end_cep" value="<?php e($cadastro->end_cep); ?>">
                                        <span class="info-cep"></span>
                                    </div>
                                    
                                    <div class="row">
                                        <div class="col-lg-9">
                                            <div class="form-group">
                                                <label for="end_endereco">Endereço*</label>
                                                <input type="text" name="end_endereco" class="form-control" for="end_endereco" value="<?php e($cadastro->end_endereco); ?>">
                                            </div>
                                        </div>
                                        <div class="col-lg-3">
                                            <div class="form-group">
                                                <label for="end_numero">Número*</label>
                                                <input type="text" name="end_numero" class="form-control" id="end_numero" value="<?php e($cadastro->end_numero); ?>">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-lg-6">
                                            <div class="form-group">
                                                <label for="end_complemento">Complemento*</label>
                                                <input type="text" name="end_complemento" class="form-control" id="end_complemento" value="<?php e($cadastro->end_complemento); ?>">
                                            </div>
                                        </div>
                                        <div class="col-lg-6">
                                            <div class="form-group">
                                                <label for="end_bairro">Bairro*</label>
                                                <input type="text" name="end_bairro" class="form-control border-warning" id="end_bairro" value="<?php e($cadastro->end_bairro); ?>">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-lg-6">
                                            <div class="form-group">
                                                <label for="end_cidade">Cidade*</label>
                                                <input type="text" name="end_cidade" class="form-control" id="end_cidade" value="<?php e($cadastro->end_cidade); ?>">
                                            </div>
                                        </div>
                                        <div class="col-lg-6">
                                            <div class="form-group">
                                                <label for="end_estado">Estado*</label>
                                                <input type="text" name="end_estado" class="form-control" id="end_estado" value="<?php e($cadastro->end_estado); ?>" readonly="readonly">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-lg-12">
                                            <div class="msgAtualizaCadastro"></div>
                                            <div class="form-group text-right mt-4">
                                                <button type="button" class="btn btn-success btnAtualizaCadastro"><i class="fa fa-check"></i> Salvar</button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    
    <?php if($cadastro == NULL){ ?>
    Ainda não há detalhes
    <?php }else{ ?>
    
    <div class="row">
        <div class="col-lg-12">
            <!--/Resumo-->
            <div class="row">
                <div class="col-lg-12">
                    <div id="accordion">
                        <!--/Cards-->
                        <div class="row mt-4">
                            <div class="col-lg-4">
                                <a href="#" class="text-decoration-none" data-toggle="collapse" data-target="#collapseImoveis" aria-expanded="false" class="collapsed">
                                    <div class="card">
                                        <div class="card-body p-0 d-flex align-items-center">
                                            <i class="icon-home bg-<?php e(count($imoveis) > 0 ? "success":"danger"); ?> p-4 font-2xl mr-3"></i>
                                            <div class="w-100">
                                                <div class="text-value-sm text-info"><?php e(count($imoveis)); ?></div>
                                                <div class="text-muted text-uppercase font-weight-bold small">Imóveis</div>
                                            </div>
                                            <button class="btn btn-transparent float-right text-primary" type="button">
                                                <i class="fa fa-eye font-2xl"></i>
                                            </button>
                                        </div>
                                    </div>
                                </a>
                            </div>
                            
                            <div class="col-lg-4">
                                <div class="card">
                                    <a href="#" class="text-decoration-none" data-toggle="collapse" data-target="#collapsePesquisas" aria-expanded="false" class="collapsed">
                                        <div class="card-body p-0 d-flex align-items-center">
                                            <i class="icon-magnifier bg-<?php e(count($pesquisou) > 0 ? "success":"danger"); ?> p-4 font-2xl mr-3"></i>
                                            <div class="w-100">
                                                <div class="text-value-sm text-info"><?php e(count($pesquisou)); ?></div>
                                                <div class="text-muted text-uppercase font-weight-bold small">Pesquisas no Site</div>
                                            </div>
                                            <button class="btn btn-transparent float-right text-primary" type="button">
                                                <i class="fa fa-eye-slash font-2xl"></i>
                                            </button>
                                        </div>
                                    </a>
                                </div>
                            </div>
                            
                            <div class="col-lg-4">
                                <div class="card">
                                    <a href="#" class="text-decoration-none" data-toggle="collapse" data-target="#collapseFavoritos" aria-expanded="false" class="collapsed">
                                        <div class="card-body p-0 d-flex align-items-center">
                                            <i class="icon-heart bg-<?php e(count($favoritos) > 0 ? "success":"danger"); ?> p-4 font-2xl mr-3"></i>
                                            <div class="w-100">
                                                <div class="text-value-sm text-info"><?php e(count($favoritos)); ?></div>
                                                <div class="text-muted text-uppercase font-weight-bold small">Favoritos</div>
                                            </div>
                                            <button class="btn btn-transparent float-right text-primary" type="button">
                                                <i class="fa fa-eye-slash font-2xl"></i>
                                            </button>
                                        </div>
                                    </a>
                                </div>
                            </div>
                            
                            <div class="col-lg-4">
                                <div class="card">
                                    <a href="#" class="text-decoration-none" data-toggle="collapse" data-target="#collapseAtendimento" aria-expanded="false" class="collapsed">
                                        <div class="card-body p-0 d-flex align-items-center">
                                            <i class="icon-people bg-<?php e(count($atendimentos) > 0 ? "success":"danger"); ?> p-4 font-2xl mr-3"></i>
                                            <div class="w-100">
                                                <div class="text-value-sm text-info"><?php e(count($atendimentos)); ?></div>
                                                <div class="text-muted text-uppercase font-weight-bold small">Atendimentos</div>
                                            </div>
                                            <button class="btn btn-transparent float-right text-primary" type="button">
                                                <i class="fa fa-eye-slash font-2xl"></i>
                                            </button>
                                        </div>
                                    </a>
                                </div>
                            </div>
                            
                            <div class="col-lg-4">
                                <div class="card">
                                    <a href="#" class="text-decoration-none" data-toggle="collapse" data-target="#collapseNegociacoes" aria-expanded="false" class="collapsed">
                                        <div class="card-body p-0 d-flex align-items-center">
                                            <i class="icon-speech bg-<?php e(count($negociacoes_compras) > 0 ? "success":"danger"); ?> p-4 font-2xl mr-3"></i>
                                            <div class="w-100">
                                                <div class="text-value-sm text-info"><?php e(count($negociacoes_compras)); ?></div>
                                                <div class="text-muted text-uppercase font-weight-bold small">Negociações</div>
                                            </div>
                                            <button class="btn btn-transparent float-right text-primary" type="button">
                                                <i class="fa fa-eye-slash font-2xl"></i>
                                            </button>
                                        </div>
                                    </a>
                                </div>
                            </div>
                            
                            <div class="col-lg-4">
                                <div class="card">
                                    <a href="#" class="text-decoration-none" data-toggle="collapse" data-target="#collapseFinanciamento" aria-expanded="false" class="collapsed">
                                        <div class="card-body p-0 d-flex align-items-center">
                                            <i class="icon-wallet bg-<?php e(count($financiamentos) > 0 ? "success":"danger"); ?> p-4 font-2xl mr-3"></i>
                                            <div class="w-100">
                                                <div class="text-value-sm text-info"><?php e(count($financiamentos)); ?></div>
                                                <div class="text-muted text-uppercase font-weight-bold small">Financiamentos</div>
                                            </div>
                                            <button class="btn btn-transparent float-right text-primary" type="button">
                                                <i class="fa fa-eye-slash font-2xl"></i>
                                            </button>
                                        </div>
                                    </a>
                                </div>
                            </div>
                        </div>
                        <!--/tables-->
                        <div class="row">
                            <div class="col-lg-12">
                                <!-- /. Imoveis -->
                                <div class="collapse my-4" id="collapseImoveis" data-parent="#accordion">
                                    <div class="box-title-section">
                                        <h5 class="text-primary"><?php e(count($imoveis) > 0 ? count($imoveis)." Imóveis":"Não há imóvel"); ?></h5>
                                        <hr>
                                    </div>
                                    
                                    <a href="javascript:;" class="btn btn-success mb-4 float-left"><i class="fa fa-plus"></i> Adicionar imóvel</a>
                                    
                                    <div class="table-container table-responsive">
                                        <table class="display table table-striped table-bordered" style="width:100%">
                                            <thead>
                                                <tr>
                                                    <th>ID</th>
                                                    <th>Imóvel</th>
                                                    <th>Bairro</th>
                                                    <th>Endereco</th>
                                                    <th>data</th>
                                                    <th>status</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php foreach($imoveis as $imovel) { ?>
                                                <tr class="trData" >
                                                    <td><a href="<?php e(base_url("imovel/".$imovel->id_imovel)); ?>" target="_blank"><?php e($imovel->id_imovel); ?></a></td>
                                                    <td class="text-center">
                                                        <a href="<?php e(base_url("imovel/".$imovel->id_imovel)); ?>" target="_blank">
                                                        <div class="avatar">
                                                            <img class="img-avatar" src="<?php HImg::ref($imovel->imagens[0]??''); ?>">
                                                        </div>
                                                        </a>
                                                    </td>
                                                    <td><?php e($imovel->bairro); ?></td>
                                                    <td><?php e($imovel->endereco); ?></td>
                                                    <td><?php e($imovel->data_hora_imovel); ?></td>
                                                    <td>
                                                        <span class='badge <?php e(HImovel::getStatus($imovel->status)->bdg); ?>'><?php e(HImovel::getStatus($imovel->status)->text); ?></span>
                                                    </td>
                                                </tr>
                                                <?php } ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                                
                                <!-- /. Pesquisas no site -->
                                <div class="collapse my-4" id="collapsePesquisas" data-parent="#accordion">
                                    <div class="box-title-section">
                                        <h5 class="text-primary"><?php e(count($pesquisou) > 0 ? count($pesquisou)." Pesquisas no Site":"Não há pesquisas no site"); ?></h5>
                                        <hr>
                                    </div>
                                    <div class="table-container table-responsive">
                                        <table class="display table table-striped table-bordered" style="width:100%">
                                            <thead>
                                                <tr>
                                                    <th>Qnt</th>
                                                    <th>Pesquisa</th>
                                                    <th>Bairro</th>
                                                    <th>quartos</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php foreach($pesquisou as $pesquisa) { ?>
                                                <tr class="trData" >
                                                    <td><?php e($pesquisa->cont); ?></td>
                                                    <td><?php e($pesquisa->pesquisa); ?></td>
                                                    <td><?php e($pesquisa->bairro); ?></td>
                                                    <td><?php e($pesquisa->quartos); ?></td>
                                                </tr>
                                                <?php } ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                                
                                <!-- /.Favoritos-->
                                <div class="collapse my-4" id="collapseFavoritos" data-parent="#accordion">
                                    <div class="box-title-section">
                                        <h5 class="text-primary"><?php e(count($favoritos) > 0 ? count($favoritos)." Favoritos":"Não há favoritos"); ?></h5>
                                        <hr>
                                    </div>
                                    <div class="table-container table-responsive">
                                        <table class="display table table-striped table-bordered" style="width:100%">
                                            <thead>
                                                <tr>
                                                    <th>Imóvel</th>
                                                    <th>ID</th>
                                                    <th>Bairro</th>
                                                    <th>Endereco</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php foreach($favoritos as $favorito) { ?>
                                                <tr class="trData" >
                                                    <td class="text-center">
                                                        <a href="<?php e(base_url("imovel/".$favorito->id_imovel)); ?>" target="_blank">
                                                        <div class="avatar">
                                                            <img class="img-avatar" src="<?php HImg::ref($favorito->imagens[0]??''); ?>">
                                                        </div>
                                                        </a>
                                                    </td>
                                                    <td><a href="<?php e(base_url("imovel/".$favorito->id_imovel)); ?>" target="_blank"><?php e($favorito->id_imovel); ?></a></td>
                                                    <td><?php e($favorito->bairro); ?></td>
                                                    <td><?php e($favorito->endereco); ?></td>
                                                </tr>
                                                <?php } ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                                
                                <!-- /.Atendimentos -->
                                <div class="collapse my-4" id="collapseAtendimento" data-parent="#accordion">
                                    <div class="box-title-section">
                                        <h5 class="text-primary"><?php e(count($atendimentos) > 0 ? count($atendimentos)." Atendimentos":"Não há atendimento"); ?></h5>
                                        <hr>
                                    </div>
                                    <div class="table-container table-responsive">
                                        <table class="display table table-striped table-bordered" style="width:100%">
                                            <thead>
                                                <tr>
                                                    <th>Atendente</th>
                                                    <th>Interesse</th>
                                                    <th>Data/Hora</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php foreach($atendimentos as $atendimento) { ?>
                                                    <tr>
                                                        <td><?php e($atendimento->id_user); ?></td>
                                                        <td><?php e($atendimento->tipo_interesse); ?></td>
                                                        <td><?php e(date('d/m/Y - H:i:s', strtotime($atendimento->data_hora))); ?></td>
                                                    </tr>
                                                <?php } ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                                
                                <!-- /.Negociações-->
                                <div class="collapse my-4" id="collapseNegociacoes" data-parent="#accordion">
                                    <div class="box-title-section">
                                        <h5 class="text-primary"><?php e(count($negociacoes_compras) > 0 ? count($negociacoes_compras)." Negociações":"Não há negociações"); ?></h5>
                                        <hr>
                                    </div>
                                    <div class="table-container table-responsive">
                                        <table class="display table table-striped table-bordered" style="width:100%">
                                            <thead>
                                                <tr>
                                                    <th>Bairro</th>
                                                    <th>Imovel</th>
                                                    <th>Status</th>
                                                    <th>Etapa</th>
                                                    <th>nº msgs</th>
                                                    <th>Ultima msg</th>
                                                    <th></th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php foreach($negociacoes_compras as $id_chat=>$chat) { ?>
                                                    <tr class="trData">
                                                        <td><?php e($chat->imovel->bairro); ?></td>
                                                        <td><a href="<?php e(base_url().'imovel/'.$chat->id_imovel); ?>" target="_blank"> <?php e($chat->imovel->endereco); ?></a></td>
                                                        <td><?php e($chat->chat_status); ?></td>
                                                        <td><?php e($chat->etapa); ?></td>
                                                        <td><?php e(count($chat->msgs) -1); ?></td>
                                                        <td><?php e(end($chat->msgs)->dt_msg); ?></td>
                                                        <td><a href="<?php e(base_url().'administrativo/braco_direito/chat/'.$chat->id_imovel.'/'.$id_chat); ?>" target="_blank">Chat</a></td>
                                                    </tr>
                                                <?php } ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                                
                                <!-- /.Financiamentos -->
                                <div class="collapse my-4" id="collapseFinanciamento" data-parent="#accordion">
                                    <div class="box-title-section">
                                        <h5 class="text-primary"><?php e(count($financiamentos) > 0 ? count($financiamentos)." Financiamentos":"Não há financiamento"); ?></h5>
                                        <hr>
                                    </div>
                                    <div class="table-container table-responsive">
                                        <table class="display table table-striped table-bordered" style="width:100%">
                                            <thead>
                                                <tr>
                                                    <th>Imóvel</th>
                                                    <th>Valor imóvel</th>
                                                    <th>Valor entrada</th>
                                                    <th>Parcelas</th>
                                                    <th>Ação</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php foreach($financiamentos as $financiamento) { ?>
                                                <tr>
                                                    <td class="text-center">
                                                        <div class="avatar">
                                                        <img class="img-avatar" src="<?php e(getenv('MEDIA_URL'));?>/anunciante/2/perfil/bg-avaliacao-rs.jpg" alt="admin@bootstrapmaster.com">
                                                        <span class="avatar-status badge-success"></span>
                                                        </div>
                                                    </td>
                                                    <td>R$ 448.999,00</td>
                                                    <td>R$ 112.899,90</td>
                                                    <td>180</td>
                                                    <td><a href="<?php e(base_url('administrativo/financiamentos/bancos/52')); ?>" target="_blank"><i class="icon-credit-card font-2xl"></i></a>
                                                </tr>
                                                <?php } ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <!--/Interesse-->
            <div class="row mt-4">
                <div class="col-lg-12">
                     <div class="card">
                        <h5 class="card-header">Interesse</h5>
                        <div class="card-body">
                            <form name="" class="" method="post">
                                <div class="row">
                                    <div class="col-lg-3">
                                        <div class="card">
                                            <div class="card-body">
                                                <div class="form-group">
                                                    <div class="custom-control custom-radio">
                                                        <input type="radio" name="radios" class="custom-control-input" id="radio1" value="radio1">
                                                        <label class="custom-control-label" for="radio1">Comprar</label>
                                                    </div>
                                                    <div class="custom-control custom-radio">
                                                        <input type="radio" name="radios" class="custom-control-input" id="radio2" value="radio2">
                                                        <label class="custom-control-label" for="radio2">Comprar para vender</label>
                                                    </div>
                                                    <div class="custom-control custom-radio">
                                                        <input type="radio" name="radios" class="custom-control-input" id="radio3" type="radio" value="radio3">
                                                        <label class="custom-control-label" for="radio3">Vender</label>
                                                    </div>
                                                    <div class="custom-control custom-radio">
                                                        <input type="radio" name="radios" class="custom-control-input" id="radio4" type="radio" value="radio4">
                                                        <label class="custom-control-label" for="radio4">Vender para comprar</label>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-lg-5">
                                        <div class="card">
                                            <div class="card-body">
                                                <!--Marcando a opção: Vender para comprar, envia uma tag para a atendente responsavel pelas vendas-->
                                                <!--Marcando estas opções Comprar, Comprar para vender, Vender para comprar, mostra os itens abaixo-->
                                                <div class="row">
                                                    <div class="col-lg-6">
                                                        <div class="form-group">
                                                            <label for="tipo_imovel">Tipo imóvel</label>
                                                            <select name="tipo_imovel" id="tipo_imovel" class="basic-multiple" multiple="multiple">
                                                                <option value="Apartamento">Apartamento</option>
                                                                <option value="Kitnet">Kitnet</option>
                                                                <option value="Casa">Casa</option>
                                                                <option value="Outros">Outros</option>
                                                            </select>
                                                        </div>
                                                    </div>
                                                    <div class="col-lg-6">
                                                        <div class="form-group">
                                                            <label for="quartos">Qtd quartos</label>
                                                            <select name="quartos[]" id="quartos" class="basic-multiple" multiple="multiple">
                                                                <option value="0">0</option>
                                                                <option value="1">1</option>
                                                                <option value="2">2</option>
                                                                <option value="3">3</option>
                                                                <option value="+4">+4</option>
                                                            </select>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="row">
                                                    <div class="col-lg-6">
                                                        <div class="form-group">
                                                            <label for="banheiros">Qtd banheiros</label>
                                                            <select name="banheiros" id="banheiros" class="basic-multiple" multiple="multiple">
                                                                <option value="0">0</option>
                                                                <option value="1">1</option>
                                                                <option value="2">2</option>
                                                                <option value="3">3</option>
                                                                <option value="+4">+4</option>
                                                            </select>
                                                        </div>
                                                    </div>
                                                    <div class="col-lg-6">
                                                        <div class="form-group">
                                                            <label for="vagas">Qtd vagas de garagem</label>
                                                            <select name="vagas" id="vagas" class="basic-multiple" multiple="multiple">
                                                                <option value="0">0</option>
                                                                <option value="1">1</option>
                                                                <option value="2">2</option>
                                                                <option value="3">3</option>
                                                                <option value="+4">+4</option>
                                                            </select>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-lg-4">
                                        <div class="card">
                                            <div class="card-body">
                                                <div class="form-group">
                                                    <label for="bairro">Bairro</label>
                                                    <select name="bairro" id="bairro" class="basic-multiple" multiple="multiple">
                                                        <option value="0">0</option>
                                                        <option value="1">1</option>
                                                        <option value="2">2</option>
                                                        <option value="3">3</option>
                                                        <option value="+4">+4</option>
                                                    </select>
                                                </div>
                                                <div class="form-group">
                                                    <label for="comodidades">Comodidades</label>
                                                    <select name="comodidades" id="comodidades" class="basic-multiple" multiple="multiple">
                                                        <option value="0">0</option>
                                                        <option value="1">1</option>
                                                        <option value="2">2</option>
                                                        <option value="3">3</option>
                                                        <option value="+4">+4</option>
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-lg-12">
                                            <div class="msgAtualizaInteresse"></div>
                                            <div class="form-group text-right mt-4">
                                                <button type="submit" class="btn btn-success btnAtualizarInteresse" id="form-button-save"><i class="fa fa-check"></i> Salvar</button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
            
            <!--/Atendimento-->
            <div class="row mt-4">
                <div class="col-lg-12">
                    <div class="card">
                        <h5 class="card-header">Atendimento</h5>
                        <div class="card-body">
                            
                            
                            <div class="card">
                                <h5 class="card-header">
                                    <a href="#" data-toggle="collapse" data-target="#collapseHistorico" aria-expanded="true">Últimos atendimentos</a>
                                </h5>
                                <div class="card-body collapse" id="collapseHistorico">
                                    <div class="row">
                                        <div class="col-lg-12">
                                            <div id="accordion_ultimos_atendimentos" role="tablist">
                                                <?php for($i=1;$i<=5;$i++){ ?>
                                                <div class="card card-accent-info">
                                                    <div class="card-header" id="heading-<?php e($i); ?>" role="tab">
                                                        <h5 class="mb-0">
                                                        <a data-toggle="collapse" href="#collapse-<?php e($i); ?>" aria-expanded="true" aria-controls="collapse-<?php e($i); ?>" class="collapsed">
                                                            <?php e(date('d/m/Y - H:i:s', strtotime("2020-05-21"))); ?>
                                                        </a>
                                                        </h5>
                                                    </div>
                                                    <div class="collapse" id="collapse-<?php e($i); ?>" role="tabpanel" aria-labelledby="heading-<?php e($i); ?>" data-parent="#accordion_ultimos_atendimentos">
                                                        <div class="card-body">
                                                            <div class="row">
                                                                <div class="col-lg-12">
                                                                    <div class="form-group">
                                                                        <label class="control-label">Atendente</label>
                                                                        <input type="text" name="atendente" value="<?php e("Ricardo"); ?>" class="form-control" readonly="readonly">
                                                                    </div>
                                                                    <div class="form-group">
                                                                        <label class="control-label">Tipo de interesse</label>
                                                                        <input type="text" name="tipo_interesse" value="<?php e("Signature"); ?>" class="form-control" readonly="readonly">
                                                                    </div>
                                                                    <div class="form-group">
                                                                        <label class="control-label">Observação</label>
                                                                        <textarea name="observacao" class="form-control" rows="3" readonly="readonly"><?php e("Lorem ipsum"); ?></textarea>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <?php } ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="box-title-section">
                                <h5 class="text-primary">Detalhes da captura</h5>
                                <hr>
                            </div>
                            <div class="card">
                                <div class="card-body">
                                    <ul class="m-0 list-unstyled">
                                        <li><strong>Data da captura:</strong> <?php e("01/05/2020"); ?></li>
                                        <li><strong>Origem:</strong> <?php e("Google"); ?></li>
                                        <li><strong>Tipo de interesse:</strong> <?php e("Signature"); ?></li>
                                        <li><strong>Unidade escolhida:</strong> <?php e("Townhouse com piscina - 454,68 m²"); ?></li>
                                        <li><strong>Situação:</strong> <span class="badge badge-success"><?php e("Ativado"); ?></span></li>
                                        <li><strong>Último atendimento:</strong> <?php e("20/05/2020"); ?></li>
                                        <li><strong>Observação:</strong> <?php e("Lorem ipsum"); ?></li>
                                        <li><strong>Próximo atendimento:</strong> <?php e("01/05/2020"); ?></li>
                                    </ul>
                                </div>
                            </div>
                            
                            <div class="row">
                                <div class="col-lg-6">
                                    <div class="box-title-section">
                                        <h5 class="text-primary">Novo atendimento</h5>
                                        <hr>
                                    </div>
                                    <div class="card">
                                        <div class="card-body">
                                            <form name="" class="" action="" method="post">
                                                <div class="row">
                                                    <div class="col-lg-6">
                                                        <div class="form-group">
                                                            <label for="data_atendimento">Data atendimento</label>
                                                            <input type="date" name="data_atendimento" class="form-control" id="data_atendimento">
                                                        </div>
                                                    </div>
                                                    <div class="col-lg-6">
                                                        <div class="form-group">
                                                            <label for="canal_atendimento">Canal de atendimento</label>
                                                            <select name="canal_atendimento" id="canal_atendimento" class="form-control">
                                                                <option value="">Selecione</option>
                                                                <option value="Voip">Voip</option>
                                                                <option value="E-mail">E-mail</option>
                                                                <option value="WhatsApp">WhatsApp</option>
                                                            </select>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="form-group">
                                                    <label class="control-label">Observação</label>
                                                    <textarea  name="observacao" class="observacao form-control" rows="3" required="required"></textarea>
                                                </div>
                                                <div class="form-group">
                                                    <label for="novo_contato">Próximo atendimento?</label>
                                                    <div class="form-group">
                                                        <div class="custom-control custom-radio form-check-inline mr-1">
                                                            <input type="radio" name="novo_contato" class="custom-control-input" id="sim" value="sim">
                                                            <label class="custom-control-label" for="sim">Sim</label>
                                                        </div>
                                                        <div class="custom-control custom-radio form-check-inline mr-1">
                                                            <input type="radio" name="novo_contato" class="custom-control-input" id="nao" value="nao">
                                                            <label class="custom-control-label" for="nao">Não, já finalizei.</label>
                                                        </div>
                                                    </div>
                                                    <div class="form-group">
                                                        <label for="proximo_contato">Data e hora</label>
                                                        <input type="date" name="proximo_contato" class="form-control" id="proximo_contato" value="">
                                                    </div>
                                                </div>
                                                <div class="form-group text-right mt-4">
                                                    <button type="submit" class="btn btn-success salvar_atendimento_" id="form-button-save"><i class="fa fa-check"></i> Salvar</button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="box-title-section">
                                        <h5 class="text-primary">Agendamento</h5>
                                        <hr>
                                    </div>
                                    <div class="card">
                                        <div class="card-body">
                                            <form name="" class="" action="" method="post">
                                                <div class="row">
                                                    <div class="col-lg-6">
                                                        <div class="form-group">
                                                            <label for="data_atendimento">Data e hora</label>
                                                            <input type="date" name="data_atendimento" class="form-control" id="data_atendimento">
                                                        </div>
                                                    </div>
                                                    <div class="col-lg-6">
                                                        <div class="form-group">
                                                            <label for="canal_atendimento">Tipo</label>
                                                            <select name="canal_atendimento" id="canal_atendimento" class="form-control">
                                                                <option value="">Selecione</option>
                                                                <option value="Visita virtual">Visita virtual</option>
                                                                <option value="Presencial">Presencial</option>
                                                                <option value="Fotos do imóvel">Fotos do imóvel</option>
                                                            </select>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="box-title-section">
                                                    <h5>Envolvidos</h5>
                                                    <hr>
                                                </div>
                                                <div class="row">
                                                    <div class="col-lg-6">
                                                        <div class="form-group">
                                                            <label for="responsavel">Responsável</label>
                                                            <select name="responsavel" id="responsavel" class="basic-multiple" multiple="multiple">
                                                                <option value="Resposavel1">Resposavel1</option>
                                                                <option value="Resposavel2">Resposavel2</option>
                                                                <option value="Resposavel3">Resposavel3</option>
                                                                <option value="Resposavel4">Resposavel4</option>
                                                            </select>
                                                        </div>
                                                    </div>
                                                    <div class="col-lg-6">
                                                        <div class="form-group">
                                                            <label for="interessado">Interessado</label>
                                                            <input type="text" name="interessado" class="form-control" id="interessado" value="Ricardo Luis" readonly="readonly">
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="form-group">
                                                    <label class="control-label">Observação</label>
                                                    <textarea  name="observacao" class="observacao form-control" rows="3" required="required"></textarea>
                                                </div>
                                                <div class="form-group text-right mt-4">
                                                    <button type="submit" class="btn btn-success salvar_atendimento_" id="form-button-save"><i class="fa fa-check"></i> Salvar</button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php } ?>
 </div>