var $imovel = $('#input-imovel').data('imovel');
var $banco = $('#input-banco').data('banco');
var $bancos = $('#input-bancos').data('bancos');
var $simulacao = $('#input-simulacao').data('simulacao');
var $rPorcentagem = parseFloat($('#input-porcentage').data('porcentage'));
var $rParcela;
var $rTotal;

var $bancosAprovados = [];

var max;
var min;
var med;

/*var range_all_sliders_valor = {
        	'min': [ min,1000 ],
        	//'50%': [ med, 1000 ],
        	'max': [ max ]
        };*/

function range_all_sliders_valor()
{
    ranger = max-min;
    espaco = ranger/4;
    //console.log('asd',min,med,max);
    
    return {
        	'min': [ min,1000 ],
        	//'25%': [ min+(espaco*1), 1000 ],
        	'50%': [ min+(espaco*2), 1000 ],
        	//'75%': [ min+(espaco*3), 1000 ],
        	'max': [ max ]
        };
}

var chave = true;
function filterPips(value, type) {
    valid = false;
    if(chave && value > max-1000)
    {
        chave = false;
        valid = true;
    }
    return (type == 1 || valid)? 1: -1;
}
var pipsSteps_valor = document.getElementById('pips-steps-valor');

var range_all_sliders_meses = {
	'min': [ 60,  60 ],
	'20%': [ 120, 60 ],
	'40%': [ 180, 60 ],
	'60%': [ 240, 60 ],
	'80%': [ 300, 60 ],
	'max': [ 360 ]
};

function filterPips1(value, type) {
    return value % 60 ? 2 : 1;
}

var pipsSteps_meses = document.getElementById('pips-steps-meses');

$(window).on('load', function(){

    //console.log('aqui', step, $simulacao);
    
    if(step == 0){
        
        max = parseFloat($banco.maiorEntrada);
        min = parseFloat($banco.menorEntrada);
        iniSlider();
        
        //console.log($simulacao);
        
        if($simulacao != null ){
            
            $('#input-valor').val($simulacao.val_entrada);
            $('#change-meses').val($simulacao.meses_financiado);
            pipsSteps_valor.noUiSlider.set($simulacao.val_entrada);
            pipsSteps_meses.noUiSlider.set($simulacao.meses_financiado);
            calculaTaxas();
        }
        else
        {
            $('#input-valor').val(min+0.1);
            resetCalculo();
        }
    }
    
});

function iniSlider()
{
    noUiSlider.create(pipsSteps_valor, {
        range: range_all_sliders_valor(),
        start: min,
        connect: [true, false],
        tooltips: wNumb({
                mark: ',',
    	        thousand: '.',
            	decimals: 2,
                prefix: 'R$',
                encoder: function( value ){
            		return parseFloat(value);
            	},
            }),
        pips: {
            mode: 'steps',
            density: 1000,
            filter: filterPips,
            format: wNumb({
                mark: ',',
    	        thousand: '.',
            	decimals: 2,
                prefix: 'R$'
            })
        }
    });


    noUiSlider.create(pipsSteps_meses, {
        range: range_all_sliders_meses,
        start: 60,
        connect: [true, false],
        tooltips: wNumb({
                encoder: function( value ){
            		return parseFloat(value);
            	},
            	suffix: ' meses'
            }),
        pips: {
            mode: 'steps',
            density: 60,
            filter: filterPips1,
            format: wNumb({
                encoder: function( value ){
            		return parseFloat(value);
            	}
            })
        }
    });
    
    
    var select = document.getElementById('change-meses');

        select.addEventListener('change', function () {
            pipsSteps_meses.noUiSlider.set(this.value);
            resetCalculo();
            
        });
        
        var inputValor = document.getElementById('input-valor');
        
        inputValor.addEventListener('keypress', function () {
            pipsSteps_valor.noUiSlider.set(this.value);
            resetCalculo();
            
        });
        
        pipsSteps_valor.noUiSlider.on('change', function (value){
            
            
            $('#input-valor').val(value).attr("value",value) 
            resetCalculo();
        });
        
        pipsSteps_meses.noUiSlider.on('change', function (value) { 
            $('#change-meses').val(parseFloat(value)) 
            resetCalculo();
            
        });
}


$('body').on('click','.calcularProposta', function(){
    calculaTaxas();
    
    var valor = $("input[name=valor]").val();
	var meses = $('#change-meses option:selected').val();
	data = {
	    valor: valor,
	    meses: meses,
	    id_imovel: id_imovel,
	    taxa: $rPorcentagem,
        val_parcelas: $rParcela,
        val_total: $rTotal,
 	}
    
    $.ajax({
		url: base_url+'comdono/ajax/financiamento_ajax/set_calculo',
		dataType: 'json',
		type: 'POST',
		data: data,
		success: function(retorno)
		{	
		},
		error: function(error)
		{
			
		}
	});
    
});

function resetCalculo()
{
   $bancosAprovados = [];
   $('.img-off').show();
   $('.img-on').hide();
   $('.valorJuros').text('-');
   $('.valorTr').text('-');
   $('.valorParcelas').text(' - ');
   $('.valorUltimaParcela').text(' - ');
   $('.valorTotal').text(' - ');
   $('.enviarProposta').prop('disabled', true);
   $('.calcularProposta').prop('disabled', false);
}

function calculaTaxas()
{
    $entrada = parseFloat($('#input-valor').val());
    $meses = parseInt($('#change-meses').val());
    $valor =  parseFloat($imovel.val_pretendido) - $entrada;
    
    if($rPorcentagem == 0)
        console.log('erro, taxa igual a zero');
    
    $bancosAprovados = [];
    cont = 0;
    $.each($('.divImgBanco'), function(key,div){
        
        if($entrada >= $bancos[key].val_min && $entrada <= $bancos[key].val_max) 
        {
            id = $bancos[key].id_banco;
            $bancosAprovados[cont] = id;
            $(this).find('.img-off').hide();
            $(this).find('.img-on').show('clip');
            cont++;
        }
        else
        {
            $(this).find('.img-off').show();
            $(this).find('.img-on').hide();
        }
    });
    
    $amortizacao = $valor/$meses;
    
    //1a parcela = 306,94 + 0,72%*110500 = 1.102,54
    //2a parcela = 306,94 + 0,72%*(110500-1*306,94) = 1.100,33
    
    $rTotal = 0;
    
    $rPorcentMes = (($rPorcentagem/12)/100).toFixed(3);
    
    
    //console.log($rPorcentMes.toFixed(3));
    
    $rParcela = $amortizacao + $rPorcentMes*($valor);
    
    for($i=0;$i<$meses;$i++)
    {
        $parcela = $amortizacao + $rPorcentMes*($valor-$i*$amortizacao);
        $rTotal += $parcela;
    }
    
    /*$rParcela = 0;
    $rTotal = 0;*/
    //=500000*(1 + 8,9%*3)  juros total
    //Fórmula do Valor Futuro (ou Montante): F = P.(1 + i.n)
    /*$rTotal = $valor*(1 + $rPorcentagem*($meses/12));
    $rParcela = $rTotal/$meses;*/
    
    $('.valorJuros').text($rPorcentagem+'%');
    $('.valorTr').text('0%');
    $('.valorParcelas').text('R$ '+$rParcela.toFixed(2).toLocaleString('pt-BR'));
    $('.valorUltimaParcela').text('R$ '+$parcela.toFixed(2).toLocaleString('pt-BR'));
    $('.valorTotal').text('R$ '+$rTotal.toFixed(2).toLocaleString('pt-BR'));
    
    $('.enviarProposta').prop('disabled', false);
    $('.calcularProposta').prop('disabled', true);
    
    
}

function formatReal( int )
{
        var tmp = int+'';
        tmp = tmp.replace(/([0-9]{2})$/g, ",$1");
        if( tmp.length > 6 )
                tmp = tmp.replace(/([0-9]{3}),([0-9]{2}$)/g, ".$1,$2");

        return tmp;
}