// file comdono/lancamento.js

addToCart = function(){
    // track facebook pixel para catalogo dinamico
    if (typeof fbq !== 'undefined') { // apenas na prod
          
        fbq('track', 'AddToCart',{
          content_ids: ['742359892923039'],
          contents: [{'id': $('input[name=id_imovel]').val(), 'quantity': 1 }],
          content_type: 'HOME_LISTING'
        });
    }
}

$('.addToCart').click(function(){
    addToCart();
});

var container_form_capture = $(".container-form-capture").outerHeight();
var box_title = $(".box-title").outerHeight();
var total_box_capture = container_form_capture - box_title;
var widthWindow = $(this).width();

if(widthWindow > 992){
    setTimeout(function(){ 
        $(".box-arrow").trigger("click"); 
    }, 5000);
}

$(window).on('load', function(){
    //$('.modal-lancamento').modal('show');
    $(".container-form-capture").css({bottom: -total_box_capture})
});

$(".actClickArrow").click(function(){
    $(".box-arrow").trigger("click");
});

$("body").on("click", ".actArrowTop", function() {
    $(this).children().removeClass("fa-chevron-up").addClass("fa-chevron-down");
    $(this).removeClass("actArrowTop").addClass("actArrowDown");
    $(".container-form-capture").css({bottom: '0px'});
    clearForm();
});

$("body").on("click", ".actArrowDown", function() {
    $(this).children().removeClass("fa-chevron-down").addClass("fa-chevron-up");
    $(this).removeClass("actArrowDown").addClass("actArrowTop");
    $(".container-form-capture").css({bottom: - (total_box_capture) });
    clearForm();
});

//clickGallery
$(".clickGallery").on("click", function(){
    $("a.first").trigger("click");
});


$(document).on("click", ".filtrarImoveis", function() {
    
    data = {
        tipo_imovel: $("#tipo_imovel").val(),
        id_imovel: $("#id_imovel").val(),
        quartos: $("#qtd_quartos option:selected").val(),
        valor: $("#valor").val(),
        banheiros:  $("#qtd_banheiros option:selected").val(),
        metro_quadrado: $("#metro_quadrado").val(),
        vaga: $("#qtd_vagas_garagem option:selected").val(),
    }
    
    getImoveisLancamento(data);
});

function getImoveisLancamento(data = null) {

    loadButton($('.filtrarImoveis'));
  
  
      $.ajax({
        url: base_url + "comdono/ajax/busca_ajax/get_imoveis_lancamento",
        dataType: "json",
        type: "POST",
        data: data,
        success: function($imoveisLancamento) {
            
            $(".result_unidades").html("");
            $.each($imoveisLancamento, function(id, unidade) {
                $(".result_unidades").append(unidade.tr_html);
            });
            
            if ($imoveisLancamento.length === 0) {
                boxHtml = '<tr><td colspan="6"><div class="row m-0"><div class="col p-0">';
                boxHtml +='<p>Ops! Imóvel não encontrado.</p>';
                boxHtml +='<p class="m-0">Infelizmente, ainda não temos ofertas disponíveis com os filtros selecionados. Por favor, tente novamente com outros dados.</p>';
                boxHtml +='</div></div></td></tr>';
                $(".result_unidades").append(boxHtml);
            }
            
            loadButton(null, false);
        },
        error: function(error) {
          loadButton(null, false);
        }
      });
}

$(document).on("click", ".verUnidades", function() {
    $(".box-view").hide();
    
    var box = $(this).data("box");
    $(".box-view-unidades-"+box).slideDown();
    
    $('html, body').animate(
    {
        scrollTop: $($(".box-view-unidades-"+box)).offset().top-150
    },1000);
    
});

$(document).on("click", ".closeUnidades", function() {
    $(this).parents(".box-view").slideUp();
});

//galeria
$("#mygallery").justifiedGallery({
    rowHeight: 300,
    margins: 20
});

$(".mygallery").justifiedGallery({
    rowHeight: 300,
    margins: 20
});

//form captura
$('#formCapturaLancamento').submit(function(){
    
    data = { 
        "origem_captura": "interessado_lancamento",
        "link": $("input[name='link']").val(),
        "nome": $("input[name='nome']").val(), 
        "email": $("input[name='email']").val(),
        "telefone": $("input[name='telefone']").val()
    };
    
    loadButton($('#formCapturaLancamento button.btn-primary'));
	
	$.ajax({
		url: base_url+"landingpage/ajax/captura_ajax/captura_lancamento",
		dataType: 'json',
		type: 'POST',
		data: data,
		success: function(retorno)
		{		
		    console.log(retorno);
			if (retorno.valid == true)
			{
			    window.open('https://api.whatsapp.com/send?phone=5561994483087&text=Olá! quero mais detalhes sobre preços e unidades disponíveis do empreendimento '+$("input[name='link']").val()+'.','_blank');
                clearForm();
			}
			else
			{ 
			    loadButton(null,false);
			    ico = '<img src="'+base_url+'/assets/img/comdono/icons/error.png">';
    	        $('#formCapturaLancamento .content_result').html('<label class="error-login"><span>'+ico+'</span>'+retorno.msg+'</label>');
			}
		},
		error: function(error)
		{ 
		    loadButton(null,false);
			ico = '<img src="'+base_url+'/assets/img/comdono/icons/error.png">';
	        $('#formCapturaLancamento .content_result').html('<label class="error-login"><span>'+ico+'</span>Erro! Tente novamente mais tarde.</label>');
		}
	});
	return false;
});

function clearForm(){
    $("input[name='nome']").val("");
    $("input[name='email']").val("");
    $("input[name='telefone']").val("");
    
    loadButton(null,false);
    
    $('#formCapturaLancamento .content_result').html("");
}