<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Busca extends Comdono_Controller {

	function __construct()
	{
		parent::__construct();
		
		Assets::add_css(array(
            'plugins/owlcarousel2-2.3.4/css/owl.carousel.min',
            'plugins/owlcarousel2-2.3.4/css/owl.theme.default.min',
            'plugins/btnSwitch/jquery.btnswitch'
        ));
        
        Assets::add_js(array(
            'plugins/owlcarousel2-2.3.4/js/owl.carousel.min',
            'plugins/btnSwitch/jquery.btnswitch'
        ));
        
        Assets::add_module_js('comdono', array(
            'actions'
        ));
        
		$this->load->helper('comdono/comdono');
		//$this->load->helper('cookie');
		$this->load->model('busca_model');
	}
	
	public function teste()
	{
	    echo(get_cookie('cookie_name'));
        set_cookie('cookie_name','cookie_value','3600');
	}
    
    public function index()
    {
        $data["menu_home"] = true;
        //Template::set("menu_home",true);
        $data['active'] = "ofertas";
        
        
        //delete_cookie('cookie_primeiravez'); 
        if(get_cookie('cookie_primeiravez') != 'primeiro'){
            set_cookie('cookie_primeiravez','primeiro',time() + (10 * 365 * 24 * 60 * 60));
            //redirect('apresentacao');
        }
        
        $post = $this->input->post();
        
        if($this->uri->segment(2) == 'imovel')
	    {
            $id_imovel = $this->uri->segment(3);
            $key_anuncio = $this->uri->segment(4);
            redirect('imovel/'.$id_imovel.'/'.$key_anuncio);
	    }
	    elseif($this->uri->segment(2) == 'lancamentos')
	    {
	        $this->session->set_userdata('lancamento', 'SIM');
	        redirect('busca');
	    }
	    elseif($this->uri->segment(2) !== NULL && !isset($post['pesquisa']))
	    {
	        $post['pesquisa'] = str_replace('-',' ',$this->uri->segment(2));
	    }
        
        Assets::add_module_css('comdono', array(
            'switch'
        ));
        Assets::add_module_js('comdono', array(
            'carousel_busca',
            'busca',
            'loading_image',
            'desinscricao'
        ));
        
        Assets::add_js(array(
            'https://developers.google.com/maps/documentation/javascript/examples/markerclusterer/markerclusterer.js'
        ));
        
	    $where = [];
	    $like = [];
	    $or_where = [];
	    $or_like = [];
	    
	    $post['intencao'] = $post['intencao'] ?? '{"para_morar":0,"para_trabalhar":0}';
	       
	    $intencao = json_decode($post['intencao']);
	    
	    $this->session->set_userdata('referer_login', 'busca');
	    //var_dump($intencao);
	    
        if($intencao->para_morar == 1)
            $where[] = ['tipo_imovel !=','Comercial'];
        elseif($intencao->para_trabalhar == 1)
            $where[] = ['tipo_imovel','Comercial'];
	       
	    if(isset($post['pesquisa']) && $post['pesquisa'] != ''){
	        $pes = trim($post['pesquisa']);
	        $or_like[] = ['id_imovel', $pes];
	        $or_like[] = ['cidade', $pes];
	        $or_like[] = ['bairro', $pes];
	        $or_like[] = ['endereco', $pes];
	        $or_like[] = ['dn_nome_nomefantasia', $pes];
	        $or_like[] = ['complemento', $pes];
	    }
	    if(($post['valor']??0) > 0){
	        $valIni = $post['valor'] - ($post['valor']*0.2);
	        $valFim = $post['valor'] + ($post['valor']*0.2);
	        $where[] = ['val_pretendido >=',$valIni];
	        $where[] = ['val_pretendido <=',$valFim];
	    }
	    
	    $lancamento = $this->session->lancamento;
	    if($lancamento == 'SIM')
	    {
	        $this->session->unset_userdata('lancamento');
	        $where[] = ['lancamento','Sim'];
	    }
	    
	    if(empty($or_like) && empty($where) && $this->uri->segment(1) == null){
	        $imoveisBairro = $this->busca_model->getSelectBusca();
            foreach ($imoveisBairro as $id_imovel=>$imovel)
            {
                $arrayBairros[$imovel->bairro] = $imovel->bairro;
            }
	        $data['tiposImovel']     = [];
            $data['bairrosImovel']   = $arrayBairros;
            $data['imoveis']         = [];
            $data['countBairro']     = json_encode([]);
            $data['countQuadra']     = json_encode([]);
            $data['countConjunto']   = json_encode([]);
            $data['countImoveis']    = json_encode([]);
            $data['idsImoveis']      = [];
	    }
	    else 
	        $data = $this->getDataBusca($where, $like, $or_where, $or_like);
	    
	    
	    
	    $intencao = $post;
        $intencao['result'] = json_encode($data['idsImoveis']);
        $intencao['cont_result'] = count($data['imoveis']);
        $intencao['id_cadastro'] = $this->session->id_cadastro??0;
        $intencao['data_hora_busca'] = date("Y-m-d H:i:s");
        
        if($intencao['id_cadastro'] == 0){
            
            $intencoes_busca = $this->session->intencoes_busca;
            $intencoes_busca[] = $intencao;
            $this->session->set_userdata(['intencoes_busca'=>$intencoes_busca]);
            $data['intencoes_busca'] = $intencoes_busca;
        }
        else{
            $data['intencoes_busca'][] = $intencao;
            $this->cad_model->setIntencaoBusca($intencao);
        }
	    
	    $data['body']['class'] = 'bg-busca autocomplete-responsive';
	    
	    $data['pesquisa'] = $post['pesquisa']??''; 
	    
	    //$data['linkRedict'] = $imovel->lancamento == 'Sim'?base_url('lancamento/'.$imovel->id_imovel):base_url('imovel/'.$imovel->id_imovel);
	    
	    $data['url'] = $this->loginUrl();
	    
	    $data['lancamento'] = 'NAO';
	    if($lancamento == 'SIM')
	        $data['lancamento'] = 'SIM';
	    
	    $data['ppFavorito'] = $this->meuCadastro->aviso_curtir??1;
	    
	    if($this->uri->segment(1) == null)
	    {
	        $data['body']['class'] = 'bg-home autocomplete-responsive';
	        
            Assets::add_css(array(
                '../plugins/cb-slideshow/css/style1',
                'css/style'
            ));
            Assets::add_js(array(
                'plugins/cb-slideshow/js/modernizr',
                'https://developers.google.com/maps/documentation/javascript/examples/markerclusterer/markerclusterer.js'
            ));
            
            $data["page"] = 1;
            Template::load_view('home_view', $data, '', '', $data['view']);
            Template::load_view('modern_view', $data, '', '', $data['modern_view']);
	    }
	    
	    $desinscricao = $this->session->flashdata('desinscricao');
	    if($desinscricao == true){
    	    Template::set_modal($data,[
                'comdono/modal/desinscricao_view'
            ]);
	    }
	    
	    Template::set($data);
        Template::set_view('busca_view');
        Template::render();
    }
    
    public function lancamento()
    {
        Assets::add_css(array(
            'plugins/justified-gallery-master/justifiedGallery.min',
            'plugins/fancyBox-v3.5.7/css/jquery.fancybox.min',
            'plugins/multiple-emails/css/multiple-emails',
            'plugins/wow_animation/css/animate'
        ));
        Assets::add_js(array(
            'plugins/justified-gallery-master/justifiedGallery.min',
            'plugins/fancyBox-v3.5.7/js/jquery.fancybox.min',
            'plugins/morecontent/jquery.morecontent.lite',
            'plugins/multiple-emails/js/multiple-emails',
            'plugins/wow_animation/js/wow.min',
            'plugins/wow_animation/js/script'
        ));
        Assets::add_module_css('landingpage', array(
            'style'
        ));
        Assets::add_module_css('comdono', array(
            'lancamento'
        ));
        Assets::add_module_js('comdono', array(
            'loading_image',
            'imovel',
            'lancamento'
        ));
        
        $id_imovel = $this->uri->segment(2);
        $key_lancamento = $this->uri->segment(3);
        $imovel = $this->busca_model->getLancamentoById($id_imovel);
        if($imovel != null)
        {
            $key = HImovel::montaKeyLancamento($imovel);
            
            if($imovel->lancamento != 'Sim')   redirect('imovel/'.$id_imovel);
            
            if($imovel->id_imovel_rel != 0)    redirect('lancamento/'.$imovel->id_imovel_rel);
            
            if($key_lancamento == null)        redirect('lancamento/'.$id_imovel.'/'.$key);
                
            if($key != $key_lancamento)        redirect('lancamento/'.$id_imovel.'/'.$key);
            
            if($imovel->status_lancamento != 3)
            {
                $visualiza = $this->input->get('visualizacao', TRUE); 
                if($this->session->perfil > 0  || $imovel->id_cadastro == $this->session->id_cadastro || $visualiza == 'true')
                    $data['navAdmin'] = true;
                else
                    redirect('busca');
            }
        }
        else
        {
            redirect('busca');
        }
        
        $data['cad_perfil'] = $this->busca_model->get_cadastro([],$imovel->id_cadastro);
        $data['imovel'] = $imovel;
        $data['galeria'] = [];
        if (!empty($imovel->imagens)) {
            foreach ($imovel->imagens as $img) {
                $data['galeria'][] = base_url($img->uri.$img->imagem);
            }
        }
        $data['galeriaJson'] = json_encode($data['galeria']);
        if (!empty($imovel->imagens)) { 
            $data['imagens'] = $imovel->imagens;
        }
        $data['arrayImovel'] = HImovel::getDetalhesImovel($imovel);
        $data['arrayCondominio'] = HImovel::getDetalhesComdominio($imovel);
        $where[] = [['a.id_imovel',$id_imovel],['id_imovel_rel',$id_imovel]];
        $imoveisLancamento = $this->busca_model->getImoveis($where);
        foreach ($imoveisLancamento as $imovell)
        {
            $imoveis[$imovell->quartos][] = $imovell;
            
            if((!isset($porquarto[$imovell->quartos]->val_pretendido))  ||   $porquarto[$imovell->quartos]->val_pretendido > $imovell->val_pretendido){
                    $porquarto[$imovell->quartos] = $imovell;
            }
            $porquarto[$imovell->quartos]->imoveis = $imoveis[$imovell->quartos];
        }
        $data['imoveisLancamento'] = $porquarto??[];
        $data['favoritos'] = $this->busca_model->get_favoritos();
        $arrayTipos = [];
        foreach ($data['imoveisLancamento'] as $imv){
            $arrayTipos[$imv->tipo_imovel] = $imv->tipo_imovel;
        }
        $data['tiposImovel'] = HBusca::getSelectTiposImovel($arrayTipos);
        $view_lancamento = $this->cad_model->getViewLancamento([["id_lancamento",$id_imovel]]);
        $data["link"] = base_url().$this->uri->uri_string();
        $data["origem"] = "lancamento_".$this->uri->segment(2);
        $data['tipo_localizacao'] = 0;
        
        //views customs
        if($view_lancamento !== NULL){
            
            Template::set_modal($data,[
                'comdono/modal/cadastro_cupom_view'
            ]);
            
            $data["view_lancamento"] = $view_lancamento->view;
            
            if($view_lancamento->view == "lancamento_faenge_b_view" || $view_lancamento->view == "lancamento_signature_view"){
                Assets::add_module_css('comdono', array(
                    'lancamento_faenge'
                ));
                // força o método ser sempre index para gerar css e js único
                $this->router->method = 'lancamento_custom';
                $this->router->module = 'comdono';
            }
            
            if($view_lancamento->view == "lancamento_elleven_view"){
                Assets::add_module_css('comdono', array(
                    'lancamento_elleven'
                ));
                Assets::add_module_js('comdono', array(
                    'lancamento_elleven'
                ));
                // força o método ser sempre index para gerar css e js único
                $this->router->method = 'lancamento_elleven';
                $this->router->module = 'comdono';
                
                if($this->input->get('utm_source', TRUE) !== NULL)
                {   
                    $origem = [
                        'origem'        => "Elleven",
                        'link'          => base_url(uri_string()),
                        'utm_source'    => $this->input->get('utm_source', TRUE),
                        'utm_medium'    => $this->input->get('utm_medium', TRUE),
                        'utm_campaign'  => $this->input->get('utm_campaign', TRUE),
                        'utm_term'      => $this->input->get('utm_term', TRUE),
                        'utm_content'   => $this->input->get('utm_content', TRUE),
                    ];
                    $this->session->set_userdata('origem', $origem);
                }
                
                Template::set_modal($data,[
                    'comdono/modal/passeio_elleven_view',
                ]);
            }
            
            if($view_lancamento->view == "lancamento_attos_liberty_view"){
                Assets::add_module_css('comdono', array(
                    'lancamento_attos_liberty'
                ));
                Assets::add_module_js('comdono', array(
                    'lancamento_attos_liberty'
                ));
                // força o método ser sempre index para gerar css e js único
                $this->router->method = 'lancamento_attos_liberty';
                $this->router->module = 'comdono';
            }
            
            if($view_lancamento->view == "lancamento_attos_liberty_b_view"){
                Assets::add_module_css('comdono', array(
                    'lancamento_attos_liberty_b'
                ));
                Assets::add_module_js('comdono', array(
                    'lancamento_attos_liberty'
                ));
                
                $data['imovel']->imagens = Himg::galeriaPremium($imovel->imagens);
            
                $data['galeria'] = json_encode($data['imovel']->imagens);
                
                // força o método ser sempre index para gerar css e js único
                $this->router->method = 'lancamento_attos_liberty';
                $this->router->module = 'comdono';
                
                Template::set_modal($data,[
                    'comdono/modal/passeio_liberty_view',
                ]);
            }
            
            if($view_lancamento->view == "lancamento_exclusive_view"){
                Assets::add_module_css('comdono', array(
                    'lancamento_exclusive'
                ));
                Assets::add_module_js('comdono', array(
                    'lancamento_exclusive'
                ));
                // força o método ser sempre index para gerar css e js único
                $this->router->method = 'lancamento_exclusive';
                $this->router->module = 'comdono';
            }
            
            if($view_lancamento->view == "lancamento_exclusive_b_view"){
                Assets::add_module_css('comdono', array(
                    'lancamento_exclusive_b'
                ));
                Assets::add_module_js('comdono', array(
                    'lancamento_exclusive'
                ));
                // força o método ser sempre index para gerar css e js único
                $this->router->method = 'lancamento_exclusive_b';
                $this->router->module = 'comdono';
                
                Template::set_modal($data,[
                    'comdono/modal/passeio_exclusive_view',
                ]);
            }
            
            if($view_lancamento->view == "lancamento_elegance_view"){
                Assets::add_module_css('comdono', array(
                    'lancamento_elegance'
                ));
                Assets::add_module_js('comdono', array(
                    'lancamento_elegance'
                ));
                // força o método ser sempre index para gerar css e js único
                $this->router->method = 'lancamento_elegance';
                $this->router->module = 'comdono';
                
                Template::set_modal($data,[
                    'comdono/modal/passeio_elegance_view',
                ]);
            }
            
            if($view_lancamento->view == "lancamento_excellence_view"){
                Assets::add_module_css('comdono', array(
                    'lancamento_excellence'
                ));
                Assets::add_module_js('comdono', array(
                    'lancamento_excellence'
                ));
                // força o método ser sempre index para gerar css e js único
                $this->router->method = 'lancamento_excellence';
                $this->router->module = 'comdono';
                
                Template::set_modal($data,[
                    'comdono/modal/passeio_excellence_view'
                ]);
            }
            
            if($view_lancamento->view == "lancamento_signature_b_view"){
                Assets::add_module_css('comdono', array(
                    'lancamento_signature_b'
                ));
                Assets::add_module_js('comdono', array(
                    'lancamento_signature_b'
                ));
                
                $data['imovel']->imagens = Himg::galeriaPremium($imovel->imagens);
            
                $data['galeria'] = json_encode($data['imovel']->imagens);
                
                // força o método ser sempre index para gerar css e js único
                $this->router->method = 'lancamento_signature_b';
                $this->router->module = 'comdono';
                
                Template::set_modal($data,[
                    'comdono/modal/passeio_signature_view'
                ]);
            }
            /*if($view_lancamento->view == "lancamento_lp_view"){
                Assets::add_module_css('comdono', array(
                    'lancamento_lp'
                ));
                Assets::add_module_js('comdono', array(
                    'lancamento_lp'
                ));
                // força o método ser sempre index para gerar css e js único
                $this->router->method = 'lancamento_lp';
                $this->router->module = 'comdono';
                
                
                
                Template::set_modal($data,[
                    'comdono/modal/passeio_lp_view'
                ]);
            }*/
            $data['tipo_localizacao'] = 1;
            
            Template::set_view($view_lancamento->view);
        }
        else{ //whitelabel
        
            $lpConfig =  $this->cad_model->getLpConfig([['id_imovel',$id_imovel]]);
            
            if($lpConfig != null)
            {
                Assets::add_css(array(
                    'plugins/twentytwenty/css/twentytwenty'
                ));
                
                Assets::add_js(array(
                    'plugins/twentytwenty/js/jquery.event.move',
                    'plugins/twentytwenty/js/jquery.twentytwenty'
                ));
                
                Assets::add_module_css('comdono', array(
                    'lancamento_lp'
                ));
                Assets::add_module_js('comdono', array(
                    'empreendimento/lancamento_lp'
                ));
                $this->router->method = 'lancamento_lp_view';
                $this->router->module = 'comdono';
                
                $data['empreendimento'] = $empreendimento = $this->cad_model->getEmpreendimento([['id_imovel',$id_imovel]]);
                
                if($this->input->get('utm_source', TRUE) !== NULL || $this->input->get('fbclid', TRUE) !== NULL)
                {   
                    $origem = [
                        'origem'        => $empreendimento->emp_nome_fantasia,
                        'link'          => base_url(uri_string()),
                        'utm_fbclid'    => $this->input->get('fbclid', TRUE),
                        'utm_source'    => $this->input->get('utm_source', TRUE),
                        'utm_medium'    => $this->input->get('utm_medium', TRUE),
                        'utm_campaign'  => $this->input->get('utm_campaign', TRUE),
                        'utm_term'      => $this->input->get('utm_term', TRUE),
                        'utm_content'   => $this->input->get('utm_content', TRUE),
                    ];
                    $this->session->set_userdata('origem', $origem);
                }
                
                //$data['incorporadora'] = $this->cad_model->getIncorporadora([['id_incorporadora',$empreendimento->id_incorporadora]]);
                
                $this->load->model('administrativo/admin_model');
        
                $data['parceirosSelecionados'] = $this->admin_model->getParceirosEmpreendimento(['id_empreendimento',$empreendimento->id_empreendimento]);
                
                $data['parceirosInline'] = false;
                foreach ($data['parceirosSelecionados'] as $parc){
                    
                    $parc->incorporadora = $this->cad_model->getIncorporadora([['id_incorporadora',$parc->id_incorporadora]]);
                    
                    if(empty($parc->incorporadora->lpconfig_titulo)){
                        $data['parceirosInline'] = true;
                    }
                }
                
                $lpConfig->comodidades = $this->cad_model->getComodidades([['id_config',$lpConfig->id_config],['status',1]]);
                
                $lpConfig->diferenciais = $this->cad_model->getDiferenciais([['id_config',$lpConfig->id_config],['status',1]]);
                
                $lpConfig->unidades = $this->cad_model->getUnidades([['id_config',$lpConfig->id_config],['status >',0]]);
                
                $data['imgCapa'] = ($data['imovel']->imagens[0]->uri??'').($data['imovel']->imagens[0]->imagem??'');
                
                $data['imovel']->imagens = Himg::galeriaPremium($imovel->imagens);
                
                //$data['imgCapa'] = $data['imovel']->imagens[0]['imagens'][0]->uri??''.$data['imovel']->imagens[0]['imagens'][0]->imagem??'';
                
                $data['galeria'] = json_encode($data['imovel']->imagens);
                foreach ($lpConfig->unidades as $k=>$unidade){
                    $lpConfig->unidades[$k]->imagens = [];
                    if($unidade->img_tipo == 2) {
                        $last = strrpos($unidade->img_url,"/");
                        $thumb = substr($unidade->img_url,0,$last).'/thumb'.substr($unidade->img_url,$last);
                        $headers = @get_headers($thumb);
                        if($headers && strpos( $headers[0], '200')) { 
                            $unidade->thumb = $thumb;
                        }
                        else
                            $unidade->thumb = $unidade->img_url;
                    }
                    foreach ($imovel->imagens as $key=>$obj) {
                        if($unidade->img == $obj['categoria']){
                            $images = $obj['imagens'];
                            foreach ($images as $img_galeria) {
                                $lpConfig->unidades[$k]->imagens[] = $img_galeria;
                            }
                        }
                    }
                }
                
                $data['config'] = $lpConfig;
                
                /*if($id_imovel == 984)//elleven prod (tagmanager)
                    $data['tagLp'] = true;*/
                
                if($lpConfig->global_site_tag)
                    $data['global_site_tag'] = $lpConfig->global_site_tag;
                
                
                Template::set_modal($data,[
                    'comdono/modal/passeio_configLp_view',
                ]);
                
                $this->loadSeo($lpConfig);
                
                //pixelFace
                if($lpConfig->tag_captura)
                    $data['tag_captura'] = $lpConfig->tag_captura;
                
                Template::set_view('lancamento_lp_view');
            }
            else
            {
                Template::set_modal($data,[
                'comdono/modal/login_view',
                'comdono/modal/compartilhar_view',
                ]);
                
                Template::set_view('lancamento_view');
            }
        }
        
        $data["menu_landingpage"] = true;
        
        $data['logado'] = $this->logado();
        
        Template::load_view('comdono/blocos_lancamento/fale_comdono_view', $data, '', '', $data['fale_comdono']);
        Template::load_view('comdono/blocos_lancamento/compartilhe_view', $data, '', '', $data['compartilhe_lancamento']);
        Template::load_view('comdono/blocos_lancamento/sobre_view', $data, '', '', $data['sobre_lancamento']);
        Template::load_view('comdono/blocos_lancamento/unidades_view', $data, '', '', $data['unidades_lancamento']);
        Template::load_view('comdono/blocos_lancamento/galeria_view', $data, '', '', $data['galeria_lancamento']);
        Template::load_view('comdono/blocos_lancamento/localizacao_view', $data, '', '', $data['localizacao_lacamento']);
        Template::set($data);
        Template::render();
    }
    
    public function xxxxlancamentos()
    {
        Assets::add_module_js('comdono', array(
            'carousel_busca',
            'busca',
            'loading_image'
        ));
        
        $post = $this->input->post();
	    $where = [];
	    $like = [];
	    $or_where = [];
	    $or_like = [];
        
        $id_imovel = $this->uri->segment(4);
        
        if($id_imovel > 0)
        {
            $imovel = $this->busca_model->getImovel([['a.id_imovel',$id_imovel],['lancamento', 'Sim']]);
            if($imovel == null)
                $where[] = ['lancamento', 'Sim'];
            elseif ($imovel->id_imovel_rel == 0) {
                $where[] = [['a.id_imovel',$id_imovel],['id_imovel_rel',$id_imovel]];
            }
            else{
                $where[] = [['a.id_imovel',$imovel->id_imovel_rel],['id_imovel_rel',$imovel->id_imovel_rel]];
            }
        }
        else
        {
            $where[] = ['lancamento', 'Sim'];
        }
        
        
	    $data = $this->getDataBusca($where, $like, $or_where, $or_like);
	    $data['pageLancamento'] = TRUE;
	    $data['ppFavorito'] = $this->session->ppFavorito??true;
        Template::set($data);
        Template::set_view('busca_view');
        Template::render();
    }
    
    private function getDataBusca($where = [], $like = [], $or_where= [], $or_like =[])
    {
        $logado = $this->tank_auth->is_logged_in();
        
        
        $favoritos = $this->busca_model->get_favoritos();
        $data['favoritos'] = $favoritos;
        
        $imoveisList = [];
        $countImoveis = [];
        $countConjunto = [];
        $countBairro = [];
        $countQuadra = [];
        $arrayTipos = [];
        $arrayBairros = [];
        
        $imoveisBairro = $this->busca_model->getSelectBusca();
        foreach ($imoveisBairro as $id_imovel=>$imovel)
        {
            $arrayBairros[$imovel->bairro] = $imovel->bairro;
        }
        $imoveis = $this->busca_model->getImoveis($where, $like, $or_where, $or_like, ['a.id_imovel' => 'DESC']);//[],[['bairro','ceilandia']]
        
        $data['idsImoveis'] = [];

        //Se mudar esse Foreach, Mudar Tambem no busca_ajax
        foreach ($imoveis as $id_imovel=>$imovel)
        {
            $data['idsImoveis'][] = $id_imovel;
            $keyBairro = trim($imovel->bairro);
            $contadorBairro[$keyBairro][] = $id_imovel;
            $position = (object)['lat'=> (float)$imovel->bairro_lat, 'lng'=> (float)$imovel->bairro_long];
            $countBairro[$keyBairro] = (object)['idImovel'=> $id_imovel, 'bairro' => $imovel->bairro, 'position' =>$position ,'lat'=> $imovel->bairro_lat, 'long'=> $imovel->bairro_long, 'count' => count($contadorBairro[$keyBairro])];
            
            //list($q1,$q2) = explode(' ',trim($imovel->endereco));
            //$quadra = $q1.' '.$q2;
            $quadra = $this->separaEndereco($imovel->endereco)->quadra;
            
            $latlong = $imovel->quadra_lat.$imovel->quadra_long;
            
            $contadorQuadra[$latlong][] = '';
            $countQuadra[$latlong] = (object)['idImovel'=> $id_imovel, 'quadra'=> $quadra, 'bairro' => $imovel->bairro, 'cep' => $imovel->cep, 'lat'=> $imovel->latitude, 'long'=> $imovel->longitude, 'count' => count($contadorQuadra[$latlong])];
            
            //$arrayConjunto = explode(' ',trim($imovel->endereco));
            //unset($arrayConjunto[0]);unset($arrayConjunto[1]);
            //$conjunto = (empty($arrayConjunto))? 'Rua' :implode(" ", $arrayConjunto);
            
            $conjunto = $this->separaEndereco($imovel->endereco)->conjunto;
            $keyConjunto = trim($imovel->endereco);
            $contadorConjunto[$keyConjunto][] = '';
            $countConjunto[$keyConjunto] = (object)['idImovel'=> $id_imovel, 'quadra'=> $quadra, 'bairro' => $imovel->bairro, 'endereco' => $imovel->endereco, 'conjunto'=> $conjunto, 'cep' => $imovel->cep, 'lat'=> $imovel->latitude, 'long'=> $imovel->longitude, 'count' => count($contadorConjunto[$keyConjunto])];
            
            $divCore = '';
            if($logado)
            {
                $color = isset($favoritos[$imovel->id_imovel]) ? 'btn_descurtir color_red' : 'btn_curtir color_grey';
                $title = isset($favoritos[$imovel->id_imovel]) ? 'Remover dos favoritos' : 'Adicionar como favorito';
                $divCore = '<div class="box-favoritos actFavoritos core_'.$imovel->id_imovel.' '.$color.'" title="'.$title.'" data-id="'.$imovel->id_imovel.'" >';
                $divCore .= '<i class="fa fa-heart" aria-hidden="true"></i>';
                $divCore .= '</div>';
            }
            
            $idImovelRel = $imovel->id_imovel_rel;
            if( $idImovelRel > 0 ){
                $contadorImovel[$idImovelRel][] = '';
                if(!isset($imoveisList[$idImovelRel]->val_pretendido)  ||   $imoveisList[$idImovelRel]->val_pretendido > $imovel->val_pretendido){
                    $countImoveis[$idImovelRel] = $this->montaImovelCount($id_imovel,$imovel,$contadorImovel,$idImovelRel,$divCore);
                    $imoveisList[$idImovelRel] = $imovel;
                }
                $countImoveis[$idImovelRel]->count = count($contadorImovel[$idImovelRel]??['']);
            }
            else{
                $contadorImovel[$id_imovel][] = '';
                if(!isset($imoveisList[$id_imovel]->val_pretendido)  ||   $imoveisList[$id_imovel]->val_pretendido > $imovel->val_pretendido){
                    $countImoveis[$id_imovel] = $this->montaImovelCount($id_imovel,$imovel,$contadorImovel,$id_imovel,$divCore);
                    $imoveisList[$id_imovel] = $imovel;
                }
                $countImoveis[$id_imovel]->count = count($contadorImovel[$id_imovel]??['']);
            }
            $imoveisLista[$id_imovel] = $this->montaImovelCount($id_imovel,$imovel,$contadorImovel,$id_imovel,$divCore);
            
            $arrayTipos[$imovel->tipo_imovel] = $imovel->tipo_imovel;
            //$arrayBairros[$imovel->bairro] = $imovel->bairro;
            
            //if($imovel->lancamento == 'Sim' && $imovel->id_imovel_rel > 0)
                //unset($imoveis[$id_imovel]);
        }
        
        $data['tiposImovel']     = HBusca::getSelectTiposImovel($arrayTipos);
        $data['bairrosImovel']   = $arrayBairros;
        $data['imoveis']         = $imoveisList;
        $data['countBairro']     = json_encode($countBairro);//$this->busca_model->getCountBairro());
        $data['countQuadra']     = json_encode($countQuadra);
        $data['countConjunto']   = json_encode($countConjunto);
        $data['countImoveis']    = json_encode($countImoveis);
        
        return $data;
    }
    
    private function separaEndereco($endereco)
    {
        $arrayEnd = explode(' ',trim($endereco));
        switch (count($arrayEnd)) {
            case 1:
                $quadra = $arrayEnd[0];
                $conjunto = $arrayEnd[0];
                break;
            case 2:
                $quadra = $arrayEnd[0].' '.$arrayEnd[1];
                $conjunto = $arrayEnd[0].' '.$arrayEnd[1];
                break;
            case 3:
                $quadra = $arrayEnd[0].' '.$arrayEnd[1].' '.$arrayEnd[2];
                $conjunto = $arrayEnd[0].' '.$arrayEnd[1].' '.$arrayEnd[2];
                break;
            case 4:
                $quadra = $arrayEnd[0].' '.$arrayEnd[1];
                $conjunto = $arrayEnd[2].' '.$arrayEnd[3];
                break;
            default:
                $quadra = implode(" ", $arrayEnd);
                //unset($arrayEnd[0]);unset($arrayEnd[1]);unset($arrayEnd[2]);
                $conjunto = implode(" ", $arrayEnd);
                break;
        }
        return (object)['quadra'=>$quadra, 'conjunto'=> $conjunto];
    }
    
    private function montaImovelCount($id_imovel,$imovel,$contadorImovel,$key,$divCore)
    {
        if (!empty($imovel->imagens)) { 
            $baseImg = $imovel->imagens[0]->uri;
            $img     = $imovel->imagens[0]->imagem;
            // para o carousel // foreach ($imovel->imagens as $img_galeria) {HImg::alt($img_galeria); HImg::ref($img_galeria);  HImg::desc($img_galeria);            }
        } else {
            $baseImg = 'themes/comdono/img/';
            $img     = 'no-image-gallery.png';
            //<img src="<?php e(base_url('themes/comdono/img/no-image-gallery.png'))
        } 
        return  (object)[
                'idImovel'  => $id_imovel,
                'idImovelRel' => $imovel->id_imovel_rel,
                'id_cadastro' => $imovel->id_cadastro,
                'dn_nome_nomefantasia' => $imovel->dn_nome_nomefantasia,
                'bairro' => $imovel->bairro,
                'endereco' => $imovel->endereco,
                'cidade' => $imovel->cidade,
                'estado' => $imovel->estado,
                'cep' => $imovel->cep,
                'baseImg' => $baseImg,
                'img' => $img,
                'valor' => number_format($imovel->val_pretendido, 2, ',', '.'),
                'val_pretendido' => $imovel->val_pretendido,
                'tipo_imovel' => $imovel->tipo_imovel,
                'metros' => $imovel->area_total,
                'quartos' => $imovel->quartos,
                'area_privativa' => $imovel->area_privativa,
                'suites' => $imovel->suites,
                'banheiros' => $imovel->banheiros,
                'lat' => $imovel->latitude,
                'long' => $imovel->longitude,
                'count' => count($contadorImovel[$key]??['']),
                'lancamento' => $imovel->lancamento,
                'divCore' => $divCore
                ];
    }
    
    public function imovel()
    {
        $id_imovel = $this->uri->segment(3);
        $key_anuncio = $this->uri->segment(4);
        redirect('imovel/'.$id_imovel.'/'.$key_anuncio);
    }
    
    private function loadSeo($lpConfig)
    {
        if($lpConfig != null)
        {
            $data["page_seo"] = true;
	        $data["url_header"] = $lpConfig->seo_site_url;
	        $data["image_header"] = $lpConfig->seo_img;
            $data["title_page"] = $lpConfig->seo_titulo;
            $data["imovel_description"] = $lpConfig->seo_descricao;
            
            Template::set($data);
        }
    }
    
    /*public function index_bk()
    {
        Assets::add_module_css('comdono', array(
            'switch'
        ));
        Assets::add_module_js('comdono', array(
            'carousel_busca',
            'busca',
            'loading_image'
        ));
        
        $post = $this->input->post();
	    $where = [];
	    $like = [];
	    $or_where = [];
	    $or_like = [];
	        
	    if(isset($post['pesquisa']) && $post['pesquisa'] != ''){
	        $pes = trim($post['pesquisa']);
	        $or_like[] = ['cidade', $pes];
	        $or_like[] = ['bairro', $pes];
	        $or_like[] = ['endereco', $pes];
	    }
	    
	    $data = $this->getDataBusca($where, $like, $or_where, $or_like);
	    //$data['linkRedict'] = $imovel->lancamento == 'Sim'?base_url('lancamento/'.$imovel->id_imovel):base_url('imovel/'.$imovel->id_imovel);
	    
	    
	    
	    $data['ppFavorito'] = $this->session->ppFavorito??true;
	    
        Template::set($data);
        Template::set_view('busca_view');
        Template::render();
    }*/
    
}