<?php if (!defined('BASEPATH')) exit('No direct script access allowed');



use FacebookAds\Object\Ad;
use FacebookAds\Object\Lead;
use FacebookAds\Api;
use FacebookAds\Logger\CurlLogger;    

class Facebook extends Builder_Controller
{
    function __construct() 
    {
        parent::__construct();
        //$this->load->library('comdono/facebook');
        //require_once (FACEBOOK);
    }
    
    public function facebookInit() 
    {
        /***************************************************
         *
         * ATUALIZAR OS DADOS ABAIXO COM O FACEBOOK DA VB
         *
        ****************************************************/
        $this->fb = new Facebook\Facebook([
            'app_id' => '621568678375721', //143441776143616
            'app_secret' => '85a696fa93dd87cc11eb76f5032817b4', //e5498b1c8af6c074e33aede09c9814a1
            'default_graph_version' => 'v6.0', 
        ]);
        return $this->fb;
    }
    
    public function loginUrl() 
    {
        $data['referer'] = null;
        if(isset($_SERVER["HTTP_REFERER"]))
            $data['referer'] = $_SERVER["HTTP_REFERER"];
        
        $this->session->set_flashdata('referer',$data['referer']);
        
        $helper = $this->facebookInit()->getRedirectLoginHelper();
        //$callbackURL = base_url('cadastro/facebook/loginCallback');
        $callbackURL = base_url('comdono/facebook/loginCallback');
        $permissions = ['email', 'public_profile'];
        $loginUrl = $helper->getLoginUrl($callbackURL, $permissions);
        return $loginUrl;
    }
    
    public function cad_logs()
    {
        $access_token = '';
        $app_secret = '85a696fa93dd87cc11eb76f5032817b4';
        $app_id = '621568678375721';
        $id = '556808355157279';
        
        $api = Api::init($app_id, $app_secret, $access_token);
        $api->setLogger(new CurlLogger());
        
        $fields = array(
        );
        $params = array(
          'filtering' => array(array('field' => 'time_created','operator' => 'GREATER_THAN','value' => 1546549613)),
        );
        echo json_encode((new Ad($id))->getLeads(
          $fields,
          $params
        )->getResponse()->getContent(), JSON_PRETTY_PRINT);
    }
    
    
    public function getProfile($token) 
    {
        $fb = $this->facebookInit();
        if (ENVIRONMENT === 'development') 
        {
            try
            {
                // Returns a `Facebook\FacebookResponse` object
                // https://developers.facebook.com/docs/graph-api/reference/user
                $response = $fb->get('/me?fields=id,name,email', $token);
            }
            catch(Facebook\Exceptions\FacebookResponseException $e) 
            {
                $this->session->set_flashdata('erro_cadastro', 'Graph returned an error: ' . $e->getMessage());
                redirect('cadastro');
                exit;
            }
            catch(Facebook\Exceptions\FacebookSDKException $e) 
            {
                $this->session->set_flashdata('erro_cadastro', 'Facebook SDK returned an error: ' . $e->getMessage());
                redirect('cadastro');
                exit;
            }
        }
        else
        {
            try
            {
                $response = $fb->get('/me?fields=id,name,email', $token);
            }
            catch(Facebook\Exceptions\FacebookResponseException $e) 
            {
                $this->session->set_flashdata('erro_cadastro', 'Cadastro não pode ser realizado. Tente novamente mais tarde.');
                redirect('cadastro');
                exit;
            }
            catch(Facebook\Exceptions\FacebookSDKException $e) 
            {
                $this->session->set_flashdata('erro_cadastro', 'Cadastro não pode ser realizado. Tente novamente mais tarde.');
                redirect('cadastro');
                exit;
            }
        }
        $user = $response->getGraphUser();
        if(!(isset($user['name']) && $user['name'] != ''))
        {
            $this->session->set_flashdata('erro_cadastro', 'O cadastro não pode ser realizado. Acesse o seu Facebook, vá em "Configurações de aplicativos", remova o aplicativo Comdono da sua lista e tente novamente.');
                redirect('cadastro');
                exit;
        }
        if(!(isset($user['email']) && $user['email'] != ''))
        {
            $this->session->set_flashdata('erro_cadastro', 'O cadastro não pode ser realizado. Acesse o seu Facebook, vá em "Configurações de aplicativos", remova o aplicativo Comdono da sua lista e tente novamente.');
                redirect('cadastro');
                exit;
        }
        if(!(isset($user['id']) && $user['id'] != ''))
        {
            $this->session->set_flashdata('erro_cadastro', 'O cadastro não pode ser realizado. Acesse o seu Facebook, vá em "Configurações de aplicativos", remova o aplicativo Comdono da sua lista e tente novamente.');
                redirect('cadastro');
                exit;
        }
        
        $userData = array(
            'full_name' => $user['name'],
            'nome' => trim($user['name']),
            'sobrenome' => substr(strstr($user['name'], " ") , 1) ,
            'email' => $user['email'],
            'id' => $user['id']
        );
        return $userData;
    }
    
    public function loginCallback() 
    {
        $fb = $this->facebookInit();
        $helper = $fb->getRedirectLoginHelper();
        
        
        
        
        if (ENVIRONMENT === 'development') 
        {
            try
            {
                $accessToken = $helper->getAccessToken();
            }
            catch(Facebook\Exceptions\FacebookResponseException $e) 
            {
                // When Graph returns an error
                echo 'Graph returned an error: ' . $e->getMessage();
                exit;
            }
            catch(Facebook\Exceptions\FacebookSDKException $e) 
            {
                // When validation fails or other local issues
                echo 'Facebook SDK returned an error: ' . $e->getMessage();
                exit;
            }
            if (!isset($accessToken)) 
            {
                if ($helper->getError()) 
                {
                    header('HTTP/1.0 401 Unauthorized');
                    echo "Error: " . $helper->getError() . "\n";
                    echo "Error Code: " . $helper->getErrorCode() . "\n";
                    echo "Error Reason: " . $helper->getErrorReason() . "\n";
                    echo "Error Description: " . $helper->getErrorDescription() . "\n";
                    redirect(base_url('anunciante/cron/redirecionamento'));
                }
                else
                {
                    header('HTTP/1.0 400 Bad Request');
                    echo 'Bad request';
                    redirect('login');
                }
                exit;
            }
        }
        else
        {
            try
            {
                $accessToken = $helper->getAccessToken();
            }
            catch(Facebook\Exceptions\FacebookResponseException $e) 
            {
                $this->session->set_flashdata('erro_cadastro', 'Não foi possível conectar ao Facebook. Tente novamente.');
                redirect('cadastro');
                exit;
            }
            catch(Facebook\Exceptions\FacebookSDKException $e) 
            {
                $this->session->set_flashdata('erro_cadastro', 'Não foi possível conectar ao Facebook. Tente novamente.');
                redirect('cadastro');
                exit;
            }
            if (!isset($accessToken)) 
            {
                $this->session->set_flashdata('erro_cadastro', 'Não foi possível conectar ao Facebook. Tente novamente.');
                redirect('cadastro');
                exit;
            }
        }
        
        
        // Logged in
        $userData = $this->getProfile($accessToken->getValue());
        
        /************************************************
         * 
         * Dados necessários para o login via Facebook 
         * 
        ************************************************/
        $this->session->set_userdata('facebook_login', true);
        $this->session->set_userdata('facebook_data', $userData);
        
        if($this->pre_cadastro($userData)) 
        {
            $referer = $this->session->referer_login;
            if($referer != null)
                $this->session->set_userdata('referer_login', null);
            $result_url = $referer??'cadastro';
            
            if(!($this->session->redirect_login_face_modal == true))
                $result_url = base_url('minha-conta');
            
            $this->session->set_userdata('redirect_login_face_modal', false);
        }
        else
        {
            $result_url = 'cadastro';
            $this->session->set_flashdata('erro_cadastro', 'Cadastro não pode ser realizado. Tente novamente.');
        }
        
        redirect($result_url);
    }
    
    public function pre_cadastro($userData)
    {
        $data = $userData;
        if(Cad_model::getSysUserByEmail($data['email']) == null)
        {
            $cadastro = Cad_model::getCadastroByEmail($data['email']);
            $senha = '1sdfsdfdsf213dfdsfsdf123';
            $data['password'] = $this->password_hash('1sdfsdfdsf213dfdsfsdf123');
            $data['etapa'] = 1;
            $data['data_hora_cadastro'] = date("Y-m-d H:i:s");
            
            if(empty($cadastro))
            {
                $result = Cad_model::setCadUser($data);
            }
            else
            {
                $this->cad_model->updateCadastro($cadastro->id_cadastro,$data);
                $data['id_cadastro'] = $cadastro->id_cadastro;
                $result['id_cadastro'] = $cadastro->id_cadastro;
                $result['id_user']     = $this->cad_model->insertUser($data);
            }
            
            
            if(!empty($result)){
                $lembrar = 0;
                HEmail::alerta('Novo Pre Cadastro', $data['email']);
                $result = $this->tank_auth->login($data['email'], $senha, $lembrar, false, true, false);
                
                $intencoes_busca = $this->session->intencoes_busca;
                foreach (($intencoes_busca??[]) as $intencao){
                    $intencao['id_cadastro'] = $this->session->id_cadastro;
                    $this->cad_model->setIntencaoBusca($intencao);
                }
                $this->session->unset_userdata('intencoes_busca');
                
                return true;
            }
            else{    
                return false;
            }
            
            
            
        }else{
            return $this->tank_auth->login($data['email'], '', 0, false, true, false, 'facebook');
            
        }
    }
    
    public function BK_pre_cadastro($userData)
    {
            $data = $userData;
            if(empty($this->cad_model->getCadastro([ ['email', $data['email'] ] ])))
            {
                $senha = '1sdfsdfdsf213dfdsfsdf123';
                $data['password'] = $this->password_hash('1sdfsdfdsf213dfdsfsdf123');
                $data['etapa'] = 1;
                $data['data_hora_cadastro'] = date("Y-m-d H:i:s");
                
                if(!empty(Cad_model::setCadUser($data))){
                    $lembrar = 0;
                    HEmail::alerta('Novo Pre Cadastro', $data['email']);
                    $result = $this->tank_auth->login($data['email'], $senha, $lembrar, false, true, false);
                    
                    $intencoes_busca = $this->session->intencoes_busca;
                    foreach (($intencoes_busca??[]) as $intencao){
                        $intencao['id_cadastro'] = $this->session->id_cadastro;
                        $this->cad_model->setIntencaoBusca($intencao);
                    }
                    $this->session->unset_userdata('intencoes_busca');
                    
                    return true;
                }
                else{    
                    return false;
                }
            }else{
                return $this->tank_auth->login($data['email'], '', 0, false, true, false, 'facebook');
                
            }
    }
    
    private function password_hash($senha) 
    {
        // Hash password using phpass
        $hasher = new PasswordHash($this->config->item('phpass_hash_strength', 'tank_auth') , $this->config->item('phpass_hash_portable', 'tank_auth'));
        $senha = $hasher->HashPassword($senha);
        
        return $senha;
    }
    
    private function cadastrar($userData) 
    {
        $this->load->model('cadastros_model', 'cadastro');
        if ($this->cadastro->buscar_campo_user('email', $userData['email'])) 
        {
            /**
             * Caso o usuário já esteja cadastrado, retorna
            */
            return true;
        }
        $cadastro = array(
            'codigo' => $this->gerar_cod_associado() ,
            'nome' => $userData['nome'],
            'sobrenome' => $userData['sobrenome'],
            'email' => $userData['email'],
            'sexo' => null
        );
        $indicacao = $this->cadastro->check_indicacao($userData['email']);
        if (!is_null($indicacao)) 
        {
            $cadastro['cod_promotor'] = $indicacao;
            $dt_indicacao['cod_indicado'] = $cadastro['codigo'];
            $this->cadastro->set_cod_indicado_indicacao($this->input->post('email') , $dt_indicacao);
        }
        $user = array(
            'nome' => $userData['full_name'],
            'email' => $userData['email'],
            'activated' => 1,
            'created' => date("Y-m-d H:i:s") ,
            'perfil' => 3
        );
        if ($this->session->cod_promotor) 
        {
            $promotor = $this->session->cod_promotor;
            if($this->valida_promotor($promotor))
            {
                $cadastro['cod_promotor'] = $promotor;
            }
        }
        $result = $this->cadastro->insere_associado($cadastro, $user);
        
        return true;
    }
    
    private function valida_promotor($cod_promotor)
    {
        $this->load->model('cadastros_model', 'cadastro');
        $promotor = $this->cadastro->get_associado_by_code($cod_promotor);
        if($promotor !== null)
        {
            if($promotor[0]->check_promotor == '1')
            {
                return true;
            }else
            {
                $this->session->unset_userdata('cod_promotor');
                return false;
            }
        }
        else 
        {
            $this->session->unset_userdata('cod_promotor');
            return false;
        }
    }
    
    private function gerar_cod_associado() 
    {
        $this->load->model('cadastros_model', 'cadastros');
        $validade = false;
        while ($validade === false) 
        {
            $alpha = substr(str_shuffle("ABCDEFGHIJKLMNOPQRSTUVWXYZ") , 0, 2);
            $numeric = substr(str_shuffle("0123456789") , 0, 4);
            $code = str_shuffle($alpha . $numeric);
            $validade = $this->cadastros->valida_codigo_associado($code);
        }
        return $code;
    }
}