<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

    class Financiamento extends Comdono_Controller {
        
	function __construct()
	{
		parent::__construct();
		
		$this->load->model('cad_model');
		$this->load->model('busca_model');
		
		Assets::add_module_css('comdono', array());
        Assets::add_module_js('comdono', array('financiamento'));
	}
	
	public function simulacao_financiamento()
    {
        $id_imovel = 0;
        $imovel = (object)[
            'id_imovel'=>'', 
            'tipo_imovel'=>'0',
            'endereco' => '',
            'bairro' => '',
            ];
        
        if($this->logado())
        {
            $id_cadastro = $this->session->id_cadastro;
            $where = ['id_imovel'=> 0, 'id_cad_dono'=> 0, 'id_cad_interessado'=>$id_cadastro, 'step <' => 3];
            $simulacao = $this->cad_model->getSimulacoesFinanciamento($where);
            $simulacao = end($simulacao)==false?[]:end($simulacao);
            
            if($simulacao == null)
                 redirect('lp/financiamento');
                 
            if(($simulacao->step??0) == 0){
                $this->cad_model->updateSimulacao($simulacao->id_simulacao,['step'=>2]);
                //redirect('financiamento/simulacao/'.$id_imovel);
            }
            
            $data['bancos'] = $this->cad_model->getBancosFinanciamento();
            foreach ($data['bancos'] as $banco)
            {
                $banco->ativo = false;
                foreach ($simulacao->bancos as $aprovado)
                    if($banco->id_banco == $aprovado->id_banco)
                        $banco->ativo = true;
            }
            $etapa = 2;
            
                $this->router->method = 'index_etapa2';
                
                Assets::add_css(array(
                    'plugins/nouislider-12.1.0/css/nouislider.min',
                    'plugins/jquery.mobile-1.4.5/css/mobile.min'
                ));
                
                Assets::add_js(array(
                    'plugins/nouislider-12.1.0/js/nouislider.min',
                    'plugins/nouislider-12.1.0/js/wNumb'
                ));
                
                Assets::add_module_js('comdono', array('financiamento_slider'));
            
            $data['tipo_imovel'] = '';
            
            $data['endereco'] = '';
            $data['bairro'] = '';
            $data['imovel']       = $imovel;
            $data['simulacao'] = $simulacao;
            $data['etapa'] = $etapa; 
            
            $data['public_key'] = $this->db->where('name','captcha_public_key')->get('sys_config')->row()->value;
            
            Template::set($data);
            Template::set_view('financiamento_step_view');
            Template::render();
        }
        else
        {
            redirect('lp/financiamento');
        }
    }
	
	public function simulacao()
    {
        $id_imovel = $this->uri->segment(3);
        $imovel = $this->busca_model->getImovelById($id_imovel);
        if($imovel == null)
            redirect('busca');
        
        if($this->logado())
        {
            $id_cadastro = $this->session->id_cadastro;
            $where = ['id_imovel'=>$id_imovel, 'id_cad_interessado'=>$id_cadastro, 'step <' => 4];
            $simulacao = $this->cad_model->getSimulacaoFinanciamento($where);
            
            if(($simulacao->step??0) > 0){
                redirect('financiamento/cadastro/'.$id_imovel);
            }
            
            $valImovel = $imovel->val_pretendido;
            $min = [];
            $max = [];
            $data['bancos'] = $this->cad_model->getBancosFinanciamento();
            foreach ($data['bancos'] as $banco)
            {
                $min[] = $banco->entrada_min;
                $max[] = $banco->entrada_max;
                
                $banco->val_min = $valImovel*$banco->entrada_min;
                $banco->val_max = $valImovel*$banco->entrada_max;
            }
            
            
            
            $menorFinanciamento = min($min);
            $maiorFinanciamento = max($max);
            $menorEntrada = $valImovel*$menorFinanciamento;//$valImovel-($valImovel*$maiorFinanciamento);
            $maiorEntrada = $valImovel*$maiorFinanciamento;//$valImovel-($valImovel*$menorFinanciamento);
            
            //$menorEntrada = number_format($menorEntrada, 2, '.', '');
            //$maiorEntrada = number_format($maiorEntrada, 2, '.', '');
            
            //var_dump($menorEntrada);
            
            $data['imovel']       = $imovel;
            
            unset($imovel->complemento);
            $data['imovelEncode'] = json_encode($imovel);
            $data['banco']        = json_encode((object)[
                    'valImovel'           => $valImovel,
                    'menorFinanciamento'  => $menorFinanciamento,
                    'maiorFinanciamento'  => $maiorFinanciamento,
                    'menorEntrada'        => $menorEntrada,
                    'maiorEntrada'        => $maiorEntrada,
            ]);
            $data['bancosEncode'] = json_encode($data['bancos']);
            
            $this->router->method = 'index_etapa1';
            Assets::add_css(array(
                'plugins/nouislider-12.1.0/css/nouislider.min',
                'plugins/jquery.mobile-1.4.5/css/mobile.min'
            ));
            
            Assets::add_js(array(
                'plugins/nouislider-12.1.0/js/nouislider.min',
                'plugins/nouislider-12.1.0/js/wNumb'
            ));
            
            Assets::add_module_js('comdono', array('financiamento_slider'));
            
            $data['simulacao'] = $simulacao;
            Template::set($data);
            Template::set_view('etapas_financ/etapa1');
            Template::render();
        }
        else
        {
            redirect('imovel/'.$id_imovel);
        }
    }
    
    public function cadastro()
    {
        $id_imovel = $this->uri->segment(3);
        $imovel = $this->busca_model->getImovelById($id_imovel);
        if($imovel == null)
            redirect('busca');
        
        
        if($this->logado())
        {
            $id_cadastro = $this->session->id_cadastro;
            $where = ['id_imovel'=>$id_imovel, 'id_cad_interessado'=>$id_cadastro, 'step <' => 3];
            $simulacao = $this->cad_model->getSimulacoesFinanciamento($where);
            $simulacao = end($simulacao)==false?[]:end($simulacao);
            
             
            if(($simulacao->step??0) == 0){
                redirect('financiamento/simulacao/'.$id_imovel);
            }
            
            $data['bancos'] = $this->cad_model->getBancosFinanciamento();
            foreach ($data['bancos'] as $banco)
            {
                $banco->ativo = false;
                foreach ($simulacao->bancos as $aprovado)
                    if($banco->id_banco == $aprovado->id_banco)
                        $banco->ativo = true;
            }
            $etapa = 2;
            
                $this->router->method = 'index_etapa2';
                
                Assets::add_css(array(
                    'plugins/nouislider-12.1.0/css/nouislider.min',
                    'plugins/jquery.mobile-1.4.5/css/mobile.min'
                ));
                
                Assets::add_js(array(
                    'plugins/nouislider-12.1.0/js/nouislider.min',
                    'plugins/nouislider-12.1.0/js/wNumb'
                ));
                
                Assets::add_module_js('comdono', array('financiamento_slider'));
            
            $data['imovel']       = $imovel;
            $data['simulacao'] = $simulacao;
            $data['etapa'] = $etapa; 
            
            $data['public_key'] = $this->db->where('name','captcha_public_key')->get('sys_config')->row()->value;
            
            Template::set($data);
            Template::set_view('financiamento_step_view');
            Template::render();
        }
        else
        {
            redirect('imovel/'.$id_imovel);
        }
    }
	
	/*public function index()
    {
        if($this->tank_auth->is_logged_in())
        {
            $etapa = 2;
            
            if($etapa == 1 || $etapa == 3){
                
                $this->router->method = 'index_etapa2';
                
                Assets::add_css(array(
                    'plugins/nouislider-12.1.0/css/nouislider.min',
                    'plugins/jquery.mobile-1.4.5/css/mobile.min'
                ));
                
                Assets::add_js(array(
                    'plugins/nouislider-12.1.0/js/nouislider.min',
                    'plugins/nouislider-12.1.0/js/wNumb'
                ));
                
                Assets::add_module_js('comdono', array('financiamento_slider'));
            }
            
            $data['tiposImovel'] = HBusca::getSelectTiposImovel();
            
            $data['etapa'] = $etapa; 
            Template::set($data);
            Template::set_view('etapas_financ/etapa1');
            Template::render();
        }
        else
        {
            redirect();
        }
    }*/
}