<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Precadastro extends Comdono_Controller {

	function __construct()
	{
		parent::__construct();
		
		$this->load->model('cad_model');
		Assets::add_module_css('comdono', array(
            'btn-switch',
            'jasny-bootstrap.min'
        ));
        Assets::add_module_js('comdono', array(
            'jasny-bootstrap.min'
        ));
	}
	
	public function index()
    {
        if($this->tank_auth->is_logged_in())
        {
            $cad = $this->cad_model->get_cadastro();
            
            if($cad->etapa == 8)
                redirect();
            
            $data['cad'] = $cad;    
            $data['etapa'] = $cad->etapa;
            
            $data["page"] = 3;
            
            Template::set($data);
            Template::set_view('cadastro_step_view');
        }
        else
        {
            $data["page"] = 3;
            
            Template::load_view('cadastro_view', $data, '', '', $data['view']);
            
            Template::set($data);
            Template::set_view('modern_view');
        }
        
        Assets::add_module_js('comdono', array(
            'cadastro'
        ));
        
        Assets::add_css(array(
            'plugins/cb-slideshow/css/style1',
            'css/style'
        ));
        Assets::add_js(array(
            'plugins/cb-slideshow/js/modernizr'
        ));
        
        Template::render();
    }
}