<?php if (!defined('BASEPATH')) exit('No direct script access allowed');



class Busca_ajax extends Builder_Controller {

	function __construct()
	{
		  parent::__construct();
		  $this->load->model('comdono/busca_model');
	}
	
	public function limpaPpFavorito()
	{
	    $this->busca_model->updateCadastro($this->session->id_cadastro,['aviso_curtir' => 1]);
	}
	
	public function get_imoveis()
	{
	    $logado = $this->tank_auth->is_logged_in();
	    
	    $post = $this->input->post();
	    $where = [];
	    $like = [];
	    $or_where = [];
	    $or_like = [];
	    
	    if($post['tipo'] != '')
	        $where[] = ['tipo_imovel',$post['tipo']];
	    else {
	        $intencao = json_decode($post['intencao']);
	        if($intencao->para_morar == 1)
	            $where[] = ['tipo_imovel !=','Comercial'];
	        elseif($intencao->para_trabalhar == 1)
	            $where[] = ['tipo_imovel','Comercial'];
	    }
	    if($post['quartos'] > 0 && $post['quartos'] < 4)
	        $where[] = ['quartos',$post['quartos']];
	    if($post['quartos'] >= 4)
	        $where[] = ['quartos >=',4];
	    if($post['valor'] > 0){
	        $valIni = $post['valor'] - ($post['valor']*0.2);
	        $valFim = $post['valor'] + ($post['valor']*0.2);
	        $where[] = ['val_pretendido >=',$valIni];
	        $where[] = ['val_pretendido <=',$valFim];
	    }
	    if($post['bairro'] != '')
	        $where[] = ['bairro',$post['bairro']];
	        
	    if($post['pesquisa'] != ''){
	        $pes = trim($post['pesquisa']);
	        $or_like[] = ['id_imovel', $pes];
	        $or_like[] = ['cidade', $pes];
	        $or_like[] = ['bairro', $pes];
	        $or_like[] = ['endereco', $pes];
	        $or_like[] = ['dn_nome_nomefantasia', $pes];
	        $or_like[] = ['complemento', $pes];
	    }
	    
	    if($post['metro_quadrado']??'' != ''){
	        $valIni = $post['metro_quadrado'] - ($post['metro_quadrado']*0.3);
	        $valFim = $post['metro_quadrado'] + ($post['metro_quadrado']*0.3);
	        $where[] = ['area_privativa >=',$valIni];
	        $where[] = ['area_privativa <=',$valFim];
	    }
	    
	    if($post['id_lancamento']??'' != '')
	    {	        
	        $idImovelPost = $post['id_lancamento'];
	        $imovel = $this->busca_model->getImovel([['a.id_imovel',$idImovelPost],['lancamento', 'Sim']]);
	        
            if ($imovel->id_imovel_rel == 0) {
                $where[] = [['a.id_imovel',$idImovelPost],['id_imovel_rel',$idImovelPost]];
            }
            else{
                $where[] = [['a.id_imovel',$imovel->id_imovel_rel],['id_imovel_rel',$imovel->id_imovel_rel]];
            }
	    }
	    if($post['tipo_busca']??'' != '')
	    {
	        if($post['tipo_busca'] == 'lancamentos')
	        {
	            $where[] = ['lancamento','Sim'];
	        }
	    }
	    
	   
	    
	    
	    $favoritos = $this->busca_model->get_favoritos();
	    
	    $imoveis = $this->busca_model->getImoveis($where, $like, $or_where, $or_like);//[],[['bairro','ceilandia']]
	    $imoveisLista = [];
        $countImoveis = [];
        $countConjunto = [];
        $countBairro = [];
        $countQuadra = [];
        $arrayTipos = [];
        
        $idsImoveis = [];
        
        $dataBox['box_item_first'] = 1;
        foreach ($imoveis as $id_imovel=>$imovel)
        {
            
            $idsImoveis[] = $id_imovel;
            
            
           $keyBairro = trim($imovel->bairro);
            $contadorBairro[$keyBairro][] = $id_imovel;
            $position = (object)['lat'=> (float)$imovel->bairro_lat, 'lng'=> (float)$imovel->bairro_long];
            $countBairro[$keyBairro] = (object)['idImovel'=> $id_imovel, 'bairro' => $imovel->bairro, 'position' =>$position ,'lat'=> $imovel->bairro_lat, 'long'=> $imovel->bairro_long, 'count' => count($contadorBairro[$keyBairro])];
            
            
            $qq = explode(' ',trim($imovel->endereco));
            $q1 = $qq[0]??'';
            $q2 = $qq[1]??'';
            $quadra = $q1.' '.$q2;
            $contadorQuadra[$quadra][] = '';
            $countQuadra[$quadra] = (object)['idImovel'=> $id_imovel, 'quadra'=> $quadra, 'bairro' => $imovel->bairro, 'cep' => $imovel->cep, 'lat'=> $imovel->quadra_lat, 'long'=> $imovel->quadra_long, 'count' => count($contadorQuadra[$quadra])];
            
            $arrayConjunto = explode(' ',trim($imovel->endereco));
            unset($arrayConjunto[0]);unset($arrayConjunto[1]);
            $conjunto = (empty($arrayConjunto))? 'Rua' :implode(" ", $arrayConjunto);
            $keyConjunto = trim($imovel->endereco);
            $contadorConjunto[$keyConjunto][] = '';
            $countConjunto[$keyConjunto] = (object)['idImovel'=> $id_imovel, 'quadra'=> $quadra, 'bairro' => $imovel->bairro, 'endereco' => $imovel->endereco, 'conjunto'=> $conjunto, 'cep' => $imovel->cep, 'lat'=> $imovel->conjunto_lat, 'long'=> $imovel->conjunto_long, 'count' => count($contadorConjunto[$keyConjunto])];
            
            $divCore = '';
            if($logado)
            {
                $color = isset($favoritos[$imovel->id_imovel]) ? 'btn_descurtir color_red' : 'btn_curtir color_grey';
                $title = isset($favoritos[$imovel->id_imovel]) ? 'Remover dos favoritos' : 'Adicionar como favorito';
                $divCore = '<div class="box-favoritos actFavoritos core_'.$imovel->id_imovel.' '.$color.'" title="'.$title.'" data-id="'.$imovel->id_imovel.'" >';
                $divCore .= '<i class="fa fa-heart" aria-hidden="true"></i>';
                $divCore .= '</div>';
            }
            
            $idImovelRel = $imovel->id_imovel_rel;
            if( $idImovelRel > 0 ){
                $contadorImovel[$idImovelRel][] = '';
                //var_dump($countImoveis[$idImovelRel]->valor??false, $imovel->val_pretendido);
                if((!isset($countImoveis[$idImovelRel]->val_pretendido))  ||   $countImoveis[$idImovelRel]->val_pretendido > $imovel->val_pretendido){
                    $countImoveis[$idImovelRel] = $this->montaImovelCount($id_imovel,$imovel,$contadorImovel,$idImovelRel,$divCore,$dataBox);
                    //var_dump($countImoveis[$idImovelRel]->val_pretendido > $imovel->val_pretendido);
                }
                $countImoveis[$idImovelRel]->count = count($contadorImovel[$idImovelRel]??['']);
            }
            else{
                $contadorImovel[$id_imovel][] = '';
                //var_dump($countImoveis[$id_imovel]->valor??false, $imovel->val_pretendido);
                if((!isset($countImoveis[$id_imovel]->val_pretendido))  ||   $countImoveis[$id_imovel]->val_pretendido > $imovel->val_pretendido){
                    $countImoveis[$id_imovel] = $this->montaImovelCount($id_imovel,$imovel,$contadorImovel,$id_imovel,$divCore,$dataBox);
                }
                $countImoveis[$id_imovel]->count = count($contadorImovel[$id_imovel]??['']);
            }
                
            $imoveisLista[$id_imovel] = $this->montaImovelCount($id_imovel,$imovel,$contadorImovel,$id_imovel,$divCore,$dataBox);
            $imoveisLista[$id_imovel]->favorito = '';
            
            if($logado)
            {
                $color = isset($favoritos[$imovel->id_imovel]) ? 'btn_descurtir color_red' : 'btn_curtir color_grey';
                $title = isset($favoritos[$imovel->id_imovel]) ? 'Remover dos favoritos' : 'Adicionar como favorito';
                $divCore = "<div class='box-favoritos actFavoritos core_".$imovel->id_imovel." ".$color."' title='".$title."' data-id='".$imovel->id_imovel."' ";
                $divCore .= "<i class'fa fa-heart' aria-hidden='true'></i>";
                $divCore .= "</div>";
                
                $imoveisLista[$id_imovel]->favorito = $divCore;
            }
            $arrayTipos[$imovel->tipo_imovel] = $imovel->tipo_imovel;
            
            $dataBox['box_item_first']++;
        }
        
        $data['tiposImovel'] = HBusca::getHtmlSelectTiposImovel($arrayTipos);
        $data['imoveis'] = $imoveisLista;
        $data['countBairro'] = $countBairro;
        $data['countQuadra'] = $countQuadra;
        $data['countConjunto'] = $countConjunto;
        $data['countImoveis'] = $countImoveis;
        
         //`id_intencao`, `id_cadastro`, `cont_result`, `result`, `pesquisa`, `bairro`, `tipo`, `quartos`, `valor`, `metro_quadrado`, `id_lancamento`, `tipo_busca`, `timestemp_intencao`
        $intencao = $post;
        $intencao['result'] = json_encode($idsImoveis);
        $intencao['cont_result'] = count($imoveis);
        $intencao['id_cadastro'] = $this->session->id_cadastro??0;
        $intencao['data_hora_busca'] = date("Y-m-d H:i:s");
        
        if($intencao['id_cadastro'] == 0){
            
            $intencoes_busca = $this->session->intencoes_busca;
            $intencoes_busca[] = $intencao;
            $this->session->set_userdata(['intencoes_busca'=>$intencoes_busca]);
            $data['intencoes_busca'] = $intencoes_busca;
        }
        else{
            $data['intencoes_busca'][] = $intencao;
            $this->cad_model->setIntencaoBusca($intencao);
        }
        
        
        echo json_encode($data); 
        
	}
	
    public function get_imoveis_lancamento()
    {    
        //$data = $this->input->post();
        
        $post = $this->input->post();
	    $where = [];
	    $like = [];
	    $or_where = [];
	    $or_like = [];
	    
	    //quartos
        //valor
        //metro_quadrado
        //vaga
	    //banheiros
	    if($post['tipo_imovel'] != '')
	        $where[] = ['tipo_imovel',$post['tipo_imovel']];
	    if($post['quartos'] > 0 && $post['quartos'] < 4)
	        $where[] = ['quartos',$post['quartos']];
	    if($post['quartos'] >= 4)
	        $where[] = ['quartos >=',4];
	    
	    if($post['vaga'] > 0 && $post['vaga'] < 4)
	        $where[] = ['vaga',$post['vaga']];
	    if($post['vaga'] >= 4)
	        $where[] = ['vaga >=',4];    
	        
	     if($post['banheiros'] > 0 && $post['banheiros'] < 4)
	        $where[] = ['banheiros',$post['banheiros']];
	    if($post['banheiros'] >= 4)
	        $where[] = ['banheiros >=',4];     
	        
	    if($post['valor'] > 0){
	        $valIni = $post['valor'] - ($post['valor']*0.2);
	        $valFim = $post['valor'] + ($post['valor']*0.2);
	        $where[] = ['val_pretendido >=',$valIni];
	        $where[] = ['val_pretendido <=',$valFim];
	    }
	   
	    if($post['metro_quadrado']??'' != ''){
	        $valIni = $post['metro_quadrado'] - ($post['metro_quadrado']*0.3);
	        $valFim = $post['metro_quadrado'] + ($post['metro_quadrado']*0.3);
	        $where[] = ['area_privativa >=',$valIni];
	        $where[] = ['area_privativa <=',$valFim];
	    }
	    
	    $where[] = [ ['a.id_imovel',$post['id_imovel']],['id_imovel_rel',$post['id_imovel']] ];
	    
	    $imoveis = $this->busca_model->getImoveis($where, $like, $or_where, $or_like);
        
        $unidades = [];
        foreach ($imoveis as $unidade){
            $unidade->tr_html = $this->getTrHtmlUnidade($unidade);
            $unidades[] = $unidade;
        }
        echo json_encode($unidades); 
    }
    
    private function getTrHtmlUnidade($unidade)
    {
        $html = '<tr>'.
                    '<td><a href="'.base_url('imovel/'.$unidade->id_imovel).'" target="_blank"><img src="'.base_url("assets/img/comdono/ico/imovel/imo-quartos.png").'">'.$unidade->quartos.'</a></td>'.
                    '<td><a href="'.base_url('imovel/'.$unidade->id_imovel).'" target="_blank"><img src="'.base_url("assets/img/comdono/ico/imovel/imo-banheiros.png").'">'.$unidade->banheiros.'</a></td>'.
                    '<td><a href="'.base_url('imovel/'.$unidade->id_imovel).'" target="_blank"><img src="'.base_url("assets/img/comdono/ico/imovel/imo-vagas.png").'">'.$unidade->vaga.'</a></td>'.
                    '<td><a href="'.base_url('imovel/'.$unidade->id_imovel).'" target="_blank">'.$unidade->area_privativa.' m²</a></td>'.
                    '<td><a href="'.base_url('imovel/'.$unidade->id_imovel).'" target="_blank">'.'R$ '.number_format($unidade->val_pretendido, 2, ',', '.').'</a></td>'.
                    '<td><a href="'.base_url('imovel/'.$unidade->id_imovel).'" target="_blank">Ver unidade</a></td>'.
                '</tr>';
        return $html;
    }
    
	
	private function montaImovelCount($id_imovel,$imovel,$contadorImovel,$key,$divCore, $data = [])
    {
        $data['logado'] = $this->logado();
        $data['ppFavorito'] = $this->meuCadastro->aviso_curtir??1;
        $data['imovel'] = $imovel;
        $data['favoritos'] = $this->busca_model->get_favoritos();
        $data['linkRedict'] = $imovel->lancamento == 'Sim'?base_url('lancamento/'.$imovel->id_imovel):base_url('imovel/'.$imovel->id_imovel);
        $data['title'] = $imovel->lancamento == 'Sim'?$imovel->dn_nome_nomefantasia:$imovel->bairro;
        $data['title'] = ucwords(strtolower($data['title']));
        Template::load_view('comdono/blocos/imovel_busca_view', $data, '', '', $blocoView);
        
        if (!empty($imovel->imagens)) { 
            $baseImg = $imovel->imagens[0]->uri;
            $img     = $imovel->imagens[0]->imagem;
            //para o carousel // foreach ($imovel->imagens as $img_galeria) {HImg::alt($img_galeria); HImg::ref($img_galeria);  HImg::desc($img_galeria);}
        } else {
            $baseImg = 'themes/comdono/img/';
            $img     = 'no-image-gallery.png';
            //<img src="<?php e(base_url('themes/comdono/img/no-image-gallery.png'))
        }
        
        $val = number_format($imovel->val_pretendido, 2, ',', '.');
        $valor = substr($val, 0, -3).",00";
        
        return  (object)[
                'idImovel'  => $id_imovel,
                'idImovelRel' => $imovel->id_imovel_rel,
                'id_cadastro' => $imovel->id_cadastro,
                'dn_nome_nomefantasia' => $imovel->dn_nome_nomefantasia,
                'bairro' => $imovel->bairro,
                'endereco' => $imovel->endereco,
                'cidade' => $imovel->cidade,
                'estado' => $imovel->estado,
                'cep' => $imovel->cep,
                'baseImg' => $baseImg,
                'img' => $img,
                'valor' => $valor,
                'val_pretendido' => $imovel->val_pretendido,
                'tipo_imovel' => $imovel->tipo_imovel,
                'metros' => $imovel->area_total,
                'quartos' => $imovel->quartos,
                'area_privativa' => $imovel->area_privativa,
                'suites' => $imovel->suites,
                'banheiros' => $imovel->banheiros,
                'lat' => $imovel->latitude,
                'long' => $imovel->longitude,
                'count' => count($contadorImovel[$key]??['']),
                'lancamento' => $imovel->lancamento,
                'blocoView' => $blocoView,
                'divCore' => $divCore
                ];
    }
    
    
}