<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

// Require the Composer autoloader.
//require APPPATH . 'libraries/vendor/autoload.php';
//define('ACCESS_KEY', "AKIAXWSGWKL2LMYZ2XSV");
//define('SECRET_KEY', "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");
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
//use Aws\Credentials\Credentials;
//use Aws\S3\S3Client;
//use Aws\S3\Exception\S3Exception;

class Cad_ajax extends Builder_Controller {

	function __construct()
	{
		  parent::__construct();
		  require APPPATH . 'libraries/vendor/autoload.php';
		  $this->load->model('cad_model'); 
		  $this->load->library('newsletter/newsletter');
		  $this->load->model('administrativo/fluxo_model');
	}
	
	public function aceitarCookie()
	{
	    //$this->load->helper('cookie');
	    
        set_cookie('aceita_cookie','aceito',time() + (10 * 365 * 24 * 60 * 60));
        
        //echo json_encode(['valid'=> true]);
	}
    
    
    // P O S T ---- C A D A S T R O ---------------------------------------------------------------
    
    public function pre_cadastro()
    {   
        $this->load->library('form_validation');
        $this->form_validation->set_rules('nome', 'Nome', 'required|trim');
        $this->form_validation->set_rules('email', 'E-mail', 'required|trim|valid_email');
		$this->form_validation->set_rules('password', 'Senha', 'required|trim|min_length[8]|matches[password_conf]');
		$this->form_validation->set_rules('password_conf', 'Confirmar Senha', 'required|trim');
		
		if ($this->form_validation->run() != FALSE) 
        {
            $data = $this->input->post();
            if(Cad_model::getSysUserByEmail($data['email']) == null)
            {
                $cadastro = Cad_model::getCadastroByEmail($data['email']);
                $senha = $data['password'];
                $data['password'] = $this->password_hash($data['password']);
                $data['etapa'] = 1;
                $data['data_hora_cadastro'] = date("Y-m-d H:i:s");
                    
                if(empty($cadastro))
                {
                    $result = Cad_model::setCadUser($data);
                }
                else
                {
                    $this->cad_model->updateCadastro($cadastro->id_cadastro,$data);
                    $data['id_cadastro'] = $cadastro->id_cadastro;
                    $result['id_cadastro'] = $cadastro->id_cadastro;
                    $result['id_user']     = $this->cad_model->insertUser($data);
                }
                
                if(!empty($result)){
                    $lembrar = 0;
                    
                    if(isset($this->session->financiment_semcad)){
                        
                        $id_cadastro = $result['id_cadastro'];
                        
                        $financiamento = $this->session->financiamento;
    			        if($financiamento != null)
    			        {
                            $financiamento['id_imovel'] = '0';
                            $financiamento['id_cad_dono'] = '0';
                            $financiamento['id_cad_interessado'] = $id_cadastro;
    			            $this->set_simulacao($financiamento, $id_cadastro);
                            $this->session->set_userdata('financiamento', null);
    			        }
    			        
    			        $cad = $this->cad_model->get_cadastro([],$id_cadastro);
            
                        $insert['nome']     = $cad->nome;
                        $insert['email']    = $cad->email;
                        //$insert['telefone'] = $cad->telefone;
                        $insert['cpf']      = $cad->cpf;
                        
                        $insert['datetime_captura'] = date("Y-m-d H:i:s");
                        $insert['mensagem'] = 'solicitarproposta';
                        $insert['origem_captura'] = 'financiamento';
                        $id_captura = $this->cad_model->insertCaptura($insert);
                        
                        $origem = $this->session->origem;
                        if($origem != NULL && is_array($origem));
                        {   
                            $array = [
    	                              'click_action'    =>'Solicitar Proposta',
                	                  'id_cad'          =>$id_cadastro,
                	                  'tb_result'       =>'cad_captura',
                	                  'id_result'       =>$id_captura,
                	                  'conta_nova'      =>1,
                	                  'date_time'       => date('Y-m-d H:i:s')
        	                         ];
                            
            	            $newOrigem = array_merge((array)$origem, $array);
            	                        
                            $this->cad_model->insertCapturaOrigem($newOrigem);
                            $this->session->unset_userdata('origem');
                        }
                        
                        HEmail::alerta('Captura LP Financiamento', $insert);
                    }
                    else
                    {
                        HEmail::alerta('Novo Pre Cadastro', $data['email']);
                    }
                    
                    $result = $this->tank_auth->login($data['email'], $senha, $lembrar, false, true, false);
                    
                    $intencoes_busca = $this->session->intencoes_busca;
                    foreach (($intencoes_busca??[]) as $intencao){
                        $intencao['id_cadastro'] = $this->session->id_cadastro;
                        $this->cad_model->setIntencaoBusca($intencao);
                    }
                    $this->session->unset_userdata('intencoes_busca');
                    
                    $json = ['valid' => true,'msg' => "Sucesso!",'redirect' => base_url(), 'resultado' => $result]; 
                }
                else{
                    $json = ['valid' => false,'erro' => 3,'msg' => "Erro!"];
                }
            }else{
                $json = ['valid' => false,'erro' => 2,'msg' => "E-mail já cadastrado!"];
            }
        }else{
            $json = ['valid' => false,'erro' => 1,'msg' => validation_errors()];
        }
        echo json_encode($json);
    }
    
    public function aceitar_termo()
    {
        
        $this->load->library('form_validation');
        $this->form_validation->set_rules('chk_termo', 'Cheque termo', 'required|trim');
        
        if ($this->form_validation->run() != FALSE) 
        {
            $chk_termo = $this->input->post('chk_termo');
            
            if($chk_termo == 1){
                
                if($this->tank_auth->is_logged_in())
                {
                    $data['termo_uso'] = 1;
                    $data['etapa'] = 2;
                    
                    if($this->session->botaoCadImovel){
                        $data['vendedor'] = 1;
                        $data['etapa'] = 3;
                        $this->session->unset_userdata('botaoCadImovel');
                    }
                    
                    if(isset($this->session->financiment_semcad)){
                        $data['comprador'] = 1;
                        $data['etapa'] = 4;
                    }
                    
                    $r = $this->cad_model->updateCadastro($this->session->id_cadastro, $data);
                    
                         
                    if($r){
                        $json = ['valid' => true,'msg' => "Sucesso!"];
                    
                        $data_email = array(   
                            'nome' => $this->altera_nome($this->session->nome),
                            'email'=> $this->session->email,
                            'anexo'=> "https://s3-us-west-2.amazonaws.com/".(getenv('S3_BUCKET'))."/assets/uploads/docs/termos_de_uso_e_relacionamento.pdf",
                            'link'=> base_url(),
                            'linkcustom'=> base_url()
                        );
                    
                        $this->newsletter->enviar_email_campanha($data_email['email'], 51, $data_email);
                    }
                         
                    else{
                        $json = ['valid' => false,'erro' => 5,'msg' => "Falha de comunicação com o banco!"];
                    }
                }
                else
                {
                    $json = ['valid' => false,'erro' => 4,'msg' => "Acesso negado!"];
                }
            }else{
            $json = ['valid' => false,'erro' => 1,'msg' => "É necessário aceitar os termos de uso"];
        }
        }else{
            $json = ['valid' => false,'erro' => 1,'msg' => validation_errors()];
        }
        echo json_encode($json);
    }
    
    /*public function aceitar_termo()
    {
        if($this->tank_auth->is_logged_in())
        {
            $data['termo_uso'] = 1;
            $data['etapa'] = 2;
            
            if($this->session->botaoCadImovel){
                $data['vendedor'] = 1;
                $data['etapa'] = 3;
                $this->session->unset_userdata('botaoCadImovel');
            }
            
            $r = $this->cad_model->updateCadastro($this->session->id_cadastro, $data);
            if($r)
                 $json = ['valid' => true,'msg' => "Sucesso!"];
            else
                 $json = ['valid' => false,'erro' => 5,'msg' => "Falha de comunicação com o banco!"];
        }
        else
        {
            $json = ['valid' => false,'erro' => 4,'msg' => "Acesso negado!"];
        }
        echo json_encode($json);
    }*/
    
    public function set_etapa_anterior()
    {
        if($this->tank_auth->is_logged_in())
        {
            if($this->input->post('etapa') <= $this->meuCadastro->etapa)
            {
                $data['etapa'] = $this->input->post('etapa');
                
                if($data['etapa'] == 2)
                {
                    $data['comprador'] = 0;
                    $data['vendedor'] = 0;
                }
                
                if($data['etapa'] <= 3)
                {
                    $data['bd_comdono'] = '';
                }
                
                $r = $this->cad_model->updateCadastro($this->session->id_cadastro, $data);
                if($r)
                     $json = ['valid' => true,'msg' => "Sucesso!"];
                else
                     $json = ['valid' => false,'erro' => 5,'msg' => "Falha de comunicação com o banco!"];
            }
            else
            {
                $json = ['valid' => false,'erro' => 4,'msg' => "Ação não Permitida!"];
            }
        }
        else
        {
            $json = ['valid' => false,'erro' => 4,'msg' => "Acesso negado!"];
        }
        echo json_encode($json);
    }
    
    
    public function set_tipo_cad()
    {
        if($this->tank_auth->is_logged_in())
        {
            $data['vendedor'] = 0;
            $data['comprador'] = 0;
            $data['etapa'] = 3;
            
            if($this->input->post('tipo') == 1)
                $data['vendedor'] = 1;
            else{
                $data['comprador'] = 1;
                $data['etapa'] = 4;
            }
            
            $r = $this->cad_model->updateCadastro($this->session->id_cadastro, $data);
            if($r)
                 $json = ['valid' => true,'msg' => "Sucesso!"];
            else
                 $json = ['valid' => false,'erro' => 5,'msg' => "Falha de comunicação com o banco!"];
        }
        else
        {
            $json = ['valid' => false,'erro' => 4,'msg' => "Acesso negado!"];
        }
        echo json_encode($json);
    }
    
    public function set_braco_direito()
    {
        if($this->tank_auth->is_logged_in())
        {
            
            $this->cad_model->deleteBracoRel($this->session->id_cadastro);
            
            if($this->input->post('pular') == 'true' || $this->input->post('bd_comdono') == 'comdono')
            {
                $data['etapa'] = 4;
                $data['bd_comdono'] = $this->input->post('bd_comdono');
                
                $r = $this->cad_model->updateCadastro($this->session->id_cadastro, $data);
                
                if($r)
                     $json = ['valid' => true,'msg' => "Sucesso!"];
                else
                     $json = ['valid' => false,'erro' => 5,'msg' => "Falha de comunicação com o banco!"];
                
                if($this->input->post('bd_comdono') == 'comdono'){
                    
                    $data_email = array(   
                                'nome' => $this->altera_nome($this->session->nome),
                                'email'=> $this->session->email
                            );
                    
                    $this->newsletter->enviar_email_campanha($data_email['email'], 21, $data_email);
                }
                
            }
            else
            {
                $data = $this->input->post();
                
                $this->load->library('form_validation');
                
                $this->form_validation->set_rules('bd_comdono', 'Braço de Direito', 'required|trim');
                /*$this->form_validation->set_rules('bd_comdono', 'Tipo de Braço de Direito', 'required|trim');
                $this->form_validation->set_rules('nome', 'Nome', 'required|trim');
                $this->form_validation->set_rules('email', 'E-mail', 'required|trim|valid_email');
        		$this->form_validation->set_rules('telefone', 'Telefone', 'required|trim');*/
                
                
        		if ($this->form_validation->run() != FALSE) 
                {
                    
                    $braco = Cad_model::getCadastro(['email'=> $data['email']]);
                    
                    if(empty($braco)) 
                    {
                        $senha = $this->gerar_senha(); 
                        
                        $user_bd = array(
                            'nome' => $data['nome'],
                            'email'=> $data['email'],
                            'telefone'=> $data['telefone'],
                            'password' => $this->password_hash($senha),
                            'etapa' => 1
                        );
                        
                        
                        $ids = Cad_model::setCadUser($user_bd);
                        if(!empty($ids)){
                            
                            $data_email_bd = array(
                                        'bd_comdono' => $data['bd_comdono'],
                                        'nome' => $this->altera_nome($data['nome']),
                                        'email_bd'=> $data['email'],
                                        'senha'=> $senha,
                                        'nome_dono' => $this->altera_nome($this->session->nome),
                                        'email_dono'=> $this->session->email
                                    );
                            
                            //var_dump($data_email_bd['email'],$data_email_bd['email_dono']);die();
                            
                            $this->newsletter->enviar_email_campanha($data['email'], 15, $data_email_bd);
                            
                            $this->newsletter->enviar_email_campanha($data_email_bd['email_dono'], 22, $data_email_bd);
                            
                            $rel['id_cad_principal'] = $this->session->id_cadastro;
                            $rel['id_cad_braco'] = $ids['id_cadastro'];
                            $json = $this->finalizaCadBraco($rel,$data);
                        }
                        else{    
                            $json = ['valid' => false,'erro' => 3,'msg' => "Erro!"];
                        }
                    }else{
                        if($this->session->id_cadastro != $braco->id_cadastro){
                            
                            $rel['id_cad_principal'] = $this->session->id_cadastro;
                            $rel['id_cad_braco'] = $braco->id_cadastro;
                            $json = $this->finalizaCadBraco($rel,$data);
                            
                            $data_email_bd_cad = array(
                                        'nome' => $this->altera_nome($braco->nome),
                                        'nome_dono' => $this->altera_nome($this->session->nome),
                                        'email_dono'=> $this->session->email,
                                    );
                            
                            //var_dump($braco->email,$data_email_bd['email_dono']);die();
                            
                            $this->newsletter->enviar_email_campanha($braco->email, 20, $data_email_bd_cad);
                            
                            $this->newsletter->enviar_email_campanha($data_email_bd_cad['email_dono'], 22, $data_email_bd_cad);
                        }
                        else{
                            $json = ['valid' => false,'erro' => 3,'msg' => "O braço direito deve ser outra pessoa!"];
                        }
                    }
                }else{
                    $json = ['valid' => false,'erro' => 1,'msg' => validation_errors()];
                }
            } 
        }
        else
        {
            $json = ['valid' => false,'erro' => 4,'msg' => "Acesso negado!"];
        }
        echo json_encode($json);
    }
    
    private function altera_nome($str){
        $nome = explode(' ', $str);
        $first = array_shift($nome);
        $last = array_pop($nome);
        $nome_novo = trim($first." ".$last);
        
        return $nome_novo;
    }
    
    private function finalizaCadBraco($rel,$data)
    {
        
        $this->cad_model->insertRelBraco($rel);
                            
        $r = $this->cad_model->updateCadastro($this->session->id_cadastro, ['etapa'=> 4, 'bd_comdono'=>$data['bd_comdono']]);
        if($r)
             $json = ['valid' => true,'msg' => "Sucesso!"];
        else
             $json = ['valid' => false,'erro' => 5,'msg' => "Falha de comunicação com o banco!"];
        
        return $json;
             
    }
    
    public function enviar_codigos_de_ativacao()
    {
        if($this->tank_auth->is_logged_in())
        {
            $this->load->library('form_validation');
            
    		$this->form_validation->set_rules('telefone', 'Telefone', 'required|trim|exact_length[15]');
    		
            if ($this->form_validation->run() != FALSE) 
            {
                $codigosSms = $this->session->codigos_sms;
                $cod_email = $this->session->codigo_email;
                
                $telefone = $this->input->post('telefone');
                
                
                if($codigosSms == null || $cod_email == null)
                {
                    $codigosSms[$telefone] = $this->gerar_senha(6, false, false);
                    $cod_email = $this->gerar_senha(6, false, false);
                    while($codigosSms[$telefone] == $cod_email)
                        $cod_email = $this->gerar_senha(6, false, false);
                    
                    $this->session->set_tempdata('codigos_sms', $codigosSms, 3600);
                    $this->session->set_tempdata('codigo_email', $cod_email, 3600);
                }
                else{
                    
                    if(!isset($codigosSms[$telefone]))
                    {
                        $codigosSms[$telefone] = $this->gerar_senha(6, false, false);
                        $this->session->set_tempdata('codigos_sms', $codigosSms, 3600);
                        $this->session->set_tempdata('codigo_email', $cod_email, 3600);
                    }
                }
                
                $r = $this->envia_sms($telefone, $codigosSms[$telefone]);
                
                $nome = $this->altera_nome($this->session->nome);
                
                $this->newsletter->enviar_email_campanha($this->session->email, 17, array('nome'=>$nome,'codigo'=>$cod_email));
                
                if($r)
                     $json = ['valid' => true,'msg' => "<p>Um código foi enviado por SMS e por e-mail e ele tem validade de 1 (uma) hora. Se não tiver recebido, verifique sua caixa de spam (lixo eletrônico) ou tente novamente em <strong><span id='contador'></span> segundos.</strong></p>"];
                     
                else
                     $json = ['valid' => false,'erro' => 5,'msg' => "Falha no envio do código de ativação!"];  
                
                    
            }else{
                $json = ['valid' => false,'erro' => 1,'msg' => validation_errors()];
            }
        }
        else
        {
            $json = ['valid' => false,'erro' => 4,'msg' => "Acesso negado!"];
        }
        echo json_encode($json);
    }
    
    /*    public function enviar_codigos_de_ativacao()
    {
        if($this->tank_auth->is_logged_in())
        {
            $this->load->library('form_validation');
            
    		$this->form_validation->set_rules('telefone', 'Telefone', 'required|trim|exact_length[15]');
    		
            if ($this->form_validation->run() != FALSE) 
            {
                $cod_sms   = $this->session->codigo_sms;
                $cod_email = $this->session->codigo_email;
                $telefone = $this->input->post('telefone');
                if($cod_sms == null || $cod_email == null)
                {
                    $cod = $this->gerar_senha(6, false, false);
                    $cod_email = $this->gerar_senha(6, false, false);
                    while($cod == $cod_email)
                    {
                        $cod_email = $this->gerar_senha(6, false, false);
                    }
                    
                    $cod_sms = ['cod' => $cod, 'fone' => $telefone];
                    $this->session->set_tempdata('codigo_sms', $cod_sms, 3600);
                    $this->session->set_tempdata('codigo_email', $cod_email, 3600);
                }
                
                
                $r = $this->envia_sms($cod_sms);
                $this->newsletter->enviar_email_campanha($this->session->email, 17, array('nome'=>$this->session->nome,'codigo'=>$cod_email));
                
                if($r)
                     $json = ['valid' => true,'msg' => "<p>O código de ativação foi encaminhado por SMS e por email.  Código tem validade de até 1 hora. Utilize-o dentro desse prazo para efetivar o seu cadastro.</p><p>Não recebeu? Verifique na sua caixa de Spam (lixo eletrônico) ou tente novamente em <strong><span id='contador'></span> segundos.</strong></p>"];
                     
                else
                     $json = ['valid' => false,'erro' => 5,'msg' => "Falha no envio do código de ativação!"];  
                
                    
            }else{
                $json = ['valid' => false,'erro' => 1,'msg' => validation_errors()];
            }
        }
        else
        {
            $json = ['valid' => false,'erro' => 4,'msg' => "Acesso negado!"];
        }
        echo json_encode($json);
    }*/
    
    private function envia_sms($telefone,$codigo)
    {
        //return true;
        $telefone = preg_replace( '/[^0-9]/', '', $telefone);
        $this->load->helper('comtele_sms');
        
        $result = send_sms("Comdono","Olá! Aqui está seu código do COMDONO: ".$codigo.". Insira na plataforma e navegue normalmente.", [$telefone]);

        if(isset($result->Success) && $result->Success == true)
            return true;
        else
            return false;
    }
    
    public function ativa_conta()
    {
        if($this->tank_auth->is_logged_in())
        {
            $this->load->library('form_validation');
    		$this->form_validation->set_rules('telefone', 'Telefone', 'required|trim');
    		$this->form_validation->set_rules('codigo_ativacao', 'Código', 'required|trim');
    		
    		if ($this->form_validation->run() != FALSE) 
            {
                $codigo_ativacao = $this->input->post('codigo_ativacao'); 
                $telefone_ativacao = $this->input->post('telefone'); 
                
                $codigosSms = $this->session->codigos_sms;
                $cod_email = $this->session->codigo_email;
                
                if($codigosSms == null && $cod_email == null)
                {
                    $json = ['valid' => false,'erro' => 5,'msg' => "Codigo expirou, envie novamente!"];   
                }
                else if(!isset($codigosSms[$telefone_ativacao]))
                {
                    $json = ['valid' => false,'erro' => 5,'msg' => "Telefone inválido!"];   
                }
                else if(!($codigosSms[$telefone_ativacao] == $codigo_ativacao || $cod_email == $codigo_ativacao))//!($cod_sms == $codigo_ativacao || $cod_email == $codigo_ativacao)
                {
                    $json = ['valid' => false,'erro' => 5,'msg' => "Código inválido!"];  
                }
                else
                {
                    $data['telefone'] = $telefone_ativacao;
                    $data['tipo_contato'] = $this->input->post('tipo_contato');
                    $this->criaPastaPerfil();
                    
                    $cad = $this->cad_model->get_cadastro();
                    
                    $data_email = array(   
                            'nome' => $this->altera_nome($this->session->nome),
                            'email'=> $this->session->email
                        );
                    
                    $data['etapa'] = 7;
                    if($cad->vendedor == 1){
                        $data['etapa'] = 5;
                        $this->newsletter->enviar_email_campanha($data_email['email'], 24, $data_email);
                    }else{
                        $this->newsletter->enviar_email_campanha($data_email['email'], 23, $data_email);
                    }
                    
                    if($codigosSms[$telefone_ativacao] == $codigo_ativacao)
                        $data['sms_activated'] = 1;
                    else
                        $data['email_activated'] = 1;
                    
                    //var_dump($data);die();
                    if(isset($this->session->financiment_semcad)){
                        $data['etapa'] = 8;
                        $direct = 'financiamento/simulacao_financiamento';
                        $this->session->set_userdata('financiment_semcad', null);
                    }
                    
                    $r = $this->cad_model->updateCadastro($this->session->id_cadastro, $data);
                    if($r)
                         $json = ['valid' => true,'msg' => "Sucesso!", 'redirect' => $direct??NULL];
                    else
                         $json = ['valid' => false,'erro' => 5,'msg' => "Falha de comunicação com o banco!"];   
                }
            }
            else
            {
                $json = ['valid' => false,'erro' => 1,'msg' => validation_errors()];
            }
        }
        else
        {
            $json = ['valid' => false,'erro' => 4,'msg' => "Acesso negado!"];
        }
        
        echo json_encode($json);
    }
    
    //FAZ UM NEGOCIO DINAMIC MOÇU
    public function set_simulacao($insert, $id_cadastro)
    {
        $simulacao = $this->cad_model->getSimulacaoFinanciamento(['id_imovel'=> 0, 'id_cad_dono'=> 0, 'id_cad_interessado'=>$id_cadastro, 'step <' => 4]);
        
        if(empty($simulacao))
        { 
            $id_simulacao = $this->cad_model->insertSimulacao($insert);
            
            $bancos = $this->cad_model->getBancosFinanciamento();
            foreach($bancos as $banco)
            {
                $dataBanco = [
                    'id_banco' => $banco->id_banco,
                    'id_simulacao' => $id_simulacao,
                    'id_cadastro' => $id_cadastro
                    ];
                $this->cad_model->insertBancoRelSimulacao($dataBanco);
            }
        }
        else
        {
            return $this->cad_model->updateSimulacao($simulacao->id_simulacao,$insert);
        }
        
        
    }
    
    public function edit_celular()
    {
        if($this->tank_auth->is_logged_in())
        {
            $this->load->library('form_validation');
    		$this->form_validation->set_rules('telefone', 'Telefone', 'required|trim');
    		$this->form_validation->set_rules('codigo_ativacao', 'Código', 'required|trim');
    		
    		if ($this->form_validation->run() != FALSE) 
            {
                $codigo_ativacao = $this->input->post('codigo_ativacao'); 
                $telefone_ativacao = $this->input->post('telefone'); 
                
                $codigosSms = $this->session->codigos_sms;
                $cod_email = $this->session->codigo_email;
                
                if($codigosSms == null && $cod_email == null)
                {
                    $json = ['valid' => false,'erro' => 5,'msg' => "Codigo expirou, envie novamente!"];   
                }
                else if(!isset($codigosSms[$telefone_ativacao]))
                {
                    $json = ['valid' => false,'erro' => 5,'msg' => "Telefone inválido!"];   
                }
                else if(!($codigosSms[$telefone_ativacao] == $codigo_ativacao || $cod_email == $codigo_ativacao))//!($cod_sms == $codigo_ativacao || $cod_email == $codigo_ativacao)
                {
                    $json = ['valid' => false,'erro' => 5,'msg' => "Código inválido!"];  
                }
                else
                {
                    $data['telefone'] = $telefone_ativacao;
                    $data['tipo_contato'] = $this->input->post('tipo_contato');
                    $this->criaPastaPerfil();
                    
                    $cad = $this->cad_model->get_cadastro();
                    
                    $data_email = array(   
                            'nome' => $this->altera_nome($this->session->nome),
                            'email'=> $this->session->email
                        );
                    
                    $data['etapa'] = 7;
                    if($cad->vendedor == 1){
                        $data['etapa'] = 5;
                        $this->newsletter->enviar_email_campanha($data_email['email'], 24, $data_email);
                    }else{
                        $this->newsletter->enviar_email_campanha($data_email['email'], 23, $data_email);
                    }
                    
                    if($codigosSms[$telefone_ativacao] == $codigo_ativacao)
                        $data['sms_activated'] = 1;
                    else
                        $data['email_activated'] = 1;
                    
                    //var_dump($data);die();
                    
                    $r = $this->cad_model->updateCadastro($this->session->id_cadastro, $data);
                    if($r)
                         $json = ['valid' => true,'msg' => "Sucesso!"];
                    else
                         $json = ['valid' => false,'erro' => 5,'msg' => "Falha de comunicação com o banco!"];   
                }
            }
            else
            {
                $json = ['valid' => false,'erro' => 1,'msg' => validation_errors()];
            }
        }
        else
        {
            $json = ['valid' => false,'erro' => 4,'msg' => "Acesso negado!"];
        }
        
        echo json_encode($json);
    }
    
    /*    public function ativa_conta()
    {
        if($this->tank_auth->is_logged_in())
        {
            $this->load->library('form_validation');
    		$this->form_validation->set_rules('telefone', 'Telefone', 'required|trim');
    		$this->form_validation->set_rules('codigo_ativacao', 'Código', 'required|trim');
    		
    		if ($this->form_validation->run() != FALSE) 
            {
                $codigo_ativacao = $this->input->post('codigo_ativacao'); 
                $telefone_ativacao = $this->input->post('telefone'); 
                
                $cod_sms = $this->session->codigo_sms;
                $cod_email = $this->session->codigo_email;
                
                if($cod_sms == null && $cod_email == null)
                {
                    $json = ['valid' => false,'erro' => 5,'msg' => "Codigo expirou, envie novamente!"];   
                }else if(!($cod_sms['cod'] == $codigo_ativacao || $cod_email == $codigo_ativacao))//!($cod_sms == $codigo_ativacao || $cod_email == $codigo_ativacao)
                {
                    $json = ['valid' => false,'erro' => 5,'msg' => "Código inválido!"];  
                }
                else
                {
                    
                    if($telefone_ativacao != $cod_sms['fone'])
                    {
                        $json = ['valid' => false,'erro' => 5,'msg' => "Telefone inválido"];
                        echo json_encode($json);
                        die();
                    }
                    $data['telefone'] =$telefone_ativacao;
                    $data['tipo_contato'] = $this->input->post('tipo_contato');
                    $this ->criaPastaPerfil();
                    
                    $cad = $this->cad_model->get_cadastro();
                    
                    $data['etapa'] = 7;
                    if($cad->vendedor == 1){
                        $data['etapa'] = 5;
                    }
                    
                    
                    
                    if($cod_sms['cod'] == $codigo_ativacao)
                        $data['sms_activated'] = 1;
                    else
                        $data['email_activated'] = 1;
                    
                    $r = $this->cad_model->updateCadastro($this->session->id_cadastro, $data);
                    if($r)
                         $json = ['valid' => true,'msg' => "Sucesso!"];
                    else
                         $json = ['valid' => false,'erro' => 5,'msg' => "Falha de comunicação com o banco!"];   
                }
            }
            else
            {
                $json = ['valid' => false,'erro' => 1,'msg' => validation_errors()];
            }
        }
        else
        {
            $json = ['valid' => false,'erro' => 4,'msg' => "Acesso negado!"];
        }
        
        echo json_encode($json);
    }*/
    
    public function set_tipo_anuncio()
    {
        if($this->tank_auth->is_logged_in())
        {
            $data['etapa'] = 8;
            if($this->input->post('tipo') == 1){
                $data['etapa'] = 6;
                $data['agendamento'] = 1;
            }
            $r = $this->cad_model->updateCadastro($this->session->id_cadastro, $data);
            if($r)
                 $json = ['valid' => true, 'redirect'=>base_url('cadastro/imovel'),'msg' => "Sucesso!"];
            else
                 $json = ['valid' => false,'erro' => 5,'msg' => "Falha de comunicação com o banco!"];
        }
        else
        {
            $json = ['valid' => false,'erro' => 4,'msg' => "Acesso negado!"];
        }
        echo json_encode($json);
    }
    
    /*public function set_agendamento()
    {
        if($this->tank_auth->is_logged_in())
        {
            $data['qnt_imovel'] = 0;
            $qnt = $this->input->post('qnt_imovel');
            if($qnt > 0)
                $data['qnt_imovel'] = $qnt;
            $data['etapa'] = 7;
            //$data['melhor_dia'] = $this->input->post('melhor_dia');
            $data['melhor_hora'] = $this->input->post('melhor_hora');
            
            $r = $this->cad_model->updateCadastro($this->session->id_cadastro, $data);
            if($r)
                 $json = ['valid' => true, 'redirect'=>base_url(),'msg' => "Sucesso!"];
            else
                 $json = ['valid' => false,'erro' => 5,'msg' => "Falha de comunicação com o banco!"];
        }
        else
        {
            $json = ['valid' => false,'erro' => 4,'msg' => "Acesso negado!"];
        }
        echo json_encode($json);
    }*/
    
    public function set_agendamento()
    {
        if($this->tank_auth->is_logged_in())
        {
            $this->load->library('form_validation');
            $this->form_validation->set_rules('qnt_imovel', 'Quantidade de imóveis', 'required|trim');
            $this->form_validation->set_rules('melhor_hora', 'Melhor horário', 'required|trim');
            
            if ($this->form_validation->run() != FALSE) 
            {
                $data['qnt_imovel'] = 0;
                $qnt = $this->input->post('qnt_imovel');
                if($qnt > 0)
                    $data['qnt_imovel'] = $qnt;
                $data['etapa'] = 8;
                //$data['melhor_dia'] = $this->input->post('melhor_dia');
                $data['melhor_hora'] = $this->input->post('melhor_hora');
                
                
                
                $r = $this->cad_model->updateCadastro($this->session->id_cadastro, $data);
                if($r)
                     $json = ['valid' => true, 'redirect'=>base_url(),'msg' => "Sucesso!"];
                else
                     $json = ['valid' => false,'erro' => 5,'msg' => "Falha de comunicação com o banco!"];
            }
            else
            {
                $json = ['valid' => false,'erro' => 1,'msg' => validation_errors()];
            }
        }
        else
        {
            $json = ['valid' => false,'erro' => 4,'msg' => "Acesso negado!"];
        }
        echo json_encode($json);
    }
    
    public function finaliza_cadastro()
    {
        if($this->tank_auth->is_logged_in())
        {
            /*if($this->input->post('tipo') == 1)
                $redirect = $this->refRedirect();
            else{
                $redirect = base_url('busca');
            }*/
            
            //var_dump($this->input->post('tipo'));
            
            if($this->input->post('tipo') == 0)
                $redirect = base_url('busca');
            else if($this->input->post('tipo') == 1)
                $redirect = $this->refRedirect();
            else
                $redirect = base_url('minha-conta');
                
                
            
            //$redirect = $this->refRedirect();
            
            $data['etapa'] = 8;
            
            $r = $this->cad_model->updateCadastro($this->session->id_cadastro, $data);
            if($r)
                 $json = ['valid' => true, 'redirect' => $redirect, 'msg' => "Sucesso!"];
            else
                 $json = ['valid' => false,'erro' => 5,'msg' => "Falha de comunicação com o banco!"];
        }
        else
        {
            $json = ['valid' => false,'erro' => 4,'msg' => "Acesso negado!"];
        }
        echo json_encode($json);
    }
    
    // P O S T ---- I M O V E L ---------------------------------------------------------------
    
    public function upload_img_perfil()
    {
        $dados_perfil = $this->input->post('dados_perfil');
        $id_cadastro = $this->session->id_cadastro;
        $id_imovel = $this->input->post('id_imovel');
        
        try {
            if (!isset($_FILES['dn_img']))
                throw new Exception("File not uploaded", 1);
            $allowed_types = array( 
                'gif',     'GIF',
                'jpg',     'JPG',
                'jpeg',    'JPEG',
                'png',     'PNG',
               );
               
            if ((!isset($_FILES["dn_img"]["name"])) || empty($_FILES["dn_img"]["name"]) || $_FILES["dn_img"]["name"] == '')
                 die(json_encode(['valid' => false,'erro' => 5,'msg' => 'Erro no  arquivo!']));
            
            
            
            $path_parts = pathinfo($_FILES["dn_img"]["name"]);
            $extension = $path_parts['extension'];
            if (!in_array($extension, $allowed_types))
                die(json_encode(['valid' => false,'erro' => 5,'msg' => 'Tipo de arquivo não permitido!']));
            
            
            $angle = $this->get_angle_rotate($_FILES['dn_img']['tmp_name']);
            $this->rotate_image($_FILES['dn_img']['tmp_name'],$angle);
            
            
            //$credentials = new Credentials(ACCESS_KEY, SECRET_KEY);
            //$s3 = new S3Client(['version' => 'latest','region' => 'us-west-2','credentials' => $credentials]);
            //$this->load->library('easyphpthumbnail');
            //$tmp_name = $_FILES['dn_img']['tmp_name'];
            //$name = str_replace($extension, "", convertAccentsAndSpecialToNormal($_FILES['dn_img']['name'])).'.'.$extension;
            //$putImg = $this->getPutResize($tmp_name, $name, 300, $id_cadastro);
            //$resImg = $s3->putObject($putImg);
            //$imgUrl = $resImg['ObjectURL'];
            
            $tmp_name = $_FILES['dn_img']['tmp_name'];
            $name = str_replace($extension, "", convertAccentsAndSpecialToNormal($_FILES['dn_img']['name'])).'.'.$extension;
            $upload_path = 'anunciante/' . $id_cadastro .'/perfil';
            $imgUrl = Upload::putObjectResize($tmp_name, $name, 300, $upload_path);
            
            
            $uri = str_replace($name, "", $imgUrl);
            
            $data['dn_img'] = $name;    
            $data['dn_img_uri'] = $uri;    
            
            $upPerfil['img_perfil'] = $name;
            $upPerfil['img_perfil_uri'] = $uri;  
            
            $cad = $this->cad_model->get_cadastro();
            
            // SE VIR MARCADO Trazer dados do perfil cadastrado, Sobe a imagem do perfil pro CADASTRO
            /*
                if($dados_perfil == 'cpf')
                    $this->cad_model->updateCadastro($cad->id_cadastro, $upPerfil);
            */
            
            if($dados_perfil == 'cpf'){
                
                $wup[] = ['id_cadastro', $id_cadastro];
                $wup[] = ['doc_perfil', 'cpf'];
                
                $this->cad_model->updateImoveis($wup,$data);
                
                if($this->cad_model->updateCadastro($cad->id_cadastro, $upPerfil)){
                    $json = ['valid' => true, 'imagem_path' => $imgUrl, 'data'=> $data,'msg' => 'Sucesso!'];
                }
                else{
                    $json = ['valid' => false,'erro' => 5,'msg' => 'Falha de comunicação com o banco!'];
                }
            }
            else{
                if($this->cad_model->updateImovel($id_imovel,$data)){
                    $this->cad_model->updateImovelRel($id_imovel,$data);
                    $json = ['valid' => true, 'imagem_path' => $imgUrl, 'data'=> $data,'msg' => 'Sucesso!'];
                }
                else{
                    $json = ['valid' => false,'erro' => 5,'msg' => 'Falha de comunicação com o banco!'];
                }
            }
            echo json_encode($json);  
            
        } catch(Exception $e) {
            echo json_encode(['valid' => false,'erro' => 5,'msg' => $e->getMessage()]);
        }
    }
    
    public function upload_img_pj()
    {
        $id_cadastro = $this->session->id_cadastro;
        
        try {
            
            if (!isset($_FILES['img_pj']))
                throw new Exception("File not uploaded", 1);
            $allowed_types = array( 
                'gif',     'GIF',
                'jpg',     'JPG',
                'jpeg',    'JPEG',
                'png',     'PNG',
               );
               
            $path_parts = pathinfo($_FILES["img_pj"]["name"]);
            $extension = $path_parts['extension'];
            if (!in_array($extension, $allowed_types))
                die(json_encode(['valid' => false,'erro' => 5,'msg' => 'Tipo de arquivo não permitido!']));
            
            //$credentials = new Credentials(ACCESS_KEY, SECRET_KEY);
            //$s3 = new S3Client(['version' => 'latest','region' => 'us-west-2','credentials' => $credentials]);
            //$this->load->library('easyphpthumbnail');
            //$tmp_name = $_FILES['img_pj']['tmp_name'];
            //$name = str_replace($extension, "", convertAccentsAndSpecialToNormal($_FILES['img_pj']['name'])).'.'.$extension;
            //$putImg = $this->getPutResize($tmp_name, $name, 300, $id_cadastro, true);
            //$resImg = $s3->putObject($putImg);
            //$imgUrl = $resImg['ObjectURL'];
            
            
            $tmp_name = $_FILES['img_pj']['tmp_name'];
            $name = str_replace($extension, "", convertAccentsAndSpecialToNormal($_FILES['img_pj']['name'])).'.'.$extension;
            $upload_path = 'anunciante/' . $id_cadastro .'/perfil/pj';
            $imgUrl = Upload::putObjectResize($tmp_name, $name, 300, $upload_path);
            
            $uri = str_replace($name, "", $imgUrl);
            
            $upPerfil['img_pj'] = $name;
            $upPerfil['img_pj_uri'] = $uri;  
            
            if($this->cad_model->updateCadastro($id_cadastro, $upPerfil)){
                $json = ['valid' => true, 'imagem_path' => $imgUrl, 'data'=> $upPerfil,'msg' => 'Sucesso!'];
            }
            else{
                $json = ['valid' => false,'erro' => 5,'msg' => 'Falha de comunicação com o banco!'];
            }
            
            echo json_encode($json);  
            
        } catch(Exception $e) {
            echo json_encode(['valid' => false,'erro' => 5,'msg' => $e->getMessage()]);
        }
    }
    
    /*private function getPutResize($tmp_name, $name, $width, $id_cadastro, $pj = false)
    {
        $resize = new easyphpthumbnail;
        		$resize->Thumblocation = $tmp_name;
        		$resize->Thumbfilename = $name;
        		$resize->Thumbwidth = $width;
        		$resize->Quality = 60;
        		$resize->Createthumb($tmp_name, 'file');
        
        $key = 'anunciante/' . $id_cadastro .'/perfil/'.$name;
        if($pj)
            $key = 'anunciante/' . $id_cadastro .'/perfil/pj/'.$name;
        
        return [
            'ACL' => 'public-read',
            'Bucket' => getenv('S3_BUCKET'),
            'Key'    => $key,
            'SourceFile' => $resize->Thumblocation.$resize->Thumbfilename,
            'ContentDisposition' => 'inline; filename='.$tmp_name,
            ];
    }*/
    
    private function lixo()
    {
        if(isset($_FILES['dn_img']) && $_FILES['dn_img'])
            {
                $this->criaPastaPerfil();
                $config['upload_path']          = './modules/anunciante/' . $id_cadastro .'/perfil/';
                $config['allowed_types']        = 'gif|jpg|jpeg|png';
                
                $this->load->library('upload', $config);

                if ( ! $this->upload->do_upload('dn_img'))
                {
                        $upDoc = $this->upload->display_errors();
                        $json = ['valid' => false,'erro' => 5, 'uploadDoc' => $upDoc, 'msg' => 'Falha de comunicação com o banco!'];
                }
                else
                {
                        $upDoc = $this->upload->data();
                        
                        $this->load->library('image_lib', $config);
                        $this->image_lib->resize();
                        
                        //Clear image library settings so we can do some more image
                        //manipulations if we have to
                        $this->image_lib->clear();
                        $angle = $this->get_angle_rotate($_FILES['dn_img']['tmp_name']);
                        $this->rotate_image($upDoc['full_path'],$angle);
                        
                        $imagem_path = base_url() . 'modules/anunciante/' . $id_cadastro .'/perfil/'.$upDoc['file_name'];
                        $data['dn_img'] = $upDoc['file_name'];
                        
                        $cad = $this->cad_model->get_cadastro();
                        // SE VIR MARCADO Trazer dados do perfil cadastrado, Sobe a imagem do perfil pro CADASTRO
                        if($dados_perfil == 'on')
                            $this->cad_model->updateCadastro($cad->id_cadastro,['img_perfil'=> $upDoc['file_name']]);
                        
                        if($this->cad_model->updateImovel($id_imovel,$data)){
                            $json = ['valid' => true, 'imagem_path' => $imagem_path, 'uploadDoc' => $upDoc, 'data'=> $data,'msg' => 'Sucesso!'];
                        }
                        else{
                            $json = ['valid' => false,'erro' => 5,'msg' => 'Falha de comunicação com o banco!'];
                        }
                }
                echo json_encode($json);
            }
    }
    
    public function do_upload_doc()
    {
        
        $id_cadastro = $this->session->id_cadastro;
        $id_imovel = $this->input->post('id_imovel');
        try {
            if (!isset($_FILES['doc_propriedade']))
                throw new Exception("File not uploaded", 1);
                $allowed_types = array( 
                    'gif',     'GIF',
                    'jpg',     'JPG',
                    'jpeg',    'JPEG',
                    'png',     'PNG',
                    'pdf',     'PDF',
                  );
                  
                if ((!isset($_FILES["doc_propriedade"]["name"])) || empty($_FILES["doc_propriedade"]["name"]) || $_FILES["doc_propriedade"]["name"] == '')
                    die(json_encode(['valid' => false,'erro' => 5,'msg' => 'Erro no arquivo!']));  
                  
                $path_parts = pathinfo($_FILES["doc_propriedade"]["name"]);
                $extension = $path_parts['extension'];
                if (!in_array($extension, $allowed_types))
                    die(json_encode(['valid' => false,'erro' => 5,'msg' => 'Tipo de arquivo não permitido!']));
                
                $angle = $this->get_angle_rotate($_FILES['doc_propriedade']['tmp_name']);
                $this->rotate_image($_FILES['doc_propriedade']['tmp_name'],$angle);
                
                
                //$credentials = new Credentials(ACCESS_KEY, SECRET_KEY);
                //$s3 = new S3Client(['version' => 'latest','region' => 'us-west-2','credentials' => $credentials]);
                //$this->load->library('easyphpthumbnail');
                //$tmp_name = $_FILES['doc_propriedade']['tmp_name'];
                //$name = str_replace($extension, "", convertAccentsAndSpecialToNormal($_FILES['doc_propriedade']['name'])).'.'.$extension;
                //$putImg = $this->getPutDoc($tmp_name, $name, $id_cadastro, $id_imovel);
                //$resImg = $s3->putObject($putImg);
                //$imgUrl = $resImg['ObjectURL'];
                
                
                $tmp_name = $_FILES['doc_propriedade']['tmp_name'];
                $name = str_replace($extension, "", convertAccentsAndSpecialToNormal($_FILES['doc_propriedade']['name'])).'.'.$extension;
                $upload_path = 'anunciante/' . $id_cadastro .'/'.$id_imovel.'/doc';
                $imgUrl = Upload::putObjectResize($tmp_name, $name, null, $upload_path);
                
                
                $uri = str_replace($name, "", $imgUrl);
                
                $data['doc_propriedade'] = $imgUrl;
                
                if($this->cad_model->updateImovel($id_imovel,$data)){
                    $json = ['valid' => true, 'imagem_path' => $imgUrl, 'uploadDoc' => $imgUrl, 'data'=> $data,'msg' => 'Sucesso!'];
                }
                else{
                    $json = ['valid' => false,'erro' => 5,'msg' => 'Falha de comunicação com o banco!'];
                }
                
                echo json_encode($json);
                
        } catch(Exception $e) {
            
            echo json_encode(['valid' => false,'erro' => $e, 'uploadDoc' => '$upDoc', 'msg' => 'Falha de comunicação com S3']);
        }
    }
    
    /*private function getPutDoc($tmp_name, $name, $id_cadastro, $id_imovel)
    {
        $key = 'anunciante/' . $id_cadastro .'/'.$id_imovel.'/doc/'.$name;
        
        $tmp_path_local = './modules/anunciante/' . $id_cadastro .'/'.$id_imovel.'/';
        
        
        if(!is_dir($tmp_path_local))
                mkdir($tmp_path_local, 0774, true);
        
        move_uploaded_file( $tmp_name, $tmp_path_local . $name);
        
        return [
            'ACL' => 'public-read',
            'Bucket' => getenv('S3_BUCKET'),
            'Key'    => $key,
            'SourceFile' => $tmp_path_local.$name,
            'ContentDisposition' => 'inline; filename='.$name,
            ];
    }*/
    
    /*public function do_upload_doc_bk()
    {
        $id_cadastro = $this->session->id_cadastro;
        $id_imovel = $this->input->post('id_imovel');
        
        if(isset($_FILES['doc_propriedade']) && $_FILES['doc_propriedade'])
        {
            $config['upload_path']          = './modules/anunciante/' . $id_cadastro .'/'.$id_imovel.'/';
            $config['allowed_types']        = 'gif|jpg|jpeg|png|pdf';

            $this->load->library('upload', $config);

            if ( ! $this->upload->do_upload('doc_propriedade'))
            {
                $upDoc = $this->upload->display_errors();
                $json = ['valid' => false,'erro' => 5, 'uploadDoc' => $upDoc, 'msg' => 'Falha de comunicação com o banco!'];
            }
            else
            {
                $upDoc = $this->upload->data();
                $imagem_path = base_url() . 'modules/anunciante/' . $id_cadastro .'/'.$id_imovel.'/'.$upDoc['file_name'];
                $data['doc_propriedade'] = $upDoc['file_name'];
                if($this->cad_model->updateImovel($id_imovel,$data)){
                    $json = ['valid' => true, 'imagem_path' => $imagem_path, 'uploadDoc' => $upDoc, 'data'=> $data,'msg' => 'Sucesso!'];
                }
                else{
                    $json = ['valid' => false,'erro' => 5,'msg' => 'Falha de comunicação com o banco!'];
                }
            }
            echo json_encode($json);
        }
    }
    
    public function upload_img_perfil_bk()
    {
            $dados_perfil = $this->input->post('dados_perfil');
            $id_cadastro = $this->session->id_cadastro;
            $id_imovel = $this->input->post('id_imovel');
            
            
            if(isset($_FILES['dn_img']) && $_FILES['dn_img'])
            {
                $this->criaPastaPerfil();
                
                $config['upload_path']          = './modules/anunciante/' . $id_cadastro .'/perfil/';
                $config['allowed_types']        = 'gif|jpg|jpeg|png';

                
                $this->load->library('upload', $config);

                if ( ! $this->upload->do_upload('dn_img'))
                {
                        $upDoc = $this->upload->display_errors();
                        $json = ['valid' => false,'erro' => 5, 'uploadDoc' => $upDoc, 'msg' => 'Falha de comunicação com o banco!'];
                }
                else
                {
                        $upDoc = $this->upload->data();
                        
                        $this->load->library('image_lib', $config);
                        $this->image_lib->resize();
                        
                        //Clear image library settings so we can do some more image
                        //manipulations if we have to
                        $this->image_lib->clear();
                        
                        $angle = $this->get_angle_rotate($_FILES['dn_img']['tmp_name']);
            
                        $this->rotate_image($upDoc['full_path'],$angle);
                        
                        
                        $imagem_path = base_url() . 'modules/anunciante/' . $id_cadastro .'/perfil/'.$upDoc['file_name'];
                        $data['dn_img'] = $upDoc['file_name'];
                        
                        
                        $cad = $this->cad_model->get_cadastro();
                        // SE VIR MARCADO Trazer dados do perfil cadastrado, Sobe a imagem do perfil pro CADASTRO
                        if($dados_perfil == 'on')
                            $this->cad_model->updateCadastro($cad->id_cadastro,['img_perfil'=> $upDoc['file_name']]);
                        
                        
                        if($this->cad_model->updateImovel($id_imovel,$data)){
                            $json = ['valid' => true, 'imagem_path' => $imagem_path, 'uploadDoc' => $upDoc, 'data'=> $data,'msg' => 'Sucesso!'];
                        }
                        else{
                            $json = ['valid' => false,'erro' => 5,'msg' => 'Falha de comunicação com o banco!'];
                        }
                }
                echo json_encode($json);
            }
            
    }*/
    
    public function remove_imagem_perfil()
    {
        $id_imovel = $this->input->post('id_imovel');
        
        $imovel = $this->cad_model->getImovelCad(['id_imovel'=> $id_imovel]);
         
        if(!is_null($imovel))
        {
            $data['dn_img'] = '';
            $data['dn_img_uri'] = '';
            $result = $this->cad_model->updateImovel($id_imovel,$data);
            
            echo json_encode(['valid' => true,'msg' => 'Deu Bom']);
        }
        else
        {
            echo json_encode(['valid' => false, 'msg' => 'Faiô']);
        }
        
    } 
    
    public function upload_planilha()
    {
        $id_cadastro = $this->session->id_cadastro;
        $id_imovel = $this->input->post('id_imovel');
        
        if(isset($_FILES['doc_planilha']) && $_FILES['doc_planilha'])
        {
            
            if(!is_dir('./modules/anunciante/' . $id_cadastro .'/planilhas/'))
                mkdir('./modules/anunciante/' . $id_cadastro .'/planilhas/', 0774, true);
            
            $config['upload_path']          = './modules/anunciante/' . $id_cadastro .'/planilhas/';
            $config['allowed_types']        = 'xlsx';
            
            
            $this->load->library('upload', $config);

            if (!$this->upload->do_upload('doc_planilha'))
            {
                $upDoc = $this->upload->display_errors();
                $json = ['valid' => false,'erro' => 5, 'uploadDoc' => $upDoc, 'msg' => 'Erro ao importar arquivo'];
            }
            else
            {
                $upDoc = $this->upload->data();
                $doc_path = '../html/modules/anunciante/' . $id_cadastro .'/planilhas/'.$upDoc['file_name'];
                $data['doc_planilha'] = $upDoc['file_name'];
                $data['importar_planilha'] = 'on';
                if($this->cad_model->updateImovel($id_imovel,$data)){
                    $json = ['valid' => true, 'doc_path' => $doc_path, 'uploadDoc' => $upDoc, 'data'=> $data,'msg' => 'Sucesso!'];
                }
                else{
                    $json = ['valid' => false,'erro' => 5,'msg' => 'Falha de comunicação com o banco!'];
                }
            }
            echo json_encode($json);
        }
    }
    
    public function insert_unidades()
    {
        $post = $this->input->post();
        
        // Verifica se o imovel pertence ao cadastro;
        $imovel = $this->cad_model->getImovelCad(['id_imovel'=>$post['id_imovel']]);
        if(!empty($imovel))
        {
            $inputFileName = $post['doc_path'];
    	    
    	    $spreadsheet = \PhpOffice\PhpSpreadsheet\IOFactory::load($inputFileName);
    	    
    	    //var_dump($spreadsheet);die();
    	    
    	    
    	    /*sleep(3);
    	    $json = ['valid' => true,'imoveis_rel' => 'asd', 'imovel' => 'asda', 'msg' => 'sucesso!'];
            echo json_encode($json);
    	    die();*/
    	    
    	    if(strcasecmp(trim($this->get_cell_value($spreadsheet,1,2)),'Empreendimento') == 0)
    	    {
    	        $worksheet = $spreadsheet->getActiveSheet(); 
                $highestRow = $worksheet->getHighestRow(); // e.g. 10 
                
                $imoveis_rel = [];
                $count = 1; 
                $tipoPlanilha2 = (strcasecmp(trim($this->get_cell_value($spreadsheet,71,2)),'Descrição') == 0)?true:false;
                if($tipoPlanilha2)
                    $arrayEndereco = $this->buscar_cep($this->get_cell_value($spreadsheet,29,3));
                
                
                for($row = 3; $row < $highestRow; $row ++)
                {
                    $val_pretendido = $this->get_cell_value($spreadsheet,15,$row);
                    $area_total = $this->get_cell_value($spreadsheet,10,$row);
                    if($val_pretendido > 0 && $area_total > 0)
                    {
                        //$val_public_total = (1.5*$val_pretendido)/100;
                        $val_public_total = (5*$val_pretendido)/100;
                        $val_public_total_metro = $val_public_total/$area_total;
                        
                        $insert = [
                                'id_imovel_rel' => $post['id_imovel'],
                                'id_cadastro' => $this->session->id_cadastro,
                                'complemento' => $this->get_cell_value($spreadsheet,2,$row),
                                'unidade' => $this->get_cell_value($spreadsheet,2,$row),
                                'area_total' => $area_total,
                                'area_privativa' => $this->get_cell_value($spreadsheet,11,$row),
                                'quartos' => $this->get_cell_value($spreadsheet,13,$row),
                                'vaga' => $this->get_vagas($this->get_cell_value($spreadsheet,14,$row)),
                                'val_pretendido' => $val_pretendido,
                                'val_public_total' => $val_public_total,
                                'val_public_total_metro' => $val_public_total_metro
                            ];
                        
                        if($tipoPlanilha2)
                        {   //for($asd = 1; $asd < 72; $asd ++) echo $asd.' => ["nameDB" => "","name" => "'.$this->get_cell_value($spreadsheet,$asd,2).'" ],<br>';
                            foreach (HImovel::getTbPlanilha() as $col=>$db){
                                $val = $this->get_cell_value($spreadsheet,$col,$row);
                                $insert[$db['nameDB']] = $col>=47&&$col<71?     $val==NULL?'':'on'  :$val;
                            }
                            $insert = array_merge($insert, $arrayEndereco);
                        }
                        if($count > 1)
                        {
                            $insert['dn_img'] = $imovel->dn_img;
                            $insert['dn_img_uri'] = $imovel->dn_img_uri;
                            $insert['id_imovel_rel'] = $this->cad_model->insertImovel($insert);
                            $imoveis_rel[] = $insert;
                        }
                        else
                        {
                            $update = $insert;
                            unset($update['id_imovel_rel']);
                            $this->cad_model->updateImovel($post['id_imovel'],$update);
                        }
                    }
                    $count++;
                } 
                
                //var_dump((object)$update);die();
                
                $json = ['valid' => true,'imoveis_rel' => (object)$imoveis_rel, 'imovel' => (object)$update, 'msg' => 'sucesso!'];
    	    }
    	    else{
    	        
        	    $file_name = $imovel->doc_planilha;
                $data['doc_planilha'] = '';   
                $result = $this->cad_model->updateImovel($imovel->id_imovel,$data);
                $file_path = './modules/anunciante/' . $this->session->id_cadastro .'/planilhas/';
                $file = $file_path.$file_name;
                if(file_exists($file))
                {
                    unlink($file);  
                }
    	        $json = ['valid' => false,'erro' => 1,'msg' => 'Erro. Modelo incorreto!'];
    	    }
        }
        else
        {
            $json = ['valid' => false,'erro' => 4,'msg' => 'Acesso negado!'];
        }
        echo json_encode($json);
    }
    
    public function remove_planilha()
    {
        $id_cadastro = $this->session->id_cadastro;
        $id_imovel = $this->session->id_imovel;
        
        $imovel = $this->cad_model->getImovelCad(['id_imovel'=> $id_imovel]);
        
        if(!is_null($imovel))
        {
         
            $file_name = $imovel->doc_planilha;
            $data['doc_planilha'] = '';   
            $result = $this->cad_model->updateImovel($id_imovel,$data);
            
            $this->cad_model->deleteImovelRel($id_imovel);
            
            $file_path = './modules/anunciante/' . $id_cadastro .'/planilhas/';
            $file = $file_path.$file_name;
            if(file_exists($file))
            {
                unlink($file);  
            }
        }
        
        echo json_encode(['valid' => true]);
        
    }
    
    
    
    public function remove_doc()
    {
        $id_cadastro = $this->session->id_cadastro;
        $id_imovel = $this->session->id_imovel;
        
        $imovel = $this->cad_model->getImovelCad(['id_imovel'=> $id_imovel]);
        
        if(!is_null($imovel))
        {
         
            $file_name = $imovel->doc_propriedade;
            $data['doc_propriedade'] = '';   
            $result = $this->cad_model->updateImovel($id_imovel,$data);
            
            echo json_encode(['valid' => true,'msg' => 'Deu Bom']);
        }
        else
        {
            echo json_encode(['valid' => false, 'msg' => 'Faiô']);
        }
        
    }
    
    public function remove_unidade()
    {
        $id_imovel = $this->input->post('id_imovel');
        $imovel = $this->cad_model->getImovelCad( ['id_imovel'=> $id_imovel] );
        
        if(!is_null($imovel))
        {
            $this->cad_model->deleteImovel($id_imovel);
            echo json_encode(['valid' => true]);
        }
        else
        {
            echo json_encode(['valid' => false, 'msg' => 'Acesso Negado!']);
        }
        
    }
    
    public function atualiza_imovel()
    {
        $data = $this->input->post();
        $data['edit']??$data['edit']='false';
        // Verifica se o imovel pertence ao cadastro;
        $imovel = $this->cad_model->getImovelCad(['id_imovel'=>$data['id_imovel']]);
        
        if(!empty($imovel))
        {
            
            $data['step'] = (int)$data['step'];
            //var_dump($data['chk_termo'],$data['step']);die();
            
            unset($data['doc_propriedade']);
            unset($data['doc_planilha']); 
            unset($data['dn_img']);
            
            if($data['edit'] == 'true')
            {
                unset($data['step']);
                $data['status'] = 2;
                $dataNew = array_merge((array)$imovel, $data); 
                $data['key_anuncio'] = HImovel::montaKeyAnuncio($dataNew);
                
            }
            else
            {
                $data['status'] = 1;
            }
            
            if($this->cad_model->updateImovel($data['id_imovel'],$data))
            {
                    
                if($data['edit'] == 'true' && $imovel->status == 3)//se publicado
                {
                    $msg['ID'] = $imovel->id_imovel;
                    $msg['Link Painel'] = base_url('administrativo/dashboard/imovel/').$imovel->id_imovel;
                    HEmail::alerta('Imovel Editado - moderação', $msg);
                    MFluxo::editImovel($data['id_imovel'], $data, 0);
                }
                    
                
                $arrayNew = $this->filtraCamposNovaUnidade($data);
                $editUnidade = [];
                
                if(!empty($arrayNew) && $imovel->id_imovel_rel == 0)
                {
                    if($data['edit'] == 'true')
                    {
                        $unidades = $this->cad_model->getImoveis(['id_imovel_rel'=>$data['id_imovel']]);
                        foreach($unidades as $unidade){
                            $upUnidade = $data;
                            $dataNew = array_merge((array)$unidade, $data);
                            $upUnidade['key_anuncio'] = HImovel::montaKeyAnuncio($dataNew);
                            $this->cad_model->updateImovel($data['id_imovel'],$upUnidade);
                            $editUnidade[] = $upUnidade['key_anuncio'];
                        }
                    }
                    else
                    {
                        $this->cad_model->updateImovelRel($data['id_imovel'],$this->filtraCamposNovaUnidade($data));
                    }
                }
                $json = ['valid' => true, 'data'=> $data, 'editUnidade' => $editUnidade, 'msg' => 'Sucesso!'];
            }
            else{
                $json = ['valid' => false,'erro' => 5,'msg' => 'Falha de comunicação com o banco!'];
            }
            //updadte cadastro
            
            if($this->cad_model->updateCadastro($imovel->id_cadastro,$data))
            {
                $json = ['valid' => true, 'data'=> $data, 'msg' => 'Sucesso!'];
            }
            else{
                $json = ['valid' => false,'erro' => 5,'msg' => 'Falha de comunicação com o banco!'];
            }
        }
        else
        {
            $json = ['valid' => false,'erro' => 4,'msg' => 'Acesso negado!'];
        }
        echo json_encode($json);
    }
    
    public function atualiza_lancamento()
    {
        $data = $this->input->post();
        
        // Verifica se o imovel pertence ao cadastro;
        $imovel = $this->cad_model->getImovelCad(['id_imovel'=>$data['id_imovel']]);
        
        if(!empty($imovel))
        {
            //$data['step'] = (int)$data['step'];
            unset($data['doc_propriedade']);
            unset($data['doc_planilha']); 
            unset($data['dn_img']);
            //$data['key_anuncio'] = HImovel::montaKeyAnuncio($data);
            
            $data['status'] = 2;
            $dtLancamento = $data;
            $dtLancamento['status_lancamento'] = 2;
            if($this->cad_model->updateImovel($data['id_imovel'],$dtLancamento)){
                
                $this->cad_model->updateImovelRel($data['id_imovel'],$data);
                /*$arrayNew = $this->filtraCamposNovaUnidade($data);
                if(!empty($arrayNew))
                    $this->cad_model->updateImovelRel($data['id_imovel'],$arrayNew);*/
                    
                $json = ['valid' => true, 'data'=> $data,'msg' => 'Sucesso!'];
            }
            else{
                $json = ['valid' => false,'erro' => 5,'msg' => 'Falha de comunicação com o banco!'];
            }
        }
        else
        {
            $json = ['valid' => false,'erro' => 4,'msg' => 'Acesso negado!'];
        }
        echo json_encode($json);
    }
    
    public function check_cpf(){
        
        $this->load->library('form_validation');
        $this->form_validation->set_rules('cpf', 'CPF', 'required|is_unique[cad_cadastro.cpf]');
        
        if ($this->form_validation->run() == FALSE)
        {
            echo json_encode(['valid' => false]);
        }else{
            echo json_encode(['valid' => true]);
        }
    }
    
    public function finaliza_cad_imovel()
    {
        $id_cadastro = $this->session->id_cadastro;
        $data = $this->input->post();
        
        // Verifica se o imovel pertence ao cadastro;
        $imovel = $this->cad_model->getImovelCad(['id_imovel'=>$data['id_imovel']]);
        
        if(!empty($imovel))
        {
            // se nao tiver cpf no cadastro e tiver marcado Trazer dados do perfil cadastrado, Sobe o cpf pro CADASTRO
            $cad = $this->cad_model->get_cadastro();
            if(strlen($imovel->dn_cpf_cnpj) == 14){
                if($cad->cpf == ''){
                    $this->cad_model->updateCadastro($cad->id_cadastro,['cpf'=> $imovel->dn_cpf_cnpj]);
                    $cad->cpf = $imovel->dn_cpf_cnpj;
                }
                
                $updateImovel["dn_nome_nomefantasia"] = $cad->nome;
                $updateImovel["dn_email"] = $cad->email;
                $updateImovel["dn_telefone"] = $cad->telefone;
                $updateImovel["dn_cpf_cnpj"] = $cad->cpf;
            }
            //--------------------------------------------------------------
            
            
            
            if($imovel->doc_perfil == 'cpf')
            {
                $updateImovel['lancamento'] = '';
                $updateImovel['imovel_novo'] = '';
                $updateImovel['doc_planilha'] = '';
                $updateImovel[''] = '';
                $this->cad_model->deleteImovelRel($imovel->id_imovel);
                if($imovel->doc_planilha != ''){
                    $file_name = $imovel->doc_planilha;
                    $file_path = './modules/anunciante/' . $id_cadastro .'/planilhas/';
                    $file = $file_path.$file_name;
                    if(file_exists($file))
                        unlink($file);  
                }
            }
            if($imovel->doc_perfil == 'cnpj' && $imovel->lancamento != 'Sim')
            {
                $updateImovel['previsao_entrega'] = '';
                $updateImovel['doc_planilha'] = '';
                $this->cad_model->deleteImovelRel($imovel->id_imovel);
                if($imovel->doc_planilha != ''){
                    $file_name = $imovel->doc_planilha;
                    $file_path = './modules/anunciante/' . $id_cadastro .'/planilhas/';
                    $file = $file_path.$file_name;
                    if(file_exists($file))
                        unlink($file);  
                }
            }
            
            $imoveis = $this->cad_model->getImoveisImg([],['a.id_imovel'=>$imovel->id_imovel,'id_imovel_rel'=>$imovel->id_imovel]);//'a.id_imovel'=>$imovel->id_imovel,
            foreach ($imoveis as $id_imovel=>$obj)
            {
                $idImovelRel = $obj->id_imovel_rel;
                if( $idImovelRel > 0 ){
                    //$uri = 'modules/anunciante/'.$obj->id_cadastro.'/'.$idImovelRel.'/galeria/';
                    
                    /*foreach ($imoveis[$idImovelRel]->imagens as $img)
                    {
                        $insert = $img;
                        $insert->id_imovel = $id_imovel;
                        $insert->uri = $uri;
                        unset($insert->id_img);
                        $this->db->insert('cad_img', $img);
                    }*/
                    
                    if($obj->tipo_imovel == '')
                        $update['tipo_imovel'] = $imoveis[$idImovelRel]->tipo_imovel;
                    
                    $update['key_anuncio'] = HImovel::montaKeyAnuncio($obj);
                    //$update['dn_img'] = $imovel->dn_img;
                    //$update['val_public_total'] = (1.5*$imoveis[$idImovelRel]->val_pretendido)/100;
                    $update['val_public_total'] = (5*$imoveis[$idImovelRel]->val_pretendido)/100;
                    
                    //dd($update['val_public_total']);
                    
	                $update['val_public_total_metro'] = str_replace(",", ".", $update['val_public_total'])/str_replace(",", ".", $imoveis[$idImovelRel]->area_total);
	                $update['val_public_total'] = str_replace(",", ".", $update['val_public_total']);
	                $update['val_public_total_metro'] = str_replace(",", ".", $update['val_public_total_metro']);
	                
                    $this->db->where('id_imovel', $id_imovel);
	                $this->db->update('cad_imovel', $update);
                    
                }
                /*
                else{
                    $uri = 'modules/anunciante/'.$obj->id_cadastro.'/'.$obj->id_imovel.'/galeria/';
                    foreach ($obj->imagens as $img)
                    {
                        $this->db->where('id_img', $img->id_img);
    	                $this->db->update('cad_img', ['uri' => $uri]);
                    }
                }*/
            }
            
            $updateImovel['key_anuncio'] = HImovel::montaKeyAnuncio($obj);
            $updateImovel['status'] = 2;
            
            $updateImovel['contrato_prestacao'] = $this->contrato_imovel_s3($imovel->id_imovel);
            
            
            $data_email_xxx = array(   
                'nome' => $this->altera_nome($this->session->nome),
                'email'=> $this->session->email,
                'anexo'=> $updateImovel['contrato_prestacao'],
                'link'=> base_url(),
                'linkcustom'=> base_url()
            );
                
            $this->newsletter->enviar_email_campanha($data_email_xxx['email'], 52, $data_email_xxx);
            
            if($this->cad_model->updateImovel($imovel->id_imovel,$updateImovel)){
                $this->cad_model->updateImovelRel($imovel->id_imovel,['status'=>2]);
                //$this->session->set_userdata('cadastro_concluido', $imovel->id_imovel);
                
                $this->cad_model->updateCadastro($this->session->id_cadastro, ['vendedor' => 1]);
                
                /*
                MFluxo::finalizaCadImovel( 
                    1 id_imovel, 
                    2 dados de update, 
                    3 id_perfil na hora da edicao (como aqui é area do usuario, vai ser sempre perfil 0)
                )
                */
                MFluxo::finalizouCadImovel($imovel->id_imovel,$updateImovel, 0);
                
                $data = array(   
                            'nome' => $this->altera_nome($this->session->nome),
                            'email'=> $this->session->email,
                            'melhor_horario'=> $imovel->melhor_horario
                        );
                
                $msg['ID'] = $imovel->id_imovel;
                $msg['Link Painel'] = base_url('administrativo/dashboard/imovel/').$imovel->id_imovel;
                HEmail::alerta('Cadastro de Imovel Concluído', $msg);
                
                if($imovel->fotos_profissionais == "on"){
                    $this->newsletter->enviar_email_campanha($data['email'], 30, $data);//cadastro com pedido de fotos
                }else{
                    $this->newsletter->enviar_email_campanha($data['email'], 25, $data);//cadastro sem pedido de fotos
                }
                
                $json = ['valid' => true, 'redirect' => base_url('cadastro/imovel/resultado'), 'data'=> $data,'msg' => 'Sucesso!'];
            }
            else{
                $json = ['valid' => false,'erro' => 5,'msg' => 'Falha de comunicação com o banco!'];
            }
        }
        else
        {
            $json = ['valid' => false,'erro' => 4,'msg' => 'Acesso negado!'];
        }
        echo json_encode($json);
    }
    
    public function finaliza_edit_imovel()
    {
        $data = $this->input->post();
        // Verifica se o imovel pertence ao cadastro;
        $imovel = $this->cad_model->getImovelCad(['id_imovel'=>$data['id_imovel']]);
        if(!empty($imovel))
        {
            // se nao tiver cpf no cadastro e tiver marcado Trazer dados do perfil cadastrado, Sobe o cpf pro CADASTRO
            $cad = $this->cad_model->get_cadastro();
            if(strlen($imovel->dn_cpf_cnpj) == 14 && $cad->cpf == '')
                $this->cad_model->updateCadastro($cad->id_cadastro,['cpf'=> $imovel->dn_cpf_cnpj]);
            //--------------------------------------------------------------
            
            $updateImovel['key_anuncio'] = HImovel::montaKeyAnuncio($obj);
            $updateImovel['status'] = 2;
            
            if($this->cad_model->updateImovel($imovel->id_imovel,$updateImovel)){
                //$this->cad_model->updateImovelRel($imovel->id_imovel,['status'=>2]);
                //$this->session->set_userdata('cadastro_concluido', $imovel->id_imovel);
                $json = ['valid' => true, 'redirect' => base_url('minha_conta/minhas_vendas/anuncios'), 'data'=> $data,'msg' => 'Sucesso!'];
            }
            else{
                $json = ['valid' => false,'erro' => 5,'msg' => 'Falha de comunicação com o banco!'];
            }
        }
        else
        {
            $json = ['valid' => false,'erro' => 4,'msg' => 'Acesso negado!'];
        }
        echo json_encode($json);
    }
    
    public function set_resultado()
    {
        $resultado = $this->input->post('resultado');
        
        switch ($resultado) {
        case 1:
            $redirec = base_url('cadastro/imovel');
            break;
        case 2:
            $this->setNovaUnidade();
            $redirec = base_url('cadastro/imovel/');
            break;
        case 3:
            $redirec = base_url('minha-conta/minhas-vendas/anuncios');
            break;
        case 4:
            $redirec = base_url('minha-conta/minhas-vendas/anuncios');
            break;
        default:
            $redirec = base_url();
    }
         
        $this->session->unset_userdata('cadastro_concluido');
        $json = ['valid' => true, 'redirect' => $redirec, 'msg' => 'Sucesso!'];
           
        echo json_encode($json);
    }
    
    private function setNovaUnidade()
    {
        $id_ultimo_imovel = $this->session->cadastro_concluido;
        if($id_ultimo_imovel != null)
        {
            $ultimoCad = $this->cad_model->getImovelCad(['id_imovel' => $id_ultimo_imovel ]); 
            if(!is_null($ultimoCad))
            {
                $insert = $this->filtraCamposNovaUnidade($ultimoCad);
                $this->cad_model->insertImovel($insert);
            }
        }
    }
    
    
    //Save S3
    public function contrato_imovel_s3($id_imovel)
    {
        ini_set('max_execution_time', 300);
        
        $data['imovel'] = $this->cad_model->getImovel(['id_imovel'=>$id_imovel]);
        $data['donoCadastro'] = $this->cad_model->getCadastro([['id_cadastro',$data['imovel']->id_cadastro]]);
        Template::load_view('doc_contrato_prestacao_servico_pdf', $data, '', '', $html);
        
	    if(!empty($html))
	    {
            $mpdf = new \Mpdf\Mpdf(['tempDir' => 'assets/uploads/']);
            $filename = 'contrato_prestacao_servico-'.$id_imovel.'-'.date('m-Y-h-i-s').'.pdf';
            //$mpdf->WriteHTML($stylesheet,1);
            $mpdf->WriteHTML($html);
            $filepath = 'assets/uploads/'.$filename;
            $mpdf->Output($filepath, 'F');
            
            return $this->load_s3($filename, $id_imovel, $data['imovel']->id_cadastro);
	    }
	    
	    return '';
    }
    
    public function load_s3($name, $id_imovel, $id_cadastro){
        
        //$credentials = new Credentials(ACCESS_KEY, SECRET_KEY);
        //$s3 = new S3Client(['version' => 'latest','region' => 'us-west-2','credentials' => $credentials]);
        //$key = 'anunciante/'.$id_cadastro.'/anuncios/'.$id_imovel.'/'.$name;
        //$tmp_name = 'assets/uploads/'.$name;
        //$putImg = $this->getPutResize($tmp_name, $nameLocal, 0, $field_info->upload_path_s3);
        //$putImg = [
        //    'ACL' => 'public-read',
        //    'Bucket' => getenv('S3_BUCKET'),
        //    'Key'    => $key,
        //    'SourceFile' => $sourceFile,
        //    'ContentDisposition' => 'inline; filename='.$name,
        //    ];
        //$resImg = $s3->putObject($putImg);
        //$imgUrl = $resImg['ObjectURL'];
        
        $tmp_name = 'assets/uploads/'.$name;
        $upload_path = 'anunciante/'.$id_cadastro.'/anuncios/'.$id_imovel;
        $imgUrl = Upload::putObjectResize($tmp_name, $name, null, $upload_path);
        
        if(file_exists($tmp_name))
        {
            unlink($tmp_name);  
        }
        
        return $imgUrl;
        
    }
    
    // P O S T ---- C E P ----------------------------------------------------------------------------
    
    public function set_geo_bairro()
    {
        if($this->tank_auth->is_logged_in())
        {
            $post = $this->input->post();
            $w[] = ['bairro', $post['bairro']];
            $geo = $this->cad_model->getGeoBairro($w);
            
            if($geo != null){
                if($geo->b_lat == '' && $geo->b_long == '')
                {
                    $data = [
                        'id_bairro' => $geo->id_bairro,
                        'b_lat' => $post['lat'],
                        'b_long' => $post['long']
                        ];
                    $r = $this->cad_model->insertGeoBairro($data);
                }
            }    
            
            if($r??false)
                 $json = ['valid' => true,'msg' => "insert!"];
            else
                 $json = ['valid' => false, 'msg' => "No insert!"];
        }
        else
        {
            $json = ['valid' => false,'erro' => 4,'msg' => "Acesso negado!"];
        }
        echo json_encode($json);
    }
    
    // P O S T ---- N E W S L E T T E R---------------------------------------------------------------
    
    public function set_email_campanha()
    {
        $this->load->library('form_validation');
        $this->form_validation->set_rules('email', 'E-mail', 'required|trim|valid_email');
		
		if ($this->form_validation->run() != FALSE) 
        {
            $email  = $this->input->post('email');
            $origem = $this->input->post('origem');
            
            $nwl_email = $this->cad_model->getEmail([['email',$email],['origem',$origem]]);
            if($nwl_email == null)
                $this->cad_model->insertEmail(['email' => $email, 'origem'=>$origem]);
            
            $email_anunciar = $this->session->set_flashdata('email_anunciar', $email);
            
            
            if($this->logado())
                $redirect = base_url('cadastro/imovel');
            elseif ($this->cad_model->get_cadastro(['email' => $email], false) == null)
                $redirect = base_url('cadastro');
            else   
                $redirect = base_url('login');
                
            $json = ['valid' => true,'msg' => "Sucesso!",'redirect' => $redirect]; 
                
        }else{
            $json = ['valid' => false,'erro' => 1,'msg' => validation_errors()];
        }
        echo json_encode($json);
    }
    // G E T ---------------------------------------------------------------
    
    public function get_cadastro_para_imovel()
    {
        $cad = $this->cad_model->get_cadastro();
        $imovel = $this->cad_model->getImovelCad(['id_imovel'=> $this->input->post('id_imovel')]);
        
        if(!empty($cad))
        {
            if($cad->img_perfil != '')
            {
                $data['dn_img'] = $cad->img_perfil;
                $data['dn_img_uri'] = $cad->img_perfil_uri;
                $this->cad_model->updateImovel($this->session->id_imovel,$data);
            }
            
            if($cad->cpf == '' && $imovel->doc_perfil == 'cpf' && $imovel->dn_cpf_cnpj != '')
            {
                $cad->cpf = $imovel->dn_cpf_cnpj;
            }
            
            $dataNasc = $cad->data_nascimento;
            if(!empty($dataNasc)){
                $traco = substr($dataNasc, 4, -5); //9999-99-99
                if($traco == "-")
                    $cad->data_nascimento = converte_data($dataNasc,2);
            }
            
            //doc_perfil
            //dn_cpf_cnpj
            
            $json = ['valid' => true, 'cad'=> $cad];
        }
        else
        {
            $json = ['valid' => false, 'cad'=> null];
        }
        echo json_encode($json);
    }
    
    public function get_braco_direito()
    {
        $email = $this->input->post('email');
        
        // Verifica se o imovel pertence ao cadastro;
        $braco_direito = $this->cad_model->get_cadastro(['email'=>$email], false);
        
        if(!empty($braco_direito))
        {
            $json = ['valid' => true, 'data'=> $braco_direito];
        }
        else
        {
            $json = ['valid' => false, 'data'=> null];
        }
        echo json_encode($json);
    }
    
    public function filtroEtapaCadImovel()
    {
        $etapa = $this->input->post('etapa_cadastro');
        
        var_dump($etapa);
        
        /*$redirect = base_url('cadastro/imovel/'.$etapa);
        
        if(!empty($redirect))
        {
            $json = ['valid' => true, 'redirect'=> $redirect];
        }
        else
        {
            $json = ['valid' => false, 'redirect'=> null];
        }
        echo json_encode($json);*/
    }
    
    // P R I V A T E ---------------------------------------------------------------
    
    private function filtraCamposNovaUnidade($cad)
    {
        $cad = (array)$cad;
        $array_unset = [
            'id_imovel',
            'id_imovel_rel',
            'unidade',
            'status',
            'importar_planilha',
            'doc_planilha',
            'tipo_imovel',
            //'numero',
            //'complemento',
            'quartos',
            'suites',
            'banheiros',
            'andar',
            'vaga',
            'posicao_sol',
            'imovel_canto',
            'num_matricula',
            'area_total',
            'area_privativa',
            'doc_propriedade',
            'val_pretendido',
            'key_anuncio'
            ];
        foreach ($cad as $key=>$value)
            if(in_array($key, $array_unset))
                unset($cad[$key]);
        
        return $cad;
    }
        
    private function get_angle_rotate($filename)
    {
        $rotate = 0;
        
        if (empty($filename) || $filename == '')
            return $rotate;
            
        $info = getimagesize($filename);
        
        if ($info['mime'] == 'image/jpeg')
        {
            $image = imagecreatefromjpeg($filename);
            $exif = @exif_read_data($filename);
            
            if(!empty($exif['Orientation'])) {
                //echo $exif['Orientation'];
                switch($exif['Orientation']) {
                    case 8:
                        $rotate = 90;
                        break;
                    case 3:
                        $rotate = 180;
                        break;
                    case 6:
                        $rotate = 270;
                        break;
                }
            }
        }   
        
        return $rotate;
    }   
    
    private function rotate_image($filename,$angle)
    {
        if($angle != 0)
        {
            $config=array();
            $config['image_library'] = 'GD2';
            $config['create_thumb'] = FALSE; //No thumbnail
            $config['source_image'] = $filename; //full path for the source image
            $config['rotation_angle'] = $angle;//
            
            $this->load->library('image_lib', $config);
            $this->image_lib->clear();
            
            $this->image_lib->initialize($config);
        
            //Rotate the image
            if (!$this->image_lib->rotate()){
                echo $this->image_lib->display_errors();
            }
        }
    }
    
    private function criaPastaPerfil()
    {
        if(!is_dir('./modules/anunciante/' . $this->session->id_cadastro .'/perfil/'))
            mkdir('./modules/anunciante/' . $this->session->id_cadastro .'/perfil/', 0774, true);
    }
    
    private function limpaVazios($array)
    {
        foreach ($array as $key=>$val)
        {
            if($val == '')
                unset($array[$key]);
        }
    }
    
    private function password_hash($senha) 
    {
        // Hash password using phpass
        $hasher = new PasswordHash($this->config->item('phpass_hash_strength', 'tank_auth') , $this->config->item('phpass_hash_portable', 'tank_auth'));
        $senha = $hasher->HashPassword($senha);
        
        return $senha;
    }
    
    private function validaEmail($email) 
    {
        $array_invalidos = array(
            //'@mailinator.com',
            //'@harakirimail.com'
            );
        $syntaxe = '#^[\w.-]+@[\w.-]+\.[a-zA-Z]{2,6}$#';
        if (preg_match($syntaxe, $email))
        {
            foreach($array_invalidos as $invalido)
            {
                $result = strrpos($email, $invalido); //Resultado: 8
                if($result != null)
                {
                   return false;
                }
            }
             return true;
        }
        else 
        {
            return false;
        }
    }
    
    private function gerar_senha($tamanho = 6, $maiusculas = true, $minusculas = true, $numeros = true, $simbolos = false)
    {
        $ma = "ABCDEFGHIJKLMNOPQRSTUVYXWZ"; // $ma contem as letras maiúsculas
        $mi = "abcdefghijklmnopqrstuvyxwz"; // $mi contem as letras minusculas
        $nu = "0123456789"; // $nu contem os números
        $si = "!@#$%¨&*()_+="; // $si contem os símbolos
        
        $senha = '';
        
        if ($maiusculas){
            // se $maiusculas for "true", a variável $ma é embaralhada e adicionada para a variável $senha
            $senha .= str_shuffle($ma);
        }
        
        if ($minusculas){
            // se $minusculas for "true", a variável $mi é embaralhada e adicionada para a variável $senha
            $senha .= str_shuffle($mi);
        }
        
        if ($numeros){
            // se $numeros for "true", a variável $nu é embaralhada e adicionada para a variável $senha
            $senha .= str_shuffle($nu);
        }
        
        if ($simbolos){
            // se $simbolos for "true", a variável $si é embaralhada e adicionada para a variável $senha
            $senha .= str_shuffle($si);
        }
        
        // retorna a senha embaralhada com "str_shuffle" com o tamanho definido pela variável $tamanho
        return substr(str_shuffle($senha),0,$tamanho);
    }
    
    private function get_vagas($str)
	{
	    $output = preg_split( "/e|,/", $str );
	    
	    return count($output);
	}
	
	private function get_cell_value($spreadsheet,$column,$row)
	{
	    return $spreadsheet->getActiveSheet()->getCellByColumnAndRow($column,$row)->getValue();
	}
	
	private function buscar_cep($cep)
	{
	    $vazio = [
                    'latitude' => '',
                    'cep' => '',
                    'endereco' => '',
                    'bairro' => '',
                    'cidade' => '',
                    'estado' => ''
                ];
	    
	    if($cep == NULL || $cep == '')
           return $vazio;
	    
        $cep = preg_replace("/[^0-9]/", "", $cep);
        $end = $this->cad_model->getEndereco($cep);
        
        if (empty($end))
            return $vazio;
        else{
            $end = (array)$end;
            $end['latitude'] = '';
            $end['endereco'] = $end['logradouro'];
            return $end;
        }
            
        
        
	    try
        {
            $loginUrl = 'http://www.buscacep.correios.com.br/sistemas/buscacep/resultadoBuscaCepEndereco.cfm';
            $postfields = array(
                'relaxation' => $cep,
                'tipoCEP' => 'ALL',
                'semelhante' => 'N'
            );
            //init curl
            $ch = curl_init();
            //Set the URL to work with
            curl_setopt($ch, CURLOPT_URL, $loginUrl);
            curl_setopt($ch, CURLOPT_REFERER, "http://www.buscacep.correios.com.br/sistemas/buscacep/");
            // ENABLE HTTP POST
            curl_setopt($ch, CURLOPT_POST, TRUE);
            //Set the post parameters
            curl_setopt($ch, CURLOPT_POSTFIELDS, $postfields);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_VERBOSE, TRUE);
            curl_setopt($ch, CURLOPT_TIMEOUT, 20);
            //execute the request (the login)
            $response = curl_exec($ch); //curl_exec($ch);
            
            curl_close($ch);
            $dom = new DOMDocument();
            //print_r(html_entity_decode($response)); die();
            @$dom->loadHTML($response);
            $xpath = new DomXPath($dom);
            $class = 'tmptabela';
            //$divs = $xpath->query("//*[contains(concat(' ', normalize-space(@class), ' '), ' $class ')]");
            $divs = $xpath->query("//*[contains(@class, 'tmptabela')]//tr[2]//td");

            $array = array();
            foreach ($divs as $div){
                $array[] = $div->nodeValue;
            }
                        
            if (count($array) == 0) 
            {
                return [
                    'cep' => '',
                    'endereco' => '',
                    'bairro' => '',
                    'cidade' => '',
                    'estado' => ''
                ];
            }
            else
            {
                $logradouro = trim($array[0]);
                $bairro = trim($array[1]);
                if($bairro == 'Setor de Habitações Individuais Sul') $bairro = 'Lago Sul';
                if($bairro == 'Setor de Habitações Individuais Norte') $bairro = 'Lago Norte';
                $pseudo_adress = explode("/", $array[2]);
                $cidade = trim($pseudo_adress[0]);
                $uf = trim($pseudo_adress[1]);
                
                return [
                    'cep' => $cep,
                    'endereco' => $logradouro,
                    'bairro' => $bairro,
                    'cidade' => $cidade,
                    'estado' => $uf
                ];
            }
        }
        catch(Exception $e) 
        {
            trigger_error(sprintf('Curl failed with error #%d: %s', $e->getCode() , $e->getMessage()) , E_USER_ERROR);
        }
	}
	
	//---------------------------------------------------------------
	
	/*if(strcmp($titulo, $novoTitulo) === 0){
                
            }
            else
            {
                $key = convertAccentsAndSpecialToNormal(strtolower($novoTitulo));
                //$key_anuncio = $this->verifica_key($key);
                $data['key_anuncio'] = $key;
            }*/
	
	/*private function verifica_key($key) 
    {
        $str = '';
        $cont = 1;
        $return = $key;
        while ($this->confirma_key($key . $str)) 
        {
            $cont++;
            $str = "-" . $cont;
            $return = $key . $str;
        }
        return $return;
    }
	
	private function confirma_key($key) 
    {
        $this->db->where('key_anuncio',$key);
        $query = $this->db->get('cad_imovel');
          
        if ($query->num_rows() === 1 )
        {
            if($query->result()[0]->id_anunciante === $this->cadID && $query->result()[0]->moderacao === 'novo')
            {
                return false;
            }
              
            return true;
        }
        return false;
    }*/
	
	

	
	//---------------------------------------------------------------
    
    //favoritos
    public function curtir_ajax()
	{
	    $valid = false;
	    $result = [];
	    $dados['id_imovel'] = $this->input->post('id_imovel');
        $dados['id_cadastro'] = $this->session->id_cadastro;
        
        if($dados['id_cadastro'] != null)
        {
            $result = $this->cad_model->select_curtir($dados['id_cadastro'],$dados['id_imovel']) ;
            
            if($result == NULL)
            {
                $this->cad_model->insert_curtir($dados);
                $valid = true;
            }
        }
        echo json_encode(['valid' => true, 'banco' => $valid, 'result' => $result, 'dados' => $dados]);
	}
	
	public function descurtir_ajax()
	{
	    $valid = false;
	    $result = [];
	    $dados['id_imovel'] = $this->input->post('id_imovel');
        $dados['id_cadastro'] = $this->session->id_cadastro;
        
        if($dados['id_cadastro'] != null)
        {
            $result = $this->cad_model->select_curtir($dados['id_cadastro'],$dados['id_imovel']) ;
            
            if($result !== NULL)
            {
                $this->cad_model->delete_curtir($dados['id_cadastro'],$dados['id_imovel']);
                $valid = true;
            }
        }
        echo json_encode(['valid' => true, 'banco' => $valid, 'result' => $result, 'dados' => $dados]);
	}
	
	/*// historico
	protected function set_visualizacao_ajax()
    {
        $id_item = $this->input->post('id_item');
        $tipo_item = $this->input->post('tipo_item');
        
        if($id_item != null && $tipo_item != null)
        {
            $this->add_visualizacao($id_item, $tipo_item);
        }
   }
	protected function set_click_ajax()
	{
	    $id_item = $this->input->post('id_item');
        $tipo_item = $this->input->post('tipo_item');
        $buttom = $this->input->post('buttom');
        if($id_item != null && $tipo_item != null)
        {
            $this->add_clik($id_item, $tipo_item, $buttom);
        }
	}*/
}