<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Contato_ajax extends Builder_Controller {

	function __construct()
	{
		parent::__construct();
	} 
	
	public function index() 
    {
        if ($this->input->post() == TRUE) 
        {
            $this->load->library('form_validation');
            
            $this->form_validation->set_rules('nome', 'Nome', 'required|trim');
            $this->form_validation->set_rules('email', 'E-mail', 'required|valid_email|trim');
            $this->form_validation->set_rules('assunto', 'Assunto', 'required|trim');
            $this->form_validation->set_rules('telefone', 'Telefone', 'trim');
            $this->form_validation->set_rules('mensagem', 'Mensagem', 'required|trim');
            
            if ($this->form_validation->run() != FALSE) 
            {
                $nome      = $this->input->post('nome');
                $email_remetente  = $this->input->post('email');
                $assunto   = $this->input->post('assunto');
                $telefone  = $this->input->post('telefone');
                $mensagem  = $this->input->post('mensagem');
                $data_hora = date("Y-m-d H:i:s");
                
                $this->load->model('sistema/usuario_model');
                
                $result_email = $this->usuario_model->get_usuario_by_email($email_remetente);
                
                if ($result_email !== NULL) 
                { 
                    $data = array(
                        'nome'      => $nome,
                        'email'     => $email_remetente,
                        'telefone'  => $telefone,
                        'assunto'   => $assunto,
                        'mensagem'  => $mensagem,
                        'data_hora' => $data_hora
                    );
                    
                    $result_insert = $this->cad_model->insertContato($data);
                    
                    if ($result_insert) 
                    {
                        $this->send_message_by_email($nome, $email_remetente, $telefone, $assunto, $mensagem, $data_hora);
                    } 
                    else
                    {
                        echo json_encode(array(
                            'valid' => false,
                            'msg' => 'Error. Por favor, tente novamente mais tarde.'
                        ));
                    }
                } 
                else
                {
                    echo json_encode(array(
                        'valid' => false,
                        'msg' => 'O e-mail informado não foi encontrado em nosso banco de dados. Favor inserir o seu e-mail no campo acima ou realizar o seu cadastro para ter acesso ao Comdono.'
                    ));
                }
            } 
            else
            {
                echo json_encode(array(
                    'valid' => false,
                    'msg' => validation_errors()
                ));
            }
        }
    }
    
    //public function send_message_by_email($nome, $id_cadastro, $email, $new_password_key)
    public function send_message_by_email($nome, $email_remetente, $telefone, $assunto, $mensagem, $data_hora)
    {
        $data = array(
            'nome'      => $nome,
            'email_remetente'     => $email_remetente,
            'telefone'  => $telefone,
            'assunto'   => $assunto,
            'mensagem'  => $mensagem,
            'data_hora' => $data_hora
            
        );
        
        $this->load->library('newsletter/newsletter');
        
        $message = "<p>Uma mensagem foi encaminhada para nossa equipe de suporte. Em breve entraremos em contato.</p>";
        
        HEmail::alerta("contato site", json_encode($data));
        
        $email_destino = "contato@viewbrasil.com.br";
        
        if ($this->newsletter->enviar_email_campanha($email_destino, 18, $data)) 
        {
            echo json_encode(array(
                'valid' => true,
                'msg' => $message,
            ));
        } 
        else
        {
            echo json_encode(array(
                'valid' => false,
                'msg' => 'O e-mail informado não pôde ser enviado. Por favor, tente novamente mais tarde.'
            ));
        }
    }
 }