<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Financiamento_ajax extends Builder_Controller {

	function __construct()
	{
        parent::__construct();
        $this->load->model('busca_model');
        
        if(!$this->logado())
            die(json_encode(['valid' => false,'erro' => 4,'msg' => "Acesso negado!"]));
        
        $this->load->library('newsletter/newsletter');
    }
    
    // POST ---- ETAPA 1 ---------------------------------------------------------------
     
    public function set_calculo()
    {
        $post = $this->input->post();
        $id_imovel = $post['id_imovel'];
        $id_cadastro = $this->session->id_cadastro;
        $simulacao = $this->cad_model->getSimulacaoFinanciamento(['id_imovel'=>$id_imovel, 'id_cad_interessado'=>$id_cadastro, 'step <' => 4 ]);
        $imovel = $this->busca_model->getImovelById($id_imovel);  
        
        if(empty($simulacao))
        {
            $insert = [
            'id_imovel'          => $id_imovel,
            'id_cad_dono'        => $imovel->id_cadastro,
            'id_cad_interessado' => $id_cadastro,
            'val_imovel'         => $imovel->val_pretendido,
            'val_entrada'        => $post['valor'],
            'meses_financiado'   => $post['meses'],
            'taxa'               => $post['taxa'],
            'val_parcelas'       => $post['val_parcelas'],
            'val_total'          => $post['val_total'],
            'tipo_pessoa'        => 'cpf',
            'data_simulacao'     => date("Y-m-d H:i:s")
            ];
            
            
            $id_simulacao = $this->cad_model->insertSimulacao($insert);
            
            if($id_simulacao != false){
                
                $msg = $insert;
                $msg['link_painel'] = base_url('administrativo/financiamentos/bancos/'.$id_simulacao);
                HEmail::alerta('Iniciou Financiamento', $msg);
                
                $historico = [
                    'id_simulacao'       => $id_simulacao,
                    'val_imovel'         => $imovel->val_pretendido,
                    'val_entrada'        => $post['valor'],
                    'meses_financiado'   => $post['meses'],
                    'taxa'               => $post['taxa'],
                    'val_parcelas'       => $post['val_parcelas'],
                    'val_total'          => $post['val_total'],
                    ];
                $this->cad_model->insertHistoricoSimulacao($historico);
                $json = ['valid' => true,'msg' => "Sucesso!"]; 
            }
                
            else
                $json = ['valid' => false,'erro' => 3,'msg' => "Erro!"];
        }
        else
        {
            $historico = [
                    'id_simulacao'       => $simulacao->id_simulacao,
                    'val_imovel'         => $imovel->val_pretendido,
                    'val_entrada'        => $post['valor'],
                    'meses_financiado'   => $post['meses'],
                    'taxa'               => $post['taxa'],
                    'val_parcelas'       => $post['val_parcelas'],
                    'val_total'          => $post['val_total'],
                    ];
            $this->cad_model->insertHistoricoSimulacao($historico);
            $json = ['valid' => true,'msg' => "Sucesso!"]; 
        }
    }
    
    public function iniciaSimulacao()
    {
        $this->load->library('form_validation');
        $this->form_validation->set_rules('id_imovel', 'Imóvel', 'required|trim');
        $this->form_validation->set_rules('valor', 'Valor', 'required|trim');
        $this->form_validation->set_rules('meses', 'Meses', 'required|trim');
		$post = $this->input->post();
		if(empty($post['bancos_aprovados']??[]))
        {
            $json = ['valid' => false,'erro' => 1,'msg' => 'Ops! Infelizmente o valor de entrada e o período de financiamento não foram aprovados por nenhum de nossos bancos parceiros.'];
            echo json_encode($json);
            die();
        }

		if ($this->form_validation->run() != FALSE) 
        {
            $post = $this->input->post();
            $id_imovel = $post['id_imovel'];
            $id_cadastro = $this->session->id_cadastro;
            $simulacao = $this->cad_model->getSimulacaoFinanciamento(['id_imovel'=>$id_imovel, 'id_cad_interessado'=>$id_cadastro, 'step <' => 4 ]);
            //$simulacao = end($simulacao);
            
            
            if(empty($simulacao))
            {
                $imovel = $this->busca_model->getImovelById($id_imovel);
                $insert = [
                'id_imovel'          => $id_imovel,
                'id_cad_dono'        => $imovel->id_cadastro,
                'id_cad_interessado' => $id_cadastro,
                'val_imovel'         => $imovel->val_pretendido,
                'val_entrada'        => $post['valor'],
                'meses_financiado'   => $post['meses'],
                'taxa'               => $post['taxa'],
                'val_parcelas'       => $post['val_parcelas'],
                'val_total'          => $post['val_total'],
                'status'             => 1,
                'step'               => 1,
                'tipo_pessoa'        => 'cpf'
                
                ];
                $id_simulacao = $this->cad_model->insertSimulacao($insert);
                
                if($id_simulacao != false){
                    
                    /*
                    foreach($post['bancos_aprovados'] as $id_banco)
                    {
                        $dataBanco = [
                            'id_banco' => $id_banco,
                            'id_simulacao' => $id_simulacao,
                            'id_cadastro' => $this->session->id_cadastro
                            ];
                        $this->cad_model->insertBancoRelSimulacao($dataBanco);
                    }
                    */
                    
                    $json = ['valid' => true,'msg' => "Sucesso!",'redirect' => base_url("financiamento/cadastro/".$id_imovel)]; 
                }
                    
                else
                    $json = ['valid' => false,'erro' => 3,'msg' => "Erro!"];
                
            }else{ 
                
                $data = [
                'id_cad_interessado' => $id_cadastro,
                'val_entrada'        => $post['valor'],
                'meses_financiado'   => $post['meses'],
                'taxa'               => $post['taxa'],
                'val_parcelas'       => $post['val_parcelas'],
                'val_total'          => $post['val_total'],
                'status'             => 1,
                'step'               => 1,
                ];
                if($this->cad_model->updateSimulacao($simulacao->id_simulacao,$data)){
                    
                    $this->cad_model->deleteBancoRelSimulacao($simulacao->id_simulacao);
                    
                    /*
                    foreach($post['bancos_aprovados'] as $id_banco)
                    { 
                        $dataBanco = [
                            'id_banco' => $id_banco,
                            'id_simulacao' => $simulacao->id_simulacao,
                            'id_cadastro' => $this->session->id_cadastro
                            ];
                        $this->cad_model->insertBancoRelSimulacao($dataBanco);
                    }
                    */
                    
                    
                    $json = ['valid' => true,'msg' => "Sucesso!",'redirect' => base_url("financiamento/cadastro/".$id_imovel)]; 
                }
                else
                    $json = ['valid' => false,'erro' => 3,'msg' => "Erro!"];
            }
            
        }else{
            $json = ['valid' => false,'erro' => 1,'msg' => validation_errors()];
        }
        echo json_encode($json);
    }
    
    
    public function atualiza_simulacao()
    {
        
        $data = $this->input->post();
         if($data['step'] >= 1)
             $data['step'] = 4;//step de simulacao comcluido
        
        
        if($this->cad_model->updateSimulacao($data['id_simulacao'],$data)){
            
            if($data['step'] == 4){
                
                // se nao tiver cpf no cadastro e tiver marcado Trazer dados do perfil cadastrado, Sobe o cpf pro CADASTRO
                $cad = $this->cad_model->get_cadastro();
                if($cad->cpf == '')
                    $this->cad_model->updateCadastro($cad->id_cadastro,['cpf'=> $data['cpf']]);
                if($cad->data_nascimento == '')
                    $this->cad_model->updateCadastro($cad->id_cadastro,['data_nascimento'=> $data['data_nascimento']]);
                //--------------------------------------------------------------
                
                $simulacao = $this->cad_model->getSimulacoesFinanciamento(['a.id_simulacao'=>$data['id_simulacao']])[$data['id_simulacao']]??[];
                
                $comImovel = true;
                if($simulacao->id_imovel == 0)
                    $comImovel = false;
                
                $dados = [];
                
                if($comImovel){
                    $list_bancos = "";
                    foreach ($simulacao->bancos as $banco)
                        $list_bancos .= "<li style='display:block;margin: 15px 0;'><img src=".base_url().$banco->logo_ativa."></li>";
                    
                      
                    $vendedor = $this->cad_model->getVendFinanciamento($data['id_simulacao']);
                    
                    $dados = array(
                        'nome_vendedor'  => $this->altera_nome($vendedor->nome),
                        'email_vendedor' => $vendedor->email,
                        'link_imovel'    => base_url()."imovel/".$data['id_imovel'],
                        'nome_comprador' => $this->altera_nome($this->session->nome),
                        'email_comprador'=> $this->session->email,
                        'list_bancos'    => $list_bancos,
                        'link_painel'    => base_url('administrativo/financiamentos/bancos/'.$simulacao->id_simulacao)
                    );
                    
                    
                    
                    
                    $this->newsletter->enviar_email_campanha($vendedor->email, 29, $dados);
                    $this->newsletter->enviar_email_campanha($this->session->email, 28, $dados);
                }
                
                //Alerta o correspondente bancario;
                $correspondeteBancario = $this->cad_model->getCadUsers([['perfil',8]]);
                foreach ($correspondeteBancario as $user)
                {
                    $dados['link_painel'] = base_url('administrativo/financiamentos/bancos/'.$simulacao->id_simulacao);
                    $this->newsletter->envia($user->email, 55, $dados);
                }
            }
            
            
            
            $json = ['valid' => true, 'data'=> $data,'msg' => 'Sucesso!', 'redirect' => $direct??NULL];
        }
        else{
            $json = ['valid' => false,'erro' => 5,'msg' => 'Falha de comunicação com o banco!'];
        }
       
        echo json_encode($json);
    }
    
    public function atualiza_banco_rel()
    {
        $data = $this->input->post();
        
        if($this->cad_model->updateBancoRelSimulacao($data['id_bc_rel'],$data)){
            
            $json = ['valid' => true, 'data'=> $data,'msg' => 'Sucesso!'];
        }
        else{
            $json = ['valid' => false,'erro' => 5,'msg' => 'Falha de comunicação com o banco!'];
        }
       
        echo json_encode($json);
    }
    
    
    
    private function altera_nome($str){
        $nome = explode(' ', $str);
        $first = array_shift($nome);
        $last = array_pop($nome);
        $nome_novo = trim($first." ".$last);
        
        return $nome_novo;
    }
    
}