<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Avaliacao extends Comdono_Controller {

	function __construct()
	{
		parent::__construct();
		
		Assets::add_css(array(
            'plugins/owlcarousel2-2.3.4/css/owl.carousel.min',
            'plugins/owlcarousel2-2.3.4/css/owl.theme.default.min',
            'plugins/fancyBox-v3.5.7/css/jquery.fancybox.min',
            'plugins/wow_animation/css/animate'
        ));
        
        Assets::add_js(array(
            'plugins/owlcarousel2-2.3.4/js/owl.carousel.min',
            'plugins/fancyBox-v3.5.7/js/jquery.fancybox.min',
            'plugins/tweenmax/tweenmax.min',
            'plugins/wow_animation/js/wow.min',
            'plugins/wow_animation/js/script'
        ));
		
	    Assets::add_module_css('comdono', array(
            'lp-style',
            'sobre'
        ));
        
        Assets::add_module_js('comdono', array(
            'loading_image',
            'carousel_logos',
            'avaliacao'
        ));
	}
    
    public function index()
    {
        $data['tiposImovel'] = HBusca::getSelectTiposImovel();
        
        Template::set($data);
	    Template::set_view('lp_avaliacao2_view');
        Template::render();
        
    }
    
    public function confirmacao()
    {
        $key = $this->uri->segment(3);
        
        $cap = $this->cad_model->getCaptura([['key_captura', $key]]);
        
        $data['nome'] = $cap->nome??null;
        $data['email'] = $cap->email??null;
        
        Template::set($data);
	    Template::set_view('lp_confirmacao_view');
        Template::render();
    }
    
    public function resultado()
    {
        $key = $this->uri->segment(3);
        $key_email = $this->uri->segment(4);
        
        Newsletter::clicou($key_email);
        
        
        $data['cap'] = $this->cad_model->getCaptura([['key_captura', $key]]);
        
        $data["title"] = "";
        Template::set_modal($data,[
            'comdono/modal/avaliacao_especialista_view'
        ]);
        
        Template::set($data);
	    Template::set_view('lp_avaliacao_resultado_view');
        Template::render();
    }
}