<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

use Spatie\PdfToText\Pdf;

class Seguro extends Builder_Controller {
 
    public function __construct() {
        require APPPATH . 'libraries/vendor/autoload.php';
    }
     
     
    public function read($file)
	{
	    $imagens = [];
	    for ($i = 1; $i <= 3; $i++) {
    	    $imagens[] = (object)[
                    'uri'    =>'https://s3-us-west-2.amazonaws.com/dev.comdono/modules/comdono/lp/exclusive-park-sul/unidades/unidade1/unidade1-1.jpg',
                    'alt'      =>'',
                ];
	    }
	    
	    $unidades = [];
        for ($i = 1; $i <= 3; $i++) {
            $unidades[] = (object)[
                'titulo'    =>'unidades_titulo',
                'subtitulo' =>'unidades_subtitulo',
                'tipo'      =>'unidade_tipo',
                'metros'    => 50,
                'quartos'   => 2,
                'suites'    => 2,
                'banheiros' => 2,
                'valor'     => 1000.99,
                'imanges'   => $imagens
            ];
        }
        
        $diferenciais = [];
        for ($i = 1; $i <= 6; $i++) {
            $diferenciais[] = (object)[
                'titulo'    =>'',
                'icone'     =>'',
                'descricao' =>''
            ];
        }
        
	   $data['lp'] = (object)[
    	    'titulo_apresentacao'    => '',
            'titulo_h1'              => '',
            'titulo_h3'              => '',
            'titulo_h4'              => '',
            'cta_header'             => '',
            'form_titulo'            => '',
            'form_descricao'         => '',
            'form_imagem'            => '',
            'sobre_logo'             => '',
            'sobre_titulo'           => '',
            'sobre_descricao'        => '',
            'sobre_imagem'           => '',
            'diferenciais_titulo'    => '',
            'diferenciais_subtitulo' => '',
            'diferenciais'           => $diferenciais,
            'unidades_titulo'        => '',
            'unidades_subtitulo'     => '',
            'unidades'               => $unidades,
            'footer_titulo'          => '',
	    ];
	    
        /*	    
        titulo_apresentacao
        titulo_h1
        titulo_h3
        titulo_h4
        cta_header
        unidades_titulo
        unidades_subtitulo
            unidade_imagem
            unidade_tipo
            unidade_metragem
            unidade_quartos
            unidade_suites
            unidade_preco
        form_titulo
        form_descricao
        form_imagem
        sobre_logo
        sobre_titulo
        sobre_descricao
        sobre_imagem
        diferenciais_titulo
        diferenciais_subtitulo
            diferencial_icone
            diferencial_titulo
            diferencial_descricao
        footer_titulo
        */
	    
	    // $file = '../html/assets/uploads/dou/read-pdf9.pdf';
	    
	    $pdf = Pdf::getText($file);
	    
        $pos = strpos($pdf, "EXTRATO DE CONTRATO");
        
        $pos1 = strpos($pdf, "UASG");
        
        $extratos    = $this->get_string_positions($pdf,"EXTRATO DE CONTRATO");
        $uasgs       = $this->get_string_positions($pdf,"UASG");
        $assinaturas = $this->get_string_positions($pdf,"Data de Assinatura");
        
        foreach ($extratos as $extrato)
        {
            foreach ($uasgs as $uasg)
            {
                $diff = $uasg - $extrato;
                if($diff < 40 && $diff > 0)
                {
                    $pos_ass = strpos($pdf, "Data de Assinatura", $extrato);
                    
                    $lastPos = $pos_ass - strlen($pdf) + 31;
                    
                    $substring = substr($pdf,$extrato,$lastPos);
                    $substring = trim(preg_replace('/\s+/', ' ', $substring));
                    
                    //echo '<br>' . $substring . '<br>';
                    
                    $dados = array(); 
                    $dados['contrato'] = trim($this->get_string_between($substring, 'Nº ', '- UASG'));
                    $ini = $uasg + 5; 
                    $dados['uasg'] = substr($pdf,$ini, $ini - strlen($pdf) + 6);
                    $dados['processo'] = trim($this->get_string_between($substring, 'Processo:', '.'));
                    $dados['contratante'] = trim(str_replace('-.','',$this->get_string_between($substring, 'Contratante:', 'CNPJ')));
                    $dados['cnpj'] = trim($this->get_string_between($substring, 'CNPJ Contratado:', '.'));
                    $dados['contratado'] = trim($this->get_string_between($substring, '. Contratado :', 'Objeto'));
                    $dados['objeto'] = trim($this->get_string_between($substring, 'Objeto:', '.'));
                    $dados['valor'] = substr(trim($this->get_string_between($substring, 'Valor Total:', 'Fonte')),0, -1);
                    $data = trim($this->get_string_between($substring, 'Data de Assinatura:', '.'));
                    $dados['dt_assinatura'] = $this->convert_date($data);
                    
                    $this->db->insert('tb_diario', $dados);
                    
                    //var_dump($dados['dt_assinatura']);
                    
                    break;
                }
            }
        }
	}  
	
	public function convert_date($data)
	{
	    $data1 = DateTime::createFromFormat("d/m/Y", $data);
	    //$date = $data1->format("Y-m-d")
        return $data1 && $data1->format("Y-m-d") === $data;
	}
	
	private function get_string_between($string, $start, $end){
        $string = ' ' . $string;
        $ini = strpos($string, $start);
        if ($ini == 0) return '';
        $ini += strlen($start);
        $len = strpos($string, $end, $ini) - $ini;
        return substr($string, $ini, $len);
	}
	
	private function get_string_positions($html, $needle)
	{
	    $lastPos = 0;
        $positions = array();
        
	    while (($lastPos = strpos($html, $needle, $lastPos))!== false) {
            $positions[] = $lastPos;
            $lastPos = $lastPos + strlen($needle);
        }
        
        return $positions;
	}
	
	function build_http_query( $query_array = '' , $query )
	{
        foreach( $query as $key => $key_value )
        {
            $query_array .= urlencode( $key ) . '=' . urlencode( $key_value ) . '&';
        }
        return $query_array;
    }
    
    public function start($page = 1, $total = 0)
    {
        if($page == 1)
        {
            $query_array = $this->set_first_post('14/01','14/01','2019');
        }
        else {
            $query_array = $this->set_next_post($page,'14/01','14/01','2019');
        }
        
        //$query_array = $this->set_first_post('14/01','14/01','2019');
        
        $result = $this->post_search($query_array);
        
        if($page == 1)
        {
            $total = $this->get_total_pages($result);
        }


        $links = $this->get_links($result);
        
        foreach ($links as $link)
        {
            $this->get_link($link);
        }
        
        if($page < $total)
        {
            $page++;
            $this->start($page,$total);
        }
    }
    
    private function get_total_pages($response)
    {
        $dom = new DOMDocument;
        libxml_use_internal_errors(true);
		$dom->loadHTML(utf8_decode($response));
		libxml_clear_errors();
		
        $xpath = new DomXpath($dom);
        $nodes = $xpath->query('//*[contains(@class, "page-item")]');
        
        $onclick = $nodes->item($nodes->length-1)->childNodes->item(0)->getAttribute('onclick');
        
        return (int)$this->get_string_between($onclick, '(', ')');
        
        //return (int)$nodes->item($nodes->length-1)->nodeValue + 1;
    }
    
    private function get_links($response)
    {
        $dom = new DOMDocument;
        libxml_use_internal_errors(true);
		$dom->loadHTML(utf8_decode($response));
	    
	    $table = $dom->getElementsByTagName("table");	

		$result = $table->item(3);	

	    $trs = $result->getElementsByTagName("tr");
	    
	    $links = [];
	    for ( $i = 0; $i < $trs->length; $i++)
		{
	        $tr = $trs->item($i);
    		$tds = $tr->getElementsByTagName("td");
    		
    		if($tds->length > 0)
    		{
    		    $link = @$tds->item(0)->childNodes->item(1)->childNodes->item(0)->getAttribute('href');
    		
    		    $links[] = $this->trata_link($link);
    		}
		}
		return $links;
    }
    
    public function set_first_post($dt_ini,$dt_fim,$ano)
	{
        $query_array = $this->build_http_query('',array(
	    'edicao.jornal_hidden'=>'1,1000,1010,1020,515,521,522,531,535,536,523,532,2,2000,529,525,3,3000,3020,1040,526,530,600,601,602,603,604,605,606,607,608,609,610,611,612,613,614,615,701,702'));
	    //$query_array = $this->build_http_query($query_array ,array('edicao.paginaAtual'=>'12'));
	    $query_array = $this->build_http_query($query_array , array('edicao.txtPesquisa'=>'"extrato de contrato"'));
        $query_array = $this->build_http_query($query_array , array('__checkbox_edicao.jornal'=>'1,1000,1010,1020,515,521,522,531,535,536,523,532,2,2000,529,525,3,3000,3020,1040,526,530,600,601,602,603,604,605,606,607,608,609,610,611,612,613,614,615,701,702'));
        $query_array = $this->build_http_query($query_array , array('__checkbox_edicao.jornal'=>'1,1000,1010,1020,515,521,522,531,535,536,523,532,600,601,602,603,612,613,614,615,701'));
        $query_array = $this->build_http_query($query_array , array('__checkbox_edicao.jornal'=>'2,2000,529,525,604,605,606,607,702'));
        $query_array = $this->build_http_query($query_array , array('__checkbox_edicao.jornal'=>'3,3000,3020,1040,526,530,608,609,610,611'));
        $query_array = $this->build_http_query($query_array , array('edicao.fonetica'=>'null'));
        $query_array = $this->build_http_query($query_array , array('edicao.dtInicio'=>$dt_ini));
        $query_array = $this->build_http_query($query_array , array('edicao.dtFim'=>$dt_fim));
        $query_array = $this->build_http_query($query_array , array('edicao.ano'=>$ano));
        
        return substr($query_array,0,-1);
	}
    
    public function set_next_post($pagina,$dt_ini,$dt_fim,$ano)
	{
        $query_array = $this->build_http_query('',array('edicao.paginaAtual'=>$pagina));
        $query_array = $this->build_http_query($query_array,array('edicao.jornal_hidden'=>''));
        $query_array = $this->build_http_query($query_array,array('edicao.consultaAntiga'=>'1,1000,1010,1020,515,521,522,531,535,536,523,532,2,2000,529,525,3,3000,3020,1040,526,530,600,601,602,603,604,605,606,607,608,609,610,611,612,613,614,615,701,702'));
        $query_array = $this->build_http_query($query_array,array('edicao.fonetica'=>'null, null, null'));
        $query_array = $this->build_http_query($query_array,array('edicao.txtPesquisa'=>'"extrato de contrato"'));
        $query_array = $this->build_http_query($query_array,array('__checkbox_edicao.jornal'=>'1,1000,1010,2,2000,3,3000,4,5,6,126,4000,5000,600,20,21,1020'));
        $query_array = $this->build_http_query($query_array,array('__checkbox_edicao.jornal'=>'1,1000,1010,1020'));
        $query_array = $this->build_http_query($query_array,array('__checkbox_edicao.jornal'=>'2,2000'));
        $query_array = $this->build_http_query($query_array,array('__checkbox_edicao.jornal'=>'3,3000'));
        $query_array = $this->build_http_query($query_array,array('edicao.fonetica'=>'null'));
        $query_array = $this->build_http_query($query_array,array('edicao.dtInicio'=>$dt_ini));
        $query_array = $this->build_http_query($query_array,array('edicao.dtFim'=>$dt_fim));
        $query_array = $this->build_http_query($query_array,array('edicao.ano'=>$ano));
        
        return substr($query_array,0,-1);
	}
	
	private function post_search($post)
	{
        $url="http://pesquisa.in.gov.br/imprensa/core/consulta.action"; 
        $ch = curl_init(); 
        curl_setopt ($ch, CURLOPT_URL, $url); 
        curl_setopt($ch, CURLOPT_AUTOREFERER, false);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $post);
        curl_setopt($ch, CURLOPT_REFERER, "http://pesquisa.in.gov.br/imprensa/core/start.action");
        curl_setopt($ch, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_1);
        curl_setopt($ch, CURLOPT_HEADER, 0);
        $curl_response = curl_exec ($ch); 
        //echo $curl_response;  
        curl_close($ch);
        
        return $curl_response;
	}
	
	/*public function post_search()
	{
        $post = 'edicao.jornal_hidden=&__checkbox_edicao.jornal=1%2C1000%2C1010%2C1020%2C515%2C521%2C522%2C531%2C535%2C536%2C523%2C532%2C540%2C1040%2C2%2C2000%2C529%2C525%2C3%2C3000%2C3020%2C1040%2C526%2C530%2C600%2C601%2C602%2C603%2C604%2C605%2C606%2C607%2C608%2C609%2C610%2C611%2C612%2C613%2C614%2C615%2C701%2C702&__checkbox_edicao.jornal=1%2C1000%2C1010%2C1020%2C515%2C521%2C522%2C531%2C535%2C536%2C523%2C532%2C540%2C1040%2C600%2C601%2C602%2C603%2C612%2C613%2C614%2C615%2C701&__checkbox_edicao.jornal=2%2C2000%2C529%2C525%2C604%2C605%2C606%2C607%2C702&edicao.jornal=3%2C3000%2C3020%2C1040%2C526%2C530%2C608%2C609%2C610%2C611&__checkbox_edicao.jornal=3%2C3000%2C3020%2C1040%2C526%2C530%2C608%2C609%2C610%2C611&edicao.dtInicio=10%2F01&edicao.dtFim=10%2F01&edicao.ano=2019';
        
        $url="http://pesquisa.in.gov.br/imprensa/core/jornalList.action"; 
        $ch = curl_init(); 
        curl_setopt ($ch, CURLOPT_URL, $url); 
        curl_setopt($ch, CURLOPT_AUTOREFERER, false);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $post);
        curl_setopt($ch, CURLOPT_REFERER, "http://pesquisa.in.gov.br/");
        curl_setopt($ch, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_1);
        curl_setopt($ch, CURLOPT_HEADER, 0);
        $curl_response = curl_exec ($ch); 
        //echo $result;  
        curl_close($ch);
        
        $dom = new DOMDocument;
        libxml_use_internal_errors(true);
		$dom->loadHTML(utf8_decode($curl_response));
        
        $table = $dom->getElementsByTagName("table");
        $result = $table->item(0);		

	    $trs = $result->getElementsByTagName("tr");
	    
	    for ( $i = 1; $i < $trs->length; $i++)
		{
	        $tr = $trs->item($i);
	        
    		$tds = $tr->getElementsByTagName("td");
    		$total = trim($tds->item(3)->nodeValue);
    		
    		$item = $tds->item(3)->childNodes->item(1)->attributes;
            
            $link = $item->item(2)->textContent;
    		
    		$this->trata_link($link);
		    
		}
	}*/
	
	private function trata_link($link)
	{
        $link = substr($link, 2, strlen($link));
	 
	    $url = "http://pesquisa.in.gov.br/imprensa".$link; 
	    
	    return $url;
	    
	}
	
	public function get_link($url)
	{
        $ch = curl_init(); 
        curl_setopt ($ch, CURLOPT_URL, $url); 
        curl_setopt($ch, CURLOPT_AUTOREFERER, false);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_REFERER, "http://pesquisa.in.gov.br/");
        curl_setopt($ch, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_1);
        curl_setopt($ch, CURLOPT_HEADER, 0);
        $result = curl_exec ($ch); 
        //echo $result;  
        curl_close($ch);
        
        // create new DOMDocument
        $dom = new \DOMDocument('1.0', 'UTF-8');
        
        // set error level
        $internalErrors = libxml_use_internal_errors(true);
        
        //$dom = new DOMDocument();
        $dom->validateOnParse = true; //<!-- this first
        $dom->loadHTML($result);        //'cause 'load' == 'parse
        
        $dom->preserveWhiteSpace = false;
        
        $belement = $dom->getElementById("plugin");
        //var_dump($belement->nodeValue);
        
        $x = new DOMXPath($dom); 
        $el = $x->query("//*[@name='visualizador']")->item(0);

	    $src = $el->getAttribute('src');
	    
	    $src = str_replace('../../','http://pesquisa.in.gov.br/imprensa/',$src);
	    
	    //var_dump($src); exit();
	    
	    $this->get_pdf($src);
	}
	
	public function get_pdf($host = null)
	{
	    $output_filename = 'read-pdf9.pdf'; //$name;

        //$host = "http://pesquisa.in.gov.br/imprensa/servlet/INPDFViewer?jornal=530&pagina=12&data=14/01/2019&captchafield=firstAccess";
        // $host = "http://pesquisa.in.gov.br/imprensa/servlet/INPDFViewer?jornal=530&pagina=14&data=14/01/2019&captchafield=firstAccess";
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $host);
        curl_setopt($ch, CURLOPT_VERBOSE, 1);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_AUTOREFERER, false);
        curl_setopt($ch, CURLOPT_REFERER, "http://pesquisa.in.gov.br/");
        curl_setopt($ch, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_1);
        curl_setopt($ch, CURLOPT_HEADER, 0);
        $result = curl_exec($ch);
        curl_close($ch);
        
        //var_dump($result); // prints the contents of the collected file before writing..
        
        
        // the following lines write the contents to a file in the same directory (provided permissions etc)
        $fp = fopen('../html/assets/uploads/dou/'.$output_filename, 'w');
        fwrite($fp, $result);
        fclose($fp);
        
        $this->read('../html/assets/uploads/dou/read-pdf9.pdf');
	}
	
	public function clean()
	{
    	$files = glob('../html/assets/uploads/dou/*'); // get all file names
        
        foreach($files as $file){ // iterate files
          if(is_file($file) && $file != '../html/assets/uploads/dou/read-pdf9.pdf')
            unlink($file); // delete file
        }
    }
}