<?php


class HCaptura
{
    static protected $elleven = [
        0 => ['Pre Cadastro',       ''],
        1 => ['Pre Cadastro',       ''],
        2 => ['Pre Cadastro',       ''],
        3 => ['Ativado',            'success'],
        4 => ['Cancelado',          'danger'],
        5 => ['Estilizar Projeto',  'primary'],
        6 => [6,                    ''],
        7 => [7,                    ''],
        8 => [8,                    ''],
        9 => [9,                    ''],
       10 => ['Não Tem Interesse',  'danger'],
        ];
        
    static protected $exclusive = [
        0 => ['Pre Cadastro',       ''],
        1 => ['Pre Cadastro',       ''],
        2 => ['Pre Cadastro',       ''],
        3 => ['Ativado',            'success'],
        4 => ['Cancelado',          'danger'],
        5 => ['Estilizar Projeto',  'warning'],
        6 => [6,                    ''],
        7 => [7,                    ''],
        8 => [8,                    ''],
        9 => [9,                    ''],
       10 => ['Não Tem Interesse',  'danger'],
        ];
    
    static protected $liberty = [
        0 => ['Pre Cadastro',       'warning'],
        1 => ['Pre Cadastro',       'warning'],
        2 => ['Pre Cadastro',       'warning'],
        3 => ['Ativado',            'success'],
        4 => ['Cancelado',          'danger'],
        5 => ['Estilizar Projeto',  'warning'],
        6 => [6,                    ''],
        7 => [7,                    ''],
        8 => [8,                    ''],
        9 => [9,                    ''],
       10 => ['Não Tem Interesse',  'danger'],
        ];
     
    static protected $signature = [
        0 => ['Pre Cadastro',       'warning'],
        1 => ['Pre Cadastro',       'warning'],
        2 => ['Pre Cadastro',       'warning'],
        3 => ['Ativado',            'success'],
        4 => ['Cancelado',          'danger'],
        5 => ['Estilizar Projeto',  'warning'],
        6 => [6,                    ''],
        7 => [7,                    ''],
        8 => [8,                    ''],
        9 => [9,                    ''],
       10 => ['Não Tem Interesse',  'danger'],
        ];
        
        
    static protected $empreendimento = [
        0 => ['Pre Cadastro',       'warning'],
        1 => ['Pre Cadastro',       'warning'],
        2 => ['Pre Cadastro',       'warning'],
        3 => ['Agendado',           'success'],
        4 => ['Cancelado',          'danger'],
        5 => [5,                    'warning'],
        6 => [6,                    ''],
        7 => [7,                    ''],
        8 => [8,                    ''],
        9 => [9,                    ''],
       10 => ['Não Tem Interesse',  'danger'],
        ];
        
    static protected $varStatus;
    static protected $varCaptura;
    
    static public function captura($captura = null)
    {
        self::$varCaptura = $captura;
        return new self();
    }
    
    static public function lp($nameArray)
    {
        self::$varStatus = self::$$nameArray??[];
        return new self();
    }
    
    static public function nameStatus($i = null)
    {
        if(self::$varCaptura != null)
            $i = self::$varCaptura->status_captura;
            
        $r = self::$varStatus[$i][0]??'undefined';
        self::reseta();      
        return $r;
    }
    
    static public function bgStatus($i = null)
    {
        if(self::$varCaptura != null)
            $i = self::$varCaptura->status_captura;
        
        $r = "<span class='badge badge-"  .(self::$varStatus[$i][1]??'').  "'>"   .(self::$varStatus[$i][0]??'undefined').  "</span>";
        self::reseta();   
        return $r;
    }
    
    static private function reseta()
    {
        self::$varCaptura = null;
        self::$varStatus  = [];
    }
    
    
}



class HAvaliacao
{
    static protected $bairrosPermitidos = [
            'Park Sul' => ['Park Sul'],
            'Asa Sul' => ['Asa Sul'],
            'Asa Norte' => ['Asa Norte'],
            'Lago Sul' => [
                'Lago Sul',
                'Setor Habitacional Jardim Botânico (Lago Sul)'
                ],
            'Lago Norte' => [
                'Lago Norte',
                'Setor de Mansões do Lago Norte',
                'Setor Habitacional Taquari (Lago Norte)',
                'Setor de Postos e Motéis Norte (Lago Norte)',
                ],
            'Sudoeste' => [
                'Sudoeste',
                'Setor Sudoeste'
                ],
            'Noroeste' => [
                'Noroeste',
                'Setor Noroeste'
                ],
            'Águas Claras' => [
                'Área de Desenvolvimento Econômico (Águas Claras)',
                'Areal (Águas Claras)',
                'Norte (Águas Claras)',
                'Setor Habitacional Arniqueira (Águas Claras)',
                'Sul (Águas Claras)',
                ],
            'Taguatinga' => [    
                'Vila São José (Taguatinga)',
                'Taguatinga Sul (Taguatinga)',
                'Taguatinga Norte (Taguatinga)',
                'Taguatinga Centro (Taguatinga)',
                'Setor Industrial (Taguatinga)',
                'Setor Habitacional Vicente Pires (Taguatinga)',
                'Setor Habitacional Vereda Grande (Taguatinga)',
                'Setor Habitacional Samambaia (Taguatinga)',
                'Setor de Desenvolvimento Econômico (Taguatinga)',
                ],
            'Ceilândia' => [
                'Setor Industrial (Ceilândia)',
                'Setor Habitacional Sol Nascente (Ceilândia)',
                'Setor Habitacional Pôr do Sol (Ceilândia)',
                'Setor de Materiais de Construção (Ceilândia)',
                'Condomínio Privê Lucena Roriz (Ceilândia)',
                'Ceilândia Sul (Ceilândia)',
                'Ceilândia Norte (Ceilândia)',
                'Ceilândia Centro (Ceilândia)',
                'Área de Desenvolvimento Econômico (Ceilândia)',
                ],
            'Guará' => [
                //'Vila Estrutural (Guará)',
                //'Setor Oeste (Vila Estrutural - Guará)',
                //'Setor Norte (Vila Estrutural - Guará)',
                //'Setor Leste (Vila Estrutural - Guará)',
                //'Setor Especial (Vila Estrutural - Guará)',
                //'Setor Central (Vila Estrutural - Guará)',
                'Quadras Econômicas Lúcio Costa (Guará)',
                'Guará II',
                'Guará I',
                ],
            'Samambaia' => [
                'Samambaia Sul (Samambaia)',
                'Samambaia Norte (Samambaia)',
                ],
            'Gama' => [
                'Setor Sul (Gama)',
                'Setor Oeste (Gama)',
                'Setor Norte (Gama)',
                'Setor Leste (Gama)',
                'Setor Industrial (Gama)',
                'Setor Central (Gama)',
                'Ponte Alta (Gama)',
                'Gama',
                'Cidade Nova (Gama)',
                ],
        ];
    
    //Bairros que na wimoveis estao como cidade
    static protected $bairroEmCidades = ['Águas Claras','Taguatinga','Ceilândia','Samambaia','Guará','Gama'];
    
    static public function getBairroPermitido($bairro)
    {
        foreach (self::$bairrosPermitidos as $keyBairro=>$arrayBairro)
            if(in_array($bairro,$arrayBairro))
                return $keyBairro;
        return false;
    }
    
    
    static public function getBairroEmCidades()
    {
        return self::$bairroEmCidades;
    }
}

class HBairros
{
    static protected $bairros = [
        'Águas Claras',
        'Asa Norte',
        'Asa Sul' ,
        'Brazlândia',
        'Candangolândia',
        'Ceilândia',
        'Cruzeiro',
        'Fercal',
        'Gama',
        'Guará',
        'Itapoã',
        'Jardim Botânico',
        'Lago Norte',
        'Lago Sul',
        'Núcleo Bandeirante',
        'Paranoá',
        'Park Way',
        'Park Sul',
        'Planaltina',
        'Recanto das Emas',
        'Riacho Fundo',
        'Riacho Fundo II',
        'Samambaia Norte',
        'Samambaia Sul',
        'Santa Maria',
        'São Sebastião',
        'SCIA',
        'SIA',
        'Sobradinho',
        'Sobradinho II',
        'Sudoeste/Octogonal',
        'Taguatinga',
        'Varjão',
        'Vicente Pires',
        ];

        static public function getSelect2()
        {
            $return = [];
            foreach (self::$bairros as $bairro)
            {
                $return[] = (object)['id' => $bairro, 'text' => $bairro];
            }
            return (object)['items' => $return];
        }
    
    
}

class HBusca
{
    static protected $selectTiposImovel = [
            "Apartamento" => [
                'Apartamento Padrão'    => 'Padrão',
                'Kitnet'                => 'Kitnet',
                'Studio'              => 'Studio',
                'Loft'                  => 'Loft',
                'Flat'                  => 'Flat',
                'Cobertura'             => 'Cobertura',
                'Duplex'                => 'Duplex',
                'Triplex'               => 'Triplex',
                ],
            "Casa" => [
                'Casa Padrão'          => 'Padrão',
                'Casa de Condomínio'   => 'Casa de Condomínio',
                'Casa de Vila'         => 'Casa de Vila',
                ],
            "Outros" => [
                'Comercial'            => 'Comercial',
                'Rural'                => 'Rural',
                'Terreno'              => 'Terreno',
                'Vaga de Garagem'      => 'Vaga de Garagem',
                ],
        ];
    
    static public function getSelectTiposImovel($tipos = [])
    {
        $selectTiposImovel = self::$selectTiposImovel;
        if (empty($tipos))
            return $selectTiposImovel;
        
        foreach ($selectTiposImovel as $key=>$subs)
        {
            foreach ($subs as $val=>$name)
            {
                if(!in_array($val, $tipos)){
                    unset($selectTiposImovel[$key][$val]);
                }
            }
            if(empty($selectTiposImovel[$key]))
                unset($selectTiposImovel[$key]);
        }
        return $selectTiposImovel;
    }
    
    static public function getHtmlSelectTiposImovel($tipos = [])
    {
        $data['tiposImovel'] = self::getSelectTiposImovel($tipos);
        Template::load_view('comdono/blocos/select_tipo_imovel', $data, '', '', $html);
        return $html;
    }
     
}

class HImg
{
    static public $noImg = 'themes/comdono/img/no-image.png';
    
    static public function alt($img)
    {
        e($img->alt??'');
    }
    
    static public function ref($img)
    {
        if($img != null)
            if(strpos($img->uri, 'http') === false) 
                e(base_url($img->uri.$img->imagem));
            else 
                e($img->uri.$img->imagem);
        else
            e(base_url(self::$noImg));
    }
    static public function thumb($img)
    {
        if($img != null)
            if(strpos($img->uri, 'http') === false)
                e(base_url($img->uri.'thumbnail/'.$img->imagem));
            else
                e($img->uri.'thumbnail/'.$img->imagem);
        else
            e(base_url(self::$noImg));
    }
    static public function med($img)
    {
        if($img != null)
            if(strpos($img->uri, 'http') === false)
                e(base_url($img->uri.'medium/'.$img->imagem));
            else
                e($img->uri.'medium/'.$img->imagem);
            
        else
            e(base_url(self::$noImg));
    }
    static public function desc($img)
    {
        e($img->descricao??'');
    }
    
    static public function noImg()
    {
        e(base_url($noImg));
    }
    
    /**
    * Separete images by category, order by position and set description
    *
    * @param array $imgs with all images togheter
    *
    * @return array
    */
    static public function galeriaPremium($imgs)
    {
        $data = array();
        foreach ($imgs as $img)
        {
            if(substr_count($img->descricao, ';') == 2)
            {
                $desc = explode(';',$img->descricao);
                
                $img->alt = $img->descricao = $desc[1];
                
                $data[$desc[0]][$desc[2]-1] = $img;
        
                ksort($data[$desc[0]]);
            }
            else
            {
                $data['Geral'][] = $img;
            }
        }
        $res = [];
        $cont = 0;
        foreach ($data as $cat=>$obj)
        {
           $res[$cont]['categoria'] = $cat;
           $res[$cont]['imagens'] = $obj;
           
           $cont++;
        }
        return $res;
    }
    
}

class HHipoteca
{
    static protected $statusHipoteca = [
            0 =>['text' =>'Disponivel','bg'=>'alert-success'],
            1 =>['text' =>'Aguardando análise','bg'=>'alert-primary'],
            2 =>['text' =>'Em análise','bg'=>'alert-warning'],
            3 =>['text' =>'Aprovado','bg'=>'alert-success'],
            4 =>['text' =>'Reprovado','bg'=>'alert-danger'],
        ];
    
    static public function getStatus($n)
    {
        return (object)(self::$statusHipoteca[$n]??['text' =>' - ','bg'=>'']);
    }
}

class HImovel
{
    //nome no EXCEL e nome no DB
    static protected $planilhaInportacao = [
                'Empreendimento'                       => "",                            
                'Unidade'                              => "unidade",                     
                'Anot. venda'                          => "",                            
                'Planta'                               => "",                            
                'Status'                               => "",                            
                'Equipe'                               => "",                            
                'Gerente'                              => "",                            
                'Corretor'                             => "",                            
                'Desconto Tab.'                        => "",                            
                'Área total'                           => "area_total",                            
                'Área privativa'                       => "area_privativa",              
                'Fração ideal'                         => "",                            
                'Quartos'                              => "quartos",                     
                'Vagas'                                => "",                            
                'Preço de venda'                       => "val_pretendido",                            
                'Valor m2'                             => "",                            
                'Data da venda / reserva'              => "",                            
                'Data do pedido'                       => "",                            
                'Taxa de decoração - Valor total'      => "",                            
                'Taxa de decoração - Parcelas'         => "",                            
                'Taxa de decoração - Início pagto'     => "",                            
                'Taxa de decoração - Início correção'  => "",                            
                'Data de recebimento'                  => "",                            
                'Venda confirmada?'                    => "",                            
                'Opção de planta'                      => "",                            
                'CNPJ'                                 => "dn_cpf_cnpj",                 
                'Nome Fantasia'                        => "dn_nome_nomefantasia",        
                'Razão Social'                         => "dn_razao_social",             
                'CEP'                                  => "cep",                         
                'Endereço'                             => "endereco",                    
                'Número'                               => "numero",                      
                'Complemento'                          => "complemento",                 
                'Cidade'                               => "cidade",                      
                'Bairro'                               => "bairro",                      
                'Estado'                               => "estado",                      
                'Tipo do Imóvel'                       => "tipo_imovel",                 
                'Previsão de Entrega'                  => "previsao_entrega",            
                'Imóvel Novo'                          => "imovel_novo",                 
                'Posição do Sol'                       => "posicao_sol",                 
                'Posição'                              => "imovel_canto",                
                'Andar '                               => "andar",                       
                'Suítes'                               => "suites",                      
                'Banheiros'                            => "banheiros",                   
                'Valor do Condomínio'                  => "val_condominio",              
                'Valor do IPTU'                        => "val_iptu",                    
                'Número da matrícula registrada'       => "num_matricula",               
                'Cobertura Privativa'                  => "cobertura_privativa",         
                'Ar Condicionado'                      => "ar_condicionado",             
                'Armários Planejados'                  => "armarios_planejados",         
                'Armários Embutidos no Quarto'         => "armarios_embutidos_quarto",   
                'Armários de Cozinha'                  => "armarios_cozinha",            
                'Armários no Banheiro'                 => "armarios_banheiro",           
                'Box Blindex'                          => "box_blindex",                 
                'Quarto de Serviço'                    => "quarto_servico",              
                'Quarto Extra Reversível'              => "quarto_extra_reversivel",     
                'Varanda Gourmet'                      => "varanda",                     
                'DCE'                                  => "dce",                         
                'Academia'                             => "academia",                    
                'Churrasqueira'                        => "churrasqueira",               
                'Elevador'                             => "elevador",                    
                'Espaço Gourmet'                       => "espaco_gourmet",              
                'Lavanderia'                           => "lavanderia",                  
                'Piscina'                              => "piscina",                     
                'Playground'                           => "playground",                  
                'Quadra esportiva'                     => "quadra_esportiva",            
                'Salão de Festas'                      => "salao_festa",                 
                'Sauna'                                => "sauna",                       
                'Cobertura'                            => "cobertura",                   
                'Estacionamento Rotativo'              => "estacionamento_rotativo",     
                'Wi-fi'                                => "wifi",                        
                'Descrição'                            => "caracteristicas",  
                'Inicio da Vigência'                   => "data_inicio_estoque",
                'Fim da Vigência'                      => "data_vencimento_estoque",
                'Tipo de Vaga'                         => "tipo_vaga",
        ];
        
    static protected $caposDate = [
        "data_inicio_estoque",
        "data_vencimento_estoque",
    ];
    static protected $caposCheckbox = [
        "cobertura_privativa",         
        "ar_condicionado",             
        "armarios_planejados",         
        "armarios_embutidos_quarto",   
        "armarios_cozinha",            
        "armarios_banheiro",           
        "box_blindex",                 
        "quarto_servico",              
        "quarto_extra_reversivel",     
        "varanda",                     
        "dce",                         
        "academia",                    
        "churrasqueira",               
        "elevador",                    
        "espaco_gourmet",              
        "lavanderia",                  
        "piscina",                     
        "playground",                  
        "quadra_esportiva",            
        "salao_festa",                 
        "sauna",                       
        "cobertura",                   
        "estacionamento_rotativo",     
        "wifi",
        ];
    
    static protected $tbPlanilha = [
                         1 => ["nameDB" => "",                            "name"=> "Empreendimento" ],
                         2 => ["nameDB" => "complemento",                 "name"=> "Unidade" ],
                         3 => ["nameDB" => "",                            "name"=> "Anot. venda" ],
                         4 => ["nameDB" => "",                            "name"=> "Planta" ],
                         5 => ["nameDB" => "",                            "name"=> "Status" ],
                         6 => ["nameDB" => "",                            "name"=> "Equipe" ],
                         7 => ["nameDB" => "",                            "name"=> "Gerente" ],
                         8 => ["nameDB" => "",                            "name"=> "Corretor" ],
                         9 => ["nameDB" => "",                            "name"=> "Desconto Tab." ],
                        10 => ["nameDB" => "",                            "name"=> "Área total" ],
                        11 => ["nameDB" => "area_privativa",              "name"=> "Área privativa" ],
                        12 => ["nameDB" => "",                            "name"=> "Fração ideal" ],
                        13 => ["nameDB" => "quartos",                     "name"=> "Quartos" ],
                        14 => ["nameDB" => "vaga",                        "name"=> "Vagas" ],
                        15 => ["nameDB" => "",                            "name"=> "Preço de venda" ],
                        16 => ["nameDB" => "",                            "name"=> "Valor m2" ],
                        17 => ["nameDB" => "",                            "name"=> "Data da venda / reserva" ],
                        18 => ["nameDB" => "",                            "name"=> "Data do pedido" ],
                        19 => ["nameDB" => "",                            "name"=> "Taxa de decoração - Valor total" ],
                        20 => ["nameDB" => "",                            "name"=> "Taxa de decoração - Parcelas" ],
                        21 => ["nameDB" => "",                            "name"=> "Taxa de decoração - Início pagto" ],
                        22 => ["nameDB" => "",                            "name"=> "Taxa de decoração - Início correção" ],
                        23 => ["nameDB" => "",                            "name"=> "Data de recebimento" ],
                        24 => ["nameDB" => "",                            "name"=> "Venda confirmada?" ],
                        25 => ["nameDB" => "",                            "name"=> "Opção de planta" ],
                        26 => ["nameDB" => "dn_cpf_cnpj",                 "name"=> "CNPJ" ],
                        27 => ["nameDB" => "dn_nome_nomefantasia",        "name"=> "Nome Fantasia" ],
                        28 => ["nameDB" => "dn_razao_social",             "name"=> "Razão Social" ],
                        29 => ["nameDB" => "cep",                         "name"=> "CEP" ],
                        30 => ["nameDB" => "endereco",                    "name"=> "Endereço" ],
                        31 => ["nameDB" => "numero",                      "name"=> "Número" ],
                        32 => ["nameDB" => "complemento",                 "name"=> "Complemento" ],
                        33 => ["nameDB" => "cidade",                      "name"=> "Cidade" ],
                        34 => ["nameDB" => "bairro",                      "name"=> "Bairro" ],
                        35 => ["nameDB" => "estado",                      "name"=> "Estado" ],
                        36 => ["nameDB" => "tipo_imovel",                 "name"=> "Tipo do Imóvel" ],
                        37 => ["nameDB" => "previsao_entrega",            "name"=> "Previsão de Entrega" ],
                        38 => ["nameDB" => "imovel_novo",                 "name"=> "Imóvel Novo" ],
                        39 => ["nameDB" => "posicao_sol",                 "name"=> "Posição do Sol" ],
                        40 => ["nameDB" => "imovel_canto",                "name"=> "Posição" ],
                        41 => ["nameDB" => "andar",                       "name"=> "Andar " ],
                        42 => ["nameDB" => "suites",                      "name"=> "Suítes" ],
                        43 => ["nameDB" => "banheiros",                   "name"=> "Banheiros" ],
                        44 => ["nameDB" => "val_condominio",              "name"=> "Valor do Condomínio" ],
                        45 => ["nameDB" => "val_iptu",                    "name"=> "Valor do IPTU" ],
                        46 => ["nameDB" => "num_matricula",               "name"=> "Número da matrícula registrada" ],
                        47 => ["nameDB" => "cobertura_privativa",         "name"=> "Cobertura Privativa" ],
                        48 => ["nameDB" => "ar_condicionado",             "name"=> "Ar Condicionado" ],
                        49 => ["nameDB" => "armarios_planejados",         "name"=> "Armários Planejados" ],
                        50 => ["nameDB" => "armarios_embutidos_quarto",   "name"=> "Armários Embutidos no Quarto" ],
                        51 => ["nameDB" => "armarios_cozinha",            "name"=> "Armários de Cozinha" ],
                        52 => ["nameDB" => "armarios_banheiro",           "name"=> "Armários no Banheiro" ],
                        53 => ["nameDB" => "box_blindex",                 "name"=> "Box Blindex" ],
                        54 => ["nameDB" => "quarto_servico",              "name"=> "Quarto de Serviço" ],
                        55 => ["nameDB" => "quarto_extra_reversivel",     "name"=> "Quarto Extra Reversível" ],
                        56 => ["nameDB" => "varanda",                     "name"=> "Varanda Gourmet" ],
                        57 => ["nameDB" => "dce",                         "name"=> "DCE" ],
                        58 => ["nameDB" => "academia",                    "name"=> "Academia" ],
                        59 => ["nameDB" => "churrasqueira",               "name"=> "Churrasqueira" ],
                        60 => ["nameDB" => "elevador",                    "name"=> "Elevador" ],
                        61 => ["nameDB" => "espaco_gourmet",              "name"=> "Espaço Gourmet" ],
                        62 => ["nameDB" => "lavanderia",                  "name"=> "Lavanderia" ],
                        63 => ["nameDB" => "piscina",                     "name"=> "Piscina" ],
                        64 => ["nameDB" => "playground",                  "name"=> "Playground" ],
                        65 => ["nameDB" => "quadra_esportiva",            "name"=> "Quadra esportiva" ],
                        66 => ["nameDB" => "salao_festa",                 "name"=> "Salão de Festas" ],
                        67 => ["nameDB" => "sauna",                       "name"=> "Sauna" ],
                        68 => ["nameDB" => "cobertura",                   "name"=> "Cobertura" ],
                        69 => ["nameDB" => "estacionamento_rotativo",     "name"=> "Estacionamento Rotativo" ],
                        70 => ["nameDB" => "wifi",                        "name"=> "Wi-fi" ],
                        71 => ["nameDB" => "caracteristicas",             "name"=> "Descrição" ],
                    ]; 
    static protected $icones = [
            //imovel
            'area_privativa' => ['ico'=>'imo-area_priv.png','name'=>'Área Privativa em m²:'],
            'area_total' => ['ico'=>'imo-area_total.png','name'=>'Área Total em m²:'],
            'posicao_sol' => ['ico'=>'imo-posicao_sol.png','name'=>'Posição do Sol:'],
            'andar' => ['ico'=>'imo-andar2.png','name'=>'Andar:'],
            'quartos' => ['ico'=>'imo-quartos.png','name'=>'Quarto(s):'],
            'suites' => ['ico'=>'imo-suites.png','name'=>'Suíte(s):'],
            'banheiros' => ['ico'=>'imo-banheiros.png','name'=>'Banheiro(s):'],
            'vaga' => ['ico'=>'imo-vagas.png','name'=>'Vagas:'],
            'cobertura_privativa' => ['ico'=>'imo-cobertura_privativa.png','name'=>'Cobertura Privativa'],
            'ar_condicionado' => ['ico'=>'imo-ar_condicionado.png','name'=>'Ar Condicionado'],
            'armarios_planejados' => ['ico'=>'imo-armarios_planejados.png','name'=>'Armários Planejados'],
            'armarios_embutidos_quarto' => ['ico'=>'imo-armarios_embutidos_quarto.png','name'=>'Armários Embutidos no Quarto'],
            'armarios_cozinha' => ['ico'=>'imo-armarios_cozinha.png','name'=>'Armários de Cozinha'],
            'armarios_banheiro' => ['ico'=>'imo-armarios_banheiro.png','name'=>'Armários no Banheiro'],
            'box_blindex' => ['ico'=>'imo-box_blindex.png','name'=>'Box Blindex'],
            'quarto_extra_reversivel' => ['ico'=>'imo-quarto_extra_reversivel.png','name'=>'Quarto Extra Reversível'],                                            
            'quarto_servico' => ['ico'=>'imo-quarto_servico.png','name'=>'Quarto de Serviço'],
            'varanda' => ['ico'=>'cond-espaco_gourmet.png','name'=>'Varanda Gourmet'],
            'dce' => ['ico'=>'imo-dce.png','name'=>'DCE'],
            //condominio
            'academia' => ['ico'=>'cond-academia.png','name'=>'Academia'],
            'churrasqueira' => ['ico'=>'cond-churrasqueira.png','name'=>'Churrasqueira'],
            'elevador' => ['ico'=>'cond-elevador.png','name'=>'Elevador'],
            'espaco_gourmet' => ['ico'=>'cond-espaco_gourmet.png','name'=>'Espaço Gourmet'],
            'lavanderia' => ['ico'=>'cond-lavanderia.png','name'=>'Lavanderia'],
            'piscina' => ['ico'=>'cond-piscina.png','name'=>'Piscina'],
            'playground' => ['ico'=>'cond-playground.png','name'=>'Playground'],
            'quadra_esportiva' => ['ico'=>'cond-quadra_esportiva.png','name'=>'Quadra esportiva'],
            'salao_festa' => ['ico'=>'cond-salao_festas.png','name'=>'Salão de Festas'],
            'sauna' => ['ico'=>'cond-sauna.png','name'=>'Sauna'],
            'cobertura' => ['ico'=>'cond-cobertura.png','name'=>'Cobertura'],
            'estacionamento_rotativo'=>['ico'=>'cond-estacionamento_rotativo.png','name'=>'Estacionamento Rotativo'],
            'wifi' => ['ico'=>'cond-wifi.png','name'=>'Wifi'],
            'porteiro_24h' => ['ico'=>'cond-porteiro_24h.png','name'=>'Porteiro 24h'],
            'acessibilidade' => ['ico'=>'cond-acessibilidade.png','name'=>'Acessibilidade'],
            ];
    static protected $detalhesImovel = [
            'area_privativa',
            'area_total',
            'posicao_sol',
            'andar',
            'quartos',
            'suites',
            'banheiros',
            'vaga',
            //'imovel_canto',
            'cobertura_privativa',
            'ar_condicionado',
            'armarios_planejados',
            'armarios_embutidos_quarto',
            'armarios_cozinha',
            'armarios_banheiro',
            'box_blindex',
            'quarto_extra_reversivel',                                            
            'quarto_servico',
            'varanda',
            'dce',
        ];
    static protected $detalhesCondominio = [
            'academia',
            'churrasqueira',
            'elevador',
            'espaco_gourmet',
            'lavanderia',
            'piscina',
            'playground',
            'quadra_esportiva',
            'salao_festa',
            'sauna',
            'cobertura',
            'estacionamento_rotativo',
            'wifi',
            'porteiro_24h',
            'acessibilidade',
        ];
    static protected $statusImovel = [
            0 =>['text' =>'Cadastro incompleto','bg'=>'alert-primary', 'bdg' => 'badge-secondary'],
            1 =>['text' =>'Cadastro incompleto','bg'=>'alert-primary', 'bdg' => 'badge-primary'],
            2 =>['text' =>'Aguardando moderação','bg'=>'alert-warning', 'bdg' => 'badge-warning'],
            3 =>['text' =>'Publicado','bg'=>'alert-success', 'bdg' => 'badge-success'],
            4 =>['text' =>'Bloqueado','bg'=>'alert-danger', 'bdg' => 'badge-danger'],
            5 =>['text' =>'nao definido','bg'=>'alert-secondary', 'bdg' => 'badge-secondary'],
            6 =>['text' =>'Vendido','bg'=>'alert-success', 'bdg' => 'badge-success'],
        ];
    static public function getStatus($n){
        return (object)(self::$statusImovel[$n]??['text' =>'Não encontrado','bg'=>'','bdg'=>'']);
    }
    static public function getDetalhesImovel($imovel, $res = true){
        $arrayResultado = ['Nascente','Poente','Neutra'];
        $arrayImovel = [];
        
        foreach ($imovel as $key=>$val){
            
            if(in_array($key,self::$detalhesImovel)){
                
                if(in_array($val,$arrayResultado))
                    $value = $val;
                else
                    $value = $val>0?$val:'';
                
                if($res){
                    if(!($val === '0' || $val == "")){
                        $arrayImovel[] = [
                            'name'=>$key,
                            'val'=>$value,
                            'ico'=>self::$icones[$key]['ico'],
                            'ico_name'=>self::$icones[$key]['name'],
                            ];
                    }
                }else
                {
                    $arrayImovel[] = [
                            'name'=>$key,
                            'val'=>(!($val === '0' || $val == ""))?$val:' - ',
                            'ico'=>self::$icones[$key]['ico'],
                            'ico_name'=>self::$icones[$key]['name'],
                            ];
                }
            }
        }
        return $arrayImovel;
    }
    static public function getDetalhesComdominio($imovel, $res = true){
        $arrayCondominio = [];
        foreach ($imovel as $key=>$val){
            if(in_array($key,self::$detalhesCondominio)){
                
                if($res){
                    if($val !== ""){
                        $arrayCondominio[]=[
                                'name'=>$key,
                                'val'=>$val,
                                'ico'=>self::$icones[$key]['ico'],
                                'ico_name'=>self::$icones[$key]['name'],
                            ];
                    }
                }
                else
                {
                    $arrayCondominio[]=[
                                'name'=>$key,
                                'val'=>($val !== "")?$val:' - ',
                                'ico'=>self::$icones[$key]['ico'],
                                'ico_name'=>self::$icones[$key]['name'],
                            ];
                }
                
            }
        }
        return $arrayCondominio;
    }
    /*SEO*/
    static public function montaTitulo($imovel){
        $quarto = ($imovel->quartos > 1 ? $imovel->quartos.' quartos': '1 quarto').' ';
        $tipo_imovel = (!isset($imovel->tipo_imovel)) ? "": $imovel->tipo_imovel;
        
        if($tipo_imovel == 'Apartamento Padrão')
            $tipo_imovel = 'Apartamento';
        if($tipo_imovel == 'Casa Padrão')
            $tipo_imovel = 'Casa';
            
        if(in_array($tipo_imovel, ['Comercial','Kitnet','Studio','Loft','Flat'])) 
            $quarto = '';
        
        //$nomeFantasia = '';
        //if($imovel->doc_perfil == 'cnpj')
        //    $nomeFantasia = $imovel->dn_nome_nomefantasia.' ';
        
        if($tipo_imovel == 'Comercial')   
            $tipo_imovel = 'sala '.$tipo_imovel;
            
            
        //return $tipo_imovel.' '.$nomeFantasia.$quarto.$imovel->bairro.' '.$imovel->cidade.' '.'df';    
        return $tipo_imovel.' '.$quarto.$imovel->bairro.' '.$imovel->cidade.' '.'df';    
        
        /*if($tipo_imovel == 'Comercial')
        
            return 'sala'.' '.$tipo_imovel.' '.$nomeFantasia.$imovel->bairro.' '.$imovel->cidade.' '.'df';
            
        elseif ($tipo_imovel == 'Kitnet' || $tipo_imovel == 'Studio' || $tipo_imovel == 'Loft' || $tipo_imovel == 'Flat')
        
            return $tipo_imovel.' '.$imovel->bairro.' '.$imovel->cidade.' '.'df';
            
        else
            return $tipo_imovel.' '.$quarto.' '.$imovel->bairro.' '.$imovel->cidade.' '.'df';*/
            
    }
    static public function tipo_imove_custom($tipo_imovel){
        
        if($tipo_imovel == 'Apartamento Padrão')
            $tipo_imovel = 'Apartamentos';
        
        if($tipo_imovel == 'Kitnet' || $tipo_imovel == 'Studio' || $tipo_imovel == 'Loft' || $tipo_imovel == 'Flat' || $tipo_imovel == 'Cobertura')
            $tipo_imovel = $tipo_imovel.'s';
        if($tipo_imovel == 'Casa Padrão')
            $tipo_imovel = 'Casas';
        if($tipo_imovel == 'Casa de Condomínio')
            $tipo_imovel = 'Casas de Condomínio';
        if($tipo_imovel == 'Casa de Vila')
            $tipo_imovel = 'Casas de Vila';
        if($tipo_imovel == 'Comercial')
            $tipo_imovel = 'Salas comerciais';
        
        return $tipo_imovel;
    }
    static public function montaKeyAnuncio($imovel){
        if(is_array($imovel))
            $imovel = (object)$imovel;
        return convertAccentsAndSpecialToNormal(strtolower(self::montaTitulo($imovel)));
    }
    static public function montaKeyLancamento($imovel){
        if(is_array($imovel))
            $imovel = (object)$imovel;
        return convertAccentsAndSpecialToNormal(strtolower($imovel->dn_nome_nomefantasia));
    }
    static public function nameDbPlanilha($i){
        return self::$tbPlanilha[$i]['nameDB'];
    }
    static public function getfieldDb($key){
        return self::$planilhaInportacao[$key]??'';
    }
    
    
    static public function getTbPlanilha(){
        return self::$tbPlanilha;
    }
    static public function getCamposDate(){
        return self::$caposDate;
    }
    static public function getCaposCheckbox(){
        return self::$caposCheckbox;
    }
    
    
    
}

class Excel extends  HImovel{
    
    private static $planilha; 
    //private static $modelo; 
    
    function __construct() 
    {
        //$this->CI =& get_instance();
        //self::$CIs =& get_instance();
        //self::$CIs->load->model('newsletter/newsletter_model');
    }
    
    
    public static function iniExcel($planilha)
    {
        self::$planilha = $planilha;
        return new static();
    }
    
    
    
}

class HNegociacoes
{
    static protected $step = [
        1 => "ETAPA 1: Alguém está interessado no seu imóvel. É hora de combinar a visita e usaremos o calendário, no topo da lateral direita da página, para marcar o melhor dia e horário para os dois.",
        2 => "ETAPA 2: A primeira etapa foi concluída, sinal de que a visita foi boa e gostaram do seu imóvel. Agora é a hora de acertar os detalhes da negociação, como valores e pagamento. Lembre-se que o COMDONO está à disposição para ajudar no que for preciso. Basta chamar. Vamos lá?",
        3 => "ETAPA 3: Com as informações da negociação fechadas, é hora de preencher o contrato padrão disponibilizado pelo COMDONO. Leia com atenção e faça os ajustes necessários antes da próxima etapa.",
        4 => "ETAPA 4: Este é um dos momentos mais importantes da negociação: é hora de agendar a ida ao cartório para assinar o contrato de compra e venda do imóvel. Lembre-se: todo imóvel deve ter escritura (com exceção dos lançamentos). Leve todos os documentos necessários para evitar remarcações e garantirem a segurança do negócio.",
        5 => "ETAPA 5: Parabéns! O negócio foi fechado e você conseguiu vender seu imóvel. Não se esqueça que a taxa COMDONO deve ser paga em até 15 dias após fechar a venda.",
        6 => "ETAPA 6: É hora de agendar a entrega das chaves e realizar a vistoria do imóvel. Usaremos o calendário, no topo da lateral direita da página, para marcar o melhor dia e horário para os dois. E não se esqueça de dar o aceite no termo abaixo.",
    ];
    
    static protected $step_comprador = [
        1 => "ETAPA 1: Você está interessado no imóvel e com vontade de conhecê-lo de perto, certo? Hora de agendar a visita com o proprietário. No topo da lateral direita da página tem um calendário. Vamos usá-lo para marcar o melhor dia e horário para os dois!",
        2 => "ETAPA 2: A primeira etapa foi concluída, sinal de que a visita foi boa e que o imóvel é o que você esperava. Agora é a hora de acertar os detalhes da negociação, como valores e pagamento. Lembre-se que o COMDONO está à disposição para ajudar no que for preciso. Basta chamar. Vamos lá?",
        3 => "ETAPA 3: Com as informações da negociação fechadas, é hora de preencher o contrato padrão disponibilizado pelo COMDONO. Leia com atenção e faça os ajustes necessários antes da próxima etapa.",
        4 => "ETAPA 4: Este é um dos momentos mais importantes da negociação: é hora de agendar a ida ao cartório para assinar o contrato de compra e venda do imóvel. Lembre-se: todo imóvel deve ter escritura (com exceção dos lançamentos). Leve todos os documentos necessários para evitar remarcações e garantirem a segurança do negócio.",
        5 => "ETAPA 5: Parabéns! O negócio foi fechado e você adquiriu um novo lar. E para comemorar com você, o COMDONO tem uma surpresa especial. Fique alerta que entraremos em contato!",
        6 => "ETAPA 6: É hora de agendar a entrega das chaves e realizar a vistoria do imóvel. Usaremos o calendário, no topo da lateral direita da página, para marcar o melhor dia e horário para os dois. E não se esqueça de dar o aceite no termo abaixo.",
    ];
    
    static public function textoNegociacoes($step,$tipo=false)
    {
        if($tipo){
            echo self::$step_comprador[$step];
        }else{
            echo self::$step[$step];
        }
    }
    
    static public function getImg($id_cadastro,$usuarios_chat)
    {
        $noImg = base_url("themes/comdono/img/no-img-perfil.png");
        
        $img_perfil = $usuarios_chat[$id_cadastro]->img_perfil??'';
        $img_perfil_uri = $usuarios_chat[$id_cadastro]->img_perfil_uri??'';
        
        
        $img = $id_cadastro??false?$img_perfil_uri.$img_perfil:$noImg;
        //$img = $id_cadastro??false?base_url("modules/anunciante/".$id_cadastro."/perfil/".$img_perfil):$noImg;
        
        return $img_perfil!='' ? $img : $noImg;
    } 
    
    
    static public function getDivMsg($msg,$usuarios_chat,$id_cadastro,$lado = null)
    {
        if($id_cadastro != null)
            $data['lado'] = $id_cadastro == $msg->id_cadastro ? 'right' : 'left';
         
        if($lado == 'right')
            $data['lado'] = 'right';
        if($lado == 'left')
            $data['lado'] = 'left';
            
        $data['msg'] = $msg;
        $data['usuarios_chat'] = $usuarios_chat;
        
        $data['src'] = self::getImg($msg->id_cadastro,$usuarios_chat);
        
        Template::load_view('minha_conta/div/div_msg_chat', $data, '', '', $html);
        return $html;
    } 
    
    static public function getDivAceitaChat($chat,$usuarios_chat, $imv = [])
    {
        $data['chat'] = $chat;
        $data['imv'] = $imv;
        $data['usuarios_chat'] = $usuarios_chat;
        Template::load_view('minha_conta/div/div_aceita_chat', $data, '', '', $html);
        return $html;
    }
    
    static public function getPerfil($id_cadastro,$usuarios_chat)
    {
        
        $perfil = $usuarios_chat[$id_cadastro]??[];
        
        if($perfil->data_nascimento != "")
            $perfil->idade = self::calc_idade($perfil->data_nascimento);
        else
            $perfil->idade = "";
        
        return $perfil;
        
    }
    
    static public function calc_idade($data_nasc) {

        $data_nasc=explode('/',$data_nasc);
        
        $data=date('d/m/Y');
        
        $data=explode('/',$data);
        
        $anos=$data[2]-$data_nasc[2];
        
        if($data_nasc[1] > $data[1])
            return $anos-1;
        
        if($data_nasc[1] == $data[1]){
            if($data_nasc[0] <= $data[0]) {
                return $anos;
            }
            else{
                return $anos-1;
            }
        }
        
        if ($data_nasc[1] < $data[1])
            return $anos;
    }
    
    static public function firstName($id_cadastro,$usuarios_chat)
    {
        return $usuarios_chat[$id_cadastro]->nome??false ?explode(" ", $usuarios_chat[$id_cadastro]->nome)[0]:'';
    }
    
}

class HProposta
{
    static protected $taxasTipo = [
                'Apartamento Padrão'    => 7.3,
                'Kitnet/Studio'         => 7.3,
                'Kitnet'                => 7.3,
                'Studio'                => 7.3,
                'Loft'                  => 7.3,
                'Flat'                  => 7.3,
                'Cobertura'             => 7.3,
                'Duplex'                => 7.3,
                'Triplex'               => 7.3,
                'Casa Padrão'           => 7.3,
                'Casa de Condomínio'    => 7.3,
                'Casa de Vila'          => 7.3,
                'Comercial'             => 7.3,
                'Rural'                 => 7.3,
                'Terreno'               => 7.3,
                'Vaga de Garagem'       => 7.3,
        ];
        
    /*static protected $status = [
        0 => ['text' => 'Aguardando análise',    'class' => 'color-warning'   ,'bg'=>'alert-warning'], 
        1 => ['text' => 'Em análise',            'class' => 'color-warning'   ,'bg'=>'alert-warning'], 
        2 => ['text' => 'Aprovada'  ,            'class' => 'color-success'   ,'bg'=>'alert-success'], 
        3 => ['text' => 'Negada'    ,            'class' => 'color-danger'    ,'bg'=>'alert-danger' ], 
        ];*/
    
    static protected $status = [
        0 => ['text' => 'Em andamento', 'class' => 'color-warning'   ,'bg'=>'alert-warning'], 
        1 => ['text' => 'Enviado',      'class' => 'color-success'   ,'bg'=>'alert-success']
        ];
        
    static public function textStatus($n)
    {
        echo self::$status[$n]['text'];
    }
    
    static public function classStatus($n)
    {
        echo self::$status[$n]['class'];
    }
    
    static public function getStatus($n)
    {
        return (object)(self::$status[$n]??['text' =>'Não encontrado','class'=>'','bg'=>'']);
    }
    
    static public function taxaTipo($n)
    {
        return (self::$taxasTipo[$n])??0;
    }
}

class HValorPretendido
{
        
    static public function exibe($valor)
    {
        $decimais = false;
        
        $val = 'R$ '.number_format($valor, 2, ',', '.');
        
        if($decimais == true)
            e($val);
        else
            e(substr($val, 0, -3).",00");
    }
}

class HValorFormat
{
        
    static public function exibe($valor)
    {
        $decimais = false;
        
        $val = 'R$ '.number_format($valor, 2, ',', '.');
        
        if($decimais == true)
            e($val);
        else
            e(substr($val, 0, -3).",00");
    }
}

class HDataPorExtenso
{
        
    static public function exibe($tipo, $data)
    {
        setlocale(LC_TIME, 'pt_BR', 'pt_BR.utf-8', 'pt_BR.utf-8', 'portuguese');
        date_default_timezone_set('America/Sao_Paulo');
        
        $return = '';
        if($tipo == 1){
            $return = strftime("Brasília, %d de %B de %Y", strtotime($data));
            strftime('%A, %d de %B de %Y', strtotime('today'));
        }else{
            $return = strftime("%A, %d de %B de %Y", strtotime($data));
        }
        
        return $return;
    }
}

/*class HDataNascimento
{
    static public function updateData($data)
    {
        $data_nasc = explode('/',$data);
        
        $data_nasc = $data_nasc[2]."-".$data_nasc[1]."-".$data_nasc[0];
        
        return $data_nasc;
    }
}*/

class HData
{
    static protected $meses = [
        'January' => 'Janeiro',
        'February' => 'Fevereiro',
        'March' => 'Março',
        'April' => 'Abril',
        'May' => 'Maio',
        'June' => 'Junho',
        'July' => 'Julho',
        'August' => 'Agosto',
        'September' => 'Setembro',
        'October' => 'Outubro',
        'November' => 'Novembro',
        'December' => 'Dezembro'
    ];
    
    static protected $dias_da_semana = [
        'Sunday' => 'Domingo',
        'Monday' => 'Segunda-feira',
        'Tuesday' => 'Terça-feira',
        'Wednesday' => 'Quarta-feira',
        'Thursday' => 'Quinta-feira',
        'Friday' => 'Sexta-feira',
        'Saturday' => 'Sábado'
    ];
    
    static public function mes($mes)
    {
        return self::$meses[$mes]??'';
    }
    
    static public function dia($dia)
    {
        return self::$dias_da_semana[$dia]??'';
    }
    
    static public function extenso($data)
    {
        $diaSemana   = utf8_encode(strftime('%A',strtotime($data)));
        $diaNumero   = utf8_encode(strftime('%d',strtotime($data)));
        $mes         = utf8_encode(strftime('%B',strtotime($data)));
        $ano         = utf8_encode(strftime('%Y',strtotime($data)));
        
        $str = (self::$dias_da_semana[$diaSemana]??'').', '.$diaNumero.' de '.(self::$meses[$mes]??'').' de '.$ano;
        
        return $str;
    }
    
    static public function bsb($data)
    {
        $bsb         = "Brasília";
        $diaNumero   = utf8_encode(strftime('%d',strtotime($data)));
        $mes         = utf8_encode(strftime('%B',strtotime($data)));
        $ano         = utf8_encode(strftime('%Y',strtotime($data)));
        
        $str = ($bsb).', '.$diaNumero.' de '.(self::$meses[$mes]??'').' de '.$ano;
        
        return $str;
    }
    
    static public function extenso_blog($data)
    {
        
        $diaNumero   = utf8_encode(strftime('%d',strtotime($data)));
        $mes         = utf8_encode(strftime('%B',strtotime($data)));
        $ano         = utf8_encode(strftime('%Y',strtotime($data)));
        
        $str = $diaNumero.' '.(self::$meses[$mes]??'').' '.$ano;
        
        return $str;
    }
    
    static public function converteData($data)
    {
        $data = explode('/',$data);
        
        $data = $data[2]."-".$data[1]."-".$data[0];
        
        return $data;
    }
}

class HEmail
{
    private static $newsletter;
    
    static protected $emailsAlerta = [
            //'ramon.marques@viewbrasil.com.br',
            //'ricardo.luis@viewbrasil.com.br',
            //'filipe@viewbrasil.com.br',
            'comprei@comdono.com',
            'flavio@fxparticipacoes.com',
            'ola@comdono.com'
        ];
    static protected $teste_emailsAlerta = [
        'ramon.marques@viewbrasil.com.br',
        'ricardo.luis@viewbrasil.com.br',
    ];  
        
    static protected $dev_emailsAlerta = [
        //'filipe@viewbrasil.com.br',
        'ramon.marques@viewbrasil.com.br',
        'ricardo.luis@viewbrasil.com.br',
    ];
        
    static public function htmlArray($array)
    {
        $html = "<ul>";
        $remove = ['cpf'];
        foreach ($array as $key => $row)
        {
            if(!in_array($key,$remove))
                $html .= "<li><b>$key</b>: $row</li>";
        }
        $html .= "</ul>";
        return $html;
    }
        
    static public function alertaTeste($titulo, $msg)
    {
        if(is_array($msg))
            $msg = self::htmlArray($msg);
        
        self::$newsletter =& get_instance()->newsletter;
        $data = [
                'mensagem'    =>$msg,
                'campanha'    =>$titulo,
                'subject'     =>$titulo.' - '.date("d-m-Y-H-i-s"),
               ];
        
        self::$newsletter->envia('ramon.marques@viewbrasil.com.br', 1, $data);
    }
    
    static public function alerta_custom($titulo, $msg, $emails)
    {
        self::$emailsAlerta = $emails;
        
        self::alerta($titulo, $msg);
    }
        
    static public function alerta($titulo, $msg)
    {
        if(getenv('BASE_URL') == "https://comdono.com/"){
            $emailsAlerta = self::$emailsAlerta;
        }
        elseif(getenv('BASE_URL') == "https://dev.comdono.com/")
        {
            $emailsAlerta = self::$dev_emailsAlerta;
            $titulo = 'DEV.'.$titulo;
        }
        else
        {
            $emailsAlerta = self::$teste_emailsAlerta;
            $titulo = 'TESTE.'.$titulo;
        }
        
        if(is_array($msg))
            $msg = self::htmlArray($msg);
        
        self::$newsletter =& get_instance()->newsletter;
        foreach ($emailsAlerta as $email)
        {
           $data = [
                'mensagem'    =>$msg,
                'campanha'    =>$titulo,
                'subject'     =>$titulo.' - '.date("d-m-Y"),
               ];
               
            //var_dump($email, 1, $data);
            
            self::$newsletter->envia($email, 1, $data);
       }
        
    }
}