<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Cad_model extends CI_Model
{
    
    public static $db;
    public static $CI;
    private static $admins = [1,2,3,4,203];
    private static $perfisAdmins = [1,2];
    
    static protected $model = null;
    
    static function cad_model()
    {
        self::$model = new Cad_model(); 
        return self::$model; 
    }
    
    
    
    function __construct() {
        
        parent::__construct();
        self::$db = &get_instance()->db;
        self::$CI = &get_instance();
        
        $this->load->helper('simple_crypt');
        
    }
    
    
    
    
    //COMFING GERAL
    static $camposCadastro = [
    	    //'id_cadastro',
    	    'nome', 'telefone', 'email', 'cpf','rg','orgao_exp','nacionalidade','estado_civil', 'data_nascimento', 'profissao', 'img_perfil_uri', 'img_perfil', 'end_cep','end_endereco','end_numero','end_complemento','end_bairro','end_cidade','end_estado', 'vendedor', 'comprador','incorporadora', 'termo_uso', 'etapa', 'tipo_contato', 'bd_comdono', 'agendamento', 'melhor_dia', 'melhor_hora', 'qnt_imovel', 'email_activated', 'celular_activated', 'aviso_curtir', 'img_pj', 'img_pj_uri', 'cnpj', 'nome_fantasia', 'descricao_pj','facebook','instagram','data_hora_cadastro','timestamp_cadastro'
        ];
    static $camposUser = [
    	    //'id',
            'id_cadastro',
            'perfil',
            'username',
            'nome',
            'password',
            'email',
            'activated',
            'banned',
            'ban_reason',
            'new_password_key',
            'new_password_requested',
            'new_email',
            'new_email_key',
            'google_secret_key',
            'last_ip',
            'last_login',
            'acessos_sistema',
            'created',
            'modified',
            'activation_key',
        ];
    static $camposImg = [
            'id_img', 'id_img_rel', 'id_cadastro', 'id_imovel', 'uri', 'imagem', 'alt', 'size', 'descricao', 'priority'
        ];
    static $camposSimulacao = [
        'id_simulacao', 'id_imovel', 'id_cad_dono', 'id_cad_interessado', 'status', 'step', 'val_imovel', 'val_entrada', 'val_parcelas', 'val_total', 'meses_financiado', 'taxa', 'tipo_pessoa', 'cpf', 'cnpj', 'servidor_publico', 'imovel_cidade', 'data_nascimento', 'renda_familiar', 'recaptcha', 'comprador_dependente', 'possui_fgts', 'valor_fgts', 'data_simulacao', 'bairro', 'origem_financiamento', 'email_propostas', 'historico_email'
        
        ];
    static $camposImovel = [
            'id_imovel',
            'id_imovel_rel',
            'id_cadastro',
            'contrato_prestacao',
            'key_anuncio',
            'unidade',
            'id_localizacao',
            'step',
            'status',
            'status_lancamento',
            'tipo_empreendimento',
            'lixeira',
            'status_hipoteca',
            'doc_perfil',
            'dados_perfil',
            'dn_nome_nomefantasia',
            'dn_razao_social',
            'dn_telefone',
            'dn_email',
            'dn_cpf_cnpj',
            'dn_img',
            'dn_img_uri',
            'tipo_imovel',
            'lancamento',
            'previsao_entrega',
            'data_lancamento',
            'imovel_novo',
            'importar_planilha',
            'cep',
            'endereco',
            'numero',
            'complemento',
            'bairro',
            'cidade',
            'estado',
            'area_privativa',
            'area_total',
            'longitude',
            'latitude',
            'bairro_lat',
            'bairro_long',
            'quadra_lat',
            'quadra_long',
            'conjunto_lat',
            'conjunto_long',
            'quartos',
            'suites',
            'banheiros',
            'andar',
            'vaga',
            'posicao_sol',
            'num_matricula',
            'chk_termo',
            'imovel_canto',
            'doc_propriedade',
            'doc_planilha',
            'cobertura_privativa',
            'armarios_planejados',
            'armarios_cozinha',
            'box_blindex',
            'quarto_extra_reversivel',
            'ar_condicionado',
            'armarios_embutidos_quarto',
            'armarios_banheiro',
            'quarto_servico',
            'varanda',
            'dce',
            'caracteristicas',
            'academia',
            'elevador',
            'lavanderia',
            'playground',
            'salao_festa',
            'churrasqueira',
            'espaco_gourmet',
            'piscina',
            'quadra_esportiva',
            'sauna',
            'cobertura',
            'estacionamento_rotativo',
            'wifi',
            'porteiro_24h',
            'acessibilidade',
            'val_pretendido',
            'val_public_total',
            'val_public_total_metro',
            'val_condominio',
            'val_iptu',
            'fotos_profissionais',
            'melhor_horario',
            'tour_virtual',
            'visualizacoes',
            'data_hora_imovel',
            'timestamp_imovel'
        ];
    static $camposChat = [
            'id_chat',
            'id_imovel',
            'id_dono',
            'id_interessado',
            'id_cartorio',
            'etapa',
            'chat_status',
            'opcao_recusado'
        ];
    static $campoMsg = [
        'id_msg',
        'id_chat',
        'id_cadastro',
        'tipo',
        'mensagem',
        'lido',
        'dt_msg',
        'dt_lido',
        'status_msg',
        ];
    static $camposBanco = [
        'id_banco', 'banco', 'status_banco', 'logo_ativa', 'logo_inativa', 'entrada_min', 'entrada_max', 'meses_min', 'meses_max'
        ];
    static $camposBancoRelSimulacao = [
        'id_bc_rel', 'id_banco', 'id_simulacao', 'id_cadastro', 'banco_chec', 'agencia', 'conta', 'primeira_parcela', 'ultima_parcela', 'prazo_total', 'valor_total', 'taxa_efetiva', 'cet', 'contatado', 'file_url', 'status_bcrel'
        ];
    static $camposContato = [
            'nome',
            'email',
            'telefone',
            'assunto',
            'mensagem',
            'data_hora'
        ];
    static $camposProposta = [
            'id_proposta', 
            'incorporadora', 
            'logo', 
            'responsavel', 
            'login', 
            'senha', 
            'status', 
            'data_hora_atualizacao', 
            'data_cadastro', 
            'acessos',
            'ultimo_acesso'
        ];
    static $camposPropostaHistorico = [
           'id_hist_proposta',
           'id_proposta',
           'status',
           'data_hora_atualizacao',
           'id_cadastro'
        ];
        
    // monta Para setar no banco ----------------------------------------
    static function montaCadastro($post)    {
        return self::criaArray(self::$camposCadastro,$post);
    }
    static function montaUser($post)    {
        return self::criaArray(self::$camposUser,$post);
    }
    static function montaSimulacao($post)    {
        return self::criaArray(self::$camposSimulacao,$post);
    }
    static function montaBancoRelSimulacao($post)    {
        return self::criaArray(self::$camposBancoRelSimulacao,$post);
    }
    static function montaImovel($post)    {
        $camposImovel = self::$camposImovel;
        unset($camposImovel[0]);
        return self::criaArray($camposImovel,$post);
    }
    static function montaContato($post)    {
        return self::criaArray(self::$camposContato,$post);
    }
    static function montaImg($post)    {
        return self::criaArray(self::$camposImg,$post);
    }
    static function montaProposta($post)    {
        return self::criaArray(self::$camposProposta,$post);
    }
    static function montaPropostaRelHistorico($post)    {
        return self::criaArray(self::$camposPropostaHistorico,$post);
    }
    // mGet para pegar do bando----------------------------------------
    static function mGetImagem($post)    {
        return self::criaObject(self::$camposImg,$post);
    }
    static function mGetImovel($row)    {
       //return self::criaObject(self::$camposImovel,$post);
       return self::cad_model()->getFields('cad_imovel',$row);
    }
    static function mGetChat($post)    {
        $obj = self::criaObject(self::$camposChat,$post);
        $to = array_merge([$obj->id_dono,$obj->id_interessado,$obj->id_cartorio], self::$admins);
        $obj->sessid = simple_crypt( json_encode(['to'=>$to]), 'e' );
        return $obj;
    }
    static function mGetMsg($post)    {
        return self::criaObject(self::$campoMsg,$post);
    }
    static function mGetSimulacao($post)    {
        return self::criaObject(self::$camposSimulacao,$post);
    }
    static function mGetBancoRelSimulacao($post)    {
        return self::criaObject(array_merge(self::$camposBancoRelSimulacao, self::$camposBanco),$post);
    }
    static function mGetProposta($post)    {
        return self::criaObject(self::$camposProposta,$post);
    }
    static function mGetPropostaRelHistorico($post)    {
        return self::criaObject(array_merge(self::$camposPropostaHistorico, self::$camposProposta),$post);
    }
    // ---------------------------------------------------------------------
	static function criaArray($arrayCampos,$post)	{
	    $res = [];
        foreach ($arrayCampos as $key)
        {
            if(isset($post[$key]))
                $res[$key] = trim($post[$key]);
        }
        return $res;
	}
	static function criaObject($arrayCampos,$post)	{
	    $res = [];
        foreach ($arrayCampos as $key)
        {
            if(isset($post->$key))
                $res[$key] = trim($post->$key);
        }
        return (object)$res;
	}
	
	//---------- A G E N D A ---------------------------
        //---G E T----------------
            function getAgenda($where = []){
            return $this->getRow('age_agenda', $where);
    	}
            function getAgendas($where = []){
            $this->db->order_by('data_hora_agendamento','asc');
            return $this->getResult('age_agenda', $where);
    	}
        //---I N S E R T----------
            public function insertAgenda($data){
            return $this->insert('age_agenda', $data);
        }
        //---U P D A T E----------
            public function updateAgenda($id_agenda, $post){
            $this->db->where('id_agenda', $id_agenda);
            return $this->update('age_agenda', $post);
        }
    //---FIM---- A G E N D A ---------------------------
    
    
    //---------- I N C O R P O R A C A O ---------------------------
        //---G E T--------------
            function getSumValoresImovel($where = []){
                $this->db->select('SUM(val_pretendido) as valor');
        	    return $this->getRow('cad_imovel as a', $where);
        	}
            function getSumValoresMidia($where = []){
                $this->db->select('midia, SUM(valor) as valor');
                $this->db->group_by('midia');
        	    return $this->getResult('inc_investimento_midias', $where);
        	}
            function getIncorporadora($where = []){
        	    return $this->getRow('inc_incorporadora', $where);
        	}
        	
        	function getIncorporadoraByMembro($where = []){
        	    
        	    $this->db->join('inc_membros', 'inc_membros.id_incorporadora = inc_incorporadora.id_incorporadora');
        	    return $this->getRow('inc_incorporadora', $where);
        	}
        	
            function getEmpreendimento($where = []){
        	    return $this->getRow('inc_empreendimento', $where);
        	}
        	function getEmpreendimentos($where = []){
        	    return $this->getResult('inc_empreendimento', $where);
        	}
        	function getLpConfig($where = []){
        	    return $this->getRow('lp_config', $where);
        	}
        	function getInvestimentos($where = []){
        	    return $this->getResult('inc_investimento_midias', $where);
        	}
        	function getDiferenciais($where = []){
        	    return $this->getResult('lp_diferenciais', $where);
        	}
        	function getUnidades($where = []){
        	    return $this->getResult('lp_unidades', $where);
        	}
        	function getComodidades($where = []){
        	    return $this->getResult('lp_comodidades', $where);
        	}
        	function getPlano($where = []){
        	    return $this->getRow('inc_planos', $where);
        	}
        	function getPlanos($where = []){
        	    return $this->getResult('inc_planos', $where);
        	}
        	function getProposta($where = []){
        	    return $this->getRow('inc_propostas', $where);
        	}
        	function getPropostas($where = []){
        	    return $this->getResult('inc_propostas', $where);
            }
            function getMembros($where = []){
                $this->db->join('cad_cadastro', 'cad_cadastro.id_cadastro = inc_membros.id_cadastro');
        	    return $this->getResult('inc_membros', $where);
            }
        //---I N S E R T--------------
            public function insertEmpreendimento($data){
                return $this->insert('inc_empreendimento', $data);
            }
            public function insertConfigLp($data){
                return $this->insert('lp_config', $data);
            }
            public function insertInvestimento($data){
                return $this->insert('inc_investimento_midias', $data);
            }
            public function insertUnidade($data){
                return $this->insert('lp_unidades', $data);
            }
            public function insertDiferencial($data){
                return $this->insert('lp_diferenciais', $data);
            }
            public function insertComodidade($data){
                return $this->insert('lp_comodidades', $data);
            }
            public function insertMembro($data){
                
                $data['id_empreendimentos'] = is_array($data['id_empreendimentos'])? json_encode($data['id_empreendimentos']):$data['id_empreendimentos'];
                return $this->insert('inc_membros', $data);
            }
        //---U P D A T E----------------
            public function updateIncorporadora($id_incorporadora, $data){
                $this->db->where('id_incorporadora', $id_incorporadora);
                return $this->update('inc_incorporadora', $data);
            }
            public function updateEmpreendimento($id_empreendimento, $data){
                $this->db->where('id_empreendimento', $id_empreendimento);
                return $this->update('inc_empreendimento', $data);
            }
            public function updateConfigLp($id_config, $post){
                $this->db->where('id_config', $id_config);
                return $this->update('lp_config', $post);
            }
            public function updateInvestimento($id_empreendimento, $post){
                $this->db->where('id_empreendimento', $id_empreendimento);
                return $this->update('inc_investimento_midias', $post);
            }
            public function updateUnidade($id_unidade, $post){
                $this->db->where('id_unidade', $id_unidade);
                return $this->update('lp_unidades', $post);
            }
            public function updateDiferencial($id_diferencial, $post){
                $this->db->where('id_diferencial', $id_diferencial);
                return $this->update('lp_diferenciais', $post);
            }
            public function updateComodidade($id_comodidade, $post){
                $this->db->where('id_comodidade', $id_comodidade);
                return $this->update('lp_comodidades', $post);
            }
    //---FIM---- I N C O R P O R A C A O ---------------------------
    
	
	
	// TESTE NOTIFICATION------------------------------------------------------
	    
    function getNotifications()
	{
	    $this->db->where('id_cadastro', $this->session->id_cadastro);
	    $this->db->where('ntf_status <', 2);
	    
	    
	    $query = $this->db->get('ntf_notificacao');
	    if ($query->num_rows() > 0)
			return $query->result();
		return [];
	}
    function insertNotification($data)
	{
	    $this->db->insert('ntf_notificacao', $data);
	    return  $this->db->insert_id();
	}
    function updateNotification($arrayWhere,$data)
	{
	    foreach ($arrayWhere as $key=>$val)
	        $this->db->where($key, $val);
	    
	    
	    return $this->db->update('ntf_notificacao', $data);
	}
    
	// TESTE------------------------------------------------------
	
	// G E T -----------------------------------------------------
	
	function getContatos($where = []){
	    return $this->getResult('cad_contato', $where);
	}
	
	//static
	
	
	static function idAdmin($id)
	{
	    $r = false;     
	    if(in_array($id,self::$admins))
	        $r = true;
	    return $r;
	}
	static function perfilAdmin($id)
	{
	    $r = false;     
	    if(in_array($id,self::$perfisAdmins))
	        $r = true;
	    return $r;
	    
	}
	static function _getCadastro($arrayWhere = [])
	{
	    foreach ($arrayWhere as $key=>$val)
	        self::$db->where($key, $val);
	    $query = self::$db->get('cad_cadastro');
	    if ($query->num_rows() > 0)
			return $query->row();
		return [];
	}
	static function getCadastroByEmail($email, $diferente = null)
	{
	    if($diferente != null)
	        self::$db->where('id_cadastro !=', $diferente);
	    
	    
	    self::$db->where('LOWER(email)=', strtolower($email));
	    $query = self::$db->get('cad_cadastro');
	    if ($query->num_rows() > 0)
			return $query->row();
		return [];
	}
	static function getSysUserByEmail($email)
	{
	    self::$db->where('LOWER(email)=', strtolower($email));
	    $query = self::$db->get('sys_users');
	    if ($query->num_rows() > 0)
			return $query->row();
		return null;
	}
	//no static
	function getSelectBusca() 
    {
    
        $this->db->select('bairro, cidade, estado, COUNT(*) as qnt_bairro');
        $this->db->where('bairro !=', '');
        
        $this->db->where('status', 3);
        $this->db->where('lixeira', 0);
        //$this->db->where('lixeira <', 2);
        $this->db->group_by('bairro'); 
        //$this->db->order_by('qnt_bairro', 'desc'); 
        $query = $this->db->get('cad_imovel');
        
        if ($query->num_rows()) {
            $result = $query->result();
            $select = [];
            
            return $result;
        }
        return [];
    }
    function get_cadastro($arrayWhere = [], $id_cadastro = null) 
    {
        if($id_cadastro === null)
            $id_cadastro = $this->session->id_cadastro;
        
        if($id_cadastro !== false)
            $this->db->where('id_cadastro', $id_cadastro);
            
	    foreach ($arrayWhere as $key=>$val)
	        $this->db->where($key, $val);
	        
	    $query = $this->db->get('cad_cadastro');
	    if ($query->num_rows() > 0)
			return $query->row();
		return null;
	}
	function get_user_cad()
	{
        $id_cadastro = $this->session->id_cadastro;
        $this->db->where('id_cadastro', $id_cadastro);
            
	    $query = $this->db->get('sys_users');
	    if ($query->num_rows() > 0)
			return $query->row();
		return null;
	}
	function getCadUsers($where = [])
	{
	    //$this->db->select('*, b.nome as nome');
	    $this->where($where, []);
	    $this->db->join('cad_cadastro as b', 'b.id_cadastro = a.id_cadastro');
	    $query = $this->db->get('sys_users as a');
	    if ($query->num_rows() > 0)
			return $query->result();
		return [];
	}
	function getImovel($arrayWhere = []) 
    {
        foreach ($arrayWhere as $key=>$val)
	        $this->db->where($key, $val);
    
            //$this->db->join('cad_localizacao', 'cad_localizacao.id_localizacao = cad_imovel.id_localizacao','left');
            //$this->db->join('cad_img', 'cad_img.id_imovel = cad_imovel.id_imovel','left');
        
        $query = $this->db->get('cad_imovel');
        
        if ($query->num_rows()) return $query->row();
        return null;
    }
    function getImgsImovel($id_imovel) 
    {
        $this->db->where('id_imovel', $id_imovel);
        $this->db->order_by('priority'); 
        $query = $this->db->get('cad_img');
        
        if ($query->num_rows()) return $query->result();
        return [];
    }
    function getImovelCad($arrayWhere = [], $id_cadastro = null) 
    {
        if($id_cadastro == null)
            $id_cadastro = $this->session->id_cadastro;
        
        $this->db->where('cad_imovel.id_cadastro', $id_cadastro);
        
        foreach ($arrayWhere as $key=>$val)
	        $this->db->where($key, $val);
        
        //$this->db->join('cad_localizacao', 'cad_localizacao.id_localizacao = cad_imovel.id_localizacao','left');
        //$this->db->join('cad_img', 'cad_img.id_imovel = cad_imovel.id_imovel','left');
        
        $query = $this->db->get('cad_imovel');
        
        if ($query->num_rows()) return $query->row();
        return null;
    }
	function getImoveis($arrayWhere = []) 
    {
        foreach ($arrayWhere as $key=>$val)
	        $this->db->where($key, $val);
        
        $query = $this->db->get('cad_imovel');
        
        if ($query->num_rows() > 0) 
            return $query->result();
        return [];
    }
    function getImoveisImg($where = [], $or_where = []) 
    {
        $this->db->select('*, a.id_imovel as id_imovel, a.id_cadastro as id_cadastro');
        
        foreach ($where as $key=>$val)
            $this->db->where($key, $val);
        foreach ($or_where as $key=>$val)
            $this->db->or_where($key, $val);
            
        $this->db->join('cad_img as b', 'b.id_imovel = a.id_imovel','left');
        $query = $this->db->get('cad_imovel as a');
        if ($query->num_rows() > 0)
        {
            $result = $query->result();
            $imoveis = [];
            $imagens = [];
            foreach($result as $obj)
            {
                $id = $obj->id_imovel;
                $imoveis[$id] = self::mGetImovel($obj);
                if( $obj->id_img == '')
                    $imagens[$id] = [];
                else 
                     $imagens[$id][] = self::mGetImagem($obj);
                
                $imoveis[$id]->imagens = $imagens[$id];
            }
            return $imoveis;
        }
        return [];
    }
    function getSimulacaoFinanciamento($where = [])
    {
        foreach ($where as $key=>$val)
            $this->db->where($key, $val);
        
        $this->db->select('*, a.id_simulacao as id_simulacao');
        $this->db->join('fnc_banco_rel_simulacao as b', 'b.id_simulacao = a.id_simulacao','left');
        $this->db->join('fnc_bancos as c', 'c.id_banco = b.id_banco','left');
        
        $query = $this->db->get('fnc_simulacao as a');
        
        if ($query->num_rows() > 0)
        {
            $result = $query->result();
            
            $simulacao = [];
            $bancos = [];
            foreach($result as $obj)
            {
                $id = $obj->id_simulacao;
                $simulacao = self::mGetSimulacao($obj);
                
                if( $obj->id_banco == '')
                    $bancos[$id] = [];
                else 
                     $bancos[$id][] = self::mGetBancoRelSimulacao($obj);
                
                $simulacao->bancos = $bancos[$id];
            }
            return $simulacao;
        }
        return null;
    }
    function getSimulacoesFinanciamento($where = [])
    {
        foreach ($where as $key=>$val)
            $this->db->where($key, $val);
        
        $this->db->select('*, a.id_simulacao as id_simulacao');
        $this->db->join('fnc_banco_rel_simulacao as b', 'b.id_simulacao = a.id_simulacao','left');
        $this->db->join('fnc_bancos as c', 'c.id_banco = b.id_banco','left');
        
        
        $query = $this->db->get('fnc_simulacao as a');
        
        if ($query->num_rows() > 0)
        {
            $result = $query->result();
            
            $simulacao = [];
            $bancos = [];
            foreach($result as $obj)
            {
                $id = $obj->id_simulacao;
                $simulacao[$id] = self::mGetSimulacao($obj);
                
                if( $obj->id_banco == '')
                    $bancos[$id] = [];
                else 
                     $bancos[$id][] = self::mGetBancoRelSimulacao($obj);
                
                $simulacao[$id]->bancos = $bancos[$id];
            }
            return $simulacao;
        }
        return[];
    }
    function getBancoFinanciamento($where= [])
    {
        foreach ($where as $key=>$val)
            $this->db->where($key, $val);
        
        $query = $this->db->get('fnc_bancos');
        if ($query->num_rows() > 0)
            return $query->row();
        return null;
    }
    function getBancosFinanciamento($where = [])
    {
        foreach ($where as $key=>$val)
            $this->db->where($key, $val);
        
        $query = $this->db->get('fnc_bancos');
        if ($query->num_rows() > 0)
            return $query->result();
        return[];
        
    }
    function getEndereco($cep)
    {
        $this->db->where('l.cep', $cep);
        
        $this->db->join('cep_bairro as b', 'b.id_bairro = l.id_bairro');
        $this->db->join('cep_cidade as c', 'c.id_cidade = l.id_cidade');
        $this->db->join('cep_bairro_geo as d', 'b.id_bairro = d.id_bairro', 'left');
        
        
        $query = $this->db->get('cep_log as l');
        
        if ($query->num_rows() > 0)
            return $query->row();
        return null;
    }
    function countImovesStatus($id_cadastro = true)
    {
        $this->db->select("COUNT(*) as cont, status");
        
        if($id_cadastro)
            $this->db->where('id_cadastro', $this->session->id_cadastro);
        $this->db->group_by('status');
        $query = $this->db->get('cad_imovel');
        if ($query->num_rows() > 0)
        {
            $return = [];
            $total = 0;
            foreach($query->result() as $obj){
                $return[$obj->status] = $obj;
                $return[$obj->status]->total = $total += $obj->cont;
            }
            return $return;
        }
        return[];
    }
    function countNegocDono()
    {
        $this->db->select("COUNT(*) as cont, chat_status");
        $this->db->where('id_dono', $this->session->id_cadastro);
        $this->db->group_by('chat_status');
        $query = $this->db->get('ngc_chat');
        if ($query->num_rows() > 0)
        {
            $return = [];
            foreach($query->result() as $obj)
                $return[$obj->chat_status] = $obj;
            return $return;
        }
        return[];
    }
    function countNegocInteressado()
    {
        $this->db->select("COUNT(*) as cont, chat_status");
        $this->db->where('id_interessado', $this->session->id_cadastro);
        $this->db->group_by('chat_status');
        $query = $this->db->get('ngc_chat');
        if ($query->num_rows() > 0)
        {
            $return = [];
            foreach($query->result() as $obj)
                $return[$obj->chat_status] = $obj;
            return $return;
        }
        return[];
    }
    function getNegocDono()
    {
        
        $this->db->where('id_dono', $this->session->id_cadastro);
        $this->db->where('chat_status < ', 4);
        $query = $this->db->get('ngc_chat');
        if ($query->num_rows() > 0)
            return $query->result();
        return[];
    }
    function getNegocInteressado()
    {
        $this->db->where('id_interessado', $this->session->id_cadastro);
        $this->db->where('chat_status < ', 4);
        $query = $this->db->get('ngc_chat');
        if ($query->num_rows() > 0)
            return $query->result();
        return[];
    }
	function countPropostasDono()
    {
        $this->db->select("COUNT(*) as cont, status");
        $this->db->where('id_cad_dono', $this->session->id_cadastro);
        $this->db->group_by('status');
        $query = $this->db->get('fnc_simulacao');
        if ($query->num_rows() > 0)
        {
            $return = [];
            foreach($query->result() as $obj)
                $return[$obj->status] = $obj;
            return $return;
        }
        return[];
    }
    function countPropostasInteressado()
    {
        $this->db->select("COUNT(*) as cont, status");
        $this->db->where('id_cad_interessado', $this->session->id_cadastro);
        $this->db->group_by('status');
        $query = $this->db->get('fnc_simulacao');
        if ($query->num_rows() > 0)
        {
            $return = [];
            foreach($query->result() as $obj)
                $return[$obj->status] = $obj;
            return $return;
        }
        return[];
    }
	function countFavoritos()
    {
        $this->db->select("COUNT(*) as cont");
        $this->db->where('id_cadastro', $this->session->id_cadastro);
        $this->db->group_by('id_cadastro');
        $query = $this->db->get('cad_favoritos');
        if ($query->num_rows() > 0)
            return $query->result();
        return[];
    }
    function getNegoviacoesImovel($id_imovel)
    {
        $this->db->where('id_imovel', $id_imovel);
        $query = $this->db->get('ngc_chat');
        if ($query->num_rows() > 0)
            return $query->result();
        return[];
    }
    function getNegoviacoes($where)
    {
        $this->where($where);
        $query = $this->db->get('ngc_chat');
        if ($query->num_rows() > 0)
            return $query->result();
        return[];
    }
    function getFavoritos($where)
    {
        $this->where($where);
        $query = $this->db->get('cad_favoritos');
        if ($query->num_rows() > 0)
            return $query->result();
        return[];
    }
    function getSimulacoes($where)
    {
        $this->where($where);
        $query = $this->db->get('fnc_simulacao');
        if ($query->num_rows() > 0)
            return $query->result();
        return[];
    }
	function getBracoDireito($id_cad_principal)
	{
	    $this->db->where('id_cad_principal', $id_cad_principal);
	    $this->db->join('cad_cadastro', 'cad_cadastro.id_cadastro = cad_rel_braco.id_cad_braco');
        $query = $this->db->get('cad_rel_braco');
        if ($query->num_rows() > 0)
            return $query->row();
        return NULL;
	}
	function getVendFinanciamento($id_simulacao)
	{
	    $this->db->where('id_simulacao', $id_simulacao);
	    $this->db->join('cad_cadastro', 'cad_cadastro.id_cadastro = fnc_simulacao.id_cad_dono');
        $query = $this->db->get('fnc_simulacao');
        if ($query->num_rows() > 0)
            return $query->row();
        return NULL;
	}
	function getImoveCadastro($id_imovel)
	{
	    $this->db->where('id_imovel', $id_imovel);
	    $this->db->join('cad_imovel', 'cad_imovel.id_cadastro = cad_cadastro.id_cadastro');
        $query = $this->db->get('cad_cadastro');
        if ($query->num_rows() > 0)
            return $query->row();
        return NULL;
	}
	function getGeoBairro($where = [])
	{
	    $this->db->select('*, b.id_bairro as id_bairro');
	    $this->where($where,[]);
	    
        $this->db->join('cep_bairro_geo as a', 'a.id_bairro = b.id_bairro', 'left');
	    
	    
	    $query = $this->db->get('cep_bairro as b');
        if ($query->num_rows() > 0)
            return $query->row();
        return null;
	}
	//NEWSLETTER
	function getEmail($where)
	{
	    $this->where($where,[]);
	    
	    $query = $this->db->get('nwl_emails');
        if ($query->num_rows() > 0)
            return $query->row();
        return null;
	}
	function insertEmail($data)
	{
	    $this->db->insert('nwl_emails', $data);
	    return  $this->db->insert_id();
	}
    function getViewLancamento($where)
    {
        if(empty($where))
            return null;
            
        $this->where($where,[]);
	    
	    $query = $this->db->get('cad_view_lancamento');
        if ($query->num_rows() > 0)
            return $query->row();
        return null;
    }
    //INTENCAO
    function setIntencaoBusca($data)
	{
	    $this->db->insert('cad_intencao_busca', $data);
	    return  $this->db->insert_id();
	}
    function getIntencoesBusca($where = [])
	{
	    $this->where($where,[]);
	    
	    $query = $this->db->get('cad_intencao_busca as a');
        if ($query->num_rows() > 0)
            return $query->result();
        return [];
	}
    //CAPTURA
    function getCaptura($where = [])
	{
	    $this->where($where,[]);
	    $query = $this->db->get('cad_captura');
        if ($query->num_rows() > 0)
            return $query->row();
        return null;
	}
	function getCapturas($where = [])
	{
	    $this->where($where,[]);
	    $query = $this->db->get('cad_captura');
        if ($query->num_rows() > 0)
            return $query->result();
        return [];
	}
	function getCadastro($where = [])
	{
	    $this->where($where);
	    $query = $this->db->get('cad_cadastro');
	    if ($query->num_rows() > 0)
			return $query->row();
		return null;
	}
	function getCadastros($where = [])
	{
	    $this->where($where,[]);
	    $query = $this->db->get('cad_cadastro');
        if ($query->num_rows() > 0)
            return $query->result();
        return [];
	}
	function getAtendimento($where = [])
	{
	    $this->where($where,[]);
	    
	    $query = $this->db->get('cad_atendimento as a');
        if ($query->num_rows() > 0)
            return $query->result();
        return [];
	}
	function setAtendimento($data)
	{
	    return $this->insert('cad_atendimento', $data);
	}
	function setAtendimentoHistorico($data)
	{
	    return $this->insert('cad_atendimento_historico', $data);
	}
	function updateAtendimento($id,$data)
	{
	    $this->db->where('id_atendimento', $id);
	    return $this->update('cad_atendimento', $data);
	}
	function updateAtendimentoHistorico($id, $data)
	{
	    $this->db->where('id_hist_atend', $id);
	    return $this->update('cad_atendimento_historico', $data);
	}
	function getAtendimentoHistorico($where = [])
	{
	    $this->where($where,[]);
	      
	    $this->db->join('cad_atendimento_historico as b', 'a.id_atendimento = b.id_atendimento'); 
	    $this->db->order_by('data_hora', 'desc');
	    $query = $this->db->get('cad_atendimento as a');
        if ($query->num_rows() > 0)
            return $query->result();
        return [];
	}
	// CAPTURA ORIGEM------------------------------------------------------
    function insertCapturaOrigem($data)
	{
	    $this->db->insert('cad_captura_origem', $data);
	    return  $this->db->insert_id();
	}
	// I N S E R T  ------------------------------------------------------
	//static
	static function setCadUser($data)
	{
	    $cadastro = self::montaCadastro($data);
	    self::$db->insert('cad_cadastro', $cadastro);
	    $data['id_cadastro'] = self::$db->insert_id();
	    
	    $user = self::montaUser($data);
	    self::$db->insert('sys_users', $user);
	    $data['id_user'] = self::$db->insert_id();
	    
	    return ['id_cadastro' => $data['id_cadastro'], 'id_user' =>$data['id_user']];
	}
	//no static
	function insertCadastro($data)
	{
	    return $this->insert('cad_cadastro', $data);
	}
    function insertImovel($data)
	{
	    $data = self::montaImovel($data);
	    $this->db->insert('cad_imovel', $data);
	    return  $this->db->insert_id();
	}
	function insertUser($data)
	{
	    return $this->insert('sys_users', $data);
	}
	function insertRelBraco($data)
	{
	    $this->db->insert('cad_rel_braco', $data);
	    return  $this->db->insert_id();
	}
	function insertSimulacao($data)
	{
	    $this->db->insert('fnc_simulacao', $data);
	    return  $this->db->insert_id();
	}
	function insertHistoricoSimulacao($data)
	{
	    $this->db->insert('fnc_historico_simulacao', $data);
	    return  $this->db->insert_id();
	}
	function insertBancoRelSimulacao($data)
	{
	    $this->db->insert('fnc_banco_rel_simulacao', $data);
	    return  $this->db->insert_id();
	}
	function insertContato($data)
	{
	    $data = self::montaContato($data);
	    $this->db->insert('cad_contato', $data);
	    return  $this->db->insert_id();
	}
	function insertGeoBairro($data)
	{
	    $this->db->insert('cep_bairro_geo', $data);
	    return  $this->db->insert_id();
	}
	//CAPTURA
	function insertCaptura($data)
	{
	    //$data = self::montaCaptura($data);
	    if(!isset($data['id_cadastro'])  ||  !($data['id_cadastro'] > 0) )
	    {
	        if(isset($data['email'])){
    	        $cadastro = self::getCadastroByEmail($data['email']);
    	        if(empty($cadastro))
                    $data['id_cadastro'] = $this->cad_model->insertCadastro($data);
                else
                    $data['id_cadastro'] = $cadastro->id_cadastro;
	        }
	    }
	    
	    $this->db->insert('cad_captura', $data);
	    return  $this->db->insert_id();
	}
   // U P D A T E ------------------------------------------------------
   //static
	static function updateCadUser($id_cadastro, $data)
	{
	    $cadastro = self::montaCadastro($data);
	    self::$db->where('id_cadastro', $id_cadastro);
	    $r1 = self::$db->update('cad_cadastro', $cadastro);
	    
	    $user = self::montaUser($data);
	    self::$db->where('id_cadastro', $id_cadastro);
	    $r2 = self::$db->update('sys_users', $user);
	    
	    if($r1 && $r2)
	        return true;
	    return false;
	}
	static function updateUser($id_cadastro, $data)
	{
	    $user = self::montaUser($data);
	    self::$db->where('id_cadastro', $id_cadastro);
	    return self::$db->update('sys_users', $user);
	}
    function updateImovel($id,$data)
	{
	    /*$data = self::montaImovel($data);

	    $this->db->where('id_imovel', $id);	
	    return $this->db->update('cad_imovel', $data);*/
	    
	    
	    //$data = self::montaImovel($data);
	    
	    $this->db->where('id_imovel', $id);
	    return $this->update('cad_imovel', $data);
	    
	}
	function updateImoveis($where,$data)
	{
	   if(!empty($where))
	   {
	       $data = self::montaImovel($data);
    	   $this->where($where,[]);
    	   return $this->db->update('cad_imovel', $data);
	   }
	   return false;
	}
	function updateImovelRel($id_imovel_rel,$data)
	{
	    $data = self::montaImovel($data);
	    $this->db->where('id_imovel_rel', $id_imovel_rel);
	    return $this->db->update('cad_imovel', $data);
	    
	}
	function updateCadastro($id,$data)
	{
	    $this->db->where('id_cadastro', $id);
	    return $this->update('cad_cadastro', $data);
	    
	}
    public function update_galeria($data)
    {
        $data['id_cadastro'] = $this->session->id_cadastro;
        $data = self::montaImg($data);
        if($this->db->insert('cad_img', $data)){
            return $this->db->insert_id();
        }
        return false;
    }
    function update_image_galery($data)
	{
	    $this->db->where('id_cadastro', $this->session->id_cadastro);
        $this->db->where('imagem', $data['imagem']);
	    return $this->db->update('cad_img', $data);
	}
    function update_galery_by_id($data)
	{
	    $this->db->where('id_cadastro', $this->session->id_cadastro);
	    $this->db->where('id_img', $data['id_img']);
	    unset($data['id_img']);
	    return $this->db->update('cad_img', $data);
	}
	function update_galery_rel_by_id($data)
	{
	    $this->db->where('id_cadastro', $this->session->id_cadastro);
	    $this->db->where('id_img_rel', $data['id_img']);
	    unset($data['id_img']);
	    return $this->db->update('cad_img', $data);
	}
	function updateSimulacao($id,$data)
	{
	    $data = self::montaSimulacao($data);
	    $this->db->where('id_simulacao', $id);
	    return $this->db->update('fnc_simulacao', $data);
	    	}
    function updateBancoRelSimulacao($id,$data)
	{
	    $data = self::montaBancoRelSimulacao($data);
	    $this->db->where('id_bc_rel', $id);
	    return $this->db->update('fnc_banco_rel_simulacao', $data);
	}
    function updateCaptura($id,$data)
	{
	    $this->db->where('id_captura', $id);
	    return $this->update('cad_captura', $data);
	}
    // D E L E T E ------------------------------------------------------
    public function delete_galeria($imgName)
    {
        $this->db->where('id_cadastro', $this->session->id_cadastro);
        $this->db->where('imagem', $imgName);
        if($this->db->delete('cad_img'))
        {
            if($this->db->affected_rows() > 0)
            {
                return true;    
            }
        }
        return false;
    }
    public function delete_galeria_admin($imgName, $id_imovel)
    {
        $this->db->where('id_imovel', $id_imovel);
        $this->db->where('imagem', $imgName);
        if($this->db->delete('cad_img'))
        {
            if($this->db->affected_rows() > 0)
            {
                return true;    
            }
        }
        return false;
    }
    function deleteImovel($id_imovel)
	{
	    $this->db->where('id_imovel', $id_imovel);
	    return $this->db->delete('cad_imovel');
	}
    function deleteImovelRel($id_imovel_rel)
	{
	    $this->db->where('id_imovel_rel', $id_imovel_rel);
	    return $this->db->delete('cad_imovel');
	}
	function deleteBancoRelSimulacao($id_simulacao)
	{
        $this->db->where('id_simulacao',$id_simulacao);
	    if ($this->db->delete('fnc_banco_rel_simulacao'))
			return true;
		else
			return FALSE;
	}
	function deleteBracoRel($id_cad_principal)
	{
        $this->db->where('id_cad_principal',$id_cad_principal);
	    if ($this->db->delete('cad_rel_braco'))
			return true;
		else
			return FALSE;
	}
    // CURTIR FAVORITOS
    function insert_curtir($dados) 
    {
		if ($this->db->insert ('cad_favoritos', $dados))
			return $this->db->insert_id();
		else
			return FALSE;
	}
	function select_curtir($id_cadastro, $id_imovel)
    {
        $this->db->where('id_cadastro',$id_cadastro);
        $this->db->where('id_imovel',$id_imovel);
	    $query = $this->db->get('cad_favoritos');
	    if ($query->num_rows() > 0)
	       return $query->row();
	    return NULL;
    }
    function delete_curtir($id_cadastro, $id_imovel)
    {
        $this->db->where('id_cadastro',$id_cadastro);
        $this->db->where('id_imovel',$id_imovel);
	    if ($this->db->delete('cad_favoritos'))
			return true;
		else
			return FALSE;
	    
    }
    // PUSH ALERT FUNCTIONS
    function get_push_key($id_cadastro)
    {
        $this->db->select('push_alertjson'); 
        $this->db->where('id_cadastro', $id_cadastro);
        
        $query = $this->db->get('cad_cadastro');
        
        if($query->num_rows() > 0){
            return $query->row()->push_alertjson;
        }else{
            return NULL;
        }
    }
    function insere_push_key($id_cadastro, $json)
    {
        
        $this->db->set('push_alertjson', $json);
        $this->db->where('id_cadastro', $id_cadastro);
        
        return  $this->db->update('cad_cadastro');
        
    }
    
    function get_push($tag){
        
        $this->db->where('tag_push', $tag);
        
        $query = $this->db->get('mkt_push_alerts');
        
        if($query->num_rows() > 0){
            return $query->row();
        }else{
            return NULL;
        }
    }
    
    //PROPOSTAS
	function insertPropostaHistorico($dados)
	{
		if ($this->db->insert ('cad_proposta_historico', $dados))
			return $this->db->insert_id();
		else
			return FALSE;
	}
    function updateProposta($id,$data)
	{
	    $data = self::montaProposta($data);
	    $this->db->where('id_proposta', $id);
	    return $this->db->update('cad_proposta', $data);
	    
	}
    //############  funcoes suporte ##########
    

    
    //----------M O D E L---------------------------
	//----------M O D E L---------------------------
	//----------M O D E L---------------------------
	//----------M O D E L---------------------------
	function getResult($tb, $where = []){
        $this->where($where);
        $query = $this->db->get($tb);
        
        if ($query->num_rows() > 0) 
            return $query->result();
        return [];
    }
    function getRow($tb, $where = []){
        $this->where($where);
        $query = $this->db->get($tb);
        
        if ($query->num_rows() > 0) 
            return $query->row();
        return null;
    }
    function insert($tb, $data){
        //$data = self::criaArray($this->db->list_fields($tb),$data);
        $data = $this->getFieldsNotPrimaryKey($tb,$data);
        if($this->db->insert($tb, $data))
            return $this->db->insert_id();
        return false;
    }
    function update($tb,  $data){
        //$data = self::criaArray($this->db->list_fields($tb),$data);
        $data = $this->getFieldsNotPrimaryKey($tb,$data);
        
        foreach ($data as $field=>$value)
        {
            if(is_array($value) || is_object($value)){
                $stringSet = '';
                foreach ($value as $keyJson => $valJson){
                    if(is_array($valJson) || is_object($valJson)){
                        //$stringSet .= ",'$.$keyJson' ,".json_encode($valJson);//$this->db->set($field, "JSON_SET(`$field` ,'$.$keyJson' ,".json_encode($valJson).")", FALSE);
                        $stringSet .= ",'$.".$keyJson."' ,JSON_ARRAY(".implode(",", $valJson).")";//$this->db->set($field, "JSON_SET(`$field` ,'$.$keyJson' ,".json_encode($valJson).")", FALSE);
                    }else{
                        $stringSet .= ",'$.$keyJson' ,$valJson";//$this->db->set($field, "JSON_SET(`$field` ,'$.$keyJson' ,$valJson)", FALSE);
                    }
                }
                $this->db->set($field, "JSON_SET(`$field` $stringSet)", FALSE);
            }else{
                $this->db->set($field, $value);
            }
        }
        
        return $this->db->update($tb);
    }
    function getPrimaryKey($tb){
        foreach ($this->db->field_data($tb) as $field)
        {
            if($field->primary_key)
               return $field->name;
        }
    }
    function getFieldsNotPrimaryKey($tb,$data, $object = false){
        $campos = [];
        foreach ($this->db->field_data($tb) as $field){
            
            if($object)
                $data = (array)$data;
            
             if($field->primary_key == 0 && isset($data[$field->name])) 
               $campos[$field->name] = $data[$field->name];
        }
        if($object)       
            return (object)$campos;
        return $campos;
    }
    function getFields($tb,$data, $object = true){
        $campos = [];
        foreach ($this->db->field_data($tb) as $field){
            
            if($object)
                $data = (array)$data;
            
             if(isset($data[$field->name])) 
               $campos[$field->name] = $data[$field->name];
        }
        if($object)       
            return (object)$campos;
        return $campos;
    }
    function order_by($order_by){
        foreach($order_by as $key=>$dado)
        {
            $this->db->order_by($key, $dado);
        }
    }
    function like($like, $or_like){
        $this->roda_like($like);
        $this->roda_or_like($or_like);
    }
    function roda_like($like){
        foreach($like as $dado)
        {
            $this->db->like($dado[0], $dado[1]);
        }
    }
    function roda_or_like($like){
       if(!empty($like))
        {
            $this->db->group_start();
            foreach($like as $dado)
            {
                $this->db->or_like($dado[0], $dado[1]);
            }
            $this->db->group_end();
        }
    }
    function where($where, $or_where = []){
        $this->roda_where($where);
        
        $this->roda_or_where($or_where);
    }
    function roda_where($where){
        foreach($where as $ky=>$dado)
        {
            if(is_array($dado[0]))
            {
                $this->db->group_start();
                foreach($dado as $dado_n)
                {
                    if(is_array($dado_n[0]))
                    {
                        $this->db->or_group_start();
                        foreach($dado_n as $dado_y)
                        {
                            $this->db->where($dado_y[0], $dado_y[1]);
                        }
                        $this->db->group_end();
                    }
                    else
                    {
                        $this->db->or_where($dado_n[0], $dado_n[1]);
                    }
                }
                $this->db->group_end();
            }
            else
            {
                if(is_array($dado))
                    $this->db->where($dado[0], $dado[1]);
                else
                    $this->db->where($where[0], $where[1]);
            }
        }
    }
    function roda_or_where($where){
       if(!empty($where))
        {
            $this->db->group_start();
            foreach($where as $dado)
            {
                $this->db->or_where($dado[0], $dado[1]);
            }
            $this->db->group_end();
        }
    }
    //----------M O D E L---------------------------
    //----------M O D E L---------------------------
    //----------M O D E L---------------------------
    //----------M O D E L---------------------------
    
    
    
    
    
}