<div class="row bg-white">
    <div class="col-lg-12">
        <div class="container-page-financiamento">
            <div class="container-v-align-cad-imovel">
                <div class="no-v-align">
                    <div class="row d-flex justify-content-center">
                        <div class="col-lg-9 container-financiamento mt-60 mb-60">
                            <div class="content-body">
                                <form id="form-financ" action="" method="post" enctype="multipart/form-data">
                                    <div class="container-etapas-passas">
                                        <div class="row">
                                            <div class="col-lg-5">
                                                <div class="container-info">
                                                    <div class="content-title">
                                                        <h2>Simulação de<span>financiamento</span></h2>
                                                    </div>
                                                    <p>Nesta simulação, o COMDONO te ajudará a conseguir a melhor condição para adquirir seu novo lar. Iremos apresentar as propostas das instituições financeiras credenciadas para encontrar a proposta que melhor se adequa ao seu orçamento.</p>
                                                    <p><strong>Obs.: O valor de juros é uma média realizada entre os bancos parceiros.</strong></p>
                                    			    <p>Todas as informações com asterisco (*) são obrigatórias.</p>
                                                </div> 
                                                <input id="id_imovel" type="hidden" name="id_imovel" class="form-control" value="<?php e($imovel->id_imovel); ?>">
                                                <div class="row"> 
                                                    <div class="col-lg-12">
                                                        <div class="detalhes-imoveis">
                                                            <?php if (!empty($imovel->imagens)) { ?>
                                                            <div class="box-img-bg" style="background-image: url('<?php e($imovel->imagens[0]->uri.$imovel->imagens[0]->imagem); ?>');"></div>
                                                            <?php } else { ?>
                                                            <div class="box-img-bg" style="background-image: url('<?php e(base_url('themes/comdono/img/no-image-gallery.png'))?>');"></div>
                                                            <?php } ?>
                                                            <div class="box">
                                                                <div class="row">
                                                                    <div class="col">
                                                                        <h3 class="destaque mb-30">Detalhes do Imóvel</h3>
                                                                    </div>
                                                                </div>
                                                                <div class="row">
                                                                    <div class="col-6">
                                                                        <p class="m-0 c-blue"><?php e($imovel->bairro); ?></p>
                                                                        <p class="m-0"><?php e($imovel->endereco); ?></p>
                                                                        <p class="m-0"><?php e($imovel->tipo_imovel); ?></p>
                                                                        <p class="m-0"><?php e($imovel->area_privativa." m²"); ?></p>
                                                                    </div>
                                                                    <div class="col-6 text-right">
                                                                        <h3 class="destaque">
                                                                            <?php HValorPretendido::exibe($imovel->val_pretendido); ?>
                                                                        </h3>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div> 
                                            <div class="col-lg-7 pl-85">
                                                <div class="container-bancos">
                                                    <div class="row">
                                                        <div class="col-lg-12">
                                                            <div class="container-group-bancos">
                                                                <div class="row">
                                                                     <?php  foreach($bancos as $bnc){ ?>
                                                                        <div class="col div-height-center pr-0 divImgBanco">
                                                                            <img src="<?php e(base_url($bnc->logo_inativa)); ?>" class="img-fluid img-off">
                                                                            <img src="<?php e(base_url($bnc->logo_ativa)); ?>" class="d-none img-fluid img-on">
                                                                        </div> 
                                                                    <?php } ?>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="container-sliders">
                                                    <div class="row d-flex justify-content-center box-valor">
                                                        <div class="col-12 col-md-12 col-lg-4 p-0">
                                                            <div class="form-group">
                                                                <label for="input-valor">Valor da entrada*</label>
                                                                <input type="hidden" name="imovel"  id="input-imovel" data-imovel='<?php e($imovelEncode)?>'>
                                                                <input type="hidden" name="banco"  id="input-banco" data-banco='<?php e($banco)?>'>
                                                                <input type="hidden" name="bancos"  id="input-bancos" data-bancos='<?php e($bancosEncode)?>'>
                                                                <input type="hidden" name="simulacao"  id="input-simulacao" data-simulacao='<?php e(json_encode($simulacao))?>'>
                                                                <input type="hidden" name="porcentage"  id="input-porcentage" data-porcentage='<?php e(str_replace(",", ".", HProposta::taxaTipo($imovel->tipo_imovel)))?>'>
                                                                <input type="text" name="valor" class="form-control maskMoney" id="input-valor" value="<?php //e($simulacao->val_entrada); ?>">
                                                            </div>
                                                        </div>
                                                        <div class="col-11 col-md-11 col-lg-8">
                                                            <div id="pips-steps-valor"></div>
                                                        </div>
                                                    </div>
                                                    <div class="row d-flex justify-content-center box-entrada">
                                                        <div class="col-12 col-md-12 col-lg-4 p-0">
                                                            <div class="form-group">
                                                                <label class="label-custom" for="change-meses">Período a ser financiado*</label>
                                                                <select name="meses" id="change-meses" class="form-control">
                                                                    <option value="60">60 meses</option>
                                                                    <option value="120">120 meses</option>
                                                                    <option value="180">180 meses</option>
                                                                    <option value="240">240 meses</option>
                                                                    <option value="300">300 meses</option>
                                                                    <option value="360">360 meses</option>
                                                                </select>
                                                            </div>
                                                        </div>
                                                        <div class="col-11 col-md-11 col-lg-8">
                                                            <div id="pips-steps-meses"></div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="container-parcelas">
                                                    <div class="c-header">
                                                        <div class="row m-0">
                                                            <div class="col p-0">
                                                                <div class="text">Juros (a.a)</div>
                                                            </div>
                                                            <div class="col p-0">
                                                                <div class="text">Taxa TR (%)</div>
                                                            </div>
                                                            <div class="col p-0">
                                                                <div class="text">1ª Parcela</div>
                                                            </div>
                                                            <div class="col p-0">
                                                                <div class="text">Última Parcela</div>
                                                            </div>
                                                            <!--<div class="col p-0">
                                                                <div class="text">Valor a ser pago</div>
                                                            </div>-->
                                                        </div>
                                                    </div>
                                                    <div class="c-content">
                                                        <div class="row m-0">
                                                            <div class="col p-0">
                                                                <div class="text valorJuros"> - </div>
                                                            </div>
                                                            <div class="col p-0">
                                                                <div class="text valorTr"> - </div>
                                                            </div>
                                                            <div class="col p-0">
                                                                <div class="text valorParcelas"> - </div>
                                                            </div>
                                                            <div class="col p-0">
                                                                <div class="text valorUltimaParcela"> - </div>
                                                            </div>
                                                            <!--<div class="col p-0">
                                                                <div class="text valorTotal"> - </div>
                                                            </div>-->
                                                        </div>
                                                    </div>
                                                </div>
                                                <div id="content-error"></div>
                                                <div class="container-buttons mt-40">
                                                    <div class="row">
                                                        <div class="col-md-4 col-lg-4">
                                                            <div class="form-group">
                                                                <button type="button" class="btn btn-success calcularProposta">Calcular</button>
                                                            </div>
                                                        </div>
                                                        <div class="col-md-4 col-lg-4 pr-0">
                                                            <div class="form-group">
                                                                <button type="submit" class="btn btn-success enviarProposta">Solicitar proposta</button>
                                                            </div>
                                                        </div>
                                                        <div class="col-md-4 col-lg-4">
                                                            <div class="form-group">
                                                                <button type="button" class="btn btn-danger-txt sairSimulacao">Sair da Simulação</button>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>