<!--inicio etapa-1 -->
<div class="etapa-1" data-title="Etapa 1 - Começando pelo básico">
    <!--inicio step-1 -->
    <div class="step" <?php e($step == 1 ? "style='display: block'":""); ?>>
        <div class="row">
            <div class="col-lg-6 pr-40">
                <div class="container-info">
                    <div class="content-title">
                        <?php if($textTitulo??false){
                            e("<h2>$textTitulo</h2>");
                        } else { ?>
                            <h2>Cadastro<span>de imóvel</span></h2>
                        <?php } ?>
                    </div>
                    <p>Confiança é a base de qualquer negócio. E para quem quer vender ou comprar um imóvel é ainda mais importante se sentir seguro, não acha? </p>
                    <p><strong>Todas as informações com asterisco (*) são obrigatórias</strong>, mas para garantir um bom nível de confiança, é importante completar o máximo de itens no cadastro. Aproveite para inserir uma foto, afinal, todo mundo gosta de saber com quem está falando :)</p>
                </div>
            </div>
            
            <div class="col-lg-6 pl-40">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="content-subtitle">
                            <h3>Olá, <?php e($first_name); ?>! Por favor, preencha o formulário.</h3>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-lg-12">
                        <div class="form-group">
                            <div class="container-input-radio">
                                <?php if ( (!($edit??false)) || $imovel->doc_perfil == "cpf"){ ?>
                                <div class="custom-control custom-radio custom-control-inline">
                                    <input type="radio" id="doc_perfil_cpf" name="doc_perfil" class="custom-control-input" value="cpf" <?php e(($imovel->doc_perfil == "cpf" ) ? "checked" : ""); ?>>
                                    <label class="custom-control-label" for="doc_perfil_cpf">Pessoa Física</label>
                                </div>
                                <?php } ?>
                                <?php if ( (!($edit??false)) || $imovel->doc_perfil == "cnpj"){ ?>
                                <div class="custom-control custom-radio custom-control-inline">
                                    <input type="radio" id="doc_perfil_cnpj" name="doc_perfil" class="custom-control-input" value="cnpj"  <?php e($imovel->doc_perfil == "cnpj" ? "checked" : ""); ?>>
                                    <label class="custom-control-label" for="doc_perfil_cnpj">Pessoa Jurídica</label>
                                </div> 
                                <?php } ?>
                            </div>
                        </div>
                        <div class="box-dados-perfil <?php e(($imovel->doc_perfil || $imovel->doc_perfil == "cnpj") ? "d-block" : "d-none"); ?>">
                            <div class="row">
                                <div class="col-lg-12">
                                    <div class="form-group">
                                        <label for="dn_nome_nomefantasia" class="label_dn_nome_nomefantasia"><?php e(($imovel->doc_perfil == "cpf") ? "Nome completo*" : "Nome fantasia*"); ?></label>
                                        <input type="text" name="dn_nome_nomefantasia" class="form-control" id="dn_nome_nomefantasia" value="<?php e($imovel->dn_nome_nomefantasia); ?>" >
                                    </div>
                                    <div class="row col-custom-cadastro">
                                        <div class="col-lg-7">
                                            <div class="form-group">
                                                <label for="dn_email">E-mail*</label>
                                                <input type="email" name="dn_email" class="form-control" id="dn_email" value="<?php e($imovel->dn_email); ?>" >
                                            </div>
                                        </div>
                                        <div class="col-lg-5">
                                            <div class="form-group">
                                                <label for="dn_telefone">Telefone*</label>
                                                <input type="tel" name="dn_telefone" class="form-control" id="dn_telefone" value="<?php e($imovel->dn_telefone); ?>" >
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <div class="row col-custom-cadastro">
                                            <div class="col-lg-5">
                                                <label for="dn_cpf_cnpj" class="label_dn_cpf_cnpj"><?php e(($imovel->doc_perfil == "cpf") ? "CPF*" : "CNPJ*"); ?></label>
                                                <input type="text" name="dn_cpf_cnpj" class="form-control" id="dn_cpf_cnpj" value="<?php e($imovel->dn_cpf_cnpj); ?>">
                                            </div>
                                            <div class="col-lg-7 box-razao-social" <?php e($imovel->dn_razao_social != "" ? "style='display: block'":"style='display: none'"); ?>>
                                                <label for="dn_razao_social">Razão Social*</label>
                                                <input type="text" name="dn_razao_social" class="form-control" id="dn_razao_social" value="<?php e($imovel->dn_razao_social); ?>">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-lg-4">
                                    <div class="form-group align-box-img mt-10">
                                        <div class="container-img custom-file container-img-img <?php e($imovel->dn_img != "" ? "" : "d-none"); ?>">
                                            <div class="box-doc divImgPerfil" <?php if ($imovel->dn_img != ""){ ?> style="background-image: url('<?php e($imovel->dn_img_uri.$imovel->dn_img)?>');" <?php } ?>>
                                            </div>
                                            
                                            <div class="box-ico-text">
                                                <div class="text">
                                                    <div class="txt">
                                                        <i class="material-icons">
                                                           <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24">
                                                               <path fill="none" d="M0 0h24v24H0V0z"/>
                                                               <path d="M14.12 4l1.83 2H20v12H4V6h4.05l1.83-2h4.24M15 2H9L7.17 4H4c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V6c0-1.1-.9-2-2-2h-3.17L15 2zm-3 7c1.65 0 3 1.35 3 3s-1.35 3-3 3-3-1.35-3-3 1.35-3 3-3m0-2c-2.76 0-5 2.24-5 5s2.24 5 5 5 5-2.24 5-5-2.24-5-5-5z"/>
                                                            </svg>
                                                        </i>
                                                        
                                                        <div class="box-remover box-remover-foto <?php e(($imovel->doc_perfil == "cpf") ? "d-block" : "d-none") ?>">
                                                            <a href="javascript:;" class="act-remover-img">Remover foto</a> 
                                                            <a href="javascript:;" class="act-pergunta-img act-remover_img_perfil d-none">Remover foto?</a> 
                                                        </div>
                                                        
                                                        <div class="box-remover box-remover-logo <?php e(($imovel->doc_perfil == "cnpj") ? "d-block" : "d-none") ?>">
                                                            <a href="javascript:;" class="act-remover-img">Remover logo</a> 
                                                            <a href="javascript:;" class="act-pergunta-img act-remover_img_perfil d-none">Remover logo?</a> 
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div> 
                                        <div class="box-doc text-center container-img-load d-none">
                                            <label><i class='fa fa-circle-o-notch fa-spin'></i></label>
                                        </div>
                                        <div id="dn_img_div" class="container-img custom-file container-img-input <?php echo $imovel->dn_img != "" ? "d-none" : ""; ?>">
                                            <input type="file" name="dn_img" class="custom-file-input" id="dn_img" data-value="<?php echo $imovel->dn_img; ?>" >
                                            <label class="custom-file-label label-img-input" for="customFile">
                                                <div class="box-ico-text">
                                                    <div class="ico">
                                                        <i class="material-icons">
                                                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24">
                                                                <path d="M12 12c2.21 0 4-1.79 4-4s-1.79-4-4-4-4 1.79-4 4 1.79 4 4 4zm0 2c-2.67 0-8 1.34-8 4v2h16v-2c0-2.66-5.33-4-8-4z"/>
                                                                <path d="M0 0h24v24H0z" fill="none"/>
                                                            </svg>
                                                        </i>
                                                    </div>
                                                    <div class="text">
                                                        <div class="txt">
                                                        <i class="material-icons">
                                                           <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24">
                                                               <path fill="none" d="M0 0h24v24H0V0z"/>
                                                               <path d="M14.12 4l1.83 2H20v12H4V6h4.05l1.83-2h4.24M15 2H9L7.17 4H4c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V6c0-1.1-.9-2-2-2h-3.17L15 2zm-3 7c1.65 0 3 1.35 3 3s-1.35 3-3 3-3-1.35-3-3 1.35-3 3-3m0-2c-2.76 0-5 2.24-5 5s2.24 5 5 5 5-2.24 5-5-2.24-5-5-5z"/>
                                                            </svg>
                                                        </i>
                                                        <span><?php e(($imovel->doc_perfil == "cpf" || $imovel->doc_perfil == "") ? "Adicionar foto" : "Adicionar logo"); ?></span>
                                                        </div>
                                                    </div>
                                                </div>
                                            </label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!--inicio step-2 -->
    <div class="step" data-title="">
        <div class="row">
            <div class="col-lg-6 pr-40">
                <div class="container-info">
                    <div class="content-title">
                        <?php if($textTitulo??false){
                            e("<h2>$textTitulo</h2>");
                        } else { ?>
                            <h2>Cadastro<span>de imóvel</span></h2>
                        <?php } ?>
                    </div>
                    <p><strong>Mas o que é um lançamento imobiliário?</strong><p/>
                    <p>É a abertura de vendas de uma grande quantidade de imóveis de um mesmo empreendimento, normalmente feito por uma construtora ou incorporadora.</p>
                </div>
            </div>
            <div class="col-lg-6 pl-40">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="content-subtitle">
                            <h3>Dados do imóvel</h3>
                        </div>
                    </div>
                </div>
                 <div class="row">
                    <div class="col-lg-12">
                        <div class="form-group">
                            <label>Você deseja anexar a planilha do seu empreendimento?</label>
                            <div class="container-input-radio">
                                <?php if ( (!($edit??false)) || $imovel->lancamento == "Sim"){ ?>
                                <div class="custom-control custom-radio custom-control-inline">
                                    <input type="radio" id="lancamento_sim" name="lancamento" class="custom-control-input" value="Sim"<?php e($imovel->lancamento == "Sim" ? "checked" : ""); ?>>
                                    <label class="custom-control-label" for="lancamento_sim">Sim</label>
                                </div>
                                <?php } ?>
                                <?php if ( (!($edit??false)) || $imovel->lancamento == "Não"){ ?>
                                <div class="custom-control custom-radio custom-control-inline">
                                    <input type="radio" id="lancamento_nao" name="lancamento" class="custom-control-input" value="Não"<?php e($imovel->lancamento == "Não" ? "checked" : ""); ?>>
                                    <label class="custom-control-label" for="lancamento_nao">Não</label>
                                </div>
                                <?php } ?>
                            </div>
                        </div>
                        <div class="_box-imovel-novo <?php e(($imovel->lancamento == "Não") ? "" : ""); ?>">
                            <div class="form-group">
                                <label>Marque abaixo o tipo de empreendimento que deseja cadastrar.</label>
                                <div class="container-input-radio">
                                    <div class="custom-control custom-radio custom-control-inline">
                                        <input type="radio" id="imovel_novo_sim" name="tipo_empreendimento" class="custom-control-input" value="lancamento"<?php e($imovel->tipo_empreendimento == "lancamento" ? "checked" : ""); ?>>
                                        <label class="custom-control-label" for="imovel_novo_sim">Lançamento imobiliário</label>
                                    </div>
                                    <div class="custom-control custom-radio custom-control-inline">
                                        <input type="radio" id="imovel_novo_nao" name="tipo_empreendimento" class="custom-control-input" value="pronto"<?php e($imovel->tipo_empreendimento == "pronto" ? "checked" : ""); ?>>
                                        <label class="custom-control-label" for="imovel_novo_nao">Empreendimento pronto</label>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <div class="box-lancamento <?php e(($imovel->lancamento == "Sim") ? "d-block" : "d-none"); ?>">
                            <div class="row mb-15">
                                <div class="col-lg-12">
                                    <div class="box-previsao">
                                        <label for="previsao_entrega">Previsão de entrega</label>
                                        <input type="text" name="previsao_entrega" class="form-control data" id="previsao_entrega" value="<?php e($imovel->previsao_entrega); ?>">
                                    </div>
                                </div>
                            </div>
                            
                            <?php if (!($edit??false)){ ?>
                            <div class="row mb-15">
                                <div class="col-lg-12">
                                    <div class="form-group">
                                        <p>Para cadastrar lançamentos, usamos um modelo de planilha COMDONO que pode ser baixado <a href="<?php e(base_url("assets/uploads/planilha-modelo-comdono.xlsx")); ?>" target="_blank">aqui</a>. Após o preenchimento, anexe-a em formato excel (xlsx) abaixo.</p>
                                    </div>
                                </div>
                            </div>
                            <div class="row mb-15">
                                <div class="col-lg-12">
                                    <div id="doc_planilha_div" class="container-file custom-file container-planilha-file">
                                        <input type="file" name="doc_planilha" class="custom-file-input" id="doc_planilha" value="">
                                        <label class="custom-file-label label-planilha-file" for="customFile">
                                            <div class="row d-flex justify-content-center">
                                                <div class="col-lg-3 p-0">
                                                    <div class="container-doc-img container-planilha-img text-right <?php echo $imovel->doc_planilha != "" ? "d-block" : "d-none"; ?>">
                                                        <div class="divDocPlanilha">
                                                            <?php if ($imovel->doc_planilha != ""){ ?>
                                                            <img src="<?php e(base_url("themes/comdono/img/ico-file-xlsx.png"));?>">
                                                            <?php } ?>
                                                        </div>
                                                    </div>
                                                    <div class="container-doc-load text-right d-none">
                                                        <i class="fa fa-circle-o-notch fa-spin"></i>
                                                    </div>
                                                    <div class="box-icons text-right <?php echo $imovel->doc_planilha != "" ? "d-none" : "d-block"; ?>">
                                                        <div class="ico arrow">
                    								        <i class="material-icons">
                                                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24">
                                                                   <path fill="none" d="M0 0h24v24H0V0z"></path>
                                                                   <path d="M4 12l1.41 1.41L11 7.83V20h2V7.83l5.58 5.59L20 12l-8-8-8 8z"></path>
                                                                </svg>
                                                            </i>
                    								    </div>
                    								    <div class="ico space">
                    								        <i class="material-icons">
                                                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24">
                                                                   <path fill="none" d="M0 0h24v24H0V0z"></path>
                                                                   <path d="M18 9v4H6V9H4v6h16V9h-2z"></path>
                                                                </svg>
                                                            </i>
                    								    </div>
                                                    </div>
            								    </div>
            								    <div class="col-lg-7 p-0">
            								        <div class="text">
            								            Clique ou arraste e solte <span>o documento</span>
            								        </div>
            								    </div>
        								    </div>
                                        </label>
                                    </div>
                                    <div class="container-remover">
                                        <div class="row d-flex justify-content-center">
                                            <div class="col-lg-3 p-0">
                                                <div class="box-act-remover <?php echo $imovel->doc_planilha != "" ? "d-block" : "d-none"; ?>">
                                                    <a href="javascript:;" class="act-remover-planilha">Remover</a> 
                                                    <a href="javascript:;" class="act-pergunta-planilha act-remover_planilha d-none">Remover?</a>
                                                </div>
                                            </div><div class="col-lg-7 p-0"></div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <?php } ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>