<!--inicio etapa-2 -->
<div class="etapa-2" data-title="Etapa 2 - Você já está quase lá">
    <!--inicio step-3 -->
    <div class="step">
        <div class="row">
            <div class="col-lg-6 pr-40">
                <div class="container-info">
                    <div class="content-title">
                        <?php if($textTitulo??false){
                            e("<h2>$textTitulo</h2>");
                        } else { ?>
                            <h2>Cadastro<span>de imóvel</span></h2>
                        <?php } ?>
                    </div>
                    
                    <p>Ao incluir o CEP, não esqueça de verificar se o endereço está com todas as informações. A localização é muito importante para quem busca um imóvel.</p>
                    <p>Caso não saiba o CEP do imóvel <a href="http://www.buscacep.correios.com.br/sistemas/buscacep/buscaCepEndereco.cfm" target="_blank">clique aqui.</a></p>
                    <p><strong>#dicacomdono</strong> O complemento é um elemento obrigatório e ajudará a filtrar melhor seu empreendimento nas buscas. Ele pode conter, por exemplo, o nome do condomínio, edifício ou residencial. Veja o exemplo abaixo:</p>
                    
                    <p class="m-0 mt-15"><strong>CEP:</strong> 70737-530</p>
                    <p class="m-0"><strong>Endereço:</strong> CLN 305 Bloco C</p>
                    <p class="m-0"><strong>Complemento:</strong> Copa Network</p>
                    <p class="m-0"><strong>Número:</strong> 305</p>
                    <p class="m-0"><strong>Bairro:</strong> Asa Norte</p>
                    <p class="m-0"><strong>Cidade:</strong> Brasília</p>
                    <p class="m-0"><strong>Estado:</strong> Distrito Federal</p>
                </div>
            </div>
            <div class="col-lg-6 pl-40">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="content-subtitle">
                            <h3>Localização do imóvel</h3>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-lg-3 col-md-3">
                        <div class="form-group">
                            <label for="cep">CEP*</label>
                            <input type="text" name="cep" class="form-control" id="cep" value="<?php e($imovel->cep); ?>">
                            <span class="info-cep"></span>
                        </div>
                    </div>
                    <div class="col-lg-6 col-md-6">
                        <div class="form-group">
                            <label for="dn_endereco">Endereço*</label>
                            <input type="text" name="endereco" class="form-control" id="endereco" value="<?php e($imovel->endereco); ?>" readonly="readonly">
                        </div>
                    </div>
                    <div class="col-lg-3 col-md-3">
                        <div class="form-group">
                            <label for="end_numero">Número*</label>
                            <input type="text" name="numero" class="form-control" id="end_numero" value="<?php e($imovel->numero); ?>">
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-lg-6 col-md-6">
                        <div class="form-group">
                            <label for="end_complemento">Complemento*</label>
                            <input type="text" name="complemento" class="form-control" id="end_complemento" value="<?php e($imovel->complemento); ?>">
                        </div>
                    </div>
                    <div class="col-lg-6 col-md-6">
                        <div class="form-group">
                            <label for="bairro">Bairro*</label>
                            <input type="text" name="bairro" class="form-control" id="bairro" value="<?php e($imovel->bairro); ?>" readonly="readonly">
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-lg-6 col-md-6">
                        <div class="form-group">
                            <label for="dn_cidade">Cidade*</label>
                            <input type="text" name="cidade" class="form-control" id="dn_end_complemento" value="<?php e($imovel->cidade); ?>" readonly="readonly">
                        </div>
                    </div>
                    <div class="col-lg-6 col-md-6">
                        <div class="form-group">
                            <label for="dn_estado">Estado*</label>
                            <input type="text" name="estado" class="form-control" id="dn_estado" value="<?php e($imovel->estado); ?>" readonly="readonly">
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!--inicio step-4 -->
    <div class="step">
        <div class="row">
            <div class="col-lg-6 pr-40">
                <div class="container-info">
                    <div class="content-title">
                        <?php if($textTitulo??false){
                            e("<h2>$textTitulo</h2>");
                        } else { ?>
                            <h2>Cadastro<span>de imóvel</span></h2>
                        <?php } ?>
                    </div>
                    <p><strong>#dicacomdono</strong></p>
                    <p>Existe uma margem de erro no GPS. Certifique-se de que o localizador do mapa ao lado está no endereço exato. Caso não esteja, você deverá movimentá-lo até a localização correta, <strong>como mostra o exemplo abaixo</strong>.</p>
                    <div class="content-img">
                        <img src="<?php e(base_url("assets/img/comdono/gif/localizacao.gif")); ?>">
                    </div>
                </div>
            </div>
            <div class="col-lg-6 pl-40">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="content-subtitle">
                            <h3>Seu imóvel no mapa</h3>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-lg-12">
                        <div class="form-group m-0">
                            <input type="hidden" name="longitude" value="<?php e($imovel->longitude); ?>" >
                            <input type="hidden" name="latitude" value="<?php e($imovel->latitude); ?>" >
                            <input type="hidden" name="bairro_lat" value="<?php e($imovel->bairro_lat); ?>" >
                            <input type="hidden" name="bairro_long" value="<?php e($imovel->bairro_long); ?>" >
                            <input type="hidden" name="quadra_lat" value="<?php e($imovel->quadra_lat); ?>" >
                            <input type="hidden" name="quadra_long" value="<?php e($imovel->quadra_long); ?>" >
                            <input type="hidden" name="conjunto_lat" value="<?php e($imovel->conjunto_lat); ?>" >
                            <input type="hidden" name="conjunto_long" value="<?php e($imovel->conjunto_long); ?>" >
                            
                            <input type="hidden" class="confirma_local" name="confirma_local" value="true" >
                            
                            <input type="hidden" id="pac-input" class="controls" type="text" placeholder="">
                            <div class="row">
                                <div class="col-lg-12">
                                    <div class="container-maps">
                                        <div id="map"></div>
                                        <div class="d-none">
                                            <div class="popup-confirmacao" id="popup-confirmacao">
                                                <div class="txt">O Pin está na localização correta?</div>
                                                <div class="row no-margin">
                                                    <div class="col-lg-6">
                                                        <button type="button" class="btn btn-primary confirmar-localizacao" >Confirmar</button>
                                                    </div>
                                                    <div class="col-lg-6">
                                                        <button type="button" class="btn btn-danger cancelar-localizacao" >Cancelar</button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="container-info-mapa bg-green">
                                       Indique a localização de seu imóvel.
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!--inicio step-5 -->
    <div class="step">
        <div class="row">
            <div class="col-lg-6 pr-40">
                <div class="container-info">
                    <div class="content-title">
                        <?php if($textTitulo??false){
                            e("<h2>$textTitulo</h2>");
                        } else { ?>
                            <h2>Cadastro<span>de imóvel</span></h2>
                        <?php } ?>
                    </div>
                    <p>Chegou a hora de inserir detalhes sobre o imóvel. Tenha a Certidão de Matrícula atualizada (de inteiro teor) em mãos para facilitar o preenchimento dos dados.</p>
                    <p>Com o número de matrícula é possível conferir as informações e histórico relativos ao imóvel que está à venda, bem como se o vendedor é realmente o responsável legal</p>
                    <p><strong>#dicadocomdono</strong></p>
                    <p>Caso não tenha o número de matrícula, faça o pedido online por meio do  <a href="https://cartorioregistrodeimoveis.com.br/" target="_blank">Cartório 24 Horas.</a></p>
                </div>
            </div>
            <div class="col-lg-6 pl-40">
                <div class="row">
                    <div class="col-lg-12">
                        <div id="accordion">
                            <div class="card <?php e(!empty($imoveis_rel) ? "":"border-none"); ?>">
                                <?php if(!empty($imoveis_rel)){ ?>
                                <div class="card-header unidade-show">
                                    <div class="row">
                                        <div class="col-10">
                                            <a class="card-link" data-toggle="collapse" href="#collapseOne">Unidade <?php e($imovel->complemento); ?></a>
                                        </div>
                                        <div class="col-2">
                                            <a data-toggle="collapse" class="icon-collapse f-right" href="#collapseOne" aria-expanded="true">
                                                <i class="fa" aria-hidden="true"></i>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                                <?php } ?>
                                <div id="collapseOne" class="collapse show" data-parent="#accordion">
                                    
                                </div>
                            </div>
                        
                        </div>
                        <div class="form-group">
                            <div class="content-subtitle">
                                <h3 class="m-10"><?php e(($imovel->lancamento == "Sim" && $imovel->doc_perfil == "cnpj") ? "Incluir Memorial de incorporação" : "Documento do imóvel"); ?></h3>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="docPropSim <?php e(($imovel->lancamento == "Sim" && $imovel->doc_perfil == "cnpj") ? "d-block" : "d-none"); ?>">
                                    <p>Anexe abaixo o Alvará de Construção ou o Memorial de Incorporação do empreendimento. O upload do documento oferece maior segurança e é uma forma de garantir que apenas o responsável legal do imóvel faça a venda.</p> 
                                </div>
                                <div class="docPropNao <?php e(($imovel->lancamento == "Sim" && $imovel->doc_perfil == "cnpj") ? "d-none" : "d-block"); ?>">
                                    <p>Anexe abaixo o IPTU do imóvel. O upload do documento oferece maior segurança e é uma forma de garantir que apenas o dono do imóvel faça a venda.</p>
                                    <p>Caso não tenha o IPTU em mãos e o imóvel seja registrado no Distrito Federal, <a href="http://www.fazenda.df.gov.br/area.cfm?id_area=1539" target="_blank">clique aqui</a>.</p>
                                </div>
                            </div>
                            
                            <div class="col-lg-12 mt-15 mb-30">
                                
                                
                            <div id="doc_propriedade_div" class="container-file custom-file container-doc-file <?php echo $imovel->doc_propriedade != "" ? "d-none" : "d-block"; ?>">
                                <input type="file" name="doc_propriedade" class="custom-file-input" id="doc_propriedade" data-value="<?php echo $imovel->doc_propriedade; ?>" value="">
                                <label class="custom-file-label label-doc-file" for="customFile">
                                    <div class="row d-flex justify-content-center">
                                        <div class="col-lg-3 p-0">
                                            <div class="container-box-doc text-right <?php echo $imovel->doc_propriedade != "" ? "d-block" : "d-none"; ?>">
                                                <div class="divDoc">
                                                    <?php 
                                                        if ($imovel->doc_propriedade != ""){
                                                            
                                                        $pdf = explode(".",$imovel->doc_propriedade);
                                                        
                                                        if (end($pdf) == "pdf"){
                                                    ?>
                                                    <img src="<?php e(base_url('themes/comdono/img/ico-file-pdf.png')); ?>">
                                                    
                                                    <?php } else { ?>
                                                    <img src="<?php e(base_url().'themes/comdono/img/ico-file-img.png'); ?>">
                                                    
                                                    <?php } } ?>
                                                </div>
                                            </div>
                                            <div class="container-doc-load text-right d-none">
                                                <i class="fa fa-circle-o-notch fa-spin"></i>
                                            </div>
                                            <div class="box-icons-doc text-right <?php echo $imovel->doc_propriedade != "" ? "d-none" : "d-block"; ?>">
                                                <div class="ico arrow">
            								        <i class="material-icons">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24">
                                                           <path fill="none" d="M0 0h24v24H0V0z"></path>
                                                           <path d="M4 12l1.41 1.41L11 7.83V20h2V7.83l5.58 5.59L20 12l-8-8-8 8z"></path>
                                                        </svg>
                                                    </i>
            								    </div>
            								    <div class="ico space">
            								        <i class="material-icons">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24">
                                                           <path fill="none" d="M0 0h24v24H0V0z"></path>
                                                           <path d="M18 9v4H6V9H4v6h16V9h-2z"></path>
                                                        </svg>
                                                    </i>
            								    </div>
                                            </div>
    								    </div>
    								    <div class="col-lg-7 p-0">
    								        <div class="text">
    								            Clique ou arraste e solte <span>o documento</span>
    								        </div>
    								    </div>
								    </div>
                                </label>
                            </div>
                        
                            <!--loading-->
                            <div id="doc_propriedade_div_load" class="container-file custom-file container-doc-file d-none">
                                <label class="custom-file-label label-doc-file" for="customFile">
                                    <div class="row d-flex justify-content-center">
                                        <div class="col-lg-3 p-0">
                                            <div class="text-right mt-15 mr-20">
                                                <i class="fa fa-circle-o-notch fa-spin fa-2x"></i>
                                            </div>
    								    </div>
    								    <div class="col-lg-7 p-0">
    								        <div class="text mt-15">
    								            Carregando...
    								        </div>
    								    </div>
								    </div>
                                </label>
                            </div>
                            
                            <!--documento-->
                            <a href="<?php e($imovel->doc_propriedade); ?>" class="link_divDoc cursor-pointer" target="_blank">
                            <div id="doc_propriedade_div_doc" class="container-file custom-file container-doc-file <?php e($imovel->doc_propriedade != "" ? "" : "d-none"); ?>">
                                <label class="custom-file-label label-doc-file cursor-pointer" for="customFile">
                                    <div class="row d-flex justify-content-center">
                                        <div class="col-lg-3 p-0">
                                            <div class="container-box-doc text-right <?php echo $imovel->doc_propriedade != "" ? "d-block" : "d-none"; ?>">
                                                <div class="divDoc">
                                                    <?php 
                                                        if ($imovel->doc_propriedade != ""){
                                                            
                                                        $pdf = explode(".",$imovel->doc_propriedade);
                                                        
                                                        if (end($pdf) == "pdf"){
                                                    ?>
                                                    <img src="<?php e(base_url('themes/comdono/img/ico-file-pdf.png')); ?>">
                                                    <?php } else { ?>
                                                    <img src="<?php e(base_url().'themes/comdono/img/ico-file-img.png'); ?>">
                                                    <?php } } ?>
                                                </div>
                                            </div>
    								    </div>
    								    <div class="col-lg-7 p-0">
    								        <div class="text mt-15 c-blue">Ver documento</div>
    								    </div>
								    </div>
                                </label>
                            </div>
                            </a>
                            
                            <div class="container-remover">
                                <div class="row d-flex justify-content-center">
                                    <div class="col-lg-3 p-0">
                                        <div class="box-act-remover-doc <?php echo $imovel->doc_propriedade != "" ? "d-block" : "d-none"; ?>">
                                            <a href="javascript:;" class="act-text act-remover-doc">Remover</a> 
                                            <a href="javascript:;" class="act-text act-pergunta-doc act-remover_doc" style="display: none;">Remover?</a>
                                        </div>
                                    </div><div class="col-lg-7 p-0"></div>
                                </div>
                            </div>
                        </div>
                            
                            <!--<div class="col-lg-12 mt-15 mb-30">
                            
                                <div id="doc_propriedade_div" class="container-file custom-file container-doc-file">
                                    <input type="file" name="doc_propriedade" class="custom-file-input" id="doc_propriedade" data-value="<?php echo $imovel->doc_propriedade; ?>" value="">
                                    <label class="custom-file-label label-doc-file" for="customFile">
                                        <div class="row d-flex justify-content-center">
                                            <div class="col-lg-3 p-0">
                                                <div class="container-box-doc text-right <?php echo $imovel->doc_propriedade != "" ? "d-block" : "d-none"; ?>">
                                                    <div class="divDoc">
                                                        <?php 
                                                            if ($imovel->doc_propriedade != ""){
                                                                
                                                            $pdf = explode(".",$imovel->doc_propriedade);
                                                            
                                                            if (end($pdf) == "pdf"){
                                                        ?>
                                                        <img src="<?php e(base_url('themes/comdono/img/ico-file-pdf.png')); ?>">
                                                        
                                                        <?php } else { ?>
                                                        <img src="<?php e(base_url().'themes/comdono/img/ico-file-img.png'); ?>">
                                                        
                                                        <?php } } ?>
                                                    </div>
                                                </div>
                                                <div class="container-doc-load text-right d-none">
                                                    <i class="fa fa-circle-o-notch fa-spin"></i>
                                                </div>
                                                <div class="box-icons-doc text-right <?php echo $imovel->doc_propriedade != "" ? "d-none" : "d-block"; ?>">
                                                    <div class="ico arrow">
                								        <i class="material-icons">
                                                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24">
                                                               <path fill="none" d="M0 0h24v24H0V0z"></path>
                                                               <path d="M4 12l1.41 1.41L11 7.83V20h2V7.83l5.58 5.59L20 12l-8-8-8 8z"></path>
                                                            </svg>
                                                        </i>
                								    </div>
                								    <div class="ico space">
                								        <i class="material-icons">
                                                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24">
                                                               <path fill="none" d="M0 0h24v24H0V0z"></path>
                                                               <path d="M18 9v4H6V9H4v6h16V9h-2z"></path>
                                                            </svg>
                                                        </i>
                								    </div>
                                                </div>
        								    </div>
        								    <div class="col-lg-7 p-0">
        								        <div class="text">
        								            Clique ou arraste e solte <span>o documento</span>
        								        </div>
        								    </div>
    								    </div>
                                    </label>
                                </div>
                                <div class="container-remover">
                                    <div class="row d-flex justify-content-center">
                                        <div class="col-lg-3 p-0">
                                            <div class="box-act-remover-doc <?php echo $imovel->doc_propriedade != "" ? "d-block" : "d-none"; ?>">
                                                <a href="javascript:;" class="act-text act-remover-doc">Remover</a> 
                                                <a href="javascript:;" class="act-text act-pergunta-doc act-remover_doc" style="display: none;">Remover?</a>
                                            </div>
                                        </div><div class="col-lg-7 p-0"></div>
                                    </div>
                                </div>
                            </div>-->
                            
                            
                            
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!--inicio step-6-->
    
    <!--inicio step-7 -->
    <div class="step">
        <div class="row">
            <div class="col-lg-6 pr-40">
                <div class="container-info">
                    <div class="content-title">
                        <?php if($textTitulo??false){
                            e("<h2>$textTitulo</h2>");
                        } else { ?>
                            <h2>Cadastro<span>de imóvel</span></h2>
                        <?php } ?>
                    </div>
                    <p>A descrição é o lugar onde você pode agregar valor ao imóvel que deseja vender. Aproveite para contar um pouco sobre o que há no comércio ao redor e curiosidades sobre a vizinhança. Que tal fazer uma descrição mais personalizada contando da sua experiência neste imóvel?</p>
                </div>
                <div class="form-group mb-20">
                    <?php $texto = "Um imóvel perfeito para chamar de seu! Com três quartos e dois banheiros, este imóvel é ideal para quem busca um lar para a família. Tenha todo o conforto de dois andares bem distribuídos, amplos e com iluminação natural. Sente-se na varanda e aproveite a tranquilidade e calmaria desta localização."; ?>
                    <label for="caracteristicas_imovel">Descreva seu imóvel</label>
                    <textarea class="form-control textminieditor" name="caracteristicas" rows="3" placeholder="<?php e($texto); ?>"><?php e($imovel->caracteristicas); ?></textarea>
                </div>
            </div>
            <div class="col-lg-6 pl-40">
                
                
                <div class="row box-detalhes-condominio">
                    <div class="col-lg-12">
                        <div class="content-subtitle">
                            <h3 class="mb-20 mt-20">Detalhes do condomínio</h3>
                        </div>
                    </div>
                </div>
                <div class="row container-detalhes-imovel box-detalhes-condominio">
                    <div class="col-6">
                        <div class="custom-control custom-checkbox">
                            <input type="checkbox" name="academia" class="custom-control-input" id="academia" <?php e($imovel->academia == "on" ? "checked" : ""); ?>>
                            <label class="custom-control-label" for="academia">Academia</label>
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="custom-control custom-checkbox">
                            <input type="checkbox" name="churrasqueira" class="custom-control-input" id="churrasqueira" <?php e($imovel->churrasqueira == "on" ? "checked" : ""); ?>>
                            <label class="custom-control-label" for="churrasqueira">Churrasqueira</label>
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="custom-control custom-checkbox">
                            <input type="checkbox" name="elevador" class="custom-control-input" id="elevador" <?php e($imovel->elevador == "on" ? "checked" : ""); ?>>
                            <label class="custom-control-label" for="elevador">Elevador</label>
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="custom-control custom-checkbox">
                            <input type="checkbox" name="espaco_gourmet" class="custom-control-input" id="espaco_gourmet" <?php e($imovel->espaco_gourmet == "on" ? "checked" : ""); ?>>
                            <label class="custom-control-label" for="espaco_gourmet">Espaço Gourmet</label>
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="custom-control custom-checkbox">
                            <input type="checkbox" name="lavanderia" class="custom-control-input" id="lavanderia" <?php e($imovel->lavanderia == "on" ? "checked" : ""); ?>>
                            <label class="custom-control-label" for="lavanderia">Lavanderia</label>
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="custom-control custom-checkbox">
                            <input type="checkbox" name="piscina" class="custom-control-input" id="piscina" <?php e($imovel->piscina == "on" ? "checked" : ""); ?>>
                            <label class="custom-control-label" for="piscina">Piscina</label>
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="custom-control custom-checkbox">
                            <input type="checkbox" name="playground" class="custom-control-input" id="playground" <?php e($imovel->playground == "on" ? "checked" : ""); ?>>
                            <label class="custom-control-label" for="playground">Playground</label>
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="custom-control custom-checkbox">
                            <input type="checkbox" name="quadra_esportiva" class="custom-control-input" id="quadra_esportiva" <?php e($imovel->quadra_esportiva == "on" ? "checked" : ""); ?>>
                            <label class="custom-control-label" for="quadra_esportiva">Quadra esportiva</label>
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="custom-control custom-checkbox">
                            <input type="checkbox" name="salao_festa" class="custom-control-input" id="salao_festa" <?php e($imovel->salao_festa == "on" ? "checked" : ""); ?>>
                            <label class="custom-control-label" for="salao_festa">Salão de Festas</label>
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="custom-control custom-checkbox">
                            <input type="checkbox" name="sauna" class="custom-control-input" id="sauna" <?php e($imovel->sauna == "on" ? "checked" : ""); ?>>
                            <label class="custom-control-label" for="sauna">Sauna</label>
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="custom-control custom-checkbox">
                            <input type="checkbox" name="cobertura" class="custom-control-input" id="cobertura" <?php e($imovel->cobertura == "on" ? "checked" : ""); ?>>
                            <label class="custom-control-label" for="cobertura">Cobertura</label>
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="custom-control custom-checkbox">
                            <input type="checkbox" name="estacionamento_rotativo" class="custom-control-input" id="estacionamento_rotativo" <?php e($imovel->estacionamento_rotativo == "on" ? "checked" : ""); ?>>
                            <label class="custom-control-label" for="estacionamento_rotativo">Estacionamento Rotativo</label>
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="custom-control custom-checkbox">
                            <input type="checkbox" name="wifi" class="custom-control-input" id="wifi" <?php e($imovel->wifi == "on" ? "checked" : ""); ?>>
                            <label class="custom-control-label" for="wifi">Wi-fi</label>
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="custom-control custom-checkbox">
                            <input type="checkbox" name="porteiro_24h" class="custom-control-input" id="porteiro_24h" <?php e($imovel->porteiro_24h == "on" ? "checked" : ""); ?>>
                            <label class="custom-control-label" for="porteiro_24h">Porteiro 24h</label>
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="custom-control custom-checkbox">
                            <input type="checkbox" name="acessibilidade" class="custom-control-input" id="acessibilidade" <?php e($imovel->acessibilidade == "on" ? "checked" : ""); ?>>
                            <label class="custom-control-label" for="acessibilidade">Acessibilidade</label>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div><!--fim etapa-2 -->