<!-----------PREVIEW-------------->
<?php if ($preview??false){ ?>

<input type="hidden" name="preview" class="form-control" id="preview" value="<?php e($preview); ?>" >
<input type="hidden" name="id_step" class="form-control" id="id_step" value="<?php e($step); ?>" >
<div class="container-page-cadastro-imoveis">
    <div class="container-alert box-fixed">
        <div class="row">
            <div class="col-12 p-0">
                <div class="alert alert-default alert-effect">
                    <div class="row">
                        <div class="col-12 col-sm-2 col-md-2 col-lg-1 pr-0">
                            <div class="content-btn">
                                <button type="button" class="btn btn-primary m-0 <?php if ($edit??false): ?>voltarEditarCadastro<?php else: ?>voltarCadastro<?php endif; ?>">Anterior</button>
                            </div>
                        </div>
                        
                        <div class="col-12 col-sm-8 col-md-8 col-lg-10 text">
                            <strong>Atenção!</strong> Esta é uma pré-visualização de como seu anúncio ficará quando estiver no ar. Confira as informações e clique em “Concluir”.
                        </div>
                        
                        <div class="col-12 col-sm-2 col-md-2 col-lg-1 pl-0">
                            <div class="content-btn">
                                 <button type="button" class="btn btn_proximo m-0 <?php if ($edit??false): ?>concluirEditarCadastro<?php else: ?>concluirCadastro<?php endif; ?>">Concluir</button>
                            </div>
                        </div>
                    </div>
                    
                </div>
            </div>
        </div>
    </div>
</div>

<div class="loader-page-preview"></div>
<div class="show-page-preview">

<?php } ?>
<!-----------END PREVIEW-------------->


<!-----------INI Visualizar como admin-------------->
<?php if ($navAdmin??false){ ?>
<div class="container-alert">
    <div class="row">
        <div class="col-12 p-0">
            <div class="alert <?php e(HImovel::getStatus($imovel->status)->bg); ?> alert-effect">
                <strong>Status: <?php e(HImovel::getStatus($imovel->status)->text); ?>.</strong> Visualização apenas para o dono e administradores.
            </div>
        </div>
    </div>
</div>
<?php } ?>
<!-----------FIM Visualizar como admin-------------->

<div class="row">
    <div class="col-lg-12">
        <div class="container-page-imovel mb-60">
            <div class="row">
                <div class="col-lg-12 p-0">
                    <div class="container-header-detalhes bg-white">
                        <div class="row d-flex justify-content-center m-0">
                            <div class="col-lg-9">
                                <div class="container-galeria">
                                    <!--Fotos-->
                                    <div class="container-fotos d-none">
                                        <?php if($logado == true){ ?>
                                        <div class="box-favoritos actFavoritos <?php e(isset($favoritos[$imovel->id_imovel]) ? 'btn_descurtir color_red' : 'btn_curtir color_grey'); ?>" title="<?php e(isset($favoritos[$imovel->id_imovel]) ? 'Remover dos favoritos' : 'Adicionar como favorito'); ?>" data-id="<?php e($imovel->id_imovel); ?>">
                                            <i class="fa fa-heart" aria-hidden="true"></i>
                                        </div>
                                        <?php }else{ ?>
                                        <!--<div class="box-favoritos-empty"></div>-->
                                        <div class="box-favoritos color_grey openLogin" title="">
                                            <i class="fa fa-heart" aria-hidden="true"></i>
                                        </div>
                                        <?php } if (!empty($imovel->imagens)) { ?>
                                        <div class="galeria">
                                            <div id="gallery" class="heightContentPainel" style="display:none;">
                                                <?php foreach ($imovel->imagens as $img_galeria) { ?>
                                                    <img alt="<?php HImg::alt($img_galeria); ?>" src="<?php HImg::ref($img_galeria); ?>" data-image="<?php HImg::ref($img_galeria); ?>" data-description="<?php HImg::desc($img_galeria); ?>">
                                                <?php } ?>
                                            </div>
                                        </div>
                                        <?php } else { ?>
                                        <div class="galeria">
                                            <div id="gallery" style="display:none;">
                                                <img src="<?php e(base_url('themes/comdono/img/no-image-gallery.png'))?>" class="img-fluid" alt="Não há imagens">
                                            </div>
                                        </div>
                                        <?php } ?>
                                    </div>
                                    
                                    <!--Videos-->
                                    <?php $actVideo = false; if($actVideo == true){ ?>
                                    <div class="container-videos w-100 d-none">
                                        <iframe src="https://my.matterport.com/show/?m=tbQAtKWppCP&utm_source=hit-content-embed" style="width: 100%;height: 100%;" frameborder="0" allowfullscreen allowvr></iframe>
                                    </div>
                                    <?php } ?>
                                    
                                    <!--Street View-->
                                    <input type="hidden" name="latitude" id="latitude" value="<?php e($imovel->latitude)?>">
                                    <input type="hidden" name="longitude" id="longitude" value="<?php e($imovel->longitude)?>">
                                    <div class="container-street-view w-100 d-none" id="mapStreetView"></div>
                                    
                                    <!--Map-->
                                    <div class="container-map w-100 d-none" id="mapImovel"></div>
                                    
                                    <!--Actions-->
                                    <div class="container-actions">
                                        <div class="row d-flex justify-content-center m-0">
                                            <div class="col p-0">
                                                <div class="item-action actFotos">
                                                    <span class="ico">
                                                        <svg xmlns="http://www.w3.org/2000/svg">
                                                            <path fill="none" d="M0 0h24v24H0V0z"/>
                                                            <path d="M14.12 4l1.83 2H20v12H4V6h4.05l1.83-2h4.24M15 2H9L7.17 4H4c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V6c0-1.1-.9-2-2-2h-3.17L15 2zm-3 7c1.65 0 3 1.35 3 3s-1.35 3-3 3-3-1.35-3-3 1.35-3 3-3m0-2c-2.76 0-5 2.24-5 5s2.24 5 5 5 5-2.24 5-5-2.24-5-5-5z"/>
                                                        </svg>
                                                    </span>
                                                    <span class="text">Fotos</span>
                                                </div>
                                            </div>
                                            <?php if($actVideo == true){ ?>
                                            <div class="col p-0 bsr-none-767">
                                                <div class="item-action actVideo">
                                                    <span class="ico">
                                                        <svg xmlns="http://www.w3.org/2000/svg">
                                                            <path fill="none" d="M0 0h24v24H0V0z"/>
                                                            <path d="M12 7C6.48 7 2 9.24 2 12c0 2.24 2.94 4.13 7 4.77V20l4-4-4-4v2.73c-3.15-.56-5-1.9-5-2.73 0-1.06 3.04-3 8-3s8 1.94 8 3c0 .73-1.46 1.89-4 2.53v2.05c3.53-.77 6-2.53 6-4.58 0-2.76-4.48-5-10-5z"/>
                                                        </svg>
                                                    </span>
                                                    <span class="text">Tour 3D</span>
                                                </div>
                                            </div>
                                            <?php } ?>
                                            <div class="col p-0">
                                                <div class="item-action actMap">
                                                    <span class="ico">
                                                        <svg xmlns="http://www.w3.org/2000/svg">
                                                            <path d="M12 2C8.13 2 5 5.13 5 9c0 5.25 7 13 7 13s7-7.75 7-13c0-3.87-3.13-7-7-7zm0 9.5c-1.38 0-2.5-1.12-2.5-2.5s1.12-2.5 2.5-2.5 2.5 1.12 2.5 2.5-1.12 2.5-2.5 2.5z"/>
                                                            <path d="M0 0h24v24H0z" fill="none"/>
                                                        </svg>
                                                    </span>
                                                    <span class="text">Mapa</span>
                                                </div>
                                            </div>
                                            <div class="col p-0 bsr-none-767">
                                                <div class="item-action actStreetView">
                                                    <span class="ico">
                                                        <svg xmlns="http://www.w3.org/2000/svg">
                                                            <path fill="none" d="M0 0h24v24H0V0z"/>
                                                            <path d="M12.56 14.33c-.34.27-.56.7-.56 1.17V21h7c1.1 0 2-.9 2-2v-5.98c-.94-.33-1.95-.52-3-.52-2.03 0-3.93.7-5.44 1.83z"/>
                                                            <circle cx="18" cy="6" r="5"/>
                                                            <path d="M11.5 6c0-1.08.27-2.1.74-3H5c-1.1 0-2 .9-2 2v14c0 .55.23 1.05.59 1.41l9.82-9.82C12.23 9.42 11.5 7.8 11.5 6z"/>
                                                        </svg>
                                                    </span>
                                                    <span class="text">Street View</span>
                                                </div>
                                            </div>
                                            <div class="col p-0">
                                                <div class="item-action actCompartilhar">                                                    
                                                    <span class="ico">
                                                        <svg xmlns="http://www.w3.org/2000/svg">
                                                            <path fill="none" d="M0 0h24v24H0V0z"/>
                                                            <path d="M18 16.08c-.76 0-1.44.3-1.96.77L8.91 12.7c.05-.23.09-.46.09-.7s-.04-.47-.09-.7l7.05-4.11c.54.5 1.25.81 2.04.81 1.66 0 3-1.34 3-3s-1.34-3-3-3-3 1.34-3 3c0 .24.04.47.09.7L8.04 9.81C7.5 9.31 6.79 9 6 9c-1.66 0-3 1.34-3 3s1.34 3 3 3c.79 0 1.5-.31 2.04-.81l7.12 4.16c-.05.21-.08.43-.08.65 0 1.61 1.31 2.92 2.92 2.92s2.92-1.31 2.92-2.92c0-1.61-1.31-2.92-2.92-2.92zM18 4c.55 0 1 .45 1 1s-.45 1-1 1-1-.45-1-1 .45-1 1-1zM6 13c-.55 0-1-.45-1-1s.45-1 1-1 1 .45 1 1-.45 1-1 1zm12 7.02c-.55 0-1-.45-1-1s.45-1 1-1 1 .45 1 1-.45 1-1 1z"/>
                                                        </svg>
                                                    </span>
                                                    <span class="text">Compartilhar</span>                                                    
                                                </div>
                                            </div>
                                        </div>
                                        
                                        <!--meta imovel-->
                                        <div class="boxCompartilhar d-none">
                                            <div class="container-compartilhar">
                                                <div class="row">
                                                    <div class="col-md-12">
                                                        <?php if ($preview??false){ ?>
                                                        <div class="container-alert">
                                                            <div class="row">
                                                                <div class="col-12 p-0">
                                                                    <div class="alert alert-danger pages-internas actAlert alert-dismissible fade show">
                                                                        <strong>Atenção:</strong> Disponível apenas após a publicação do anúncio.
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <?php }else{ ?>
                                                        <ul class="list-inline">
                                                            <li class="list-inline-item">
                                                                <a href="javascript: void(0);" onclick="window.open('https://www.facebook.com/sharer.php?u=<?php e($link); ?>','ventanacompartir', 'toolbar=0, status=0, width=520, height=450');">
                                                                    <div class="btn-comp btn-facebook">
                                                                        <i class="fa fa-facebook-official" aria-hidden="true"></i> Compartilhar
                                                                    </div>
                                                                </a>
                                                            </li>
                                                            <li class="list-inline-item">
                                                               <a href="javascript: void(0);" onclick="window.open('https://twitter.com/share?text=%20Gostei%20desse%20imóvel &amp;url=<?php e($link); ?>','ventanacompartir', 'toolbar=0, status=0, width=650, height=450');">
                                                                    <div class="btn-comp btn-twitter">
                                                                        <i class="fa fa-twitter" aria-hidden="true"></i> Tuitar
                                                                    </div>
                                                                </a>
                                                           </li>
                                                           <li class="list-inline-item">
                                                               <a href="https://api.whatsapp.com/send?text=Olá, veja este imóvel <?php e($link); ?>" target="_blank">
                                                                   <div class="btn-comp btn-whatsapp">
                                                                        <i class="fa fa-whatsapp" aria-hidden="true"></i> Whatsapp
                                                                    </div>
                                                                </a>
                                                           </li>
                                                           <li class="list-inline-item">
                                                                <div class="btn-comp btn-email act-compartilhar" data-url="<?php e($link); ?>">
                                                                    <i class="fa fa-envelope" aria-hidden="true"></i> E-mail
                                                                </div>
                                                           </li>
                                                        </ul>
                                                        <?php } ?>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-lg-12 p-0">
                    <div class="container-body-detalhes mt-60">
                        <div class="row d-flex justify-content-center m-0">
                            <!--content main-->
                            <div class="col-lg-6 col-md-6">
                                <div class="info-imovel">
                                    <div class="row">
                                        <div class="col-md-6 col-lg-6">
                                            <?php if($imovel->doc_perfil == "cpf"){ ?>
                                            <h1><?php e($imovel->bairro); ?></h1>
                                            <?php }else{ ?>
                                            <h1><?php e($imovel->dn_nome_nomefantasia); ?></h1>
                                            <?php } ?>
                                            <h4 class="mt-10"><strong>Endereço:</strong> <?php e($imovel->endereco); ?> <?php e($imovel->doc_perfil == "cpf" ? "" : ", ".$imovel->bairro); ?> </h4>
                                            <h4 class="mt-10"><strong>Tipo do imóvel:</strong> <?php e($imovel->tipo_imovel); ?></h4>
                                        </div>
                                        <div class="col-md-6 col-lg-6">
                                            <h3 class="valor-pretendido"><?php HValorPretendido::exibe($imovel->val_pretendido); ?></h3>
                                        </div>
                                    </div>
                                </div>
                                
                                <!--sidebar modile-->
                                <div class="d-block-767">
                                    <div class="row">
                                    <div class="col-md-12">
                                        <div class="sidebar-right">
                                            <div class="box">
                                                <?php if($imovel->doc_perfil == "cpf"){ ?>
                                                <div class="container-dono">
                                                    <div class="text m-0">Dono: <?php e(explode(" ", $imovel->dn_nome_nomefantasia)[0]); ?></div>
                                                </div>
                                                <?php }else{ ?>
                                                <div class="container-dono-pj">
                                                    <div class="row">
                                                        <div class="col-lg-12 text-center">
                                                            <a href="<?php e(base_url('lancamento/'.$imovel->id_imovel)); ?>">
                                                            <?php if ($imovel->dn_img != "") { ?>
                                                                <img src="<?php e($imovel->dn_img_uri.$imovel->dn_img); ?>" class="img-fluid" alt="<?php e($imovel->dn_nome_nomefantasia); ?>" >
                                                            <?php } ?>
                                                            </a>
                                                        </div>
                                                        <!--<div class="col-lg-12">
                                                            <p><?php e($imovel->dn_nome_nomefantasia); ?></p>
                                                        </div>-->
                                                    </div>
                                                </div>
                                                <?php } ?>
                                            </div>
                                            <div class="box">
                                                <div class="box-cta-imovel <?php e(($cadastro_user->id_cadastro??0) == $imovel->id_cadastro ? "disabled":"falarComdono"); ?>" data-unidade='<?php e(json_encode($imovelFalarComdono)); ?>' title="<?php e(($cadastro_user->id_cadastro??0) == $imovel->id_cadastro ? "Você é o dono deste imóvel":""); ?>">
                                                    <div class="ico">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24">
                                                            <path fill="none" d="M0 0h24v24H0V0z"/>
                                                            <path d="M4 4h16v12H5.17L4 17.17V4m0-2c-1.1 0-1.99.9-1.99 2L2 22l4-4h14c1.1 0 2-.9 2-2V4c0-1.1-.9-2-2-2H4zm2 10h8v2H6v-2zm0-3h12v2H6V9zm0-3h12v2H6V6z"/>
                                                        </svg>
                                                    </div>
                                                    <div class="text">Falar com o Dono</div>
                                                </div>
                                            </div>
                                            <?php if(($imovel->tipo_empreendimento??'') !== "lancamento"){ ?>
                                            <div class="box">
                                                <div class="box-simulador <?php e($preview??false ? "disabled":"simulaFinanciamento"); ?>">
                                                    <div class="ico">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24">
                                                            <path fill="none" d="M0 0h24v24H0V0z"></path>
                                                            <path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 18c-4.41 0-8-3.59-8-8s3.59-8 8-8 8 3.59 8 8-3.59 8-8 8zm.31-8.86c-1.77-.45-2.34-.94-2.34-1.67 0-.84.79-1.43 2.1-1.43 1.38 0 1.9.66 1.94 1.64h1.71c-.05-1.34-.87-2.57-2.49-2.97V5H10.9v1.69c-1.51.32-2.72 1.3-2.72 2.81 0 1.79 1.49 2.69 3.66 3.21 1.95.46 2.34 1.15 2.34 1.87 0 .53-.39 1.39-2.1 1.39-1.6 0-2.23-.72-2.32-1.64H8.04c.1 1.7 1.36 2.66 2.86 2.97V19h2.34v-1.67c1.52-.29 2.72-1.16 2.73-2.77-.01-2.2-1.9-2.96-3.66-3.42z"></path>
                                                        </svg>
                                                    </div>
                                                    <div class="text">Simular financiamento</div>
                                                </div>
                                            </div>
                                            <?php } ?>
                                            <div class="box">
                                                <h3>Mais informações</h3>
                                                <ul class="outras-infors">
                                                    <?php if ($imovel->val_condominio !== "0.00") { ?>
                                                    <li>Condomínio: <strong>R$ <?php e(number_format($imovel->val_condominio, 2, ',', '.')); ?>/mês</strong></li>
                                                    <?php } ?>
                                                    <?php if (($imovel->val_iptu !== "0.00")) { ?>
                                                    <li>IPTU: <strong>R$ <?php e(number_format($imovel->val_iptu, 2, ',', '.')); ?>/ano</strong></li>
                                                    <?php } ?>
                                                    <?php if ((!empty($imovel->imovel_canto) && $imovel->imovel_canto !== "Não")) { ?>
                                                    <li>Imóvel de canto: <strong><?php e($imovel->imovel_canto == 'Canto' ? 'Sim': 'Sim'); ?></strong></li>
                                                    <?php } ?>
                                                    <?php $visualizacoes = $contVisualizacoes??0; $negociacoes = $contNegociacoes??0; ?>
                                                    <?php if ($visualizacoes >= 1 || $negociacoes >= 1) { ?>
                                                    <?php e(($visualizacoes == 1) ? "<li>Total de Visualização: <strong>".$visualizacoes."</strong>":"" ) ?>
                                                    <?php e(($visualizacoes > 1) ? "<li>Total de Visualizações: <strong>".$visualizacoes."</strong>":"" ) ?>
                                                    <?php e(($negociacoes == 1) ? "<li>Negociação em andamento: <strong>".$negociacoes."</strong>":"" ) ?>
                                                    <?php e(($negociacoes > 1) ? "<li>Negociações em andamento: <strong>".$negociacoes."</strong>":"" ) ?>
                                                    <?php } ?>
                                                </ul>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                </div>
                                
                                <div class="detalhes-imovel <?php e($imovel->caracteristicas !== "" ? "m-0" : "pt-50"); ?>">
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="container-detalhes">
                                                <div class="row">
                                                    <?php  if($imovel->caracteristicas !== ""){ ?>
                                                    <div class="col-md-12">
                                                        <div id="container-descricao" class="container-descricao pt-50">
                                                            <h3>Descrição do imóvel</h3>
                                                            <div class="leia_mais" data-mrc>
                                                                <?php e($imovel->caracteristicas); ?>
                                                            </div>
                                                            <div class="box-control-more open-text"><a href="javascript:;">Leia mais sobre o imóvel <i class="material-icons">arrow_drop_down</i></a></div>
                                                            <div class="box-control-more close-text"><a href="#container-descricao" class="linkAnchor">Fechar <i class="material-icons">arrow_drop_up</i></a></div>
                                                        </div>
                                                        <hr>
                                                    </div>
                                                    <?php } if(!empty($arrayImovel)){ ?>
                                                    <div class="col-md-12">
                                                        <h3>Detalhes do imóvel</h3>
                                                        <div class="container-detalhes-info">
                                                            <div class="row">
                                                                <div class="col-lg-6">
                                                                    <div class="content-item">
                                                                        <span><img src="<?php e(base_url('assets/img/comdono/ico/imovel/imo-area_priv.png'))?>" class="" alt="Área privativa"></span>
                                                                        Área privativa <?php e($imovel->area_privativa); ?>M²
                                                                    </div>
                                                                </div>
                                                                <div class="col-lg-6">
                                                                    <div class="content-item">
                                                                        <span><img src="<?php e(base_url('assets/img/comdono/ico/imovel/imo-quartos.png'))?>" class="" alt="Quartos"></span>
                                                                        <?php if($imovel->quartos >= 2){ ?>
                                                                        <?php e($imovel->quartos) ?> Quartos
                                                                        <?php }else{ ?>
                                                                        <?php e($imovel->quartos) ?> Quarto
                                                                        <?php } ?>
                                                                    </div>
                                                                </div>
                                                                <div class="col-lg-6">
                                                                    <div class="content-item">
                                                                        <span><img src="<?php e(base_url('assets/img/comdono/ico/imovel/imo-vagas.png'))?>" class="" alt="Vagas na garagem"></span>
                                                                        <?php if($imovel->vaga >= 2){ ?>
                                                                        <?php e($imovel->vaga) ?> Vagas na garagem
                                                                        <?php }else{ ?>
                                                                        <?php e($imovel->vaga) ?> Vaga na garagem
                                                                        <?php } ?>
                                                                    </div>
                                                                </div>
                                                                <div class="col-lg-6">
                                                                    <div class="content-item">
                                                                        <span><img src="<?php e(base_url('assets/img/comdono/ico/imovel/imo-banheiros.png'))?>" class="" alt="Banheiros"></span>
                                                                        <?php if($imovel->banheiros >= 2){ ?>
                                                                        <?php e($imovel->banheiros) ?> Banheiros
                                                                        <?php }else{ ?>
                                                                        <?php e($imovel->banheiros) ?> Banheiro
                                                                        <?php } ?>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="row">
                                                                <div class="col-12">
                                                                    <div class="cta-detalhes act-detalhes-imovel">
                                                                        Mais detalhes do imóvel
                                                                        <i class="material-icons">control_point</i>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <?php e(!empty($arrayCondominio) || !empty($imoveisEndereco) || !empty($imoveisBairro) ? "<hr>" : ""); ?>
                                                    </div>
                                                    <?php } if (!empty($arrayCondominio)){ ?>
                                                    <div class="col-md-12">
                                                        <h3>Detalhes do condomínio</h3>
                                                        <div class="container-detalhes-info">
                                                            <div class="row">
                                                                <?php foreach (array_slice($arrayCondominio, 0, 4)  as $array){ ?>
                                                                <div class="col-lg-6">
                                                                    <div class="content-item">
                                                                        <img src="<?php e(base_url()); ?>assets/img/comdono/ico/condominio/<?php e($array['ico']); ?>" class="img-fluid" alt="<?php e($array['ico_name']);?>">
                                                                        <?php e($array['ico_name']);?>
                                                                    </div>
                                                                </div>
                                                                <?php } ?>
                                                            </div>
                                                            <?php if(count($arrayCondominio) > 4){ ?>
                                                            <div class="row">
                                                                <div class="col-12">
                                                                    <div class="cta-detalhes act-detalhes-condominio">
                                                                        Mais detalhes do condomínio
                                                                        <i class="material-icons">control_point</i>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <?php } ?>
                                                        </div>
                                                        <?php e(!empty($imoveisEndereco) || !empty($imoveisBairro) ? "<hr>" : ""); ?>
                                                    </div>
                                                    <?php } ?>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!--sidebar full-->
                            <div class="col-lg-3 col-md-6 d-none-767">
                                <div class="sidebar-right sticky-top">
                                    <div class="box">
                                        <?php if($imovel->doc_perfil == "cpf"){ ?>
                                        <div class="container-dono">
                                            <div class="text m-0">Dono: <?php e(explode(" ", $imovel->dn_nome_nomefantasia)[0]); ?></div>
                                        </div>
                                        <?php }else{ ?>
                                        <div class="container-dono-pj">
                                            <div class="row">
                                                <div class="col-lg-12 text-center">
                                                    <a href="<?php e(base_url('lancamento/'.$imovel->id_imovel)); ?>">
                                                    <?php if ($imovel->dn_img != "") { ?>
                                                        <img src="<?php e($imovel->dn_img_uri.$imovel->dn_img); ?>" class="img-fluid mb-10" alt="<?php e($imovel->dn_nome_nomefantasia); ?>" >
                                                    <?php } ?>
                                                    </a>
                                                </div>
                                                
                                                <!--<div class="col-lg-12">
                                                    <p><?php e($imovel->dn_nome_nomefantasia); ?></p>
                                                </div>-->
                                            </div>
                                        </div>
                                        <?php } ?>
                                    </div>
                                    <div class="box">
                                        <div class="box-cta-imovel <?php e(($cadastro_user->id_cadastro??0) == $imovel->id_cadastro ? "disabled":"falarComdono"); ?>" data-unidade='<?php e(json_encode($imovelFalarComdono)); ?>' title="<?php e(($cadastro_user->id_cadastro??0) == $imovel->id_cadastro ? "Você é o dono deste imóvel":""); ?>">
                                            <div class="ico">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24">
                                                    <path fill="none" d="M0 0h24v24H0V0z"/>
                                                    <path d="M4 4h16v12H5.17L4 17.17V4m0-2c-1.1 0-1.99.9-1.99 2L2 22l4-4h14c1.1 0 2-.9 2-2V4c0-1.1-.9-2-2-2H4zm2 10h8v2H6v-2zm0-3h12v2H6V9zm0-3h12v2H6V6z"/>
                                                </svg>
                                            </div>
                                            <div class="text">Falar com o Dono</div>
                                        </div>
                                    </div>
                                    <?php if(($imovel->tipo_empreendimento??'') != "lancamento"){ ?>
                                    <div class="box">
                                        <div class="box-simulador <?php e($preview??false ? "disabled":"simulaFinanciamento"); ?>">
                                            <div class="ico">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24">
                                                    <path fill="none" d="M0 0h24v24H0V0z"></path>
                                                    <path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 18c-4.41 0-8-3.59-8-8s3.59-8 8-8 8 3.59 8 8-3.59 8-8 8zm.31-8.86c-1.77-.45-2.34-.94-2.34-1.67 0-.84.79-1.43 2.1-1.43 1.38 0 1.9.66 1.94 1.64h1.71c-.05-1.34-.87-2.57-2.49-2.97V5H10.9v1.69c-1.51.32-2.72 1.3-2.72 2.81 0 1.79 1.49 2.69 3.66 3.21 1.95.46 2.34 1.15 2.34 1.87 0 .53-.39 1.39-2.1 1.39-1.6 0-2.23-.72-2.32-1.64H8.04c.1 1.7 1.36 2.66 2.86 2.97V19h2.34v-1.67c1.52-.29 2.72-1.16 2.73-2.77-.01-2.2-1.9-2.96-3.66-3.42z"></path>
                                                </svg>
                                            </div>
                                            <div class="text">Simular financiamento</div>
                                        </div>
                                    </div>
                                    <?php } ?>
                                    <div class="box">
                                        <h3>Mais informações</h3>
                                        <ul class="outras-infors">
                                            <?php if ($imovel->val_condominio !== "0.00") { ?>
                                            <li>Condomínio: <strong>R$ <?php e(number_format($imovel->val_condominio, 2, ',', '.')); ?>/mês</strong></li>
                                            <?php } ?>
                                            <?php if (($imovel->val_iptu !== "0.00")) { ?>
                                            <li>IPTU: <strong>R$ <?php e(number_format($imovel->val_iptu, 2, ',', '.')); ?>/ano</strong></li>
                                            <?php } ?>
                                            <?php if ((!empty($imovel->imovel_canto) && $imovel->imovel_canto !== "Não")) { ?>
                                            <li>Imóvel de canto: <strong><?php e($imovel->imovel_canto == 'Canto' ? 'Sim': 'Sim'); ?></strong></li>
                                            <?php } ?>
                                            <?php if ($visualizacoes >= 1 || $negociacoes >= 1) { ?>
                                            <?php e(($visualizacoes == 1) ? "<li>Total de Visualização: <strong>".$visualizacoes."</strong>":"" ) ?>
                                            <?php e(($visualizacoes > 1) ? "<li>Total de Visualizações: <strong>".$visualizacoes."</strong>":"" ) ?>
                                            <?php e(($negociacoes == 1) ? "<li>Negociação em andamento: <strong>".$negociacoes."</strong>":"" ) ?>
                                            <?php e(($negociacoes > 1) ? "<li>Negociações em andamento: <strong>".$negociacoes."</strong>":"" ) ?>
                                            <?php } ?>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php if (!empty($imoveisEndereco) || !empty($imoveisBairro)) {?>
            <div class="row">
                <div class="col-lg-12 p-0">
                    <div class="container-body-listas">
                        <?php if (!empty($imoveisEndereco)) {?>
                        <div class="row d-flex justify-content-center m-0">
                            <div class="col-lg-9">
                                <div class="title">
                                    <h3 class="m-0 mb-30">Mais nesta quadra</h3>
                                </div>
                            </div>
                        </div>
                        <div class="row d-flex justify-content-center m-0">
                            <div class="col-lg-9">
                                <div class="container-anuncios container-carousel">
                                    <div class="loading-img"><i class="fa fa-circle-o-notch fa-spin fa-3x fa-fw"></i></div>
                                    <div class="show-imgs">
                                        <div class="owl-carousel-imoveis owl-carousel owl-theme">
                                            <?php foreach ($imoveisEndereco as $quadra) { ?>
                                                <div class="box-anuncio">
                                                    <?php if($logado == true){ ?>
                                                    <div class="box-favoritos actFavoritos <?php e(isset($favoritos[$quadra->id_imovel]) ? 'btn_descurtir color_red' : 'btn_curtir color_grey'); ?>" title="<?php e(isset($favoritos[$quadra->id_imovel]) ? 'Remover dos favoritos' : 'Adicionar como favorito'); ?>" data-id="<?php e($quadra->id_imovel); ?>">
                                                    	<i class="fa fa-heart" aria-hidden="true"></i>
                                                    </div>
                                                    <?php }else{ ?>
                                                    <div class="box-favoritos color_grey openLogin" title="">
                                                        <i class="fa fa-heart" aria-hidden="true"></i>
                                                    </div>
                                                    <?php } ?>
                                                    <a href="<?php e(($quadra->lancamento=='Sim')?base_url('lancamento/'.$quadra->id_imovel):base_url('imovel/'.$quadra->id_imovel))?>">
                                                        
                                                        <?php if(($quadra->tipo_empreendimento??'') == "lancamento"){ ?>
                                                        <div class="box-flag">
                                                            <img src="<?php e(base_url('assets/img/comdono/icons/ico-flag-lancamento.png')); ?>" alt="Lançamento">
                                                        </div>
                                                        <?php } ?>
                                                        
                                                        <?php if(!empty($quadra->imagens)){ ?>
                                                        
                                                    	<div class="content-img grid" style="background-image: url('<?php HImg::med($quadra->imagens[0]); ?>');"></div>
                                                    	
                                                        <?php }else{ ?>
                                                    	<div class="no-image border-img content-img grid">
                                                    		<img src="<?php e(base_url('themes/comdono/img/no-image.png')); ?>" class="img-fluid" alt="Não há imagens">
                                                    	</div>
                                                        <?php } ?>
                                                        <div class="box">
                                                            <?php if($quadra->lancamento=='Sim'){ ?>
                                                                <div class="row m-0 mb-10">
                                                                    <div class="col-7 p-0">
                                                                    	<div class="valor m-0">
                                                                    	    <?php HValorPretendido::exibe($quadra->val_pretendido); ?>
                                                                        </div>
                                                                    </div>
                                                                    <?php if(($quadra->tipo_empreendimento??'') == "lancamento"){ ?>
                                                                    <div class="col-5 p-0 text-right">
                                                                        <div class="cta-lancamento">Lançamento</div>
                                                                    </div>
                                                                    <?php } ?>
                                                                </div>
                                                                <div class="empreendimento">
                                                                    <strong><?php e($quadra->dn_nome_nomefantasia); ?></strong>
                                                                </div>
                                                                <div class="endereco">
                                                                    <?php e($quadra->bairro) ?>
                                                                </div>
                                                            <?php }else{ ?>
                                                                <div class="valor m-0 mb-10">
                                                                    <?php e('R$ '.number_format($quadra->val_pretendido, 2, ',', '.')); ?>
                                                                </div>
                                                                <div class="endereco">
                                                                    <?php e($quadra->endereco) ?> <br/><?php e($quadra->bairro) ?>
                                                                </div>
                                                            <?php } ?>
                                                            <div class="detalhes">
                                                                <ul class="list-inline">
                                                                    <li class="list-inline-item"><?php e($quadra->area_privativa) ?>m²</li>
                                                                    <?php if($quadra->quartos >=1 ){ ?>
                                                                    <li class="list-inline-item"> <span>|</span> <?php e($quadra->quartos) ?> Quarto(s)</li>
                                                                    <?php } ?>
                                                                    <?php if($quadra->suites >=1 ){ ?>
                                                                    <li class="list-inline-item"> <span>|</span> <?php e($quadra->suites) ?> Suite(s)</li>
                                                                    <?php } ?>
                                                                </ul>
                                                            </div>
                                                        </div>
                                                     </a>
                                                </div>
                                            <?php } ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php } if (!empty($imoveisBairro)) {?>
                        <div class="row d-flex justify-content-center m-0">
                            <div class="col-lg-9">
                                <div class="title">
                                    <h3>Mais neste bairro</h3>
                                </div>
                            </div>
                        </div>
                        <div class="row d-flex justify-content-center m-0">
                            <div class="col-lg-9">
                                <div class="container-anuncios container-carousel">
                                    <div class="loading-img"><i class="fa fa-circle-o-notch fa-spin fa-3x fa-fw"></i></div>
                                    <div class="show-imgs">
                                        <div class="owl-carousel-imoveis owl-carousel owl-theme">
                                            <?php foreach ($imoveisBairro as $bairro) { ?>
                                                <div class="box-anuncio">
                                                    <?php if($logado == true){ ?>
                                                    <div class="box-favoritos actFavoritos <?php e(isset($favoritos[$bairro->id_imovel]) ? 'btn_descurtir color_red' : 'btn_curtir color_grey'); ?>" title="<?php e(isset($favoritos[$bairro->id_imovel]) ? 'Remover dos favoritos' : 'Adicionar como favorito'); ?>" data-id="<?php e($bairro->id_imovel); ?>">
                                                    	<i class="fa fa-heart" aria-hidden="true"></i>
                                                    </div>
                                                    <?php }else{ ?>
                                                    <div class="box-favoritos color_grey openLogin" title="">
                                                        <i class="fa fa-heart" aria-hidden="true"></i>
                                                    </div>
                                                    <?php } ?>
                                                    <a href="<?php e(($bairro->lancamento=='Sim')?base_url('lancamento/'.$bairro->id_imovel):base_url('imovel/'.$bairro->id_imovel))?>">
                                                        
                                                        <?php if(($bairro->tipo_empreendimento??'') == "lancamento"){ ?>
                                                        <div class="box-flag">
                                                            <img src="<?php e(base_url('assets/img/comdono/icons/ico-flag-lancamento.png')); ?>" alt="Lançamento">
                                                        </div>
                                                        <?php } ?>
                                                        
                                                        <?php if(!empty($bairro->imagens)){ ?>
                                                    	
                                                    		<div class="content-img grid" style="background-image: url('<?php HImg::med($bairro->imagens[0]); ?>');"></div>
                                                    	
                                                        <?php }else{ ?>
                                                    	<div class="no-image border-img content-img grid">
                                                    		<img src="<?php e(base_url('themes/comdono/img/no-image.png')); ?>" class="img-fluid" alt="Não há imagens">
                                                    	</div>
                                                        <?php } ?>
                                                        
                                                        
                                                        <div class="box">
                                                            <?php if($bairro->lancamento=='Sim'){ ?>
                                                                <div class="row m-0 mb-10">
                                                                    <div class="col-7 p-0">
                                                                    	<div class="valor m-0">
                                                                    	     <?php HValorPretendido::exibe($bairro->val_pretendido); ?>
                                                                        </div>
                                                                    </div>
                                                                    <?php if(($bairro->tipo_empreendimento??'') == "lancamento"){ ?>
                                                                    <div class="col-5 p-0 text-right">
                                                                        <div class="cta-lancamento">Lançamento</div>
                                                                    </div>
                                                                    <?php } ?>
                                                                </div>
                                                                <div class="empreendimento">
                                                                    <strong><?php e($bairro->dn_nome_nomefantasia); ?></strong>
                                                                </div>
                                                                <div class="endereco">
                                                                    <?php e($bairro->bairro) ?>
                                                                </div>
                                                            <?php }else{ ?>
                                                                <div class="valor m-0 mb-10">
                                                                    <?php e('R$ '.number_format($bairro->val_pretendido, 2, ',', '.')); ?>
                                                                </div>
                                                                <div class="endereco">
                                                                    <?php e($bairro->endereco) ?> <br/><?php e($bairro->bairro) ?>
                                                                </div>
                                                            <?php } ?>
                                                            <div class="detalhes">
                                                                <ul class="list-inline">
                                                                    <li class="list-inline-item"><?php e($bairro->area_privativa) ?>m²</li>
                                                                    <?php if($bairro->quartos >=1 ){ ?>
                                                                    <li class="list-inline-item"> <span>|</span> <?php e($bairro->quartos) ?> Quarto(s)</li>
                                                                    <?php } ?>
                                                                    <?php if($bairro->suites >=1 ){ ?>
                                                                    <li class="list-inline-item"> <span>|</span> <?php e($bairro->suites) ?> Suite(s)</li>
                                                                    <?php } ?>
                                                                </ul>
                                                            </div>
                                                        </div>
                                                    </a>
                                                </div>
                                            <?php } ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php } ?>
                    </div>
                </div>
            </div>
            <?php } ?>
        </div>
    </div>
</div>
<?php if ($preview??false){ ?>
</div>
<?php } ?>
<input type="hidden" name="id_imovel" class="form-control" id="id_imovel" value="<?php e($imovel->id_imovel); ?>" >
<script async defer src="https://maps.googleapis.com/maps/api/js?key=AIzaSyAOAGU-4BBR5aS8X31cflK-7bp43EpHXsI"> </script>