<input type="hidden" name="id_imovel" value="<?php e($imovel->id_imovel); ?>">
<div id="toTop" class="container-page-lp page-elleven">
    
    <div class="row container-header">
        <div class="col-md-6 offset-lg-1 col-lg-5 d-none-767">
            <div class="container-v-align">
                <div class="v-align">
                    <div class="box-info-header">
                        <div class="logo mt-5 mb-5">
                            <img src="https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/liberty/images/logo-attos.png">
                        </div>
                        <div class="title mb-5">
                            <h1>
                                Apresenta:
                                <br>O Liberty Lago Norte
                            </h1>
                            <h3>
                                <strong>Imóveis prontos e vendas com condições especiais</strong>!<br>
                                Lazer, qualidade de vida e segurança, <br>
                                localizado ao lado do Shopping Iguatemi.
                            </h3>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-6 col-lg-6 p-0">
            <div class="container-banner p-0">
                <video width="100%" height="100%" playsinline autoplay loop muted>
                    <source src="https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/liberty/videos/liberty-sobre.mp4" type="video/mp4">
                </video>
            </div>
            <div class="container-header-mobile">
                <div class="container-v-align">
                    <div class="v-align">
                        <div class="box-info-header">
                            <div class="logo mb-5"><img src="https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/liberty/images/logo-attos-white1.png"></div>
                            <div class="title">
                                <h1>
                                    O grupo Attos apresenta
                                    <br>O Liberty Lago Norte
                                </h1>
                                <h3>
                                    <strong>Imóveis prontos e vendas com condições especiais</strong>!<br>
                                    Lazer, qualidade de vida e segurança, <br>
                                    localizado ao lado do Shopping Iguatemi.
                                </h3>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-----------INI Visualizar como admin-------------->
    <?php if ($navAdmin??false){ ?>
    <div class="container-alert">
        <div class="row">
            <div class="col-12 p-0">
                <div class="alert <?php e(HImovel::getStatus($imovel->status_lancamento)->bg); ?> alert-effect">
                    <strong>Status: <?php e(HImovel::getStatus($imovel->status_lancamento)->text); ?>.</strong> Visualização apenas para o dono e administradores.
                </div>
            </div>
        </div>
    </div>
    <?php } ?>
    <!-----------END Visualizar como admin-------------->   
    
    <div id="section-cta" class="row d-flex justify-content-center sticky-top">
        <div class="col-lg-12">Compre uma unidade e ganhe uma <span><strong>TV de 68 polegadas</strong>! <a href="javascript:;" class="selecionar-unidade">Clique aqui <i class="fa fa-chevron-down"></i></a></span></div>
    </div>
    
    <?php if($imovel->caracteristicas !== ""){ ?>
    <div id="sobre" class="row d-flex justify-content-center section-page">
        <div class="col-md-12 col-lg-9">
            <div class="row">
                <div class="col-md-6 col-lg-6">
                    <div class="title">
                        <img src="https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/liberty/images/logo.jpg">
                        <h2 class="text-left mt-5 mb-5 ">Lago Norte, segurança, conforto e lazer perto de você</h2>
                    </div> 
                    <div class="leia_mais" data-mrc>
                        <?php e($imovel->caracteristicas); ?>
                    </div>                     
                    <div class="box-control-more open-text"><a href="javascript:;">Saiba mais <i class="material-icons">arrow_drop_down</i></a></div>
                    <div class="box-control-more close-text"><a href="#sobre" class="linkAnchor">Fechar <i class="material-icons">arrow_drop_up</i></a></div>
                </div>
                <div class="col-md-6 offset-lg-1 col-lg-5">
                    <p>Unidade decorada</p>
                    <div class="container-img-bg loading-img border-img"><i class="fa fa-circle-o-notch fa-spin fa-3x fa-fw"></i></div>
                    <div class="show-imgs">
                        <div class="container-carousel">
                            <div class="owl-carousel-images owl-carousel owl-theme">
                                <a data-fancybox="images" href="https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/liberty/images/galeria/1-predio.png">
                                    <div class="container-img-bg" style="background-image: url('https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/liberty/images/galeria/1-predio.png');"></div>
                                </a>
                                <a data-fancybox="images" href="https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/liberty/images/galeria/2-sala-cozinha.jpg">
                                    <div class="container-img-bg" style="background-image: url('https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/liberty/images/galeria/2-sala-cozinha.jpg');"></div>
                                </a>
                                <a data-fancybox="images" href="https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/liberty/images/galeria/3-area-servico.jpg">
                                    <div class="container-img-bg" style="background-image: url('https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/liberty/images/galeria/3-area-servico.jpg');"></div>
                                </a>
                                <a data-fancybox="images" href="https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/liberty/images/galeria/4-cozinha.jpg">
                                    <div class="container-img-bg" style="background-image: url('https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/liberty/images/galeria/4-cozinha.jpg');"></div>
                                </a>
                                <a data-fancybox="images" href="https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/liberty/images/galeria/5-home-theater.jpg">
                                    <div class="container-img-bg" style="background-image: url('https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/liberty/images/galeria/5-home-theater.jpg');"></div>
                                </a>
                                <a data-fancybox="images" href="https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/liberty/images/galeria/6-para-trabalhar.jpg">
                                    <div class="container-img-bg" style="background-image: url('https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/liberty/images/galeria/6-para-trabalhar.jpg');"></div>
                                </a>
                                <a data-fancybox="images" href="https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/liberty/images/galeria/7-sala.jpg">
                                    <div class="container-img-bg" style="background-image: url('https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/liberty/images/galeria/7-sala.jpg');"></div>
                                </a>
                                <a data-fancybox="images" href="https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/liberty/images/galeria/8-quarto.jpg">
                                    <div class="container-img-bg" style="background-image: url('https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/liberty/images/galeria/8-quarto.jpg');"></div>
                                </a>
                                <a data-fancybox="images" href="https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/liberty/images/galeria/9-quarto-casal.jpg">
                                    <div class="container-img-bg" style="background-image: url('https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/liberty/images/galeria/9-quarto-casal.jpg');"></div>
                                </a>
                                <a data-fancybox="images" href="https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/liberty/images/galeria/10-banheiro.jpg">
                                    <div class="container-img-bg" style="background-image: url('https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/liberty/images/galeria/10-banheiro.jpg');"></div>
                                </a>
                                <a data-fancybox="images" href="https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/liberty/images/galeria/11-duplex.jpg">
                                    <div class="container-img-bg" style="background-image: url('https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/liberty/images/galeria/11-duplex.jpg');"></div>
                                </a>
                            </div>
                        </div>
                    </div> 
                    <div class="container-img d-none-767"><img src="https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/liberty/images/sobre-liberty.png" class="img-fluid"></div>
                </div>
            </div>
        </div>
    </div>
    <?php } ?>
    
    <div id="section-unidades" class="row d-flex justify-content-center section-page">
        <div class="col-lg-9">
            <div class="title">
                <h2 class="mb-2">Preço válido apenas para estas unidades</h2>
                <h3 class="text-center mb-4">Faça uma visita sem compromisso</h3>
            </div>
            <div class="row">
                <div class="col-md-4 col-lg-4">
                    <div class="box-produto">
                        <div class="box-img loading-img border-img"><i class="fa fa-circle-o-notch fa-spin fa-3x fa-fw"></i></div>
                        <div class="show-imgs">
                            <div class="container-carousel">
                                <div class="owl-carousel-unidades owl-carousel owl-theme">
                                    <a data-fancybox="images" href="https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/liberty/images/unidades/unidade1/image4.jpg">
                                        <div class="box-img" style="background-image: url('https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/liberty/images/unidades/unidade1/image4.jpg');"></div>
                                    </a>
                                    
                                    <a data-fancybox="images" href="https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/liberty/images/unidades/unidade1/image1.jpg">
                                        <div class="box-img" style="background-image: url('https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/liberty/images/unidades/unidade1/image1.jpg');"></div>
                                    </a>
                                    <a data-fancybox="images" href="https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/liberty/images/unidades/unidade1/image2.jpg">
                                        <div class="box-img" style="background-image: url('https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/liberty/images/unidades/unidade1/image2.jpg');"></div>
                                    </a>
                                    <a data-fancybox="images" href="https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/liberty/images/unidades/unidade1/image3.jpg">
                                        <div class="box-img" style="background-image: url('https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/liberty/images/unidades/unidade1/image3.jpg');"></div>
                                    </a>
                                </div>
                            </div>
                        </div>
                        <!--<div class="box-img box-reservado reservado1">Reservado</div>-->
                        <div class="box-title">Unidade 115 Torre 2<br>25,21m²</div>
                        <div class="box-info">entrada mais prestações<br>de <strong>R$ 1.493,97</strong></div>
                        <div class="box-cta"><button type="button" class="btn btn-primary w-auto actReservar addToCart" data-tipo="Unidade 115 Torre 2 - 25,21m²" data-unidade="1">Visitar</button></div>
                    </div>
                </div>
                <div class="col-md-4 col-lg-4">
                    <div class="box-produto">
                        <div class="box-img loading-img border-img"><i class="fa fa-circle-o-notch fa-spin fa-3x fa-fw"></i></div>
                        <div class="show-imgs">
                            <div class="container-carousel">
                                <div class="owl-carousel-unidades owl-carousel owl-theme">
                                    <a data-fancybox="images" href="https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/liberty/images/unidades/unidade2/image4.jpg">
                                        <div class="box-img" style="background-image: url('https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/liberty/images/unidades/unidade2/image4.jpg');"></div>
                                    </a>
                                    <a data-fancybox="images" href="https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/liberty/images/unidades/unidade2/image5.jpg">
                                        <div class="box-img" style="background-image: url('https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/liberty/images/unidades/unidade2/image5.jpg');"></div>
                                    </a>
                                    <a data-fancybox="images" href="https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/liberty/images/unidades/unidade2/image1.jpg">
                                        <div class="box-img" style="background-image: url('https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/liberty/images/unidades/unidade2/image1.jpg');"></div>
                                    </a>
                                    <a data-fancybox="images" href="https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/liberty/images/unidades/unidade2/image2.jpg">
                                        <div class="box-img" style="background-image: url('https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/liberty/images/unidades/unidade2/image2.jpg');"></div>
                                    </a>
                                    <a data-fancybox="images" href="https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/liberty/images/unidades/unidade2/image3.jpg">
                                        <div class="box-img" style="background-image: url('https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/liberty/images/unidades/unidade2/image3.jpg');"></div>
                                    </a>
                                </div>
                            </div>
                        </div>
                        <!--<div class="box-img box-reservado reservado2 bg-vendido d-block">Vendido</div>-->
                        <div class="box-title">Unidade 008 Torre 1<br>53,43m²</div>
                        <div class="box-info">entrada mais prestações<br>de <strong>R$ 2.632,18</strong></div>
                        <div class="box-cta h-custom"><button type="button" class="btn btn-primary w-auto actReservar addToCart" data-tipo="Unidade 008 Torre 1 - 53,43m²" data-unidade="2">Visitar</button></div>
                    </div>
                </div>
                <div class="col-md-4 col-lg-4">
                    <div class="box-produto">
                        <div class="box-img loading-img border-img"><i class="fa fa-circle-o-notch fa-spin fa-3x fa-fw"></i></div>
                        <div class="show-imgs">
                            <div class="container-carousel">
                                <div class="owl-carousel-unidades owl-carousel owl-theme">
                                    <a data-fancybox="images" href="https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/liberty/images/unidades/unidade3/image4.jpg">
                                        <div class="box-img" style="background-image: url('https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/liberty/images/unidades/unidade3/image4.jpg');"></div>
                                    </a>
                                    <a data-fancybox="images" href="https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/liberty/images/unidades/unidade3/image5.jpg">
                                        <div class="box-img" style="background-image: url('https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/liberty/images/unidades/unidade3/image5.jpg');"></div>
                                    </a>
                                    <a data-fancybox="images" href="https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/liberty/images/unidades/unidade3/image1.jpg">
                                        <div class="box-img" style="background-image: url('https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/liberty/images/unidades/unidade3/image1.jpg');"></div>
                                    </a>
                                    <a data-fancybox="images" href="https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/liberty/images/unidades/unidade3/image2.jpg">
                                        <div class="box-img" style="background-image: url('https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/liberty/images/unidades/unidade3/image2.jpg');"></div>
                                    </a>
                                    <a data-fancybox="images" href="https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/liberty/images/unidades/unidade3/image3.jpg">
                                        <div class="box-img" style="background-image: url('https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/liberty/images/unidades/unidade3/image3.jpg');"></div>
                                    </a>
                                </div>
                            </div>
                        </div>
                        <!--<div class="box-img box-reservado reservado3">Reservado</div>-->
                        <div class="box-title">Unidade 213 Torre 2<br>55,95m²</div>
                        <div class="box-info">entrada mais prestações<br>de <strong>R$ 2.828,07</strong></div>
                        <div class="box-cta"><button type="button" class="btn btn-primary w-auto actReservar addToCart" data-tipo="Unidade 213 Torre 2 - 55,95m²" data-unidade="3">Visitar</button></div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div id="section-diferenciais" class="row d-flex justify-content-center section-page">
        <div class="col-md-12 col-lg-9 text-center">
            <div class="title">
                <h2>Se imagine morando no<br>Lago Norte com:</h2>
            </div>
            <div class="d-none-767">
                <div class="row">
                    <div class="col-md-4 border-right">
                        <div class="box-diferenciais">
                            
                            <div class="box-ico"><img src="https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/liberty/icons/condominio-fechado.svg"></div>
                            <div class="box-title">Condomínio<br>fechado</div>
                            <div class="box-info">Segurança e<br>tranquilidade garantidas</div>
                        </div>
                    </div>
                    <div class="col-md-4 border-right">
                         <div class="box-diferenciais">
                            <div class="box-ico"><img src="https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/liberty/icons/shopping.svg"></div>
                            <div class="box-title">Próximo ao<br>shopping</div>
                            <div class="box-info">Conveniência e Lazer<br>perto de você</div>
                        </div>
                    </div>
                    <div class="col-md-4">
                         <div class="box-diferenciais">
                            <div class="box-ico"><img src="https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/liberty/icons/localizacao-privilegiada.svg"></div>
                            <div class="box-title">Localização<br>privilegiada</div>
                            <div class="box-info">Praticidade e<br>qualidade de vida</div>
                        </div>
                    </div>
                </div>
                <div class="row section-page">
                    <div class="col-md-4 border-right">
                         <div class="box-diferenciais text-center">
                            <div class="box-ico"><img src="https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/liberty/icons/jardim-externo.svg"></div>
                            <div class="box-title">Jardim externo</div>
                            <div class="box-info">Espaços amplos com<br>calçadas em pedra portuguesa</div>
                        </div>
                    </div>
                    <div class="col-md-4 border-right">
                         <div class="box-diferenciais text-center">
                            <div class="box-ico"><img src="https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/liberty/icons/rede-wireless.svg"></div>
                            <div class="box-title">Rede wireless</div>
                            <div class="box-info">Cobertura em toda<br>a área do prédio</div>
                        </div>
                    </div>                
                    <div class="col-md-4">
                         <div class="box-diferenciais text-center">
                            <div class="box-ico"><img src="https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/liberty/icons/2-vagas.svg"></div>
                            <div class="box-title">Vaga na garagem</div>
                            <div class="box-info">Mais conforto e<br>facilidade para você</div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="d-block-767">
                <div class="row">
                    <div class="col-6 border-right">
                        <div class="box-diferenciais">
                            <div class="box-ico"><img src="https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/liberty/icons/condominio-fechado.svg"></div>
                            <div class="box-title">Condomínio<br>fechado</div>
                            <div class="box-info">Segurança e<br>tranquilidade garantidas</div>
                        </div>
                    </div>
                    <div class="col-6">
                         <div class="box-diferenciais">
                            <div class="box-ico"><img src="https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/liberty/icons/shopping.svg"></div>
                            <div class="box-title">Próximo ao<br>shopping</div>
                            <div class="box-info">Conveniência e Lazer<br>perto de você</div>
                        </div>
                    </div>
                    <div class="col-6 border-right mt-30">
                         <div class="box-diferenciais">
                            <div class="box-ico"><img src="https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/liberty/icons/localizacao-privilegiada.svg"></div>
                            <div class="box-title">Localização<br>privilegiada</div>
                            <div class="box-info">Praticidade e<br>qualidade de vida</div>
                        </div>
                    </div>
                    <div class="col-6 mt-30">
                         <div class="box-diferenciais text-center">
                            <div class="box-ico"><img src="https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/liberty/icons/jardim-externo.svg"></div>
                            <div class="box-title">Jardim externo</div>
                            <div class="box-info">Espaços amplos com<br>calçadas em pedra portuguesa</div>
                        </div>
                    </div>
                    <div class="col-6 border-right mt-30">
                         <div class="box-diferenciais text-center">
                            <div class="box-ico"><img src="https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/liberty/icons/rede-wireless.svg"></div>
                            <div class="box-title">Rede wireless</div>
                            <div class="box-info">Cobertura em toda<br>a área do prédio</div>
                        </div>
                    </div>
                    <div class="col-6  mt-30">
                         <div class="box-diferenciais text-center">
                            <div class="box-ico"><img src="https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/liberty/icons/2-vagas.svg"></div>
                            <div class="box-title">Vaga na garagem</div>
                            <div class="box-info">Mais conforto e<br>facilidade para você</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div id="localizacao" class="row d-flex justify-content-center section-page">
        <div class="col-md-12 col-lg-9">
            <div class="row">
                <div class="col-lg-12">
                    <div class="title mb-5">
                        <h2 class="text-left m-0">Localização</h2>
                    </div>
                    <iframe src="https://maps.google.com/maps?q=<?php e($imovel->latitude)?>,<?php e($imovel->longitude)?>&hl=es;z=14&amp;output=embed" width="100%" height="600" frameborder="0" style="border:0; border-radius: 4px" allowfullscreen></iframe>
                </div>
            </div>
        </div>
    </div>
    
    <div id="section-contato" class="row d-flex justify-content-center">
        <div class="col-lg-12">
            <div class="row d-flex justify-content-center">
                <div class="col-lg-9">
                    <div class="row">
                        <div class="col-md-6 col-lg-7">
                            <div class="title">
                                <h2 class="m-0">Falta pouco para confirmar sua visita </h2>
                                <h3 class="mt-2 mb-4 color-white">Isso não gera obrigação de compra</h3>
                            </div>
                            <p class="m-0">
                                Ao se cadastrar abaixo você receberá seu <strong>Código Vip</strong> digital. Confirme o código ao agendar uma visita e, ao efetuar a compra você receberá a chave do <strong>seu novo imóvel</strong> com uma <strong>TV de 68 polegadas</strong>! Todos os passos serão realizados dentro do site para que você tenha toda tranquilidade, comodidade e segurança.
                            </p>
                            <div class="row">
                                <div class="col-lg-8">
                                    <form id="formCaptura" action="" method="post" autocomplete="off">
                                        <div class="form-group mt-5 mb-5">
                                            <div class="box-selecione">
                                                <span class="selecionar">Selecione uma unidade <i class="material-icons">arrow_upward</i></span>
                                                <span class="selecionado d-none">Visitar: <span class="value-reserva"></span> <i class="material-icons icon-close">close</i></span>
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <label>Unidade*</label>
                                            <input type="text" name="tipo_imovel" class="form-control selecionar-unidade" placeholder="Sua unidade preferida" required="required" readonly="readonly">
                                        </div>
                                        <div class="form-group">
                                            <label>Nome completo*</label>
                                            <input type="text" name="nome" class="form-control" placeholder="Nome" required="required">
                                            <input type="hidden" name="origem" value="<?php e($origem)?>">
                                            <input type="hidden" name="link" value="<?php e($link)?>">
                                            <input type="hidden" name="endereco" value="https://maps.google.com/maps?q=<?php e($imovel->latitude)?>,<?php e($imovel->longitude)?>&hl=es;z=14&amp;output=embed">
                                            <input type="hidden" name="area_total" value="">
                                        </div>
                                        <div class="form-group">
                                            <label>Seu melhor e-mail*</label>
                                            <input type="email" name="email" class="form-control" placeholder="exemplo@email.com" required="required">
                                        </div>
                                        <div class="form-group mt-30">
                                            <label>Telefone/Whatsapp*</label>
                                            <input type="text" name="telefone" class="form-control celular" placeholder="Seu whatsapp" required="required">
                                        </div>
                                        <div class="form-group mt-30">
                                            <div class="row">
                                                <div class="col-lg-5"><label class="campos-obrigatorios">*Campos obrigatórios</label></div>
                                                <div class="col-lg-7 text-right">
                                                    <button type="submit" class="btn btn-primary btn-enviar">Cadastrar</button>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="content_result"></div>
                                    </form>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6 col-lg-5 text-center d-none-767">
                            <img src="https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/liberty/images/cartao-comdono.png">
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div id="section-footer" class="row d-flex justify-content-center">
        <div class="col-lg-12">
            <div class="row d-flex justify-content-center">
                <div class="col-lg-9 text-center">
                    <div class="item">
                        Imóvel 100% concluído, imagens reais. Promoção não cumulativa<br/>
                        nem transferível. Condições especiais devem ser consultadas.
                    </div>
                    <div class="item m-0" style="font-size: 12px;">
                        CNPJ: <?php e($imovel->dn_cpf_cnpj); ?> - <?php e($imovel->endereco." ".$imovel->numero." ".$imovel->bairro); ?>, Brasília-DF - <?php e($imovel->cep); ?> - Incorporadora Grupo Attos
                    </div>
                    <div class="mt-4">Powered by <a href="<?php e(base_url()); ?>"><img src="<?php e(base_url()); ?>assets/img/comdono/logo-white-full.png"></a></div>
                </div>
            </div>
        </div>
    </div>
</div>