<input type="hidden" name="id_imovel" value="<?php e($imovel->id_imovel); ?>">
<div id="toTop" class="container-page-lp page-elleven">
    
    <div class="row container-header">
        <div class="col-md-6 offset-lg-1 col-lg-5 d-none-767">
            <div class="container-v-align">
                <div class="v-align">
                    <div class="box-info-header">
                        <div class="logo mt-5 mb-5">
                            <img src="https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/exclusive-park-sul/images/logo-faenge.png">
                        </div>
                        <div class="title mb-5">
                            <h1>
                                Apresenta:
                                <br>O Exclusive Park Sul
                            </h1>
                            <h3>
                                Sustentabilidade, acessibilidade e inovação:<br>
                                o Exclusive Park Sul é o primeiro empreendimento<br>
                                da região com o conceito de arquitetura de integração.<br>
                                O que há de mais moderno com conforto, lazer, praticidade e segurança.
                            </h3>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-6 col-lg-6 p-0">
            <div class="container-banner p-0">
                <video width="100%" height="100%" playsinline autoplay loop muted>
                    <source src="https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/liberty/videos/liberty-sobre.mp4" type="video/mp4">
                </video>
            </div>
            <div class="container-header-mobile">
                <div class="container-v-align">
                    <div class="v-align">
                        <div class="box-info-header">
                            <div class="logo mb-5"><img src="https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/exclusive-park-sul/images/logo-faenge.png"></div>
                            <div class="title">
                                <h1>
                                    Apresenta:
                                    <br>O Exclusive Park Sul
                                </h1>
                                <h3>
                                    Sustentabilidade, acessibilidade e inovação:<br>
                                    o Exclusive Park Sul é o primeiro empreendimento<br>
                                    da região com o conceito de arquitetura de integração.<br>
                                    O que há de mais moderno com conforto, lazer, praticidade e segurança.
                                </h3>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-----------INI Visualizar como admin-------------->
    <?php if ($navAdmin??false){ ?>
    <div class="container-alert">
        <div class="row">
            <div class="col-12 p-0">
                <div class="alert <?php e(HImovel::getStatus($imovel->status_lancamento)->bg); ?> alert-effect">
                    <strong>Status: <?php e(HImovel::getStatus($imovel->status_lancamento)->text); ?>.</strong> Visualização apenas para o dono e administradores.
                </div>
            </div>
        </div>
    </div>
    <?php } ?>
        
    <div id="section-cta" class="row d-flex justify-content-center sticky-top">
        <div class="col-lg-12">Compre uma unidade e ganhe uma <strong class="color-red">Geladeira</strong>! <a href="#section-unidades" class="linkAnchor">Clique aqui <i class="fa fa-chevron-down"></i></a></div>
    </div>
    
    <?php if($imovel->caracteristicas !== ""){ ?>
    <div id="sobre" class="row d-flex justify-content-center section-page">
        <div class="col-md-12 col-lg-9">
            <div class="row">
                <div class="col-md-6 col-lg-6">
                    <div class="title">
                        <img src="https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/exclusive-park-sul/images/logo-exclusive.jpg">
                        <h2 class="text-left mt-5 mb-5 ">Sustentabilidade, acessibilidade e inovação no Park Sul</h2>
                    </div> 
                    
                    <p>O Exclusive Park Sul foi pensado para ganhar tempo e qualidade de vida. Aqui, a inovação contribui com a sua locomoção e com o planeta. De apartamentos adaptáveis, desenvolvidos com base nas necessidades dos PNE’s, a uso de aquecimento solar. Conheça mais dos nossos diferenciais. O projeto que vai integrar sustentabilidade, acessibilidade e inovação em unidades residenciais e comerciais. Vagas verdes, aquecimento solar, facilidades na locomoção e muito mais. No Exclusive Park Sul, você encontra uma localização privilegiada com o que há de melhor em lazer, conforto e segurança.</p>
                </div>
                <div class="col-md-6 offset-lg-1 col-lg-5">
                    <p>Imagens ilustrativas</p>
                    <div class="container-img-bg loading-img border-img"><i class="fa fa-circle-o-notch fa-spin fa-3x fa-fw"></i></div>
                    <div class="show-imgs">
                        <div class="container-carousel">
                            <div class="owl-carousel-images owl-carousel owl-theme">
                                <a data-fancybox="images" href="https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/exclusive-park-sul/galeria/image1.jpg">
                                    <div class="container-img-bg" style="background-image: url('https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/exclusive-park-sul/galeria/image1.jpg');"></div>
                                </a>
                                <a data-fancybox="images" href="https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/exclusive-park-sul/galeria/image2.jpg">
                                    <div class="container-img-bg" style="background-image: url('https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/exclusive-park-sul/galeria/image2.jpg');"></div>
                                </a>
                                <a data-fancybox="images" href="https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/exclusive-park-sul/galeria/image3.jpg">
                                    <div class="container-img-bg" style="background-image: url('https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/exclusive-park-sul/galeria/image3.jpg');"></div>
                                </a>
                                <a data-fancybox="images" href="https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/exclusive-park-sul/galeria/image4.jpg">
                                    <div class="container-img-bg" style="background-image: url('https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/exclusive-park-sul/galeria/image4.jpg');"></div>
                                </a>
                                <a data-fancybox="images" href="https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/exclusive-park-sul/galeria/image5.jpg">
                                    <div class="container-img-bg" style="background-image: url('https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/exclusive-park-sul/galeria/image5.jpg');"></div>
                                </a>
                                <a data-fancybox="images" href="https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/exclusive-park-sul/galeria/image6.jpg">
                                    <div class="container-img-bg" style="background-image: url('https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/exclusive-park-sul/galeria/image6.jpg');"></div>
                                </a>
                                <a data-fancybox="images" href="https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/exclusive-park-sul/galeria/image7.jpg">
                                    <div class="container-img-bg" style="background-image: url('https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/exclusive-park-sul/galeria/image7.jpg');"></div>
                                </a>
                                <a data-fancybox="images" href="https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/exclusive-park-sul/galeria/image8.jpg">
                                    <div class="container-img-bg" style="background-image: url('https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/exclusive-park-sul/galeria/image8.jpg');"></div>
                                </a>
                                <a data-fancybox="images" href="https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/exclusive-park-sul/galeria/image9.jpg">
                                    <div class="container-img-bg" style="background-image: url('https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/exclusive-park-sul/galeria/image9.jpg');"></div>
                                </a>
                                <a data-fancybox="images" href="https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/exclusive-park-sul/galeria/image10.jpg">
                                    <div class="container-img-bg" style="background-image: url('https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/exclusive-park-sul/galeria/image10.jpg');"></div>
                                </a>
                                <a data-fancybox="images" href="https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/exclusive-park-sul/galeria/image11.jpg">
                                    <div class="container-img-bg" style="background-image: url('https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/exclusive-park-sul/galeria/image11.jpg');"></div>
                                </a>
                                <a data-fancybox="images" href="https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/exclusive-park-sul/galeria/image12.jpg">
                                    <div class="container-img-bg" style="background-image: url('https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/exclusive-park-sul/galeria/image12.jpg');"></div>
                                </a>
                                <a data-fancybox="images" href="https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/exclusive-park-sul/galeria/image13.jpg">
                                    <div class="container-img-bg" style="background-image: url('https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/exclusive-park-sul/galeria/image13.jpg');"></div>
                                </a>
                                <a data-fancybox="images" href="https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/exclusive-park-sul/galeria/image14.jpg">
                                    <div class="container-img-bg" style="background-image: url('https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/exclusive-park-sul/galeria/image14.jpg');"></div>
                                </a>
                                <a data-fancybox="images" href="https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/exclusive-park-sul/galeria/image15.jpg">
                                    <div class="container-img-bg" style="background-image: url('https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/exclusive-park-sul/galeria/image15.jpg');"></div>
                                </a>
                                <a data-fancybox="images" href="https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/exclusive-park-sul/galeria/image16.jpg">
                                    <div class="container-img-bg" style="background-image: url('https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/exclusive-park-sul/galeria/image16.jpg');"></div>
                                </a>
                            </div>
                        </div>
                    </div> 
                    <div class="container-img d-none-767"><img src="https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/exclusive-park-sul/galeria/footer.jpg" class="img-fluid"></div>
                </div>
            </div>
        </div>
    </div>
    <?php } ?>
    
    <div id="section-unidades" class="row d-flex justify-content-center section-page">
        <div class="col-lg-9">
            <div class="title">
                <h2 class="mb-2">PREÇO VÁLIDO APENAS PARA ESTAS UNIDADES</h2>
                <h3 class="text-center mb-4">Faça uma visita sem compromisso</h3>
            </div>
            <div class="row d-flex justify-content-center">
                <div class="col-md-4 col-lg-4">
                    <div class="box-produto">
                        <div class="box-img loading-img border-img"><i class="fa fa-circle-o-notch fa-spin fa-3x fa-fw"></i></div>
                        <div class="show-imgs">
                            <div class="container-carousel">
                                <div class="owl-carousel-unidades owl-carousel owl-theme">
                                    <a data-fancybox="images" href="https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/exclusive-park-sul/unidades/unidade1/unidade1-0.jpg">
                                        <div class="box-img" style="background-image: url('https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/exclusive-park-sul/unidades/unidade1/unidade1-0.jpg');"></div>
                                    </a>
                                    <a data-fancybox="images" href="https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/exclusive-park-sul/unidades/unidade1/unidade1-1.jpg">
                                        <div class="box-img" style="background-image: url('https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/exclusive-park-sul/unidades/unidade1/unidade1-1.jpg');"></div>
                                    </a>
                                    <a data-fancybox="images" href="https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/exclusive-park-sul/unidades/unidade1/unidade1-2.jpg">
                                        <div class="box-img" style="background-image: url('https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/exclusive-park-sul/unidades/unidade1/unidade1-2.jpg');"></div>
                                    </a>
                                    <a data-fancybox="images" href="https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/exclusive-park-sul/unidades/unidade1/unidade1-3.jpg">
                                        <div class="box-img" style="background-image: url('https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/exclusive-park-sul/unidades/unidade1/unidade1-3.jpg');"></div>
                                    </a>
                                </div>
                            </div>
                        </div>
                        <!--<div class="box-img box-reservado reservado1">Reservado</div>-->
                        <div class="box-title">Unidade 401<br> 64,04 m²</div>
                        <div class="box-info"><strong>R$ 640.000,00</strong></div>
                        <div class="box-cta"><button type="button" class="btn btn-primary w-auto actReservar addToCart" data-tipo="Unidade 401 - 64,04 m²" data-unidade="1">Visitar</button></div>
                    </div>
                </div>
                <div class="col-md-4 col-lg-4">
                    <div class="box-produto">
                        <div class="box-img loading-img border-img"><i class="fa fa-circle-o-notch fa-spin fa-3x fa-fw"></i></div>
                        <div class="show-imgs">
                            <div class="container-carousel">
                                <div class="owl-carousel-unidades owl-carousel owl-theme">
                                    <a data-fancybox="images" href="https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/exclusive-park-sul/unidades/unidade2/unidade2-0.jpg">
                                        <div class="box-img" style="background-image: url('https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/exclusive-park-sul/unidades/unidade2/unidade2-0.jpg');"></div>
                                    </a>
                                    <a data-fancybox="images" href="https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/exclusive-park-sul/unidades/unidade2/unidade2-1.jpg">
                                        <div class="box-img" style="background-image: url('https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/exclusive-park-sul/unidades/unidade2/unidade2-1.jpg');"></div>
                                    </a>
                                    <a data-fancybox="images" href="https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/exclusive-park-sul/unidades/unidade2/unidade2-2.jpg">
                                        <div class="box-img" style="background-image: url('https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/exclusive-park-sul/unidades/unidade2/unidade2-2.jpg');"></div>
                                    </a>
                                    <a data-fancybox="images" href="https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/exclusive-park-sul/unidades/unidade2/unidade2-3.jpg">
                                        <div class="box-img" style="background-image: url('https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/exclusive-park-sul/unidades/unidade2/unidade2-3.jpg');"></div>
                                    </a>
                                </div>
                            </div>
                        </div> 
                        <!--<div class="box-img box-reservado reservado2">Reservado</div>-->
                        <div class="box-title">Unidade 603<br>64,28 m²</div>
                        <div class="box-info"><strong>R$ 655.000,00</strong></div>
                        <div class="box-cta"><button type="button" class="btn btn-primary w-auto actReservar addToCart" data-tipo="Unidade 603 - 64,28 m²" data-unidade="2">Visitar</button></div>
                    </div>
                </div>
                <div class="col-md-4 col-lg-4">
                    <div class="box-produto">
                        <div class="box-img loading-img border-img"><i class="fa fa-circle-o-notch fa-spin fa-3x fa-fw"></i></div>
                        <div class="show-imgs">
                            <div class="container-carousel">
                                <div class="owl-carousel-unidades owl-carousel owl-theme">
                                    <a data-fancybox="images" href="https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/exclusive-park-sul/unidades/unidade3/unidade3-0.jpg">
                                        <div class="box-img" style="background-image: url('https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/exclusive-park-sul/unidades/unidade3/unidade3-0.jpg');"></div>
                                    </a>
                                    <a data-fancybox="images" href="https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/exclusive-park-sul/unidades/unidade3/unidade3-1.jpg">
                                        <div class="box-img" style="background-image: url('https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/exclusive-park-sul/unidades/unidade3/unidade3-1.jpg');"></div>
                                    </a>
                                </div>
                            </div>
                        </div>
                        <!--<div class="box-img box-reservado reservado3">Reservado</div>-->
                        <div class="box-title">Unidade 702<br>87,60 m²</div>
                        <div class="box-info"><strong>R$ 890.000,00</strong></div>
                        <div class="box-cta"><button type="button" class="btn btn-primary w-auto actReservar addToCart" data-tipo="Unidade 702 - 87,60 m²" data-unidade="3">Visitar</button></div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div id="section-diferenciais" class="row d-flex justify-content-center section-page">
        <div class="col-md-12 col-lg-9 text-center">
            <div class="title">
                <h2>Se imagine morando no<br>Park Sul com:</h2>
            </div>
            <div class="d-none-767">
                <div class="row">
                    <div class="col-md-4 border-right">
                        <div class="box-diferenciais">
                            <div class="box-ico"><img src="https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/exclusive-park-sul/icons/condominio-fechado.svg"></div>
                            <div class="box-title">Condomínio<br>fechado</div>
                            <div class="box-info">Segurança e<br>tranquilidade garantidas</div>
                        </div>
                    </div>
                    <div class="col-md-4 border-right">
                         <div class="box-diferenciais">
                            <div class="box-ico"><img src="https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/exclusive-park-sul/icons/shopping.svg"></div>
                            <div class="box-title">Próximo ao<br>shopping</div>
                            <div class="box-info">Conveniência e Lazer<br>perto de você</div>
                        </div>
                    </div>
                    <div class="col-md-4">
                         <div class="box-diferenciais">
                            <div class="box-ico"><img src="https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/exclusive-park-sul/icons/acessibilidade.svg"></div>
                            <div class="box-title">Ambiente com<br>acessibilidade</div> 
                            <div class="box-info">Projeto idealizado<br>para facilitar a locomoção</div>
                        </div>
                    </div>
                </div>
                <div class="row section-page">
                    <div class="col-md-4 border-right">
                         <div class="box-diferenciais text-center">
                            <div class="box-ico"><img src="https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/exclusive-park-sul/icons/sustentabilidade.svg"></div>
                            <div class="box-title">Sustentabilidade</div>
                            <div class="box-info">Aquecimento solar, reuso<br>de água e vaga elétrica</div>
                        </div>
                    </div>
                    <div class="col-md-4 border-right">
                         <div class="box-diferenciais text-center">
                            <div class="box-ico"><img src="https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/exclusive-park-sul/icons/academia.svg"></div>
                            <div class="box-title">Academia</div>
                            <div class="box-info">Saúde e qualidade de vida<br>para você e sua família</div>
                        </div>
                    </div>                
                    <div class="col-md-4">
                         <div class="box-diferenciais text-center">
                            <div class="box-ico"><img src="https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/exclusive-park-sul/icons/churrasqueira.svg"></div>
                            <div class="box-title">Churrasqueira<br>gourmet</div>
                            <div class="box-info">A melhor estrutura para<br>encontros culinários</div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="d-block-767">
                <div class="row">
                    <div class="col-6 border-right">
                        <div class="box-diferenciais">
                            <div class="box-ico"><img src="https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/exclusive-park-sul/icons/condominio-fechado.svg"></div>
                            <div class="box-title">Condomínio<br>fechado</div>
                            <div class="box-info">Segurança e<br>tranquilidade garantidas</div>
                        </div>
                    </div>
                    <div class="col-6">
                         <div class="box-diferenciais">
                            <div class="box-ico"><img src="https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/exclusive-park-sul/icons/shopping.svg"></div>
                            <div class="box-title">Próximo ao<br>shopping</div>
                            <div class="box-info">Conveniência e Lazer<br>perto de você</div>
                        </div>
                    </div>
                    <div class="col-6 border-right mt-30">
                         <div class="box-diferenciais">
                            <div class="box-ico"><img src="https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/exclusive-park-sul/icons/acessibilidade.svg"></div>
                            <div class="box-title">Ambiente com<br>acessibilidade</div> 
                            <div class="box-info">Projeto idealizado<br>para facilitar a locomoção</div>
                        </div>
                    </div>
                    <div class="col-6 mt-30">
                         <div class="box-diferenciais text-center">
                            <div class="box-ico"><img src="https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/exclusive-park-sul/icons/sustentabilidade.svg"></div>
                            <div class="box-title">Sustentabilidade</div>
                            <div class="box-info">Aquecimento solar, reuso<br>de água e vaga elétrica</div>
                        </div>
                    </div>
                    <div class="col-6 border-right mt-30">
                         <div class="box-diferenciais text-center">
                            <div class="box-ico"><img src="https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/exclusive-park-sul/icons/academia.svg"></div>
                            <div class="box-title">Academia</div>
                            <div class="box-info">Saúde e qualidade de vida<br>para você e sua família</div>
                        </div>
                    </div>
                    <div class="col-6  mt-30">
                         <div class="box-diferenciais text-center">
                            <div class="box-ico"><img src="https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/exclusive-park-sul/icons/churrasqueira.svg"></div>
                            <div class="box-title">Churrasqueira<br>gourmet</div>
                            <div class="box-info">A melhor estrutura para<br>encontros culinários</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div id="localizacao" class="row d-flex justify-content-center section-page">
        <div class="col-md-12 col-lg-9">
            <div class="row">
                <div class="col-lg-12">
                    <div class="title mb-5">
                        <h2 class="text-left m-0">Localização</h2>
                    </div>
                    <iframe src="https://maps.google.com/maps?q=<?php e($imovel->latitude); ?>,<?php e($imovel->longitude); ?>&hl=es;z=14&amp;output=embed" width="100%" height="600" frameborder="0" style="border:0; border-radius: 4px" allowfullscreen></iframe>
                </div>
            </div>
        </div>
    </div>
    
    <div id="section-contato" class="row d-flex justify-content-center">
        <div class="col-lg-12">
            <div class="row d-flex justify-content-center">
                <div class="col-lg-9">
                    <div class="row">
                        <div class="col-md-6 col-lg-7">
                            <!--<div class="title">
                                <h2 class="m-0">Para confirmar sua Reserva</h2>
                                <h3 class="mt-2 mb-4 color-white">Não gera obrigação de compra</h3>
                            </div>
                            <p class="m-0">
                                1 - Preencha os dados abaixo<br>
                                2 - Marque uma visita<br>
                                3 - Ver condição de pagamento<br>
                                4 - Confirme a compra (não obrigatório)<br>
                                5 - Receba a chave do seu novo imóvel com uma Geladeira<br>
                            </p>-->
                            <div class="title">
                                <h2 class="m-0">Falta pouco para confirmar sua visita </h2>
                                <h3 class="mt-2 mb-4 color-white">Isso não gera obrigação de compra</h3>
                            </div>
                            <p class="m-0">
                                Ao se cadastrar abaixo você receberá seu <strong>Código Vip</strong> digital. Confirme o código ao agendar uma visita e, ao efetuar a compra você receberá a chave do <strong>seu novo imóvel</strong> com uma <strong>Geladeira</strong>! Todos os passos serão realizados dentro do site para que você tenha toda tranquilidade, comodidade e segurança.
                            </p>
                            <div class="row">
                                <div class="col-lg-8">
                                    <form id="formCaptura" action="" method="post" autocomplete="off">
                                        <div class="form-group mt-5 mb-5">
                                            <div class="box-selecione">
                                                <span class="selecionar">Selecione uma unidade <i class="material-icons">arrow_upward</i></span>
                                                <span class="selecionado d-none">Visitar: <span class="value-reserva"></span> <i class="material-icons icon-close">close</i></span>
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <label>Unidade*</label>
                                            <input type="text" name="tipo_imovel" class="form-control selecionar-unidade" placeholder="Sua unidade preferida" required="required" readonly="readonly">
                                        </div>
                                        <div class="form-group">
                                            <label>Seu nome*</label>
                                            <input type="text" name="nome" class="form-control" placeholder="Nome" required="required">
                                            <input type="hidden" name="origem" value="<?php e($origem)?>">
                                            <input type="hidden" name="link" value="<?php e($link)?>">
                                            <input type="hidden" name="endereco" value="https://maps.google.com/maps?q=<?php e($imovel->latitude)?>,<?php e($imovel->longitude)?>&hl=es;z=14&amp;output=embed">
                                            <input type="hidden" name="area_total" value="">
                                        </div>
                                        <div class="form-group">
                                            <label>Seu melhor email*</label>
                                            <input type="email" name="email" class="form-control" placeholder="exemplo@email.com" required="required">
                                        </div>
                                        <div class="form-group mt-30">
                                            <label>Telefone/Whatsapp*</label>
                                            <input type="text" name="telefone" class="form-control celular" placeholder="Seu whatsapp" required="required">
                                        </div>
                                        <div class="form-group mt-30">
                                            <div class="row">
                                                <div class="col-lg-5"><label class="campos-obrigatorios">*Campos obrigatórios</label></div>
                                                <div class="col-lg-7 text-right">
                                                    <button type="submit" class="btn btn-primary btn-enviar">Cadastrar</button>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="content_result"></div>
                                    </form>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6 col-lg-5 text-center d-none-767">
                            <img src="https://s3-us-west-2.amazonaws.com/<?php e(getenv('S3_BUCKET'));?>/modules/comdono/lp/exclusive-park-sul/images/cartao-vip-comdono.png">
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div id="section-footer" class="row d-flex justify-content-center">
        <div class="col-lg-12">
            <div class="row d-flex justify-content-center">
                <div class="col-lg-9 text-center">
                    <div class="item">
                        Imagens ilustrativas. Promoção não cumulativa<br/>
                        nem transferível. Condições especiais devem ser consultadas.
                    </div>
                    <div class="item m-0" style="font-size: 12px;">
                        CNPJ: <?php e($imovel->dn_cpf_cnpj); ?> - <?php e($imovel->endereco." ".$imovel->numero." ".$imovel->complemento." ".$imovel->bairro); ?>, Brasília-DF - <?php e($imovel->cep); ?> - Incorporadora Faenge
                    </div>
                    <div class="item" style="font-size: 12px;">
                        CNPJ: 34.627.929/0001-67 - CLN 305 Bl. C 1º Andar, Brasília-DF - 70737-530 © 2019 Comdono S/A
                    </div>    
                    <div>Powered by <a href="<?php e(base_url()); ?>"><img src="<?php e(base_url()); ?>assets/img/comdono/logo-white-full.png"></a></div>
                </div>
            </div>
        </div>
    </div>
</div>