<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

include_once GROCERY_CRUD;

class Agencia extends Grocery{
		
	public function __construct()
	{
		parent::__construct();
		$this->load->model('conversao_model');
	}
	
	public function index()
	{
		try{
			$this->ini_method();
			$crud = new Custom_Grocery_CRUD();
			$this->valida_acoes($crud);
			$state = $crud->getState();	
			
			if($state == 'read1')
			{
			    $stateInfo = $crud->getStateInfo();
				$this->visualizar_cadastro($stateInfo->primary_key,3);
			}
			else 
			{
			    $this->grocery_agencia($crud,$state);
			}
	
		}catch(Exception $e){
			show_error($e->getMessage().' --- '.$e->getTraceAsString());
		}
	}
	
	private function load_modal_iframe()
	{
	    $data['modal'] = Template::get('modal');
        $fields = array(
            array(
                'name' => 'cadastro',
                'display' => 'Cadastro PF',
                'iframe' => 'conversao/cadastro/add_modal_default/index/add/',
            )
        );
        
        foreach($fields as $key=>$field)
        {
	        Template::load_view('modal/modal_add', $field, '', '', $data['modal'][]);
        }
        
        Template::set($data);
	}
	
	public function grocery_agencia($crud,$state)
	{
	    $this->crud_agencia($crud,$state);
		
		$output = $crud->render();
		
		$this->_example_output($output);
	}
	
	public function crud_agencia($crud,$state)
	{
	    $crud->set_table('cad_empresa')
		->set_subject('Agência')
		->columns('nome','email','cnpj', 'status')
		->display_as('id_cad_forn','ID')
		->display_as('id_cadastro','Responsável')
		->display_as('nome','Nome Fantasia')
		//->display_as('profissao','Profissão')
		//->display_as('orgao_exp','Órgão expeditor')
		//->display_as('data_exp','Data expedição')
		//->display_as('endereco','Endereço')
		//->display_as('end_cep','CEP')
		//->display_as('end_endereco','Endereço')
		//->display_as('end_numero','Número')
		//->display_as('end_complemento','Complemento')
		//->display_as('end_bairro','Bairro')
		//->display_as('end_cidade','Cidade')
	    //->display_as('end_estado','Estado')
		->display_as('email','E-mail');
		//->display_as('emp_email','E-mail')
		//->display_as('login_email','E-mail')
		//->display_as('conf_senha','Confirme a senha');
		
		$crud->set_relation('id_cadastro','cad_cadastro','{nome} : {email}',array('status' => '1'));
		
		//$crud->set_model('Agencia_crud_model');
		
		$crud->where('cad_empresa.status',1);
        //$crud->unset_texteditor('obs');
		/*$crud->set_fields_abas('Dados do Responsável',array(
            'Dados Pessoais' => array('nome','telefone', 'email', 'sexo','data_nascimento', 'nacionalidade', 'naturalidade', 'cpf', 'rg', 'orgao_exp', 'data_exp', 'estado_civil',  'profissao'),
            'Endereço' => array('end_cep', 'end_endereco', 'end_numero', 'end_complemento', 'end_bairro', 'end_cidade', 'end_estado'),
            'Redes Sociais' => array('facebook','instagram','linkedin')
        ));*/
        /*$crud->set_fields_abas('Dados da Agência',array(
            'Dados' => array('nome_empresa', 'cnpj', 'telefone_empresa', 'email_empresa', 'site')
        ));*/
        /*$crud->set_fields_abas('Dados de Acesso',array(
	        'Login' => array('login_email', 'senha', 'conf_senha'),
        ));*/
        
        $crud->fields('nome',  'id_cadastro', 'cnpj', 'telefone', 'email', 'site');
        
	    $stateInfo = $crud->getStateInfo();
	    $pk = $stateInfo->primary_key??0;
	    
	    $id_cadastro = $this->conversao_model->get_empresa($pk)->id_cadastro??0;
        
        $crud->set_rules('email', "'E-mail'", 'trim|required|valid_email'); //|callback_valida_email['.$id_cadastro.']
        
		$crud->required_fields('nome', 'id_cadastro','telefone');
		
        //$crud->callback_add_field('login_email',array($this,'field_add_login_email'));
        //$crud->callback_add_field('estado_civil',array($this,'add_field_estado_civil'));
        //$crud->callback_add_field('sexo',array($this,'add_field_sexo'));
        //$crud->callback_add_field('senha',array($this,'formata_password1'));
        //$crud->callback_add_field('conf_senha',array($this,'formata_passconf1'));
        
        //$crud->callback_edit_field('sexo',array($this,'edit_field_sexo'));
        //$crud->callback_edit_field('estado_civil',array($this,'edit_field_estado_civil'));
        //$crud->callback_edit_field('login_email',array($this,'field_edit_login_email'));
		//$crud->callback_edit_field('senha',array($this,'formata_password'));
		//$crud->callback_edit_field('conf_senha',array($this,'formata_passconf'));
		
        if($state == 'add' || $state == 'insert' || $state == 'insert_validation')
        {
    		$crud->field_type('agencia', 'hidden', 1);
    		$crud->field_type('status', 'hidden', 1);
    		$crud->field_type('data_hora_cadastro', 'hidden', date('Y-m-d H:i:s'));
    		$crud->field_type('historico', 'hidden', json_encode(['inserido_por'=>$this->session->user_id]));
        }
        
		$crud->field_type('ultima_atualizacao', 'hidden', date('Y-m-d H:i:s'));
        //$crud->callback_before_insert(array($this,'before_insert')); 
        //$crud->callback_before_update(array($this,'before_update'));
        
		$crud->callback_delete(array($this,'callback_before_delete'));
		
		//Assets::add_css('plugins/select2-4.0.6/select2.min');
		
		Assets::add_js(array(
		    'plugins/inputmask.3.3.11/inputmask-lib',
			//'plugins/select2-4.0.6/select2.full.min',
			//'plugins/select2-4.0.6/select2.config'
		));
		
	    Assets::add_module_js('conversao',array('agencia','modal_add')); // 'mascaras',
	    
	    $this->load_modal_iframe();
	}
	
	public function add_modal_default()
	{
		try{
			$this->ini_method('index');
			$crud = new Custom_Grocery_CRUD();
			
			$this->valida_acoes($crud);
			$state = $crud->getState();	
	    	
			//-------GROCERY CONTROLLER------//
			$this->common_crud_clean($crud);
			
			$this->crud_agencia($crud,$state);
			
			$output = $crud->render();
			$output->output = str_replace("<span class='edit-icon'></span>", "", $output->output );
			$this->_example_output($output);
		}
		catch(Exception $e){
			show_error($e->getMessage().' --- '.$e->getTraceAsString());
		}
	}
	
	
	/*public function callback_add_responsavel($value = '', $row) 
	{
	    $json = "";
	    if(isset($row))
	    {
	        $cadastros = $this->conversao_model->list_cadastros();
	        if($cadastros !== NULL)
	            $json = json_encode(array_column($cadastros, 'id_cadastro'));
	    }
	    
    	$retorno = "<div class='col-sm-9'><button class='btn btn-info' type='button' id='add-servico'><i class='fa fa-plus-circle' aria-hidden='true'></i> Adicionar Serviço</button>";
    	$retorno .= "<span id='servicos_selected' class='hide' data-servicos='$json'>".$this->get_servicos_html()."</span>";
    	$retorno .= '</div><div class="col-sm-3"><input type="text" class="subtotal" name="sub_servico[]" readonly="readonly" style="width:100%"><label>Total Serviço</label></div>';
    	
    	return $retorno;
    }*/
	
	function add_field_estado_civil()
	{    
        $html = '<select id="field-estado_civil" name="estado_civil" size="8" class="chosen-select" data-placeholder="Selecione Estado Civil" style="100%">';
        $html .= "<option value='Solteiro(a)'>Solteiro(a)</option>";
        $html .= "<option value='Casado(a)'>Casado(a)</option>";
        $html .= "<option value='Divorciado(a)'>Divorciado(a)</option>";
        $html .= "<option value='Viúvo(a)'>Viúvo(a)</option>";
        $html .= "</select>";
        
        return $html;
	}
	
	function edit_field_estado_civil($value, $primary_key)
	{    
        $html = '<select id="field-estado_civil" name="estado_civil" size="8" class="chosen-select" data-placeholder="Selecione Estado Civil" style="100%">';
        $selected = $value=="Solteiro"?"selected='selected'":"";
        $html .= "<option value='Solteiro(a)' ".$selected." >Solteiro(a)</option>";
        $selected = $value=="Casado(a)"?"selected='selected'":"";
        $html .= "<option value='Casado(a)' ".$selected.">Casado(a)</option>";
        $selected = $value=="Divorciado(a)"?"selected='selected'":"";
        $html .= "<option value='Divorciado(a)' ".$selected.">Divorciado(a)</option>";
        $selected = $value=="Viúvo(a)"?"selected='selected'":"";
        $html .= "<option value='Viúvo(a)' ".$selected.">Viúvo(a)</option>";
        $html .= "</select>";
        
        return $html;
	}
	
	function add_field_sexo()
	{    
        $html = '<select id="field-sexo" name="sexo" size="8" class="chosen-select" data-placeholder="Selecione Sexo">';
        $html .= "<option value='Masculino'>Masculino</option>";
        $html .= "<option value='Feminino'>Feminino</option>";
        $html .= "<option value='Outro'>Outro</option>";
        $html .= "</select>";
        
        return $html;
	}
	
	function edit_field_sexo($value, $primary_key)
	{    
        $html = '<select id="field-sexo" name="sexo" size="8" class="chosen-select" data-placeholder="Selecione Sexo">';
        $selected = $value=="Masculino"?"selected='selected'":"";
        $html .= "<option value='Masculino' ".$selected.">Masculino</option>";
        $selected = $value=="Feminino"?"selected='selected'":"";
        $html .= "<option value='Feminino' ".$selected.">Feminino</option>";
        $selected = $value=="Outro"?"selected='selected'":"";
        $html .= "<option value='Outro' ".$selected.">Outro</option>";
        $html .= "</select>";
        
        return $html;
	}
	
	/*function formata_password1()
	{
	    return '<input class="form-control" type="password" value="" name="senha" >';
	}
	
	function formata_passconf1()
	{
	    return '<input class="form-control" type="password" value="" name="conf_senha" >';
	}
	
	function field_add_login_email()
    {
        return '<input id="field-add-login_email" class="form-control" type="text" value="" name="login_email" readonly="readonly">';
    }
    
	function field_edit_login_email($value, $primary_key)
    {
        return '<input id="field-edit-login_email" class="form-control" type="text" value="'.$value.'" name="login_email" readonly="readonly">';
    }
    
    function formata_password($value, $primary_key)
	{
	    return '<input class="form-control" type="password" value="xxxxxx" name="senha" onBlur="password_blur(this)" onFocus="password_focus(this)" >';
	}
	
	function formata_passconf($value, $primary_key)
	{
	    return '<input class="form-control" type="password" value="xxxxxx" name="conf_senha" onBlur="password_blur(this)" onFocus="password_focus(this)" >';
	}*/
	
	public function valida_email($email,$id_cadastro)
	{
       if($this->conversao_model->check_email_is_unique($email,$id_cadastro))
       {
            return TRUE;
       }
       else
       {
            $this->form_validation->set_message('valida_email','E-mail já cadastrado! Informe outro e-mail.');
            return FALSE;
       }
	}
	
	public function get_chosen_ajax()
	{    
	    $id = $this->input->post('id');
	    $field = $this->input->post('field');
	    $title = 'Agência';
	    $this->load->model('conversao_model');
	    $result = $this->conversao_model->list_agencias(); 
	    $html = "";
        $html = '<select id="field-'.$field.'" name="'.$field.'" size="8" class="chosen-select" data-placeholder="Selecione a Agência">';
        foreach($result as $row){
            $selected = ($id == $row->id_empresa) ? 'selected="selected"' : '';
            $html .= "<option value='".$row->id_empresa."' $selected>".$row->nome."</option>";
        }
        $html .= "</select>";
        echo json_encode(array('valid'=>true,'html'=>$html)); 
	}
	
	/*public function before_insert($post_array) 
	{
	    // insert cad_cadastro
	    $this->create_new_cadastro($post_array);
	    
	    // insert sys_users
	    $this->create_new_user($post_array);
	    
	    //$this->trata_dados_agencia($post_array);
	    
	    return $post_array;
    }*/
    
    /*public function trata_dados_agencia(&$post_array)
    {
	    //$post_array['nome']      = $post_array['nome_empresa'];
	    //$post_array['email']     = $post_array['email_empresa'];
	    //$post_array['telefone']  = $post_array['telefone_empresa'];
	    
	    //unset($post_array['nome_empresa'],$post_array['email_empresa'],$post_array['telefone_empresa']);
	    
        //return $post_array;
    }*/
    
    /*private function create_new_cadastro(&$post_array)
    {
        $insert_cadastro = array(
            'nome' => $post_array['nome'],
            'telefone' => $post_array['telefone'],
            'email' => $post_array['email'],
            'data_nascimento' => $post_array['data_nascimento'],
            'estado_civil' => $post_array['estado_civil'],
            'cpf' => $post_array['cpf'],
            'rg' => $post_array['rg'],
            'orgao_exp' => $post_array['orgao_exp'],
            'data_exp' => $post_array['data_exp'],
            'sexo' => $post_array['sexo'],
            'naturalidade' => $post_array['naturalidade'],
            'nacionalidade' => $post_array['nacionalidade'],
            'profissao' => $post_array['profissao'],
            //'img_perfil' => $post_array[''],
            'end_cep' => $post_array['end_cep'],
            'end_endereco' => $post_array['end_endereco'],
            'end_numero' => $post_array['end_numero'],
            'end_complemento' => $post_array['end_complemento'],
            'end_bairro' => $post_array['end_bairro'],
            'end_cidade' => $post_array['end_cidade'],
            'end_estado' => $post_array['end_estado'],
            'facebook' => $post_array['facebook'],
            'instagram' => $post_array['instagram'],
            'linkedin' => $post_array['linkedin'],
            'aceita_termos' => 1,
            'status' => 1,
            'data_hora_cadastro' => date('Y-m-d H:i:s'),
            'ultima_atualizacao' => date('Y-m-d H:i:s'),
            'historico' => json_encode(['inserido_por'=>$this->session->user_id])
        );
        
        foreach ($insert_cadastro as $key=>$insert_cad)
        {
            if(!in_array($key,['nome','email']))    
                unset($post_array[$key]);
        }
        
        $id_cadastro = $this->conversao_model->create_cadastro($insert_cadastro);
        
        $post_array['id_cadastro'] = $id_cadastro;
        
        return $post_array;
        
    }*/
    
    /*private function create_new_user(&$post_array)
    {
        $hasher = new PasswordHash(
    		$this->config->item('phpass_hash_strength', 'tank_auth'),
    		$this->config->item('phpass_hash_portable', 'tank_auth')
		);
		$post_array['senha'] = $hasher->HashPassword($post_array['senha']);
	    
	    $insert_user = array(
	        'id_cadastro' => $post_array['id_cadastro'],
    	    'perfil' => 3, // perfil de agencia
    	    'nome' => $post_array['nome'],
    	    'password' => $post_array['senha'],
    	    'email' => $post_array['email'],
    	    'activated' => 1,
        );
        
        //unset($post_array['perfil']);
        unset($post_array['nome']);
        unset($post_array['senha']);
        unset($post_array['email']);
        unset($post_array['conf_senha']);
        unset($post_array['login_email']);
        
        $user_id = $this->conversao_model->create_user($insert_user);
        
        return $post_array;
    }*/
    
    /*function before_update($post_array, $primary_key)
	{
	    $this->update_cadastro($post_array, $primary_key);
	    
	    $this->update_user($post_array, $primary_key);
		
		//$this->trata_dados_agencia($post_array);
	    
	    return $post_array;
	}*/
	
	/*private function update_cadastro(&$post_array,$primary_key)
    {
        $update_cadastro = array(
            'nome' => $post_array['nome'],
            'telefone' => $post_array['telefone'],
            'email' => $post_array['email'],
            'data_nascimento' => $post_array['data_nascimento'],
            'estado_civil' => $post_array['estado_civil'],
            'cpf' => $post_array['cpf'],
            'rg' => $post_array['rg'],
            'orgao_exp' => $post_array['orgao_exp'],
            'data_exp' => $post_array['data_exp'],
            'sexo' => $post_array['sexo'],
            'naturalidade' => $post_array['naturalidade'],
            'nacionalidade' => $post_array['nacionalidade'],
            'profissao' => $post_array['profissao'],
            //'img_perfil' => $post_array[''],
            'end_cep' => $post_array['end_cep'],
            'end_endereco' => $post_array['end_endereco'],
            'end_numero' => $post_array['end_numero'],
            'end_complemento' => $post_array['end_complemento'],
            'end_bairro' => $post_array['end_bairro'],
            'end_cidade' => $post_array['end_cidade'],
            'end_estado' => $post_array['end_estado'],
            'facebook' => $post_array['facebook'],
            'instagram' => $post_array['instagram'],
            'linkedin' => $post_array['linkedin'],
            'aceita_termos' => 1,
            'status' => 1,
            'ultima_atualizacao' => date('Y-m-d H:i:s'),
            'historico' => json_encode(['inserido_por'=>$this->session->user_id])
        );
        
        foreach ($update_cadastro as $key=>$update_cad)
        {
            if(!in_array($key,['nome','email']))    
                unset($post_array[$key]);
        }
        
        $empresa = $this->conversao_model->get_empresa($primary_key);
        
        $this->conversao_model->update_cadastro($empresa->id_cadastro,$update_cadastro);
        
        $post_array['id_cadastro'] = $empresa->id_cadastro;
        
        return $post_array;
        
    }*/
	
	/*protected function update_user(&$post_array, $primary_key)
	{
	    $update_user = array(
    	    'nome' => $post_array['nome'],
    	    'email' => $post_array['email'],
        );
        
	    if($post_array['senha'] != "xxxxxx" )
	    {   
	    	// Hash password using phpass
			$hasher = new PasswordHash(
					$this->config->item('phpass_hash_strength', 'tank_auth'),
					$this->config->item('phpass_hash_portable', 'tank_auth'));
			$update_user['password'] = $hasher->HashPassword($post_array['senha']);
	    }	    
        
        //unset($post_array['perfil']);
        unset($post_array['nome']);
        unset($post_array['senha']);
        unset($post_array['email']);
        unset($post_array['conf_senha']);
        unset($post_array['login_email']);
        
        $empresa = $this->conversao_model->get_empresa($primary_key);
        
        $user_id = $this->conversao_model->update_user($empresa->id_cadastro,$update_user);
	    
	    return $post_array;
	}*/
	
	//id_cadastro	uuid_cadastro	nome	telefone	email	cpf	rg	orgao_exp	
	//data_exp	sexo	nacionalidade	naturalidade	estado_civil	data_nascimento	
	//profissao	img_perfil	end_cep	end_endereco	end_numero	end_complemento	end_bairro	
	//end_cidade	end_estado	facebook	instagram	linkedin	push_alertjson	aceita_termos	
	//data_hora_cadastro	ultima_atualizacao	historico
	
	//agencia 0-empresa/1-agencia	uuid_empresa	uuid_cadastro
    //	nome_empresa	cnpj	telefone	email	site	status 0-inativa/1-ativa	
    //data_hora_cadastro	ultima_atualizacao	historico	

	
	public function callback_before_delete($primary_key)
    {
        //$this->db->set('status','Inativo');
        $this->db->set('status',0);
        $this->db->where('id_empresa',$primary_key);
        $this->db->update('cad_empresa');
        return true;
    }
}