<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

include_once GROCERY_CRUD;

class Cadastro extends Grocery{
		
	public function __construct()
	{
		parent::__construct();
		$this->load->model('conversao_model');
	}
	
	public function index()
	{
		try{
			$this->ini_method();
			$crud = new Custom_Grocery_CRUD();
			$this->valida_acoes($crud);
			$state = $crud->getState();	
			
			if($state == 'read1')
			{
			    $stateInfo = $crud->getStateInfo();
				$this->visualizar_cadastro($stateInfo->primary_key,3);
			}
			else 
			{
			    $this->grocery_cadastro($crud,$state);
			}
	
		}catch(Exception $e){
			show_error($e->getMessage().' --- '.$e->getTraceAsString());
		}
	}
	
	public function add_modal_default()
	{
		try{
			$this->ini_method('index');
			$crud = new Custom_Grocery_CRUD();
			
			$this->valida_acoes($crud);
			$state = $crud->getState();	
	    	
			//-------GROCERY CONTROLLER------//
			$this->common_crud_clean($crud);
			
			$this->crud_cadastro($crud,$state);
			
			$output = $crud->render();
			$output->output = str_replace("<span class='edit-icon'></span>", "", $output->output );
			$this->_example_output($output);
		}
		catch(Exception $e){
			show_error($e->getMessage().' --- '.$e->getTraceAsString());
		}
	}
	
	public function grocery_cadastro($crud,$state)
	{
	    $this->crud_cadastro($crud,$state);
		
		$output = $crud->render();
		
		$this->_example_output($output);
	}
	
	private function crud_cadastro(&$crud,$state)
	{
	    $crud->set_table('cad_cadastro')
		->set_subject('Cadastro')
		->columns('id_cadastro','nome','telefone', 'email', 'perfil')
		//->display_as('id_cad_forn','ID')
		//->display_as('responsavel','Responsável')
		->display_as('profissao','Profissão')
		->display_as('orgao_exp','Órgão expeditor')
		->display_as('data_exp','Data expedição')
		->display_as('endereco','Endereço')
		->display_as('end_cep','CEP')
		->display_as('end_endereco','Endereço')
		->display_as('end_numero','Número')
		->display_as('end_complemento','Complemento')
		->display_as('end_bairro','Bairro')
		->display_as('end_cidade','Cidade')
		->display_as('end_estado','Estado')
		->display_as('email','E-mail')
		->display_as('login_email','E-mail')
		->display_as('conf_senha','Confirme a senha');
		
		$crud->set_model('Cadastro_crud_model');
		
		$crud->where('status',1);
        //$crud->unset_texteditor('obs');
		$crud->set_fields_abas('Dados do Responsável',array(
            'Dados Pessoais' => array('nome','telefone', 'email', 'sexo','data_nascimento', 'nacionalidade', 'naturalidade', 'cpf', 'rg', 'orgao_exp', 'data_exp', 'estado_civil',  'profissao'),
            'Endereço' => array('end_cep', 'end_endereco', 'end_numero', 'end_complemento', 'end_bairro', 'end_cidade', 'end_estado'),
            'Redes Sociais' => array('facebook','instagram','linkedin')
        ));
        /*$crud->set_fields_abas('Dados da Agência',array(
            'Dados' => array('nome_empresa', 'cnpj', 'telefone_empresa', 'email_empresa', 'site')
        ));*/
        $crud->set_fields_abas('Dados de Acesso',array(
	        'Login' => array('login_email', 'perfil', 'senha', 'conf_senha'),
        ));
        
        $crud->callback_column('perfil',array($this,'_callback_perfil_column'));
        
	    $stateInfo = $crud->getStateInfo();
	    $pk = $stateInfo->primary_key??0;
	    
	    //$id_cadastro = $this->conversao_model->get_empresa($pk)->id_cadastro??0;
        
        $crud->set_rules('email', "'E-mail'", 'trim|required|valid_email|callback_valida_email['.$pk.']') 
            ->set_rules('senha', "Senha", 'trim|required|min_length['.$this->config->item('password_min_length', 'tank_auth').']|max_length['.$this->config->item('password_max_length', 'tank_auth').']')
			->set_rules('conf_senha', "Confirmar Senha", 'trim|required|matches[senha]');
        
		$crud->required_fields('nome','email','telefone');
		
		//$crud->set_relation('id_perfil','sys_perfil','perfil'); // ,array('status' => '1')
		
		$crud->callback_field('perfil',array($this,'field_perfil'));
		$crud->callback_field('login_email',array($this,'field_add_login_email'));
        $crud->callback_add_field('login_email',array($this,'field_add_login_email'));
        $crud->callback_add_field('estado_civil',array($this,'add_field_estado_civil'));
        $crud->callback_add_field('sexo',array($this,'add_field_sexo'));
        $crud->callback_add_field('senha',array($this,'formata_password1'));
        $crud->callback_add_field('conf_senha',array($this,'formata_passconf1'));
        
        $crud->callback_edit_field('sexo',array($this,'edit_field_sexo'));
        $crud->callback_edit_field('estado_civil',array($this,'edit_field_estado_civil'));
        $crud->callback_edit_field('login_email',array($this,'field_edit_login_email'));
		$crud->callback_edit_field('senha',array($this,'formata_password'));
		$crud->callback_edit_field('conf_senha',array($this,'formata_passconf'));
		
        if($state == 'add' || $state == 'insert' || $state == 'insert_validation')
        {
    		//$crud->field_type('agencia', 'hidden', 1);
    		$crud->field_type('status', 'hidden', 1);
    		$crud->field_type('data_hora_cadastro', 'hidden', date('Y-m-d H:i:s'));
    		$crud->field_type('historico', 'hidden', json_encode(['inserido_por'=>$this->session->user_id]));
        }
        
		$crud->field_type('ultima_atualizacao', 'hidden', date('Y-m-d H:i:s'));
        $crud->callback_before_insert(array($this,'before_insert')); 
        $crud->callback_after_insert(array($this,'after_insert')); 
        $crud->callback_before_update(array($this,'before_update'));
        //$crud->callback_after_update(array($this,'after_up')); 
        
		$crud->callback_delete(array($this,'callback_before_delete'));
		
	    Assets::add_css('../painel/plugins/select2-4.0.6/select2.min');
		
		Assets::add_js(array(
		    '../painel/plugins/inputmask.3.3.11/inputmask-lib',
			'../painel/plugins/select2-4.0.6/select2.full.min',
			'../painel/plugins/select2-4.0.6/select2.config'
		));
		
		Assets::add_module_js('conversao',array('cadastro')); // 'mascaras',
	}
	
	public function _callback_perfil_column($value, $row)
    {
        $user = $this->conversao_model->get_usuario_by_id_cadastro($row->id_cadastro);
        if(!empty($user))
        {
            $perfil = $this->conversao_model->get_perfil($user->perfil);
            return $perfil->perfil??'Sem Perfil';
        }
        return 'Sem Perfil';
    }    
	
	public function get_chosen_ajax()
	{    
	    $id = $this->input->post('id');
	    $field = $this->input->post('field');
	    $title = 'Cadastro PF';
	    $this->load->model('conversao_model');
	    $cadastros = $this->conversao_model->list_cadastros(); 
	    $html = "";
        $html = '<select id="field-'.$field.'" name="'.$field.'" size="8" class="chosen-select" data-placeholder="Selecione o Cadastro">';
        foreach($cadastros as $cadastro){
            $selected = ($id == $cadastro->id_cadastro) ? 'selected="selected"' : '';
            $html .= "<option value='".$cadastro->id_cadastro."' $selected>".$cadastro->nome."</option>";
        }
        $html .= "</select>";
        echo json_encode(array('valid'=>true,'html'=>$html)); 
	}
	
	function add_field_estado_civil()
	{    
        $html = '<select id="field-estado_civil" name="estado_civil" size="8" class="chosen-select" data-placeholder="Selecione Estado Civil" style="100%">';
        $html .= "<option value='Solteiro(a)'>Solteiro(a)</option>";
        $html .= "<option value='Casado(a)'>Casado(a)</option>";
        $html .= "<option value='Divorciado(a)'>Divorciado(a)</option>";
        $html .= "<option value='Viúvo(a)'>Viúvo(a)</option>";
        $html .= "</select>";
        
        return $html;
	}
	
	function edit_field_estado_civil($value, $primary_key)
	{    
        $html = '<select id="field-estado_civil" name="estado_civil" size="8" class="chosen-select" data-placeholder="Selecione Estado Civil" style="100%">';
        $selected = $value=="Solteiro"?"selected='selected'":"";
        $html .= "<option value='Solteiro(a)' ".$selected." >Solteiro(a)</option>";
        $selected = $value=="Casado(a)"?"selected='selected'":"";
        $html .= "<option value='Casado(a)' ".$selected.">Casado(a)</option>";
        $selected = $value=="Divorciado(a)"?"selected='selected'":"";
        $html .= "<option value='Divorciado(a)' ".$selected.">Divorciado(a)</option>";
        $selected = $value=="Viúvo(a)"?"selected='selected'":"";
        $html .= "<option value='Viúvo(a)' ".$selected.">Viúvo(a)</option>";
        $html .= "</select>";
        
        return $html;
	}
	
	function add_field_sexo()
	{    
        $html = '<select id="field-sexo" name="sexo" size="8" class="chosen-select" data-placeholder="Selecione Sexo">';
        $html .= "<option value='Masculino'>Masculino</option>";
        $html .= "<option value='Feminino'>Feminino</option>";
        $html .= "<option value='Outro'>Outro</option>";
        $html .= "</select>";
        
        return $html;
	}
	
	function edit_field_sexo($value, $primary_key)
	{    
        $html = '<select id="field-sexo" name="sexo" size="8" class="chosen-select" data-placeholder="Selecione Sexo">';
        $selected = $value=="Masculino"?"selected='selected'":"";
        $html .= "<option value='Masculino' ".$selected.">Masculino</option>";
        $selected = $value=="Feminino"?"selected='selected'":"";
        $html .= "<option value='Feminino' ".$selected.">Feminino</option>";
        $selected = $value=="Outro"?"selected='selected'":"";
        $html .= "<option value='Outro' ".$selected.">Outro</option>";
        $html .= "</select>";
        
        return $html;
	}
	
	function formata_password1()
	{
	    return '<input class="form-control" type="password" value="" name="senha" >';
	}
	
	function formata_passconf1()
	{
	    return '<input class="form-control" type="password" value="" name="conf_senha" >';
	}
	
	function field_add_login_email()
    {
        return '<input id="field-add-login_email" class="form-control" type="text" value="" name="login_email" readonly="readonly">';
    }
    
	function field_perfil($value, $primary_key)
    {
        //$id = $this->input->post('id');
	    //$field = $this->input->post('field');
	    //$agencia = $this->conversao_model->get_agencia($primary_key);
	    /*echo $this->db->last_query();
	    dd($agencia);*/
	    if($primary_key !== NULL)
	    {
    	    $cadCadastro = $this->conversao_model->get_usuario_by_id_cadastro($primary_key);
    	    $userPerfil = $this->conversao_model->get_perfil($cadCadastro->perfil);
	    }
	    else
	    {
	        $userPerfil = (object)['id_perfil'=>0];
	    }
	    $perfis = $this->conversao_model->list_perfis(); 
	    
	    //dd($perfis,$cadCadastro,$userPerfil);
	    $html = "";
        $html = '<select id="field-perfil" name="perfil" size="8" class="chosen-select" data-placeholder="Selecione o Perfil">';
        foreach($perfis as $perfil){
            $selected = ($userPerfil->id_perfil == $perfil->id_perfil) ? 'selected="selected"' : '';
            $html .= "<option value='".$perfil->id_perfil."' $selected>".$perfil->perfil."</option>";
        }
        $html .= "</select>";
        //echo json_encode(array('valid'=>true,'html'=>$html)); 
        
        
        return $html; //'<input id="field-perfil" class="form-control" type="text" value="" name="login_email" readonly="readonly">';
    }
    
	function field_edit_login_email($value, $primary_key)
    {
        return '<input id="field-edit-login_email" class="form-control" type="text" value="'.$value.'" name="login_email" readonly="readonly">';
    }
    
    function formata_password($value, $primary_key)
	{
	    return '<input class="form-control" type="password" value="xxxxxx" name="senha" onBlur="password_blur(this)" onFocus="password_focus(this)" >';
	}
	
	function formata_passconf($value, $primary_key)
	{
	    return '<input class="form-control" type="password" value="xxxxxx" name="conf_senha" onBlur="password_blur(this)" onFocus="password_focus(this)" >';
	}
	
	public function valida_email($email,$id_cadastro)
	{
       if($this->conversao_model->check_email_is_unique($email,$id_cadastro))
       {
            return TRUE;
       }
       else
       {
            $this->form_validation->set_message('valida_email','E-mail já cadastrado! Informe outro e-mail.');
            return FALSE;
       }
	}
	
	public function before_insert($post_array) 
    {
        // insert cad_cadastro
        //$this->create_new_cadastro($post_array);
        
        $this->session->set_userdata('senha',$post_array['senha']);
    
        if($this->session->perfil == 1)
            $this->session->set_userdata('field_perfil',$post_array['perfil']);
        else
        {
	        $perfil = $this->get_id_perfil_by_class();
            $this->session->set_userdata('field_perfil',$perfil);
        }
        
        unset($post_array['senha']);
        unset($post_array['perfil']);
        unset($post_array['conf_senha']);
        unset($post_array['login_email']);
        
        // insert sys_users
        //$this->create_new_user($post_array);
        
        //$this->trata_dados_agencia($post_array);
        
        return $post_array;
    }
	
	public function after_insert($post_array,$primary_key) 
	{
	    // insert cad_cadastro
	    //$this->create_new_cadastro($post_array);
	    
	    // insert sys_users
	    $this->create_new_user($post_array,$primary_key);
	    
	    //$this->trata_dados_agencia($post_array);
	    
	    //return $post_array;
    }
    
    /*public function trata_dados_agencia(&$post_array)
    {
	    $post_array['nome']      = $post_array['nome_empresa'];
	    $post_array['email']     = $post_array['email_empresa'];
	    $post_array['telefone']  = $post_array['telefone_empresa'];
	    
	    unset($post_array['nome_empresa'],$post_array['email_empresa'],$post_array['telefone_empresa']);
	    
        return $post_array;
    }*/
    
    /*private function create_new_cadastro(&$post_array)
    {
        $insert_cadastro = array(
            'nome' => $post_array['nome'],
            'telefone' => $post_array['telefone'],
            'email' => $post_array['email'],
            'data_nascimento' => $post_array['data_nascimento'],
            'estado_civil' => $post_array['estado_civil']??'',
            'cpf' => $post_array['cpf'],
            'rg' => $post_array['rg'],
            'orgao_exp' => $post_array['orgao_exp'],
            'data_exp' => $post_array['data_exp'],
            'sexo' => $post_array['sexo']??'',
            'naturalidade' => $post_array['naturalidade'],
            'nacionalidade' => $post_array['nacionalidade'],
            'profissao' => $post_array['profissao'],
            //'img_perfil' => $post_array[''],
            'end_cep' => $post_array['end_cep'],
            'end_endereco' => $post_array['end_endereco'],
            'end_numero' => $post_array['end_numero'],
            'end_complemento' => $post_array['end_complemento'],
            'end_bairro' => $post_array['end_bairro'],
            'end_cidade' => $post_array['end_cidade'],
            'end_estado' => $post_array['end_estado'],
            'facebook' => $post_array['facebook'],
            'instagram' => $post_array['instagram'],
            'linkedin' => $post_array['linkedin'],
            'aceita_termos' => 1,
            'status' => 1,
            'data_hora_cadastro' => date('Y-m-d H:i:s'),
            'ultima_atualizacao' => date('Y-m-d H:i:s'),
            'historico' => json_encode(['inserido_por'=>$this->session->user_id])
        );
        
        foreach ($insert_cadastro as $key=>$insert_cad)
        {
            if(!in_array($key,['nome','email']))    
                unset($post_array[$key]);
        }
        
        $id_cadastro = $this->conversao_model->create_cadastro($insert_cadastro);
        
        $post_array['id_cadastro'] = $id_cadastro;
        
        return $post_array;
        
    }*/
    
        
    
    private function create_new_user($post_array,$primary_key)
    {
        $hasher = new PasswordHash(
    		$this->config->item('phpass_hash_strength', 'tank_auth'),
    		$this->config->item('phpass_hash_portable', 'tank_auth')
		);
		$post_array['senha'] = $hasher->HashPassword($this->session->senha);
	    
	    $insert_user = array(
	        'id_cadastro' => $primary_key,
    	    'perfil' => $this->session->field_perfil, // perfil de agencia //verificar !!!
    	    'nome' => $post_array['nome'],
    	    'password' => $post_array['senha'],
    	    'email' => $post_array['email'],
    	    'activated' => 1,
        );
        
        //unset($post_array['perfil']);
        /*unset($post_array['nome']);
        
        unset($post_array['email']);*/
        
        $user_id = $this->conversao_model->create_user($insert_user);
        
        //return $post_array;
        
        return is_null($user_id) ? FALSE : TRUE;
    }
    
    private function get_id_perfil_by_class()
    {
        $class = $this->uri->segment(3);
        
        dd($class);
        
        switch ($referrer) {
	        case 'agencia':
	            return 3;
            break;
	        case 'empresa':
	            return 4;
            break;
            case 'cliente':
	            return 5;
            break;
            case 'responsavel_tecnico':
	            return 6;
            break;
	        default:
	            return 0; // redefinir no banco para um perfil sem acesso
            break;
	    }
    }
    
    
    
    function before_update($post_array, $primary_key)
	{
	    //$this->update_cadastro($post_array, $primary_key);
	    
	    $this->update_user($post_array, $primary_key);
		
		//$this->trata_dados_agencia($post_array);
	    
	    return $post_array;
	}
	
	/*private function update_cadastro(&$post_array,$primary_key)
    {
        $update_cadastro = array(
            'nome' => $post_array['nome'],
            'telefone' => $post_array['telefone'],
            'email' => $post_array['email'],
            'data_nascimento' => $post_array['data_nascimento'],
            'estado_civil' => $post_array['estado_civil'],
            'cpf' => $post_array['cpf'],
            'rg' => $post_array['rg'],
            'orgao_exp' => $post_array['orgao_exp'],
            'data_exp' => $post_array['data_exp'],
            'sexo' => $post_array['sexo'],
            'naturalidade' => $post_array['naturalidade'],
            'nacionalidade' => $post_array['nacionalidade'],
            'profissao' => $post_array['profissao'],
            //'img_perfil' => $post_array[''],
            'end_cep' => $post_array['end_cep'],
            'end_endereco' => $post_array['end_endereco'],
            'end_numero' => $post_array['end_numero'],
            'end_complemento' => $post_array['end_complemento'],
            'end_bairro' => $post_array['end_bairro'],
            'end_cidade' => $post_array['end_cidade'],
            'end_estado' => $post_array['end_estado'],
            'facebook' => $post_array['facebook'],
            'instagram' => $post_array['instagram'],
            'linkedin' => $post_array['linkedin'],
            'aceita_termos' => 1,
            'status' => 1,
            'ultima_atualizacao' => date('Y-m-d H:i:s'),
            'historico' => json_encode(['inserido_por'=>$this->session->user_id])
        );
        
        foreach ($update_cadastro as $key=>$update_cad)
        {
            if(!in_array($key,['nome','email']))    
                unset($post_array[$key]);
        }
        
        $empresa = $this->conversao_model->get_empresa($primary_key);
        
        $this->conversao_model->update_cadastro($empresa->id_cadastro,$update_cadastro);
        
        $post_array['id_cadastro'] = $empresa->id_cadastro;
        
        return $post_array;
        
    }*/
	
	protected function update_user(&$post_array, $primary_key)
	{
	    $update_user = array(
    	    'nome' => $post_array['nome'],
    	    'email' => $post_array['email'],
    	    'perfil' => $post_array['perfil'],
        );
        
	    if($post_array['senha'] != "xxxxxx" )
	    {   
	    	// Hash password using phpass
			$hasher = new PasswordHash(
					$this->config->item('phpass_hash_strength', 'tank_auth'),
					$this->config->item('phpass_hash_portable', 'tank_auth'));
			$update_user['password'] = $hasher->HashPassword($post_array['senha']);
	    }	    
	    
	    
        $this->session->set_userdata('field_perfil',$post_array['perfil']);
        
        unset($post_array['perfil']);
        unset($post_array['nome']);
        unset($post_array['senha']);
        unset($post_array['email']);
        unset($post_array['conf_senha']);
        unset($post_array['login_email']);
        
        ///$empresa = $this->conversao_model->get_empresa($primary_key);
        
        $user_id = $this->conversao_model->update_user($primary_key,$update_user);
	    
	    return $post_array;
	}
	
	//id_cadastro	uuid_cadastro	nome	telefone	email	cpf	rg	orgao_exp	
	//data_exp	sexo	nacionalidade	naturalidade	estado_civil	data_nascimento	
	//profissao	img_perfil	end_cep	end_endereco	end_numero	end_complemento	end_bairro	
	//end_cidade	end_estado	facebook	instagram	linkedin	push_alertjson	aceita_termos	
	//data_hora_cadastro	ultima_atualizacao	historico
	
	//agencia 0-empresa/1-agencia	uuid_empresa	uuid_cadastro
    //	nome_empresa	cnpj	telefone	email	site	status 0-inativa/1-ativa	
    //data_hora_cadastro	ultima_atualizacao	historico	

	
	public function callback_before_delete($primary_key)
    {
        $this->db->set('status','Inativo');
        $this->db->set('status',0);
        $this->db->where('id_cad_forn',$primary_key);
        $this->db->update('cad_empresa');
        return true;
    }
}