<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

include_once GROCERY_CRUD;

class Configuracoes extends Grocery{
		
	public function __construct()
	{
		parent::__construct();
		$this->load->model('conversao_model');
	}
	
	public function scripts()
	{
	    
	    try{
			$this->ini_method();
			$crud = new Custom_Grocery_CRUD();
			$this->valida_acoes($crud);
			$state = $crud->getState();	
			
			$crud->set_table('cad_pagina_scripts')
    		->set_subject('Scripts')
    		->columns('id_pagina','nome','posicao','data_hora_cadastro')
    		->display_as('id_pagina','Página');
    		
    		$crud->set_relation('id_pagina','cad_pagina','{nome}',array('status' => '1'));
            
    		$crud->required_fields('id_pagina','nome','posicao','script');
            
            $crud->unset_texteditor('script');
    		$crud->field_type('data_hora_cadastro', 'hidden', date('Y-m-d H:i:s'));
    		$crud->field_type('ultima_atualizacao', 'hidden', date('Y-m-d H:i:s'));
            
    		$crud->callback_delete(array($this,'callback_before_delete'));
    		
    		Assets::add_module_css('conversao','pagina');
    		
    		$output = $crud->render();
    		
    		$this->_example_output($output);
	
		}catch(Exception $e){
			show_error($e->getMessage().' --- '.$e->getTraceAsString());
		}
	}
	
	public function dominio()
	{
	    
	    try{
			$this->ini_method();
			$crud = new Custom_Grocery_CRUD();
			$this->valida_acoes($crud);
			$state = $crud->getState();	
			
			$crud->set_table('cad_dominio')
    		->set_subject('Domínio')
    		->columns('id_dominio','id_empresa','dominio','status')
    		->display_as('id_empresa','Empresa');
    		
    		$crud->set_relation('id_empresa','cad_empresa','{nome}',array('status' => '1'));
            
    		$crud->required_fields('id_empresa','dominio','status');
            
    		$crud->field_type('data_hora_cadastro', 'hidden', date('Y-m-d H:i:s'));
    		$crud->field_type('ultima_atualizacao', 'hidden', date('Y-m-d H:i:s'));
            
    		$crud->callback_delete(array($this,'callback_before_delete'));
    		
    		Assets::add_module_css('conversao','pagina');
    		
    		$output = $crud->render();
    		
    		$this->_example_output($output);
	
		}catch(Exception $e){
			show_error($e->getMessage().' --- '.$e->getTraceAsString());
		}
	}
	
	public function callback_before_delete($primary_key)
    {
        $this->db->set('status','Inativo');
        $this->db->set('status',0);
        $this->db->where('id_cad_forn',$primary_key);
        $this->db->update('cad_empresa');
        return true;
    }
    
    public function utm()
    {
        try
        {
            $this->ini_method();
            $crud= new grocery_CRUD();
            $this->valida_acoes($crud);
            $crud->set_table('cad_pagina_utm')->set_subject('UTM');
            $crud->columns('id_utm','id_pagina','utm_source','utm_medium','utm_campaign','data_hora_cadastro','ultima_atualizacao');
     
            $crud->field_type('data_hora_cadastro', 'hidden', date('Y-m-d H:i:s'));
    		$crud->field_type('ultima_atualizacao', 'hidden', date('Y-m-d H:i:s'));
                
    		$crud->callback_delete(array($this,'callback_before_delete'));
     
            $output = $crud->render();
     
            $this->_example_output($output);
        }catch(Exception $e){
			show_error($e->getMessage().' --- '.$e->getTraceAsString());
		}
    } // fim do metodo utm
    
    public function tema()
    {
        try
        {
            $this->ini_method();
            $crud= new grocery_CRUD();
            $this->valida_acoes($crud);
            $crud->set_table('cad_tema')
            ->set_subject('Tema');
            $crud->columns('id_tema','nome','favicon','status','ultima_atualizacao','data_hora_cadastro');

            $crud->field_type('data_hora_cadastro', 'hidden', date('Y-m-d H:i:s'));
    		$crud->field_type('ultima_atualizacao', 'hidden', date('Y-m-d H:i:s'));
               
            $crud->set_field_upload('favicon','assets/uploads/tema/'); 
    		$crud->callback_delete(array($this,'callback_before_delete'));
     
            $output = $crud->render();
     
            $this->_example_output($output);
        }catch(Exception $e){
			show_error($e->getMessage().' --- '.$e->getTraceAsString());
		}
    }
    
}   // fim da classe
// fim