<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

include_once GROCERY_CRUD;

class Pagina extends Grocery{
		
	private $utm;
		
	public function __construct()
	{
		parent::__construct();
		$this->load->model('conversao_model');
	}
	
	public function index()
	{
		try{
			$this->ini_method();
			$crud = new Custom_Grocery_CRUD();
			$this->valida_acoes($crud);
			$state = $crud->getState();	
			
			if($state == 'read1')
			{
			    $stateInfo = $crud->getStateInfo();
				$this->visualizar_cadastro($stateInfo->primary_key,3);
			}
			else 
			{
			    $crud->set_table('cad_pagina')
        		->set_subject('Página')
        		->columns('nome','id_campanha','id_dominio','ultima_atualizacao', 'status')
        		->display_as('ultima_atualizacao','Última Atualização')
        		->display_as('id_campanha','Campanha')
        		->display_as('id_tema','Tema')
        		->display_as('id_dominio','Domínio')
        		->display_as('id_cadastro','Responsável')
        		->display_as('email','E-mail')
        		->display_as('script','Código Script')
        		->display_as('nome_script','Nome Script')
        		->display_as('posicao','Posição');
        		
        		$crud->unset_texteditor('keywords');
        		
        		$crud->set_relation('id_campanha','cad_campanha','{nome}');
        		
        		$crud->set_relation('id_tema','cad_tema','nome');
        		
        		$crud->set_relation('id_dominio','cad_dominio','dominio');
        		
        		//$this->config->set_item('grocery_crud_file_upload_allow_file_types','pdf');
		        //$crud->set_field_upload_S3('file_url','financiamento/'.$id_simulacao.'/pdf');
		        $crud->set_field_upload('favicon','assets/uploads/empresas/');
        		
        		$crud->set_fields_abas('Dados da Página',array(
                    'Página' => array('status','nome','id_campanha','id_dominio','id_tema','favicon','ultima_atualizacao')
                ));
                
                $crud->set_fields_abas('UTM',array(
                    'UTM' => array('utm_source','utm_medium','utm_campaign')
                ));
                
                $crud->set_fields_abas('Meta Tags',array(
                    'Meta Tag' => array('keywords','site_name','url','title','description','image','ultima_atualizacao')
                ));
                
                $crud->set_fields_abas('Scripts',array(
                    'Script' => ['nome_script','posicao','script']
                ));
                
		        $crud->set_field_upload('image','assets/uploads/empresas/');
        		//$crud->change_field_type('image', 'file');
        		
        		// PROBLEMA: LIMITADO A 1 JOIN APENAS
        		$crud->join_table('cad_metatag','id_metatag','id_metatag');
        		
        		// SE FUNCIONASSE O JOIN + 1 TB NAO NECESSITARIA DE CALLBACK
        		//$crud->join_table('cad_pagina_utm','id_pagina','id_pagina');
        		
        	    $stateInfo = $crud->getStateInfo();
        	    $pk = $stateInfo->primary_key??0;
        	    
        	    //$id_cadastro = $this->conversao_model->get_empresa($pk)->id_cadastro??0;
                
                //$crud->set_rules('email', "'E-mail'", 'trim|valid_email');
                
        		//$crud->required_fields('nome','email', 'nome_empresa','telefone');
        		
                /*$crud->callback_add_field('login_email',array($this,'field_add_login_email'));
                $crud->callback_add_field('estado_civil',array($this,'add_field_estado_civil'));
                $crud->callback_add_field('sexo',array($this,'add_field_sexo'));
                $crud->callback_add_field('senha',array($this,'formata_password1'));
                $crud->callback_add_field('conf_senha',array($this,'formata_passconf1'));
                
                $crud->callback_edit_field('sexo',array($this,'edit_field_sexo'));
                $crud->callback_edit_field('estado_civil',array($this,'edit_field_estado_civil'));
                $crud->callback_edit_field('login_email',array($this,'field_edit_login_email'));
        		$crud->callback_edit_field('senha',array($this,'formata_password'));
        		$crud->callback_edit_field('conf_senha',array($this,'formata_passconf'));*/
        		
        		$crud->callback_field('status',array($this,'trata_status_callback'));
        		$crud->field_type('posicao','dropdown', array('Head'=>'Head', 'Body'=>'Body', 'Footer'=>'Footer'));
        		
                if($state == 'add' || $state == 'insert' || $state == 'insert_validation')
                {
            		$crud->field_type('data_hora_cadastro', 'hidden', date('Y-m-d H:i:s'));
            		$crud->field_type('historico', 'hidden', json_encode(['inserido_por'=>$this->session->user_id]));
                }
                
                if($state == 'edit' || $state == 'update' || $state == 'update_validation')
                {
                    $this->utm = $this->conversao_model->get_utm($pk);
                    $crud->callback_edit_field('utm_source', function ($value, $primary_key) { $source = $this->utm->utm_source??'';
                        return '<input type="text" value="'.$source.'" name="utm_source" class="form-control">';
                    });
                    $crud->callback_edit_field('utm_medium', function ($value, $primary_key) { $medium = $this->utm->utm_medium??'';
                        return '<input type="text" value="'.$medium.'" name="utm_medium" class="form-control">';
                    });
                    $crud->callback_edit_field('utm_campaign', function ($value, $primary_key) { $campaign = $this->utm->utm_campaign??'';
                        return '<input type="text" value="'.$campaign.'" name="utm_campaign" class="form-control">';
                    });
                }
                
        		$crud->field_type('ultima_atualizacao', 'hidden', date('Y-m-d H:i:s'));
        		$crud->field_type('script', 'text');
                
                $crud->callback_before_insert(array($this,'before_insert')); 
                $crud->callback_after_insert(array($this,'after_insert')); 
                
                $crud->callback_before_update(array($this,'before_update'));
                
        		//$crud->callback_delete(array($this,'callback_before_delete'));
        		
        		Assets::add_css('plugins/select2-4.0.6/select2.min');
        		
        		Assets::add_js(array(
        		    'plugins/inputmask.3.3.11/inputmask-lib',
        			'plugins/select2-4.0.6/select2.full.min',
        			'plugins/select2-4.0.6/select2.config'
        		));
        	
        	    Assets::add_module_css('conversao','pagina');
        	
        	    Assets::add_module_js('conversao',array('pagina','modal_add')); // 'mascaras',
        	    
        	    //$this->load_modal_iframe();
        		
        		$output = $crud->render();
        		
        		$this->_example_output($output);
			}
	
		}catch(Exception $e){
			show_error($e->getMessage().' --- '.$e->getTraceAsString());
		}
	}
	
	function trata_status_callback($value = '', $primary_key = null)
    {
        $status = [0=>'Aguardando Informações',1=>'Solicitado',2=>'Em Desenvolvimento',3=>'Em Homologação',4=>'Publicado',5=>'Despublicado'];
        
        $return = "<select id='field-status' name='status' class='chosen-select' data-placeholder='Selecione um Status' style='width: 300px;'>";
		$return .= "<option value=''></option>";
		foreach($status as $key=>$statu)
		{
		    $selected = '';
		    if((empty($value) && $key == 0) || (!empty($value) && $value == $statu)) $selected = 'selected="selected"';
			$return .= "<option value='$key' $selected>$statu</option>";
		}

	    $return .= "</select>";
        
        return $return;
    }
	
	
	
	private function load_modal_iframe()
	{
	    $data['modal'] = Template::get('modal');
        $fields = array(
            array(
                'name' => 'cadastro',
                'display' => 'Cadastro PF',
                'iframe' => 'conversao/cadastro/add_modal_default/index/add',
            )
        );
        
        foreach($fields as $key=>$field)
        {
	        Template::load_view('modal/modal_add', $field, '', '', $data['modal'][]);
        }
        
        Template::set($data);
	}
	
	/*function add_field_estado_civil()
	{    
        $html = '<select id="field-estado_civil" name="estado_civil" size="8" class="chosen-select" data-placeholder="Selecione Estado Civil" style="100%">';
        $html .= "<option value='Solteiro(a)'>Solteiro(a)</option>";
        $html .= "<option value='Casado(a)'>Casado(a)</option>";
        $html .= "<option value='Divorciado(a)'>Divorciado(a)</option>";
        $html .= "<option value='Viúvo(a)'>Viúvo(a)</option>";
        $html .= "</select>";
        
        return $html;
	}
	
	function edit_field_estado_civil($value, $primary_key)
	{    
        $html = '<select id="field-estado_civil" name="estado_civil" size="8" class="chosen-select" data-placeholder="Selecione Estado Civil" style="100%">';
        $selected = $value=="Solteiro"?"selected='selected'":"";
        $html .= "<option value='Solteiro(a)' ".$selected." >Solteiro(a)</option>";
        $selected = $value=="Casado(a)"?"selected='selected'":"";
        $html .= "<option value='Casado(a)' ".$selected.">Casado(a)</option>";
        $selected = $value=="Divorciado(a)"?"selected='selected'":"";
        $html .= "<option value='Divorciado(a)' ".$selected.">Divorciado(a)</option>";
        $selected = $value=="Viúvo(a)"?"selected='selected'":"";
        $html .= "<option value='Viúvo(a)' ".$selected.">Viúvo(a)</option>";
        $html .= "</select>";
        
        return $html;
	}
	
	function add_field_sexo()
	{    
        $html = '<select id="field-sexo" name="sexo" size="8" class="chosen-select" data-placeholder="Selecione Sexo">';
        $html .= "<option value='Masculino'>Masculino</option>";
        $html .= "<option value='Feminino'>Feminino</option>";
        $html .= "<option value='Outro'>Outro</option>";
        $html .= "</select>";
        
        return $html;
	}
	
	function edit_field_sexo($value, $primary_key)
	{    
        $html = '<select id="field-sexo" name="sexo" size="8" class="chosen-select" data-placeholder="Selecione Sexo">';
        $selected = $value=="Masculino"?"selected='selected'":"";
        $html .= "<option value='Masculino' ".$selected.">Masculino</option>";
        $selected = $value=="Feminino"?"selected='selected'":"";
        $html .= "<option value='Feminino' ".$selected.">Feminino</option>";
        $selected = $value=="Outro"?"selected='selected'":"";
        $html .= "<option value='Outro' ".$selected.">Outro</option>";
        $html .= "</select>";
        
        return $html;
	}
	
	function formata_password1()
	{
	    return '<input class="form-control" type="password" value="" name="senha" >';
	}
	
	function formata_passconf1()
	{
	    return '<input class="form-control" type="password" value="" name="conf_senha" >';
	}
	
	function field_add_login_email()
    {
        return '<input id="field-add-login_email" class="form-control" type="text" value="" name="login_email" readonly="readonly">';
    }
    
	function field_edit_login_email($value, $primary_key)
    {
        return '<input id="field-edit-login_email" class="form-control" type="text" value="'.$value.'" name="login_email" readonly="readonly">';
    }
    
    function formata_password($value, $primary_key)
	{
	    return '<input class="form-control" type="password" value="xxxxxx" name="senha" onBlur="password_blur(this)" onFocus="password_focus(this)" >';
	}
	
	function formata_passconf($value, $primary_key)
	{
	    return '<input class="form-control" type="password" value="xxxxxx" name="conf_senha" onBlur="password_blur(this)" onFocus="password_focus(this)" >';
	}
	
	public function valida_email($email,$id_cadastro)
	{
       if($this->conversao_model->check_email_is_unique($email,$id_cadastro))
       {
            return TRUE;
       }
       else
       {
            $this->form_validation->set_message('valida_email','E-mail já cadastrado! Informe outro e-mail.');
            return FALSE;
       }
	}*/
	
	public function before_insert($post_array) 
	{
	    //unset($post_array['keywords']);
	    
	    // insert utm's
	    $this->set_session_utm($post_array);
	    
	    // insert sys_users
	    $this->set_session_script($post_array);
	    
	    //$this->trata_dados_agencia($post_array);
	    
	    return $post_array;
    }
    
    public function after_insert($post_array,$primary_key) 
	{
	    // insert cad_pagina_utm
	    $this->insert_utm($primary_key);
	    
	    // insert cad_pagina_scripts
	    $this->insert_scripts($primary_key);
	    
	    return $post_array;
    }
    
    private function insert_utm($primary_key)
    {
        $utm = $this->session->utm;
        
        if(is_array($utm) && count($utm) == 3)
        {
            $utm['id_pagina'] = $primary_key;
            $utm['historico'] = json_encode(['inserido_por'=>$this->session->user_id]);
            $this->conversao_model->insert_utm($utm);
            $this->session->unset_userdata('utm');
        }
    }
    
    private function insert_scripts($primary_key)
    {
        $scripts = $this->session->scripts;
        
        if(is_array($scripts) && count($scripts) == 3)
        {
            $this->insert_script($scripts,$primary_key);
        }
    }
    
    private function insert_script($scripts,$primary_key)
    {
        if(empty($scripts))
            return;
            
        //dd($scripts);
            
        for($i=0;$i<count($scripts['nomes']);$i++)
        {
            //var_dump($scripts['nomes']);
            //var_dump($scripts['nomes'][$i],$scripts['posicoes'][$i],$scripts['scripts'][$i]);
            
            $data = [];
            
            $data['id_pagina'] = $primary_key;
            $data['historico'] = json_encode(['inserido_por'=>$this->session->user_id]);
            $data['data_hora_cadastro'] = date('Y-m-d H:i:s');
            $data['nome'] = $scripts['nomes'][$i];
            $data['posicao'] = $scripts['posicoes'][$i];
            $data['script'] = $scripts['scripts'][$i];
            
            $this->conversao_model->insert_scripts($data);
        }
        
        $this->session->unset_userdata('scripts');
    }
    
    private function set_session_utm(&$post_array)
    {
        $session_utm = [
            'utm_source'=>$post_array['utm_source'],
            'utm_medium'=>$post_array['utm_medium'],
            'utm_campaign'=>$post_array['utm_campaign']
        ];
        
        $this->session->set_userdata('utm',$session_utm);
        
        unset($post_array['utm_source']);
        unset($post_array['utm_medium']);
        unset($post_array['utm_campaign']);
    }
    
    private function set_session_script(&$post_array)
    {
        $session_script = [
            'nomes'=>$post_array['nome_script'],
            'posicoes'=>$post_array['posicao'],
            'scripts'=>$post_array['script']
        ];
        
        $this->session->set_userdata('scripts',$session_script);
        
        unset($post_array['nome_script']);
        unset($post_array['posicao']);
        unset($post_array['script']);
    }
    
    /*public function trata_dados_agencia(&$post_array)
    {
	    $post_array['nome']      = $post_array['nome_empresa'];
	    $post_array['email']     = $post_array['email_empresa'];
	    $post_array['telefone']  = $post_array['telefone_empresa'];
	    
	    unset($post_array['nome_empresa'],$post_array['email_empresa'],$post_array['telefone_empresa']);
	    
        return $post_array;
    }*/
    
    /*private function create_new_cadastro(&$post_array)
    {
        $insert_cadastro = array(
            'nome' => $post_array['nome'],
            'telefone' => $post_array['telefone'],
            'email' => $post_array['email'],
            'data_nascimento' => $post_array['data_nascimento'],
            'estado_civil' => $post_array['estado_civil'],
            'cpf' => $post_array['cpf'],
            'rg' => $post_array['rg'],
            'orgao_exp' => $post_array['orgao_exp'],
            'data_exp' => $post_array['data_exp'],
            'sexo' => $post_array['sexo'],
            'naturalidade' => $post_array['naturalidade'],
            'nacionalidade' => $post_array['nacionalidade'],
            'profissao' => $post_array['profissao'],
            //'img_perfil' => $post_array[''],
            'end_cep' => $post_array['end_cep'],
            'end_endereco' => $post_array['end_endereco'],
            'end_numero' => $post_array['end_numero'],
            'end_complemento' => $post_array['end_complemento'],
            'end_bairro' => $post_array['end_bairro'],
            'end_cidade' => $post_array['end_cidade'],
            'end_estado' => $post_array['end_estado'],
            'facebook' => $post_array['facebook'],
            'instagram' => $post_array['instagram'],
            'linkedin' => $post_array['linkedin'],
            'aceita_termos' => 1,
            'status' => 1,
            'data_hora_cadastro' => date('Y-m-d H:i:s'),
            'ultima_atualizacao' => date('Y-m-d H:i:s'),
            'historico' => json_encode(['inserido_por'=>$this->session->user_id])
        );
        
        foreach ($insert_cadastro as $key=>$insert_cad)
        {
            if(!in_array($key,['nome','email']))    
                unset($post_array[$key]);
        }
        
        $id_cadastro = $this->conversao_model->create_cadastro($insert_cadastro);
        
        $post_array['id_cadastro'] = $id_cadastro;
        
        return $post_array;
        
    }*/
    
    /*private function create_new_user(&$post_array)
    {
        $hasher = new PasswordHash(
    		$this->config->item('phpass_hash_strength', 'tank_auth'),
    		$this->config->item('phpass_hash_portable', 'tank_auth')
		);
		$post_array['senha'] = $hasher->HashPassword($post_array['senha']);
	    
	    $insert_user = array(
	        'id_cadastro' => $post_array['id_cadastro'],
    	    'perfil' => 3, // perfil de agencia
    	    'nome' => $post_array['nome'],
    	    'password' => $post_array['senha'],
    	    'email' => $post_array['email'],
    	    'activated' => 1,
        );
        
        //unset($post_array['perfil']);
        unset($post_array['nome']);
        unset($post_array['senha']);
        unset($post_array['email']);
        unset($post_array['conf_senha']);
        unset($post_array['login_email']);
        
        $user_id = $this->conversao_model->create_user($insert_user);
        
        return $post_array;
    }*/
    
    function before_update($post_array, $primary_key)
	{
	    $this->update_utm($post_array, $primary_key);
	    /*$this->update_cadastro($post_array, $primary_key);
	    
	    $this->update_user($post_array, $primary_key);
		
		$this->trata_dados_agencia($post_array);*/
	    
	    return $post_array;
	}
	
	private function update_utm(&$post_array,$id_pagina)
	{
	    $utm = [
            'utm_source'=>$post_array['utm_source'],
            'utm_medium'=>$post_array['utm_medium'],
            'utm_campaign'=>$post_array['utm_campaign']
        ];
        
        $this->conversao_model->update_utm_by_id_pagina($id_pagina,$utm);
        
        unset($post_array['utm_source']);
        unset($post_array['utm_medium']);
        unset($post_array['utm_campaign']);
	}
	
	/*private function update_cadastro(&$post_array,$primary_key)
    {
        $update_cadastro = array(
            'nome' => $post_array['nome'],
            'telefone' => $post_array['telefone'],
            'email' => $post_array['email'],
            'data_nascimento' => $post_array['data_nascimento'],
            'estado_civil' => $post_array['estado_civil'],
            'cpf' => $post_array['cpf'],
            'rg' => $post_array['rg'],
            'orgao_exp' => $post_array['orgao_exp'],
            'data_exp' => $post_array['data_exp'],
            'sexo' => $post_array['sexo'],
            'naturalidade' => $post_array['naturalidade'],
            'nacionalidade' => $post_array['nacionalidade'],
            'profissao' => $post_array['profissao'],
            //'img_perfil' => $post_array[''],
            'end_cep' => $post_array['end_cep'],
            'end_endereco' => $post_array['end_endereco'],
            'end_numero' => $post_array['end_numero'],
            'end_complemento' => $post_array['end_complemento'],
            'end_bairro' => $post_array['end_bairro'],
            'end_cidade' => $post_array['end_cidade'],
            'end_estado' => $post_array['end_estado'],
            'facebook' => $post_array['facebook'],
            'instagram' => $post_array['instagram'],
            'linkedin' => $post_array['linkedin'],
            'aceita_termos' => 1,
            'status' => 1,
            'ultima_atualizacao' => date('Y-m-d H:i:s'),
            'historico' => json_encode(['inserido_por'=>$this->session->user_id])
        );
        
        foreach ($update_cadastro as $key=>$update_cad)
        {
            if(!in_array($key,['nome','email']))    
                unset($post_array[$key]);
        }
        
        $empresa = $this->conversao_model->get_empresa($primary_key);
        
        $this->conversao_model->update_cadastro($empresa->id_cadastro,$update_cadastro);
        
        $post_array['id_cadastro'] = $empresa->id_cadastro;
        
        return $post_array;
        
    }
	
	protected function update_user(&$post_array, $primary_key)
	{
	    $update_user = array(
    	    'nome' => $post_array['nome'],
    	    'email' => $post_array['email'],
        );
        
	    if($post_array['senha'] != "xxxxxx" )
	    {   
	    	// Hash password using phpass
			$hasher = new PasswordHash(
					$this->config->item('phpass_hash_strength', 'tank_auth'),
					$this->config->item('phpass_hash_portable', 'tank_auth'));
			$update_user['password'] = $hasher->HashPassword($post_array['senha']);
	    }	    
        
        //unset($post_array['perfil']);
        unset($post_array['nome']);
        unset($post_array['senha']);
        unset($post_array['email']);
        unset($post_array['conf_senha']);
        unset($post_array['login_email']);
        
        $empresa = $this->conversao_model->get_empresa($primary_key);
        
        $user_id = $this->conversao_model->update_user($empresa->id_cadastro,$update_user);
	    
	    return $post_array;
	}*/
	
	//id_cadastro	uuid_cadastro	nome	telefone	email	cpf	rg	orgao_exp	
	//data_exp	sexo	nacionalidade	naturalidade	estado_civil	data_nascimento	
	//profissao	img_perfil	end_cep	end_endereco	end_numero	end_complemento	end_bairro	
	//end_cidade	end_estado	facebook	instagram	linkedin	push_alertjson	aceita_termos	
	//data_hora_cadastro	ultima_atualizacao	historico
	
	//agencia 0-empresa/1-agencia	uuid_empresa	uuid_cadastro
    //	nome_empresa	cnpj	telefone	email	site	status 0-inativa/1-ativa	
    //data_hora_cadastro	ultima_atualizacao	historico	

	
	public function callback_before_delete($primary_key)
    {
        $this->db->set('status','Inativo');
        $this->db->set('status',0);
        $this->db->where('id_cad_forn',$primary_key);
        $this->db->update('cad_empresa');
        return true;
    }
}