<?php

class Newsletter_model extends CI_Model
{
    
    private $tb_emais = 'nwl_emails';
    
    private $tb_campanha = 'nwl_campanha_email';
    
    private $tb_config_campanha = 'nwl_config_campanha';
    
    private $tb_log_email = 'nwl_log_emails';
    
    private $tb_desinscricao = 'nwl_desinscricao';
    
    private $tb_local_cadastro = 'nwl_local_cadastro';
    
    function verifica_log_email($email, $id_campanha) 
    {
        $this->db->where('email', $email);
        $this->db->where('id_campanha', $id_campanha);
        $this->db->where('enviado', 1);
        $query = $this->db->get($this->tb_log_email);
        
        if ($query->num_rows() > 0) 
        {
            return true;
        }
        else
        {
            return false;
        }
    }
    function get_email($id) 
    {
        $this->db->where('id', $id);
        $query = $this->db->get($this->tb_emais);
        
        if ($query->num_rows() == 1) return $query->row();
        return null;
    }
    function get_email_by_email($email) 
    {
        $this->db->where('email', $email);
        $query = $this->db->get($this->tb_emais);
        
        if ($query->num_rows() == 1) return $query->row();
        return null;
    }
    
    function get_campanha($id) 
    {
        $this->db->where('id_campanha', $id);
        $query = $this->db->get($this->tb_campanha);
        
        if ($query->num_rows() == 1) return $query->row();
        return null;
    }
    
    function get_campanha_uuid($uuid) 
    {
        $this->db->where('UUID', $uuid);
        $query = $this->db->get($this->tb_campanha);
        
        if ($query->num_rows() == 1) return $query->row();
        return null;
    }
    
    
    function get_campanhas($fields = '') 
    {
        if($fields != '')
            $this->db->select($fields);
        
        $query = $this->db->get($this->tb_campanha);
        
        if ($query->num_rows() > 1) return $query->result();
        return [];
    }
    function get_config_campanha($id_config = 1) 
    {
        $this->db->where('id', $id_config);
        $query = $this->db->get($this->tb_config_campanha);
        
        if ($query->num_rows() == 1) return $query->row();
        return null;
    }
    function insere_log($data) 
    {
        
        if ($this->db->insert($this->tb_log_email, $data)) return $this->db->insert_id();
        return NULL;
    }
    function enviou_campanha($id) 
    {
        $sql = "UPDATE `$this->tb_campanha` SET enviados = enviados + 1  WHERE `id_campanha` = $id";
        return $this->db->query($sql);
    }
    function falhou_campanha($id) 
    {
        $sql = "UPDATE `$this->tb_campanha` SET falhou = falhou + 1  WHERE `id_campanha` = $id";
        return $this->db->query($sql);
    }
    function abriu_email_campanha($key) 
    {
        $row = $this->confirma_email_campanha($key);
        
        if ($row !== NULL && $row->abriu == 0) 
        {
            $dados = array(
                'abriu' => 1,
                'abriu_em' => date('Y-m-d H:i:s')
            );
            $this->db->where('key_log', $key);
            $this->db->update($this->tb_log_email, $dados);
            $this->db->query("UPDATE `$this->tb_campanha` SET abertos = abertos + 1  WHERE `id_campanha` = $row->id_campanha");
        }
        return $row;
    }
    function confirma_email_campanha($key) 
    {
        $this->db->where('key_log', $key);
        //$this->db->where($status,0);*/
        $query = $this->db->get($this->tb_log_email);
        
        if ($query->num_rows() === 1) 
        {
            return $query->row();
        }
        else
        {
            return NULL;
        }
    }
    function clicou_email_campanha($key) 
    {
        $result = $this->confirma_email_campanha($key);
        
        if ($result !== NULL) 
        {
            $id = $result->id_campanha;
            /*$dados = array('clicou' => 1);
            $this->db->where('key_log', $key);            
            $this->db->update($this->tb_log_email, $dados);             
            */
            $this->db->query("UPDATE `$this->tb_log_email` SET clicou = clicou + 1  WHERE `key_log` = '$key'");
            
            if ($result->clicou == 0) 
            {
                $this->db->query("UPDATE `$this->tb_campanha` SET clicados = clicados + 1  WHERE `id_campanha` = $id");
            }
        }
        return $result;
    }
    function clicou_email_campanha_site($key) 
    {
        $result = $this->confirma_email_campanha($key);
        if ($result !== NULL) 
        {
            $id = $result->id_campanha;
            $this->db->query("UPDATE `$this->tb_log_email` SET clicou_site = clicou_site + 1  WHERE `key_log` = '$key'");
            if ($result->clicou_site == 0) 
            {
                $this->db->query("UPDATE `$this->tb_campanha` SET clicou_site = clicou_site + 1  WHERE `id_campanha` = $id");
            }
        }
        return $result;
    } 
    
    function insert_historico_clique($id, $historico)
    {
        $this->db->where('id',$id);
        $this->db->update($this->tb_log_email, array('historico_clique' => $historico));
    }
    
    //cadencia
    
    function getTag($where = [])
	{
	    $this->where($where);
	    $query = $this->db->get('nwl_tags');
        if ($query->num_rows() > 0)
            return $query->row();
        return null;
	}
    
    
    function getSequencias($where = [])
	{
	    $this->where($where,[]);
	    $query = $this->db->get('nwl_sequencia');
        if ($query->num_rows() > 0)
            return $query->result();
        return [];
	}
	function getCapByTag($where = [])
	{
	    $this->db->select('*, a.email as email, a.nome as nome');
	    $this->where($where,[]);
	    $this->db->join('cad_captura as a', 'a.id_captura = b.id_captura');//,'left');
	    $this->db->join('cad_cadastro as c', 'a.id_cadastro = c.id_cadastro','left');
	    $query = $this->db->get('nwl_tags_rel as b');
	    
        if ($query->num_rows() > 0)
            return $query->result();
        return [];
	}
	
	
	function getCapByTagSemCad($where = [])
	{
	    
	    $this->where($where,[]);
	    //$this->where_not_in('a.email');
	    $this->db->join('cad_captura as a', 'a.id_captura = b.id_captura','left');
	    $this->db->join('cad_cadastro as c', 'a.email = c.email','left');
	    
	    $query = $this->db->get('nwl_tags_rel as b');
	    
        if ($query->num_rows() > 0)
            return $query->result();
        return [];
	}
	
	function insere_tag_captura($data) 
    {
        return $this->db->insert('nwl_tags_rel', $data);
    }
    
    function insere_tag_historico($data) 
    {
        return $this->db->insert('nwl_tags_historico', $data);
    }
    
    function delete_tag_captura($where = [])
    {
        if(empty($where))
            return FALSE;
        
        $this->where($where,[]);
	    return $this->db->delete('nwl_tags_rel');
	    
    }
    
    /*####################### INSERT #######################################################*/
    function insere_news_email($data) 
    {
        $data['criado_em'] = date('Y-m-d H:i:s');
        
        if ($this->db->insert($this->tb_emais, $data)) 
        {
            return $this->db->insert_id();
        }
        else
        {
            return NULL;
        }
    }
    function insere_desinscricao($data) 
    {
        return $this->db->insert($this->tb_desinscricao, $data);
    }
    function insert_local_cadastro($data_location) 
    {
        return $this->db->insert($this->tb_local_cadastro, $data_location);
    } 
    
    
    
    
    
    /*####################### SELECT #######################################################*/
    function confirma_email_campanha_abriu($key, $status) 
    {
        $this->db->where('key_log', $key);
        $this->db->where($status, 0);
        $query = $this->db->get($this->tb_log_email);
        
        if ($query->num_rows() === 1) 
        {
            $r = $query->row();
            return $r->id_campanha;
        }
        else
        {
            return NULL;
        }
    }
    
    function verifica_desinscricao($email) 
    {
        $this->db->where('email', $email);
        $this->db->where('status', 2);
        $this->db->group_by('email');
        $query = $this->db->get($this->tb_emais);
        
        if ($query->num_rows() == 1) 
        {
            return true;
        }
        else
        {
            return false;
        }
    }
    
    function confirma_email($email) 
    {
        $this->db->where('id_anunciante', '0');
        $this->db->where('email', $email);
        $query = $this->db->get($this->tb_emais);
        
        if ($query->num_rows() === 1) 
        {
            return $query->row();
        }
        else
        {
            return NULL;
        }
    }
    function select_emails_expired($datetime) 
    {
        $this->db->where('criado_em <', $datetime);
        $this->db->where('status', 0);
        $this->db->where('conf_1', 1);
        $this->db->where('conf_2', 0);
        $query = $this->db->get($this->tb_emais);
        
        if ($query->num_rows() > 0) 
        {
            return $query->result_array();
        }
        else
        {
            return NULL;
        }
    }
    function activate_email_cadastro($key, $dados = null) 
    {
        $this->db->where('CONCAT(`id`,`activation_key`)', $key);
        /*$this->db->where('status', 0);*/
        $query = $this->db->get($this->tb_emais);
        
        if ($query->num_rows() == 1) 
        {
            $dados['ativado_em'] = date('Y-m-d H:i:s');
            $dados['status'] = 1;
            return $this->alterar_status($key, $dados);
        }
        else
        {
            return FALSE;
        }
    }
    function desativa_email_cadastro($key) 
    {
        $this->db->where('CONCAT(`id`,`activation_key`)', $key);
        /*$this->db->where('status', 0);*/
        $query = $this->db->get($this->tb_emais);
        
        if ($query->num_rows() == 1) 
        {
            $data['desativado_em'] = date('Y-m-d H:i:s');
            $data['status'] = 2;
            return $this->alterar_status($key, $data);
        }
        else
        {
            return FALSE;
        }
    }
    
    function desativa_email($email)
    {
        $data['desativado_em'] = date('Y-m-d H:i:s');
        $data['status'] = 2;
        $this->db->where('email', $email);
        return $this->db->update($this->tb_emais, $data);
    }
    
    
    function verifica_cadastro($key) 
    {
        $this->db->where('CONCAT(`id`,`activation_key`)', $key);
        $query = $this->db->get($this->tb_emais);
        
        if ($query->num_rows() == 1) 
        {
            $result = $query->row();
            return $result->status;
        }
        else
        {
            return null;
        }
    }
    function select_email_by_activation_key($activation_key) 
    {
        $this->db->where('activation_key', $activation_key);
        $this->db->join('qi_cadastro', 'qi_cadastro.id_cadastro = nwl_emails.id_anunciante');
        $query = $this->db->get('nwl_emails');
        
        if ($query->num_rows() > 0) 
        {
            return $query->row();
        }
        else
        {
            return NULL;
        }
    }
    function confirma_key($key) 
    {
        $this->db->where('CONCAT(`id`,`activation_key`)', $key);
        $query = $this->db->get($this->tb_emais);
        
        if ($query->num_rows() === 1) 
        {
            $result = $query->row();
            return $result->id;
        }
        else
        {
            return NULL;
        }
    }
    function get_email_key_concat($key) 
    {
        $this->db->where('CONCAT(`id`,`activation_key`)', $key);
        $query = $this->db->get($this->tb_emais);
        
        if ($query->num_rows() === 1) 
        {
            $result = $query->row();
            return $result;
        }
        else
        {
            return NULL;
        }
    }
    function confirma_email_1($key) 
    {
        $this->db->where('CONCAT(`id`,`activation_key`)', $key);
        $this->db->where('status', 0);
        $this->db->where('conf_1', 1);
        $this->db->where('abriu_conf_1', '0000-00-00 00:00:00');
        $query = $this->db->get($this->tb_emais);
        
        if ($query->num_rows() === 1) 
        {
            $result = $query->row();
            return $result->id;
        }
        else
        {
            return NULL;
        }
    }
    function confirma_email_2($key) 
    {
        $this->db->where('CONCAT(`id`,`activation_key`)', $key);
        $this->db->where('status', 0);
        $this->db->where('conf_1', 1);
        $this->db->where('conf_2', 1);
        $this->db->where('abriu_conf_2', '0000-00-00 00:00:00');
        $query = $this->db->get($this->tb_emais);
        
        if ($query->num_rows() === 1) 
        {
            $result = $query->row();
            return $result->id;
        }
        else
        {
            return NULL;
        }
    }
    function select_log_email($key) 
    {
        $this->db->where('key_log', $key);
        $this->db->order_by('id', 'DESC');
        $query = $this->db->get($this->tb_log_email);
        
        if ($query->num_rows() > 0) 
        {
            return $query->row();
        }
        else
        {
            return NULL;
        }
    }
    function listar_leads() 
    {
        $this->db->where('origem', 'soon');
        $this->db->where('status', 0);
        $query = $this->db->get($this->tb_emais);
        
        if ($query->num_rows() > 0) 
        {
            return $query->result();
        }
        else
        {
            return NULL;
        }
    } 
    
    /*####################### update #######################################################*/
    function adicionou_membro($id) 
    {
        $dados = array(
            'mailchimp' => 1
        );
        $this->db->where('id', $id);
        return $this->db->update($this->tb_emais, $dados);
    }
    function deletou_membro($id) 
    {
        $dados = array(
            'mailchimp' => 0
        );
        $this->db->where('id', $id);
        return $this->db->update($this->tb_emais, $dados);
    }
    function update_tb_emails($key, $dados) 
    {
        $this->db->where('activation_key', $key);
        return $this->db->update($this->tb_emais, $dados);
    }
    function alterar_status($key, $dados) 
    {
        $this->db->where('CONCAT(`id`,`activation_key`)', $key);
        return $this->db->update($this->tb_emais, $dados);
    }
    function reenviou_email_conf($id) 
    {
        $sql = "UPDATE `$this->tb_emais` SET reenvio = reenvio + 1  WHERE `id` = $id";
        return $this->db->query($sql);
    }
    function enviou_email_1($id) 
    {
        $dados = array(
            'conf_1' => 1
        );
        $this->db->where('id', $id);
        return $this->db->update($this->tb_emais, $dados);
    }
    function enviou_email_2($id) 
    {
        $dados = array(
            'conf_2' => 1
        );
        $this->db->where('id', $id);
        return $this->db->update($this->tb_emais, $dados);
    }
    function abriu_email_1($key) 
    {
        $id = $this->confirma_email_1($key);
        
        if ($id !== NULL) 
        {
            $dados = array(
                'abriu_conf_1' => date('Y-m-d H:i:s')
            );
            $this->db->where('id', $id);
            $this->db->update($this->tb_emais, $dados);
        }
    }
    function abriu_email_2($key) 
    {
        $id = $this->confirma_email_2($key);
        
        if ($id !== NULL) 
        {
            $dados = array(
                'abriu_conf_2' => date('Y-m-d H:i:s')
            );
            $this->db->where('id', $id);
            $this->db->update($this->tb_emais, $dados);
        }
    }
    function clicou_email_conf_maps($key) 
    {
        $this->db->query("UPDATE `$this->tb_emais` SET clicou_maps = clicou_maps + 1  WHERE CONCAT(`id`,`activation_key`) = '$key'");
    } 
    
    //############  funcoes suporte ##########
    
    
    function order_by($order_by)
    {
        foreach($order_by as $key=>$dado)
        {
            $this->db->order_by($key, $dado);
        }
    }
    
    function like($like, $or_like)
    {
        $this->roda_like($like);
        $this->roda_or_like($or_like);
    }
    
    function roda_like($like)
    {
        foreach($like as $dado)
        {
            $this->db->like($dado[0], $dado[1]);
        }
    }
    
    function roda_or_like($like)
    {
       if(!empty($like))
        {
            $this->db->group_start();
            foreach($like as $dado)
            {
                $this->db->or_like($dado[0], $dado[1]);
            }
            $this->db->group_end();
        }
    }
    
    function where($where, $or_where = [])
    {
        $this->roda_where($where);
        
        $this->roda_or_where($or_where);
    }
    
    function roda_where($where)
    {
        foreach($where as $dado)
        {
            if(is_array($dado[0]))
            {
                $this->db->group_start();
                foreach($dado as $dado_n)
                {
                    if(is_array($dado_n[0]))
                    {
                        $this->db->or_group_start();
                        foreach($dado_n as $dado_y)
                        {
                            $this->db->where($dado_y[0], $dado_y[1]);
                        }
                        $this->db->group_end();
                    }
                    else
                    {
                        $this->db->or_where($dado_n[0], $dado_n[1]);
                    }
                }
                $this->db->group_end();
            }
            else
            {
                $this->db->where($dado[0], $dado[1]);
            }
        }
    }
    
    function roda_or_where($where)
    {
       if(!empty($where))
        {
            $this->db->group_start();
            foreach($where as $dado)
            {
                $this->db->or_where($dado[0], $dado[1]);
            }
            $this->db->group_end();
        }
    }
    
    
    /* pmdb ###############################################################*/
    
    private $tb = array(
        'tb_municipio',
        /* 0			'tb_municipio_composicao',*/
        /* 1					'tb_municipio_import',*/
        /* 2			'tb_municipio_bk',*/
        /* 3			'tb_ex_pres_municipais_log'*/
        /* 4	*/
        );
        function lista_municipios_pmdb() 
        {
            $this->db->select('*');
            $this->db->order_by('id_municipio', 'ASC');
            $query = $this->db->get($this->tb[0]);
            
            if ($query->num_rows() > 0) return $query->result();
            return NULL;
        }
        function lista_composicao_municipio($id_municipio) 
        {
            $this->db->where('id_municipio', $id_municipio);
            $query = $this->db->get($this->tb[1]);
            
            if ($query->num_rows() > 0) return $query->result();
            return NULL;
        }
    }