<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

include 'Pagina.php';

class Modelo extends Pagina {

	function __construct()
	{
		parent::__construct();
		$this->load->model('conversao/conversao_model');
	}
	
	public function index($id_pagina = 1)
	{
	    $proxy = $this->checaProxy();
       
        //$data['pagina'] = $pagina = $this->conversao_model->getPagina([['id_pagina',$id_pagina]]);
        //$id_emp = $pagina->id_empresa;
        $id_mod = 1;
        $id_camp = 1;
	    
	    if($proxy == FALSE){
	        $this->config->set_item('base_site', base_url());
	        $link = base_url(uri_string().'/');
	    }
	    else{
	        $this->config->set_item('base_site', 'https://conversao.viewbrasil.com.br/');
	        $link = base_site('pagina/'.$id_pagina);
	    }
	    $data['link'] = $link;
	    //$this->set_origem_utm($empresa, $link);
        
        $pagina_utm   = $this->input->get('utm_medium', TRUE);
        $page         = substr($pagina_utm, -1);
        $pagina_view  = 'page_a';
        if($pagina_utm !== NULL)
            $pagina_view = 'page_'.$page;
        
        if($this->check_file_exists($id_mod,$page) == FALSE)
            $pagina_view  = 'page_a';
            
        Assets::add_module_css('pagina', array(
            "mods/mod_$id_mod/theme",
            "mods/mod_$id_mod/page_a",
        ));
        Assets::add_css(array(
        ));
        Assets::add_js(array(
            'plugins/inputmask/inputmask',
            'plugins/inputmask/mascaras',
        ));
        
        // força o método ser sempre index para gerar css e js único
        $this->router->method = $pagina_view;
        
        if($pagina_view == 'page_e'){
            
            Assets::add_css(array(
                'plugins/fancyBox-v3.5.7/jquery.fancybox.min',
                '../conversao/plugins/justified-gallery-master/justifiedGallery.min',
            ));
            Assets::add_js(array(
                '../conversao/plugins/fancyBox-v3.5.7/jquery.fancybox.min',
                '../conversao/plugins/justified-gallery-master/justifiedGallery.min'
            ));
            Assets::add_module_js('pagina', array(
                "script_galeria",
            ));
        }
        
        Template::set_modal($data,[
            "mods/mod_1/modal/galeria",
        ]);
        
        $data['meta'] = $this->metaTags();
        $this->load_cookie($pagina_view,$pagina_view);
        
        Template::set($data);
	    Template::set_view("mods/mod_$id_mod/$pagina_view");
        Template::render();
	}
	
	public function resultado()
    {
        $id_mod = 1;
        $id_camp = 1;
        
        Assets::add_module_css('pagina', array(
            "mods/mod_$id_mod/theme",
            "mods/mod_$id_mod/page_a",
        ));
        
        $data['pixelFaceLead'] = true;
        $data['meta'] = $this->metaTags();
        
        Template::set($data);
	    Template::set_view("mods/mod_$id_mod/page_resultado");
        Template::render();
    }
	
	public function metaTags(){
	    return [
	        'keywords' => "Página de conversão, site, landingpage, página rápida, Brasília-DF",
            'site_name' => base_url(),
            'url' => base_url(),
            'title' => "Conversão - Páginas rápidas",
            'description' => "Conversão - Páginas rápidas.",
            'image' => (getenv('MEDIA_URL'))."/modules/mods/assets/images/emp/riviera/seo-riviera.jpg",
            'favicon' => (base_url()),
        ];
	}
	
	public function check_file_exists($id_mod,$page)
    {
        $path = "modules/pagina/views/mods/mod_$id_mod/page_$page.php";
        
        if(file_exists(APPPATH.$path))
            return TRUE;
        else
            return FALSE;
    }
}